package charite.christo.strap;
import charite.christo.*;
import java.io.File;
import java.util.*;
import static charite.christo.ChUtils.*;
import static charite.christo.strap.Strap.*;
#define THIS_CLASS(a) BUT_C_##SequenceAlignerImpl##_##a
#if !CPP_WITH_GUI
#define ALIAS_PRGPARAS_FURTHER
#endif //!CPP_WITH_GUI
#define _implementID '2'
/** @author Christoph Gille */
/* (highlight-regexp "\\bALIGNER_") */
#if CPP_WITH_GUI
@*H THIS_CLASS(ALIGNER_M_CLUSTALW)
 ClustalW PUBMED:18792934 http://www.clustal.org/ is a widely applied program to generate multiple sequence
 alignments automatically.
 <BR><BR><B>NT-sequence:</B>
 ClustalW treats the letters as nucleotides if 85% or more of the characters in the sequence are A,C,G,T,U or N.
*@
@*RSC_MULTI_PRGPARA THIS_CLASS(ALIGNER_M_CLUSTALW)
 ALIAS_PRGPARAS_FURTHER
 -GAPOPEN=; Gap opening penalty
 -GAPEXT=; Gap extension penalty
 -MATRIX=; Protein weight matrix=BLOSUM, PAM, GONNET, ID or filename
*@
/* ================================================================================ */
@*H THIS_CLASS(ALIGNER_M_T_COFFEE)
 Author: Cedric Notredame PUBMED:10964570
*@
@*RSC_MULTI_PRGPARA THIS_CLASS(ALIGNER_M_T_COFFEE)
 ALIAS_PRGPARAS_FURTHER
 -gapopen=;Gap open penalty
 -gapext=;Gap extension penalty
 -fgapopen=;
 -fgapext=;
*@
/* ================================================================================ */
@*H THIS_CLASS(ALIGNER_M_MUSCLE)
 <BR>Publication: PUBMED:15318951
 <BR><B>Windows-MSYS2:</B> To build the package successfully please change the file intmath.cpp:
 Move the definition of the method log2(double) to the top and rename it e.g. to Log2 (upper case).
*@
// intmath.cpp: log2(double) => Log2(double)
// PrgParas
@*RSC_MULTI_PRGPARA THIS_CLASS(ALIGNER_M_MUSCLE)
 ALIAS_PRGPARAS_FURTHER
 -maxiters; Maximum number of iterations (integer, default 16)
 -maxhours; Maximum time to iterate in hours (default no limit)
 -maxmb; Maximum memory to allocate in Mb (default 80% of RAM)
*@
/* ================================================================================ */
@*H THIS_CLASS(ALIGNER_M_KALIGN)
 Author: Timo Lassmann
 Publication: PUBMED:16343337
*@
// <timolassmann@gmail.com> lukas.kall@ki.se
@*RSC_MULTI_PRGPARA THIS_CLASS(ALIGNER_M_KALIGN)
 ALIAS_PRGPARAS_FURTHER
 --gapopen=; Gap open penalty
 --gapextension=; Gap extension penalty
 --terminal_gap_extension_penalty=; Terminal gap penalties
 --matrix_bonus=; A constant added to the substitution matrix.
*@
/* ================================================================================ */
@*H THIS_CLASS(ALIGNER_M_ALIGN_M)
 Align-m is an accurate and highly versatile multiple alignment program.
 <BR>Author: Ivo Van Walle
 <BR>http://bioinformatics.vub.ac.be/software/software.html
*@
@*RSC_MULTI_PRGPARA THIS_CLASS(ALIGNER_M_ALIGN_M)
 ALIAS_PRGPARAS_FURTHER
 -v;[x]Verbose comments during execution
 -s2p_guided_aln;[x]Substitution matrix name. For protein sequences
 -s2p_m;Width of ungapped segment to average over. Default: BLOSUM62
 -s2p_w;nsigma max. Maximum number of sigma that a new set of columns may score on average below the first one. default: 15
 -s2p_minscore;minscore. Minimum score that a new set of columns may score on average (supersedes -s2p nsigma max) .default: 0.0
 -s2p_go;Gap opening penalty for guided alignments Gap extension penalty for guided. default: 12.0
*@
/* ================================================================================ */
@*H THIS_CLASS(ALIGNER_M_DIALIGN)
 Home-page http://dialign.gobics.de/
 <BR>Author: Burkhard Morgenstern and Said Abdeddaim
 <BR>Publication: PUBMED:10222408
*@
@*RSC_MULTI_PRGPARA THIS_CLASS(ALIGNER_M_DIALIGN)
 ALIAS_PRGPARAS_FURTHER
 -afc;[x]Creates additional output file <I>*.afc</I> containing data of all fragments considered for alignment. WARNING: this file can be HUGE !
 -afc_v;[x]like <I>"-afc"</I> but verbose: fragments are explicitly printed. WARNING: this file can be EVEN BIGGER !
 -ff;[x]Creates file <I>*.frg</I> containing information about all fragments that are part of the respective optimal pairwise alignments plus information about consistency in the multiple alignment
 -fop;[x]Creates file <I>*.fop</I> containing coordinates of all fragments
 -fsm;[x]Creates file <I>*.fsm</I> containing coordinates of all fragments that are part of the final alignment
 -iw;[x]overlap weights switched off.<BR> Higher quality, less speed
 -lo;[x](Long Output) Additional file <I>*.log</I> with more information
 -mat;[x]Creates file *mat with substitution counts.
 -mat_thr;[x]Like <I>-mat</I> but only fragments with weight score
 -max_link;[x]<I>maximum linkage</I> clustering used to construct sequence tree instead of UPGMA
 -min_link;[x]minimum linkage
 -mot;[x]motif option
 -msf;[x]separate output file in MSF format
 -o;[x]fast version, resulting alignments may be slightly different
 -ow;[x]overlap weights enforced.<BR>Less quality, high speed
 -thr=;Threshold T = x
*@
/* ================================================================================ */
@*H THIS_CLASS(ALIGNER_M_AMAP)
 <B>Author:</B> A.S. Schwartz, E.W. Myers and L. Pachter
 <BR>WIKI:AMAP
*@
@*RSC_MULTI_PRGPARA THIS_CLASS(ALIGNER_M_AMAP)
 ALIAS_PRGPARAS_FURTHER
 --consistency=;use 0 <= REPS <= 5 (default: 0) passes of consistency transformation
 --iterative-refinement=;use 0 <= REPS <= 1000 (default: 100) passes of iterative-refinement
 --pre-training=;use 0 <= REPS <= 20 (default: 0) rounds of pretraining
 -pairs;[x]generate all-pairs pairwise alignments
 -viterbi;[x]use Viterbi algorithm to generate all pairs (automatically enables -pairs)
 --verbose;[x]report progress while aligning (default: off)
 -annot=;write annotation for multiple alignment to FILENAME
 --train=;compute EM transition probabilities, store in FILENAME (default: no training)
 --emissions=;also reestimate emission probabilities (default: off)
 --paramfile=;read parameters from FILENAME (default:)
 --gap-factor=;use GF as the gap-factor parameter, set to 0 for best sensitivity, higher values for better specificity (default: 0.5)
*@
/* ================================================================================ */
@*H THIS_CLASS(ALIGNER_M_MAFFT)
 Mafft is an  alignment program published in PUBMED:15661851
*@
/* ================================================================================ */
@*H THIS_CLASS(ALIGNER_M_PROBCONS2)
 Author: Mahathi Mahabhashyam PUBMED:15687296
*@
// probcons  -v --consistency 2  --iterative-refinement 1000     input_file
@*RSC_MULTI_PRGPARA THIS_CLASS(ALIGNER_M_PROBCONS2)
 ALIAS_PRGPARAS_FURTHER
 -c=; Use 0<=REPS<=5 (default:2). Passes of consistency transformation:
 -ir=; Use 0<=REPS<=1000 (default:100). Passes of iterative refinement.
*@
/* ================================================================================ */
@*H THIS_CLASS(ALIGNER_M_DIALIGNT)
 <BR>Author: Amarendran R. Subramanian.
 <BR>Publication PUBMED:15784139
*@
//  gcc -lm *.c
@*RSC_MULTI_PRGPARA THIS_CLASS(ALIGNER_M_DIALIGNT)
 ALIAS_PRGPARAS_FURTHER
 -d=;Debug-Mode  [DEFAULT 0] 0 no, 1 current phase of the processing, 2 very loquacious, 5 hardcore debugging
 -s=;max amount of input sequences [DEFAULT 5000]
 -a=;max number of characters per line in a FASTA file [DEFAULT 100]
 -c=;max amount of characters per line when printing a sequence [DEFAULT 80]
 -m=;score matrix file name (in the config directory) [DEFAULT PROTEIN: BLOSUM.scr,  DNA: dna_matrix.scr]
 -w=;    defines the min weight when the weight formula is changed to 1-pow(1-prob, factor) [DEFAULT 0.000000065]
 -p=;probability distribution file name (in the config directory) [DEFAULT PROTEIN: BLOSUM.diag_prob_t10,  DNA: dna_diag_prob_100_exp_550000]
 -v=;add to each score (to prevent negative values) [DEFAULT 0]
 -t=;"even" threshold for low score for sequences alignment [DEFAULT PROTEIN: 4, DNA: 0]
 -n=;max number of consecutive positions for window containing low scoring positions [DEFAULT PROTEIN: 4, DNA: 1]
 -g=;global min fragment length for stop criterion [DEFAULT PROTEIN: 40, DNA: 1]
 -m=;minimal allowed average score in frag window containing low scoring positions [DEFAULT PROTEIN: 4.0,  DNA: 0.9]
 -o=;wether overlap weights are calculated or not [DEFAULT 0]
 -f=;min fragment length [DEFAULT 1]
 -r=;threshold weight to consider the fragment at all [DEFAULT 0.0]
 -u=;[DEFAULT 0] 1: only use a sqrt(amount_of_seqs) stripe of neighbor<BR> sequences to calculate pairwise alignments (increase performance)<BR>0: all pairwise alignments will be calculated
 -D=;input is DNA-sequence
 -T=;translate DNA into aminoacids from begin to end (length will be cut to mod 3 = 0) WARNING: Do not use -D with this option
 -L=;compare only longest ORF WARNING: Do not use -D with this option (Default values for PROTEIN input will be loaded)
 -O=;translate DNA to aminoacids, reading frame for each sequence calculated due to its longest ORF WARNING: Do not use -D with this option
 -P=;output in aminoacids, no retranslation of DNA sequences [DEFAULT: input = output]
 -C=;generate probability table saved in <config_dir>/prob_table and exit
*@
/* ================================================================================ */
@*H THIS_CLASS(ALIGNER_NEEDLEMANWUNSCH)
 Global alignment.<BR>
 Adapted from http://neobio.sourceforge.net/
*@
/* ================================================================================ */
@*H THIS_CLASS(ALIGNER_SMITHWATERMAN)
 Local alignment.<BR>
 Adapted from http://neobio.sourceforge.net/
*@
/* ================================================================================ */
@*H THIS_CLASS(ALIGNER_3D_MAPSCI)
 <BR><B>Publication:</B> PUBMED:20122279
*@
/* ================================================================================ */
@*H THIS_CLASS(ALIGNER_3D_MATT)
 <BR><B>Publication:</B> PUBMED:18193941
*@
/* ================================================================================ */
@*H THIS_CLASS(ALIGNER_3D_MUSTANG)
 <BR><B>Publication:</B> PUBMED:16736488
*@
/* ================================================================================ */
@*H THIS_CLASS(SUPERIMPOSE_TMALIGN)
 <BR><B>Publication:</B> PUBMED:15849316
*@
//Versager: Superimposed s6stdout -load="PDB:1G51_B PDB:1J5W_A"
/* ================================================================================ */
@*H THIS_CLASS(SUPERIMPOSE_CE)
 CE/CL ported to Java by Andreas Prlic
*@
/* ================================================================================ */
@*H THIS_CLASS(SUPERIMPOSE_GANGSTAPLUS)
 <BR><B>Publication:</B> PUBMED:18583523  PUBMED:17118190
*@
//   aysam.guerler@googlemail.com
/* ================================================================================ */
@*H THIS_CLASS(ALIGNER_COMBINE_1D_3D)
 Combining sequence alignment methods and 3D-superposition.
 If at least for two of the sequences to be aligned have 3D-coordinates and not all sequences have
 attached 3D-structures,
 this class combines a sequence alignment method supporting profiles (ClustalW) with
 a 3D-alignment.
 The prefered method is TMalign (C++ or Fortran).
 If installation fails, CE is used as a fall-back.
 <BR><B>Program line options to set t_coffee and TMalign</B>: PAR_ALIGNER_PROFILE=t_coffee PAR_ALIGNER_3D-aligner3D=TMalign
*@
#endif //CPP_WITH_GUI
/* (NUM1 0) */
#define _EXECUTABLE_ 0
#define _PDB_FILE_ARRAY_ 1
#define _PDB_LIST_FILENAMES_ 2
#define _PDB_LIST_ 3
#define _INFILE_MFA_ 4
#define _DIALIGN_T_CONF_ 5
#define _PDB0_ 6
#define _PDB1_ 7
#define _OUTPUT_TREE_ 8
#define _INFILE_GAPPED_MFA_ 9
#define _TCOFFEE_PROFILE_ 10
#define _PRG_PARA_ 11
#define _RPLC_ZZZ 12

@*SARRAYeq_ALIGNER_REPLACEMENT
 gapped.fa=_INFILE_GAPPED_MFA_
 input.fa=_INFILE_MFA_
*@

public final class SequenceAlignerImpl implements ChRunnable,SequenceAligner{
    private final static String ERR=RED_ERROR+"SequenceAligner ",_rplc[]=new String[_RPLC_ZZZ];
    private Object IF_GUI(_liProgress,)_e,_combinedClass3D;
    private Protein[]_pp;
    private final int _it,_flags;
    private int _opt;
    private Collection<byte[][]>_vProfiles;
/* >>> ALIGNER_COMBINE_1D_3D >>> */
    private SequenceAligner _combined1D,_combined3D;
    private TYPE_ALIGN_RESULT _result;
#if CPP_WITH_GUI
    private boolean _running=true,_interrupted[],_stopped;
    private int _combinedCtrlInit;
    private final Object[]_shared=new Object[SHARED_FIELD_ZZZ];
    private Object _ctrl,_ctrlS;
#endif //CPP_WITH_GUI
/* <<< ALIGNER_COMBINE_1D_3D <<< */
    public SequenceAlignerImpl(int it){
        _it=it;
        int flags=it==ALIGNER_M_CLUSTALW?ALIGNER_FLAGS_PROFILES_1:
            it==ALIGNER_M_T_COFFEE?ALIGNER_FLAGS_NEEDS_PROTEINS|ALIGNER_FLAGS_HAS_SCORE|ALIGNER_FLAGS_PROFILES_3:
            it==ALIGNER_M_ALIGN_M?ALIGNER_FLAGS_HAS_SCORE|ALIGNER_FLAGS_AT_LEAST_3_SEQS:
            it==ALIGNER_M_MUSCLE||it==ALIGNER_M_KALIGN||it==ALIGNER_M_DIALIGN||it==ALIGNER_M_AMAP||it==ALIGNER_M_PROBCONS2||it==ALIGNER_M_DIALIGNT?ALIGNER_FLAGS_HAS_SCORE:
            it==ALIGNER_M_MAFFT?ALIGNER_FLAGS_HAS_SCORE:
            it==ALIGNER_NEEDLEMANWUNSCH?ALIGNER_FLAGS_ONLY_TWO_SEQUENCES:
            it==ALIGNER_SMITHWATERMAN?ALIGNER_FLAGS_ONLY_TWO_SEQUENCES|ALIGNER_FLAGS_LOCAL:
            it==ALIGNER_3D_MAPSCI||it==ALIGNER_3D_MATT||it==ALIGNER_3D_MUSTANG?ALIGNER_FLAGS_3D:
            it==SUPERIMPOSE_TMALIGN?ALIGNER_FLAGS_ONLY_TWO_SEQUENCES|ALIGNER_FLAGS_HAS_SCORE|ALIGNER_FLAGS_RETURNS_MATRIX|ALIGNER_FLAGS_LOCAL:
            it==SUPERIMPOSE_CE?ALIGNER_FLAGS_NO_CTRL_PNL|ALIGNER_FLAGS_ONLY_TWO_SEQUENCES|ALIGNER_FLAGS_RETURNS_MATRIX|ALIGNER_FLAGS_LOCAL:
            it==SUPERIMPOSE_GANGSTAPLUS?ALIGNER_FLAGS_RETURNS_MATRIX:
            it==ALIGNER_COMBINE_1D_3D?ALIGNER_FLAGS_3D:
            0;
        if(0!=(flags&(ALIGNER_FLAGS_3D|ALIGNER_FLAGS_RETURNS_MATRIX))) flags|=ALIGNER_FLAGS_NEEDS_PROTEINS;
        if(it!=SUPERIMPOSE_GANGSTAPLUS) flags|=ALIGNER_FLAGS_RETURNS_GAPPED;
        _flags=flags;
        if(it==ALIGNER_COMBINE_1D_3D) _combinedClass3D=sclDefaultForInterface(INTRFC_SequenceAligner3D);
    }
/* >>> Setters Getters >>> */
    OVERRIDE_PUBLIC_IF final int getPropertyFlags(){return _flags;}
    OVERRIDE_PUBLIC_IF TYPE_ALIGN_RESULT getAlignResult(){return _result;}
/* <<< Setters Getters <<< */
/* ---------------------------------------- */
/* >>> Exec >>> */
    private static int[]_it2bid=new int[ALIGNER_ZZZ];
    private BA prepareExec(int execOpts,Object s,byte[][]seqs,Protein[]pp){
        if(_it2bid[_it]==0) _it2bid[_it]=bidForClass(this);
        final BasicExecutable be=new BasicExecutable(_it2bid[_it]);
        _e=be;
        final BA tmp=new BA(99);
        {
            s=toBA(s);
            ROFi0(_RPLC_ZZZ){
                if(_rplc[i]==null) _rplc[i]=s(clr(tmp).aa('%',i,'%'));
                if(strstr(0,_rplc[i],s)>=0){
                    final String rplc=iConst(SARRAYeq_ALIGNER_REPLACEMENT,i);
                    if(rplc!=null) s=strplc(_rplc[i],rplc,s);
                    if(i==_INFILE_GAPPED_MFA_) wrte(newFile(tmpDir(),rplc),aliToTxt(ALITXT_FASTA,seqs,null));
                    if(i==_INFILE_MFA_) wrte(newFile(tmpDir(),rplc),toUngappedMultipleFasta(seqs,"s",0));
                    if(i==_EXECUTABLE_) s=strplc(_rplc[i],s(be.fileExecutable()),s);
                    IF_GUI(if(i==_OUTPUT_TREE_) s=strplc(_rplc[i],s(_outputTree),s));;
                    if(i==_PDB0_||i==_PDB1_){
                        s=strplc(_rplc[i],
                                 nam(pdbFile(pp[i-_PDB0_],i-_PDB0_)),
                                 s);
                    }
                    if(i==_TCOFFEE_PROFILE_){
                        final byte[][][]profiles=toArry(_vProfiles,new byte[0][][]);
                        if(sze(profiles)>0){
                            clr(tmp).a("-profile=");
                            ROFk0(profiles.length){
                                final int e=tmp.end();
                                wrte(newFile(((BasicExecutable)runCR(RUN_GET_NATIVE_EXE,this)).dirTemp(),tmp.aa("profile",k,".mfa,").newString(e,tmp.end()-1)),
                                     aliToTxt(ALITXT_FASTA|ALITXT_PFX_p,profiles[k],null));
                            }
                            s=strplc(_rplc[i],tmp.del(','),s);
                        }
                    }

                }
            }
        }
        final String[]tt=splitTkns(s);
        final Object[]argv=new Object[tt.length];
        if(0!=(_opt&OPT_ALIGN_NO_ERROR)) execOpts|=EXEC_NO_ERROR;
        ROFi0(argv.length){
            argv[i]=tt[i];
            if(chrAt(0,argv[i])=='%'&&lstChar(argv[i])=='%'){
                final int k=atoi(argv[i],1);
                if(k==_PRG_PARA_) argv[i]=IF_GUI(runCR(RUN_GET_PRG_PARAS,this)) UNLESS_GUI(null);
                if(k==_DIALIGN_T_CONF_){
                    argv[i]=null;
                    if(strStarts("/usr/bin",be.fileExecutable())) argv[i]="/usr/share/dialign-tx/";
#if CPP_WITH_GUI
                    else{
                        for(String f:lstDir(be.dirBinaries())){
                            if(f.startsWith("DIALIGN") && !f.endsWith(".exe")){
                                argv[i]=s(clr(tmp).aa(be.dirBinaries(),'/',f,"/conf").replaceChar('\\','/'));
                                break;
                            }
                        }
                    }
#endif //CPP_WITH_GUI
                }
                if(k==_PDB_FILE_ARRAY_ || k==_PDB_LIST_FILENAMES_ || k==_PDB_LIST_){
                    final String[]ff=k==_PDB_FILE_ARRAY_?new String[pp.length]:null;
                    clr(tmp);
                    FORiP(0,pp.length){
                        final File f=pdbFile(pp[iP],iP);
                        if(k==_PDB_LIST_FILENAMES_||k==_PDB_LIST_){
                            mkLink(0,f,newFile(tmpDir(),nam(f)));
                            tmp.aa(nam(f),k==_PDB_LIST_?';':'\n');
                        }else{
                            ff[iP]=s(f);
                        }
                    }
                    argv[i]=
                        k==_PDB_LIST_?tmp:
                        k==_PDB_LIST_FILENAMES_?wrte(newFile(tmpDir(),"listOfPdbFiles"),tmp.del(';')):
                        ff;
                }
            }
        }
        final ChExec ex=be.exec(execOpts).addCmdV(argv).setDir(tmpDir());
        IF_WINDOWS(if(_it==ALIGNER_M_T_COFFEE && isWin()) ex.addEnv("HOME",iFile(DIR_PRGDATA)));;
#if CPP_WITH_GUI
        if(strStarts(s(be.dirBinaries()),be.fileExecutable())){
            if(_it==ALIGNER_M_DIALIGNT) ex.addEnv("DIALIGN2_DIR",clr(tmp).aa(be.dirBinaries(),"/dialign_package/dialign2_dir/"));
            if(_it==ALIGNER_M_MAFFT) ex.addEnv("MAFFT_BINARIES",clr(tmp).aa(be.dirBinaries(),'/',iConst(SARRAYeq_BEXEC_NAME,_it2bid[_it]),"/core"));
        }
#endif //CPP_WITH_GUI
        IF_GUI(if(_it==ALIGNER_M_CLUSTALW&&_outputTree!=null||iConst(SARRAYeq_ALIGNER_OUT_FILE,_it)==null) return ex.stdoutAndDispose());;
        ex.run();
        return readBytes(file(clr(tmp).aa(tmpDir(),'/',iConst(SARRAYeq_ALIGNER_OUT_FILE,_it))));
    }
/* <<< Exec <<< */
/* ---------------------------------------- */
/* >>> Ctrl >>> */
    CPP_RUN_ID_ARG(){
        switch(id){
            CASE_ARGV(RUN_GET_INSTANCE_TYPE) return io(_it);
            CASE_ARGV(RUN_GET_SCORE) return iThEl(ALIGNRESULT_SCORE,_result);
            CASE_ARGV(RUN_DISPOSE){
                final Object e=deref(runCR(RUN_GET_NATIVE_EXE,this));
                if(e!=null){
                    dispos(e);
                    IF_GUI(if(e==_e) _e=newSoftRef(e));
                }
                return TRUEr;
            }
            CASE_ARG(RUN_ALIGN_ADD_PROFILE,byte[][],ss){
                final int profiles=0!=(_flags&ALIGNER_FLAGS_PROFILES_3)?3: 0!=(_flags&ALIGNER_FLAGS_PROFILES_1)?1:0;
                if(ss!=null && sze(_vProfiles)<profiles) _vProfiles=adNotNullNew(ss,_vProfiles);
                RETURN(io(profiles));
            }
            CASE_ARG(RUN_SET_OPTIONS,int,opt) _opt=opt;BREAK;
#if WRITE_CONCATENATED_JAVA||defined RUN_GET_OPTIONS
            CASE_ARGV(RUN_GET_OPTIONS) return io(_opt);
#endif //WRITE_CONCATENATED_JAVA||defined RUN_GET_OPTIONS
            CASE_ARGV(RUN_GET_SEQUENCES) return _pp;
            CASE_ARGV(RUN_GET_NATIVE_EXE) return deref(_e);
#if CPP_WITH_GUI
            CASE_ARG(RUN_IS_OBJECT_ENABLED,Object,o){
                if(_it==ALIGNER_COMBINE_1D_3D) return TRUEr;
                if(_it!=ALIGNER_M_T_COFFEE && 0!=(_flags&ALIGNER_FLAGS_3D)){
                    return o instanceof Protein&&CTRUE!=((Protein)o).getIntProperty(PROTEINI_NOT_USE_STRUCTURE_FOR_ALIGNMENT) && hasCalpha((Protein)o)?TRUEr:FALSEr;
                }
                BREAK;
            }
            CASE_ARGV(RUN_STOP){
                _stopped=true;
                runCR(RUN_STOP,_msaCurrent);
                runCR(RUN_STOP,_combined1D);
                runCR(RUN_STOP,_combined3D);
                runCR(RUN_STOP,runCR(RUN_GET_NATIVE_EXE,this));
                break;
            }
            CASE_ARG(RUN_ALIGN_SET_INTERRUPTED_BOOLARRAY,boolean[],bb){
                _interrupted=bb;
                BREAK;
            }
            CASE_ARG(RUN_GET_CTRL_PNL,Object,supported){
                if(_ctrl==null&&0==(_flags&ALIGNER_FLAGS_NO_CTRL_PNL)){
                    if(supported==PROPERTY_SUPPORTED) return PROPERTY_SUPPORTED;/*X CURRENT*/
                    if(_it==ALIGNER_COMBINE_1D_3D){
                        _ctrl=pnl(GRIDLAYOUT(2,1));
                        runCR1(RUN_ALIGNER3D_ADD_TO_CTRLPNL,this,_combined1D);
                        runCR1(RUN_ALIGNER3D_ADD_TO_CTRLPNL,this,_combined3D);
                    }else if(_it==ALIGNER_MSA_FROM_PAIRALIGNMENT){
                        _ctrl=log().textView(true);
                    }else{
                        final Object cached=gcp(GUI_KEY_CACHE_TEXT,this);
                        if(cached!=null) _ctrl=ChButton.doView(cached).t("Found in cache");
                        if(runCR(RUN_GET_NATIVE_EXE,this)!=null){
                            if(supported==PROPERTY_SUPPORTED) return PROPERTY_SUPPORTED;
                            _ctrl=runCR1(RUN_GET_CTRL_PNL,runCR(RUN_GET_NATIVE_EXE,this),null);
                        }
                    }
                }
                RETURN(_ctrl);
            }
/* >>> ALIGNER_COMBINE_1D_3D >>> */
            CASE_ARG(RUN_ALIGNMENT_PROGRESS,Object,txt){
                runCR1(RUN_ALIGNMENT_PROGRESS,_liProgress,txt);
                BREAK;
            }
            CASE_ARG(RUN_ALIGNMENT_PROGRESS_SET_LISTENER,Object,li){
                _liProgress=li;
                BREAK;
            }
            CASE_ARG(RUN_GET_SHARED_CTRL_PNL,Object,supported){
                if(supported==PROPERTY_SUPPORTED) return bidOpt(TITI_OPT_HAS_PRGPARA,_it2bid[_it])||_it==ALIGNER_COMBINE_1D_3D?PROPERTY_SUPPORTED:null;
                if(_ctrlS==null){
                    _ctrlS=_it!=ALIGNER_COMBINE_1D_3D?getPnl(runCR(RUN_GET_PRG_PARAS_CREATE,this)):
                        ChButton.doView(jMenu(0,
                                              new Object[]{menuSetDefaultMethod(INTRFC_SequenceAligner3D),
                                                      menuSetDefaultMethod(INTRFC_SequenceAlignerTakesProfile)})).t("Default method\u25bc");

                }
                RETURN(_ctrlS);
            }
            CASE_ARG(RUN_ALIGNER_COMBINED_SET_CLASS_3D,Object,c){_combinedClass3D=c;BREAK;}
            CASE_ARG(RUN_ALIGNER3D_ADD_TO_CTRLPNL,Object,c){
                final int i=c==_combined1D?0:1;
                if(_ctrl!=null&&c!=null&&0==(_combinedCtrlInit&(1<<i))){
                    if(!isEDT()) inEdtLater(thrdCR1(RUN_ALIGNER3D_ADD_TO_CTRLPNL,this,c));
                    else{
                        _combinedCtrlInit|=(1<<i);
                        final BA sb=new BA(99);
                        if(i==0) sb.aa(shrtClasNamOrAlias(io(BUT_C1(MultiFromPairAligner))),' ',shrtClasNamOrAlias(c));
                        else sb.aa("3D-alignment ",shrtClasNamOrAlias(_combinedClass3D));
                        adC(pnl(HBL,sb.a(' '),sze(gcp(GUI_KEY_CACHE_TEXT,c))>0?ChButton.doView(gcp(GUI_KEY_CACHE_TEXT,c)).t("In cache"):newCtrlButOrNull(c)),_ctrl);
                        wndw(WNDW_DO_PACK|WNDW_UNLESS_MAIN_WINDOW|WNDW_REVAL_REPAINT,_ctrl);
                    }
                }
                BREAK;
            }
/* <<< ALIGNER_COMBINE_1D_3D <<< */
            CASE_ARG(RUN_MSA_FROM_PAIRALIGNMENTS_SET_CLASS,Object,c) _msaClass=c;BREAK;
            CASE_ARGV(RUN_MSA_FROM_PAIRALIGNMENTS_GET_CLASS) return _msaClass;
#endif //CPP_WITH_GUI

        }
        return IF_GUI(returnPrgParas(id,arg,_shared,this))UNLESS_GUI(null);
    }
/* <<< Ctrl <<< */
/* ---------------------------------------- */
/** >>> compute >>> */
    OVERRIDE_PUBLIC_IF final Object[]computeAlignment(int opt,final Protein[]ppOrig){
        _opt=opt;
        _result=null;
        //IF_GUI(IF_MEIN_DEBUG(final int time=timeOn()));;
        if(sze(_pp=ppOrig)<2) return null;
        if(_it==ALIGNER_MSA_FROM_PAIRALIGNMENT){
            _result=_msaComputeAlignment();
        }else if(_it==ALIGNER_COMBINE_1D_3D){
            byte[][]aligned=null;
            IF_GUI(_vCanBeStopped.add(wref(this)));;
            Protein[]pp3D=null;
            ROFiP0(ppOrig.length){
                final Protein p=ppOrig[iP];
                if(p!=null && CTRUE!=p.getIntProperty(PROTEINI_NOT_USE_STRUCTURE_FOR_ALIGNMENT) && p.countCalpha(S3D_CE_MIN_CALPHA)>=S3D_CE_MIN_CALPHA){
                    if(pp3D==null) pp3D=new Protein[ppOrig.length];
                    pp3D[iP]=p;
                }
            }
            Object[]result3D=null;
            if(sze(pp3D=rmNullPP(pp3D))>=2){
                if((_combined3D=(SequenceAligner)mkInstance(0,_combinedClass3D))!=null){
                    if(pp3D.length>2 && 0!=(_combined3D.getPropertyFlags()&ALIGNER_FLAGS_ONLY_TWO_SEQUENCES)){
                        runCR1(RUN_MSA_FROM_PAIRALIGNMENTS_SET_CLASS,_combined3D=new SequenceAlignerImpl(ALIGNER_MSA_FROM_PAIRALIGNMENT),_combinedClass3D);
                    }
                    setOpts(_opt,_combined3D);
                    IF_GUI(runCR1(RUN_ALIGNER3D_ADD_TO_CTRLPNL,this,addActLi(this,_combined3D)));;
                    IF_GUI(if(_stopped) return null);;
                    aligned=(byte[][])iThEl(ALIGNRESULT_GAPPED,result3D=_combined3D.computeAlignment(0,pp3D));
                }
            }
            Object ii=null;
            if(aligned==null||pp3D.length<ppOrig.length){
                IF_GUI(if(_stopped) return null);;

                if((_combined1D=(SequenceAligner)mkInstance(0,sclDefaultForInterface(INTRFC_SequenceAlignerTakesProfile)))==null)
                    _combined1D=new SequenceAlignerImpl(ALIGNER_M_CLUSTALW);
                IF_GUI(runCR1(RUN_ALIGNER3D_ADD_TO_CTRLPNL,this,_combined1D));;
                setOpts(_opt,_combined1D);
                runCR1(RUN_ALIGN_ADD_PROFILE,_combined1D,aligned);
                final Object[]result1D=_combined1D.computeAlignment(0,ppOrig);
                aligned=(byte[][])iThEl(ALIGNRESULT_GAPPED,result1D);
                ii=iThEl(ALIGNRESULT_INDICES_OF_SEQUENCES,result1D);
            }
            if(sze(ii)==0) ii=iThEl(ALIGNRESULT_INDICES_OF_SEQUENCES,result3D);
            (_result=alignResultNew(aligned,sze(ii)>0?(int[])ii: count01234(0,null,0,spp(this).length),null))[ALIGNRESULT_SCORE]=orO(runCR(RUN_GET_SCORE,_combined1D),runCR(RUN_GET_SCORE,_combined3D));
        }else{/* ClustalW,Mafft,Kalign ... */
            IF_GUI(final int cacheOpt=0);/*X | (0!=(_flags&ALIGNER_FLAGS_RETURNS_MATRIX)?CacheResult.SOFTREF: 0)*/
            final Protein[]pp;
            {
                final int minNumSeqs=0!=(_flags&ALIGNER_FLAGS_AT_LEAST_3_SEQS)?3:2;
                if(ppOrig.length<minNumSeqs){
                    IF_GUI(pleaseSelect(CHAINTYPE_PEP|(minNumSeqs<<PLEASE_SELECT_N_SHIFT),null));;
                    return null;
                }
            }
            IF_GUI(if(!isCbSlct(TOG_ALI_NOT_COMMUT))) Arrays.sort(pp=ppOrig.clone(),comparator(COMPARE_P_XYZ));
            IF_GUI(else {pp=ppOrig;});;
            final byte[][]ss=residueTypeArray(pp);
            final boolean cacheP=
                _it!=ALIGNER_NEEDLEMANWUNSCH&&_it!=ALIGNER_SMITHWATERMAN&&
                pp.length==2&&
                isPrprty(IS_CACHE_READ)&&
                (ALIGNER_FLAGS_ONLY_TWO_SEQUENCES|ALIGNER_FLAGS_RETURNS_MATRIX)==(_flags&(ALIGNER_FLAGS_ONLY_TWO_SEQUENCES|ALIGNER_FLAGS_RETURNS_MATRIX))
                IF_GUI(&&runCR(RUN_GET_PRG_PARAS,this)==null);

            TYPE_ALIGN_RESULT result=cacheP?pp[0].cacheSuperimpose(_it,pp[1],null):null;
            if((_opt&ALIGNER_FLAGS_CHECK_PERFECT_MATCH)!=0){
                final byte[][]aligned=gappedForPerfectMatch(ss);
                if(aligned!=null) (result=alignResultNew(aligned,null,null))[ALIGNRESULT_SCORE]=meinFloatObject(ALIGN_SCORE_FOR_PERFECT_MATCH);
            }
            if(result==null){
                final String cacheKey;
                final BA sbKey=baClr(112);
                CPP_synchronized(recordSync(sbKey,"SequenceAligner")){
                    clr(sbKey);
                    FORi(0,ppOrig.length) cacheKeyForSeq(ss[i],sbKey);
                    if(_it==ALIGNER_M_T_COFFEE || 0!=(_flags&ALIGNER_FLAGS_3D)) FORi(0,pp.length) sbKey.aHex(pp[i].hashCodeCalpha()).a('_');
                    {
                        final byte[][][]profiles=toArry(_vProfiles,new byte[0][][]);
                        FORi(0,sze(profiles))if(profiles[i]!=null) for(byte[]gapped:profiles[i]) if(gapped!=null) sbKey.aa('P',hashCdUC(gapped,0,MAX_INT),'_');
                    }
                    sbKey.a1('_');
                    IF_GUI(sbKey.join('_',runCR(RUN_PRGPARAS_AS_STRING_ARRAY,runCR(RUN_GET_PRG_PARAS,this))).a1('_'));;
                    cacheKey=s(sbKey.a(_implementID));
                    if(isPrprty(IS_CACHE_READ) && (_opt&ALIGNER_FLAGS_USE_SECONDARY_STRUCTURE)==0){
                        final BA output=IF_AA_CACHE(aaCacheGet(getClass(),cacheKey,null)) UNLESS_AA_CACHE(CacheResult.getValue(shrtClasNamOrAlias(getClass()),cacheKey,null));

                        if(0!=(_opt&OPT_ALIGN_NO_ERROR)||checkIntegrity(output)&&
                            errorInPairalignment(result=parseResult(S3D_PARSE_ALIGNMENT|S3D_PARSE_SCORE|(0!=(_flags&ALIGNER_FLAGS_RETURNS_MATRIX)?S3D_PARSE_MATRIX:0),pp.length,output),
                                                 ss,
                                                 " from_cache")){
                            result=null;
                        }
                        IF_GUI(pcp(GUI_KEY_CACHE_TEXT,output==null?null:newSoftRef(new BA(0).a(output)),this));;
                    }
                }
                if(result==null){
                    if(_it==ALIGNER_NEEDLEMANWUNSCH) result=alignResultNew(needlemanWunsch(ss[0],ss[1],null,-11,-1,-11,-1),null,null);
                    else if(_it==ALIGNER_SMITHWATERMAN) result=alignResultNew(smithWaterman(ss[0],ss[1],null),null,null);
#if CPP_WITH_GUI
                    else if(_it==SUPERIMPOSE_CE){
                        final String t=butTxt(BUT_C1(Superimpose_CE_ChRunnable));
                        if(pp[0].countCalpha(S3D_CE_MIN_CALPHA)<S3D_CE_MIN_CALPHA||pp[1].countCalpha(S3D_CE_MIN_CALPHA)<S3D_CE_MIN_CALPHA) baOut(RED_ERROR).a(t).aln(" At least "+S3D_CE_MIN_CALPHA+" coordinates required ");
                        final Object r=runCR1(RUN_COMPUTE,mkInstance(0,cloadJavaClassWithJar(BUT_C1(Superimpose_CE_ChRunnable))),pp);
                        if(r instanceof TYPE_ALIGN_RESULT) result=(TYPE_ALIGN_RESULT)r;
                        else errorEx(r,t,r instanceof OutOfMemoryError?iUrl(iURL_STRAP_HEAP):null);
                }
#endif //CPP_WITH_GUI
                    else{
                        final Object baOrResult=computeResult2(ss,pp);
                        result=
                            baOrResult instanceof BA?parseResult(S3D_PARSE_MSA_START_S|(0==(_flags&ALIGNER_FLAGS_HAS_SCORE)?0:S3D_PARSE_SCORE),ss.length,(BA)baOrResult):
                            (TYPE_ALIGN_RESULT)baOrResult;
                    }
                    if(result!=null && cacheP && isPrprty(IS_CACHE_WRITE)){
                        IF_AA_CACHE(aaCachePut(clasNamOrS(this),cacheKey,alignResultToText(0,result,null)));;
                        UNLESS_AA_CACHE(CacheResult.putValue(cacheOpt,clasNamOrS(this),cacheKey,alignResultToText(0,result,null)));;
                        IF_CACHE_JDBC(IF_MEIN_DEBUG(if(!CacheResultJdbc.instance().init()) ckCacheClassKey(clasNamOrS(this),cacheKey,ss)));;
                    }
                    final Object e=runCR(RUN_GET_NATIVE_EXE,this);
                    if(e!=null && e==_e) _e=newSoftRef(e);
                }
            }
            if((_result=alignResultChangeOrder(result,pp,ppOrig))==null) baOut(ERR).a(" result=null ").aln(shrtClasNamOrAlias(this));
            else{
                if(cacheP) pp[0].cacheSuperimpose(_it,pp[1],result);
                IF_MEIN_DEBUG(errorInPairalignment(result,ss,"Am_Ende "));;
            }
        }
        //IF_GUI(IF_MEIN_DEBUG(debugTime(shrtClasNamOrAlias(this),time)));;

        return _result;
    }

    private static TYPE_ALIGN_RESULT alignResultNew(byte[][]gapped,int[]ii,Matrix3D m){
        final Object[]result=new Object[ALIGNRESULT_ZZZ];
        result[ALIGNRESULT_GAPPED]=gapped;
        result[ALIGNRESULT_MATRIX]=m;
#if CPP_WITH_MEIN_DEBUG
        if((result[ALIGNRESULT_INDICES_OF_SEQUENCES]=ii)!=null){
            final int N=gapped==null?2:sze(gapped);
            if(ii.length<N){
                baOut(RED_ERROR).aPlrl(ii.length," SequenceAlignerImpl ii=%n gapped=").a(sze(gapped)).aln();
            }else{
                ROFi0(N){
                    if(idxOf(i,ii,0,N)<0){
                        baOut(RED_ERROR).aPlrl(N,"alignResultNew numSeq=%n ii=").aIntArray(ii,0,MAX_INT).aln().joinLns(gapped).aln();
                        result[ALIGNRESULT_INDICES_OF_SEQUENCES]=count01234(0,null,0,ii.length);
                        break;
                    }
                }
            }
        }
#endif //CPP_WITH_MEIN_DEBUG
        return result;
    }
/* If order of sequences does not matter,sequences are subjected to alignment computuation using a canonical order. */
/* This is to make caching of results more efficient */
    private static Object[]alignResultChangeOrder(final Object[]result,Protein[]current,Protein[]orig){
        if(result==null||eqArry(0,current,orig)) return result;
        final byte[][]gg0=(byte[][])iThEl(ALIGNRESULT_GAPPED,result);
        final int
            n=gg0==null?2:gg0.length,
            ii0[]=(int[])iThEl(ALIGNRESULT_INDICES_OF_SEQUENCES,result),
            ii[]=ii0==null?null:new int[n],
            done[]=new int[n];
        final byte[][]gg=gg0==null?null:new byte[n][];
        if(ii!=null) Arrays.fill(ii,-1);
        FORi(0,n){
            FORj(0,n){
                if(current[i]==orig[j] && done[j]++==0){
                    if(ii!=null) ii[j]=ii0[i];
                    if(gg!=null) gg[j]=gg0[i];
                    break;
                }
            }
        }
        final TYPE_ALIGN_RESULT r=alignResultNew(gg,ii,iThEl(ALIGNRESULT_MATRIX,result)==null?null:((Matrix3D)result[ALIGNRESULT_MATRIX]).newInverse());
        r[ALIGNRESULT_SCORE]=result[ALIGNRESULT_SCORE];
        r[ALIGNRESULT_RMSD]=result[ALIGNRESULT_RMSD];
        return r;
    }

/* <<< Compute <<< */
/* ---------------------------------------- */
/* >>> File >>> */
    private static int _instances;
    private File _dir;
    private final File tmpDir(){
        if(_dir==null){
            final Object x=runCR(RUN_GET_NATIVE_EXE,this);
            mkdrsErr(_dir=x!=null?((BasicExecutable)x).dirTemp(): file(iPath2(DIR_TMP,shrtClasNamOrAlias(this)).aa('/',++_instances)));
        }
        return _dir;
    }
    private File pdbFile(Protein p,int i){
        return wrte(file(new BA(99).aa(tmpDir(),"/s",i,".pdb")),
             strapInstance(_it==SUPERIMPOSE_GANGSTAPLUS?SEQW_SIDE_CHAIN_ATOMS:SEQWRITER_PDB)
             .getProteinText(SEQW_MET_INSTEAD_OF_MSE|SEQW_CHAIN_A|SEQW_IDX_FOR_RESNUM|SEQW_NO_OCCUPANCY|
                             (_it==SUPERIMPOSE_TMALIGN?SEQW_SHORT_ATOM_LINES:0),
                             p,
                             null,null,null));
    }
/* <<< File <<< */
/* ---------------------------------------- */
/* >>> parse >>> */
    REFLECTION_PUBLIC_STATIC byte[][]insertWhereNoCoordinates(int startIdxR,byte[]ggR,int startIdxM,byte[]ggM,Protein pR,Protein pM){
        final byte[]seqR=pR.resTypeUpperCaseForXYZ();
        final byte[]seqM=pM.resTypeUpperCaseForXYZ();
        if(ggR==null || ggM==null || seqR==null || seqM==null) return null;
        byte[]outR=null,outM=null;
        final int seqRL=strLen(seqR),seqML=strLen(seqM);
        final boolean[]lettr=chrClas(LETTR);
        while(true){
            int oR=0,oM=0,colR=0,colM=0,iR=0,iM=0;
            for(int i=0;i<startIdxR && iR<seqRL;) {final byte c=seqR[iR++]; if(IS_UPPER(c)) i++;}
            for(int i=0;i<startIdxM && iM<seqML;) {final byte c=seqM[iM++]; if(IS_UPPER(c)) i++;}
            boolean foundLetterR=false,foundLetterM=false;
            while(iR<seqRL && iM<seqML && (colR<ggR.length || colM<ggM.length)){
                final boolean
                    letterR=isChrClas(lettr,ggR,colR++),
                    letterM=isChrClas(lettr,ggM,colM++);
                int countXR=0,countXM=0;
                if(letterR) while(iR<seqRL && !(IS_UPPER(seqR[iR]))){
                        if(foundLetterR){
                            if(outR!=null) outR[oR]=seqR[iR];
                            oR++;
                            countXR++;
                        }
                        iR++;
                    }
                if(letterM) while(iM<seqML && !(IS_UPPER(seqM[iM]))){
                        if(foundLetterM){
                            if(outM!=null) outM[oM]=seqM[iM];
                            oM++;
                            countXM++;
                        }
                        iM++;
                    }
                ROFi0(countXM-countXR){
                    if(outR!=null) outR[oR]=' ';
                    oR++;
                }
                ROFi0(countXR-countXM){
                    if(outM!=null) outM[oM]=' ';
                    oM++;
                }
                if(iR<seqRL){
                    if(outR!=null) outR[oR]=letterR?seqR[iR]:(byte)' ';
                    oR++;
                }
                if(iM<seqML){
                    if(outM!=null) outM[oM]=letterM?seqM[iM]:(byte)' ';
                    oM++;
                }
                if(letterR){foundLetterR=true;iR++;}
                if(letterM){foundLetterM=true;iM++;}
            }
            if(outR==null){
                outR=new byte[oR];
                outM=new byte[oM];
            }
            else break;
        }
        return new byte[][]{outR,outM};
    }
    CPP_PRIVATE static void parseScore(BA txt,TYPE_ALIGN_RESULT result){
        final byte[]T=txt.bytes();
        final int E=txt.end();
        FORi(0,E-6){
            boolean eq=true;
            int pos=0;
            switch(BYTES(T[i],T[i+1],T[i+2],T[i+3])|  (32|(32<<8)|(32<<16)|(32<<24))){
            case BYTES('s','c','o','r'):
                if(!isChrClas(LETTR_DIGT_US,T,i-1)&&(T[i+4]|32)=='e')pos=i+5;
                break;
            case BYTES('r','m','s','d'):
                if(!isChrClas(LETTR_DIGT_US,T,i-1)) pos=i+4;
                break;
            case BYTES('a','l','i','g'):/*X  ClustalW */
                if(chrAt(i-1,T)=='\n'&&strEquAt(STR_IC,"Alignment Score ",T,i)){
                    pos=i+16;
                    eq=false;
                }
                break;
            }
            if(pos>0){
                if((!eq || chrAt((pos=nxt(chrClas(-SPC),T,pos,E)+1)-1,T)=='=') &&
                   isChrClas(DIGT_DASH,T,pos=nxt(chrClas(-SPC),T,pos,E))) result[(T[i]|32)=='r'?ALIGNRESULT_RMSD:ALIGNRESULT_SCORE]=meinFloatObject(atof(T,pos,E));
            }
        }
    }
    CPP_PRIVATE static TYPE_ALIGN_RESULT parseResult(int opt,int numSeq,BA txt){
        if(txt==null){
            baOut(ERR).aln("#parse: txt is null");
            return null;
        }
        final byte[]T=txt.bytes();
        Matrix3D m3d=null;
        int[]indicesOfSeqs=null;
        if((opt&S3D_PARSE_MATRIX)!=0){
            if(!(m3d=new Matrix3D()).parseMatrix(txt)){
                m3d=null;
                baOut(ERR).a("Matrix ").aln(txt);
                return null;
            }
        }
        byte[][]gapped=null;
        if((opt&S3D_PARSE_MSA_START_S)!=0){
            CPP_synchronized(SYNC_PARSE_MSA){
                msaParse(MSF_START_WITH_S,txt,null);
                byte[][]gg=_msaSeq;
                if(sze(gg)>=numSeq){
                    final String[]names=_msaName;
                    final byte[][]sorted=new byte[(gg=chSze(gg,numSeq,byte[].class)).length][];
                    Arrays.fill(indicesOfSeqs=new int[gg.length],-1);
                    boolean errorI=false;
                    FORi(0,gg.length){
                        final int j=atoi(names[i],nxt(0,chrClas(DIGT),names[i]));
                        if(j<sorted.length && j>=0){
                            sorted[j]=gg[i];
                            indicesOfSeqs[j]=i;/*X  ???*/
                        }else{
                            errorI=true;
                        }
                    }
                    if(errorI || idxOf(-1,indicesOfSeqs,0,MAX_INT)>=0){
                        baOut(ERR).a("names=").aln(names);
                        return null;
                    }
                    gapped=sorted;
                }else{
                    return null;
                }
            }
        }
        if((opt&S3D_PARSE_ALIGNMENT)!=0){
            int aliLineStart=-1,aliLineEnd=-1;
            for(int iL=0;;iL++){
                LINE_TRIM_BE(iL,txt);;
                if(e-b<10 || T[b]!='<') continue;
                else if(strEquAt(0,"<alignment>",T,b)) aliLineStart=iL+1;
                else if(strEquAt(0,"</alignment>",T,b)) aliLineEnd=iL;
            }
            if(aliLineStart>=0 && aliLineStart<aliLineEnd){
                final boolean[]digt=chrClas(DIGT);
                final int[]eol=txt.eol();
                while(true){
                    int count=0;
                    FORiL(aliLineStart,aliLineEnd){
                        final int b=BOL0(iL,eol),e=eolTrim(T,b,eol[iL]);
                        if(e-b>1 && T[b]=='s' && isChrClas(digt,T,b+1)){
                            if(gapped!=null){
                                final int idx=atoi(T,b+1,e);
                                indicesOfSeqs[idx]=count;
                                gapped[idx]=txt.newBytes(b+S3D_COLUMN_SEQUENCE,e);
                            }
                            count++;
                        }
                    }
                    if(gapped!=null)  break;
                    else{
                        gapped=new byte[count][];
                        indicesOfSeqs=new int[count];
                    }
                }
            }else{
                baOut(ERR).aa("Lines ","<alignment>",'=',aliLineStart,'\t',"</alignment>",'=',aliLineEnd).aln();
                return null;
            }
        }

        final TYPE_ALIGN_RESULT result=alignResultNew(gapped,indicesOfSeqs,m3d);
        if((opt&(S3D_PARSE_SCORE|S3D_PARSE_MATRIX))!=0) parseScore(txt,result);
        return result;
    }/*X   TYPE_ALIGN_RESULT parseResult() */
    private final static byte[]TAGS[]={"rotation".getBytes(),"translation".getBytes(),"alignment".getBytes()};
/* <<< parse <<< */
/* ---------------------------------------- */
/* >>> checkIntegrity >>> */
    private static boolean checkIntegrity(BA txt){
        if(txt==null) return false;
        boolean ok=true;
        //int end=0;
        final byte[]T=txt.bytes();
        for(byte[]tag:TAGS){
            int open=0,close=0;
            final int ee[]=txt.eol();
            FORi(0,ee.length){
                final int b=i==0?txt.begin():ee[i-1]+1;
                //if (end<e) end=e;
                if(ee[i]-b>=tag.length+2&&T[b]=='<'){
                    if(T[b+1]=='/' && ee[i]-b>tag.length+2 && T[b+tag.length+2]=='>' && strEquAt(0,tag,T,b+2)) close++;
                    if(T[b+tag.length+1]=='>' && strEquAt(0,tag,T,b+1)) open++;
                }
            }
            if(open!=close){
                baOut(null).an('-',80).aa("\ncheckIntegrity ",tag,' ',open,' ',close).aln().aln(txt);
                ok=false;
            }
        }
        return ok;
    }
#if CPP_WITH_MEIN_DEBUG&&CPP_WITH_CACHE_JDBC
    private static void ckCacheClassKey(String c,String key,byte[]ss[]){
        if(sze(ss)==2){
            final String M="ckCacheClassKey ";
            boolean error=false;
            final BA output=IF_AA_CACHE(aaCacheGet(c,key,null)) UNLESS_AA_CACHE(CacheResult.getValue(c,key,null));
            if(output==null) {error=true; baOut(ANSI_MAGENTA).a(M).aln("output is null");}
            else errorInPairalignment(parseResult(S3D_PARSE_ALIGNMENT,ss.length,output),ss,M);
            if(error) baOut(ANSI_YELLOW).a(M).aln(key).aln(ss[0]).aln(ss[1]).aln(ANSI_RESET);
        }
    }
#endif //CPP_WITH_MEIN_DEBUG&&CPP_WITH_CACHE_JDBC
    private static boolean errorInPairalignment(TYPE_ALIGN_RESULT r,byte[][]ss,String msg){
        if(r==null)return true;
        final String M="errorInPairalignment ";
        final byte[][]ali=(byte[][])r[ALIGNRESULT_GAPPED];
        if(ali!=null){
            if(ali.length!=ss.length){
                baOut(RED_WARNING).aa(M," sze(ali)=",sze(ali)).aln();
                return false;
            }
#if CPP_WITH_MEIN_DEBUG
            boolean error=false;
            FORi(0,ali.length){
                final byte[]a=ali[i],s=ss[i];
                if(idxOfLetters(a,s,0,strLen(s))<0){
                    final BA sb=baOut(ERR).aa(M,i,'\t').aln(msg).aln(alignResultToText(0,r,null));
                    aliToTxt(ALITXT_FOLD_100|ALITXT_ANSI,new byte[][]{a,s},sb).aln().aln();
                    error=true;
                }
            }
            return error;
#endif //CPP_WITH_MEIN_DEBUG
        }
        return false;
    }
/* <<< checkIntegrity <<< */
/* ---------------------------------------- */
/* >>> Tree >>> */
#if CPP_WITH_TREE
    private String _outputTree;/*X * option -OUTPUTTREE=nj */
    public File computePhFile(byte[][]alignment,String[]names,String tree){
        _outputTree=tree;
        computeResult2(alignment,null);
        final File fPh=newFile(tmpDir(),tree==null?"gapped.dnd":"gapped.ph");
        if(names==null) return fPh;
        final BA sb=readBytes(fPh),tmp=new BA(99);
        if(sb==null){
            baOut(RED_ERROR).aFile(fPh).aln();
            return null;
        }
        ROFi0(names.length)sb.replace(STRPLC_FILL_NULLS,s(clr(tmp).aa('s',i,':')),s(clr(tmp).aWithoutLstCmpnt('.',names[i]).a(':')));
        return wrte(newFile(tmpDir(),addPfx("named_",nam(fPh))),sb.delAllChars('\0'));
    }
#endif //CPP_WITH_TREE
/* <<< Tree <<< */
/* ---------------------------------------- */
/* >>> T_COFFEE >>> */
#if CPP_DEACTIVATED
    private byte[][]_fixed,_ssWithoutFixed;
    private String mayAddFixed(){
        if(_fixed==null) return null;
        wrte(file(getNativeExec().dirTemp(),"fixed.clustalW"),aliToTxt(_ssWithoutFixed.length,_fixed,new BA(99).aln("CLUSTAL\n")));
        return "Afixed.clustalW";
    }
    public void setSequencesWithoutFixed(byte ss[][]) {_ssWithoutFixed=ss;}
#endif //CPP_DEACTIVATED
/* <<< T_COFFEE <<< */
/* ---------------------------------------- */
#include "SequenceAlignerImpl_computeInc.java"
#include "SequenceAlignerImpl_MSAfromPair_Inc.java"
}
#undef THIS_CLASS
