#define MSG_STOP "MultiFromPairAligner stopped"
private MSAResult[][]_msaResults;
private MSASeq[]_msaPP;
private Object IF_GUI(_msaCurrent,)_msaClass;
#if CPP_WITH_GUI
private BA _log;
public BA log(){
    if(_log==null) _log=new BA(999).aa("Log of MultiFromPairAligner(",shrtClasNamOrAlias(_msaClass),')').aln();
    return _log;
}
#endif //CPP_WITH_GUI

private Object[]_msaComputeAlignment(){
#if CPP_WITH_GUI
    _vCanBeStopped.add(wref(this));
    log().a("\n"+ANSI_YELLOW+"_msaComputeAlignment"+ANSI_RESET+"\n");
    FORi(0,_pp.length) log().aa(i,' ').aln(_pp[i]);
#endif //CPP_WITH_GUI
    if((SequenceAligner)mkInstance(iCLASS_SequenceAligner,_msaClass)==null){
        new BA(99).aa("Could not instanciate<PRE>",_msaClass,'=',shrtClasNamOrAlias(_msaClass),"</PRE>").special(BA_ERROR);
        return null;
    }
    final MSAResult[][]results=_msaGetAlignments();
    if(results==null){
        baOut(RED_ERROR).aln(" MultiFromPairAligner results=null");
        return null;
    }
    final int nP=_pp.length;
    if(nP<2) return null;
    final MSAStack stack=new MSAStack();
    final MSASeq[]s=msaProts();
    int topIdx=0;
    ROFt0(2){/*X try 3D*/
        double maxScoreSum=Float.MIN_VALUE;
        ROFi0(nP){
            if(t>0 && !hasCalpha(s[i]._p)) continue;
            float scoreSum=0;
            ROFj0(nP){
                if(i!=j){
                    final double sc=results[i][j]._score;
                    scoreSum+=sc*sc;
                }
            }
            if(maxScoreSum<scoreSum){
                maxScoreSum=scoreSum;
                topIdx=i;
            }
        }
        if(topIdx>0) break;
    }
    IF_GUI(log().aln("\n A(i,j) means sequence alignment of sequence i,j and S(i,j) means 3D superposition\n"));;
    stack.top=s[topIdx];
    adUniq(stack.top,stack.all);
    final List<MSASeq>notAlignedV=new ArrayList();
    ROFi0(nP) if(i!=stack.top._n && s[i]!=null) notAlignedV.add(s[i]);
    while(notAlignedV.size()>0 IF_GUI(&&_running))  _msaCompute(stack,notAlignedV);
    final byte[][]aligned=new byte[nP][];
    final Object[]result=new Object[ALIGNRESULT_ZZZ];
    {
        final int[]sort=new int[nP];
        for(int i=0;i<nP IF_GUI(&&_running);i++){
            final MSASeq p=stack.all.get(i);
            aligned[p._n]=p._gapped;
            sort[i]=p._n;
        }
        result[ALIGNRESULT_INDICES_OF_SEQUENCES]=sort;
    }
    result[ALIGNRESULT_GAPPED]=aligned;
    _msaResults=null;
    _pp=null;
    return result;
}
private MSASeq[]msaProts(){
    if(_msaPP==null){
        ROFi0((_msaPP=new MSASeq[_pp.length]).length) _msaPP[i]=new MSASeq(_pp[i].getResType(),_pp[i],i);
    }
    return _msaPP;
}
private MSAResult[][]_msaGetAlignments(){
    if(_msaResults==null){
        IF_GUI(int timePG=0);;
        _msaResults=new MSAResult[_pp.length][_pp.length];
        final MSASeq[]pp=msaProts();
        IF_GUI(final Object constProgress=new BA(99).aa('/',pp.length*pp.length,' ',shrtClasNamOrAlias(_msaClass),' '));;
        for(int IF_GUI(count=0,)iR=pp.length;--iR>=0;){
            for(int iM=pp.length;--iM>=0;IF_GUI(count++)){
                IF_GUI(final Protein pR=pp[iR]._p,pM=pp[iM]._p);;
                if(iR==iM) continue;
                if(_msaResults[iR][iM]==null){
                    final MSAResult result=_msaResults[iR][iM]=new MSAResult(pp[iR],pp[iM]);
                    SequenceAligner aligner=(SequenceAligner)mkInstance(iCLASS_SequenceAligner,_msaClass);
                    IF_GUI(if(_stopped || iThBool(0,_interrupted)) {baOut(MSG_STOP).a('\n'); return null;});;
                    byte[][]rrLocal=(byte[][])iThEl(ALIGNRESULT_GAPPED,aligner.computeAlignment(0,new Protein[]{pp[iR]._p,pp[iM]._p}));
#if CPP_WITH_GUI
                    _msaCurrent=aligner;
                    if(withGui() && timeOn()-timePG>200){
                        final BA sbPG=baClr(113)IF_GUI(.a(count)).a(constProgress).and(pR," ./. ",pM);
                        timePG=timeOn();
                        runCR1(RUN_ALIGNMENT_PROGRESS,sbPG,_liProgress);
                    }
                    if(_stopped) {baOut(MSG_STOP).a('\n'); return null;}
#endif //CPP_WITH_GUI
                    if(iThEl(0,rrLocal)==null || iThEl(1,rrLocal)==null){
                        IF_GUI(log().aa(RED_ERROR,'(',iR,',',iM,") computeAlignment(0,...) returns null ").aln(shrtClasNamOrAlias(_msaClass)));;
                        return null;
                    }else{
                        if(0!=(aligner.getPropertyFlags()&ALIGNER_FLAGS_RETURNS_MATRIX)){
                            if(Double.isNaN(result._score=scor(aligner))) result._score=pairAignScore(-20f,-4f,rrLocal[0],rrLocal[1],0,MAX_INT,-BLOSUM62_MIN);
                        }else result._score=pairAignScore(-20f,-5f,rrLocal[0],rrLocal[1],0,MAX_INT,0);
                        IF_GUI(log().aa(GREEN_SUCCESS,'(',iR,',',iM,") result._score=",result._score).aln());;
                    }
                    if(iThEl(0,rrLocal)==null || iThEl(1,rrLocal)==null) return null;
                    IF_MEIN_DEBUG(if(sze(rrLocal)!=2) baOut(RED_ERROR).aln("sze(rrLocal)!=2"));;
                    result._aligned=rrLocal;
                    dispos(aligner);
                    IF_GUI(log().aa("result(",iR,',',iM,")=",result._score).aln());;
                    IF_GUI(count++);;
                    if(rrLocal!=null) _msaResults[iM][iR]=result.invert();
                }
            }
        }
        IF_GUI(if(withGui()) runCR1(RUN_ALIGNMENT_PROGRESS,_liProgress,new BA(99).aPlrl(pp.length*pp.length," %N Alignment%S done")));;
    }
    IF_GUI(_msaCurrent=null);;
    return _msaResults;
}
private void _msaCompute(MSAStack stack,List<MSASeq>notAlignedV){
    final MSAResult bestAli=_msaBestResult(stack.all,notAlignedV);
    final MSASeq protStack=bestAli._pR,protNotAl=bestAli._pM;
    final byte[][]aligned=bestAli._aligned;
    if(protStack==null||aligned==null||protNotAl==null||aligned==null){
        IF_GUI(IF_MEIN_DEBUG(log().aa(RED_ERROR," in protStack=",protStack!=null," aligned=",aligned," protNotAl=",protNotAl," aligned=",aligned!=null?aligned.length:-1).aln()));;
        IF_GUI(_running=false);;
        return;
    }
    IF_GUI(log().aa(bestAli._superimposed?" S(": " A(",protStack._n,',',protNotAl._n,") ").aln());;
    final byte[][]ist={protStack._gapped,protNotAl._gapped},soll={aligned[0],aligned[1]};
    final int[][]inserts=mergeAlignments(null,soll,ist);
    protNotAl._gapped=_msaInsertGapsAtColumns(inserts[1],protNotAl._gapped);
    ROFi0(stack.all.size()){
        final MSASeq p=stack.all.get(i);
        p._gapped=_msaInsertGapsAtColumns(inserts[0],p._gapped);
    }
    notAlignedV.remove(bestAli._pM);
    adUniq(bestAli._pM,stack.all);
}
/* <<< Compute <<< */
/* ---------------------------------------- */
/* >>> Best Comparison  >>> */
private MSAResult _msaBestResult(List<MSASeq>pp1,List<MSASeq>pp2){
    MSAResult best=null;
    final MSAResult[][]aa=_msaGetAlignments();
    ROFi0(pp1.size()){
        ROFj0(pp2.size()){
            final MSAResult result=aa[pp1.get(i)._n][pp2.get(j)._n];
            if(best==null || result!=null && result.isBetterThan(best)) best=result;
        }
    }
    return best;
}
/* <<< Best Comparison <<< */
/* ---------------------------------------- */
/* >>>  Classes  >>> */
private static class MSAStack {MSASeq top;List<MSASeq>all=new ArrayList();}
private static class MSAResult{
    final MSASeq _pM,_pR;
    byte[][]_aligned;
    double _score;
    boolean _superimposed;
    public MSAResult(MSASeq pR,MSASeq pM) {_pR=pR;_pM=pM;}
    public MSAResult invert(){
        final MSAResult r=new MSAResult(_pM,_pR);
        r._score=_score;
        r._superimposed=_superimposed;
        r._aligned=new byte[][]{_aligned[1],_aligned[0]};
        return r;
    }
    private boolean isBetterThan(MSAResult r2){
#if 0
        if(r2==null) return true;
        if(_superimposed && !r2._superimposed) return true;
        if(!_superimposed && r2._superimposed) return false;
        return _score>r2._score;
#endif //0
        return r2==null||_superimposed && !r2._superimposed||
            !(!_superimposed && r2._superimposed) && _score>r2._score;

    }
}
private static class MSASeq{
    final int _n;
    final Protein _p;
    byte[]_gapped;
    public MSASeq(byte[]seq,Protein p,int number){
        _gapped=seq;
        _p=p;
        _n=number;
    }
}
private static byte[]_msaInsertGapsAtColumns(int[]insert,byte[]orig){
    int n=orig.length;
    ROFi0(n<insert.length?n:insert.length) n+=insert[i];
    final byte[]txt=new byte[n];
    for(int iT=0,i=0;i<orig.length;i++){
        if(i<insert.length) ROFj0(insert[i]) txt[iT++]=32;
        txt[iT++]=orig[i];
    }
    return txt;
}
