package charite.christo.strap;
import java.util.*;
import charite.christo.*;
import static charite.christo.ChUtils.*;
import static charite.christo.strap.Strap.*;
/* Preliminary deactivate ChTreeMap and use HashMap  */
#define STRUCT_OPER_LIST_SIZE 99
#define treeAdd(key)  put(longObjct(key),"")==null
#define treeClear() clear()
#if !CPP_WITH_MEIN_DEBUG
#define exitOnErr()
#define errLine(a,b)
#endif //!CPP_WITH_MEIN_DEBUG
#define THIS_CLASS(a) BUT_C_##SequenceParserImpl3D##_##a
#define _pdbTmp(opt) baClr(98|opt)
#define pdbTmp() _pdbTmp(0)
#define pdbTmpClr() _pdbTmp(VCLR_CLEAR)
#define _vAssemblies vNoClr(253)
/* (NUM1 1) */
#define PDB_ATOM 1
#define PDB_HETATM 2
/* (NUM1 3)  Leading two bits are used as flags! */
#define PDB_HEADER 3
#define PDB_COMPND 4
#define PDB_CONECT 5
#define PDB_DBREF 6
#define PDB_LINK 7
#define PDB_SEQADV 8
#define PDB_HELIX 9
#define PDB_HET 10
#define PDB_END 11
#define PDB_ENDMDL 12
#define PDB_TER 13
#define PDB_MODRES 14
#define PDB_SEQRES 15
#define PDB_SHEET 16
#define PDB_SITE 17
#define PDB_CISPEP 18
#define PDB_SSBOND 19
#define PDB_SOURCE 20
#define PDB_TITLE 21
#define PDB_REMARK 22
#define PDB_CONN_METALC 23
#define PDB_CONN_SALTBR 24
#define PDB_CONN_COVALE 25
#define PDB_CONN_HYDROG 26
/* (NUM1 0) */
#define CIF_SHIFT_ALTLOC 0
//#define CIF_SHIFT_E 1
#define CIF_SHIFT_SKIP 2
#define CIF_SHIFT_RESN 3
/* --- */
#define secStruAdd(iL,type,name1,rn1,ins1,name2,rn2,ins2) _secStruAdd(IF_MEIN_DEBUG(iL,)type,IF_MEIN_DEBUG(name1,)rn1,ins1,IF_MEIN_DEBUG(name2,)rn2,ins2)
#define anno(tol,line) _anno(tol IF_MEIN_DEBUG(,line))
#define setUniprot(iL,posDb,posId) _setUniprot(IF_MEIN_DEBUG(iL,) posDb,posId)
#define MC_FOR_TXT(txt) (((long)txt.mc())<<32L)|uintToLong(System.identityHashCode(txt))
#define _resanUniq setNoClr(252)
#define _mapHet mapNoClr(266)
#define _mapSiteDescr mapNoClr(267)
#define _mapSiteEvdnc mapNoClr(268)
#define _mapSite mapNoClr(269)
    public class SequenceParserImpl3D implements ProteinParser,ChRunnable{
        private static BA _txt;//,_seqres,_atmSeq,_title;
#define _seqres baNoClr(168)
#define _atmSeq baNoClr(145)
#define _title baNoClr(146)
#define _altloc mapNoClr(279|VCLR_ChTreeMap)
#include "SequenceParserImpl3D_PDB_Inc.java"
#include "SequenceParserImpl3D_CIF_Inc.java"

        private static int _msgChain,_bufAtom[]={},_bufSeqId[]={},_bufRnums[],_bufAnum[],_bufrAnums[],_buf[]={},_seqresAli[]={},__it,
            _B,_E,_eol[],_chain,_chainOfLine[],_hetsInPep[]={},_hetsInPepL;/*X  Hetero residues in  peptide chains resnum<<8|ins */
        private static short[]_bufElmn={};
        private static float IF_GUI(_resolution,)_xyz[]={};
        private static byte[]_secStr={},_typeOfLine,_T;
        private static Protein _p;
        private final static int[]FST_LINE_OF_CHAIN=new int['z'+1],LST_LINE_OF_CHAIN=new int['z'+1],RESNUM=new int[99];
        private static String _chainsByType[][],_id4,_dbColonId,_className;

        private final int _it;
        REFLECTION_PUBLIC SequenceParserImpl3D(int it) {_it=it;}
        private float[]_dsspAcc;
        private byte[]_dsspSS;
        OVERRIDE_PUBLIC String[][]parse(int opt,String wantChain,BA txt,final Protein p){
            if(_it==SPARSER_DSSP){
#include "SequenceParserImpl3D_parse_DSSP_Inc.java"
            }
            CPP_synchronized(SYNC_PDB){
                return _it==SPARSER_PDB?_parsePDB(opt,wantChain,txt,p):_parseCIF(opt,wantChain,txt,p);
            }
        }
        CPP_RUN_ID_ARG(){
            switch(id){
#if CPP_WITH_GUI
                CASE_ARG(RUN_PDB_SPLIT,BA,ba){
                    final Collection v=new ArrayList();
                    synchronized(SYNC_PDB){
                        final String[][]chainsByType=chainsInPdbOrCif(ba);
                        for(int t=CHAINTYPE_HET; chainsByType!=null && --t>=0;){
                            for(String ch:chainsByType[t]){
                                java.io.File fNew=null;
                                if(ba.getFile()!=null){
                                    final String fn=delSfx(".zip",xdelSfx(STR_IC,arry(SARRAY_COMPRESS_SUFFIX),nam(ba.getFile())));
                                    final int i=fn.lastIndexOf('.');
                                    final BA sb=pdbTmpClr();
                                    if(i<0 || i<fn.lastIndexOf('/') || i<fn.lastIndexOf('\\')) sb.aa(fn,'_',ch,".pdb");
                                    else sb.aFT(fn,0,i).aa('_',ch).aFT(fn,i,MAX_INT);
                                    fNew=file(sb);
                                }
                                fileDel(0,fNew);
                                _pdbWriteOnlyChain(t==CHAINTYPE_DNA||t==CHAINTYPE_RNA?SEQW_SIDE_CHAIN_ATOMS|SEQW_ONLY_NT_STRUCTURE:SEQW_SIDE_CHAIN_ATOMS,chainToChain1(ch),ba,fNew);
                                if(sze(fNew)>0) adNotNullNew(fNew,v);
                            }
                        }
                    }
                    RETURN(v);
                }
#endif //CPP_WITH_GUI
#if CPP_WITH_MEIN_DEBUG
                CASE_ARGV(RUN_PDBCIF_LOG_WARN) return err(PDB_WRN);
#endif //CPP_WITH_MEIN_DEBUG
#if CPP_WITH_MEIN_DEBUG&&CPP_WITH_GUI
                CASE_ARGV(RUN_PDBCIF_LOG_ERROR) return err(PDB_ERR);
#endif //CPP_WITH_MEIN_DEBUG&&CPP_WITH_GUI
                CASE_ARGV(RUN_PDBCIF_GET_HETEROS) return parseAtoms(0,null);
                CASE_ARGV(RUN_GET_INSTANCE_TYPE) return io(_it);
                CASE_ARGV(RUN_GET_DSSP_ACCESSIBILITY) return _dsspAcc;
                CASE_ARGV(RUN_GET_DSSP_SECONDARY_STRUCTURE) return _dsspSS;
            }
            return null;
        }
        private static String dbColonId(){
            if(_dbColonId==null) _dbColonId=s(pdbTmpClr().and("PDB:",_id4));
            return _dbColonId;
        }
        private static void _init(int it,BA txt){
            __it=it;
            _txt=txt;
            _className=iConst(SARRAY_BID_TO_CLASS,bidForClass(pdbTmpClr().aa(SequenceParserImpl3D.class,'#',it)));
            if(txt!=null){
                _chainOfLine=redim(_chainOfLine,(_eol=txt.eol()).length,999|REDIM_CLEAR_ARRAY);
                //_chainOfLine2=redim(_chainOfLine2,_eol.length,999|REDIM_CLEAR_ARRAY);
                _B=txt.begin();
                _E=txt.end();
                _T=txt.bytes();
            }else{
                _T=null;
                _eol=null;
            }
            //_heterosWithBlankChain=null;
            IF_GUI(_resolution=0);;
            Arrays.fill(STRUCT_OPER_LIST,null);
            clr(_resanUniq);
            clr(_vAssemblies);
            clr(_mapSiteEvdnc);
            clr(_mapSiteDescr);
            clr(_mapHet);
            Arrays.fill(FST_LINE_OF_CHAIN,MAX_INT);
            Arrays.fill(LST_LINE_OF_CHAIN,MIN_INT);
            _msgChain=-1;
            _dbColonId=_id4;
            clr(_title);
        }
        private static int beginOrEnd(String chain,Protein p){
            IF_MEIN_DEBUG(if(p!=null && chain==null) {stckTrcCT(0); exitOnErr();});;
            if(p!=null){
                p.setChain(chain);
                _chain=charsToBitsStopAtSpace(pdbTmpClr().aa(chain,' ').bytes(),0);
            }else{
                p=_p;
                final int lst=nxtBwd(0,chrClas(LETTR),_secStr);
                if(lst>0) p.setResidueSecStrType(cpyArry(_secStr,0,lst+1));
                for(Map.Entry e:entryArry(_mapSite)){
                    final String id=(String)e.getKey();
                    Object detail=_mapSiteDescr.get(id),group="PDB",name=id;
                    if(0<=strstr(STR_IC,"BINDING SITE",detail)) name=group="Binding_site";
                    else if(0<=strstr(STR_IC,"CATALYTIC",detail)) name=group="Active_site";
                    annotateSeqStyleRgbPosNameGrp(p,SSTYLE_UNDERLINE,0x0000ff,e.getValue(),name,(String)group).annoAdd(IRESAN_BALLOON,detail).annoAdd(IRESAN_SRC,dbColonId());
                }
                if(sze(dbColonId())>0){
                    final String dbColonIdChain=s(pdbTmpClr().a(dbColonId()).a('_').aBytes(_chain));
                    p.addSeqRef(ADD_SEQREF_ACC,dbColonIdChain);
                    p.setPdbID(PDBID_ID|PDBID_NOT_OVERWRITE,dbColonIdChain);
                }
                biomtFinally();
                if(sze(_title.trim())>0) _p.setProperty(P_TITLE,toStrgTrim(simplifyTitle(_title))); /*X  Too long e.g.. 3cf5 */
            }
            _p=p;
            clr(_seqres);
            clr(_mapSite);
            clr(_secStr);
            return _chain;
        }
        UNLESS_MEIN_DEBUG(private) static Object simplifyTitle(BA sb){
            {/*X Colon separated fields start with same */
                final byte[]T=sb.bytes();
                final int B=sb.begin(),E=sb.end(),cc[]=new int[countChr(',',T,B,E)];
                if(cc.length>1){
                    final boolean[]no_spc=chrClas(-SPC);
                    for(int count=0,i=B;i<E;i++) if(T[i]==',') cc[count++]=i;
                    int commonStart=0;
                nxtChar:
                    for(;;commonStart++){
                        for(int c0=0,i=0,e=B-1;i<cc.length;i++){
                            int b=nxt(no_spc,T,e+1,E); e=cc[i];
                            if(e-b<=commonStart) break nxtChar;
                            final byte c=T[b+commonStart];
                            if(c0==0) c0=c;
                            if(c0!=c) break nxtChar;
                        }
                    }
                    if(commonStart>6){
                        final BA sb2=pdbTmpClr().aFT(T,B,commonStart).del(' ');
                        for(int i=0,e=B-1;i<cc.length;i++){
                            int b=nxt(no_spc,T,e+1,E); e=cc[i];
                            sb2.a1(' ').aFT(T,b+commonStart,e).a1(',');
                        }
                        sb=sb2.del(',');
                    }
                }
            }
            {/*X MUTANT WITH HIS 195 REPLACED BY GLN */
                while(true){
                    final byte T[]=sb.bytes(),rt1,rt2;
                    final int B=sb.begin(),E=sb.end(),i=strstr(0," REPLACED BY ",T,B,E),numStart=i<0?-1:nxtBwd(0,chrClas(-DIGT),T,i-1,B);
                    if(numStart<i && numStart>0&&
                       0!=(rt1=toOneLetterCode(charsToBitsStopAtSpace(T,numStart-3)))&&
                       0!=(rt2=toOneLetterCode(charsToBitsStopAtSpace(T,i+13)))){
                        if(rt1!=0 && rt2!=0){
                            final String rplc=s(pdbTmpClr().a((char)rt1).a(atoi(T,numStart)).a((char)rt2));
@*SARRAY_RPLC_MUTANT
                             MUTANT WITH|MUTANT AND|MUTANT  AND
*@
                            sb.replaceRange(numStart-3-B,i+16-B,strstr(0,rplc,T,B,E)>0?"":rplc).replace(STR_w,arry(SARRAY_RPLC_MUTANT),"MUTANT");
                        }
                    }else break;
                }
            }
            Object s=s(sb).replaceAll("[\t\n ]+"," ").replaceAll("; CHAIN:.*","");
            for(String d:arry(SARRAY_PDB_ANNOTATION_RM)) s=strplc(STR_IC|STR_X_MATCHES_ANY,d,"",s);
            for(String d:arry(SARRAY_PDB_ANNOTATION_DEL_PFX)) s=delPfx(d,s);
            return s;
        }
        UNLESS_MEIN_DEBUG(private) static BA err(int opt){
            final BA sb=baLog(LOG_FILES_3D);
            if(DIFF_MC(_msgChain,_chain)){
                final BA sb2=baClr(120).an('-',3).aa(' ',_className,' ').aFile(_txt.getFile()).and(" id=",_id4).and(" name=",_p).a(_chain==0?null:" chain=").aBytes(_chain).a(' ').an('-',3);
                sb.a(ANSI_STYLE_PDB).an('-',sze(sb2)).aln().a(sb2).aln(ANSI_RESET);
            }
            sb.aa(ANSI_STYLE_PDB,_className,ANSI_RESET+" ");
            if(0!=(opt&PDB_ERR)) sb.a(RED_ERROR);
            if(0!=(opt&PDB_WRN)) sb.a(RED_WARNING);
            if(0!=(opt&PDB_DONE)) sb.a(GREEN_DONE);
            return sb;
        }
#if CPP_WITH_MEIN_DEBUG
        static void errLine(int pos,int beforeAndAfter){
            if(0!=(beforeAndAfter&PDB_ERR_LINE_FROM_POS)){
                ROFiL0(_eol.length){
                    final int b=iL==0?_B:_eol[iL-1]+1;
                    if(pos>=b){
                        errLine(iL,beforeAndAfter&~PDB_ERR_LINE_FROM_POS);
                        break;
                    }
                }
            }else{
                final BA sb=err(0).aln();
                for(int iL=maxi(0,pos-(beforeAndAfter>>>8));iL<pos+(beforeAndAfter&0xFF)+1;iL++){
                    if(iL<_eol.length) sb.a(" "+ANSI_INVERSE).aInt(iL,4).a(ANSI_RESET+" ").a(iL==pos?'>':' ').aFT(_T,iL==0?_B:_eol[iL-1]+1,_eol[iL]).a('\n');
                }
                sb.del('\n').aln();
            }
        }
        private static void exitOnErr(){
            stckTrcCT(0);
            err(0).a(_title).aln(ANSI_RED+" exitOnErr "+ANSI_RESET).special(DIE_NOW);
        }
#endif //CPP_WITH_MEIN_DEBUG
#define FLAG_END (1<<31)
        private static Protein[]parseAtoms(int wantChain,Protein p){/*X if p==null then collect heteros */
            final int atomB,atomE,nAtom;
            final Collection<Protein>vHet=p!=null?null:new ArrayList();
            {
                final int tmp=vHet!=null?PDB_HETATM: wantChain<='z'?wantChain:0;
                atomB=FST_LINE_OF_CHAIN[tmp];
                atomE=LST_LINE_OF_CHAIN[tmp];
            }
            assert PDB_HETATM!=0 && PDB_HETATM<'0';
            clr(_atmSeq);
            clr(_altloc);
            {
                int s=atomE-atomB+1;
                if(_buf.length<=s*PDBBUF_ZZZ) _buf=chSze(_buf,(s+3333)*PDBBUF_ZZZ);
                if(_xyz.length<=s*3) _xyz=chSze(_xyz,(s+3333)*3);
            }
            boolean needAlignSeqres=__it==SPARSER_PDB;
            {
                int iXYZ=0;
                //                ||wantChain!=_chainOfLine2[iL]
                for(int iL=atomB,rNumPrev=INT_NAN,chainPrev=0,idxHetsInPep=-1,iBuf=0,iAmino=0;iL<=atomE;iL++){
                    // if(vHet!=null) baOut(DEBUG_NOW+" _chainOfLine=").aBytes(_chainOfLine[iL]).a(" _chainOfLine2=").aBytes(_chainOfLine2[iL]).a(" wantChain=").aBytes(wantChain).aln();
                    //if(wantChain!=_chainOfLine[iL]&&vHet==null || (_typeOfLine[iL]==PDB_HETATM)!=(vHet!=null)) continue;
                    if(wantChain!=_chainOfLine[iL]&&vHet==null || (_typeOfLine[iL]!=(vHet!=null?PDB_HETATM:PDB_ATOM))) continue;
                    final int
                        b=iL==0?_B:_eol[iL-1]+1,
                        code=__it==SPARSER_PDB?_parseLinePDB(_T,b,_eol[iL],_buf,iBuf,_xyz,iXYZ):_parseLineCIF(_T,b,_buf,iBuf,_xyz,iXYZ),
                        rnum=code>>>CIF_SHIFT_RESN;
                    // if(iBuf>0 && 0!=(code&(1<<CIF_SHIFT_E))) break;/*X  New Chain */
                    if(0!=(code&(1<<CIF_SHIFT_SKIP))) continue;
                    if(0!=(code&(1<<CIF_SHIFT_ALTLOC)) &&  !(_altloc.treeAdd((((long)rnum)<<32)|_buf[iBuf+PDBBUF_ATOM]))) continue;/*X  ALTLOC */
                    if(__it==SPARSER_PDB && vHet==null && _typeOfLine[iL]==PDB_HETATM){
                        if(rNumPrev!=rnum) idxHetsInPep=idxOf(rnum,_hetsInPep,0,_hetsInPepL);
                        if(idxHetsInPep<0) continue;
                    }
                    if(DIFF_MC(rNumPrev,rnum) || (vHet!=null&&chainPrev!=_chainOfLine[iL])){/*X in 3unb there are heteros with a dot instead of residue number */
                        if(vHet!=null) chainPrev=_chainOfLine[iL];
                        else{
                            final byte olc=toOneLetterCode(_buf[iBuf+PDBBUF_RNAM]);
                            _atmSeq.a((char)olc);
                            if(!needAlignSeqres){
                                if(_bufSeqId.length<=iAmino) _bufSeqId=chSze(_bufSeqId,iAmino*2+333);
                                _bufSeqId[iAmino++]=rnum-1;
#if CPP_WITH_MEIN_DEBUG
                                if(vHet==null){
                                    final byte seqres[]=_seqres.newBytes(),s=iThByte(rnum-1,seqres);

                                    if(s!=0 && olc!=s){/*X E.g.2BFL*/
                                        err(PDB_ERR).aa("Mismatch: ATOM=",(char)olc," SEQRES=").aFT(seqres,0,rnum-1).aa(ANSI_GREEN,(char)s,ANSI_RESET).aFT(seqres,rnum,MAX_INT).aln();
                                        errLine(iL,0x0108);
                                        needAlignSeqres=true;
                                    }
                                }
#endif //CPP_WITH_MEIN_DEBUG
                            }
                        }
                        if(iBuf>0) _buf[PDBBUF_ATOM-PDBBUF_ZZZ+iBuf]|=FLAG_END;
                    }
                    iBuf+=PDBBUF_ZZZ;
                    iXYZ+=3;
                }
                if((nAtom=iXYZ/3)==0) return Protein.NONE;
            }
            _buf[(nAtom-1)*PDBBUF_ZZZ+PDBBUF_ATOM]|=FLAG_END;
/* ---------------------------------------- */
/*  Compare the one-letter-code sequences   */
/*  from SEQRES with those from ATOM lines  */
/* ---------------------------------------- */
            int seqresOffset=0,seqresAli[]=null;
            byte[]aminos=null;
            if(vHet==null){
                final byte[]ss=_seqres.newBytes(),aa=_atmSeq.newBytes();
                if(ss.length==0) aminos=aa;
                else{
                    aminos=ss;
                    seqresAli=!needAlignSeqres?_bufSeqId:
                        (seqresOffset=strstrBB(aa,aa.length,ss,ss.length))<0?seqresAlignment(aa,ss):
                        null;
                }
                p.setResidueType(aminos);
            }
/* ---------------------------------------- */
/*  From here we know:                      */
/*     which lines                          */
/*     #aminos                              */
/*     Correspondence to seqres             */
/* ---------------------------------------- */
            final int[]rrAtomF=new int[vHet!=null?1:aminos.length];Arrays.fill(rrAtomF,-1);
            int[]rrAnums[]=null,bufAnum=_bufAnum,rrAtoms[]=null,bufAtom=null,rNams=null,aaOlc=null;
            _bufrAnums=redim(_bufrAnums,rrAtomF.length,99);
            byte[]rIns=null;
            short[]eeOlc=null,rrElmns[]=null,bufElmn=null;
            boolean rAnumsDiff=false,needRnum=true;
            final int[]rNums=redim(_bufRnums,rrAtomF.length,333);
            Arrays.fill(rNums,INT_NAN);
            for(int iAtom0123=0,iAmino=INT_NAN,iAminoRaw=0,iBuf=0,anumFst=0,iAtom=0;iAtom<nAtom; iAtom++,iBuf+=PDBBUF_ZZZ){
                final int
                    anum=_buf[iBuf+PDBBUF_ANUM],
                    rnam=_buf[iBuf+PDBBUF_RNAM];
#define elem _buf[iBuf+PDBBUF_ELEM]
#define chain _buf[iBuf+PDBBUF_CHAIN]
#define atomAndFlags _buf[iBuf+PDBBUF_ATOM]
#define rnum (_buf[iBuf+PDBBUF_RNUM]>>7) /*X  signed bit shift !*/
#define insc (_buf[iBuf+PDBBUF_RNUM]&127)
#define atom (atomAndFlags&~FLAG_END)

                if(iAtom0123==0){/*X New amino */
                    iAmino=iAminoRaw;/*X  Seting iAmino ... */
                    if(vHet!=null){
                        iAmino=0;
                        bufAtom=_bufAtom;
                        bufAnum=_bufAnum;
                        bufElmn=_bufElmn;
                    }else{
                        if(seqresAli!=null) iAmino=seqresAli[iAminoRaw];
                        else if(seqresOffset>0) iAmino=seqresOffset+iAminoRaw;
/* iAmino done*/
                        int amino=0;
                        bufAtom=bufAnum=null;
                        bufElmn=null;
                        if(iAmino<aminos.length) amino=aminos[iAmino];
                        IF_MEIN_DEBUG(else baOut(RED_ERROR).aa("PDBParser_UtilsInc",_id4,' ',_chain," iAmino=",iAmino,'/',aminos.length).aln());;

                        aaOlc=Protein.AMINOACID_ATOMS[amino];
                        eeOlc=Protein.AMINOACID_ELEMENTS[amino];
                        if(rNams==null)rNams=new int[rrAtomF.length];
                        if(rnam!=toThreeLetterCode(amino)&&iAmino<rrAtomF.length) rNams[iAmino]=rnam;
                    }
                    iAminoRaw++;
                    if(anum!=(vHet!=null?iAtom0123:iAtom)+1) rAnumsDiff=true;
                    _bufrAnums[iAmino]=anumFst=anum;
                    if(insc!=0) (rIns==null?rIns=new byte[rrAtomF.length]:rIns)[iAmino]=(byte)insc;
                    if(iAmino+1!=(rNums[iAmino]=rnum)) needRnum=true;
                }/*X newAmino*/
/*X Elements (C,N,O,MG),Atoms (CA,CB,N,O) and Atom index offsets (0,1,2,3) are stored in Arrays for each residue individual only if non standard data occus. */
                if(sze(_bufAtom)<=iAtom0123){
                    _bufAtom=chSze(bufAtom,iAtom0123+99);
                    _bufElmn=chSze(bufElmn,iAtom0123+99);
                    _bufAnum=chSze(bufAnum,iAtom0123+99);
                    if(bufAtom!=null) bufAtom=_bufAtom;
                    if(bufAnum!=null) bufAnum=_bufAnum;
                    if(bufElmn!=null) bufElmn=_bufElmn;
                }
                if(bufAtom==null && (aaOlc==null || aaOlc.length<=iAtom0123 || atom!=aaOlc[iAtom0123])){
                    bufAtom=_bufAtom;
                    if(iAtom0123>1) System.arraycopy(aaOlc,0,bufAtom,0,iAtom0123);
                }
                if(bufElmn==null && (eeOlc==null || eeOlc.length<=iAtom0123 || elem!=eeOlc[iAtom0123])){
                    bufElmn=_bufElmn;
                    if(iAtom0123>1) System.arraycopy(eeOlc,0,bufElmn,0,iAtom0123);
                }
                if(bufAnum==null && anum!=anumFst+iAtom0123) count01234(0,bufAnum=_bufAnum,0,iAtom0123);
                if(bufAtom!=null) bufAtom[iAtom0123]=atom;
                if(bufElmn!=null) bufElmn[iAtom0123]=(short)elem;
                if(bufAnum!=null) bufAnum[iAtom0123]=anum-anumFst;
/*S Increment the counters. They equal the numbers of atoms */
                iAtom0123++;
                if(0!=(atomAndFlags&FLAG_END)){/*X Finish Residue*/
                    //putln(DEBUG_NOW+" Finish Residue "+bufElmn);
                    if(iAmino<rrAtomF.length){
                        if(bufAtom!=null) (vHet!=null||rrAtoms==null?rrAtoms=new int[rrAtomF.length][]:rrAtoms)[iAmino]=cpyArry(bufAtom,0,iAtom0123);
                        if(bufAnum!=null) (vHet!=null||rrAnums==null?rrAnums=new int[rrAtomF.length][]:rrAnums)[iAmino]=cpyArry(bufAnum,0,iAtom0123);
                        if(bufElmn==null && eeOlc!=null && eeOlc.length!=iAtom0123) bufElmn=cpyArry(eeOlc,0,iAtom0123); /*X Test by deleting one single ATOM line in PDB file */
                        if(bufElmn!=null) (vHet!=null||rrElmns==null?rrElmns=new short[rrAtomF.length][]:rrElmns)[iAmino]=cpyArry(bufElmn,0,iAtom0123);
                    }
                    //putln(DEBUG_NOW+"iAmino="+iAmino+" iAtom0123="+iAtom0123+" "+(bufAtom!=null)+(_bufAtom!=null));
                    final int nA=iAtom+1-iAtom0123;
                    if(vHet==null&& iAmino<rrAtomF.length) rrAtomF[iAmino]=nA;
                    if(vHet!=null || iAtom+1==nAtom){/*X To Protein*/
                        if(vHet!=null){
                            (p=new Protein()).setIntProperty(PROTEINI_CHAINTYPE,CHAINTYPE_HET);
                            p.setProperty(P_TITLE,_mapHet.get(io(rnam)));
                            p.setFile(_txt.getFile());
                            p.setPdbID(PDBID_ID,_id4);
                            p.setChain(wantChain==0||wantChain==' '?"_":s(pdbTmpClr().aBytes(wantChain)));
                            p.setChain(s(pdbTmpClr().aBytes(chain)));
                            p.setAtoms(cpyArry(_xyz,3*nA,(1+iAtom)*3),new int[]{0},rrAtoms,rrElmns);
                            p.setResidueName32(new int[]{rnam});
                            p.setName(pdbTmpClr().aBytes(rnam).aa('_',rNums[0],":",p.getChain()).del(' '));
                        }else{
                            p.setAtoms(cpyArry(_xyz,0,(1+iAtom)*3),rrAtomF,rrAtoms,rrElmns);
                            p.setResidueName32(rNams);
                        }
                        if(needRnum) p.setResn(cpyArry(rNums,0,rrAtomF.length),rIns);
                        p.setChainsByType(_chainsByType);
                        p.setAtomSerial(rAnumsDiff?cpyArry(_bufrAnums,0,rrAtomF.length):null,rrAnums);
                        if(vHet!=null) vHet.add(p);
                        else p.setChainsByType(_chainsByType);
                    }
#if 0
                    if(iAtom0123>sze(iThShorts(iAmino,rrElmns))){
                        err(PDB_WRN).aa(" NUM_ATOMS_EXCEEDS_LIMIT ",sze(iThShorts(iAmino,rrElmns)),": ",iAminoRaw,'/',iAmino,':',(char)_chain,' ',iAtom0123," rnam=").aBytes(rnam).a("  atom=").aBytes(atom).aln();
                        IF_MEIN_DEBUG(exitOnErr());;
                    }
#endif //0
                    iAtom0123=0;
                }
#undef chain
#undef rnum
#undef elem
#undef atomAndFlags
#undef atom
#undef insc
            }/*X for*/
            return spp(vHet);
        }/*X parseAtom*/
        private static int[]seqresAlignment(byte[]aa,byte[]ss){
            //        final byte[]aligned[]=needlemanWunsch(aa,ss,null,-11,-1,-111,-11),ggA=aligned[0],ggS=aligned[1];
            final byte[]aligned[]=needlemanWunsch(aa,ss,null,-5,0,-20,0),ggA=aligned[0],ggS=aligned[1];
            _seqresAli=redim(_seqresAli,aa.length+ss.length,99);
            int countA=0;
            boolean error=false;
            for(int countS=0,colL=maxi(ggA.length,ggS.length),c=0;c<colL && countA<aa.length;c++){
                final byte cA=ggA[c],cS=ggS[c];
                if(cA>='A'){
                    _seqresAli[countA++]=countS;
                    if(ggS[countS]<'A') error=true;
                }
                if(cS>='A') countS++;
            }
            if(error){
                err(PDB_WRN).aln("seqresAlignment");
                aliToTxt(ALITXT_FOLD_100|ALITXT_PFX_SEQRES_ATOMS|ALITXT_ANSI,new byte[][]{ggS,ggA},err(PDB_ERR).aln()).aln();
            }
            if(countA<aa.length) _seqresAli[countA]=0;
            return _seqresAli;
        }
        private static boolean isWater(byte[]T,int b){/*X  HOH HHO H2O OHH */
            final int c0=T[b];
            if(c0=='H'||c0=='D'||c0=='O'){
                final int c1=T[b+1],c2=T[b+2];
                if(c0=='H') return(c1=='H'||c1=='2')&&c2=='O'||c1=='O'&&c2=='H';
                if(c0=='D') return(c1=='D'||c1=='2')&&c2=='O'||c1=='O'&&c2=='D';
                return c1=='D'&&c2=='D'||c1=='H'&&c2=='H';
            }
            return false;
        }
        private static void setFstAndLastLineForChain(int line,int chain){
            if(FST_LINE_OF_CHAIN[0]>line) FST_LINE_OF_CHAIN[0]=line;
            if(LST_LINE_OF_CHAIN[0]<line) LST_LINE_OF_CHAIN[0]=line;
            if(chain<='z'){
                if(LST_LINE_OF_CHAIN[chain]<line) LST_LINE_OF_CHAIN[chain]=line;
                if(FST_LINE_OF_CHAIN[chain]>line) FST_LINE_OF_CHAIN[chain]=line;
            }
        }
        private static void _secStruAdd(IF_MEIN_DEBUG(int iL,)char type,
                                        IF_MEIN_DEBUG(int name1,)int rn1,int ins1,
                                        IF_MEIN_DEBUG(int name2,)int rn2,int ins2){
            if((ins1=_T[ins1])<'A') ins1=0;
            if((ins2=_T[ins2])<'A') ins2=0;
            rn1=atoi(_T,rn1);
            rn2=atoi(_T,rn2);
            UNLESS_MEIN_DEBUG(int f=_p.resnToIdx(RESIDUE_FULL,rn1,(char)ins1));;
            UNLESS_MEIN_DEBUG(int t=_p.resnToIdx(RESIDUE_FULL,rn2,(char)ins2));;
#if CPP_WITH_MEIN_DEBUG
            final BA sb=baClr(121);
            int f=_p.resnToIdxErr(rn1,(char)ins1,charsToBitsStopAtSpace(_T,name1),sb);
            int t=_p.resnToIdxErr(rn2,(char)ins2,charsToBitsStopAtSpace(_T,name2),sb);
            if(sze(sb)>0){
                err(PDB_ERR).aa("secStruAdd ",sb).aln();
                errLine(iL,0x0101);
                if(__it==SPARSER_CIF) exitOnErr();
            } else
#endif //CPP_WITH_MEIN_DEBUG
                {
                    if(f>t&&t>=0) {final int tmp=f;f=t;t=tmp;}/*X  Swap */
                    if(f>=0){
                        if(_secStr.length<=t+1) _secStr=chSze(_secStr,t+999);
                        Arrays.fill(_secStr,f,t+1,(byte)type);
                    } IF_MEIN_DEBUG(else err(PDB_ERR).a("secStruAdd f<0 ").aFromDashTo(f,t).aln());
                }
        }
        private static void _anno(int tol IF_MEIN_DEBUG(,int line)){
            final int count=(tol>>>8)+1;
            tol&=255;
            final BA sb=baClr(122),res=baClr(169) IF_MEIN_DEBUG(,err=baClr(123));
            boolean needResn=count>1;
            String name=null,group=null;
            boolean other=false;
            switch(tol){
            case PDB_CONN_COVALE:
                name="Covalent";
                group="Bond";
                break;
            case PDB_CONN_SALTBR:/*X 1A28*/
                name="Salt_bridge";
                group="Bond";
                break;
            case PDB_CONN_HYDROG:/*X 1A54*/
                name="Hydrogen_bond";
                group="Bond";
                break;
            case PDB_CONN_METALC:
                name="Metal_binding";
                group="Metal";
                break;
            case PDB_CISPEP:
                group=name="Cis_conformation";
                break;
            case PDB_SSBOND:/*X 2a6c*/
                name="Disulfide_bond";
                group="Bond";
                break;
            case PDB_SITE:
                group=name="Site";
                break;
            default:
                other=true;
            }
            int k=0;
            for(int i=0;i<count;i++,k+=4){
                if(isWater(_T,RESNUM[k])) continue;
                final int nam=charsToBitsStopAtSpace(_T,RESNUM[k]),resn=atoi(_T,RESNUM[k+1]),ins=RESNUM[k+2]==0?0:_T[RESNUM[k+2]],chain=RESNUM[k+3];
                if(chain==_chain && toThreeLetterCode(toOneLetterCode(nam))==nam){
#define INS ins==' '?'_':ins=='?'?'_':(char)ins
                    final int toIdx=_p.IF_MEIN_DEBUG(resnToIdxErr(resn,INS,nam,err)) UNLESS_MEIN_DEBUG(resnToIdx(RESIDUE_FULL,resn,INS));
#undef INS
                    if(toIdx==RESN_TO_IDX_FAILED) continue;
                    if(toIdx==RESN_TO_IDX_IS_HETERO) res.a(" Hetero ");
                }else{
                    needResn=true;
                }
                final int end=sb.end();
                sb.a(resn).aLetterDigit(ins).a(':');
                res.aBytes(nam).a(' ').aFT(sb,end,MAX_INT).aLetterDigit(chain).a(' ');
                sb.a(' ');
            }
            if(sb.trim().end()>0){
                if(other){
                    String details=toStrgTrim(_T,RESNUM[k++],RESNUM[k++]);
                    if(sze(details)<2) details=null;
                    if(tol==PDB_SITE){
                        if((name=details)==null) name=s(res);
                        group="Site";
                        mapGetBA(details,_mapSite).a(sb);
                        return;
                    }else if(tol==PDB_MODRES){
                        name=group="Modified_residue";
                        if(details!=null){
                            name=details;
#if CPP_WITH_MEIN_DEBUG
                            if(name==(name=sftrMapSynonyms(0,name))){
                                err(PDB_WRN).aa("PDB_MODRES=",name).a(" details=").a(details).aln();
                                errLine(line,0x0101);
                            }
#endif //CPP_WITH_MEIN_DEBUG
                        }
                    }else{
                        group="Conn";
                    }
                }
#if CPP_WITH_MEIN_DEBUG
            if(sze(err)>0){
                if(sze(err)>0) err(PDB_WRN).aa("mkAnno",name,' ',err).aln();
                errLine(line,0x0101);
            }
#endif //CPP_WITH_MEIN_DEBUG
            if(_resanUniq.add(s(baClr(124).aa(sb,' ',name,' ',group,' ',needResn?res:null)))) annotateSeqStyleRgbPosNameGrp(_p,SSTYLE_UNDERLINE,0,sb,name,group).annoAdd(IRESAN_SRC,dbColonId()).annoAdd(IRESAN_BALLOON,needResn?res:null);
            }
        }
/* <<<  <<< */
/* ---------------------------------------- */
/* >>>  >>> */
        private final static Matrix3D[]STRUCT_OPER_LIST=new Matrix3D[STRUCT_OPER_LIST_SIZE];
/* @param matrices: */
/* CIF-format: int[]corresponding to m._matrixNum */
/* PDB-format: Matrix3D[] */
        private static void combineAssemblyIdMatricesAndChains(int assemblyID,Matrix3D[]mm,String[]chains){
            final Object[]e=new Object[ASSEMBLY_ZZZ];
            e[ASSEMBLY_ID]=io(assemblyID);
            e[ASSEMBLY_CHAINS]=chains;
            ROFi0(sze(e[ASSEMBLY_MATRICES]=mm)){
                if(mm[i]!=null) mm[i]._assemblyID=assemblyID;
            }
            _vAssemblies.add(e);
        }
        private static void addToStructOperList(int num,
                                                int xx,int xy,int xz,int xo,
                                                int yx,int yy,int yz,int yo,
                                                int zx,int zy,int zz,int zo){
            final Matrix3D m=new Matrix3D(atof(_T,xx,_E),atof(_T,xy,_E),atof(_T,xz,_E),atof(_T,xo,_E),
                                          atof(_T,yx,_E),atof(_T,yy,_E),atof(_T,yz,_E),atof(_T,yo,_E),
                                          atof(_T,zx,_E),atof(_T,zy,_E),atof(_T,zz,_E),atof(_T,zo,_E));
            final int i=num>=0?num:idxOf(null,STRUCT_OPER_LIST);
            if(i>=0&&i<STRUCT_OPER_LIST_SIZE) STRUCT_OPER_LIST[i]=m;
        }
        private static void biomtFinally(){
            if(sze(_vAssemblies)>0) _p.setProperty(PROTEINO_BIOMT,toArry(_vAssemblies,NO_Objects));
        }
/* <<< BIOMT <<< */
/* ---------------------------------------- */
/* >>> xrefs >>> */
        private static void _setUniprot(IF_MEIN_DEBUG(int iL,) int posDb,int posId){
            final int db=charsToBitsStopAtSpace(_T,posDb);
            if(db==('N'|('O'<<8)|('R'<<16))) return;
            final int
                GB=  'G'|('B'<<8),
                gb=  'g'|('b'<<8),
                PDB ='P'|('D'<<8)|('B'<<16),
                GENP='G'|('E'<<8)|('N'<<16)|('P'<<24);
            final boolean isUniProt=
                db==('S'|('W'<<8)|('S'<<16))||
                db==('U'|('N'<<8)|('P'<<16))||
                db==('T'|('R'<<8)|('E'<<16)|('M'<<24)) || db==0;
            if(db==PDB && strEquAt(STR_IC,_id4,_T,posId)){
            }else if(db==GENP || isUniProt || db==GB || db==gb || db==PDB||
                     db==('P'|('I'<<8)|('R'<<16))||
                     db==('E'|('M'<<8)|('B'<<16)|('L'<<24))){
                final BA sb=pdbTmpClr();
                if(isUniProt) sb.a("UNIPROT");
                else if(db==GENP) sb.a("GenPept");
                else sb.aBytes(db==gb?GB:db);
                _p.addSeqRef(0,s(sb.a(':').a(wordAt(_T,posId))));
            }else{
                err(PDB_WRN).a("setUniprot UNKNOWN_DB=").aBytes(db).aln();
                errLine(iL,0);
            }
        }
    }
#undef errLine
#undef exitOnErr
#undef THIS_CLASS
