/** @author Christoph Gille */
#define PREFIX_SIZE 2048
#define _posGetInt(field)  atoi(_T,_pos(field))
/* (NUM1 3) */
#define CIFe_id 3
#define CIFe_pdbx_description 4
#define CIFe_pdbx_ec 5
#define CIFas_B_iso_or_equiv 6
#define CIF_AS_FIRST CIFas_B_iso_or_equiv
#define CIFas_label_seq_id 7
#define CIFas_Cartn_x 8
#define CIFas_Cartn_y 9
#define CIFas_Cartn_z 10
#define CIFas_auth_asym_id 11
#define CIFas_auth_atom_id 12
#define CIFas_auth_comp_id 13
#define CIFas_auth_seq_id 14
#define CIFas_id 15
#define CIFas_label_alt_id 16
#define CIFas_label_asym_id 17
#define CIFas_pdbx_PDB_ins_code 18
#define CIFas_pdbx_PDB_model_num 19
#define CIFas_type_symbol 20
#define CIF_AS_LAST CIFas_type_symbol
#define CIFs_entry_id 21
#define CIFs_pdbx_descriptor 22
#define CIFs_title 23
#define CIFsc_beg_auth_comp_id 24
#define CIFsc_beg_auth_seq_id 25
#define CIFsc_end_auth_asym_id 26
#define CIFsc_beg_auth_asym_id 27
#define CIFsc_end_auth_comp_id 28
#define CIFsc_end_auth_seq_id 29
#define CIFsc_pdbx_beg_PDB_ins_code 30
#define CIFsc_pdbx_end_PDB_ins_code 31
#define CIFssr_beg_auth_comp_id 32
#define CIFssr_beg_auth_seq_id 33
#define CIFssr_beg_auth_asym_id 34
#define CIFssr_end_auth_asym_id 35
#define CIFssr_end_auth_comp_id 36
#define CIFssr_end_auth_seq_id 37
#define CIFssr_pdbx_beg_PDB_ins_code 38
#define CIFssr_pdbx_end_PDB_ins_code 39
#define CIFep_entity_id 40
#define CIFep_pdbx_seq_one_letter_code 41
#define CIFep_pdbx_strand_id 42
#define CIFep_type 43
#define CIFss_id 44
#define CIFss_details 45
#define CIFss_pdbx_evidence_code 46
#define CIFssg_site_id 47
#define CIFssg_pdbx_auth_ins_code 48
#define CIFssg_auth_seq_id 49
#define CIFssg_auth_comp_id 50
#define CIFssg_auth_asym_id 51
#define CIFesg_pdbx_gene_src_scientific_name 52
#define CIFesg_entity_id 53
#define CIFesg_pdbx_gene_src_ncbi_taxonomy_id 54
#define CIFpsmr_auth_asym_id 55
#define CIFpsmr_auth_seq_id 56
#define CIFpsmr_auth_comp_id 57
#define CIFpsmr_PDB_ins_code 58
#define CIFpsmr_parent_comp_id 59
#define CIFpsmr_details 60
#define CIFsmpc_pdbx_PDB_ins_code_2 61
#define CIFsmpc_pdbx_auth_comp_id_2 62
#define CIFsmpc_pdbx_auth_seq_id_2 63
#define CIFsmpc_pdbx_auth_asym_id_2 64
#define CIFsco_conn_type_id 65
#define CIFsco_ptnr1_auth_asym_id 66
#define CIFsco_ptnr1_auth_comp_id 67
#define CIFsco_ptnr1_auth_seq_id 68
#define CIFsco_ptnr2_auth_asym_id 69
#define CIFsco_ptnr2_auth_comp_id 70
#define CIFsco_ptnr2_auth_seq_id 71
#define CIFesn_entity_id 72
#define CIFesn_common_name 73
#define CIFesn_pdbx_organism_scientific 74
#define CIFpsag_assembly_id 75
#define CIFpsag_oper_expression 76
#define CIFpsag_asym_id_list 77
#define CIFpsol_id 78
#define CIFpsol_type 79
#define CIFpsol_name 80
#define CIFpsol_symmetry_operation 81
#define CIFpsol_matrix11 82
#define CIFpsol_matrix12 83
#define CIFpsol_matrix13 84
#define CIFpsol_vector1 85
#define CIFpsol_matrix21 86
#define CIFpsol_matrix22 87
#define CIFpsol_matrix23 88
#define CIFpsol_vector2 89
#define CIFpsol_matrix31 90
#define CIFpsol_matrix32 91
#define CIFpsol_matrix33 92
#define CIFpsol_vector3 93
#define CIFsr_db_name 94
#define CIFsr_db_code 95
#define CIFsr_pdbx_db_accession 96
#define CIFsr_entity_id 97
#define CIFcc_id 98
#define CIFcc_name 99
#define CIFcc_type 100
#define CIF_TYPES 101

@*SARRAYeq_CIFParser_CIF_FEATURES
 chem_comp.id=CIFcc_id
 chem_comp.type=CIFcc_type
 chem_comp.name=CIFcc_name
 entity.pdbx_description=CIFe_pdbx_description
 entity.id=CIFe_id
 entity.pdbx_ec=CIFe_pdbx_ec
 atom_site.B_iso_or_equiv=CIFas_B_iso_or_equiv
 atom_site.label_seq_id=CIFas_label_seq_id
 atom_site.Cartn_x=CIFas_Cartn_x
 atom_site.Cartn_y=CIFas_Cartn_y
 atom_site.Cartn_z=CIFas_Cartn_z
 atom_site.auth_asym_id=CIFas_auth_asym_id
 atom_site.auth_seq_id=CIFas_auth_seq_id
 atom_site.id=CIFas_id
 atom_site.label_alt_id=CIFas_label_alt_id
 atom_site.label_asym_id=CIFas_label_asym_id
 atom_site.auth_atom_id=CIFas_auth_atom_id
 atom_site.auth_comp_id=CIFas_auth_comp_id
 atom_site.pdbx_PDB_ins_code=CIFas_pdbx_PDB_ins_code
 atom_site.pdbx_PDB_model_num=CIFas_pdbx_PDB_model_num
 atom_site.B_iso_or_equiv=CIFas_B_iso_or_equiv
 atom_site.type_symbol=CIFas_type_symbol
 entity_poly.entity_id=CIFep_entity_id
 entity_poly.pdbx_seq_one_letter_code=CIFep_pdbx_seq_one_letter_code
 entity_poly.pdbx_strand_id=CIFep_pdbx_strand_id
 entity_poly.type=CIFep_type
 struct_conf.beg_auth_seq_id=CIFsc_beg_auth_seq_id
 struct_conf.beg_auth_comp_id=CIFsc_beg_auth_comp_id
 struct_conf.end_auth_comp_id=CIFsc_end_auth_comp_id
 struct_conf.end_auth_seq_id=CIFsc_end_auth_seq_id
 struct_conf.pdbx_beg_PDB_ins_code=CIFsc_pdbx_beg_PDB_ins_code
 struct_conf.pdbx_end_PDB_ins_code=CIFsc_pdbx_end_PDB_ins_code
 struct_conf.beg_auth_asym_id=CIFsc_beg_auth_asym_id
 struct_conf.end_auth_asym_id=CIFsc_end_auth_asym_id
 struct_sheet_range.beg_auth_asym_id=CIFssr_beg_auth_asym_id
 struct_sheet_range.beg_auth_comp_id=CIFssr_beg_auth_comp_id
 struct_sheet_range.beg_auth_seq_id=CIFssr_beg_auth_seq_id
 struct_sheet_range.end_auth_asym_id=CIFssr_end_auth_asym_id
 struct_sheet_range.end_auth_comp_id=CIFssr_end_auth_comp_id
 struct_sheet_range.end_auth_seq_id=CIFssr_end_auth_seq_id
 struct_sheet_range.pdbx_beg_PDB_ins_code=CIFssr_pdbx_beg_PDB_ins_code
 struct_sheet_range.pdbx_end_PDB_ins_code=CIFssr_pdbx_end_PDB_ins_code
 struct_site_gen.auth_seq_id=CIFssg_auth_seq_id
 struct_site_gen.auth_comp_id=CIFssg_auth_comp_id
 struct_site_gen.auth_asym_id=CIFssg_auth_asym_id
 struct_site.details=CIFss_details
 struct_site.id=CIFss_id
 struct_site.pdbx_evidence_code=CIFss_pdbx_evidence_code
 struct_site_gen.site_id=CIFssg_site_id
 struct_site_gen.pdbx_auth_ins_code=CIFssg_pdbx_auth_ins_code
 entity_src_gen.entity_id=CIFesg_entity_id
 entity_src_gen.pdbx_gene_src_scientific_name=CIFesg_pdbx_gene_src_scientific_name
 entity_src_gen.pdbx_gene_src_ncbi_taxonomy_id=CIFesg_pdbx_gene_src_ncbi_taxonomy_id
 pdbx_struct_mod_residue.parent_comp_id=CIFpsmr_parent_comp_id
 pdbx_struct_mod_residue.PDB_ins_code=CIFpsmr_PDB_ins_code
 pdbx_struct_mod_residue.details=CIFpsmr_details
 pdbx_struct_mod_residue.auth_comp_id=CIFpsmr_auth_comp_id
 pdbx_struct_mod_residue.auth_asym_id=CIFpsmr_auth_asym_id
 pdbx_struct_mod_residue.auth_seq_id=CIFpsmr_auth_seq_id
 struct_mon_prot_cis.pdbx_auth_seq_id_2=CIFsmpc_pdbx_auth_seq_id_2
 struct_mon_prot_cis.pdbx_auth_comp_id_2=CIFsmpc_pdbx_auth_comp_id_2
 struct_mon_prot_cis.pdbx_PDB_ins_code_2=CIFsmpc_pdbx_PDB_ins_code_2
 struct_mon_prot_cis.pdbx_auth_asym_id_2=CIFsmpc_pdbx_auth_asym_id_2
 struct_conn.conn_type_id=CIFsco_conn_type_id
 struct_conn.ptnr1_auth_asym_id=CIFsco_ptnr1_auth_asym_id
 struct_conn.ptnr1_auth_comp_id=CIFsco_ptnr1_auth_comp_id
 struct_conn.ptnr1_auth_seq_id=CIFsco_ptnr1_auth_seq_id
 struct_conn.ptnr2_auth_asym_id=CIFsco_ptnr2_auth_asym_id
 struct_conn.ptnr2_auth_comp_id=CIFsco_ptnr2_auth_comp_id
 struct_conn.ptnr2_auth_seq_id=CIFsco_ptnr2_auth_seq_id
 entity_src_nat.entity_id=CIFesn_entity_id
 entity_src_nat.common_name=CIFesn_common_name
 entity_src_nat.pdbx_organism_scientific=CIFesn_pdbx_organism_scientific
 pdbx_struct_assembly_gen.assembly_id=CIFpsag_assembly_id
 pdbx_struct_assembly_gen.asym_id_list=CIFpsag_asym_id_list
 pdbx_struct_assembly_gen.oper_expression=CIFpsag_oper_expression
 pdbx_struct_oper_list.id=CIFpsol_id
 pdbx_struct_oper_list.matrix[1][1]=CIFpsol_matrix11
 pdbx_struct_oper_list.matrix[1][2]=CIFpsol_matrix12
 pdbx_struct_oper_list.matrix[1][3]=CIFpsol_matrix13
 pdbx_struct_oper_list.matrix[2][1]=CIFpsol_matrix21
 pdbx_struct_oper_list.matrix[2][2]=CIFpsol_matrix22
 pdbx_struct_oper_list.matrix[2][3]=CIFpsol_matrix23
 pdbx_struct_oper_list.matrix[3][1]=CIFpsol_matrix31
 pdbx_struct_oper_list.matrix[3][2]=CIFpsol_matrix32
 pdbx_struct_oper_list.name=CIFpsol_name
 pdbx_struct_oper_list.symmetry_operation=CIFpsol_symmetry_operation
 pdbx_struct_oper_list.type=CIFpsol_type
 pdbx_struct_oper_list.vector[1]=CIFpsol_vector1
 pdbx_struct_oper_list.vector[2]=CIFpsol_vector2
 pdbx_struct_oper_list.vector[3]=CIFpsol_vector3
 pdbx_struct_oper_list.matrix[3][3]=CIFpsol_matrix33
 struct_ref.db_name=CIFsr_db_name
 struct_ref.pdbx_db_accession=CIFsr_pdbx_db_accession
 struct_ref.db_code=CIFsr_db_code
 struct_ref.entity_id=CIFsr_entity_id
 struct.title=CIFs_title
 struct.pdbx_descriptor=CIFs_pdbx_descriptor
 struct.entry_id=CIFs_entry_id
*@

static {assert PDB_ATOM<3 && PDB_HETATM<3;}
private final static byte[][]STRING=new byte[CIF_TYPES][];
private final static int[]
TOK_B=new int[256],
    TOK_E=new int[256],
    LINE=new int[CIF_TYPES],
    COLUMN=new int[CIF_TYPES],
    COLS=new int[CIF_TYPES],
    BODY=new int[CIF_TYPES],
    HC=new int[CIF_TYPES],
    PREFIX_HC=new int[CIF_TYPES];

#if CPP_WITH_MEIN_DEBUG
#define DEBUG_EXIT_BEFORE_ATOM_LINES(a)
#else
#define DEBUG_EXIT_BEFORE_ATOM_LINES(a)
#endif //CPP_WITH_MEIN_DEBUG
private final static boolean[]PREFIX_USED=new boolean[PREFIX_SIZE];
private static Poly _polymer[],_poly;
private static long _prepareMC;
private static boolean _isCif;
private static int _initalized;
static{
    if(_initalized++==0){
        final String[]ss=arry(SARRAYeq_CIFParser_CIF_FEATURES);
        ROFi0(CIF_TYPES){
            final byte[]bb=STRING[i]=toByts(ss[i]);
            if(bb!=null){
            HC[i]=hashCd(bb,0,MAX_INT);
            PREFIX_USED[PREFIX_HC[i]=prefixHC(bb,0,bb.length)]=true;
            }
        }
    }
}
/* <<< 40980 <<< */
/* ---------------------------------------- */
/* >>> Parsing >>> */
private String[][]_parseCIF(int opt,String wantChain,BA txt,Protein p){
    if(!_prepareCIF(txt)) return null;
    if(wantChain==null || p==null) return _chainsByType;
    final int chain=beginOrEnd(wantChain,p);
    Poly poly=null;
    for(Poly p1:_polymer){
        if(idxOf(chain,p1._chains)>=0){
            _poly=poly=p1;
            break;
        }
    }
    if(poly==null){
        err(PDB_ERR).a("Missing polymer for chain ").aln(wantChain);
        exitOnErr();
        return null;
    }
    if(null==_poly._res){
        cifValues(CIFep_entity_id|(CIFep_entity_id<<16));
        cifValues(CIFesg_entity_id|(CIFesg_entity_id<<16));
        cifValues(CIFesn_entity_id|(CIFesn_entity_id<<16));
        cifValues(CIFe_id|(CIFe_id<<16));
        cifValues(CIFe_pdbx_ec);
        if(sze(_title)==0) cifValues(CIFs_entry_id);
    }
    if(0==(opt&PROTPARS_NO_SEQRES)) _seqres.a(_poly._res);
    parseAtoms(chain,p);
    cifValues(CIFpsmr_details| (CIFpsmr_auth_asym_id)<<8);/*X PDB_MODRES*/
    cifValues(CIFsmpc_pdbx_auth_seq_id_2| (CIFsmpc_pdbx_auth_asym_id_2)<<8);/*X PDB_CISPEP*/
    cifValues(CIFsco_ptnr1_auth_seq_id);/*X SSBOND*/
    cifValues(CIFsc_beg_auth_seq_id| (CIFsc_end_auth_asym_id<<8));/*X HELIX*/
    cifValues(CIFssr_beg_auth_seq_id| (CIFssr_end_auth_asym_id<<8));/*X SHEET*/
#if CPP_DEACTIVATED
    cifValues(CIFss_id);/*X SITE*/ /* TODO  See 1nrg  However 1sbt does not give active site trias */
    cifValues(CIFssg_site_id| (CIFssg_auth_asym_id)<<8);/*X SITE*/
#endif //CPP_DEACTIVATED
    cifValues(CIFsr_entity_id| (CIFsr_entity_id<<16));/*X DBREF*/
    p.setProperty(PROTEINO_EC,_T,(int)(poly._ec>>>RANGEFROM_SHIFT),(int)(poly._ec&RANGETO_MASK));
    p.setProperty(P_ORGANISM_SC,poly._orgSc);
    p.setProperty(P_ORGANISM,poly._org);
    p.setProperty(P_COMPOUND,poly._descr);
    p.setIntProperty(PROTEINI_TAXID,poly._taxId);
    beginOrEnd(null,null);
    cifValues(CIFcc_id);
    return _chainsByType;
}/*X parse*/
/* <<< Polymer Class <<< */
/* ---------------------------------------- */
/* >>> Parsing >>> */
private static boolean _prepareCIF(BA txt){
    if(_prepareMC!=(_prepareMC=MC_FOR_TXT(txt))){
        final int[]eol=txt.eol();
        final byte[]T=txt.bytes();
        _typeOfLine=redim(_typeOfLine,eol.length+1,99|REDIM_CLEAR_ARRAY);
        _isCif=false;
        {
            final boolean[]lettr_digt_us=chrClas(LETTR_DIGT_US);
            long already=0;
        line:
            for(int count=0,iL=1;iL<eol.length;iL++){
                final int b=eol[iL-1]+1,e=eol[iL];
                if(e-b>11 && T[b]=='_'&&T[b+1]=='a'&&T[b+2]=='t'&&T[b+3]=='o'&&T[b+4]=='m'&&T[b+5]=='_'&&T[b+6]=='s'&&T[b+10]=='.'){
                    ROFi0(CIF_AS_LAST-CIF_AS_FIRST+1){
                        if(0!=(already&(1<<i))) continue;
                        final byte[]bb=STRING[i+CIF_AS_FIRST];
                        if(e-b>=bb.length && isChrClas(lettr_digt_us,T,b+bb.length) && !isChrClas(lettr_digt_us,T,b+bb.length+1) && strEquAt(0,bb,T,b+1)){
                            if(count++>8) {_isCif=true; break line;}/*X CIF if at least 8 of those entries found */
                            already|=(1<<i);
                        }
                    }
                }
            }
        }
        if(!_isCif) return false;
        _init(SPARSER_CIF,txt);
        clr(BODY);
        _polymer=new Poly[0];
        int loopXYZ=0,eLXYZ=0;
        {/*X Store specific Lines and Loop positions */
            java.util.Arrays.fill(LINE,-1);
            java.util.Arrays.fill(COLUMN,-1);
            final boolean[]no_spc=chrClas(-SPC);
            for(int iL=1,loop=0,body=0;iL<eol.length;iL++){
                final int b=eol[iL-1]+1,e=eol[iL];
                if(e==b) continue;
                if(b>=T.length){
                    IF_MEIN_DEBUG(err(PDB_ERR).aa(" T=",T.length," b=",b).aln());;
                    break;
                }
                final byte c0=T[b];
                if(c0=='#' && nxt(no_spc,T,b+1,e)<0){
                    if(loop!=0 && loop==loopXYZ) eLXYZ=iL;
                    loop=body=0;
                }else if(c0=='l' && e-b>4 && T[b+1]=='o'&&T[b+2]=='o'&&T[b+3]=='p'&&T[b+4]=='_' && isChrClas(SPC,T,b+5) &&  PREFIX_USED[prefixHC(T,e+2,eol[iL+1])]){
                    loop=iL;
                    FORjL(iL+1,eol.length){
                        final byte l0=T[eol[jL-1]+1];
                        if(l0=='#') break;
                        else if(l0!='_' && body==0) body=jL;
                    }
                }else if(c0=='_' && e-b>3){
                    final int spc=strchr(STR_E|' ',T,b,e),hash=hashCd(T,b+1,spc);
                    if(e-b>12 && CPP_HASHCD("entry.id")==hash && strEquAt(0,"entry.id ",T,b+1)) _id4=toStrgTrim(T,b+10,e);
                    else{
                        ROFi0(CIF_TYPES){
                            final byte[]s=STRING[i];
                            if(s!=null && spc==b+1+s.length && hash==HC[i] && strEquAt(0,s,T,b+1)){
                                LINE[i]=iL;
                                if(loop>0 && nxt(no_spc,T,b+s.length+1,e)<0){
                                    COLUMN[i]=iL-loop-1;
                                    COLS[i]=(BODY[i]=body)-loop-1;
                                    if(i==CIFas_Cartn_x) loopXYZ=loop;
                                }
                                _typeOfLine[iL]=(byte)i;
                                break;
                            }
                        }
                    }
                }
            }/*X for*/
        }
        DEBUG_EXIT_BEFORE_ATOM_LINES(err(PDB_INFO).a(ANSI_RED+"EXIT_BEFORE_ATOM_LINES"+ANSI_RESET).special(DIE_NOW));;
        xyzLines(loopXYZ,eLXYZ);
        cifValues(CIFep_type);/*X  Only this one at preparation */
        //IF_MEIN_DEBUG(for(Poly p:_polymer) baOut(DEBUG_LONGER).a(_id4).a(' ').a(polyToStrg(p)).aln());
        IF_MEIN_DEBUG(if(_polymer.length==0) exitOnErr());;
        _chainsByType=newChainsByType(_id4);
        final BA sb=pdbTmpClr();
        FORi(CHAINTYPE_FST,CHAINTYPE_LST_PRIMARY+1){
            clr(sb);
            for(Poly p:_polymer){
                if(p._chainType==i) for(int c:p._chains) sb.aBytes(c).a(' ');
            }
            _chainsByType[i]=splitTkns(sb);
        }
        cifValues(CIFpsol_id);
        cifValues(CIFpsag_assembly_id);
        //IF_MEIN_DEBUG(if(sze(PDBParserTest._mapLabelToAsym)>0) baOut(DEBUG_LONGER).a(ANSI_INVERSE+"_mapLabelToAsym=").a(PDBParserTest._mapLabelToAsym).aln(ANSI_RESET));
    }
    return true;
}/*X prepare*/
private static boolean xyzLines(int loopXYZ,int eLXYZ){
    final byte[]T=_T;
    final int body=BODY[CIFas_Cartn_x];
    if(body==0){
        err(PDB_ERR).aa(" xyzLines "," missing ",STRING[CIFas_Cartn_x]).aln();
        exitOnErr();
        return false;
    }
/*X _fromCurrentCol is required for _xyzColumns(...) */
    _fromCurrentCol=redim(_fromCurrentCol,COLS[CIFas_Cartn_x],REDIM_CLEAR_ARRAY);
    _xyzColumns=redim(_xyzColumns,COLS[CIFas_Cartn_x],REDIM_CLEAR_ARRAY);
    clr(_fromCurrentCol);
    FORiL(loopXYZ+1,body){
        final int b=_eol[iL-1]+1,L=_eol[iL]-b;
        FORj(CIF_AS_FIRST,CIF_AS_LAST+1){
            if(L>STRING[j].length && isChrClas(SPC,T,b+1+STRING[j].length) && strEquAt(0,STRING[j],T,b+1)) _fromCurrentCol[iL-loopXYZ-1]=j;
        }
    }
    boolean aligned=true;
/*X All lines same length? */
    final int bBody=_eol[body-1]+1;
    {
        final int len=_eol[body]-bBody;
        for(int iL=body,e=bBody-1;iL<eLXYZ;iL++){/*X  Lines same length? */
            final int b=e+1;
            if((e=_eol[iL])-b!=len){
                aligned=false;
                IF_MEIN_DEBUG(if(onlyOnce(53)) {err(PDB_WRN).aa(" xyzLines ","MISALIGNED ","LINE_LENGTH_DIFFERS").aln();errLine(iL,0x0303);});;
            }
        }
/*X All columns aligned? */
        if(aligned){
            aligned=_xyzColumns(false,bBody);
            for(int j=CIF_AS_FIRST; aligned && j<=CIF_AS_LAST;j++){
                if(!(aligned=xyzAligned(T,bBody+_xyzColumns[j],len+1,eLXYZ-body))){
                    IF_MEIN_DEBUG(if(onlyOnce(54)) err(PDB_WRN).aa(" prepareXYZ ","MISALIGNED ",STRING[j]).aln());;
                }
            }
        }
    }
/*X ATOM or HETATM?  setFstAndLastLineForChain(...) */
    for(int iL=body,e=bBody-1,model=0;iL<eLXYZ;iL++){
        final int b=e+1; e=_eol[iL];
        final int c0=e-b<4?0:T[b];
        if(c0=='A'){
            if(T[b+1]=='T'&&T[b+2]=='O'&&T[b+3]=='M') _typeOfLine[iL]=PDB_ATOM;
        }else if(c0=='H' && e-b>5 && T[b+1]=='E'&&T[b+2]=='T'&&T[b+3]=='A'&&T[b+4]=='T'&&T[b+5]=='M') _typeOfLine[iL]=PDB_HETATM;
        //HETATM 5789 O "O5'" . GDP D 4 .   ? 2.961   55.057 -28.867 1.00 39.61  ? 355 GDP A "O5'" 1

/*X If not aligned then Recompute columns */
        if(!aligned && !_xyzColumns(true,b)){
            err(PDB_ERR).aa(" xyzLines "," _xyzColumns ").aln();
            errLine(iL,0x0103);
            exitOnErr();
        }
        {/*X ENDMDL 2JQU 1AXJ */
            final int pos=b+_xyzColumns[CIFas_pdbx_PDB_model_num];
            if(model==0) model=atoi(T,pos);
            if(T[pos]!='1' && atoi(T,pos)!=model){
                IF_MEIN_DEBUG(err(PDB_DONE).aa(" Stop after model ",model).aln(); errLine(iL,0x0103));;
                break;
            }
        }
        if(c0=='H'){/*X  Water */
            if(isWater(T,b+_xyzColumns[CIFas_auth_comp_id])) continue;
            setFstAndLastLineForChain(iL,PDB_HETATM);
        }
/*X First and last line */
        setFstAndLastLineForChain(iL,_chainOfLine[iL]=charsToBitsStopAtSpace(T,b+_xyzColumns[CIFas_auth_asym_id]));
        //baOut(DEBUG_NOW).aBytes(_chainOfLine[iL]).an(' ',4).aFT(T,b,e).aln();
        //_chainOfLine2[iL]=charsToBitsStopAtSpace(T,b+_xyzColumns[CIFas_label_asym_id]);
        //IF_MEIN_DEBUG(PDBParserTest.asymLabelAndAuth(charsToBitsStopAtSpace(T,b+_xyzColumns[CIFas_label_asym_id]),_chainOfLine[iL],b));
    }
    IF_MEIN_DEBUG(if(_xyzAligned=aligned) err(PDB_DONE).aa(" prepareXYZ ",ANSI_GREEN+"ALIGNED"+ANSI_RESET).aln());;
    return true;
}
private static boolean xyzAligned(byte[]T,int b,int len,int nL){
    for(int i=0;i<nL; i++,b+=len){
        if(T[b]==' '||T[b-1]!=' ') return false;
    }
    return true;
}
/* <<< Prepare: Main  <<< */
/* ---------------------------------------- */
/* >>> Prepare: Assemble Lines >>> */
private static int prefixHC(byte[]T,int b1,int e){
    if(b1<0 || e<=b1 || T==null) return 0;
    final int dot=strchr('.',T,b1,e);
    return dot<0?0: hashCd(T,b1,dot)%(PREFIX_SIZE/2)+PREFIX_SIZE/2;
}
/* <<< Prepare: Assemble Lines <<< */
/* ---------------------------------------- */
/* >>> One atom line >>> */
private static int _lastChain;
private static int _parseLineCIF(byte[]T,int b,int[]buf,int i,float[]xyz,int iXYZ){
    if(!_xyzAligned) _xyzColumns(true,b);
    final int cc[]=_xyzColumns,elem=charsToBitsStopAtSpace(T,b+cc[CIFas_type_symbol]);
    if(elem=='H') return 1<<CIF_SHIFT_SKIP;
    xyz[iXYZ  ]=(float)atof(T,b+cc[CIFas_Cartn_x  ],b+cc[CIFas_Cartn_x+1]);
    xyz[iXYZ+1]=(float)atof(T,b+cc[CIFas_Cartn_x+1],b+cc[CIFas_Cartn_x+2]);
    xyz[iXYZ+2]=(float)atof(T,b+cc[CIFas_Cartn_x+2],b+cc[CIFas_Cartn_x+3]);

    final int
        altl=charsToBitsStopAtSpace(T,b+cc[CIFas_label_alt_id]),
        rchn=buf[i+PDBBUF_CHAIN]=charsToBitsStopAtSpace(T,b+cc[CIFas_auth_asym_id]),
        rnum=atoi(T,b+cc[CIFas_auth_seq_id]),
        insc=T[b+cc[CIFas_pdbx_PDB_ins_code]];
    //baOut(DEBUG_NOW+" rchn=").aa((char)rchn,' ').aFT(T,b,b+30).aln();
    buf[i+PDBBUF_ELEM]=elem;
    buf[i+PDBBUF_ANUM]=atoi(T,b+cc[CIFas_id]);
    buf[i+PDBBUF_RNAM]=charsToBitsStopAtSpace(T,b+cc[CIFas_auth_comp_id]);
    buf[i+PDBBUF_ATOM]=charsToBitsStopAtSpace(T,b+cc[CIFas_auth_atom_id]);
    final int resnIns=(buf[i+PDBBUF_RNUM]=(rnum<<7)|(insc<'A'?0:insc));
#if 0
    baOut(DEBUG_LONGER)
        .a("x=").aFloat(xyz[iXYZ],4,2)
        .aa(" rnum=",rnum," rnam=").aBytes(buf[i+PDBBUF_RNAM])
        .aa(" anum=",buf[i+PDBBUF_ANUM]," anam=").aBytes(buf[i+PDBBUF_ATOM])
        .aln();
#endif //0
    final int seqId=atoi(T,b+cc[CIFas_label_seq_id]);
    return(altl<'A'?0:(1<<CIF_SHIFT_ALTLOC))|
        (_lastChain!=(_lastChain=rchn)?2:0)|
        ((seqId!=0?seqId:resnIns)  <<CIF_SHIFT_RESN);
}
/* <<< One atom line <<< */
/* ---------------------------------------- */
/* >>> cifValues >>> */
private static int _nTokens(int pos,int num){
    boolean prev=false;
    final boolean[]space=chrClas(SPC);
    for(int E1=_E+1,t=0,i=pos,f=0;i<E1;i++){
        final byte c=_T[i];
        boolean spc=c>0 && space[c];
        if(!spc){
            if(!prev){
                prev=true;
                f=i;
                if(c=='#' && i>0 && _T[i-1]=='\n'){
                    return 0;
                }
                if(!(c==';' && _T[i-1]=='\n') &&c!='\''&&c!='"') continue;
                i=_semikolon(f++);
                spc=true;
            }
        }
        if(prev && spc){
            prev=false;
            TOK_B[t]=f;
            TOK_E[t]=i;
            if(++t==num) return i+1;
        }
    }
    return -pos;/*X  0 is fine,less 0 means premature stop */
}
private static int _semikolon(int f){
    int i=f+1;
    for(int c0=_T[f],E1=_E-1,c;i<E1;i++){
        switch(c=_T[i]){
        case';':
            if(c0==';' && _T[i-1]=='\n') return i;
            break;
        case'\'':
        case'"':
            if(c==c0 && isChrClas(SPC,_T,i+1)) return i;
            break;
        }
    }
    err(PDB_ERR).aln("Missing semikolon");
    return i;
}
private static void cifValues(int id){
    final int idChain=(id>>>8)&255,idEntry=(id>>>16)&255,nCol;
    id&=255;
    int iL=BODY[id],pos=0;
    final boolean isLoop=iL>0;
    if(isLoop){
        pos=_eol[iL-1]+1;
        nCol=COLS[id];
    }else{
        iL=LINE[id];
        nCol=0;
        if(iL<0){
#if CPP_WITH_MEIN_DEBUG
            final byte[]name=STRING[id];
            if(id==CIFep_type||
               id==CIFep_pdbx_seq_one_letter_code||
               id==CIFesg_pdbx_gene_src_scientific_name||
               id==CIFe_pdbx_description)    baOut(RED_WARNING).aa(name,ANSI_RED+" not found "+ANSI_RESET).aln();
#endif //CPP_WITH_MEIN_DEBUG
            return;
        }
    }
    final byte[]T=_T;
    Poly poly=_poly;
    for(int PID=poly==null?0:poly._id,record=0; isLoop||record<1;record++){
        if(isLoop && (pos=_nTokens(pos,nCol))<=0){
            if(pos<0) err(PDB_WRN).aa(STRING[id]," record=",record," Expected n x ",nCol," columns"," Anfang=").aSingleSpaces(0,T,TOK_B[0],TOK_E[0]).aln();
            break;
        }
 if(idChain!=0 || idEntry!=0){
            final int c=idChain!=0?charsToBitsStopAtSpace(T,_pos(idChain)):_posGetInt(idEntry);
            if(c!=(idChain!=0?_chain:PID)) continue;
            // if(id==CIFe_id){
            //     errLine(pos,0x0303|PDB_ERR_LINE_FROM_POS);
            //     baOut(DEBUG_NOW).a(ANSI_GREEN+" pos="+_pos(idEntry)+","+" idChain="+idChain+" idEntry="+idEntry+" c="+c+" pid="+pid).aln(ANSI_RESET);
            // }
        }
        switch(id){
        case CIFcc_id:
            if(strEquAt(0,"NON-POLYMER",_T,_pos(CIFcc_type),_posEnd)){
                final int f=_pos(CIFcc_id);
                _mapHet.put(io(charsToBitsSkipSpc(T,f,_posEnd-f)),_posGetWord(CIFcc_name));
            }
            break;

        case CIFesg_entity_id:/*X pid*/
            poly._orgSc=_posGetWord(CIFesg_pdbx_gene_src_scientific_name);
            poly._taxId=_posGetInt(CIFesg_pdbx_gene_src_ncbi_taxonomy_id);
            break;
        case CIFesn_entity_id:/*X pid*/
            poly._orgSc=_posGetWord(CIFesn_pdbx_organism_scientific);
            poly._org=_posGetWord(CIFesn_common_name);
            break;
        case CIFe_id:/*X pid*/
            poly._descr=s(pdbTmpClr().aSingleSpaces(FILTER_SPC_TO_US,T,_pos(CIFe_pdbx_description),_posEnd));
            poly._ec=RANGE_FROM_TO(_pos(CIFe_pdbx_ec),_posEnd);
            break;
        case CIFep_entity_id:{/*X pid*/
/*X pid*/
            final boolean[]lettr=chrClas(LETTR);
            final BA sb=pdbTmpClr();
            for(int k=_pos(CIFep_pdbx_seq_one_letter_code),end=_posEnd,parenth=-1; k>=0 && k<end;k++){
                final byte c=T[k];
                char a='\0';
                if(c=='('){/*X  1JD2 15 'polypeptide(L)' no yes '(1QQ)YN(R4K)(AKK)' XYNWX 8,9*/
                    parenth=k;
                }else if(c==')'){
                    if(k-parenth==4) a=(char)toOneLetterCode(T[parenth+1]|(T[parenth+2]<<8)|(T[parenth+3]<<16));
                    parenth=-1;
                }else if(parenth==-1 && c>=0 && lettr[c]){
                    a=(char)c;
                }
                if(a!=0) sb.a(a);
            }
            poly._res=sb.newBytes();
            break;
        }
        case CIFsr_entity_id:/*X pid*/
            setUniprot(iL,_pos(CIFsr_db_name),_pos(CIFsr_db_code));
            setUniprot(iL,_pos(CIFsr_db_name),_pos(CIFsr_pdbx_db_accession));
            break;
        case CIFep_type:{
            _polymer=adToArry(0,poly=new Poly(),_polymer,Poly.class);
            poly._id=_posGetInt(CIFep_entity_id);
            {
                String[]ss=splitTkns(',',T,_pos(CIFep_pdbx_strand_id),_posEnd,null);
                if(ss.length==0){
                    ss=new String[]{s((char)('A'-1+_polymer.length))};
                    err(PDB_WRN).a(STRING[CIFep_pdbx_strand_id]).aln(" not found. Assuming chain ").joinSpc(ss).aln();
                }
                final int cc[]=poly._chains=new int[ss.length];
                ROFj0(ss.length) cc[j]=charsToBitsStopAtSpace(pdbTmpClr().aa(ss[j],' ').bytes(),0);
            }
            final int f=_pos(CIFep_type);
            int typ=-1;
            final String PEP="polypeptide",RNA="polyribonucleotide",DNA="polydeoxyribonucleotide";
            if(_posEnd-f>11){
                switch(T[f+4]){
                case'p':if(strEquAt(0,PEP,T,f)) typ=CHAINTYPE_PEP;break;
                case'r':if(strEquAt(0,RNA,T,f)) typ=CHAINTYPE_RNA;break;
                case'd':if(strEquAt(0,DNA,T,f)) typ=CHAINTYPE_DNA;break;
                }
            }
            if(typ<0){
                err(PDB_WRN).aa(STRING[CIFep_type]," Expected=",PEP,"|").aa(DNA,"|",RNA).a(" Found=\"").aSingleSpaces(0,T,f,_posEnd).aln("\" ");
                if(!strEquAt(0,"other",T,f)){
                    errLine(iL,0x0101);
                    exitOnErr();
                }
            }else{
                poly._chainType=typ;
            }
            break;
        }
        case CIFssr_beg_auth_seq_id:
#if CPP_WITH_MEIN_DEBUG
            if(charsToBitsStopAtSpace(T,_pos(CIFssr_beg_auth_asym_id))!=charsToBitsStopAtSpace(T,_pos(CIFssr_end_auth_asym_id))){
                err(PDB_ERR).aa(STRING[CIFssr_beg_auth_asym_id]," != ",STRING[CIFssr_end_auth_asym_id]).aln();exitOnErr();
            }
#endif //CPP_WITH_MEIN_DEBUG
            secStruAdd(iL,'E',
                       _pos(CIFssr_beg_auth_comp_id),_pos(CIFssr_beg_auth_seq_id),_pos(CIFssr_pdbx_beg_PDB_ins_code),
                       _pos(CIFssr_end_auth_comp_id),_pos(CIFssr_end_auth_seq_id),_pos(CIFssr_pdbx_end_PDB_ins_code));
            break;
        case CIFsc_beg_auth_seq_id:
#if CPP_WITH_MEIN_DEBUG
            if(charsToBitsStopAtSpace(T,_pos(CIFsc_beg_auth_asym_id))!=charsToBitsStopAtSpace(T,_pos(CIFsc_end_auth_asym_id))){
                err(PDB_ERR).aa(STRING[CIFsc_beg_auth_asym_id]," != ",STRING[CIFsc_end_auth_asym_id]).aln();exitOnErr();
            }
#endif //CPP_WITH_MEIN_DEBUG
            secStruAdd(iL,'H',
                       _pos(CIFsc_beg_auth_comp_id),_pos(CIFsc_beg_auth_seq_id),_pos(CIFsc_pdbx_beg_PDB_ins_code),
                       _pos(CIFsc_end_auth_comp_id),_pos(CIFsc_end_auth_seq_id),_pos(CIFsc_pdbx_end_PDB_ins_code));
            break;
        case CIFss_id:{
            final String sid=_posGetWord(CIFss_id);
            if(sze(sid)>0){
                _mapSiteDescr.put(sid,_posGetWord(CIFss_details));
                _mapSiteEvdnc.put(sid,_posGetWord(CIFss_pdbx_evidence_code));
            }
            break;
        }
        case CIFssg_site_id:
            RESNUM[0]=_pos(CIFssg_auth_comp_id);
            RESNUM[1]=_pos(CIFssg_auth_seq_id);
            RESNUM[2]=_pos(CIFssg_pdbx_auth_ins_code);
            RESNUM[3]=0;
            RESNUM[4]=_pos(CIFssg_site_id);
            RESNUM[5]=_posEnd;
            anno(PDB_SITE,iL);
            break;
        case CIFpsmr_details:/*X 1F34*/
            RESNUM[0]=_pos(CIFpsmr_auth_comp_id);
            RESNUM[1]=_pos(CIFpsmr_auth_seq_id);
            RESNUM[2]=_pos(CIFpsmr_PDB_ins_code);
            RESNUM[3]=0;
            RESNUM[4]=_pos(CIFpsmr_details);
            RESNUM[5]=_posEnd;
            anno(PDB_MODRES,iL);
            break;
        case CIFsmpc_pdbx_auth_seq_id_2:/*X 32C2*/
            RESNUM[0]=_pos(CIFsmpc_pdbx_auth_comp_id_2);
            RESNUM[1]=_pos(CIFsmpc_pdbx_auth_seq_id_2);
            RESNUM[2]=_pos(CIFsmpc_pdbx_PDB_ins_code_2);
            RESNUM[3]=0;
            anno(PDB_CISPEP,iL);
            break;
        case CIFsco_ptnr1_auth_seq_id:{/*X 11ba Problem,could be of different chains*/
            int type=-1;
            final int
                chain1=charsToBitsStopAtSpace(T,_pos(CIFsco_ptnr1_auth_asym_id)),
                chain2=charsToBitsStopAtSpace(T,_pos(CIFsco_ptnr2_auth_asym_id));
            if(chain1==_chain || chain2==_chain){
                final int j=_pos(CIFsco_conn_type_id);
                switch(T[j]){
                case'd':
                    if(strEquAt(0,"disulf",T,j)) type=PDB_SSBOND;
                    break;
                case'm':
                    if(strEquAt(0,"metalc",T,j)) type=PDB_CONN_METALC;
                    break;
                case'c':
                    if(strEquAt(0,"covale",T,j)) type=PDB_CONN_COVALE;
                    break;
                case's':
                    if(strEquAt(0,"saltbr",T,j)) type=PDB_CONN_SALTBR;
                    break;
                case'h':
                    if(strEquAt(0,"hydrog",T,j)) type=PDB_CONN_HYDROG;
                    break;
                }
                if(type<0) baOut(DEBUG_LONGER+" UNKNOWN_CONN ").a(_txt.getFile()).a(' ').aln(_posGetWord(CIFsco_conn_type_id));
                RESNUM[0]=_pos(CIFsco_ptnr1_auth_comp_id);
                RESNUM[1]=_pos(CIFsco_ptnr1_auth_seq_id);
                RESNUM[2]=0;
                RESNUM[3]=chain1;
                RESNUM[4]=_pos(CIFsco_ptnr2_auth_comp_id);
                RESNUM[5]=_pos(CIFsco_ptnr2_auth_seq_id);
                RESNUM[6]=0;
                RESNUM[7]=chain2;
                anno(type|(1<<8),iL);
            }
            break;
            //_struct_conn.id                            covale1
            //_struct_conn.conn_type_id                  covale
        }
        case CIFpsol_id:/*X pdbx_struct_oper_list.id*/
            if(!strEquAt(0,"crystal sym",T,_pos(CIFpsol_type))){
                addToStructOperList(_posGetInt(CIFpsol_id),
                                    _pos(CIFpsol_matrix11),_pos(CIFpsol_matrix12),_pos(CIFpsol_matrix13),_pos(CIFpsol_vector1),
                                    _pos(CIFpsol_matrix21),_pos(CIFpsol_matrix22),_pos(CIFpsol_matrix23),_pos(CIFpsol_vector2),
                                    _pos(CIFpsol_matrix31),_pos(CIFpsol_matrix32),_pos(CIFpsol_matrix33),_pos(CIFpsol_vector3));
            }
            break;
        case CIFpsag_assembly_id:{
/* https://www.cgl.ucsf.edu/chimera/data/group-meeting-nov2008/quaternary.html */
/* Identifies the operation of collection of operations from category PDBX_STRUCT_OPER_LIST. */
/* Operation expressions may have the forms: */
/* (1)        the single operation 1 */
/* (1,2,5)    the operations 1,2,5 */
/* (1-4)      the operations 1,2,3 and 4 */
/* (1,2)(3,4) the combinations of operations 3 and 4 followed by 1 and 2 (i.e. the cartesian product of parenthetical groups applied from right to left) */
            int exprB=_pos(CIFpsag_oper_expression),exprE=_posEnd;
            if(exprE>=exprB && T[exprB]=='(' && T[exprE-1]==')') {exprB++;exprE--;}

            java.util.Collection<Matrix3D>v=null;
            final int matrixId=_posGetInt(CIFpsag_assembly_id);
            if(matrixId>0){
                if(strchr('(',T,exprB,exprE)>=0){/*X  This one is not supported: (1,2)(3,4) */
                    err(PDB_WRN).aa(STRING[CIFpsag_oper_expression]," Cartesian products not yet supported: ").aSingleSpaces(0,T,exprB,exprE).aln();
                }else{
                    final int to;
                    final boolean[]bb;
                    CPP_synchronized(SYNC_PARSE_SET){/*X  (1-60) (1,2,6,10,23,24)   */
                        to=mini(STRUCT_OPER_LIST_SIZE,(int)(RANGETO_MASK&parseSet(toknzr(341,',').setText(T,exprB,exprE),0,99)));
                        bb=parseSetGet(MAX_INT,MAX_INT);
                    }
                    FORi(0,to)if(bb[i] && STRUCT_OPER_LIST[i]!=null)  v=adNotNullNew(STRUCT_OPER_LIST[i].clone(),v);
                    combineAssemblyIdMatricesAndChains(matrixId,toArry(v,Matrix3D.NONE),splitTkns(',',T,_pos(CIFpsag_asym_id_list),_posEnd,null));
                    //baOut(DEBUG_NOW+" matrixId="+matrixId+" STRUCT_OPER_LIST="+sze(STRUCT_OPER_LIST)).aln();
                    //baOut(DEBUG_NOW+"\n"+ANSI_FG_GREEN+v).aln(ANSI_RESET);

                }
            }
            break;
        }
        case CIFs_entry_id:{
            final int t=_pos(CIFs_pdbx_descriptor);
            _title.aSingleSpaces(0,T,t>0?t:_pos(CIFs_title),_posEnd).a(' ');
            break;
        }
        }
    }
}
private static int _posEnd;
private static int _pos(int field){
    final int c=COLUMN[field];
    int f,t;
    final int iL=LINE[field];
    if(iL<0) return _posEnd=0;
    final int b=iL==0?_B:_eol[iL-1]+1;
    if(c<0){
        if(iL<0){
            if(field!=CIFpsmr_details) err(PDB_ERR).a(STRING[field]).aInt(field,5).aln(": No such field");
            return 0;
        }
        if(0>(f=nxt(chrClas(-SPC),_T,b+STRING[field].length+1,_E))){
            t=-1;
        }else{
            final byte c0=_T[f];
            if(c0==';' || c0=='\''|| c0=='"'){
                t=_semikolon(f++);
                while(t>0 && isChrClas(SPC,_T,t-1)) t--;
            }else{
                t=nxt(STR_E,chrClas(SPC),_T,f,_E);
                if(0>t) t=_E;
            }
        }
    }else{
        f=TOK_B[c];
        t=TOK_E[c];
    }
    _posEnd=t;
    return f;
}
private static String _posGetWord(int field){
    int b=_pos(field);
    if(_posEnd-b<2) return null;
    if(field==CIFss_pdbx_evidence_code){
        switch(_T[b]|32){
        case'a':
            if(strEquAt(STR_IC,"AUTHOR",_T,b)) return EVIDENCE_BY_AUTHOR;
            break;
        case's':
            if(strEquAt(STR_IC,"SOFTWAR",_T,b)) return EVIDENCE_BY_SOFTWARE;/*X 2NUG trailing "e" missing */
            break;
        case'u':
            if(strEquAt(STR_IC,"UNKNOWN",_T,b)) return EVIDENCE_UNKNOWN;
            break;
        }
        IF_MEIN_DEBUG(err(PDB_WRN).a("UNKNOWN_EVIDENCE=>").aSingleSpaces(0,_T,b,_posEnd).aln("<").special(STCKTRC));;
    }
    return s(baClr(114).aSingleSpaces(0,_T,b,_posEnd));
}
/* <<< cifValues <<< */
/* ---------------------------------------- */
/* >>> CIF Atom lines >>> */
private static boolean _xyzAligned;
private static int[]_xyzColumns,_fromCurrentCol;
private static boolean _xyzColumns(boolean withLineBreak,int b){
    final boolean[]space=chrClas(SPC);
    final int n=COLS[CIFas_Cartn_x],fcc[]=_fromCurrentCol,cc[]=_xyzColumns;
    clr(cc);
    boolean prev=false;
    int E=_E,count=0;
    FORi(b,E){
        if(!withLineBreak && _T[i]=='\n') return false;
        final boolean noSpc=_T[i]<0||!space[_T[i]];
        if(noSpc&&!prev){
            cc[fcc[count]]=i-b;
            if(++count==n) return true;
        }
        prev=noSpc;
    }
    return false;
}
/* <<< CIV atom line <<< */
/* ---------------------------------------- */
/* >>> Polymer Class >>> */
private static class Poly{
    int _id,_chainType,_chains[]={},_taxId;/*X  Example 1JD2 Plymer 1 has Chains A,V */
    byte[]_res;
    String _orgSc,_org,_descr;
    long _ec;
}
/* <<< Polymer Class <<< */
/* ---------------------------------------- */
/* >>>  >>> */
#if CPP_DEACTIVATED
private static Object polyToStrg(Poly p){
    final BA sb=baClr(115).a(" Polymer ").aInt(p._id,3).a(" chains=");
    for(int c:p._chains) sb.aBytes(c).a(',');
    return sb.del(',').aa(" type=",iConst(SARRAYeq_STRAP_OBJECT_TITLE,p._chainType)," rt=",p._res);
}
#endif //CPP_DEACTIVATED
#undef PREFIX_SIZE
