@*H THIS_CLASS(SPARSER_PDB)
 See File_example:pdb WIKI:Protein_Data_Bank_(file_format).
 <i>HTMLDOC_BUTTON:STOG_ignoreSEQRES</i> or with the command line option PAR_noSeqres .
*@
//   $STRAP_SRC/mail/notes/Bioinf/PDB_Format.txt   Todo addToPep wenn in _seqres24
#define SHIFT_RESN 8
/* --- */
private final static byte[]_molidForChain=new byte['z'+1];/*X  Required to pick the COMPND and SOURCE lines. */
private final static BA[]_chainsByTypeV=new BA[CHAINTYPE_INFO+1];
/* --- */
private static boolean _isPdb;
private static int
IF_GUI(_lstLine,)
    _linkSrc[]={},_linkDst[],_linkL,/*X   Required for LINK. Associates two resnums. resnum<<SHIFT_RESN|ins */
    _resnIns1[]={},_resnIns1L,/*X  Required for inAtoms LINK.  resnum<<SHIFT_RESN|ins */
    _seqres24[]={},
    _lstNonAtomLine;

private static long _mcPrepare;
private String[][]_parsePDB(int opt,String chainAsString,BA txt,final Protein p){
#define debugT 0
#define wantHeader 0==(opt&(PROTPARS_AS_DNA_OR_RNA|PROTPARS_NO_HEADER))
#define wantSeqres 0==(opt&(PROTPARS_AS_DNA_OR_RNA|PROTPARS_NO_SEQRES))
#if debugT
        baOut(DEBUG_TIME).aa("parse ",sze(txt),' ',chainAsString).aln();
#endif //debugT
        if(txt==null || !_preparePDB(txt)) return null;
        if(_chainsByType==null||p==null) return _chainsByType;
        final byte[]T=_T;
#if debugT
        final int time0=timeOn();
#endif //debugT
        final int wantChain=beginOrEnd(chainAsString,p);
        final byte molid=_molidForChain[wantChain];/*X Reihenfolge!*/
/* --- static buffers Thread safe --- */
#if debugT
        err(PDB_DONE).aln("parse SEQRES ");
#endif //debugT
        _linkL=_resnIns1L=0;
        IF_GUI(final BA helixSheetKeepTxt=clr(baSoft(105)));;
    nextLine:
        for(int e=_B-1,iL=0;iL<=_lstNonAtomLine;iL++){
            final int chn=_chainOfLine[iL],b=e+1; e=_eol[iL];
            if(chn>0 && wantChain!=chn && chn!='_') continue;
            switch(_typeOfLine[iL]){
            case PDB_SOURCE:
            case PDB_COMPND:
                if(chn==-molid){
                    final int b11=b+11;
                    switch(T[b11]){
                    case'O':
                        if(e-b>31 && strEquAt(0,"ORGANISM_SCIENTIFIC:",T,b11)) p.setProperty(P_ORGANISM_SC,T,b11+20,e);/*X BEISPIEL=1ryp_B */
                        if(e-b>26 && strEquAt(0,"ORGANISM_TAXID:",T,b11)) p.setIntProperty(PROTEINI_TAXID,atoi(T,b11+15));/*X BEISPIEL=1ryp_B */
                        break;
                    case'M':
                        if(e-b>20 && strEquAt(0,"MOLECULE:",T,b11)) p.setProperty(P_COMPOUND,T,b11+9,e);/*X BEISPIEL=1ryp_B */
                        break;
                    case'E':
                        if(strEquAt(0,"EC:",T,b11)) p.setProperty(PROTEINO_EC|PROTEINO_FLAG_ADD,T,b11+3,e);/*X BEISPIEL=1ryp_B */
                        break;
                    }
                }
                break;
            case PDB_TER:break nextLine;
            case PDB_LINK:/*X  BEISPIEL: PDB:1s29 */
                if(_linkSrc.length<=_linkL){
                    final int sze=_linkL*2+333;
                    _linkSrc=chSze(_linkSrc,sze);
                    _linkDst=chSze(_linkDst,sze);
                }
                _linkSrc[_linkL  ]=(int4(T,b+25)<<SHIFT_RESN)|T[b+26];
                _linkDst[_linkL++]=(int4(T,b+55)<<SHIFT_RESN)|T[b+56];
                break;
            case PDB_SEQRES:
                if(wantSeqres){
                    final int to=mini(eolTrim(T,b,e)-b-2,68);
                    for(int c=19;c<to; c+=4){
                        final int i=sze(_seqres);
                        if(_seqres24.length<=i) _seqres24=chSze(_seqres24,i+999);
                        _seqres.a((char)toOneLetterCode(_seqres24[i]=charsToBitsSkipSpc(T,b+c,3)));
                    }
                }
                break;
            case PDB_DBREF:/*X  BEISPIEL=PDB:1RYP BEISPIEL(GB)=1gde BEISPIEL(PDB)=1h4t BEISPIEL(PIR)=1qte */
                setUniprot(iL,26+b,33+b);
                setUniprot(iL,26+b,42+b);
                break;
            case PDB_SEQADV:/*X  BEISPIEL=3sbg_A  BEISPIEL(GB)=PDB:1rxq */
                setUniprot(iL,24+b,29+b);
                break;
            case PDB_HEADER:
                if(wantHeader){
                    p.setProperty(P_HEADER,T,b+10,b+50);
                    p.setIntProperty(PROTEINI_DEPOSITION_YEAR,atoi(T,b+57));
                }
                break;
            case PDB_TITLE:
                if(wantHeader) _title.aSingleSpaces(0,T,b+10,e).a(' ');
                break;
            }

        }/*X for*/
        for(int iL=maxi(0,FST_LINE_OF_CHAIN[wantChain]),eL=LST_LINE_OF_CHAIN[wantChain],resNum=0,e=_B-1;iL<=eL;iL++){
            if(wantChain!=_chainOfLine[iL]) continue;
            final int b=e+1; e=_eol[iL];
            if(e-b<26) continue;
            final int tol=_typeOfLine[iL];
            if(tol==PDB_ATOM || 0==(opt&PROTPARS_AS_DNA_OR_RNA)){/*X  HETATM eingebettet. z.B. PDB:1s29/MSE  PDB:1vqo/PPU */
                if(DIFF_MC(resNum,(int4(T,b+25)<<SHIFT_RESN)|(127&T[b+26])) && tol==PDB_ATOM){
                    if(_resnIns1.length<=_resnIns1L) _resnIns1=chSze(_resnIns1,_resnIns1L*2+333);
                    _resnIns1[_resnIns1L++]=resNum;
                }
            }
        }

        heterosInPep();
        parseAtoms(wantChain,p);
            FORiL(0,_lstNonAtomLine){
            final byte tol=_typeOfLine[iL];
            if(tol!=PDB_SSBOND && wantChain!=_chainOfLine[iL]) continue;
            final int b=iL==0?_B:_eol[iL-1]+1,e=_eol[iL];
            switch(tol){
            case PDB_HELIX:
                secStruAdd(iL,'H',
                           21-6+b,21+b,21+4+b,
                           33-6+b,33+b,33+4+b);
                IF_GUI(helixSheetKeepTxt.aFT(T,b,e).a1('\n'));;
                break;
            case PDB_SHEET:
                secStruAdd(iL,'E',
                           22-5+b,22+b,22+4+b,
                           33-5+b,33+b,33+4+b);
                IF_GUI(helixSheetKeepTxt.aFT(T,b,e).a1('\n'));;
                break;
#if CPP_DEACTIVATED
/* Todo association with name. See example pdb1nrg */
            case PDB_SITE:
                int i=0;/*X  19 24 28*/
                for(int n=b+18,end=eolTrim(T,b,e);n<end; n+=11){
                    RESNUM[i++]=19-19+n;
                    RESNUM[i++]=24-19+n;
                    RESNUM[i++]=28-19+n;
                    RESNUM[i++]=0;
                }
                RESNUM[i  ]=b+11;
                RESNUM[i+1]=b+14;
                anno(PDB_SITE|((i/3-1)<<8),iL);
                break;
#endif //CPP_DEACTIVATED
            case PDB_CISPEP:
                RESNUM[0]=b+25;
                RESNUM[1]=b+31;
                RESNUM[2]=b+35;
                RESNUM[3]=0;
                anno(PDB_CISPEP,iL);
                break;
            case PDB_SSBOND:
                final byte chain1=T[b+15] ,chain2=T[b+20];
                if(wantChain==chain1 || wantChain==chain2){
                    RESNUM[0]=b+11;
                    RESNUM[1]=b+17;
                    RESNUM[2]=b+21;
                    RESNUM[3]=chain1;
                    RESNUM[4]=b+25;
                    RESNUM[5]=b+31;
                    RESNUM[6]=b+35;
                    RESNUM[7]=chain2;
                    anno(PDB_SSBOND|(1<<8),iL);
                }
                break;
            case PDB_MODRES:
                RESNUM[0]=b+24;
                RESNUM[1]=b+18;
                RESNUM[2]=b+22;
                RESNUM[3]=0;
                RESNUM[4]=b+29;
                RESNUM[5]=e;
                anno(PDB_MODRES,iL);
                break;
            }/*X switch(tol)*/
        }/*X  fo*/
#if debugT
        IF_MEIN_DEBUG(IF_AA(if(!isPrprty(IS_AA_SETUP)) err(PDB_DONE).aa(ANSI_STYLE_PDB,timeOn()-time0).aln(" ms ")));;
#endif //debugT
        beginOrEnd(null,null);
        IF_GUI(IF_MEIN_DEBUG(p.setProperty(PROTEINO_PDBTEXT_SECSTR,helixSheetKeepTxt.newBytes())));;
        IF_GUI(p.setResolutionAngstroms(_resolution));;
        return DEFAULT_CHAINS_BY_TYPE;
}/*X parse*/

private static void addToPep(int num){
    if(!inPep(num) && !inAtoms(num)){
        if(_hetsInPep.length<=_hetsInPepL) _hetsInPep=chSze(_hetsInPep,333+_hetsInPepL*2);
        _hetsInPep[_hetsInPepL++]=num;
    }
}
private static boolean inPep(int num) {return idxOf(num,_hetsInPep,0,_hetsInPepL)>=0;}
private static boolean inAtoms(int num) {return 0<=java.util.Arrays.binarySearch(_resnIns1,0,_resnIns1L,num);}
private static void heterosInPep(){
    _hetsInPepL=0;
    while(true){
        boolean changed=false;
        ROFi0(_linkL){
            final int src=_linkSrc[i];
            if(src==0) continue;
            final int dst=_linkDst[i];
            if(inPep(dst)){
                addToPep(src);
            }else if(inPep(src)){
                addToPep(dst);
            }else if(inAtoms(dst)){
                addToPep(src);
            }else if(inAtoms(src)){
                addToPep(dst);
            }else continue;
            changed=true;
            _linkSrc[i]=0;
        }
        if(!changed) break;
    }
#if 0
    final BA sb=baClr(125).aa(DEBUG_LONGER,"_hetsInPep=");
    FORi(0,_hetsInPepL)sb.aa(_hetsInPep[i]>>8,(char)(_hetsInPep[i]&255),' ');
    baOut(DEBUG_LONGER).aln(sb);
#endif //0
}
private static int _parseLinePDB(byte[]T,int b,int e,int[]buf,int i,float[]xyz,int iXYZ){
    final int
        atom=charsToBitsSkipSpc(T,b+12,4),
        elem=e-b>77?(short)charsToBitsSkipSpc(T,b+76,2):T[b+12]!=' '?(short)charsToBitsSkipSpc(T,b+12,2):(short)(atom&127);
    if(elem=='H') return 1<<CIF_SHIFT_SKIP;
    xyz[iXYZ  ]=float33(T,33+b);
    xyz[iXYZ+1]=float33(T,41+b);
    xyz[iXYZ+2]=float33(T,49+b);
#define altl T[b+16]
#define insc T[b+26]
#define rnum int4(T,b+25)
    buf[i+PDBBUF_RNAM]=charsToBitsSkipSpc(T,b+17,4);
    buf[i+PDBBUF_ANUM]=uInt6(T,b+10);
    buf[i+PDBBUF_ELEM]=elem;
    buf[i+PDBBUF_ATOM]=atom;
    buf[i+PDBBUF_CHAIN]=T[b+21];
    //final boolean newChain=false;
    return
        (altl<'A'?0:(1<<CIF_SHIFT_ALTLOC))|
        //(/*newChain?2:*/0)|
        ((buf[i+PDBBUF_RNUM]=(rnum<<7)|(insc<'A'?0:insc))<<CIF_SHIFT_RESN);
#undef altl
#undef insc
#undef rnum
}
private static String headerId4(byte[]T,int b,int e){
    if(e-b>=66 && T[4]=='E' && T[5]=='R' && T[6]==' ' && nxt(chrClas(-LETTR_DIGT),T,b+62,b+66)<0 && isChrClas(-LETTR_DIGT,T,b+61) && (e-b==66 || isChrClas(-LETTR_DIGT,T,b+66))){
        return byts2strg(T,b+62,b+62+4).toLowerCase();
    }
    return null;
}
private static boolean _preparePDB(BA txt){
    if(DIFF_MC(_mcPrepare,MC_FOR_TXT(txt)) || _chainOfLine==null){
        _init(SPARSER_PDB,txt);
        final byte[]T=_T;
        {/*X is PDB Format? */
            _isPdb=false;
            for(int firstLine=0,iL=0;iL<_eol.length;iL++){
                final int b=iL==0?_B:_eol[iL-1]+1,e=eolTrim(T,b,_eol[iL]);
                if(e-b==0) continue;
                if(e-b<20) break;
                final int s4=charsToBitsSkipSpc(T,b,4),c4=T[b+4],s45=c4|(T[b+5]<<8),c6=T[b+6];
                if(s4=='A'+('T'<<8)+('O'<<16)+('M'<<24)&&c4<'A'||
                   s4=='H'+('E'<<8)+('T'<<16)+('A'<<24)&&s45==('T'|('M'<<8))||
                   s4=='S'+('E'<<8)+('Q'<<16)+('R'<<24)&&s45==('E'|('S'<<8))){
                    _isPdb=true;
                    break;
                }
                if(firstLine++==0){
                    switch(s4){
                    case'H'|('E'<<8)|('A'<<16)|('D'<<24):
                        if(headerId4(T,b,e)!=null && c6==' ') {_isPdb=true;break;}
                        continue;
                    case'H'|('E'<<8)|('T'<<16)|('A'<<24):
                        if(s45!=('T'|('M'<<8)) && c6==' ') continue;
                        break;
                    case'A'|('T'<<8)|('O'<<16)|('M'<<24):
                        if(c4>='A') {_isPdb=true;break;}
                        break;
                    case'S'|('E'<<8)|('Q'<<16)|('R'<<24):
                        if(s45==('E'|('S'<<8)) && c6==' ') {_isPdb=true;break;}
                        break;
                    default: break;
                    }
                }
            }
        }
        if(!_isPdb) return false;
        IF_GUI(int lstLine=)_lstNonAtomLine=IF_GUI(_lstLine=)0;;
        final byte[]typeol=_typeOfLine=redim(_typeOfLine,_eol.length+1,333);
        clr(_molidForChain);
        clr(_chainsByTypeV);
        String siteRef=null;
        int molid=0,chainType=-1,prevChain=0,bioMolecule=0,bioLines[]=null;
        boolean bioCollectingChains=false;
        final BA bioChains=baClr(126);
    nextLine:
        FORiL(0,_eol.length){
            final int b=iL==0?_B:_eol[iL-1]+1,e=eolTrim(T,b,_eol[iL]),L=e-b;
            boolean skip=true,error=false;
            int idxChain=0;
            byte chain=0,tol=0;
            try{
                if(L<3) continue;
                final int
                    c4=L<5?' ':T[b+4],
                    c5=L<6?' ':T[b+5],
                    c6=L<7?' ':T[b+6],
                    c45= c4 |(c5<<8),
                    c456=c45|(c6<<16);
                final int c0123=T[b]|(T[b+1]<<8)|(T[b+2]<<16)|(L<4?0:(T[b+3]<<24));
                switch(c0123){
                case'H'+('E'<<8)+('T'<<16)+('A'<<24):
                    if(c45==('T'|('M'<<8))){
                        tol=PDB_HETATM;
                        if(L<=21 || isWater(T,b+17)) continue;
                        chainType=CHAINTYPE_HET;
                        idxChain=21;
                    }
                    break;
                case'H'+('E'<<8)+('T'<<16)+(' '<<24):tol=PDB_HET; continue;
                case'H'+('E'<<8)+('T'<<16)+('N'<<24):if(c456==('A'|('M'<<8)|(' '<<16))){/*X Can have folded lines as in 1fiq*/
                        final Object key=io(charsToBitsSkipSpc(T,b+11,4));
                        final BA sb=pdbTmpClr().a(_mapHet.get(key));
                        final int start=nxt(chrClas(-SPC),T,b+15,e);
                        if(isChrClas(LETTR_DIGT_US,sb.bytes(),sze(sb)-1)&&isChrClas(LETTR_DIGT_US,T,start)) sb.a(' ');/*X Space if lines end and start with word-character*/
                        _mapHet.put(key,s(sb.aFT(T,start,e)));
                        continue nextLine;
                    }break;
                case'E'+('N'<<8)+('D'<<16)+(' '<<24):tol=PDB_END;  break nextLine;
                case'E'+('N'<<8)+('D'<<16)+('M'<<24):if(c456==('D'|('L'<<8)|(' '<<16))) {tol=PDB_ENDMDL; break nextLine;} break;
                case'T'+('E'<<8)+('R'<<16)+(' '<<24):tol=PDB_TER; idxChain=21;break;
                case'L'|('I'<<8)|('N'<<16)|('K'<<24):if(c4==' ') {tol=PDB_LINK; idxChain=21;} break;
                case'S'|('I'<<8)|('T'<<16)|('E'<<24):if(c4==' ') {tol=PDB_SITE; idxChain=22;} break;
                case'H'|('E'<<8)|('L'<<16)|('I'<<24):if(c45== ('X'|(' '<<8))) {tol=PDB_HELIX; idxChain=19;} break;
                case'S'|('H'<<8)|('E'<<16)|('E'<<24):if(c45== ('T'|(' '<<8))) {tol=PDB_SHEET; idxChain=21;} break;
                case'D'|('B'<<8)|('R'<<16)|('E'<<24):if(c45== ('F'|(' '<<8))) {if(L<55) continue; tol=PDB_DBREF;  idxChain=12;} break;
                case'S'|('E'<<8)|('Q'<<16)|('A'<<24):if(c456==('D'|('V'<<8)|(' '<<16))) {if(L<55) continue; tol=PDB_SEQADV; idxChain=16;} break;
                case'M'|('O'<<8)|('D'<<16)|('R'<<24):if(c456==('E'|('S'<<8)|(' '<<16))) {if(L<25) continue; tol=PDB_MODRES; idxChain=16;} break;
                case'C'|('I'<<8)|('S'<<16)|('P'<<24):if(c456==('E'|('P'<<8)|(' '<<16))) {if(L<25) continue; tol=PDB_CISPEP; idxChain=15;} break;/*X 32C2*/
                case'S'|('S'<<8)|('B'<<16)|('O'<<24):if(c456==('N'|('D'<<8)|(' '<<16))) {if(L<35) continue; tol=PDB_SSBOND; idxChain=15;} break;/*X 11ba*/
                case'M'+('A'<<8)+('S'<<16)+('T'<<24):
                case'J'+('R'<<8)+('N'<<16)+('L'<<24):
                case'S'+('C'<<8)+('A'<<16)+('L'<<24):
                case'C'+('R'<<8)+('Y'<<16)+('S'<<24):
                case'O'+('R'<<8)+('I'<<16)+('G'<<24):
                case'A'+('U'<<8)+('T'<<16)+('H'<<24):
                case'A'+('N'<<8)+('I'<<16)+('S'<<24):
                case'R'+('E'<<8)+('V'<<16)+('D'<<24):
                case'E'+('X'<<8)+('P'<<16)+('D'<<24):
                case'K'+('E'<<8)+('Y'<<16)+('W'<<24):continue;
                case'R'|('E'<<8)|('M'<<16)|('A'<<24):{
                    if(c45!=('R'|('K'<<8)) || L<12 || nxt(chrClas(-SPC),T,b+11,e)<0) continue;
                    tol=PDB_REMARK;
                    final int c11=T[b+11];
                    switch(atoi(T,b+7)){
                    case 2:
                        IF_GUI(if(L>36 && c11=='R'&& strEquAt(0,"  2 RESOLUTION",T,b+7)) _resolution=(float)atof(T,b+22,e));;
                        break;
                    case 350:{
                        int whereChains=b+41;
                        if(L>11+12 && c11=='B'&&strEquAt(0,"BIOMOLECULE:",T,b+11)){
                            bioMolecule=maxi(1,atoi(T,b+23));/*X  --- sometimes this line is incomplete --- */
                            //if(sze(bioChains)>0) combineAssemblyIdMatricesAndChains(bioMolecule,STRUCT_OPER_LIST,bioChains.toStringArray());
                            Arrays.fill(STRUCT_OPER_LIST,null);
                            clr(bioChains);
                            if(bioLines==null) bioLines=new int[2*4]; else clr(bioLines);
                            bioLines[0]=b;
                            bioLines[1]=iL;
                        }else if(L>41 && c11=='A'&&strEquAt(0,"APPLY THE FOLLOWING",T,b+11)||
                                 bioCollectingChains && ((whereChains=strstr(STR_AFTER," TO CHAINS:",T,b,e))>0||(whereChains=strstr(STR_AFTER," AND CHAINS:",T,b,e))>0)){
                            if(!bioCollectingChains) clr(bioChains);
                            bioCollectingChains=true;
                            final ChTokenizer tok=toknzr(342,SPACE_COMMA).setText(T,whereChains,e);
                            while(tok.nextToken()) if(tok.to()-tok.from()==1) bioChains.aLetterDigit(T[tok.from()]);
                            clr(tok);
                        }else if(L>55 && c11==' '&&strEquAt(0,"  BIOMT",T,b+11)){
                            final int i123=T[b+18]-'0';
                            if(sze(bioChains)==0) err(PDB_ERR).a("A line \"... ").aa(!bioCollectingChains?"BIOMOLECULE:":" TO CHAINS:"," ... \" must preced #").aInt(iL,4).a(' ').aFT(T,b,e).aln();
                            else if(0<i123 && i123<4){
                                bioCollectingChains=false;
                                bioLines[2*i123]=b;
                                bioLines[2*i123+1]=iL;
                                if(i123==3){
                                    final int b1=bioLines[2*1],b2=bioLines[2*2],lineNum=atoi(T,20+b);
                                    if(lineNum!=atoi(T,20+b1) || lineNum!=atoi(T,20+b2)){
                                        err(PDB_ERR).aln("Matrix num:");
                                        FORi(0,4){
                                            err(0).a(' ').aInt(bioLines[2*i+1],5).aln();
                                            IF_MEIN_DEBUG(errLine(bioLines[2*i+1],0));;
                                        }
                                    }
                                    addToStructOperList(-1,
                                                        b1+24,b1+34,b1+44,b1+54,
                                                        b2+24,b2+34,b2+44,b2+54,
                                                        b +24,b +34,b +44,b +54);
                                }
                            }
                        }else{
                            continue;
                        }
                        break;
                    }
                    case 800:
/* BEISPIEL 2amf_A */
/*     REMARK 800 SITE_IDENTIFIER: RCB */
/*     REMARK 800 SITE_DESCRIPTION: DESIGNATED RECOGNITION REGION IN PRIMARY */
/*     REMARK 800  REFERENCE.  PROPOSED TO AFFECT  SUBSTRATE SPECIFICITY. */
                        if(c11=='S' && strEquAt(0,"SITE_IDENTIFIER: ",T,b+11))  siteRef=toStrgTrim(T,b+28,e);
                        else if(c11=='E' && strEquAt(0,"EVIDENCE_CODE: ",T,b+11)) _mapSiteEvdnc.put(siteRef,toStrgTrim(T,b+26,e));
                        else if(siteRef!=null){
                            if(c11==' ' || c11=='S' && strEquAt(0,"SITE_DESCRIPTION: ",T,b+11)) mapGetBA(siteRef,_mapSiteDescr).aSingleSpaces(0,T,b+(c11==' '?11:28),e);
                        }
                        break;
                    default:continue;
                    }
                    break;
                }
                case'S'|('E'<<8)|('Q'<<16)|('R'<<24):
                    if(c45!=('E'|('S'<<8)) || L<=11) continue;
                    tol=PDB_SEQRES;
                    idxChain=11;
                    break;
                case'A'|('T'<<8)|('O'<<16)|('M'<<24):
                    if(c4>='A' || L<=21) continue;
                    tol=PDB_ATOM;
                    chain=T[b+21];
                    if(T[b+17]==' '){
                        final int c18=T[b+18];
                        if(c18=='D'){
                            if(chainType!=CHAINTYPE_DNA && is(ACTGU,T[b+19])) chainType=CHAINTYPE_DNA;
                        }else if(c18==' '){
                            if(chainType!=CHAINTYPE_RNA && is(ACTGU,T[b+19])) chainType=CHAINTYPE_RNA;
                        }
                    }else if(T[b+12]==' '){
                        if(chainType!=CHAINTYPE_PEP && T[b+13]=='C'&&T[b+14]=='A'&&T[b+15]==' ')  chainType=CHAINTYPE_PEP;
                    }
                    break;
                case'C'|('O'<<8)|('N'<<16)|('E'<<24):if(c456!=('C'|('T'<<8)|(' '<<16))) continue;  tol=PDB_CONECT;break;
                case'T'|('I'<<8)|('T'<<16)|('L'<<24):if(c45!=('E'|(' '<<8))) continue;  tol=PDB_TITLE;break;
                case'H'|('E'<<8)|('A'<<16)|('D'<<24):
                    if(c456!=('E'|('R'<<8)|(' '<<16))) continue;
                    tol=PDB_HEADER;
                    _id4=headerId4(T,b,e);
                    break;
                case'S'|('O'<<8)|('U'<<16)|('R'<<24):
                case'C'|('O'<<8)|('M'<<16)|('P'<<24):
                    if(L>15){
                        final boolean no_lettr_digt[]=chrClas(-LETTR_DIGT),isSource=c0123==('S'|('O'<<8)|('U'<<16)|('R'<<24));
                        if(c45==(isSource?('C'|('E'<<8)):('N'|('D'<<8)))){
                            tol=isSource?(byte)PDB_SOURCE:(byte)PDB_COMPND;
                            for(int i=b+12; L>19 && --i>=b+10;){
                                if(T[i]=='M' && strEquAt(0,"MOL_ID:",T,i)) molid=atoi(T,i+7);
                            }
                            if(molid>128){
                                err(PDB_ERR).aa("MOL_ID:",molid).aln();
                                error=true;
                            }else{
                                chain=(byte)-molid;
                                if(!isSource && strEquAt(0,"CHAIN:",T,b+11)){
                                    for(int i=b+17;i<e;i++){
                                        final byte c=T[i];
                                        if(c<0||no_lettr_digt[c]) continue;
                                        final byte m=_molidForChain[c];
                                        if(m!=0 && m!=c){
                                            err(PDB_ERR).aa("MOL_ID:",molid," Already assigned ",(char)c).aln();
                                            error=true;
                                        }
                                        _molidForChain[c]=(byte)molid;
                                    }
                                }
                            }
                        }
                    }
                    break;
                }/*X switch*/
                skip=idxChain>0 && idxChain>=L;
            } finally{
#define ANY_CHAIN MIN_INT
                typeol[iL]=tol;
                if(skip) _chainOfLine[iL]=0;
                else{
                    IF_GUI(lstLine=iL);;
                    byte ch=idxChain>0?T[b+idxChain]:chain;
                    if(ch==' ') ch=(byte)'_';
                    _chainOfLine[iL]=ch==0?ANY_CHAIN:ch;
                    if(tol==PDB_HETATM || tol==PDB_ATOM){
                        setFstAndLastLineForChain(iL,ch);
                        if(tol==PDB_HETATM) setFstAndLastLineForChain(iL,PDB_HETATM);
/* chain or molid or asterisk */
                        if(ch!=0 && chainType>=0 && DIFF_MC(prevChain,ch)){
                            BA cbt=_chainsByTypeV[chainType];
                            if(cbt==null) cbt=_chainsByTypeV[chainType]=new BA(32);
                            if(strchr(ch,cbt.bytes(),0,cbt.end())<0)   cbt.a((char)ch);
                        }
                    }else{
                        _lstNonAtomLine=iL;
                    }
                }
                if(error){
                    err(PDB_WRN).aFT(T,b,e).aln();
                }
            }
        }/*X for*/
        IF_GUI(_lstLine=lstLine);;
        if(sze(bioChains)>0){
            Matrix3D[]mm=rmNullA(STRUCT_OPER_LIST,Matrix3D.class);
            if(mm==STRUCT_OPER_LIST) mm=mm.clone();
            combineAssemblyIdMatricesAndChains(bioMolecule,mm,bioChains.toStringArray());
        }
        _chainsByType=newChainsByType(_id4);
        FORi(CHAINTYPE_FST,CHAINTYPE_LST_PRIMARY+1){
            final BA cbt=_chainsByTypeV[i];
            final int L=sze(cbt);
            if(L>0){
                _chainsByType[i]=new String[L];
                FORj(0,L)_chainsByType[i][j]=chain1ToChain(chrAt(j,cbt));
            }
        }
    }/*X mc*/
    return _isPdb;
}/*X prepare*/

#if CPP_WITH_GUI

private static void _pdbWriteOnlyChain(int opt,char wantChain,BA txt,java.io.File file){/*X wantChain can be zero*/
    if(!_preparePDB(txt)||wantChain>'z') return;
    if(wantChain==' ') wantChain='_';
    java.io.OutputStream fos=null;
    boolean success=false;
    try{
        for(int iL=0;iL<=_lstLine;iL++){
            final int chn=_chainOfLine[iL],b=iL==0?_B:_eol[iL-1]+1,L=_eol[iL]-b;
            int nWrite=L;
            if(chn>=0 && wantChain!=chn && chn!='_') continue;
            switch(_typeOfLine[iL]){
            case PDB_COMPND:
            case PDB_SOURCE:
                if(0!=(opt&SEQW_ONLY_NT_STRUCTURE) && wantChain!=0 && chn!=-_molidForChain[wantChain]) continue;
                break;
            case PDB_ATOM:
                nWrite=78;
                success=true;
                break;
            case PDB_HETATM:
                if(0!=(opt&SEQW_ONLY_NT_STRUCTURE)) continue;
                nWrite=78;
                success=true;
                break;
            case PDB_CONECT:
                final int a=int6(_T,b+10);
                if(a<FST_LINE_OF_CHAIN[wantChain]||a>=LST_LINE_OF_CHAIN[wantChain]) continue;
                break;
            case PDB_REMARK:
                if(0!=(opt&SEQW_ONLY_NT_STRUCTURE)) continue;
                break;
            }
            if(fos==null && null==(fos=fOutStrm(STREAM_Z_BY_SFX,file))){
                success=false;
                break;
            }
            if(nWrite>L) nWrite=L;
            final int e=b+nWrite;
            if(e<_T.length){
                final byte save=_T[e];
                _T[e]=(byte)'\n';
                fos.write(_T,b,nWrite+1);
                _T[e]=save;
            }else{
                fos.write(_T,b,nWrite);
            }

        }
        if(fos!=null) fos.write(toByts("\nEND\n"),0,5);
    }catch(Exception ex){
        errorEx(ex,"writePdbOnlyChain",file);
    }
    if(file!=null){
        closeStrm(fos);
        if(!success) fileDel(0,file);
    }
}
#endif //CPP_WITH_GUI
/* <<< writePdbOnlyChain <<< */
/* ---------------------------------------- */
/* >>> atoi atof >>> */
private final static int[]D1=new int[256],D0=new int[256],D2=new int[256],D3=new int[256],D4=new int[256],D5=new int[256];
private final static float[]F1=new float[256],F2=new float[256],F3=new float[256];
static{
    ROFk0(7){
        final float[]ff=k==1?F1:k==2?F2:k==3?F3:null;
        final int dd[]= k==0?D0:k==1?D1:k==2?D2:k==3?D3:k==4?D4:k==5?D5:null,fac=power10(k);
        for(int i=10;--i>0;){
            if(dd!=null) dd[i+'0']=fac*i;
            if(ff!=null) ff[i+'0']=((float)i)/fac;}
    }
}
// private static float ufloat32(byte[]cc,int k) { // f6.2 -3
//     return D0[127&cc[k]] + D1[127&cc[k-1]] + D2[127&cc[k-2]] +                             F1[127&cc[k+2]] + F2[127&cc[k+3]];
// }
private static float float33(byte[]T,int k){
    final byte c1=T[k-1],c2=T[k-2];
    final float f= D0[127&T[k]] + D1[127&c1] + D2[127&c2] + F1[127&T[k+2]] + F2[127&T[k+3]] + F3[127&T[k+4]];
    return c1=='-' || c2=='-' || T[k-3]=='-'?-f:f;
}
private static int uInt6(byte[]cc,int k){
    return D0[127&cc[k]] + D1[127&cc[k-1]] + D2[127&cc[k-2]] + D3[127&cc[k-3]] + D4[127&cc[k-4]] + D5[127&cc[k-5]];
}
private static int int4(byte[]cc,int k){
    final int n=D0[127&cc[k]] + D1[127&cc[k-1]] + D2[127&cc[k-2]] + D3[127&cc[k-3]];
    return cc[k-1]=='-' || cc[k-2]=='-' || cc[k-3]=='-'?-n:n;
}
#if CPP_WITH_GUI
private static int int6(byte[]cc,int k){
    final int n=D0[127&cc[k]] + D1[127&cc[k-1]] + D2[127&cc[k-2]] + D3[127&cc[k-3]] + D4[127&cc[k-4]] + D4[127&cc[k-5]];
    return cc[k-1]=='-' || cc[k-2]=='-' || cc[k-3]=='-' || cc[k-4]=='-' || cc[k-5]=='-'?-n:n;
}
#endif //CPP_WITH_GUI
private static int uInt4(byte[]cc,int k){
    return D0[127&cc[k]] + D1[127&cc[k-1]] + D2[127&cc[k-2]] + D3[127&cc[k-3]];
}
private static float float41(byte[]cc,int k){/*X f6.1 -2 */
    final float f= D0[127&cc[k]] + D1[127&cc[k-1]] + D2[127&cc[k-2]] + D3[127&cc[k-3]]  +  F1[127&cc[k+2]];
    return cc[k-1]=='-' || cc[k-2]=='-' || cc[k-3]=='-' || cc[k-4]=='-'?-f:f;
}
/* <<< atoi atof <<< */
/* ---------------------------------------- */
/* >>>  >>> */
#undef SHIFT_RESN
