@*H THIS_CLASS(SPARSER_DSSP)
 This class reads dssp files. See File_example:dssp
 CPP_HASH  RESIDUE AA STRUCTURE BP1 BP2  ACC     N-H-->O    O-->H-N    N-H-->O    O-->H-N    TCO  KAPPA ALPHA  PHI   PSI    X-CA   Y-CA   Z-CA
 1    1 A M              0   0   74      0, 0.0     2,-0.9     0, 0.0     3,-0.1   0.000 360.0 360.0 360.0 130.2    6.5   -0.8  -52.3

 CPP_HASH  RESIDUE AA STRUCTURE BP1 BP2  ACC   N-H-->O  O-->H-N  N-H-->O  O-->H-N    TCO  KAPPA ALPHA  PHI   PSI    X-CA   Y-CA   Z-CA
 1    1 B M              0   0  219    0, 0.0   0, 0.0   0, 0.0   0, 0.0   0.000 360.0 360.0 360.0 178.8   42.9 -119.7   33.4

*@
#define INSERTION 10
#define CHAIN 11
#define FORMAT_LINE "  #  RESIDUE"
final byte[]T=txt.bytes();
final int[]ee=txt.eol();
if(ee.length<5 || strstr(STR_IC,"SECONDARY STRUCTURE DEFINITION",T,txt.begin(),ee[0])<0) return null;
int iZ=0,b,pos_ss=0,pos_x=0,pos_y=0,pos_z=0,pos_aa=0;

FORi(1,ee.length)  if(ee[i]-(b=ee[i-1]+1)>50 && T[b+2]=='#' && strEquAt(0,FORMAT_LINE,T,b)){iZ=i;break;}
if(iZ==0||iZ>ee.length-2){
    baOut("Error in DSSP_Parser ").a("while parsing a DSSP-file.\nCould not find line ").aln(FORMAT_LINE);
    return null;
 }
// determination of tab positions
b=ee[iZ-1]+1;
@*SARRAYeq_STRUCTURE_XCA_YCA_ZCA_AA_ACC
 STRUCTURE=0 X-CA=1 Y-CA=2 Z-CA=3 AA=4 ACC=5
*@

ROFi0(6){
    final int pos=strstr(STR_w,iConst(SARRAYeq_STRUCTURE_XCA_YCA_ZCA_AA_ACC,i),T,b,ee[iZ])-b;
    if(pos<0){
        baOut(RED_ERROR).aa("Error in DSSP_Parser ","Expected ",iConst(SARRAYeq_STRUCTURE_XCA_YCA_ZCA_AA_ACC,i)," in line ").aFT(T,b,ee[iZ]).aln().aln();
        return null;
    }
    if(i==0) pos_ss=pos;
    else if(i==1) pos_x=pos;
    else if(i==2) pos_y=pos;
    else if(i==3) pos_z=pos;
    else if(i==4) pos_aa=pos;
 }
int nAA=0;
for(int i=iZ+1;i<ee.length && ee[i]-ee[i-1]>125;i++){
    b=ee[i-1]+1;
    if(T[b+pos_aa]==' '){/*X || p==null&&T[b+CHAIN]!=' '*/
        //baOut(DEBUG_NOW+" Abgebrochen").a(T[b+CHAIN]).special(DIE_NOW);
        break;
    }
    nAA++;
 }
final byte[]rType=new byte[nAA],secStru=new byte[nAA];
java.util.Arrays.fill(secStru,SECSTRU_UNKNOWN);
byte[]rIns=null;
final int[]rNum=new int[nAA];
final float[]xyz=new float[nAA*3],resAccess=new float[nAA];
int chain=0;
iZ++;
for(int ias=0,ias3=0;ias<nAA; iZ++,ias++,ias3+=3){
    b=ee[iZ-1]+1;
    rNum[ias]=uInt4(T,b+9);
    chain=T[b+CHAIN];
    final byte iCode=T[b+INSERTION];
    if(iCode!=' ') (rIns==null?rIns=rIns=new byte[nAA]: rIns)[ias]=iCode;
    if((rType[ias]=T[b+pos_aa])=='!') continue;
    xyz[ias3  ]=float41(T,b+pos_x+1);
    xyz[ias3+1]=float41(T,b+pos_y+1);
    xyz[ias3+2]=float41(T,b+pos_z+1);
    final byte ss=T[b+pos_ss];
    secStru[ias]=ss=='H'||ss=='E'?ss:SECSTRU_NONE;
    resAccess[ias]=uInt4(T,b+37);
 }
UNLESS_AA(if(p==null)){
    _dsspSS=secStru;
    _dsspAcc=resAccess;
} UNLESS_AA(else){
    p.setResidueType(rType);
    p.setChain(chain1ToChain((char)chain));
    p.setResn(rNum,rIns);
    p.setResidueCalphaXYZ(xyz);
    p.setResidueSolventAccessibility(resAccess);
    p.setResidueSecStrType(secStru);
  }
return DEFAULT_CHAINS_BY_TYPE;
#undef CHAIN
#undef INSERTION
