/* >>> BLAST  >>> */
#if CPP_WITH_BLAST
    private static int[]_isBlastdbSet;
    public static int isBlastdbSet(int t){
        if(_isBlastdbSet==null) _isBlastdbSet=new int[SEQ_BLASTER_ZZZ];
        int b=_isBlastdbSet[t];
        if(b==0){
            final BA log=new BA(333);
            b=CFALSE;
            final String var=iConst(SARRAYeq_BLASTDB_ENV,t);
            if(var==null) return 0;
            final String env=getEnv(var),cmd=iConst(SARRAYeq_BLAST_CMD,t);
            log.aa(cmd,": Environment variable $",var," = ",env);
            if(sze(env)>0){
                log.a(" is ");
                if(isDir(file(getEnv(var)))) {b=CTRUE; log.a("not ");}
                log.a("a directory.");
            }
            log.aln(ANSI_RESET);
            if(b==CTRUE){
                log.aa(cmd,ANSI_FG_RED+" Command ");
                if(INT_NAN==rtExecV(0*EXEC_NO_ERROR,oo(cmd))) b=CFALSE;
                else log.a("not ");
                log.a("found"+ANSI_RESET);
            }
            baLog(LOG_BLAST).aln(log);
            baLog(LOG_BLAST4SEQ).aln(log);

            _isBlastdbSet[t]=b;
        }
        return b;
    }
#endif //CPP_WITH_BLAST
/* <<< BLAST <<< */
/* ---------------------------------------- */
/* >>> Alignment  >>> */
    public static BA alignResultToText(int opt,Object[]result,BA sb){
        if(sb==null) sb=new BA(999);
        //sb.a(isInverse?" Inverse:\n": "");
        if(result[ALIGNRESULT_MATRIX]!=null) ((Matrix3D)result[ALIGNRESULT_MATRIX]).toText((opt&S3D_PRINT_HUMAN_READABLE)!=0?MTRX_FORMAT_EXPLAIN: MTRX_FORMAT_XML,(opt&S3D_PRINT_HUMAN_READABLE)!=0?"mobile ":null,sb);
        final byte[][]gg=(byte[][])result[ALIGNRESULT_GAPPED];
        if(!ARRAY_EMPTY(gg)){
            if((opt&S3D_PRINT_HUMAN_READABLE)==0) sb.aln("<alignment>");
            final int ii[]=(int[])result[ALIGNRESULT_INDICES_OF_SEQUENCES];
            FORi(0,gg.length){
                final int idx=sze(ii)>=gg.length?idxOf(i,ii): i;
                sb.aa('s',idx).an(' ',S3D_COLUMN_SEQUENCE-1-strSzeOfInt(idx)).aln(gg[idx]);
            }
            if((opt&S3D_PRINT_HUMAN_READABLE)==0) sb.aln("</alignment>");
        }
        sb.and(" Score=",result[ALIGNRESULT_SCORE]).and(" Rmsd=",result[ALIGNRESULT_RMSD]);  /*X .aFloat(((Float)result[ALIGNRESULT_RMSD]).floatValue(),0,4);*/
        return sb;
    }
    REFLECTION_PUBLIC_STATIC Runnable alignProteins(int opt,SequenceAligner a,Object vP IF_GUI(,boolean[]shouldStop)){/*X vP is Collection or Array*/
        final Protein[]pp=spp(vP);
        if(pp.length>1){
            IF_GUI(if(OPT_RETURN_THREAD(opt)) return CPP_thrdMS(alignProteins,Strap,io(opt),a,pp,shouldStop));;
            if(a==null) a=sclInstanceSA(MKINSTANCE_SHOW_ERROR,pp,null);
            IF_GUI(final boolean[]isInterrupted=isInterrupted(shouldStop,a));;
            IF_GUI(addActLiMain(a));;
            IF_GUI(_vCanBeStopped.add(a));;
            final Object[]result=a.computeAlignment(0,pp);
            IF_GUI(_vCanBeStopped.remove(a));;
            final byte[][]aligned=(byte[][])iThEl(ALIGNRESULT_GAPPED,result);
#define thisMethod "alignProteins(...) "
            if(sze(aligned)==0) baOut(RED_ERROR).a(thisMethod).aln("aligned=null");
            else if(aligned.length<pp.length) baOut(RED_ERROR).aa(thisMethod," aligned.length=",aligned.length," pp.length=",pp.length).aln();
            else{
                IF_GUI(runCR1(RUN_ALIGN_SET_INTERRUPTED_BOOLARRAY,a,isInterrupted));;
                new AcceptAlignment2(pp,0,aligned);
                final int[]ii=0!=(opt&ALIGN_CHANGE_ORDER)?(int[])result[ALIGNRESULT_INDICES_OF_SEQUENCES]:null;
                if(sze(ii)>=pp.length){
                    ROFi0(ii.length) pp[i].setIntProperty(PROTEINI_PREFERRED_ORDER,ii[i]);
                    IF_AA(Strap._infOrderLater=true);;
                    UNLESS_AA(strapInferOrderOfProteins(SORT_PREFORDER,pp));;
                }
                strapEvtDispatch(EVT_ALIGNMENT|SEVTMS*1);
            }
            IF_GUI(interruptComputation(shouldStop,a));;
        }
        return null;
#undef thisMethod
    }
/* <<< Alignment <<< */
/* ---------------------------------------- */
/* >>> Superimpose >>> */
    public CPP_sync static TYPE_ALIGN_RESULT superimposeTwoProteins(int opt,Object clazz,Protein pM,Protein pR){
        if(!hasCalpha(pM) || !hasCalpha(pR)) return null;
        IF_GUI(if(0!=(opt&SUPERIMP_COMPLEX_BEST) && sze(pM.getProteinsSameComplex())+sze(pR.getProteinsSameComplex())>0)  return superimposeTwoComplexes(pM,pR));;
        if(clazz==null) clazz=sclDefaultForInterface(INTRFC_Superimpose3D);
        SequenceAligner a=derefZ(clazz,SequenceAligner.class);
        if(a==null&&null==(a=(SequenceAligner)mkInstance(iCLASS_SequenceAligner,clazz))) return null;
        IF_GUI(_vCanBeStopped.add(a));;
        final TYPE_ALIGN_RESULT result=a.computeAlignment(opt,new Protein[]{pR,pM});
        IF_GUI(_vCanBeStopped.remove(a));;
        if(result==null && 0!=(opt&OPT_ALIGN_NO_ERROR)) baOut(RED_WARNING).aa("superimposeTwoProteinsM result==null for pM=",pM," pR ").aln(pR);
        return result;}

    public static boolean hasCalpha(Protein p) {return p!=null && 0!=(p._flags&(PFLAG_HAS_CALPHA|PFLAG_HAS_XYZ));}
    public static boolean hasXYZ(Protein p) {return p!=null && 0!=(p._flags&(PFLAG_HAS_XYZ));}
    public static int structureWhichRepresentsOthers(boolean getBest,TYPE_ALIGN_RESULT rrr[][]){
    scoreOrRmsd:
        ROFt0(2){/*X score*/
            int best=-1;
#define higherIsBetter (getBest==(t==1))
            double highest=higherIsBetter?0:Double.MAX_VALUE;
            FORi(0,rrr.length){
                double sum=0;
                FORj(0,rrr.length){
                    final TYPE_ALIGN_RESULT result=rrr[i][j];
                    if(result!=null){
                        final Object o=result[t==0?ALIGNRESULT_RMSD:ALIGNRESULT_SCORE];
                        final float f=xatof(o);
                        if(Float.isNaN(f)) continue scoreOrRmsd;
                        else sum+=f*f;
                    }
                }
                if(higherIsBetter?highest<sum: highest>sum){
                    highest=sum;
                    best=i;
                }
            }
#undef higherIsBetter
            if(best>=0) return best;
        }
        return -1;
    }
    IF_GUI(private static int _countSP);;
    REFLECTION_PUBLIC_STATIC Runnable superimposeProteins(int opt,Object vP IF_GUI(,boolean[]shouldStop)){
        IF_GUI(if(OPT_RETURN_THREAD(opt)) return CPP_thrdMS(superimposeProteins,Strap,io(opt),vP,shouldStop));;
        IF_GUI(final boolean[]isInterrupted=isInterrupted(shouldStop,null));;
        final Protein[]pp=spp(vP);
        IF_GUI(_isSuperimposing=true);;
        int count=0;
        final TYPE_ALIGN_RESULT[][]rrr=new Object[pp.length][pp.length][];
        for(int IF_GUI(timePG=0,) i=0;i<pp.length;i++){
            FORj(0,pp.length){
                final Protein pi=pp[i],pj=pp[j];
                if(i==j||pi==null||pj==null) continue;
                IF_GUI(if(iThBool(0,isInterrupted)) break);;
                IF_GUI(++count);;
                if(pi!=pj&&pi.xyzByID(false)!=null && pj.xyzByID(false)!=null){
                    rrr[i][j]=superimposeTwoProteins(opt,null,pi,pj);
                    IF_GUI(if(timeOn()-timePG>200) {timePG=timeOn(); baLog(LOG_MSG).aa('#',++_countSP,' ',count,'/',pp.length*pp.length,' ',pi," ./. ").aln(pj);});;
                }
            }
        }
        {
            final int iBest=structureWhichRepresentsOthers(true,rrr);
            if(iThProt(iBest,pp)!=null){
                baLog(LOG_MSG).aa(count," Superpositions done. Reference protein=").aln(iThProt(iBest,pp));
                FORi(0,pp.length){
                    final Protein p=pp[i];
                    if(p!=null){
                        final Matrix3D m=i==iBest?null:(Matrix3D)iThEl(ALIGNRESULT_MATRIX,rrr[i][iBest]);
                        p.setRotationAndTranslation(m);
                        if(0!=(opt&SUPERIMP_COMPLEX_BEST)) for(Protein p2:p.getProteinsSameComplex()) p2.setRotationAndTranslation(m);
                    }
                }
            }
        }
#if CPP_WITH_GUI
        _isSuperimposing=false;
        interruptComputation(shouldStop,null);
        if(0!=(opt&SUPERIMP_EVENT) && sze(vP)>0) strapEvtDispatch(EVT_PROTEIN_3D_MOVED);
#endif //CPP_WITH_GUI
        return null;
    }
/* <<< Superimpose <<< */
/* ---------------------------------------- */
/* >>> Align-Utils Leading Trailing >>> */
    private static int[]leadingAndTrailingLowerCaseLettersInMSA(Protein[]pp){
        if(ARRAY_EMPTY(pp)) return null;
        int firstU=MAX_INT,lastU=0;
        boolean onlyUC=true;
        final boolean[]uppr=chrClas(UPPR);
        for(Protein p:pp){
            if(p==null) continue;
            final byte[]bb=p.getResType();
            final int L=mini(bb.length,p.countRes());
            {
                final int fU=nxt(uppr,bb,0,L);
                if(fU>0) onlyUC=false;
                firstU=mini(firstU,p.getResColumnAt(fU));
            }
            final int lU=nxtBwd(0,uppr,bb,L-1,-1);
            if(lU!=L-1) onlyUC=false;
            lastU=maxi(lastU,p.getResColumnAt(lU));
        }
        if(onlyUC) return null;
        for(Protein p:pp){
            if(p!=null){
                final int fU=nxt(0,uppr,p.getResType());
                if(fU>0 && p.getResColumnAt(fU-1)>=firstU) return null;
            }
        }
        return firstU>0 && firstU<lastU?new int[]{firstU,lastU}:null;
    }
/* <<< Align-Utils <<< */
/* ---------------------------------------- */
/* >>> Align-Utils Letters  >>> */
/* public static int firstLetter(byte[]s1,byte[]s2){ */
/*     if(s1==null || s2==null) return -1; */
/*     final boolean[]lettr=chrClas(LETTR); */
/*     for(int col=0;col<s1.length && col<s2.length;col++) if(isChrClas(lettr,s1,col) && isChrClas(lettr,s1,col)) return col; */
/*     return -1; */
/* } */

/* ---------------------------------------- */
/* >>> Align-Utils Blosum >>> */
@*SARRAYeq_BLOSUM62
     4=ASCII_A
     -2 4=ASCII_B
     0 -3 9=ASCII_C
     -2 4 -3 6=ASCII_D
     -1 1 -4 2 5=ASCII_E
     -2 -3 -2 -3 -3 6=ASCII_F
     0 -1 -3 -1 -2 -3 6=ASCII_G
     -2 0 -3 -1 0 -1 -2 8=ASCII_H
     -1 -3 -1 -3 -3 0 -4 -3 4=ASCII_I
     -1 0 -3 -1 1 -3 -2 -1 -3 -99 5=ASCII_K
     -1 -4 -1 -4 -3 0 -4 -3 2 -99 -2 4=ASCII_L
     -1 -3 -1 -3 -2 0 -3 -2 1 -99 -1 2 5=ASCII_M
     -2 3 -3 1 0 -3 0 1 -3 -99 0 -3 -2 6=ASCII_N
     -1 -2 -3 -1 -1 -4 -2 -2 -3 -99 -1 -3 -2 -2 -99 7=ASCII_P
     -1 0 -3 0 2 -3 -2 0 -3 -99 1 -2 0 0 -99 -1 5=ASCII_Q
     -1 -1 -3 -2 0 -3 -2 0 -3 -99 2 -2 -1 0 -99 -2 1 5=ASCII_R
     1 0 -1 0 0 -2 0 -1 -2 -99 0 -2 -1 1 -99 -1 0 -1 4=ASCII_S
     0 -1 -1 -1 -1 -2 -2 -2 -1 -99 -1 -1 -1 0 -99 -1 -1 -1 1 5=ASCII_T
     0 -3 -1 -3 -2 -1 -3 -3 3 -99 -2 1 1 -3 -99 -2 -2 -3 -2 0 -99 4=ASCII_V
     -3 -4 -2 -4 -3 1 -2 -2 -3 -99 -3 -2 -1 -4 -99 -4 -2 -3 -3 -2 -99 3 11=ASCII_W
     2 2 2 2 2 2 2 2 2 -99 2 2 2 2 -99 2 2 2 2 2 -99 2 2 4=ASCII_X
     -2 -3 -2 -3 -2 3 -3 2 -1 -99 -2 -1 -1 -2 -99 -3 -1 -2 -2 -2 -99 -1 2 -1 7=ASCII_Y
*@

    private static byte[]_simMx[][];
    private static byte[]_lys2k[];
    public static byte[][]similarityMatrix(int id){
        if(_simMx==null){
            final byte[][][]mmm=new byte[SIMILARITY_MATRIX_ZZZ][][];
            {
                final byte[]bbb[]=mmm[SIMILARITY_MATRIX_BLOSUM62]=new byte[128][];
                {
                    final byte[]row=new byte['Z'-'A'];
                    final BA[]aa=arryBA(SARRAYeq_BLOSUM62);
                    final ChTokenizer t=new ChTokenizer(SPC);
                    Arrays.fill(bbb,new byte[128]);
                    Arrays.fill(bbb[0],(byte)-99);
                    FORi('A','Z'){
                        bbb[i]=bbb[32|i]=bbb[0].clone();
                        if(xiThEl(i,aa)!=null) System.arraycopy(byteArrayFromTok(t.setText(aa[i]),row),0,bbb[i],'A','Z'-'A');
                    }
                    FORi('A','Z'){
                        for(int j='A';j<=i;j++){/*X 4  Sonst macht MSE=U bei ATOM-SEQRES-Alignment ein Problem*/
                            if(-99==(bbb[i][j|32]=bbb[j][i]=bbb[j][i|32]=bbb[i][j]) && i==j) bbb[i][i]=4;
                        }
                    }
                    Arrays.fill(bbb['*']=new byte[128],(byte)-4);
                }
                {
                    final byte[]mid[]=mmm[SIMILARITY_MATRIX_BLASTMIDLINE]=new byte[128][],b2s[]=mmm[SIMILARITY_MATRIX_BL2SEQ_MIDLINE]=new byte[128][];
                    Arrays.fill(mid,new byte[128]);
                    Arrays.fill(mid[0],(byte)' ');
                    Arrays.fill(b2s,mid[0]);
#define JOU(i) i=='J'||i=='O'||i=='U'
                    FORi('A','Z'){
                        b2s[i]=b2s[32|i]=mid[0].clone();
                        mid[i]=mid[32|i]=mid[0].clone();
                        FORj('A','Z'){
                            if(!(JOU(i)||JOU(j))){
                                final byte m=bbb[i][j];
                                b2s[i][j]=b2s[i][j|32]=(byte)(i==j?'|':m>2?':':m>0?'.':' ');
                                mid[i][j]=mid[i][j|32]=(byte)(i==j?i:m>0?'+':' ');
                            }
                        }
                    }
#undef JOU
                }
            }
            {
                final byte[]nuc[]=mmm[SIMILARITY_MATRIX_NUC]=new byte[128][],cmp[]=mmm[SIMILARITY_MATRIX_COMPL]=new byte[128][];
                Arrays.fill(nuc,new byte[128]);
                Arrays.fill(cmp,nuc[0]);
                FORi('A','Z'){
                    if(is(ACTGU,i)){
                        nuc[i]=nuc[32|i]=new byte[128];
                        cmp[i]=cmp[32|i]=new byte[128];
                        FORj('A','Z'){
                            final int a=i=='U'?'T':i,b=j=='U'?'T':j,ab=a|(b<<8);
                            nuc[i][j]=nuc[i][j|32]=(byte)(a==b?3:-3);
                            cmp[i][j]=cmp[i][j|32]=(byte)(ab==('A'|('T'<<8))||
                                                          ab==('C'|('G'<<8))||
                                                          ab==('G'|('C'<<8))||
                                                          ab==('T'|('A'<<8))?3:-3);
                        }
                    }
                }
            }
            _simMx=mmm;
        }
        return _simMx[id];
    }
/* <<< Align-Utils Blosum <<< */
/* ---------------------------------------- */
/* >>> Align-Utils score >>> */
/*      http://www.gsic.titech.ac.jp/supercon/supercon2003e/alignmentE.html    */
    public static float pairAignScore(float gapOpen,float gapExt,byte[]s0,byte[]s1,int fromCol,int toCol,float addConstant){
        final byte[][]b62=similarityMatrix(SIMILARITY_MATRIX_BLOSUM62);
        boolean isGap=false,end0=false,end1=false;
        float score=0;
        for(int L=mini(sze(s0),sze(s1),toCol),i=fromCol;i<L;i++){
            final byte c0=s0[i],c1=s1[i];
            if(c0==0) end0=true;
            if(c1==0) end1=true;
            final boolean
                letter0=!end0 && IS_UPPER_OR_LOWER(c0),
                letter1=!end1 && IS_UPPER_OR_LOWER(c1);
            if(!letter0 && !letter1) continue;
            else if(letter0 && letter1){
                score+=b62[c0][c1]+addConstant;
                isGap=false;
            }else{
                score+=+(isGap?gapExt:gapOpen);
                isGap=true;
            }
        }
        return score;
    }
/* <<< Align-Utils Blosum <<< */
/* ---------------------------------------- */
/* >>> Align-Utils To Text >>> */

    public static BA aliToTxt(int opt,byte gapped[][],BA sb){
        if(sb==null) sb=new BA(0);
        {
            int size=sze(gapped)*(1+12);
            if(size==0) return sb;
            for(byte[]bb:gapped) size+=bb.length;
            sb.ensureCapacity(sb.end()+size);
        }
        final char pfx=0!=(opt&ALITXT_PFX_p)?'p':'s';
        for(int max=maxSze(gapped),OFFSET=opt&ALITXT_OFFSET_MASK,WIDTH=0!=(opt&ALITXT_FOLD_100)?100:max,from=0;from<max; from+=WIDTH){
            FORi(0,gapped.length){
                final byte[]above=0!=(opt&ALITXT_ANSI)&&i>0?gapped[i-1]:null,below=0!=(opt&ALITXT_ANSI) && i+1<gapped.length?gapped[i+1]:null;
                if(0!=(opt&ALITXT_FASTA)) sb.aa('>',pfx,i+OFFSET).aln();
                else if(0!=(opt&ALITXT_PFX_SEQRES_ATOMS)) sb.a(i==0?"SEQRES ":"ATOM   ");
                else sb.a(pfx).an('0',8-strSzeOfInt(i+OFFSET)).aa(i+OFFSET,' ');
                final byte[]gg=gapped[i];
                int red=0;
                final int to=mini(from+WIDTH,gg.length);
                FORj(from,to){
                    byte c=gg[j];
                    if(c==0) break;
                    if(!is(LETTR,c)) c='-';
                    if(c!='-' && 0!=(opt&ALITXT_ANSI) && (above!=null&&c!=iThByte(j,above) || below!=null&&c!=iThByte(j,below))){
                        if(red++==0) sb.a(ANSI_FG_RED);
                    }else if(red!=0){
                        sb.a(ANSI_RESET);
                        red=0;
                    }
                    sb.a((char)c);
                }
                if(red!=0)sb.a(ANSI_RESET);
                sb.aln();
            }
        }
        return sb;
    }
    public static BA toUngappedMultipleFasta(byte sequences[][],String prefix,int offset){
        int size=0;
        for(byte[]s:sequences) size+=s.length+20;
        final BA sb=new BA(size);
        FORi(0,sequences.length){
            sb.aa('>',prefix,offset+i).aln();
            for(byte c:sequences[i]) if(IS_UPPER_OR_LOWER(c)) sb.a((char)c);
            sb.aln();
        }
        return sb;
    }
/* <<< Align-Utils To Text <<< */
/* ---------------------------------------- */
/* >>> Align-Utils MergeAlignments  >>> */
    public static int[][]mergeAlignments(int[]startIdx,byte soll[][],final byte ist[][]){
        final int R=ist.length,inserts[][]=new int[R][],insertsAtCol[][]=new int[R][],colIst[][]=new int[R][],col2aSoll[][]=new int[R][];
        for(int r=0;r<R;r++){
            col2aSoll[r]=column2letterIdx(soll[r]);
            {
                final int start=startIdx==null?countChrClas(chrClas(LETTR),ist[r],0,idxOfLetters(soll[r],ist[r],0,MAX_INT)): iThInt(r,startIdx);
                if(start>0) ROFi0(col2aSoll[r].length) if(col2aSoll[r][i]>=0) col2aSoll[r][i]+=start;
            }
            colIst[r]=letterIdx2column(ist[r]);
            inserts[r]=new int[countChrClas(chrClas(LETTR),ist[r],0,MAX_INT)];
            insertsAtCol[r]=new int[ist[r].length];
        }
        final int[]sumInserted=new int[R],toBeInserted=new int[R];
        boolean busy=true;
        for(int c=0;busy;c++){
            busy=false;
            Arrays.fill(toBeInserted,0);
            int minInserted=0;
            for(int r=0;r<R;r++){
                if(c<col2aSoll[r].length){
                    busy=true;
                    final int iAa=col2aSoll[r][c];
                    if(0<=iAa && iAa<colIst[r].length){/*X  catch the case that soll-sequ longer than ist-sequ*/
                        toBeInserted[r]=c-colIst[r][iAa]-sumInserted[r];
                        if(minInserted>toBeInserted[r]) minInserted=toBeInserted[r];
                    }
                }
            }
            for(int r=0;r<R;r++){
                if(col2aSoll[r].length<=c) continue;
                final int iAa=col2aSoll[r][c];
                if(iAa<0) continue;
                final int ins=toBeInserted[r]-minInserted;
                if(inserts[r].length>iAa){
                    inserts[r][iAa]=ins;
                    if(colIst[r].length>iAa){
                        insertsAtCol[r][colIst[r][iAa]]=ins;
                        sumInserted[r]+=ins;
                    }
                }
            }
        }
        return insertsAtCol;
    }
    private static int[]letterIdx2column(byte[]text){
        final int[]indices=new int[countChrClas(chrClas(LETTR),text,0,MAX_INT)];
        for(int i=0,iLetter=0;i<text.length;i++){
            final int b=text[i];
            if(IS_UPPER_OR_LOWER(b)) indices[iLetter++]=i;
        }
        return indices;
    }
    private static int[]column2letterIdx(byte[]text){
        final int[]indices=new int[text.length];
        Arrays.fill(indices,-1);
        final boolean[]lettr=chrClas(LETTR);
        for(int i=0,iLetter=0;i<text.length;i++) if(text[i]>0 && lettr[text[i]]) indices[i]=iLetter++;
        return indices;
    }
/* <<< Align-Utils MergeAlignments <<< */
/* ---------------------------------------- */
/* >>> Align-Utils Perfect >>> */
    public static byte[][]gappedForPerfectMatch(byte[]...ungapped){
        if(ungapped.length!=2) return null;
        final int iNeedle,iHaystack;
        if(ungapped[0].length<ungapped[1].length) {iNeedle=0; iHaystack=1;}else{iNeedle=1; iHaystack=0;}
        final int idx=strstr(STR_IC,ungapped[iNeedle],ungapped[iHaystack]);
        byte[][]gapped=null;
        if(idx>0){
            final byte[]seq=new byte[ungapped[iHaystack].length];
            System.arraycopy(ungapped[iNeedle],0,seq,idx,ungapped[iNeedle].length);
            Arrays.fill(seq,0,idx,(byte)' ');
            gapped=new byte[2][];
            gapped[iHaystack]=ungapped[iHaystack];
            gapped[iNeedle]=seq;
            return gapped;
        }
        return gapped;

    }
/* <<< Perfect <<< */
/* ---------------------------------------- */
/* >>> Align-Utils Count identical >>> */
    public static long alignmentIdentity(byte[]s1,byte[]s2,int from,int to){
        if(s1==null || s2==null) return 0;
        int ident=0,count=0;
        for(int L=mini(s1.length,s2.length,to),i=from;i<L;i++){
            final int b1=s1[i]|32,b2=s2[i]|32;
            if(IS_LOWER(b1)&&
               IS_LOWER(b2)){
                count++;
                if(b1==b2) ident++;
            }
        }
        return(((long)ident)<<NUMERATOR_SHIFT)|count;
    }
/* <<< Align-Utils Count identical <<< */
/* ---------------------------------------- */
/* >>> Align-Utils Cache >>> */
    public static BA cacheKeyForSeq(Object s,BA ba){
        final int L=s instanceof byte[]?strLen((byte[])s):sze(s);
        if(ba==null) ba=new BA(44);
        if(L==0) return ba;
        final int e=ba.end();
        return ba.aFT(s,0,4).a('-').aFT(s,maxi(L-4,4),L).a('-').aHex(hashCdLUC(s,0,MAX_INT)).toUpperOrLowerE(FILTER_TO_UPPER,e).a('_');
    }
    public static String cacheKeyForSeqAsStrg(Object s,BA ba){
        if(s instanceof Protein){
            Object cache[]=((Protein)s).cached(),k=cache[P_CACHE_KEY4RESIDUES];
            if(k==null) cache[P_CACHE_KEY4RESIDUES]=k=cacheKeyForSeqAsStrg(((Protein)s).getResTypeUC(),ba);
            return(String)k;
        }
        return s(cacheKeyForSeq(s,ba));
    }
/* <<< Align-Utils Cache <<< */
/* ---------------------------------------- */
/* >>> Align-Utils Text >>> */
@*SARRAYeq_ONELETTER_TO_AMINOACID_NAME
     Alanine=ASCII_A
     Cysteine=ASCII_C
     Aspartate=ASCII_D
     Glutamate=ASCII_G
     Phenylalanine=ASCII_F
     Glycine=ASCII_G
     Histidine=ASCII_H
     Isoleucine=ASCII_I
     Lysine=ASCII_K
     Leucine=ASCII_L
     Methionine=ASCII_M
     Asparagine=ASCII_N
     Proline=ASCII_P
     Glutamine=ASCII_Q
     Arginine=ASCII_R
     Serine=ASCII_S
     Threonine=ASCII_T
     Valine=ASCII_V
     Tryptophan=ASCII_W
     Tyrosine=ASCII_Y
*@
    public static char textHasAminoAcid(String n){
        final int lst=lstChar(n)|32;
        if(lst=='n'||lst=='e'){
            final String[]nn=arry(SARRAYeq_ONELETTER_TO_AMINOACID_NAME);
            FORi('A',nn.length) if(strstr(STR_IC|STR_w,nn[i],n)>=0) return(char)i;
        }
        return 0;
    }
/* <<< Align-Utils Text <<< */
/* ---------------------------------------- */
/* >>> gapped >>> */
    private static Gaps2Columns _g2c;
    public static Gaps2Columns strapG2C(){/*X strapG2C() */
        if(_g2c==null) (_g2c=new Gaps2Columns()).setProteinsV(strapProteinsV(PROTEINS_IN_ALI),Protein.MC_GLOBAL);
        return _g2c;
    }
/* <<< gapped <<< */
/* ---------------------------------------- */
