@*H THIS_CLASS(ALIWR_HSSP)
   This class reads protein files like http://www.bioinformatics.org/strap/data/fileFormats/example.hssp.txt
*@

@*~RSC_HSSP_ERROR_REQUIRES_REF
 ERROR:
 The HSSP-format requires a reference protein with 3D coordinates.
 Please indicate the reference protein by placing the alignment cursor on the protein
*@
public static Collection _hssp(Object[]para,BA sb){
    final Collection<byte[]>vTxt=new ArrayList();
    String[]names=(String[])para[ALIWR_PARA_NAMES];
    sb.aln("HSSP       HOMOLOGY DERIVED SECONDARY STRUCTURE OF PROTEINS ");
    final Protein withSecStr=strapCursorProtein();
    if(withSecStr==null){
        sb.aln(rsc(RSC_HSSP_ERROR_REQUIRES_REF)).bytesToCollection(vTxt);
        return vTxt;
    }
    final int[]colFromTo=(int[])para[ALIWR_PARA_COL_RANGE];
    int firstAA=withSecStr.columnToIndex(CFALSE,colFromTo==null?0:colFromTo[RANGE_FROM]);
    final int lastAA=withSecStr.columnToIndex(CFALSE,colFromTo==null?9999999:colFromTo[RANGE_TO]-1);
    sb.aln("# the structure file is the one of the alignment cursor\n# structure file=").aa(withSecStr.getName()," fromIdx=",firstAA," toIndex=",lastAA).bytesToCollection(vTxt);
    if(_aliwrPP==null) return vTxt;
    if(idxOf(withSecStr,_aliwrPP)<0){
        final int n=_aliwrPP.length;
        final Protein[]prots=new Protein[n+1];
        prots[n]=withSecStr;
        System.arraycopy(_aliwrPP,0,prots,0,n);
        _aliwrPP=prots;
        names=chSze(names,n+1);
        names[n]=withSecStr.getName();
    }
    sb.aPlrl(_aliwrPP.length,"\n# NUMBER OF PROTEINS: %n\n# PROTEINS: ").joinSpc(names).aln();
    if(firstAA<0) firstAA=0;
/*X transpose */
        final int hMax=maxColumn(_aliwrPP);
        final byte[][]ali=new byte[_aliwrPP.length][hMax],aliTranspon=new byte[hMax][_aliwrPP.length];
        FORj(0,hMax){
            FORi(0,_aliwrPP.length)ali[i][j]=aliTranspon[j][i]=32;
        }
        FORi(0,_aliwrPP.length){
            final Protein p=_aliwrPP[i];
            final byte[]aa=p.getResType();
            final int cc[]=p.getResColumn(),n=p.countRes();
            FORj(0,n){
                final byte b=(byte)(aa[j]&~32);
                if(IS_UPPER(b)){
                    final int pos=cc[j];
                    if(pos<hMax) ali[i][pos]=aliTranspon[pos][i]=b;
                }
            }
        }

    int iBlock=0;
    sb.bytesToCollection(vTxt);
    while(_exportHSSP(sb,iBlock++,withSecStr,firstAA,lastAA,ali,aliTranspon)) sb.bytesToCollection(vTxt);
    sb.aln("## ").bytesToCollection(vTxt);
    return vTxt;
}
// ----------------------------------------
private static boolean _exportHSSP(BA sb,int iBlock,Protein withSecStr,int firstAA,int lastAA,byte[][]ali,byte[][]aliTranspon){
    if(ali.length<1) return false;
    boolean anOtherBlock=true;
    final int colMin=iBlock*70;
    int colMax=(iBlock+1)*70;
    if(ali.length<=colMax) {colMax=ali.length; anOtherBlock=false;}
    if(iBlock==0){
        sb.aa("SEQLENGTH   ",lastAA-firstAA)
            .aPlrl(ali.length,"\nNALIGN       %n\n  NR.    ID         STRID   %IDE %WSIM IFIR ILAS JFIR JLAS LALI NGAP LGAP LSEQ2 ACCNUM     PROTEIN").aln();
    }
    sb.aa("## ALIGNMENTS    ",colMin+1,"  -  ",colMax,"\n SeqNo  PDBNo AA STRUCTURE BP1 BP2  ACC NOCC  VAR  ");
    // ....:....1....:....2....:....3....:....4....:....5....
    FORi(0,ali.length){
        char c='.';
        if(i%10==4) c=':';
        if(i%10==9) c= (char)(((i+1)/10)%10+'0');
        sb.a(c);
    }
    sb.a('\n');
    final byte[]resType=withSecStr.getResType(),secStr=withSecStr.getResidueSecStrType();
    final float[]acc=withSecStr.getResidueAccessibility1(0);
    final int J=mini(withSecStr.countRes(),lastAA),start=withSecStr.subsetStart();
    FORj(firstAA,J){
        sb
            .aInt(j+1-firstAA,6)
            .aInt(withSecStr.resnAt(0,j),5)
            .an(' ',3)
            .a((char)resType[j])
            .aa("  ",(char)(maxi(' ',iThByte(j+start,secStr)))).a("           0   0")
            .aInt((int)iThFloat(j+start,acc),5).aInt(1,10).a("  ").aFT(aliTranspon[j],colMin,colMax).a('\n');
    }
    return anOtherBlock;
}
