#define U (1<<1)
#define I (1<<3)
#define FONT (1<<4)
#define SPAN (1<<5)
#define TAGS 6
static class HtmlUtil{
    private int _fg,_bg=-1,_current;
    private final boolean _omitBG;
    private final BA _sb;
    public BA reset(){
        set(-1,0,-1);
        return _sb;
    }
    public HtmlUtil(BA sb,boolean noBG){
        _sb=sb;
        _omitBG=noBG;
    }
/*X  Frequently changing tags first */
    public void set(int style0,int fg,int bg){
        if((0xFFffFF&bg)==0xFFffFF) bg=-1;
        if(_sb==null) return;
        int current=_current;
        int style=style0==-1?0:style0|(fg!=_fg?FONT:0)|(_current&FONT)|(bg!=_bg?SPAN:0)|(_current&SPAN);
        if(bg==-1) style=style&(~SPAN);
        if(fg==0)  style=style&(~FONT);
        FORi(0,TAGS){
            final int bit=1<<i;
            if((current&bit)!=(style&bit) || bit==FONT && fg!=_fg || bit==SPAN && bg!=_bg){
                for(int j=0;j<=i;j++){
                    final int bitJ=1<<j;
                    if((current&bitJ)!=0){
                        _sb.a(bitJ==U?"</U>": bitJ==HTMLUTIL_BOLD?"</B>": bitJ==I?"</I>": bitJ==FONT?"</FONT>": "</SPAN>");
                        current&=~bitJ;
                    }
                }
            }
        }
        if(style0==-1){
            _current=0;
        }else{
            for(int i=TAGS;--i>0;){
                final int bit=1<<i;
                if(((style&bit)!=0) && (current&bit)==0){
                    if(bit==FONT) _sb.a("<FONT color=\"#").aHex(fg,6).aCC('"','>');
                    else if(bit==SPAN && !_omitBG) _sb.a("<SPAN style=\"background-color:#").aHex(bg,6).a(";\">");
                    else _sb.a(bit==U?"<U>": bit==HTMLUTIL_BOLD?"<B>": bit==I?"<I>": "<SPAN>");
                    current|=bit;
                }
            }
            _current=current;
        }
        _bg=bg;
        _fg=fg;
    }
}

#undef FONT
#undef I
#undef SPAN
#undef TAGS
#undef U
