/* >>> Default aligner >>> */
public static SequenceAligner sclInstanceSA(int opt,Protein[]pp,Object o){
    IF_MEIN_DEBUG(final Object o0=o);;
    if(o==null) o=sclDefaultForInterface(INTRFC_SequenceAligner);
    final SequenceAligner sa=(SequenceAligner)mkInstance(opt|iCLASS_SequenceAligner,o);
    if(sa!=null){
        if(pp!=null&&0!=(sa.getPropertyFlags()&ALIGNER_FLAGS_3D)){
            for(Protein p:pp){
                if(!hasCalpha(p)){
                    final SequenceAligner sa3d=(SequenceAligner)mkInstanceBid(BUT_C1(AlignerCombine1d3d));
                    runCR1(RUN_ALIGNER_COMBINED_SET_CLASS_3D,sa3d,o);
                    return sa3d;
                }
            }
        }
        if(sze(pp)>2 && (sa.getPropertyFlags()&ALIGNER_FLAGS_ONLY_TWO_SEQUENCES)!=0){
            final SequenceAligner a=(SequenceAligner)mkInstanceBid(BUT_C1(MultiFromPairAligner));
            runCR1(RUN_MSA_FROM_PAIRALIGNMENTS_SET_CLASS,a,o);
            return a;
        }
    }
#if CPP_WITH_MEIN_DEBUG
    else{
        baOut(RED_WARNING).aa("sclInstanceSA o=",o," o0=").aln(o0);
        assrt();
    }
#endif //CPP_WITH_MEIN_DEBUG
    return sa;
}
#if CPP_WITH_GUI
@*RSC_TESTPROT_3D_XYZ
 290 -2227 266 303 -2251 293 316 -2220 312 281 -2212 323 291 -2221 358 318 -2195 364
*@

private static Protein testProt(){
    Protein p=_testProt3D;
    if(p==null){
        (p=_testProt3D=new Protein()).setResidueType("AGYDRH");
        p.setResidueCalphaXYZ(floatArry(rsc(RSC_TESTPROT_3D_XYZ),.1f));
    }
    return p;
}
#endif //CPP_WITH_GUI
public static Object sclDefaultForInterface(int i){
    Object c=STRAP_DEFAULT_CLASSES[i];
    if(c==null){
        if(i==INTRFC_SequenceAligner2) c=io(BUT_C1(Smith_Waterman));
        if(i==INTRFC_SequenceAlignerTakesProfile) c=io(BUT_C1(ClustalW));
        if(i==INTRFC_SequenceAligner) c=io(BUT_C1(AlignerCombine1d3d));
        IF_AA(if(i==INTRFC_Superimpose3D||i==INTRFC_SequenceAligner3D) c=io(BUT_C1(TMalign)));;
#if CPP_WITH_GUI
        if(i==INTRFC_Superimpose3D||i==INTRFC_SequenceAligner3D){
            Protein p=testProt();
            CPP_synchronized(_testProt3D=p){
                final int save=isPrprty(IS_CACHE_READ)?1:-1;
                setPrprtyB(-IS_CACHE_READ);
                final Object mx=iThEl(ALIGNRESULT_MATRIX,((SequenceAligner)mkInstanceBid(BUT_C1(TMalign))).computeAlignment(OPT_ALIGN_NO_ERROR,new Protein[]{p,p}));
                IF_MEIN_DEBUG(baOut(mx==null?RED_FAILED:GREEN_SUCCESS).aln("sclDefaultForInterface(INTRFC_Superimpose3D)").aln(mx));;
                if(mx!=null) c=io(BUT_C1(TMalign));
                setPrprtyB(save*IS_CACHE_READ);
            }
            if(c==null) c=io(UNLESS_WINDOWS(fileExsts("/usr/bin/TMalign")?BUT_C1(TMalign):)BUT_C1(Superimpose_CE));
        }
        if(i==INTRFC_View3d) c=io(BUT_C1(ChAstex));/*X fileExsts("/usr/bin/pymol")?CLASS_Pymol: */
        if(i==INTRFC_PhylogeneticTree) c=io(isPrprty(IS_CLASSLOADING)?BUT_C1(Archaeopteryx): BUT_C1(TreeTop));
#endif //CPP_WITH_GUI
        STRAP_DEFAULT_CLASSES[i]=c;
    }
    return c;
}
public static int sclSetDefaultForInterface(int i,String cn){
    final int bid=bidForName(cn),ret;
    if(bid<=0) ret=DEFAULT_FOR_INTREFACE_UNKNOWN;
    else if(strstr(STR_w,s(bid),iConst(SARRAYeq_IMPLEMENTATIONS_FOR_INTERFACE,i))<0) ret=DEFAULT_FOR_INTREFACE_NOT_APPLICABLE;
    else{
        STRAP_DEFAULT_CLASSES[i]=io(bid);
        ret=0;
    }
    baOut(ret==0?GREEN_SUCCESS:RED_FAILED)
        .aa(iConst(SARRAYeq_SSCRIPT_MSG,DEFAULT_FOR_INTREFACE_FN),' ',i,' ',IF_GUI(sclInterfaceName(i)),' ',cn,' ')
        .aln(iConst(SARRAYeq_SSCRIPT_MSG,ret));
    return ret;
}

/* (highlight-regexp "=INTRFC_\\w+") */
@*SARRAYeq_IMPLEMENTATIONS_FOR_INTERFACE
 BUT_C1(FastaParser) BUT_C1(CIFParser) BUT_C1(PDBParser) BUT_C1(StrapParser) BUT_C1(SwissprotParser) BUT_C1(DSSP_Parser) BUT_C1(SBD_Parser) BUT_C1(XML_SequenceParser) =INTRFC_ProteinParser
 BUT_C1(ClustalW) BUT_C1(Amap) BUT_C1(Mafft) BUT_C1(T_Coffee) BUT_C1(Kalign) BUT_C1(Muscle) BUT_C1(Dialign) BUT_C1(Dialign_T) BUT_C1(Probcons) BUT_C1(Needleman_Wunsch) BUT_C1(Smith_Waterman) BUT_C1(align_m) BUT_C1(TMalign) BUT_C1(Mapsci) BUT_C1(Matt) BUT_C1(Mustang) BUT_C1(AlignerCombine1d3d) =INTRFC_SequenceAligner
 BUT_C1(ClustalW) BUT_C1(T_Coffee) =INTRFC_SequenceAlignerTakesProfile
 BUT_C1(TMalign) IF_GUI(BUT_C1(Superimpose_CE)) BUT_C1(Matt) BUT_C1(Mapsci) BUT_C1(Mustang) =INTRFC_SequenceAligner3D
 BUT_C1(TMalign) IF_GUI(BUT_C1(Gangsta)) IF_GUI(BUT_C1(Superimpose_CE)) =INTRFC_Superimpose3D
#if CPP_WITH_GUI
 BUT_C1(ProteinWriter_PDB) BUT_C1(ProteinWriter_Fasta) BUT_C1(ProteinWriter_FastaNuc) =INTRFC_ProteinWriter
 BUT_C1(ClustalW_format) BUT_C1(MSF_format) BUT_C1(Fasta_format) BUT_C1(HSSP_format) =INTRFC_AlignmentWriter
 BUT_C1(Distance3DToHetero) BUT_C1(Distance3DToCursor) =INTRFC_ResidueSelection
 BUT_C1(CompareBySequenceIdentityAsAligned) BUT_C1(CompareBySequenceIdentity) BUT_C1(CompareByAlignmentScore) BUT_C1(CompareBySuperimpose3D_RMSD) BUT_C1(CompareBySuperimpose3D_Score) =INTRFC_CompareTwoProteins
 BUT_C1(AlignmentEntropy) =INTRFC_ValueOfAlignPosition
 BUT_C1(Hydrophobicity) BUT_C1(Hydrophobicity_TOPPRED) BUT_C1(ResidueSolventAccessibility) BUT_C1(ResidueValues_from_textfile) =INTRFC_ValueOfResidue
 BUT_C1(CountResidues) =INTRFC_ValueOfProtein
 BUT_C1(SecondaryStructureJnet)=INTRFC_PredictionFromSequenceSecstru
 BUT_C1(CoiledCoil)=INTRFC_PredictionFromSequenceCoiledCoil
 BUT_C1(TM_Helix_Phobius) BUT_C1(TM_Helix_Hmmtop) BUT_C1(TM_Helix_Toppred) BUT_C1(TM_Helix_DAS) =INTRFC_PredictionFromSequenceTmHelix
 BUT_C1(ConsensusSequence) =INTRFC_StrapExtension
 BUT_C1(Archaeopteryx) BUT_C1(TreeTop) BUT_C1(ArchaeopteryxATM) BUT_C1(Jalview) =INTRFC_PhylogeneticTree
 BUT_C1(ChAstex) =INTRFC_View3d
#endif //CPP_WITH_GUI
*@

public static int[]sclImplementationsForInterface(int i){
    if(i<0||i>=INTRFC_ZZZ) return NO_int;
    if(_sclImplementationsForIntrfc[i]==null){
        _sclImplementationsForIntrfc[i]=
            i==INTRFC_PredictionFromSequence?joinArrysInt(new int[][]{
                    sclImplementationsForInterface(INTRFC_PredictionFromSequenceCoiledCoil),
                        sclImplementationsForInterface(INTRFC_PredictionFromSequenceSecstru),
                        sclImplementationsForInterface(INTRFC_PredictionFromSequenceTmHelix)}):
            iThInts(i,intArrys(SARRAYeq_IMPLEMENTATIONS_FOR_INTERFACE));
    }
    return _sclImplementationsForIntrfc[i];
}
#if CPP_WITH_GUI
public static int bidIntrfcForImpl(int bid){
    ROFi0(INTRFC_ZZZ)if (idxOf(bid,sclImplementationsForInterface(i))>=0) return i; /*X && sclDialogForInterface(i)>0 */
    return -1;
}
public static boolean bidIsIntrfc(int intrfc,Object impl){
    {
        final int bid=bidForClass(impl);
        if(bid>0) return idxOf(bid,sclImplementationsForInterface(intrfc))>=0;
    }
    return isAssignblFrm(sclInterfaceClass(intrfc),impl);
}
#endif //CPP_WITH_GUI
/* <<< Default aligner <<< */
/* ---------------------------------------- */
