
OVERRIDE_PUBLIC int compareObjects(int id,Object o1,Object o2){
    switch(id){
    case COMPARE_SEL_VIS:
    case COMPARE_ResSel:
    case COMPARE_Feature:{
        if(o1 instanceof ResidueAnnotation && o2 instanceof ResidueAnnotation){
            final ResidueAnnotation s1=(ResidueAnnotation)o1,s2=(ResidueAnnotation)o2;
            if(id==COMPARE_Feature){
                final String f1=s1.featureName(),f2=s2.featureName();
                if(f1!=null && f2!=null){
                    int t=s1.getSelectedAminoacids().length-s2.getSelectedAminoacids().length;
                    if(t!=0 || (t=s1.getSelectedAminoacidsOffset()-s2.getSelectedAminoacidsOffset())!=0) return -t;
                    return f1.compareTo(f2);
                }
            }else{
#if CPP_WITH_GUI
                if(id==COMPARE_ResSel){
                    final int i1=xatoi(runCR(RUN_GET_INSTANCE_TYPE,o1)),i2=xatoi(runCR(RUN_GET_INSTANCE_TYPE,o2));
                    if(i1==RESSEL_IMPL_CURSOR || i1==RESSEL_IMPL_SELECTED) return -1;
                    if(i2==RESSEL_IMPL_CURSOR || i2==RESSEL_IMPL_SELECTED) return 1;
                }
#endif //CPP_WITH_GUI
                int t=Integer.compare(s1.getStyle(),s2.getStyle());
                if(t!=0 || (t=Integer.compare(countTrue(s1.getSelectedAminoacids()),countTrue(s2.getSelectedAminoacids())))!=0) return t;
            }
        }
        return o1!=null?-1:o2!=null?1:0;

    }
    case COMPARE_SEQS_BY_PREF_ORDER:
    case COMPARE_ROW:
    case COMPARE_P_XYZ:
    case COMPARE_P_CHAIN:
    case COMPARE_P_ALPHA:{
        final Protein p1=iThProt(0,o1),p2=iThProt(0,o2);
        if(p1!=null && p2!=null){
            long iP1=-1,iP2=-1;
            switch(id){
            case COMPARE_SEQS_BY_PREF_ORDER:
                iP1=p1.getIntProperty(PROTEINI_PREFERRED_ORDER);
                iP2=p2.getIntProperty(PROTEINI_PREFERRED_ORDER);
                if(iP1<0 && iP2<0){
                    iP1=p1.getRow();
                    iP2=p2.getRow();
                }
                break;
            case COMPARE_ROW:
                iP1=p1.getRow();
                iP2=p2.getRow();
                break;
            case COMPARE_P_XYZ:{
                if((iP1=p1.hashCodeCalpha())!=(iP2=p2.hashCodeCalpha())) return iP1<iP2?-1:1;
                break;
            }
            case COMPARE_P_ALPHA:return compareAlphabetically(true,p1.getResType(),p2.getResType());
            case COMPARE_P_CHAIN:return orS(p1.getChain(),"").compareTo(orS(p2.getChain(),""));
            }/*X switch*/
            return iP1==iP2?p1.getName().compareTo(p2.getName()):iP1<0?1: iP2<0?-1: iP1<iP2?-1:1;
        }
        return o1!=null?-1:o2!=null?1:0;
    }
    }
    return INT_NAN;
}
