IF_GUI(private static int _dsspAvailable);;
#define DSSP_OPT_WRITE SEQW_SIDE_CHAIN_ATOMS|SEQW_PDB_TRAILING_SPC|SEQW_IDX_FOR_RESNUM
private static BA dsspData(boolean always,Protein[]pp){
    if(fstNotNull(pp)==null) return null;
    final BA sb=pdbFileName(DSSP_OPT_WRITE,pp);
    if(sb==null) return null;
    final String fnDssp=s(sb.a(".ss_acc.gz"));
    final File fDssp=file(fnDssp);
    IF_MEIN_DEBUG(if(onlyOnce(45)) baOut(DEBUG_LONGER).a("fDssp=").aFile(fDssp).aln());;
    if(sze(fDssp)==0 && (always||onlyOnceHC(321,fnDssp))){
        final File fPdb=iFile(FSUFFIX_pdb);
        baOut("\nmkdssp fPdb=").aFile(fPdb).aln();
#if CPP_WITH_GUI
        if(_dsspAvailable==0){
            if(!dashDashVersion(fileFindExecutable("mkdssp"))){
                clr(sb).aa(RED_ERROR," mkdssp: ","Please install the program mkdssp (package dssp) in the executable path!").special(BA_ERROR);
                _dsspAvailable=CFALSE;
                return null;
            }
            _dsspAvailable=CTRUE;
        }
        if(_dsspAvailable==CFALSE) return null;
#endif //CPP_WITH_GUI
        dsspDataFromPdbFile(pdbFileWrite(DSSP_OPT_WRITE,pp),clr(sb));
        wrte(WRTE_REPORT_STDOUT,fDssp,sb);
    }
    final BA txt=readBytes(fDssp);
    if(sze(txt)==0) return null;
    if(txt.eol().length<0){
        baOut(RED_ERROR).a(" mkdssp: ").aln("Missing linebreak ").aFile(fDssp).aln().aln(txt);
        fileDel(0,fDssp);
        return null;
    }
    return txt;
}
#undef _onlyOnceTxt
public static boolean dsspDataFromPdbFile(File fPdb,BA sb){
    final BA dssp=sze(fPdb)==0?null:toBA(rtExecOutput(0,new Object[]{fileFindExecutable("mkdssp"),fPdb}));
    if(dssp==null){
        baOut(RED_ERROR).a(" mkdssp: ").aln(fPdb);
        return false;
    }
    final ProteinParser parser=sequenceParser(BUT_C1(DSSP_Parser));
    if(null==parser.parse(0,null,dssp,null)){
        baOut(RED_ERROR).a(" mkdssp: ").aln("Parsing ").aFT(dssp,0,300).aln().aln();
        return false;
    }
    clr(sb).a0((byte[])runCR(RUN_GET_DSSP_SECONDARY_STRUCTURE,parser)).aln();
    for(float acc:(float[])runCR(RUN_GET_DSSP_ACCESSIBILITY,parser)) sb.aa((int)acc,' ');
    sb.aln();
    return true;
}
static void assignSecStru(Protein p){
    final BA txt=dsspData(false,new Protein[]{p});
    final int lf=txt==null?0:iThInt(0,txt.eol());
    if(lf>0) p.setResidueSecStrType(txt.newBytes(0,lf));
}
public static float[]getAccessibility(boolean always,Protein[]pp){
    final BA txt=dsspData(always,pp);
    final int lf=txt==null?0:iThInt(0,txt.eol());
    return lf<=0?null:floatArry(new BA(txt.bytes(),lf,txt.end()),1);
    //if(lf<=0) return null;
/* final ChTokenizer tok=toknzr(11,SPC).setText(txt.bytes(),lf,txt.end()); */
/* final float[]acc=new float[lf]; */
/* for(int iT=0; tok.nextToken() && iT<acc.length;iT++) acc[iT]=tok.asInt(); */
/* clr(tok); */
    //return acc;
}
#if CPP_DEACTIVATED
public static void cancelOut(float[]needle,float[]haystack){
    if(ARRAY_EMPTY(needle)||haystack==null) return;
 nextHaystack:
    for(int iH=0;iH<=haystack.length-needle.length; iH+=3){
        ROFiN0(needle.length){
            if(haystack[iH+iN]!=needle[iN]) continue nextHaystack;
        }
        for(int i=iH;i<iH+needle.length; i+=3)  haystack[i]=Float.NaN;
        break;
    }
}
#endif //CPP_DEACTIVATED
