/* >>> MSA >>> */
    CPP_PRIVATE static Protein[]ppFromMsfText(BA txt){
        if(sze(txt)==0) return Protein.NONE;
        final File f=txt.getFile();
        final int msf_FromTo[]={0,0},format=msaGetFormat(0,txt,msf_FromTo,_msfCountP);
        Protein[]pp=null;

        if(format!=0 && _msfCountP[0]>=2){
            CPP_synchronized(SYNC_PARSE_MSA){
                msaParse(format,txt,msf_FromTo);
                if(_msaName==null) return Protein.NONE;
                if(_msaName.length>5000){
                    final BA sb=new BA(sze(txt)).aln(f).aPlrl(_msaName.length,"The file contains more than 5000 sequences.\nTherefore identical sequences are omitted.\n #Sequences=%N\n\n Skipped sequences:\n\n");
                    final int nameLen=sze(longestName(_msaName)),hCodes[]=new int[_msaName.length];
                    ROFi0(_msaName.length) hCodes[i]=hashCd(_msaSeq[i],0,MAX_INT);
                    final int[]hCodesSorted=hCodes.clone();
                    Arrays.sort(hCodesSorted);
                    final boolean[]alreadyTaken=new boolean[_msaName.length];
                    FORi(0,_msaName.length){
                        final int pos=Arrays.binarySearch(hCodesSorted,hCodes[i]);
                        if(pos<0) {assrt();continue;}
                        if(alreadyTaken[pos]){
                            sb.aTrailingSpc(_msaName[i],nameLen+1).aln(_msaSeq[i]);
                            _msaName[i]=null;
                            _msaSeq[i]=null;
                        }else alreadyTaken[pos]=true;
                    }
                    IF_GUI(shwTxtInW("Skipped sequences",sb.trimSize()));;
                }
                pp=new Protein[_msaName.length];
                final String pfam;
                {
                    final String fn0=delLstCmpnt('.',nam(f));
                    if(sze(fn0)>2){
                        int digi0=-1;
                        ROFi0(sze(fn0)) if(isChrClas(DIGT,fn0,i)) digi0=i; else break;
                        pfam=format==MSF_FORMAT_STOCKHOLM && digi0==2 && fn0.charAt(0)=='P' && fn0.charAt(1)=='F'?addPfx("PFAM:",fn0):null;
                    }else pfam=null;
                }
                final Protein[]ppLoaded=strapProteins();
                final String[]keys=hrefGetDB(HREF_PROTEIN_FILE)[0];
                final byte[]char0_ofKeys=new byte[keys.length];
                int char0_ofKeysCount=0;
                for(String key:keys){
                    final int c0=key.charAt(0);
                    if(c0>='A' && strchr(c0,char0_ofKeys,0,char0_ofKeysCount)<0) char0_ofKeys[char0_ofKeysCount++]=(byte)c0;
                }
                IF_GUI(final String[]dirAnnoListing=lstDir(fileOfProtein(FP_ANNO,null)));;
                ROFiP0(pp.length){
                    if(_msaName[iP]==null) continue;
                    final String pn0=_msaName[iP],pn=pn0.replace('/','_').replace('|','_');
                    Protein p=sequenceWithName(pn,ppLoaded);
                    if(p==null) p=new Protein();
                    (pp[iP]=p).setName(pn);
                    {/*X  Accession ID */
                        final char c0=chrAt(0,pn0);
                        final int colon=pn0.indexOf(':');
                        String foundKey=colon>0 && c0=='P' && colon==3 && pn0.startsWith("PDB")?"PDB:": colon>0 && c0=='E' && pn0.startsWith("ENSEMBL")?"ENSEMBL:":null;
                        if(foundKey==null && colon>0){
                            if(strchr(c0,char0_ofKeys,0,char0_ofKeysCount)>=0){
                                for(String key:keys){
                                    final int keyL=sze(key);
                                    if(colon+1==keyL && key.charAt(0)==c0 && pn0.startsWith(key)){
                                        foundKey=key;
                                        break;
                                    }
                                }
                            }
                        }
                        if(foundKey!=null){
                            final String id=wordAt(foundKey=="PDB:"?LETTR_DIGT_US_COLON:LETTR_DIGT,pn0,colon+1);
                            p.addSeqRef(ADD_SEQREF_ACC,foundKey+id);
                            p.setName(id.replace(':','_'));
                        }/*X else if(sze(pn)>6 && 0>nxt(0,chrClas(-UPPR_DIGT_US),pn)) p.addSeqRef(0,pn);*/
                    }
                    p.setGappedSequence(_msaSeq[iP],MAX_INT);
                    if(_msaSeqStru!=null) p.setResidueSecStrType(_msaSeqStru[iP]);
                    for(String s:iThStrgArray(iP,_msaRef)){
                        if(p.getPdbID(PDBID_ID)==null && s.startsWith("PDB:")) p.setPdbID(PDBID_ID,s);
                        p.addSeqRef(0,s);
                    }
                    for(String s:toStrgArray(0,_msaSharedRef)) p.addDatabaseRef(s);
                    p._flags|=PFLAG_IS_IN_MSF;
                    p.setFile(f);
                    IF_GUI(if(findPfxI(0,dirAnnoListing,pn)>=0) readAttributes(0,p,null));;
                    p.addSeqRef(ADD_SEQREF_ACC,iThStrg(iP,_msaAccession));/*X war delLstCmpnt('!',accID[iP]) */
                    p.setIndexOffsetAA(iThIntOr(iP,_msaResOffset,0));
                    if(pfam!=null){
                        p.addDatabaseRef(pfam);
                        IF_GUI(runCR1(RUN_SET_ICON_IMAGE,p,img(iicon(IC_PFAM))));;
                    }
                }
            }
            IF_GUI(setIconToSequence(SEQUENCE_SET_ICON_3D|SEQUENCE_SET_ICON_SPECIES,pp));;
            {
                final int[]fromTo=leadingAndTrailingLowerCaseLettersInMSA(pp);
                for(Protein p:pp) if(p!=null && fromTo!=null) setResidueSubsetFromColumnRange(p,fromTo[0],fromTo[1]);
            }
            {
                final int countMultiSwiss=ARRAY_EMPTY(pp)?parseMultipleSwiss(txt,null):0;
                if(countMultiSwiss>1){
                    pp=new Protein[countMultiSwiss];
                    ROFi0(countMultiSwiss){
                        (pp[i]=new Protein())._flags|=PFLAG_IS_IN_MSF;
                        pp[i].setFile(f);
                    }
                    parseMultipleSwiss(txt,pp);
                }
            }
            IF_AA(baOut(pp.length>0?GREEN_SUCCESS:RED_FAILED).aa("Read ",txt.getFile()," #",pp.length).aln());;
        }
        ROFi0((pp=spp(pp)).length){
            if(pp[i]!=null) pp[i].setProperty(PROTEINO_ALIGNMENT,_main);/*X  muss nach leadingAndTrailingLowerCaseLettersInMSA */
        }
        return pp;
    }

    private static int parseMultipleSwiss(BA ba,Protein[]pp){
        if(msaGetFormat(MSF_FORMAT_MSF,ba,CPP_NULL(Range),null)<0) return 0;
        final byte[]T=ba.bytes();
        int count=0;
        boolean hasSeq=false;
        String id=null;
        boolean isGenbank=false;
        for(int ee[]=ba.eol(),from=ba.begin(),iL=0;iL<ee.length;iL++){
            final int b=iL==0?from: ee[iL-1]+1,e=ee[iL];
            if(e-b==0)continue;
            final int c0=T[b];
            if(c0==0)continue;
            final boolean slashSlash=e-b>=2 && c0=='/' && T[b+1]=='/' && nxt(chrClas(-SPC),T,b+2,e)<0;
            if(!isGenbank  && c0=='L' && strEquAt(0,"LOCUS ",T,b)) isGenbank=true;
            //if(!isGenbank && !slashSlash && c0!=' ' && ( !iThBool(c0,chrClas(LETTR)) || !isChrClas(LETTR,T,b+1) || isChrClas(chrClas(-SPC),T,b+2))) return 0;
            if(!isGenbank && !slashSlash && c0!=' ' && (!chrClas(LETTR)[c0] || !isChrClas(LETTR,T,b+1) || isChrClas(-SPC,T,b+2))) return 0;
            if(!isGenbank && (c0=='I' && T[b+1]=='D'  || c0=='A' && T[b+1]=='C')){
                if(!isChrClas(LETTR_DIGT,T,b+5)) return 0;
                if(c0=='I' || id==null) id=ba.newString(b+5,nxt(STR_E,chrClas(-LETTR_DIGT_US),T,b+5,e));
            }
            if(isGenbank && c0=='A' && strEquAt(0,"ACCESSION ",T,b)){
                final int pos=nxt(chrClas(-SPC),T,b+10,e);
                if(pos>0)   id=ba.newString(pos,nxt(STR_E,chrClas(-LETTR_DIGT_US),T,pos,e));
            }
            if(isGenbank?c0=='O' && strEquAt(0,"ORIGIN ",T,b): c0=='S' && T[b+1]=='Q') hasSeq=true;
            if(slashSlash||iL==ee.length-1){
                if(id!=null && hasSeq){
                    final Protein p=pp!=null && pp.length>count?pp[count]:null;
                    if(p!=null){
                        sequenceParser(BUT_C1(SwissprotParser)).parse(0,null,new BA(T,from,e),p);
                        p.setName(id);
                    }
                    count++;
                }
                from=e+1;
                id=null;
            }
        }
        return count;
    }

/* <<< MSA <<< */
/* ---------------------------------------- */
