/* From code written by Ren-Xiang Yan in China Agricultural University and is originally based on */
/* Dr. Yang Zhang (http://zhanglab.ccmb.med.umich.edu/NW-align/). */
#define NW_RECORD_MS 0
#if NW_RECORD_MS
private static int _nwCumTime,_nwMinTime=MAX_INT,_nwMaxTime=MIN_INT;
#endif //NW_RECORD_MS
#define SCORE 0
#define IDIR 1
#define IDIRH 2
#define IDIRV 3
#define VAL 0
#define PREV 1
#define PREH 2
#define PRED 3
private static int _nwj2i[],_nwL1,_nwL2;
private final static int _nwiint[][][]=new int[4][][];
private static byte _nwAligned1[],_nwAligned2[],_nwBytes[][][]=new byte[4][][];
private static void _nwPrepare(int L1,int L2){
    if(L1>_nwL1||L2>_nwL2){
        final int L12=(_nwL1=L1+33)+2;
        final int L22=(_nwL2=L2+33)+2;
        _nwAligned1=new byte[L1+L22];
        _nwAligned2=new byte[L1+L22];
        _nwj2i=new int[L22];
        _nwBytes[SCORE]=new byte[L12-1][L22-1];
        _nwBytes[IDIR]=new byte[L12][L22];
        _nwBytes[IDIRH]=new byte[L12][L22];
        _nwBytes[IDIRV]=new byte[L12][L22];
        _nwiint[VAL]=new int[L12][L22];
        _nwiint[PREV]=new int[L12][L22];
        _nwiint[PREH]=new int[L12][L22];
        _nwiint[PRED]=new int[L12][L22];
    }
}
public static CPP_sync byte[][]needlemanWunsch(byte[]s1,byte[]s2,byte[][]scoring,int gapOpen1,int gapExtn1,int gapOpen2,int gapExtn2){
    //IF_MEIN_DEBUG(final int time=timeOn());
    if(scoring==null) scoring=similarityMatrix(SIMILARITY_MATRIX_BLOSUM62);
    final int
        iint[][][]=_nwiint,
        L1=strLen(s1),
        L2=strLen(s2);
    _nwPrepare(L1,L2);
    final byte[]
        aligned1=_nwAligned1,
        aligned2=_nwAligned2,
        score[]=_nwBytes[SCORE],
        idir[]=_nwBytes[IDIR],
        idirH[]=_nwBytes[IDIRH],
        idirV[]=_nwBytes[IDIRV];
    final int[]
        j2i=_nwj2i,
        val[]=iint[VAL],
        preV[]=iint[PREV],
        preH[]=iint[PREH],
        preD[]=iint[PRED];
    int i,j;
    for(j=1;j<=L2;j++){
        for(i=1;i<=L1;i++){
            score[i][j]=scoring[s1[i-1]][s2[j-1]];
            j2i[j]=-1;/*X  !all are not aligned*/
        }
    }
    // int V,H;
#if CPP_DEACTIVATED
    final boolean standard=false;
    if(standard){
        ////////////////////////////////////////////////////////////////////////////////
        //      This is a standard Needleman-Wunsch dynamic program (by Y. Zhang 2005).
        //      1. Count multiple-gap.
        //      2. The gap penality W(k)=Go+Ge*k1+Go+Ge*k2 if gap open on both sequences
        //      idir[i][j]=1,2,3,from diagonal,horizontal,vertical
        //      val[i][j] is the cumulative score of (i,j)
        ////////////////////////////////////////////////////////////////////////////////
        final int[][]
            jpV=new int[L1+2][L2+2],
            jpH=new int[L1+2][L2+2];
        val[0][0]=0;
        val[1][0]=gapOpen1;
        for(i=2;i<=L1;i++){
            val[i][0]=val[i-1][0]+gapExtn1;
        }
        for(i=1;i<=L1;i++){
            preV[i][0]=val[i][0];/*X  not use preV at the beginning*/
            idir[i][0]=0;/*X  useless*/
            jpV[i][0]=1;/*X  useless*/
            jpH[i][0]=i;/*X  useless*/
        }
        val[0][1]=gapOpen2;
        for(j=2;j<=L2;j++){
            val[0][j]=val[0][j-1]+gapExtn2;
        }
        for(j=1;j<=L2;j++){
            preH[0][j]=val[0][j];
            idir[0][j]=0;
            jpV[0][j]=j;
            jpH[0][j]=1;
        }
        // DP ------------------------------>
        for(j=1;j<=L2;j++){
            for(i=1;i<=L1;i++){
                // D=VAL(i-1,j-1)+SCORE(i,j)--------------->
                final int D=val[i-1][j-1]+score[i][j];/*X  from diagonal,val(i,j) is val(i-1,j-1)*/
                // H=H+gapOpen ------->
                jpH[i][j]=1;
                int val1=val[i-1][j]+gapOpen1;/*X  gapOpen from both D and V*/
                int val2=preH[i-1][j]+gapExtn1;/*X  gapExtn from horizontal*/
                int H,V;
                if(val1>val2){/*X  last step from D or V*/
                    H=val1;
                }else{/*X  last step from H*/
                    H=val2;
                    if(i >1) jpH[i][j]=jpH[i-1][j]+1;/*X  record long-gap*/
                }
                // V=V+gapOpen --------->
                jpV[i][j]=1;
                val1=val[i][j-1]+gapOpen2;
                val2=preV[i][j-1]+gapExtn2;
                if(val1>val2){
                    V=val1;
                }else{
                    V=val2;
                    if(j>1) jpV[i][j]=jpV[i][j-1]+1;/*X  record long-gap*/
                }
                preH[i][j]=H;/*X  unaccepted H*/
                preV[i][j]=V;/*X  unaccepted V*/
                if((D>H)&&(D>V)){
                    idir[i][j]=1;
                    val[i][j]=D;
                }else if(H >V){
                    idir[i][j]=2;
                    val[i][j]=H;
                }else{
                    idir[i][j]=3;
                    val[i][j]=V;
                }
            }
        }
        //  tracing back the pathway
        i=L1;
        j=L2;
        while(i>0&&j>0){
            if(idir[i][j]==1){/*X  from diagonal*/
                j2i[j--]=i--;
            }else if(idir[i][j]==2){/*X  from horizonal*/
                for(int N=jpH[i][j],me=1;me<=N;me++){/*X   In the point view of a programer,you should not use the  "for(int me=1;me<=jpH[i][j];me++)".*/
                    if(i>0) i--;/*X   If you use up sentence,the value of jpH[i][j] is changed when variable i changes.*/
                    //  So the value of jpH[i][j] was assigned to the value N and use the setence "for(int me=1;me<=temp1;me++)" here.
                }
            }else{
                for(int N=jpV[i][j],me=1;me<=N;me++){/*X   you should not use the  "for(int me=1;me<=jpV[i][j];me++)".*/
                    if(j>0)  j--;/*X   Because when variable i change,the jpV[i][j] employed here is also change.                                                                 //  So the value of idirV[i][j] was assigned to the value temp2 and use the setence "for(int me=1;me<=temp2;me++)" here.*/
                }
            }
        }
    }else
#endif //CPP_DEACTIVATED
        {
        /////////////////////////////////////////////////////////////////////////////////
        //       This is an alternative implementation of Needleman-Wunsch dynamic program
        //       (by Y. Zhang 2005)
        //       1. Count two-layer iteration and multiple-gaps
        //       2. The gap penality W(k)=Go+Ge*k1+Ge*k2 if gap open on both sequences
        //
        //       idir[i][j]=1,2,3,from diagonal,horizontal,vertical
        //       val[i][j] is the cumulative score of (i,j)
        ////////////////////////////////////////////////////////////////////////////////
        val[0][0]=0;
        for(i=1;i<=L1;i++){
            val[i][0]=preD[i][0]=0;
            idir[i][0]=0;
            preH[i][0]=preV[i][0]=-1000;
        }
        for(j=1;j<=L2;j++){
            val[0][j]=preD[0][j]=0;
            idir[0][j]=0;
            preH[0][j]=preV[0][j]=-1000;
        }
        // DP ------------------------------> // Urspruenglich erst j- dann i- schleife;
        for(i=1;i<=L1;i++){
            final int[]
                preDi=preD[i],
                preHi=preH[i],
                preVi=preV[i],
                preDi1=preD[i-1],
                preHi1=preH[i-1],
                preVi1=preV[i-1],
                vali=val[i];
            final byte[]
                idirHi1=idirH[i-1],
                idirVi=idirV[i],
                idiri=idir[i];
            for(j=1;j<=L2;j++){
                preDi[j]=val[i-1][j-1]+score[i][j];
                // preH: pre-accepted H----------------------->
                int D=preDi1[j]+gapOpen2;
                int H=preHi1[j]+gapExtn2;
                int V=preVi1[j]+gapExtn2;
                if((D>H)&&(D>V)){
                    preHi[j]=D;
                    idirHi1[j]=1;
                }else if(H>V){
                    preHi[j]=H;
                    idirHi1[j]=2;
                }else{
                    preHi[j]=V;
                    idirHi1[j]=3;
                }
                // preV: pre-accepted V----------------------->
                D=preDi[j-1]+gapOpen1;
                H=preHi[j-1]+gapExtn1;
                V=preVi[j-1]+gapExtn1;
                if(D>H&&D>V){
                    preVi[j]=D;
                    idirVi[j-1]=1;
                }else if(H>V){
                    preVi[j]=H;
                    idirVi[j-1]=2;
                }else{
                    preVi[j]=V;
                    idirVi[j-1]=3;
                }
                // decide idir(i,j)----------->
                if((preDi[j]>preHi[j])&&(preDi[j]>preVi[j])){
                    idiri[j]=1;
                    vali[j]=preDi[j];
                }else if(preHi[j]>preVi[j]){
                    idiri[j]=2;
                    vali[j]=preHi[j];
                }else{
                    idiri[j]=3;
                    vali[j]=preVi[j];
                }
            }
        }
        //  tracing back the pathway
        i=L1;
        j=L2;
        while(i>0&&j>0){
            if(idir[i][j]==1){
                j2i[j--]=i--;
            }else if(idir[i][j]==2){
                i--;
                idir[i][j]=idirH[i][j];
            }else{
                j--;
                idir[i][j]=idirV[i][j];
            }
        }
    }
    int k=0;
    i=j=1;
    while(true){
        final byte c1=i<=L1?s1[i-1]:0,c2=j<=L2?s2[j-1]:0;
        byte a1=(byte)'-',a2=(byte)'-';
        if(c1==0){
            if(c2==0) break;/*X  unaligned C on 1*/
            a1=(byte)' ';
            a2=c2;
            j++;
        }else if(c2==0 && i<L1){/*X  unaligned C on 2*/
            a1=c1;
            a2=(byte)' ';
            i++;
        }else{
            final int j2ij=j2i[j];
            if(i==j2ij){/*X  if align*/
                a1=c1;
                a2=c2;
                i++;
                j++;
            }else if(j2ij<0){/*X  gap on 1*/
                a2=c2;
                j++;
            }else if(j2ij>=0){/*X  gap on 2*/
                a1=c1;
                i++;
            }
        }
        aligned1[k  ]=a1;
        aligned2[k++]=a2;
    }
#if NW_RECORD_MS
    final int ms=timeOn()-time;
    baOut(ANSI_FG_WHITE+ANSI_GREEN+"NeedlemanWunsch "+ANSI_RESET).aa(L1,'x',L2,' ',ms," ms ",_nwCumTime+=ms," mima=",_nwMaxTime,' ',_nwMinTime).aln();
#endif //NW_RECORD_MS
    return new byte[][]{newByts(aligned1,0,k),newByts(aligned2,0,k)};
}
/* <<< NeedlemanWunsch <<< */
/* ---------------------------------------- */
/* >>> SmithWaterman  1 ms for two sequences of length 250 >>> */
public static byte[][]smithWaterman(byte[]s1,byte[]s2,byte[][]scoring){
    if(scoring==null) scoring=similarityMatrix(SIMILARITY_MATRIX_BLOSUM62);
    final int L1=strLen(s1),L2=strLen(s2);
    if(L1==0||L2==0) return null;
    byte[]scorGap=scoring['*'],gg1=new byte[L1+L2],gg2=new byte[gg1.length];
    final int rows=L1+1,cols=L2+1,m[][]=new int[rows][cols];
/* Initialization of m takes one 5th of time */
    int r,c,maxRow=0,maxCol=0,maxScore=0;
    for(r=1;r<rows;r++){/*X  Compute Matrix */
        m[r][0]=0;
        final byte[]scoring_r_1=scoring[s1[r-1]];
        for(c=1;c<cols;c++){
            m[r][c]=maxi(CPP_REM(Ins) m[r][c-1]+scorGap[s2[c-1]],
                         CPP_REM(Sub)m[r-1][c-1]+scoring_r_1[s2[c-1]],
                         CPP_REM(Del)m[r-1][c]+scorGap[s1[r-1]],
                         0);
            if(m[r][c]>maxScore){
                maxScore=m[r][c];
                maxRow=r;
                maxCol=c;
            }
        }
    }
    int p1=gg1.length,p2=p1;
/* Start at cell with max score */
    r=maxRow;
    c=maxCol;
    while((r>0||c>0) && m[r][c]>0){
        if(c>0 && m[r][c]==m[r][c-1]+scorGap[s2[c-1]]){/*X  Insertion */
            gg1[--p1]=(byte)'-';
            gg2[--p2]=s2[--c];
            continue;
        }
        if(r>0 && c>0){
            final int sub=scoring[s1[r-1]][s2[c-1]];
            if(m[r][c]==m[r-1][c-1]+sub){/*X  Substitution */
                gg1[--p1]=s1[--r];
                gg2[--p2]=s2[--c];
                continue;
            }
        }
/* Deletion */
        gg1[--p1]=s1[--r];
        gg2[--p2]=(byte)'-';
    }
    return new byte[][]{newByts(gg1,p1,gg1.length),newByts(gg2,p2,gg2.length)};
}
#if CPP_DEACTIVATED_MAIN
public static void main(String[]argv)throws Exception{
    setNoGui(argv);

    //        final String s0="MIRSVVIVGGGTAGWMTASYLKAAFDDRIDVTLVESVGEATFSTVRHFFDYLGLDEREWLPRCAGGYKLGIRFENWSEPGEYFYHPFERLRVVDGFNMAEWWLAVGSFSEACYLTHRLCEAKRAPRMLDGSLFALGRSTLAEQRAQFPYAYHFDADEVARYLSEYAIARGVRHVVDDVQHVGQDERGWISGVHTKQHGEISGDLFVDCTGFRGLLINQTLGGRFQSFSDVLPNNRAVALRVPRENDEDMRPYTTATAMSAGWMWTIPLFKRDGNGYVYSDEFISPEEAERELRSTVAPGRDDLEANHIQMRIGRNERTWINNCVAVGLSAAFVEPLESTGIFFIQHAIEQLVKHFPGERWDPVLISAYNERMAHMVDGVKEFLVLHYKGAQREDTPYWKAAKTRAMPDGLARKLELSASHLLDEQTIYPYYHGFETYSWITMNLGLGIVPERPRPALLHMDPAPALAEFERLRREGDELIAALPSCYEYLASIQ";
    //final String s1="MIRSVVIVGGGTAGWMTASYLKAAFDDRIDVTLVESGNVRRIGVGEATFSTVRHFFDYLGLDEREWLPRCAGGYKLGIRFENWSEPGEYFYHPFERLRVVDGFNMAEWWLAVGDRRTSFSEACYLTHRLCEAKRAPRMLDGSLFASQVDESLGRSTLAEQRAQFPYAYHFDADEVARYLSEYAIARGVRHVVDDVQHVGQDERGWISGVHTKQHGEISGDLFVDCTGFRGLLINQTLGGRFQSFSDVLPNNRAVALRVPRENDEDMRPYTTATAMSAGWMWTIPLFKRDGNGYVYSDEFISPEEAERELRSTVAPGRDDLEANHIQMRIGRNERTWINNCVAVGLSAAFVEPLESTGIFFIQHAIEQLVKHFPGERWDPVLISAYNERMAHMVDGVKEFLVLHYKGAQREDTPYWKAAKTRAMPDGLARKLELSASHLLDEQTIYPYYHGFETYSWITMNLGLGIVPERPRPALLHMDPAPALAEFERLRREGDELIAALPSCYEYLASIQ";

    final String s0=argv[0];
    final String s1=argv[1];

    //        final String s0="MIRSVVIVGGGTAGWMTAE";
    //final String s1="MSVVIVGGGTATAE";
    ROFi0(2){
        final byte[][]aligned=needlemanWunsch(toByts(i==0?s0:s1),toByts(i==0?s1:s0),null);
        putln("");
        putln(aligned[0]);
        putln(aligned[1]);
    }
}
public static void main(String[]argv)throws Exception{
    setNoGui(argv);
    int n=0;
    final byte[][]ss=new byte[argv.length][];
    for(String a:argv){
        final Protein p=newProteinInstance(0,file(a));
        if(p!=null && p.countRes()>0) ss[n++]=p.getResTypeUC();
    }
    int[]hcc=new int[5];
    ROFi0(5){
        int hc=0;
        FORi(0,ss.length){
            FORj(0,ss.length){
                final byte[][]aligned1=needlemanWunsch(ss[i],ss[j],null);
                hc+=hashCd(aligned1[0])+hashCd(aligned1[1]);
                final byte[][]aligned2=iThEl(ALIGNRESULT_GAPPED,((SequenceAligner)mkInstanceBid(ClustalW)).computeAlignment(0,new Protein[]{ss[i],ss[j]}));
                final boolean success0=strEquAt(0,aligned1[0],aligned2[0],0);
                final boolean success1=strEquAt(0,aligned1[1],aligned2[1],0);
                if(success0 && success1)  baOut(GREEN_SUCCESS).aa(i,'/',j).aln();
                else {
                    baOut(RED_FAILED).aa(i,'/',j,' ',success0,' ',success1).aln();
                    baOut(aligned1[0]).aa('\n',aligned1[1]).aln().aln();

                    baOut(ANSI_BLUE,aligned2[0]).aa('\n',aligned2[1],ANSI_RESET).aln().aln();
                }
            }
        }
        CPP_GUI_CACHE_SAVE();
        hcc[i]=hc;
    }
    baOut(ANSI_GREEN+" hc=").aIntArray(hcc,0,MAX_INT).a(ANSI_RESET).aln();
}
#endif //CPP_DEACTIVATED_MAIN
#undef SCORE
#undef IDIR
#undef IDIRH
#undef IDIRV
#undef VAL
#undef PREV
#undef PREH
#undef PRED
#undef NW_RECORD_MS
