/* (NUM1 1) */
#define allowSlashInName (1<<1)
#define allowPipeInName (1<<2)
#define allowColonInName (1<<3)
/* --- */
#define _gap '-'
#define tmpClr() baClr(132)
/* Reads multiple sequences formats:  clustalW, MSF, WIKI:Fasta */
/* see */
/* <UL> */
/* <LI>http://www.molecularevolution.org/mbl/resources/fileformats/</LI> */
/* <LI>http://bioinformatics.abc.hu/tothg/biocomp/other/Stockholm.html  WIKI:Stockholm_format</LI> */
/* <LI> http://www.ebi.ac.uk/help/formats_frame.html</LI> */
/* <LI> http://www.bioinformatics.nl/tools/crab_pir.html</LI> */
/* <UL> */
/* ?? BIOWIKI:NexusFormat */
@*SARRAY_FASTA_REFS
 gi|GB:|sp|UNIPROT:|uniprot|UNIPROT:|ensembl|ENSEMBL:|embl|EMBL:|trembl|TREMBL:|pdb|PDB:
*@

//  http://www.molecularevolution.org/mbl/resources/fileformats
public static byte[][]IF_GUI(_msaHeader,)_msaSeq,_msaSeqStru;
public static int[]_msaResOffset;
public static String[]_msaSharedRef,_msaName,_msaAccession,_msaRef[];
private static int _msaOpt;
private static ChTokenizer _msaTok;
public static int msaGetFormat(int whatFormat,BA ba,int[]returnLineRange,int[]returnProteinCount){
    final byte[]T=ba.bytes();
    final int B=ba.begin(),E=ba.end(),eol[]=ba.eol();
    if(T==null || E-B<10 || eol.length<2) return 0;
    final ChTokenizer tok=_msaTok==null?_msaTok=new ChTokenizer(' '):_msaTok;
    final boolean[]no_spc=chrClas(-SPC);
    int nSeq=9999,fromLine=0,toLine=MAX_INT;
    CPP_synchronized(recordSync(tok,"isFormat")){
        try{
            if(whatFormat==MSF_FORMAT_MSF || whatFormat==MSF_FORMAT_CLUSTALW || whatFormat==0){
                // http://cubic.bioc.columbia.edu/predictprotein/Dexa/optin_msf.html
                // http://www.pdg.cnb.uam.es/cagen/main/CAGENformats.html
                // http://www.predictprotein.org/newwebsite/Dexa/optin_msfWWW.html
                int msfHeader=0;
            checkHeader:
                for(int iHeaderLine=0,iL=0;iL<eol.length && iHeaderLine<4;iL++){
                    final int b=BOLb(iL,eol),e=eolTrim(T,b,eol[iL]);
                    if(e>b) iHeaderLine++;
                    if(e-b>5 && (whatFormat==MSF_FORMAT_MSF||whatFormat==0) && T[e-1]=='.'&&T[e-2]=='.'&&T[e-3]==' '){
                        final int i=strstr(0,"MSF:",T,b,e);
                        if(i==0 || i>0&&T[i-1]==' '&&isChrClas(DIGT,T,nxt(no_spc,T,i+4,e))){
                            msfHeader=iL;
                            break checkHeader;
                        }
                    }
                    if((whatFormat==MSF_FORMAT_CLUSTALW||whatFormat==0) && b+8<E && T[b]=='C' && T[b+1]=='L'){
@*SARRAY_CLUSTAL_CLUSTAL_W
                         CLUSTAL FORMAT for T-COFFEE Version_|CLUSTAL W|CLUSTAL
*@
                        final String ww[]=arry(SARRAY_CLUSTAL_CLUSTAL_W);
                        FORi(0,ww.length){
                            if(strEquAt(0,ww[i],T,b)){/*X CLUSTAL W 2.1 multiple sequence alignment */
                                final int noSpc=nxt(no_spc,T,b+sze(ww[i]),e);
                                if(i==0||noSpc<0 || isChrClas(DIGT,T,noSpc) || T[noSpc]=='('&&isChrClas(DIGT,T,noSpc+1)){
                                    fromLine=iL+1;
                                    return MSF_FORMAT_CLUSTALW;
                                }
                            }
                        }
                    }
                }
                if(msfHeader>=0){
                    boolean Name=false;
                    FORiL(msfHeader,eol.length){
                        LINE_TRIM_BE(iL,ba);;
                        if(!Name) Name=e-b>6 && T[b]=='N' && strEquAt(0,"Name: ",T,nxt(STR_E,no_spc,T,b,e),e);
                        else if(e-b>=2 && T[b]=='/' && T[b+1]=='/' && nxt(no_spc,T,b+2,e)<0){
                            fromLine=iL+1;
                            return MSF_FORMAT_MSF;
                        }
                    }
                }
            }
            if(whatFormat==MSF_FORMAT_PRODOM || whatFormat==0){
                if(E-B>100 && eol.length>3 && T[B]=='I' && T[B+1]=='D' && T[B+2]==' '){
                    FORiL(1,eol.length){
                        final int b=eol[iL-1]+1,e=eol[iL];
                        if(iL==1){
                            if(e-b<13 || T[b]!='A'||T[b+1]!='C'||T[b+2]!=' ') break;
                            if(!tok.setText(T,b+2,e).nextToken() || !strEquAt(0,"PD",T,tok.from())) break;
                        }else{
                            if(e-b>46 && T[b]=='A' && T[b+1]=='L' && T[b+2]==' '){
                                fromLine=iL+1;
                                return MSF_FORMAT_PRODOM;
                            }
                        }
                    }
                }
            }
#if CPP_WITH_HSSP_FORMAT
            if(whatFormat==MSF_FORMAT_HSSP || whatFormat==0){
                if(E-B>1000 && T[B+0]=='H' && T[B+1]=='S' && strEquAt(0,"HSSP       HOMOLOGY DERIVED SECONDARY STRUCTURE OF PROTEINS",T,B)) return MSF_FORMAT_HSSP;
            }
#endif //CPP_WITH_HSSP_FORMAT
            if(whatFormat==MSF_FORMAT_NEXUS ||whatFormat==0){
                // http://www.molecularevolution.org/mbl/resources/fileformats/nexus_dna.php
                if(E-B>20 && T[B+0]=='#' && strEquAt(STR_IC,"nexus",T,B+1) && IS_SPACE(T[B+6])){
                    boolean beginData=false;
                    FORiL(1,eol.length){
                        final int b=eol[iL-1]+1,e=eol[iL];
                        if(e-b>1){
                            final int lc0=T[b]|32;
                            if(fromLine>0){
                                if(T[b]==';' || T[b+1]==';' && IS_SPACE(T[b]) || lc0=='e' && strEquAt(STR_IC,"end;",T,nxt(no_spc,T,b,e))){
                                    toLine=iL;
                                    return MSF_FORMAT_NEXUS;
                                }
                            }else{
                                if(beginData){
                                    if((lc0=='m' || (T[b+1]|32)=='m') && strEquAt(STR_IC,"matrix",T,nxt(no_spc,T,b,e))) fromLine=iL+1;
                                }else{
                                    if(lc0=='b' && strEquAt(STR_IC,"begin data;",T,b)) beginData=true;
                                }
                            }
                        }
                    }
                    if(fromLine>0) return MSF_FORMAT_NEXUS;
                }
            }
            if(whatFormat==MSF_FORMAT_STOCKHOLM || whatFormat==0){
                if(E-B>20 && T[B]=='#' && strEquAt(0," STOCKHOLM",T,B+1)) return MSF_FORMAT_STOCKHOLM;
            }
            if(whatFormat==MSF_FORMAT_SIMPLE || whatFormat==0){
                int indent=-1,lineLen=-1;
                boolean lineLenDiffers=false,foundLetter=false;
                nSeq=0;
                for(int blockBegin=-1,blockBeginFirst=-1,iL=0;iL<eol.length;iL++){
                    LINE_TRIM_BE(iL,ba);;
                    if(e<=b){
                        blockBegin=-1;
                        continue;
                    }
                    //if(!iThBool(T[b],chrClas(LETTR_DIGT_US))) {nSeq=0;break;}
                    if(!isChrClas(LETTR_DIGT_US,T,b)){nSeq=0;break;}
                    if(blockBegin<0){
                        if(lineLenDiffers) {nSeq=0;break;}
                        blockBegin=iL;
                        if(blockBeginFirst<0) blockBeginFirst=iL;
                    }
                    if(lineLen<0) lineLen=e-b;
                    else if(lineLen!=e-b) lineLenDiffers=true;
                    final int iSpc=strchr(' '|STR_E,T,b,e);
                    {
                        final int iP=iL-blockBegin;
                        if(nSeq<=iP) nSeq=iP+1;
                        if(indent>0 && iSpc-b>indent) {nSeq=0;break;}
                        {
                            final int refName=blockBeginFirst+iP>0?eol[blockBeginFirst+iP-1]+1:B;
                            if(!xstrEquAt(0,T,b,iSpc,T,refName,E) || !isChrClas(SPC,T,refName+(iSpc-b))) {nSeq=0;break;}
                        }
                    }
                    final int seqStart=nxt(no_spc,T,iSpc,e);
                    if(seqStart>0){
                        if(indent<0) indent=seqStart-b;
                        else if(indent!=seqStart-b) {nSeq=0;break;}
                        // if(!cntainsOnly(LETTR_DASH_TILDE_DOT,T,seqStart,e)) return 0;
                        if(0<=nxt(chrClas(-LETTR_DASH_TILDE_DOT),T,seqStart,e)) {nSeq=0;break;}
                        foundLetter=foundLetter || nxt(chrClas(LETTR),T,seqStart,e)>0;
                    }
                }
                if(lineLen>0 && indent>0 && nSeq>1 && foundLetter) return MSF_FORMAT_SIMPLE;
                nSeq=9999;
            }
            if((whatFormat==MSF_FORMAT_PIR  ||whatFormat==0) && (nSeq=msaCountFasta(ba,MSF_FORMAT_PIR))>0) return MSF_FORMAT_PIR;/*X ORDER_OF_LINES must be last */
            if((whatFormat==MSF_FORMAT_FASTA||whatFormat==0) && (nSeq=msaCountFasta(ba,MSF_FORMAT_FASTA))>0) return MSF_FORMAT_FASTA;/*X ORDER_OF_LINES must be last */
            return 0;
        }finally{
            if(returnLineRange!=null){
                returnLineRange[RANGE_FROM]=fromLine;
                returnLineRange[RANGE_TO]=toLine;
            }
            if(returnProteinCount!=null) {returnProteinCount[0]=nSeq;}
        }
    }
}

private static boolean _msaIsPir(byte[]T,int b){
        if(T.length<b+5 || T[b]!='>'||T[b+3]!=';') return false;
        final byte c1=T[b+1],c2=T[b+2];
        return
            (c1=='P'||c1=='F') && c2=='1'||
            (c1=='D'||c1=='R') && (c2=='L'||c2=='C')||
            (c1=='X'&&c2=='X');
    }
    public static int msaCountFasta(BA ba,int format){
        final byte[]T=ba.bytes();
        final int[]eol=ba.eol();
        if(eol.length<2 || T[ba.begin()]!='>' || format==MSF_FORMAT_PIR && !_msaIsPir(T,ba.begin())) return 0;
        boolean isPirHeader=true;
        int count=1;
        FORiL(1,eol.length){
            final int b=eol[iL-1]+1,e=eolTrim(T,b,eol[iL]);
            if(e<=b) continue;
            if(format==MSF_FORMAT_PIR?_msaIsPir(T,b):T[b]=='>'){
                isPirHeader=true;
                if(!isChrClas(LETTR_DIGT_US,T,nxt(chrClas(-SPC),T,b+1,e))) return 0;
                count++;
                continue;
            }
            //if (format==MSF_FORMAT_FASTA && !cntainsOnly(LETTR_DASH,T,b,e)) return 0;
            if(format==MSF_FORMAT_FASTA && 0<=nxt(chrClas(-LETTR_DASH),T,b,e)) return 0;
            if(format==MSF_FORMAT_PIR){
                if(!isPirHeader){
                    FORi(b,e){
                        final byte c=T[i];
                        if(c=='*' && i+1<e && 0<=nxt(chrClas(-SPC),T,i+1,e) ||
                           !(c>0&&chrClas(LETTR_DASH)[c]||c==' '||c=='*')) return 0;
                    }
                }
                isPirHeader=false;
            }
        }
        return count;
    }
    private static void _msaStockholmHeader(int nP,byte[]T,int[]eol){
        ROFiP0(nP){
            final String n=_msaName[iP];
            if(n.length()==0) continue;
            final char name0=n.charAt(0);
            FORiL(1,eol.length){
                final int b=eol[iL-1]+1,e=eol[iL],nameTo=b+5+n.length();
                if(e<=nameTo+4 || name0!=T[b+5]) continue;
                if(!equlsIgnoreNoWord(n,T,b+5)||T[nameTo]!=' ') continue;
                if(T[b]!='#' || T[b+1]!='=' || T[b+4]!=' ') continue;
                if(T[b+2]=='G' && T[b+3]=='S'){
                    {
                        final int idB=strstr(STR_AFTER," AC ",T,nameTo,e);
                        if(idB>0){
                            if(_msaAccession==null) _msaAccession=new String[nP];
                            final int idE=nxt(STR_E,chrClas(-LETTR_DIGT_US),T,idB,e);
                            final BA tmp=tmpClr().aFT(T,idB,idE);
                            final int slash=strchr('/',T,b,e);
                            //if(slash>0 && iThBool(T[slash+1],chrClas(DIGT))) tmp.a('!').aFT(T,slash+1,nxt(STR_E,chrClas(-DIGT),T,slash+1,e));
                            if(slash>0 && isChrClas(DIGT,T,slash+1)) tmp.a('!').aFT(T,slash+1,nxt(STR_E,chrClas(-DIGT),T,slash+1,e));

                            _msaAccession[iP]=s(tmp);
                        }
                    }
                    {
                        final int idB=strstr(STR_AFTER," PDB; ",T,nameTo,e);
                        if(idB>0){
                            final int endWord=strchr(';',T,idB,e);
#define withChain endWord-idB==6
/*X  DR PDB; 1jm7 A; 24-64; */
#define withoutChain endWord-idB==5
/*X  DR PDB; 1chc ; 8-46; */
                            if(withChain || withoutChain){
                                if(_msaRef==null) _msaRef=new String[nP][];
                                final BA ba=tmpClr().a("PDB:").aFT(T,idB,idB+ 4);
                                if(withChain) ba.a('_').a((char)T[idB+5]);
                                _msaRef[iP]=adToStrgs(s(ba),_msaRef[iP],4);
                            }
                        }
                    }
                }
#undef withChain
#undef withoutChain
                if(T[b+2]=='G' && T[b+3]=='R'){
                    final int iSS=strstr(STR_AFTER," SS ",T,nameTo,e);
                    if(iSS>0){
                        if(_msaSeqStru==null) _msaSeqStru=new byte[nP][];
                        final byte[]seq=_msaSeq[iP],ss=_msaSeqStru[iP]=new byte[countChrClas(chrClas(LETTR),seq,0,MAX_INT)];
                        for(int fromWord=nxt(chrClas(-SPC),T,iSS,e),i=0,iA=0;i<seq.length;i++) if(isChrClas(LETTR,seq,i)) ss[iA++]=T[fromWord+i];
                    }
                }
            }
        }
    }
    public static void msaParse(int format,BA ba,int[]lineRange){
        _msaOpt=format;
        format&=0xFF;
        IF_GUI(_msaHeader=)_msaSeq=_msaSeqStru=null;
        _msaResOffset=null;
        _msaSharedRef=_msaName=_msaAccession=null;
        _msaRef=null;
        if(format==0){
            if(lineRange==null) lineRange=new int[2];
            format=msaGetFormat(0,ba,lineRange,(int[])null);
        }
        if(format!=0){
            //final int time=timeOn();
            IF_HSSP_FORMAT(if(format==MSF_FORMAT_HSSP) _msaHssp(ba));;
            if(format==MSF_FORMAT_PIR || format==MSF_FORMAT_FASTA) _msaFAorPIR(ba,format);
            if(format==MSF_FORMAT_PRODOM) _msaProdom(ba);
            if(format==MSF_FORMAT_MSF || format==MSF_FORMAT_STOCKHOLM || format==MSF_FORMAT_NEXUS || format==MSF_FORMAT_CLUSTALW || format==MSF_FORMAT_SIMPLE)  _msaMSF(format,ba,lineRange);
            //IF_AA(baOut(ANSI_STYLE_TIME).a(" Time MultipleSequenceParser ").a(timeOn()-time).aln(" ms"+ANSI_RESET));
        }
    }
    private static void _msaMSF(int format,BA ba,int[]lineRange){
        final byte[]T=ba.bytes();
        final int eol[]=ba.eol(),optBlank=allowSlashInName|allowPipeInName|(format==MSF_FORMAT_CLUSTALW?allowColonInName:0);
        boolean foundPipeInName=false,foundDashInName=false;
        final List<String>vNames=new ArrayList();/*X  defines order */
        final Map<String,int[]>map=new HashMap();
        {
            final int toLine=lineRange==null?eol.length:mini(lineRange[RANGE_TO],eol.length);
            FORiL(iThInt(RANGE_FROM,lineRange),toLine){
                int b=iL==0?ba.begin():eol[iL-1]+1;
                final int e=eolTrim(T,b,eol[iL]);
                if(e-b<2) continue;
                if(0==(_msaOpt&MSF_START_WITH_S)) b=nxt(chrClas(-SPC),T,b,e);
                else if(T[b]!='s') continue;
                final int blank=_msaFirstBlank(optBlank,T,b,e);
                if(blank<0) continue;
                int countAA=0,countGG=0;
                for(int i=nxtBwd(0,chrClas(-DIGT),T,e-1,blank-1)+1;--i>=blank;){
                    final byte c=T[i];
                    if(c>0){
                        if(chrClas(LETTR)[c]) countAA++;
                        else if(c=='-'||c=='.'||c=='~') countGG++;
                        else if(c!=' ' && c!='\t' && c!='\r') {countGG=countAA=-1;break;}
                    }
                }
                if(countAA+countGG>0){
                    final String s=ba.newString(b,blank);
                    final int[]ii=map.get(s);
                    if(ii==null) vNames.add(s);
                    map.put(s,adToIntArry2(iL,ii,10));
                }
            }
        }
        //debugTime("MultipleSequenceParser: sequence names found duration=",time);/*X  Throwable*/
        byte[]buff=new byte[999];
        if(sze(map)!=sze(vNames)) assrt();
        _msaSeq=new byte[sze(vNames)][];
        _msaName=new String[sze(vNames)];
        int nProt=0;
        FORk(0,_msaName.length){
            final String n=vNames.get(k);
            final int[]lines=map.get(n);
            if(lines==null) {assrt(); continue;}
            int count=0,lastLetter=0;
            for(int iL:lines){
                if(iL<0) break;
                final int b0=iL==0?ba.begin():eol[iL-1]+1,e=eol[iL],blank=_msaFirstBlank(optBlank,T,b0,e);
                if(blank<0) continue;
                if(buff.length<count+e-blank) buff=chSze(buff,(count+e-blank)*3/2);
                FORi(blank,e){
                    final byte c=T[i];
                    if(IS_UPPER_OR_LOWER(c)) buff[lastLetter=count++]=c;
                    else if(c=='-'||c=='.'|| c=='~')  buff[count++]=_gap;
                }
            }
            if(lastLetter>0){
                _msaName[nProt]=n;
                System.arraycopy(buff,0,_msaSeq[nProt]=new byte[lastLetter+1],0,lastLetter+1);
                foundPipeInName|=n.indexOf('|')>0;
                foundDashInName|=n.indexOf('-')>0;
                nProt++;
            }
        }
        _msaSeq=chSze(_msaSeq,nProt);
        _msaName=chSze(_msaName,nProt);
        if(format==MSF_FORMAT_STOCKHOLM) _msaStockholmHeader(nProt,T,eol);
        if((format==MSF_FORMAT_MSF || format==MSF_FORMAT_STOCKHOLM) && (foundDashInName || foundPipeInName)){
            FORiP(0,nProt){
                final String n=_msaName[iP];
                int from=0;
                while(true){
                    final int to0=strchr('|'|STR_E,n,from,n.length()),to=strchr('/'|STR_E,n,from,to0);
                    String xRef=null;
                    final int us=n.indexOf('_',from);
                    if(to-from==6 || (us>0 && us<to)){
                        final int t=us-from==6?us:to;
                        if(0>nxt(0,chrClas(-UPPR_DIGT_US),n,from,t)) xRef=s(clr(ba).a("UNIPROT:").aFT(n,from,t));
                    }
                    if(to-from>10 && strEquAt(0,"ENS",n,from)){
                        xRef=n.substring(from,to);
                    }
                    if(xRef!=null){
                        if(_msaAccession==null) _msaAccession=new String[nProt];
                        _msaAccession[iP]=xRef;
                    }
                    if(to==n.length()) break;
                    from=to0+1;
                }
                //                 if(foundPipeInName && isMSF){
                //                     final int lastPipe=n.lastIndexOf('|');
                //                     if(lastPipe>0){/*X  --- ProDom --- */

                //                         if(_msaAccession==null) _msaAccession=new String[nProt];
                //                         _msaAccession[iP]=s(clr(BA).a("UNIPROT:").a(n,n.lastIndexOf('|',lastPipe-1)+1,lastPipe));
                //                     }
                //                 }
                if(foundDashInName){
                    final int dash=n.lastIndexOf('-');
                    if(dash>0 && !isChrClas(-DIGT,n,dash-1) && dash+1<n.length() && 0>nxt(0,chrClas(-DIGT),n,dash+1,n.length())){
                        final int firstDigt=nxtBwd(STR_E,chrClas(-DIGT),n,dash-1,0)+1;
                        final char chDashOrUS=chrAt(firstDigt-1,n);
                        if(chDashOrUS=='_' || chDashOrUS=='-' || chDashOrUS=='/'){
                            if(_msaResOffset==null) _msaResOffset=new int[nProt];
                            _msaResOffset[iP]=atoi(n,firstDigt)-1;
                        }
                    }
                }
            }
        }
        //debugTime("MultipleSequenceParser done duration=",time);
    }
    private static int _msaFirstBlank(int opt,byte[]T,int b,int e){
        if(T!=null && b>=0 && e>=b){
            if(e>T.length) e=T.length;
            final boolean[]lettr_digt_us=chrClas(LETTR_DIGT_US);
            for(int START=nxt(chrClas(-SPC),T,b,e),i=START;i<e;i++){
                if(i<0) continue;
                final byte c=T[i];
                if(c==' ') return i;
                if(!(c>0&&lettr_digt_us[c] || i>START && (c=='-' || c=='.' || c=='+'||(0!=(opt&allowSlashInName)&&c=='/')||(0!=(opt&allowPipeInName)&&c=='|')||(0!=(opt&allowColonInName)&&c==':')))) return -1;
            }
        }
        return -1;
    }
    private static void _msaFAorPIR(BA ba,int format){
        final byte[]T=ba.bytes();
        final int[]eol=ba.eol();
        int iSeq=0;
        FORiL(0,eol.length-1){
            final int b=BOL(iL,eol,ba),e=eol[iL];
            if(e>b&&T[b]=='>'){
                if(e-b==1) return;
                if(0==(_msaOpt&MSF_START_WITH_S) || 's'==T[b+(format==MSF_FORMAT_PIR?4:1)]) iSeq++;
            }
        }
        IF_GUI(_msaHeader=new byte[iSeq][]);;
        _msaSeq=new byte[iSeq][];
        _msaName=new String[iSeq];
        iSeq=0;
        int iL=0;
        while(iL<eol.length){
            final int b=iL==0?ba.begin():eol[iL-1]+1,e=eolTrim(T,b,eol[iL]),seqStart=1+(format==MSF_FORMAT_PIR?iThInt(iL+1,eol):e),nameStart=b+(format==MSF_FORMAT_PIR?4:1);
            if(e-b<1 || seqStart<0) continue;
            if(T[b]!='>') break;
            if(format==MSF_FORMAT_FASTA){

/* >28377.ENSACAP00000001514 hairy and enhancer of split 1,(Drosophila) [Anolis carolinensis] */
/* >28377.ENSACAP00000004769 hairy and enhancer of split 7 (Drosophila) [Anolis carolinensis] */

                final int nxtLineStart=eol[iL]+1;
                if(nxtLineStart>=ba.end()) break;
                if(!isChrClas(LETTR_DASH,T,nxtLineStart)){
                    iL++;
                    continue;
                }
            }
            int next=e;
            while(iL<eol.length){
                if(((next=eol[iL]+1))>=ba.end() || T[next]=='>') break;
                iL++;
            }
            iL++;
            if(0!=(_msaOpt&MSF_START_WITH_S) && 's'!=T[nameStart]) continue;
            if(next>=T.length) next=T.length;
            byte[]gg=null;
            {
                while(true){
                    int iC=0;
                    for(int iT=seqStart;iT<next && iT<T.length;iT++){
                        final byte c=T[iT];
                        if(!IS_SPACE(c)){
                            if(gg!=null) gg[iC]=IS_UPPER_OR_LOWER(c)?c:(byte)_gap;
                            iC++;
                        }
                    }
                    if(gg==null){
                        gg=new byte[iC];
                        int iT=nameStart;
                        final String[]fax=arry(SARRAY_FASTA_REFS);
                        for(;iT<e;iT++){
                            boolean cont=T[iT]=='+' ||isChrClas(LETTR_DIGT_US_COLON,T,iT);
                            if(!cont){
                                for(int iRef=0;iRef<fax.length;iRef+=2){
                                    if(iT-b==fax[iRef].length()+1 && strEquAt(0,fax[iRef],T,b+1)){
                                        cont=true;
                                        break;
                                    }
                                }
                            }
                            if(!cont) break;
                        }
                        if(iSeq>=_msaName.length) break;
                        _msaName[iSeq]=s(tmpClr().aFT(T,nameStart,iT));
                        IF_GUI(System.arraycopy(T,b+1,_msaHeader[iSeq]=new byte[e-b-1],0,e-b-1));;
                        final String[]refs1=_msaFastaRefs(T,b,e);
                        if(refs1.length>0) (_msaRef==null?_msaRef=new String[_msaName.length][]:_msaRef)[iSeq]=refs1;
                    }else break;
                }
            }
            if(gg.length>0){
                if(iSeq<_msaSeq.length) _msaSeq[iSeq++]=gg; else MEIN_ASSRT();
            }
        }
    }
    private static String[]_msaFastaRefs(byte[]T,int start,int end){
        final Collection v=vClr(20);
        final String[]fax=arry(SARRAY_FASTA_REFS);
        FORi(start,end){
            if(T[i]=='|'){
                final int b=nxtBwd(0,chrClas(-LETTR),T,i-1,start-1)+1;
                if(b>0 && i-b>1){
                    for(int iRef=0;iRef<fax.length;iRef+=2){
                        if(strEquAt(STR_IC|STR_w_R,fax[iRef],T,b))  v.add(s(tmpClr().a(fax[iRef+1]).aFT(T,i+1,nxt(STR_E,chrClas(-LETTR_DIGT_US),T,i+1,end))));
                    }
                }
            }
        }
        return toStrgArray(0,v);
    }
/* DR   PDB;         1I09 chain B  (60-270) KG3B_HUMAN (60-270) */
/* DR   PDB;         1IAN (26-244) MK14_CANFA (25-243) */
    private static void _msaProdom(BA ba){
        final byte[]T=ba.bytes();
        final int[]eol=ba.eol();
        int[]hashcde=null;
        final ChTokenizer tok=_msaTok==null?_msaTok=new ChTokenizer(' '):_msaTok;
        _msaSharedRef=new String[5];
        while(true){
            int count=0;
            FORiL(1,eol.length-1){
                final int b=eol[iL-1]+1,e=eol[iL];
                if(e-b<13||T[b+2]!=' ') continue;
                final byte t0=T[b];
                if(t0=='/') break;
                tok.setText(T,b+3,e);
                if(t0=='A' && T[b+1]=='L'){
                    if(_msaSeq!=null){
                        tok.nextToken();
                        final int f=tok.from(),t=tok.to();
                        tok.nextToken();
                        _msaResOffset[count]=tok.asInt()-1;
                        tok.nextToken();
                        int seqE=tok.asInt()-1;
                        if(tok.nextToken() && tok.nextToken()){
                            _msaSeq[count]=newByts(T,tok.from(),tok.to());
                            final int bar=strchr('|',T,f,t);
                            _msaAccession[count]=s(tmpClr().a("UNIPROT:").aFT(T,f,bar>0?bar:t));
                            if(bar>0) T[bar]=(byte)'_';
                            _msaName[count]=s(tmpClr().aFT(T,bar>0 && xstrEquAt(0,T,f,bar,T,bar+1,MAX_INT)?bar+1:f,t).aa('_',_msaResOffset[count]+1,'_',seqE+1));
                            hashcde[count]=hashCd(T,bar+1,t);
                            if(bar>0) T[bar]=(byte)'|';
                        }
                    }
                    count++;
                }
                if(hashcde!=null){
                    if(t0=='D' && strEquAt(0,"DR   ",T,b)){
                        if(tok.nextToken() && strEquAt(0,"PDB;",T,tok.from()) && tok.nextToken()){
                            final BA tmp=tmpClr().a("PDB:").aFT(T,tok.from(),tok.to());
                            while(tok.nextToken()){
                                final int f=tok.from();
                                if(tok.to()-f==1) tmp.aa(':',(char)T[f]);
                                if(T[f]=='(') break;
                            }
                            if(!tok.nextToken()) baOut(RED_ERROR).a("PRODOM:").aFile(ba.getFile()).aln();
                            String name=tok.asString(),s=null;
                            final int HC=name.hashCode();
                            ROFiP0(hashcde.length){
                                if(hashcde[iP]==HC && _msaName[iP].indexOf(name)>=0){
                                    if(s==null) s=s(tmp);
                                    _msaRef[iP]=adToStrgs(s,_msaRef[iP],4);
                                }
                            }
                        }else{
                            tok.setText(T,b+2,e);
                            if(tok.nextToken() && T[tok.to()-1]==';'){
                                final BA tmp=tmpClr().aFT(T,tok.from(),tok.to()-1).a(':');
                                if(tok.nextToken()) _msaSharedRef=adToStrgs(s(tmp.aFT(T,tok.from(),tok.to())),_msaSharedRef,4);
                            }
                        }
                    }
                    if(iL<3 && t0=='A' && T[b+1]=='C' && tok.nextToken() && strEquAt(0,"PD",T,tok.from())){
                        _msaSharedRef=adToStrgs(s(tmpClr().a("PRODOM:").aFT(T,tok.from(),tok.to())),_msaSharedRef,4);
                    }
                }
            }
            if(_msaSeq==null){
                _msaSeq=new byte[count][];
                _msaName=new String[count];
                _msaRef=new String[count][];
                _msaAccession=new String[count];
                _msaResOffset=new int[count];
                hashcde=new int[count];
            }else break;
        }
    }
#if CPP_WITH_HSSP_FORMAT
    private static void _msaHssp(BA ba){
        final byte[]T=ba.bytes();
        final int[]eol=ba.eol();
        int lineProts=0,lineAlignments=0,nProts=-1;
        String id=null;
        FORiL(1,eol.length-1){
            final int b=eol[iL-1]+1,e=eol[iL];
            if(e-b<13) continue;
            if(T[b]=='#'){
                if(lineProts==0 && strEquAt(0,"## PROTEINS",T,b)) lineProts=iL+2;
                if(lineProts>0 && strEquAt(0,"## ALIGNMENTS",T,b)){
                    if(lineAlignments==0) lineAlignments=iL;
                    nProts=iL-lineProts+1;
                    break;
                }
            }
            if(T[b]=='P' && strEquAt(0,"PDBID ",T,b)) id=byts2strg(T,b+11,e).trim();
        }
        if(nProts>0 && lineAlignments>0){
            final String[]names0=_msaName=new String[nProts],acc0=_msaAccession=new String[nProts];
            final int[]from0=_msaResOffset=new int[nProts];
            names0[0]=id;
            acc0[0]=addPfx("PDB:",id);
            for(int iL=lineProts,iP=1;iP<nProts; iL++,iP++){
                final int b=eol[iL-1]+1,e=eol[iL];
                if(e-b<60) names0[iP]="error";
                else{
                    final int space=nxt(chrClas(SPC),T,b+8,e),f=from0[iP]=atoi(T,b+48,e)-1,t=f+atoi(T,b+58,e);
                    final String nam=space>b?byts2strg(T,b+8,space): "error";
                    acc0[iP]=addPfx("UNIPROT:",nam);
                    names0[iP]=s(tmpClr().aa(nam,'!',f,'-',t));
                }
            }
            final boolean[]chains=new boolean['z'+1];
            FORiL(lineAlignments+2,eol.length){
                final byte c=iThByte(eol[iL-1]+1,T),ch=iThByte(eol[iL-1]+1+12,T);
                if(c=='#' || c==0 || c=='/') break;
                if(ch>0&&chrClas(LETTR_DIGT)[ch]) chains[ch]=true;
            }
            int iP=0;
            for(boolean b:chains) if(b) iP+=names0.length;
            _msaName=new String[iP];
            _msaAccession=new String[iP];
            _msaResOffset=new int[iP];
            _msaSeq=new byte[iP][];
            iP=0;
            for(char c='0';c<='z';c++){
                if(chains[c]){
                    final byte[][]gg=_msaHssp(T,eol,eol.length,lineProts,c,names0);
                    FORi(0,names0.length){
                        if(gg[i]!=null){
                            _msaSeq[iP]=gg[i];
                            _msaName[iP]=s(tmpClr().aa(c,'_',names0[i]));
                            _msaAccession[iP]=acc0[i];
                            _msaResOffset[iP]=from0[i];
                            iP++;
                        }
                    }
                }
            }
            //if (id!=null) Arrays.fill(_msaRef=new String[iP][],new String[]{"HSSP:"+id,"PDB:"+id});
            if(id!=null) Arrays.fill(_msaRef=new String[iP][],new String[]{addPfx("HSSP:",id),addPfx("PDB:",id)});
            _msaName=chSze(_msaName,iP);
            _msaAccession=chSze(_msaAccession,iP);
            _msaResOffset=chSze(_msaResOffset,iP);
            _msaSeq=chSze(_msaSeq,iP);
        }
    }
    private static byte[][]_msaHssp(byte[]T,int[]eol,int nL,int lineProts,char chain,String[]names){
        final byte[][]gapped=new byte[names.length][];
        //ROFi0(names.length) gapped[i]=NO_byte;
        FORjL(lineProts,nL){
            final int B0=eol[jL-1]+1,e=eol[jL];
            if(e>B0&&T[B0]=='#' && strEquAt(0,"## ALIGNMENTS",T,B0)){
                final int iP0=atoi(T,B0+13,e);
                int toLine=-1,fromLine=-1;
                FORiL(jL+2,nL){
                    final int B=eol[iL-1]+1;
                    final boolean brk;
                    if(eol[iL]-B>14){
                        final byte c=T[B],ch=T[B+12];
                        if(fromLine==-1 && ch==chain) fromLine=iL;
                        brk=fromLine>0 && (c=='#' || c==0 || c=='/' || ch!=chain && T[B+14]!='!');
                    }else brk=true;
                    if(brk) {toLine=iL;break;}
                }
                if(fromLine<0) continue;
                gapped[0]=new byte[toLine-fromLine];
                for(int iL=toLine;--iL>=fromLine;){
                    final int B=eol[iL-1]+1;
#define iRes iL-fromLine
                    gapped[0][iRes]=eol[iL]-B>14?T[B+14]:(byte)' ';
                    for(int i=B+51,iP=iP0;i<eol[iL] && iP<names.length; i++,iP++){
                        if(IS_UPPER(T[i])){
                            if(gapped[iP]==null) Arrays.fill(gapped[iP]=new byte[iRes+1],(byte)' ');
                            gapped[iP][iRes]=T[i];
                        }
                    }
#undef iRes
                }
            }
        }
        return gapped;
    }
#endif //CPP_WITH_HSSP_FORMAT
/* <<< Parse <<< */
/* ---------------------------------------- */
/* >>> Utils >>> */
    private static boolean equlsIgnoreNoWord(String needle,byte[]hs,int fromH){
        final boolean[]lettr_digt=chrClas(LETTR_DIGT);
        final int t=needle.length();
        FORi(0,t){
            final char c=needle.charAt(i);
            if(c<128&&lettr_digt[c] && c!=hs[fromH+i]) return false;
        }
        return true;
    }
#undef allowSlashInName
#undef allowPipeInName
#undef allowColonInName
#undef _gap
#undef tmpClr
