@*H BUT_C2(Strap,SPARSER_SP)
Sequence files where the sequence block is at the end of the file.
See File_example:gb File_example:embl File_example:uniprot

This sequence block might have preceding or trailing
position numbers.

In case there is no numbering then the sequence
block must be indented by space of any length.  To identify the first
and last line of this sequence block the program starts looking from
the end of the file.  This is because files usually start with
annotations and references which might be mistaken for the sequence if
started from the first line.

<BR>GenBank sample: http://www.ncbi.nlm.nih.gov/Sitemap/samplerecord.html ftp://ftp.ncbi.nih.gov/genbank/gbrel.txt

*@
int from=-1,to=-1;
boolean numbersL=false,numbersR=false;
ROFiL0(eol.length){
    final int b=BOL0(iL,eol),e=eol[iL];
    if(to<0){
        numbersL=_swissIsLineOK(T,b,e,false,true,false);
        numbersR=_swissIsLineOK(T,b,e,false,false,true);
    }
    if(_swissIsLineOK(T,b,e,to>0,numbersL,numbersR)){
        from=b;
        if(to<0) to=e;
    }else if(to>=0) break;
 }
if(from<0) return null;
final byte[]aa=allLettersB(T,from,to);
if(aa!=null && aa.length>0){
    if(p!=null){
        boolean upCase=false;
        ROFi0(aa.length) if((aa[i]&32)==0) {upCase=true;break;}
        if(!upCase) ROFi0(aa.length) aa[i]&= ~32;
        p.setResidueType(aa);
        if(0==(opt&PROTPARS_NO_HEADER)){
            IF_MEIN_DEBUG(if(p.subsetStart()!=0) assrt());;
            if(p.onlyActgn()||p.isTranslated()) parseCDS(p,txt);
            if(strStarts("LOCUS ",txt)){/*X NCBI http://xulab.bxaf.net/bxaf6/bxseqtools/help_gb_format.php */
                final Collection v=vClr(18);
                final boolean[]no_spc=chrClas(-SPC);
                _swissEC(T,eol,v);
                for(int iL=0;;iL++){
                    LINE_TRIM_BE(iL,txt);;
                    if(e-b<9) continue;
                    final byte c0=T[b];
                    if(c0=='L'&&strEquAt(0,"LOCUS ",T,b)) p.setMoleculeType(T,b+10,e);
                    if(c0=='O'&&strEquAt(0,"ORGANISM ",T,b)) p.setProperty(P_ORGANISM_SC,strgTrim(T,nxt(no_spc,T,b+8,e),e));
                    if(c0=='A'&&strEquAt(0,"ACCESSION ",T,b)) p.addSeqRef(ADD_SEQREF_ACC,"ENTREZ:"+tokn(T,nxt(no_spc,T,b+9,e),e,null));
                    if(c0=='D'&&strEquAt(0,"DEFINITION ",T,b)){
                        String skip=null;
                        int f=nxt(STR_E,no_spc,T,b+10,e);
                        if(strEquAt(0,skip="RecName: Full=",T,f)) f+=skip.length();
                        p.setProperty(P_COMPOUND,strgTrim(T,f,strstr(STR_E,"AltName:",T,f,strchr(STR_E|'[',T,f,e))));
                    }
                    if(c0=='V'&&strEquAt(0,"VERSION ",T,b)){/*X  --- VERSION     M57965.2  GI:24429600 --- */
                        final int gi=strstr(0,"GI:",T,b+7,e);
                        if(gi>0) p.addSeqRef(0,tokn(T,gi,e,null));
                    }
                    if(c0=='D'&&strEquAt(0,"DBSOURCE ",T,b)){/*X  --- DBSOURCE    pdb: molecule 1CF1, chain 68,  --- */
                        final int pdb=strstr(STR_AFTER,"pdb: molecule",T,b+7,e);
                        if(pdb>0){
                            final int chain=atoi(T,strstr(STR_AFTER,", chain ",T,pdb,e),e);
                            p.setPdbID(0,tokn(T,pdb,e,chrClas(SPACE_COMMA)).toLowerCase()+ (chain>='0'?":"+(char)chain:""));
                        }
                    }
                }
                p.setProperty(PROTEINO_EC,v);
            }else{
                {
                    final BA sb=baClr(133);
                    if(_swissEntries('D'|('E'<<8),sb,txt)) p.setProperty(P_COMPOUND,sb);
                    if(_swissEntries('O'|('S'<<8),sb,txt)){
                        final int parOpen=strstr(0," (",sb);
                        int parClose=-1;
                        if(parOpen>1 && (parClose=strstr(0,") (",sb,parOpen,MAX_INT))<0){/*X OS   Danio rerio (Zebrafish) (Brachydanio rerio).*/
                            parClose=strstr(0,").",sb,parOpen,MAX_INT);
                        }
                        p.setProperty(P_ORGANISM_SC,parClose<0?sb.del('.'): sb.newString(0,parOpen));
                        if(parClose>0) p.setProperty(P_ORGANISM,sb.newString(parOpen+2,parClose));
                        clr(sb);
                    }
                    if(_swissEntries('O'|('C'<<8),sb,txt)) p.setProperty(P_TAXONOMY,sb.del('.'));
                }
                boolean isEnsemble=false;
                String accession=null;
                p.setProperty(PROTEINO_EC,_swissEC(T,eol,vClr(17)));
                byte[]ss=p.getResidueSecStrType();
                final int countCDS=p.countCDS();
                FORk(0,2){
                    FORiL(0,eol.length){
                        LINE_TRIM_BE(iL,txt);;
                        if(e-b<6 || T[b+2]!=' ') continue;
                        final int c01=(T[b]|(T[b+1]<<8));
                        isEnsemble=isEnsemble || c01==('D'|('E'<<8)) && strEquAt(0,"DE   annotated by Ensembl",T,b);
/* --- FT                   /db_xref="PDB:1IRU" --- */
/* --- FT                   /db_xref="UniProtKB/TrEMBL:Q9FDF2" */
                        if(c01==('F'|('T'<<8)) && countCDS<2){/*X  --- No refs for DNA-files more than one CDS --- */
                            final int dbref=strstr(STR_AFTER,"/db_xref=",T,b,e);
                            if(dbref>0){
                                int idx=-1;
                                final String DB=
                                    (idx=strstr(STR_AFTER,"Swiss-Prot:",T,dbref,e))>0?"UNIPROT:":
                                    (idx=strstr(STR_AFTER,"TrEMBL:",T,dbref,e))>0?"TREMBL:":
                                    (idx=strstr(STR_AFTER,"PDB:",T,dbref,e))>0?"PDB:":
                                    null;
                                if(DB!=null){
                                    final int quote=strchr('"',T,idx,e);
                                    if(quote>0) p.addSeqRef(0,DB+txt.newString(idx,quote));
                                }
                            }
                        }
                        if(k==0) continue;
                        switch(c01){
                        case'F'|('T'<<8):{
                            final char c=strEquAt(0,"FT   HELIX ",T,b)?'H': strEquAt(0,"FT   STRAND ",T,b)?'E': strEquAt(0,"FT   TURN ",T,b)?'T': ' ';
                            if(c!=' '&&ss==null) ss=new byte[p.countRes()];
                            if(ss!=null){
                                final int i1=mini(ss.length,atoi(T,b+14,e)),i2=mini(ss.length,atoi(T,b+21,e));
                                if(i1>0 && i2>0 && i2>i1) Arrays.fill(ss,i1-1,i2,(byte)c);
                            }
                            break;
                        }
                        case'I'|('D'<<8):
                        case'A'|('C'<<8):{
                            if(c01==('I'|('D'<<8))) p.setMoleculeType(T,b+3,e);
                            final String db=isEnsemble?"ENSEMBL:": p.onlyActgn()||p.isTranslated()?"EMBL:": "UNIPROT:";/*X  !!!!!!!!!*/
                            {
                                final String id=tokn(T,b+3,e,chrClas(SPACE_COMMA_SEMICOLON_DOT)),acc=db+id;
                                if(accession==null && c01==('A'|('C'<<8))) accession=acc;
                                p.addSeqRef(0,acc);
                            }
/* AC   Q86UR5; A7MBN6; O15048; Q5JY25; Q5SZK1; Q8TDY9; Q8TDZ5; Q9HBA1; */
                            if(T[e-1]==';'){
                                final int semikolon=strchr(';',T,b+3,e-3);
                                if(semikolon>0){
                                    final ChTokenizer tok=toknzr(344,SPACE_COMMA_SEMICOLON_DOT).setText(T,b+3,e-1);
                                    while(tok.nextToken()) p.addSeqRef(0,db+tok.asString());
                                    clr(tok);
                                }
                            }
                            break;
                        }
                        case'D'|('R'<<8):
                            {
                                final int idx=strstr(STR_AFTER,"PDB; ",T,b+3,e);
                                if(idx>0){
                                    final int semi=strchr(';',T,idx,e);
                                    if(semi>0) p.addSeqRef(0,"PDB:"+txt.newString(idx,semi));
                                }
                            }
                            FORi(0,4){
                                String DB=null,db=null;
                                switch(i){
                                case 0:db="Pfam; ";   DB="PFAM";break;
                                case 1:db="PRINTS; "; DB="PRINTS";break;
                                case 2:db="ProDom; "; DB="PRODOM";break;
                                default: db="PROSITE; "; DB="PROSITE";
                                }
                                final int idx=strstr(STR_AFTER,db,T,b+3,e);
                                if(idx>0){
                                    final int semi=strchr(';',T,idx,e);
                                    if(semi>0) p.addDatabaseRef(DB+":"+txt.newString(idx,semi));
                                }
                            }
                            break;
                        }
                    }
                    if(ss!=null){
                        for(int f=MAX_INT,t=0,prepare=2;--prepare>=0;){
                            ROFi0(ss.length){
                                final byte c=ss[i];
                                if(IS_UPPER_OR_LOWER(c)){
                                    if(prepare!=0){
                                        if(t==0) t=i;
                                        f=i;
                                    }
                                }else if(prepare==0){
                                    ss[i]=f<i && i<t?SECSTRU_NONE:SECSTRU_UNKNOWN;
                                }
                            }
                        }
                        p.setResidueSecStrType(ss);
                    }
                }
                if(accession!=null) p.addSeqRef(ADD_SEQREF_ACC,accession);
            }

        }
    }
    return DEFAULT_CHAINS_BY_TYPE;
 }
return null;
