#define _DEBUG_PW 0
#if _DEBUG_PW
#define IF_DEBUG_PW(a) a
#else
#define IF_DEBUG_PW(a)
#endif //_DEBUG_PW
public Collection<byte[]>getProteinText(int opt,Protein p,Matrix3D[]mm3d,Object residues,Collection<byte[]>vTxt){
    CPP_synchronized(SYNC_ProteinWriter){
        if(vTxt==null) vTxt=new ArrayList();
        final BA sb=baClr(134);
        final int from,to;
        {
            final int mx=p.subsetEnd()-p.subsetStart();
            if(residues instanceof int[]){
                from=((int[])residues)[RANGE_FROM];
                to=mini(mx,((int[])residues)[RANGE_TO]);
            }else{
                from=0;
                to=mx;
            }
        }
        final byte[]res=p.getResType();
        if(_it==SEQWRITER_FA ||_it==SEQWRITER_FA_NUC){
            sb.a('>').aln(p);
            if(_it==SEQWRITER_FA) sb.aFT(res,from,to);
            else{
                final byte[]nt=p.triplets();
                sb.aFT(nt,3*from,mini(strLen(nt),3*to));
            }
            sb.aln();
        }else if(_it==SEQWRITER_PDB){
            char chain=0!=(opt&SEQW_CHAIN_A)?'A':chainToChain1(residues instanceof String?(String)residues:p.getChain());
            if(chain=='_'||chain==0) chain=' ';
            sb.enlargeCapacityBy(999*1000,130);
            final byte[]rIns=0!=(opt&SEQW_IDX_FOR_RESNUM)?null:p.getResidueInsCode();
            final int
                type=p.getIntProperty(PROTEINI_CHAINTYPE),
                rAtomNum[]=0==(opt&SEQW_SIDE_CHAIN_ATOMS)?null:p.getResidueAtomNumber(),
                rAtomIdx[]=0==(opt&SEQW_SIDE_CHAIN_ATOMS)?null:p.getResidueAtomIdx();
            IF_TMP_AND_OCCUPANCY(final float[]aTemp=(float[])p.getProperty(PROTEINO_ATOM_B_FACTOR),aOccu=(float[])p.getProperty(PROTEINO_ATOM_OCCUPANCY));;
#if !CPP_PRG_AA
            if(type==CHAINTYPE_PEP && (opt&(SEQW_SEQRES|SEQW_SEQRES_IF_COORDINATES))!=0){
                int total=-1;
                while(true){
                    int count=0,iLine=0;
                    FORa(0,to){
                        if(residues instanceof boolean[]){
                            if(a>=sze(residues)) break;
                            if(!((boolean[])residues)[a]) continue;
                        }
                        if(total>=0){
                            if(count%13==0){
                                if(iLine>0) sb.aln();
                                sb.a("SEQRES").aInt(++iLine,4).aa(' ',chain).aInt(total,5).a("  ").bytesToCollection(vTxt);
                            }
                            sb.aBytesAdj(toThreeLetterCode(res[a]),4);
                        }
                        count++;
                    }
                    if(total<0) total=count; else break;
                }
                sb.aln();
            }
            if((opt&SEQW_HELIX_SHEET)!=0) sb.a(p.getProperty(PROTEINO_PDBTEXT_SECSTR)).a1('\n');
#endif //!CPP_PRG_AA
            FORiM(0,(sze(mm3d)>0?sze(mm3d):1)){
                final Matrix3D m3d=iM<sze(mm3d)?mm3d[iM]:null;
                if(m3d==null && iM>0) continue;
                final float[]xyz=0!=(opt&SEQW_SIDE_CHAIN_ATOMS)?p.getAtomXYZ(m3d):p.getResidueCalphaXYZ(m3d);
                //SEQW_SIDE_CHAIN_ATOMS getResidueCalphaXYZ
                if(xyz==null) continue;
                ensureCapcty(sze(vTxt)+xyz.length/3+10,vTxt);
                FORa(0,to){
                    final short[]ee=0==(opt&SEQW_SIDE_CHAIN_ATOMS)?null:p.getResidueElement(false,a);
                    final int[]atom32=0==(opt&SEQW_SIDE_CHAIN_ATOMS)?null:p.getResidueAtoms32(false,a);
                    IF_DEBUG_PW(final int end1=sb.end());;
                    if(residues instanceof boolean[]&& !iThBool(a,(boolean[])residues) || a<from) continue;
                    final int amino=a+p.subsetStart(),atomF,atomT;
                    if(0!=(opt&SEQW_SIDE_CHAIN_ATOMS)){
                        if(amino<0||amino>=sze(rAtomIdx)||(atomF=rAtomIdx[amino])<0) continue;
                        atomT=atomF+ee.length;
                    } else{
                        atomT=(atomF=a)+1;
                    }
                    char iCode=(char)iThByte(amino,rIns);
                    final int[]rAtom01234=0==(opt&SEQW_SIDE_CHAIN_ATOMS)?null:p.getResidueAtomNumberOffsets(amino);
                    if(iCode==0) iCode=' ';
                    for(int thisResn=0!=(opt&SEQW_IDX_FOR_RESNUM)?a+1+p.getIntProperty(PROTEINI_AA_IDX_OFFSET):p.resnAt(0,a),atom=atomF;atom<atomT;atom++){
                        IF_DEBUG_PW(boolean err=false);;
                        final int i3=3*(0!=(opt&SEQW_SIDE_CHAIN_ATOMS)?atom:amino),iAtom=atom-atomF;
                        if(xyz.length<=i3+2) break;
                        if(Float.isNaN(xyz[i3])) continue;
                        final int
                            end=sb.end(),
                            aType32=atom32!=null?iThIntOr(iAtom,atom32,'X'|('x'<<8)|('X'<<16)):
                            (type==CHAINTYPE_PEP||type==CHAINTYPE_DNA||type==CHAINTYPE_RNA) && atomT-atomF==1?(type==CHAINTYPE_PEP?'C'+('A'<<8):'P'):'X'|('X'<<8)|('x'<<16),
                            el=ee==null?aType32&127:iAtom<ee.length?ee[iAtom]:'X'|('X'<<8);
                        IF_DEBUG_PW(if(el='X'|('X'<<8)||aType32=='X'|('x'<<8)|('X'<<16)) err=true);;
                        //putln(DEBUG_NOW+" iAmino="+amino+" atom="+atom+"  atomF="+atomF+" atomT="+atomT+"  rAtomNum="+iThInt(amino,rAtomNum));
                        sb.a(type==CHAINTYPE_HET?"HETATM":"ATOM")
                            //.aInt(iThInt(amino,rAtomNum),7).aInt(iThInt(iAtom,rAtom01234),7)
                            .aInt(iThIntOr(amino,rAtomNum,atomF+1)+
                                   (0==(opt&SEQW_SIDE_CHAIN_ATOMS)?1:iThIntOr(iAtom,rAtom01234,iAtom)),
                                   type==CHAINTYPE_HET?5:7)
                            .an(' ',(el>>>8)==0?2:1)
                            .aBytes(aType32)
                            .fillSpaceTo(17+end).aBytesAdj((opt&SEQW_MET_INSTEAD_OF_MSE)!=0?toThreeLetterCode(iThByte(a,res)): p.getResName32At(a),-3)
                            .aa(' ',chain).aInt(thisResn,4).a(iCode).an(' ',3).aFloat(xyz[i3],4,3).aFloat(xyz[i3+1],4,3).aFloat(xyz[i3+2],4,3);
                        if(0==(opt&SEQW_SHORT_ATOM_LINES)){
                            IF_TMP_AND_OCCUPANCY(if(0==(opt&SEQW_NO_OCCUPANCY)) sb.aFloat(0!=(opt&SEQW_SIDE_CHAIN_ATOMS)&&aOccu!=null?aOccu[atom]:1,3,2).aFloat(0!=(opt&SEQW_SIDE_CHAIN_ATOMS)&&aTemp!=null?aTemp[atom]:0,3,2));;
                            sb.aBytesAdj(el,-(78+end-sb.end()));
                            if(0!=(opt&SEQW_PDB_TRAILING_SPC)) sb.fillSpaceTo(77+end);
                        }
#if _DEBUG_PW
                        if(err) sb.aa(" "+ANSI_RED+"!"+ANSI_RESET,a);
                        if(ee!=null && iThShort(iAtom,iThShorts(iThByte(a,res),AMINOACID_ELEMENTS))!=el) sb.a(" "+ANSI_YELLOW+"E"+ANSI_RESET);
                        if(0!=(opt&SEQW_SIDE_CHAIN_ATOMS) && atom==atomF && atomT-atomF>sze(atom32)){
                            sb.aa(ANSI_FG_RED+" num-atoms=",sze(atom32),ANSI_RESET);
                            if(onlyOnce(39)) baOut(RED_ERROR).aa(p," ProteinWriter1 ").aFT(sb.bytes(),end1,sb.end()).aln();
                        }
#endif //_DEBUG_PW
                        sb.aln().bytesToCollection(vTxt);
                    }
                    if(0!=(opt&SEQW_NICE_SPACING)) sb.delBlanksR().aln().aln();
                }
                ROFt0(2){/*X hetero */
                    if(0!=(opt&(t!=0?SEQW_HETEROS:SEQW_NT_STRUCTURE))){
                        Map names=null;
                        for(Protein s:p.getMolecules(t!=0?CHAINTYPE_HET:CHAINTYPE_NUC)){
                            sb.bytesToCollection(vTxt);
                            new Strap(SEQWRITER_PDB).getProteinText(SEQW_SIDE_CHAIN_ATOMS,s,mm3d,null,vTxt);
                            if(0!=(opt&SEQW_NICE_SPACING))sb.aln();
                            if(t!=0&&s.getProperty(P_TITLE)!=null) (names==null?names=new HashMap():names).put(io(s.getResidueName32()[0]),s.getProperty(P_TITLE));
                        }
                       for(Map.Entry e:entryArry(names)) sb.a("HETNAM     ").aBytesAdj(xatoi(e.getKey()),4).aln(e.getValue());
                    }
                }
                if(sze(mm3d)>0) sb.aBYTES('T','E','R').aln().aln();
            }

        }
        sb.bytesToCollection(vTxt);
        return vTxt;
    }
}
#undef _DEBUG_PW
