/* ---------------------------------------- */
/* >>> ResSel amino idx >>> */
public static int resSelFirstAmino(ResidueSelection s) {return s==null?-1: fstTrue(s.getSelectedAminoacids())+s.getSelectedAminoacidsOffset();}
public static int resSelAminoOffsetZ(ResidueSelection s) {return s==null?0:s.getSelectedAminoacidsOffset()-firstResIdx(sp(s));}
#if CPP_WITH_GUI
public static int resSelLastAmino(ResidueSelection s) {return s==null?-1: lstTrue(s.getSelectedAminoacids())+s.getSelectedAminoacidsOffset();}
public static boolean isResSelAminoSelectedZ(int a,ResidueSelection s){
    return s!=null&& iThBool(a-s.getSelectedAminoacidsOffset()+firstResIdx(sp(s)),s.getSelectedAminoacids());
}
#endif //CPP_WITH_GUI
/* <<< ResSel amino idx  <<< */
/* ---------------------------------------- */
/* >>> ResSel Variables >>> */
@*SARRAY_FIRST_AAA_LAST_AAA
$FIRST_AAA|$LAST_AAA|$FIRST_aaa|$LAST_aaa|$FIRST_Aaa|$LAST_Aaa|$FIRST_Aaa|$LAST_Aaa|$FIRST_INDEX|$LAST_INDEX|$FIRST_NUMBER|$LAST_NUMBER|$FIRST_A|$LAST_A
*@
@*SARRAY_resSelVariables
$CHAIN|$SELECTION_NAME|$TEX_RESIDUES|$TEX_PROTEIN|CPP_UNSTRINGIZE(RESAN_RESIDUES_BEFORE_GAPS)
*@
@*SARRAY_COLOR_RGBA__RGB
$COLOR_RGB|$COLOR_RGBA
*@
public static String[]resSelVariables(int n){
    if(_resSelVarNames==null)_resSelVarNames=new String[][]{joinArrys(0,null,arry(SARRAY_FIRST_AAA_LAST_AAA),arry(SARRAY_resSelVariables),String.class),arry(SARRAY_FIRST_AAA_LAST_AAA)};
    return _resSelVarNames[n];
}
public static Object resSelReplaceVariable(Object txt,ResidueSelection s){
    if(s!=null && strchr('$',txt)>=0){
        txt=resSelReplaceVariableBB(txt,s.getSelectedAminoacids(),s.getSelectedAminoacidsOffset(),nam(s),sp(s),null);
        ROFi0(2){
            final Object color=strstr(STR_w,arry(SARRAY_COLOR_RGBA__RGB)[i],txt)<0?null:getColrO(s);
            if(color!=null) txt=strplc(STR_w,arry(SARRAY_COLOR_RGBA__RGB)[i],new BA(7).aFT(color,0,i==1?8:6),txt);
        }
    }
    return txt;
}
public static Object resSelReplaceVariableBB(Object txt,boolean[]bb,int offset,String name,Protein p,Protein[]allPP){
    if(strchr('$',txt)>=0){
    if(strstr(0,"$FIRST_",txt=strplc(STR_w_R,"$SELECTION_NAME",name,txt))>=0 || strstr(0,"$LAST_",txt)>=0){
        for(String n:resSelVariables(1)){
            if(strstr(0,n,txt)<0) continue;
            final int idx=offset+(chrAt(1,n)=='F'?fstTrue(bb): lstTrue(bb)),cz=lstChar(n),cy=chrAtR(1,n),cx=chrAtR(2,n),a;
            final String rplc=
                idx>=(p==null?0:p.countRes())||idx<0?"?":
                cy=='E'&&cz=='X'?s(idx+1):
                cy=='_'&&cz=='A'?s(chrAt(idx,p.getResType())):
                cy=='E'&&cz=='R'?s(idx<0||p==null?-1:idx+1):
                (cx|32)=='a'&&(cy|32)=='a'&&(cz|32)=='a'?
                s(new byte[]{(byte)((a=p.getResName32At(idx))&0xff|(cx&32)),
                            (byte)((a>>>8)&0xff|(cy&32)),
                            (byte)((a>>>16)&0xff|(cz&32))}):
                null;

            if(rplc!=null) txt=strplc(STR_w_R,n,rplc,txt);
        }
    }
    txt=strplc(STR_w_R,"$CHAIN",p==null?"?":p.getChain(),txt);
    String n;
    IF_GUI(if(strstr(STR_w_R,n="$TEXSHADE_RESIDUES",txt)>=0|| strstr(STR_w_R,n="$TEX_RESIDUES",txt)>=0) txt=strplc(STR_w_R,n,texshadeRange(bb,offset),txt));;
    if(IF_GUI(strstr(STR_w_R,n="$TEX_PROTEIN",txt)>=0||)strstr(STR_w_R,n="$PROTEIN_NO",txt)>=0) txt=strplc(STR_w_R,n,s(p==null||allPP==null?1:idxOf(p,allPP)+1),txt);
    }
    return txt;
}
/* <<< ResSel Variables <<< */
/* ---------------------------------------- */
IF_GUI(public static String selectedPositionsToText(ResidueSelection s) {return selectedPositionsToText(0,s.getSelectedAminoacids(),s.getSelectedAminoacidsOffset(),sp(s));});;
public static String selectedPositionsToText(int opt,boolean[]bb,int offset,Protein p){
    if(bb==null) return "";
    BA sb=null;
    if(p.getChain()==null) opt&=~SELPOS2TXT_PDB_RESNUM;
    FORi(0,bb.length){
        if(bb[i]){
            if(sb==null) sb=new BA(99);
            else{
                sb.a(',');
                if(0==(opt&SELPOS2TXT_COMPACT_NO_SPC)) sb.a(' ');
            }
            final int iA0=i+offset;
            while(i<bb.length && bb[i]) i++;
            final int iA1=i+offset,d=iA1-iA0;
            if(0!=(opt&SELPOS2TXT_PDB_RESNUM)){
                p.resnAsText(0,iA0,sb);
                if(d>1) p.resnAsText(0,iA1-1,sb.a(d>2?'-': ','));
            }else{
                sb.a(iA0+1);
                if(d>1) sb.a(d>2?'-': ',').a(iA1);
            }
        }
    }
    return toStrgN(sb);
}
static String resSelSimplifyPos(int pdbNumbering,ResidueAnnotation s){
    final Protein p=sp(s);
    return p==null?null:
        selectedPositionsToText(pdbNumbering==CTRUE||pdbNumbering==0&&s.value(IRESAN_POS).indexOf(':')>0?SELPOS2TXT_PDB_RESNUM:0,
                                s.isAmino()?s.getSelectedAminoacids(): s.getSelectedNucleotides(),
                                s.isAmino()?s.getSelectedAminoacidsOffset(): s.getSelectedNucleotidesOffset(),
                                p);
}
public static boolean resSelEqualAminoPos(ResidueSelection s1,ResidueSelection s2){
    return s1!=null && s2!=null && sp(s1)==sp(s2) && eqBoolArraysOffset(s1.getSelectedAminoacids(),s1.getSelectedAminoacidsOffset(),s2.getSelectedAminoacids(),s2.getSelectedAminoacidsOffset());
}
public static boolean resSelPosMatches(byte[]txt,int f,int t,ResidueSelection s){
    final Protein p=sp(s);
    return p!=null && resSelFirstAmino(s)==p.indexFromExpression(txt,f,t);
}
/* <<< ResSel Position <<< */
/* ---------------------------------------- */
/* >>> ResSel asString >>> */
public static void resSelPrint(int opt,Object[]oo,BA sb){
    final ResidueSelection[]ss=new ResidueSelection[(oo=oo.clone()).length];
    for(Object o0:oo){
        final Protein p=sp(derefRessel(o0));
        if(p==null) continue;
        sb.aa(p,'/');
        int count=0;
        FORi(0,oo.length){
            final ResidueSelection s=derefRessel(oo[i]);
            if(sp(s)==p){
                oo[i]=null;
                ss[count++]=s;
            }
        }
        if(count==0) continue;
        if(count>1) sb.a('{');
        FORi(0,count){
            sb.an(' ',i>0?1:0).a(nam(ss[i]));
            if(0==(opt&RESSEL_PRINT_NO_AT)) sb.a('@').a(resSelFirstAmino(ss[i])+1);
        }
        if(count>1) sb.a('}');
        if(0!=(opt&RESSEL_PRINT_SLASH_N)) sb.aBYTES('\\','n'); else sb.a('\n');
    }
}
#if CPP_WITH_GUI
public static BA resSelAsText(boolean name,ResidueSelection s,BA sb){
    if(s!=null){
        sb.a(sp(s)).aln();
        if(sze(nam(s))>0 && name) sb.a(nam(s));
        else sb.boolToText(s.getSelectedAminoacids(),1+firstResIdx(sp(s))+s.getSelectedAminoacidsOffset(),",","-");
        sb.aln();
    }
    return sb;
}
#endif //CPP_WITH_GUI
/* <<< ResSel asString <<< */
/* ---------------------------------------- */
/* >>> ResSel Style >>> */
public static boolean vis123isUnderline(ResidueSelection s) {return s!=null&&(s.getStyle()&SSTYLE_MASK)==SSTYLE_UNDERLINE;}
public static boolean vis123isThere(int where,ResidueSelection s){
    final int w=where&~VIS123_NO_FLASH;
    return
        s!=null&&
        IF_GUI(((w&VIS123_SEQUENCE)==0|| w!=where || s==_rsNoHide || !cntainsEl(s,_rsHide)) &&)
        runCR(RUN_IS_ENABLED,s)!=FALSEr&&
        !(w!=0 && 0==(s.getVisibleWhere()&w));
}
#if CPP_WITH_GUI
public static boolean[]resSelPosDisplayed(ResidueSelection s){
    if(s instanceof ResidueAnnotation && s!=_rsNoHide){
        final boolean[]sa=((ResidueAnnotation)s).getSelectedAminoacids(),saViewed=(boolean[])((ResidueAnnotation)s).cached()[RESANCACHE_IS_SEL_DISPLAYED];
        return saViewed!=null?saViewed: sa;
    }
    return s!=null?s.getSelectedAminoacids(): NO_boolean;
}
#endif //CPP_WITH_GUI
public static int resSelLayoutUL(IF_GUI(boolean useArrows,)Protein[]pp){
    IF_GUI(assrtEDT(79));;
    final int[]rows;
    {
        int nRmax=0;
        for(Protein p:pp) nRmax=maxi(nRmax,p.countRes());
        rows=new int[nRmax];
    }
    ResidueSelection[]ff=new ResidueSelection[99];
    int maxLine=-1;
    for(Protein p:pp){
        Arrays.fill(rows,0);
        int count=0;
        for(ResidueSelection s:p.allResidueSelectionsSorted()){
            if(vis123isUnderline(s) && vis123isThere(VIS123_SEQUENCE|VIS123_NO_FLASH,s)){
                if(count>=ff.length) ff=chSze(ff,count+99,ResidueSelection.class);
                ff[count++]=s;
            }
        }
        if(count==0) continue;
        while(true){
            try{
                Arrays.sort(ff,0,count,comparator(COMPARE_Feature));
            }catch(Exception ex){
                IF_GUI(if(setLegacySort(ex,"resSelLayoutUL")) continue);;
            }
            break;
        }
        final int nR=p.countRes(),idx1=firstResIdx(p);
        FORiS(0,count){
            final boolean[]bb=IF_GUI(useArrows?resSelPosDisplayed(ff[iS]):) ff[iS].getSelectedAminoacids();
            final int offset=ff[iS].getSelectedAminoacidsOffset()-idx1,to=mini(nR,offset+lstTrue(bb)+1);
        nextRow:
            FORiL(0,32){
#define bitMask (1<<iL)
                FORa(maxi(0,offset),to)if(bb[a-offset] && (rows[a]&bitMask)!=0) continue nextRow;
                FORa(maxi(0,offset),to)if(bb[a-offset]) rows[a]|=bitMask;
#undef bitMask
                ff[iS].setStyle(SSTYLE_UNDERLINE|(iL<<VIS123_BIT_SHIFT_LINE));
                if(maxLine<iL) maxLine=iL;
                break;
            }
        }
    }
    return maxLine+1;
}
/* <<< ResSel Style <<< */
/* ---------------------------------------- */
/* >>> ResSel Map Positions>>> */
public static boolean[]resSelMapPosZ(ResidueSelection[]ss,Protein pDest){
    if(pDest==null||ARRAY_EMPTY(ss)) return null;
    boolean[]selected=null;
    for(ResidueSelection s:ss) if(sp(s)!=null) selected=resSelMapPosZ(s.getSelectedAminoacids(),resSelAminoOffsetZ(s),sp(s),pDest,selected);
    return selected;
}
private static boolean[]resSelMapPosZ(boolean[]bbSrc,int offsetSrc,Protein src,Protein dest,boolean[]buffer){
    final boolean[]selDest=buffer!=null?buffer: new boolean[dest.countRes()];
    for(int i=sze(bbSrc)+offsetSrc;--i>=offsetSrc;){
        if(bbSrc[i-offsetSrc]){
            final int col=src.getResColumnAt(i),idxDest=dest.columnToIndex(CTRUE,col);
            if(idxDest>=0 && idxDest<selDest.length && dest.getResColumnAt(idxDest)==col) selDest[idxDest]=true;
        }
    }
    return selDest;
}
public static boolean[]ntPositions2aaZ(boolean[]nn,int offset,int[]returnMinIdx,Protein p){
    final int[]c2a;
    if(p==null || sze(c2a=p.coding2allPositions())==0) return NO_boolean;
    boolean[]aa=null;
    int aMin=MAX_INT,aMax=0;
    while(true){
        ROFi0(mini(c2a.length,p.countRes()*3)){
            {
                final int n=c2a[i]-offset;
                if(n<0 || n>=nn.length || !nn[n]) continue;
            }
            final int a=i/3;
            if(aa!=null){
                if(a>=aMin && aa.length>a-aMin) aa[a-aMin]=true;
                else MEIN_ASSRT();
            }else{
                if(aMin>a) aMin=a;
                if(aMax<a) aMax=a;
            }
        }
        if(aa==null) aa=aMin==MAX_INT?NO_boolean:new boolean[aMax-aMin+1];
        else break;
    }
    returnMinIdx[0]=aMin;
    return aa;
}
/* <<< ResSel Map Positions <<< */
/* ---------------------------------------- */
/* >>>ResSel Anno >>> */
public static int resanKeyToUniqIdx(String k){
    if(k!=null) ROFi0(IRESAN_ZZZ) if(iConst(SARRAYeq_RESAN_KEYS,i)==k) return i;
    return -1;
}
/* <<< ResSel Anno  <<< */
/* ---------------------------------------- */
/* >>> Protein Name Group >>> */

public static ResidueAnnotation annotateSeqStyleRgbPosNameGrp(Protein p,int style,int rgb,Object pos,Object name,String group){
    if(p==null) return null;
    final ResidueAnnotation a=new ResidueAnnotation(p);
    a.annoAdd(IRESAN_POS,pos).annoAdd(IRESAN_NAME,name).annoAdd(IRESAN_GROUP,group).setStyle(style);
    if(rgb!=0) runCR1(RUN_SET_COLOR,a,newColr(rgb));
    if(SSTYLE_UNDERLINE==style) a.setFeatureSrc(SEQFEAT_SRC_FILE);
    if(0==(style&SFLAG_NO_ADD)) addToProt(a,p);
    return a;
}
/* <<< Protein Name Group <<< */
/* ---------------------------------------- */
/* >>> 3D >>> */
public static boolean[]residuesAroundMoleculeZ(float max,BA txt,Protein p,boolean[]selected UNLESS_AA(,BA tt)){
    if(sze(txt)==0||p==null) return NO_boolean;
    final byte[]T=txt.bytes();
    strapIncMC(P_MC_RES_SELECTIONS,p);
    final Collection v=vClr(14);
    selected=redim(selected,p.countRes(),REDIM_CLEAR_ARRAY);
    final ChTokenizer TOK=new ChTokenizer(SPC).setText(txt);
 nextToken:
    while(TOK.nextToken()){
        final int f;
        final Protein pParent;
        {
            final int slash=strchr('/',T,TOK.from(),TOK.to());
            if(slash<0){
                f=TOK.from();
                pParent=p;
            }else{
                if(null==(pParent=sequenceWithName(byts2strg(T,TOK.from(),slash),null))) continue;
                f=slash+1;
            }
        }
        final int colon=strchr(':',T,f,TOK.to()),t=colon>0?colon:TOK.to();
        String chain=colon<0?null: pdbChainAt(T,colon+1,TOK.to());
        int no=t>f && 0>nxt(chrClas(-DIGT),T,f,t)?atoi(T,f,TOK.to()): INT_NAN;
#if CPP_WITH_FLAVIN
        if(TOK.to()-f==1 && T[f]=='!'){
            final String s=gcps(AROUND_KEY_DEFAULT_HETERO,p);
            if(s!=null){
                final int col=s.indexOf(':');
                chain=col<0?null:pdbChainAt(s,col+1,MAX_INT);
                no=xatoi(s);
            }
        }
#endif //CPP_WITH_FLAVIN
        final String asStrg=colon==f?null:s(T,f,t);
        final int name32=charsToBitsSkipSpc(T,f,t-f);
        for(Protein h:pParent.getMolecules(CHAINTYPE_NUC_OR_HET)){
            final int type=h.getIntProperty(PROTEINI_CHAINTYPE);
#define wrongChain (chain!=null&&!eqStr(h.getChain(),chain))
            if(!wrongChain&&(
                              strEquAt(0,delLstCmpnt(':',s(h)),T,f,t)||
                              no!=INT_NAN && type==CHAINTYPE_HET && no==h.resnAt(RESIDUE_FULL,0)||
                              colon==f && chain!=null||
                              asStrg!=null && asStrg.equals(h.getName())||
                              name32!=0 && name32==(type==CHAINTYPE_HET?h.getResidueName32()[0]:
                                                    type==CHAINTYPE_DNA?('D'|('N'<<8)|('A'<<16)):
                                                    type==CHAINTYPE_RNA?('R'|('N'<<8)|('A'<<16)):
                                                    0))
               ){
                adUniq(h,v);
                continue nextToken;
            }
        }
        if(colon==f && chain!=null) for(Protein prot:strapProteins()) if(chain.equals(prot.getChain())) adUniq(prot,v);
        adAllUniq(objectsWithRegex(OBJRX_RESSEL,TOK.asString(),strapProteins()),v);
    }/*X nextToken()*/
    ROFi0(sze(v)){
        final Object o=iThEl(i,v);
        IF_GUI(tt.aa(' ',o,' '));;
        p.residueSquareDistanceZ(0,p.subsetStart(),p.subsetEnd(),o,max,selected);
    }
    return selected;
}
