/* >>> Script_interpreter 998488 T3 >>> */
/* (NUM1 1) */
#define PARAMETER_PP 1
#define ONLY_PP 2
#define PARAMETER_PP_AA 3
#define ONLY_PP_AA 4
#define PARAMETER_P_OR_NEW 5
#define PARAMETER_PARSE 6
#define PARAMETER_ZZZ 7
//SSCRIPT_MSG_EXEMPLE_URL_ALIAS

/* (NUM1 1) */
#define SSCRIPT_MSG_DEFAULT 2
#define DEFAULT_FOR_INTREFACE_FN 3
#define DEFAULT_FOR_INTREFACE_UNKNOWN 4
#define DEFAULT_FOR_INTREFACE_NOT_APPLICABLE 5
#define GFF_MSG_AT_LEAST_3_FIELDS 6
#define GFF_MSG_START_END 7
#define SSCRIPT_MSG_CHAINS 8
#define SSCRIPT_MSG_CHAIN 9
#define SSCRIPT_MSG_CMD_NOT_PROCESSED 10
#define SSCRIPT_MSG_DIE 11
#define SSCRIPT_MSG_EXEMPLE_URL_ALIAS 12
#define SSCRIPT_MSG_EXPECT_COLOR_SCHEME 13
#define SSCRIPT_MSG_EXPECT_FEATURE_COLORS 14
#define SSCRIPT_MSG_EXPECT_KOMMA 15
#define SSCRIPT_MSG_EXPECT_PARAMPETER 16
#define SSCRIPT_MSG_EXPECT_RESANS 17
#define SSCRIPT_MSG_EXPECT_SEQS 18
#define SSCRIPT_MSG_MX3D 19
#define SSCRIPT_MSG_SECONDARY_STRUCTURE 20
#define SSCRIPT_MSG_NO_SEQS 21
#define SSCRIPT_MSG_NO_SUCH_FILE 22
#define SSCRIPT_MSG_NO_SUCH_SEQ 23
#define SSCRIPT_MSG_NO_SUCH_V3D 24
#define SSCRIPT_MSG_UNKNOWN_CMD 25
#define SSCRIPT_MSG_UNKNOWN_TAXONOMY 26
#define SSCRIPT_MSG_VAR_DECLARATION 27
#define SSCRIPT_MSG_WRONG_NUM_ARGS 28
#define SSCRIPT_MSG_EXPECT_EQ 29
#define SSCRIPT_MSG_RES_IDX_OUT_OF_RANGE 30

#if CPP_WITH_GUI
#define SSCRIPT_MSG_FAILED_INSTANTIATE_V3D 31
#define SSCRIPT_MSG_CMD_NOT_BG 32
#define SSCRIPT_MSG_EXPECT_CMD_AFTER_BG 33
#define SSCRIPT_MSG_NO_SUCH_BG_PROCESS 34
#define SSCRIPT_MSG_FAILED_CLASS_FORNAME 35
#define SSCRIPT_MSG_observeScriptFileBG 36
#endif //CPP_WITH_GUI

#if CPP_PRG_AA
#define SSCRIPT_MSG_EXPECT_IMG 37
#define SSCRIPT_MSG_UNKNOWN_IMG 38
#endif //CPP_PRG_AA

/* --- */

@*SARRAYeq_SSCRIPT_MSG
 sclSetDefaultForInterface=DEFAULT_FOR_INTREFACE_FN
 Unknown implementation=DEFAULT_FOR_INTREFACE_UNKNOWN
 Unknown_Taxonomy=SSCRIPT_MSG_UNKNOWN_TAXONOMY
 Not applicable=DEFAULT_FOR_INTREFACE_NOT_APPLICABLE

 Require at least 3 fields =GFF_MSG_AT_LEAST_3_FIELDS
 START (field 3) and END (field 4) must be numbers=GFF_MSG_START_END

 Outside residue index range [0-%n]=SSCRIPT_MSG_RES_IDX_OUT_OF_RANGE
 Expecting "~"-sign=SSCRIPT_MSG_EXPECT_EQ
 Exit due to Strap command SCRIPT_die=SSCRIPT_MSG_DIE
 Variable declaration.=SSCRIPT_MSG_VAR_DECLARATION
 Unknown command=SSCRIPT_MSG_UNKNOWN_CMD
 Expecting Komma=SSCRIPT_MSG_EXPECT_KOMMA
 No such file =SSCRIPT_MSG_NO_SUCH_FILE
 Expect list of sequences or residue selections=SSCRIPT_MSG_EXPECT_RESANS

 Error: wrong number of arguments =SSCRIPT_MSG_WRONG_NUM_ARGS

 Expecting "~". Example: CPP_UNSTRINGIZE(SCRIPT_feature_colors) Modified_residue~#FF2222,#FF0000=SSCRIPT_MSG_EXPECT_FEATURE_COLORS
 Expecting "~". Example: CPP_UNSTRINGIZE(SCRIPT_url_alias) WIKTIONARY:~http:||en.wiktionary.org|wiki|=SSCRIPT_MSG_EXEMPLE_URL_ALIAS
 Expect_parameter=SSCRIPT_MSG_EXPECT_PARAMPETER
 No_sequence=SSCRIPT_MSG_NO_SEQS
 Expect_list_of_sequences=SSCRIPT_MSG_EXPECT_SEQS
 No_such_sequence=SSCRIPT_MSG_NO_SUCH_SEQ
 Chains=SSCRIPT_MSG_CHAINS
 Chain=SSCRIPT_MSG_CHAIN
 Secondary structure=SSCRIPT_MSG_SECONDARY_STRUCTURE
 Matrix3D=SSCRIPT_MSG_MX3D
 No 3D-viewer with this name=SSCRIPT_MSG_NO_SUCH_V3D
 Command not processed=SSCRIPT_MSG_CMD_NOT_PROCESSED

 Expect color scheme like =SSCRIPT_MSG_EXPECT_COLOR_SCHEME

#if CPP_WITH_GUI
 Could not instantiate protein structure viewer=SSCRIPT_MSG_FAILED_INSTANTIATE_V3D
 The command cannot be run in background=SSCRIPT_MSG_CMD_NOT_BG
 Expecting command after "bg"=SSCRIPT_MSG_EXPECT_CMD_AFTER_BG
 No such background process:=SSCRIPT_MSG_NO_SUCH_BG_PROCESS
 Failed Class.forName(...)=SSCRIPT_MSG_FAILED_CLASS_FORNAME
 observeScriptFileBG =SSCRIPT_MSG_observeScriptFileBG
#endif //CPP_WITH_GUI

#if CPP_PRG_AA
 Expecting image name=SSCRIPT_MSG_EXPECT_IMG
 Unknown image=SSCRIPT_MSG_UNKNOWN_IMG
#endif //CPP_PRG_AA

*@

@*SARRAYeq_StrapScriptInterpreter_Errors
 Expect either transcript numbers like "2,4-5" or a CDS expression like "reverse(10..30)" or the a gene product=iSCRIPT_cds
 Expect '~'=iSCRIPT_add_annotation
 iSCRIPT_add_annotation=iSCRIPT_set_annotation
 Expecting at least one residue selection of the form "sequence_name/100-110"=iSCRIPT_print_mapped_residue_indices
 Expect number=iSCRIPT_sleep
 iSCRIPT_sleep=iSCRIPT_biomt
 iSCRIPT_sleep=iSCRIPT_set_residue_index_offset
 iSCRIPT_sleep=iSCRIPT_set_nucleotide_index_offset
 Expecting GFF file URL or file PATH=iSCRIPT_GFF
 Unknown alignment program=iSCRIPT_use_aligner
 iSCRIPT_use_aligner=iSCRIPT_use_aligner3D
 iSCRIPT_use_aligner=iSCRIPT_use_aligner_p
 Expect list of sequences (DB-references, protein files, URLs)=iSCRIPT_load
 Expect web color such as #00FF00 (hash+hex rgb or rgba)=iSCRIPT_color
 Expecting 3 tokens=iSCRIPT_add_het
 Error parsing matrix=iSCRIPT_rotate_translate
 iSCRIPT_rotate_translate=iSCRIPT_rotate_translate_complex
 Expect database reference like UNIPROT:P29590=iSCRIPT_xref
 iSCRIPT_xref=iSCRIPT_AC
 iSCRIPT_xref=iSCRIPT_remove_xref

#if CPP_WITH_GUI
 iSCRIPT_sleep=iSCRIPT_msec
 Not expecting a parameter=iSCRIPT_toFront
 iSCRIPT_toFront=iSCRIPT_iconify
 iSCRIPT_toFront=iSCRIPT_deiconify
 Expect command name=iSCRIPT_wait_for
 Unknown 3D viewer=iSCRIPT_use_3D_viewer
 iSCRIPT_to_row=iSCRIPT_below_row
 Wrong destination row=iSCRIPT_to_row
 Phylogenetic tree: At least 3 sequences are required=iSCRIPT_tree
#endif //CPP_WITH_GUI

*@

@*RSC_INTS_V3D_STYLE_COMMANDS
 iV3DCMD_spheres iV3DCMD_sticks iV3DCMD_lines iV3DCMD_ribbons iV3DCMD_surface iV3DCMD_sa_surface iV3DCMD_dots iV3DCMD_mesh iV3DCMD_cartoon
*@
@*RSC_INTS_V3D_COMMANDS_WITH_COLOR
 iV3DCMD_cartoon iV3DCMD_color iV3DCMD_surface_color iV3DCMD_surface iV3DCMD_background iV3DCMD_change_object_color
*@

//#define syntaxFromCmd _syntx[cmd]
/* --- */
private ResidueAnnotation[]_siResanLstCreated;
private Protein[]_siParsePP;
private String _siParseID;
public static int v3dCmdInLine(Object txt) {return chrAt(0,txt)=='3'?scriptCmdInLine(txt,0,MAX_INT):0;}
public static int scriptCmdInLine(Object txt,int b,int e){
    if(txt==null) return 0;
    byte[]T=null;
    if(txt instanceof byte[]) T=(byte[])txt;
    else if(txt instanceof BA){
        e=mini(e,(T=((BA)txt).bytes()).length)+((BA)txt).begin();
        b+=((BA)txt).begin();
    }
    int k;
    {
        if(T!=null){
            if(e<=b||T.length<=b||T[b]=='#') return 0;
            int spc=nxt(STR_E,chrClas(SPC),T,b,e);
            if(spc<e) spc++;
            k=idxOfArry(s(T,b,spc),SARRAY_STRAP_SCRIPT_CMD);
        }else{/*X txt is String */
            if((e=mini(e,sze(txt)))<=b||chrAt(b,txt)=='#') return 0;
            int spc=nxt(STR_E,chrClas(SPC),(String)txt,b,e);
            if(spc<e) spc++;
            return idxOfArry(((String)txt).substring(b,spc),SARRAY_STRAP_SCRIPT_CMD);
        }
    }
    if(k>0){
#if !CPP_WITH_GUI
        if (0!=(SCRIPT_OPT_GUI&iThInt(k,intArry(SARRAY_STRAP_SCRIPT_OPT)))){
            final String s=iConst(SARRAY_STRAP_SCRIPT_CMD,k);
            if(onlyOnceHC(322,s)) baOut(RED_WARNING).a(s).aln(": Command only available with GUI.");
            return 0;
        }
#endif //!CPP_WITH_GUI

@*SARRAYeq_SCRIPT_OLD
        iSCRIPT_xref=iSCRIPT_OLD_add_xref
        iSCRIPT_AC=iSCRIPT_accession_id
        iSCRIPT_gff_uniprot=iSCRIPT_OLD_GFF_uniprot_features
        iSCRIPT_gff_uniprot=iSCRIPT_OLD_GFF_expasy_features
        iSCRIPT_aa_sequence=iSCRIPT_sequence
        iSCRIPT_res_secstru=iSCRIPT_secondary_structure
#if CPP_WITH_GUI
        iSCRIPT_res_name=iSCRIPT_OLD_res_name4
        iSCRIPT_download_files=iSCRIPT_OLD_download_protein_files
        iSCRIPT_chain=iSCRIPT_OLD_set_chain_char
        iSCRIPT_cds=iSCRIPT_OLD_cds
        iSCRIPT_find_uniprot_id=iSCRIPT_OLD_find_uniprot_id_fast
#endif //CPP_WITH_GUI
*@
        int k2=iThInt(k,intArry(SARRAYeq_SCRIPT_OLD));
        return k2>0?k2:k;
    }
    //IF_MEIN_DEBUG(baOut(RED_WARNING).aa(iConst(SARRAYeq_SSCRIPT_MSG,SSCRIPT_MSG_UNKNOWN_CMD),' ').aFT(T,b,e).aln().special(STCKTRC));;
    return 0;
}
#if CPP_WITH_GUI
private Collection _siVJobs,_siVJobsKeep;
@*RSC_INTS_SI_CMDS_BG
 iSCRIPT_superimpose iSCRIPT_align iSCRIPT_GFF iSCRIPT_load iSCRIPT_add_het iSCRIPT_das iSCRIPT_gff_uniprot iSCRIPT_CSA iSCRIPT_download_files
*@
#endif //CPP_WITH_GUI
private ChTokenizer _tok;
private ChTokenizer tok(){
    if(_tok==null) _tok=new ChTokenizer(SPC);
    return _tok;
}
#define _siWaring(opt) baClr(139|opt)
#define siWarning() _siWaring(0)
#define siWarningClr() _siWaring(VCLR_CLEAR)
static float[]_siXyz;
private static ScriptVariables _siVars;
private static byte[]_siBufBB;
// _syntx
public void siInterpretScript(int opt,Object scriptOrArray){
    final BA script=scriptOrArray instanceof BA?(BA)scriptOrArray: siConcat(IF_GUI(true,false,)oo(scriptOrArray));
    if(sze(script)==0)return;
    script.replace(STRPLC_FILL_SPACES,"new_aminoacid_selection ",SCRIPT_new_aminoacid_selection);
    final byte[]T=script.bytes();
    IF_GUI(if(!isEDT()){thrdCR1(RUN_STRAP_SCRIPT|THRDCR_EDT_LATER,this,script); return;});;
#if CPP_WITH_GUI
    newAlignmentPanel(false);
    if(0==(opt&STRAPSCRIPT_NOT_FRAME_TO_FRONT) && !prgOptOn(iPAR_iconify)){
        for(int iL=0;;iL++){
            final long be=lineTrim(iL,script);
            if(be==-1){wndw(WNDW_NATIVE|WNDW_DO_FRONT|WNDW_MAIN_WINDOW,null);break;}
            if((be&RANGETO_MASK)-(be>>>((long)RANGEFROM_SHIFT))>6 && strEquAt(STR_w,SCRIPT_iconify,T,(int)(be>>>((int)RANGEFROM_SHIFT)))) break;
        }
    }
#endif //CPP_WITH_GUI
    if(_siVars==null) _siVars=new ScriptVariables();
    final BA print=new BA(99);
    BA baObj=null,baArgs=new BA(0);
    for(int iL=0;;iL++){
        clr(print);
        int b;
        final int e;
        {
            final long be=lineTrim(iL,script);
            if(be==-1) break;
            if((e=(int)(be&RANGETO_MASK))-(b=(int)(be>>>((int)RANGEFROM_SHIFT)))<2 ||T[b]==0) continue;
            if(T[b]=='#'){
                if(0!=(opt&STRAPSCRIPT_HASH_CREATE_NEW_PROTEIN)){
                    if(T[b+1]==STRAPFORMAT_HASH_ID)_siParseID=wordAt(T,b+2);
                    if(T[b+1]==STRAPFORMAT_HASH_CHAIN){
                        final Protein p=new Protein();
                        p.setName(addSfx(_siParseID,wordAt(T,b+2)));
                        p.setPdbID(PDBID_ID,s(p));
                        p.setProperty(PROTEINO_ALIGNMENT,_main);
                        strapSetSequenceIsInAlignment(CTRUE,_siParsePP=spp(p));
                    }
                }
                continue;
            }

        }
        int iErr=0;
        siWarningClr();
        IF_GUI(String jobId=null;int evt=-1,evtLater=-1,timeOutMS=0);;
#define EVT_LATER(e) IF_GUI(evtLater=e)
#define EVT_NOW(e) IF_GUI(evt=e)
        final Protein[]ppAll=strapProteins()IF_GUI(,ppVis=strapVisibleProteins());
        Runnable IF_GUI(threadGuiBG=null,) threadBG=null;
        if(T[b]=='b' && T[b+1]=='g' && !isChrClas(-SPC,T,b+2)){
            b=nxt(chrClas(-SPC),T,b+2,e);
#if CPP_WITH_GUI
            {
                if(sze(jobId=wordAt(T,b))==0) {iErr=SSCRIPT_MSG_EXPECT_CMD_AFTER_BG;continue;}
                boolean ok=false;
                for(int s:intArry(RSC_INTS_SI_CMDS_BG))  ok=ok||strEquAt(STR_w_R,jobId,iConst(SARRAY_STRAP_SCRIPT_CMD,s),0);
                if(!ok) {iErr=SSCRIPT_MSG_CMD_NOT_BG;continue;}
            }
#else
#define ppVis ppAll
#endif //CPP_WITH_GUI
        }
        final int cmd,logEnd=baLog(LOG_SCRIPT_INTERPRETER).end();
        {
            final int c=scriptCmdInLine(T,b,e);
            cmd=c==0&&strchr(' ',T,b,e)<0?scriptCmdInLine(new BA(e-b+1).aFT(T,b,e).a(' '),0,MAX_INT):c;
        }
        if(cmd==0)iErr=SSCRIPT_MSG_UNKNOWN_CMD;
        try{
#if CPP_WITH_GUI
            if(cmd==iSCRIPT_exit) break;
            if(cmd==iSCRIPT_close_strap) shutDwn(5555);
            final int stx=iThInt(cmd,intArry(SARRAY_STRAP_SCRIPT_OPT));
            if(0!=(stx&(SCRIPT_OPT_IGNORE_TREE_OR_JALVIEW|SCRIPT_OPT_3D)) && prgOptOn(iPAR_toJalview)||prgOptOn(iPAR_toTree)) continue;
#endif //CPP_WITH_GUI
            {
                final int noSpc=nxt(STR_E,chrClas(-SPC),T,strchr(STR_E|' ',T,b,e),e);
                if(cmd==iSCRIPT_let){
                    if(!_siVars.evalVarAssignment(T,noSpc,e))siWarning().aln(iConst(SARRAYeq_SSCRIPT_MSG,SSCRIPT_MSG_VAR_DECLARATION));
                    continue;
                }
                if(cmd==iSCRIPT_xyz||cmd==iSCRIPT_xyzAlpha) clr(baArgs).aFT(T,noSpc,e);
                else baArgs=_siVars.set(true,T,noSpc,e).mkBA(baArgs);
            }
            if(cmd==iSCRIPT_die) baOut(ANSI_RED).a(iConst(SARRAYeq_SSCRIPT_MSG,SSCRIPT_MSG_DIE)).aln(baArgs).special(EXIT_NOW);
            final Protein[]omittedPP;
            final int lstKomma,fstKomma,L=baArgs.end();
            final byte[]A=baArgs.bytes();
            if(_siParsePP!=null && cmd!=iSCRIPT_add_annotation && cmd!=iSCRIPT_new_aminoacid_selection){/*X  Was sollte das? iSCRIPT_color && !(L>1 && A[L-1]=='~' && A[L-2]=='~') */
                omittedPP=_siParsePP;
                fstKomma=lstKomma=L;
            }else if((cmd==iSCRIPT_select_3D IF_GUI(||(cmd==iSCRIPT_close_3D||cmd==iSCRIPT_to_front_3D))) && strchrBwd(',',A,L-1,-1)<0){
                fstKomma=lstKomma=L;
                omittedPP=ppAll;
            }else{
                lstKomma=strchrBwd(',',A,L-1,-1);
                omittedPP=null;
                fstKomma=strchr(',',A,0,L);
            }
            if(cmd==iSCRIPT_alignment_type_P||cmd==iSCRIPT_alignment_type_N||cmd==iSCRIPT_alignment_type_CN){
                _aliType=cmd;
                continue;
            }
            if(cmd==iSCRIPT_wrap_off){
                SI_VALUES[cmd]="";
                continue;
            }
            if(cmd==iSCRIPT_simul_exception){
                final Object[]oo={null};
                if(sze(baArgs)==0) oo[4711]=null;
                else try{oo[4711]=null;}catch(Exception ex){stckTrcCT(90);}
                continue;
            }
#define stxType (stx&SCRIPT_SYNTAX_MASK)
            String para=null;
            if(stxType==PARAMETER_PP_AA||stxType==PARAMETER_PP||stxType==PARAMETER_P_OR_NEW){
                if(lstKomma<0 && omittedPP==null)iErr=SSCRIPT_MSG_EXPECT_KOMMA;
                else{
                    para=toStrgTrim(A,0,lstKomma);
                    baObj=omittedPP!=null?null:new BA(A,lstKomma+1,L);
                }
            }else if(stxType==ONLY_PP_AA||stxType==ONLY_PP){
                baObj=baArgs;
            }else{
                para=toStrgTrim(baArgs);
            }
            if(baObj!=null) baObj.trim();

            if(IF_GUI((cmd==iSCRIPT_toFront||cmd==iSCRIPT_iconify||cmd==iSCRIPT_deiconify)&&sze(para)>0||)
               (cmd==iSCRIPT_sleep||cmd==iSCRIPT_set_characters_per_line) && !looks(LIKE_INTEGER,A,chrAt(0,A)=='+'?1:0,L)||
               (cmd==iSCRIPT_set_residue_index_offset||cmd==iSCRIPT_set_nucleotide_index_offset) && (!isChrClas(DIGT_DASH,para,0)||nxt(0,chrClas(-DIGT),para,1,MAX_INT)>0))iErr=SSCRIPT_MSG_DEFAULT;
            if(iErr!=0){
            }else if(cmd==iSCRIPT_GFF){/*X  GFF test.seq||Modified residue|4|4|.|.|.|Note=Phosphotyrosine */
                baArgs.replaceChar('|','\t');
                final int tab=strchr('\t',A,0,L);
                if(tab>=0){
                    for(Object p:omittedPP!=null?omittedPP:objectsWithRegex(OBJRX_RESSEL,s(A,0,tab),ppVis)){
                        if(p instanceof Protein){
                            final ResidueAnnotation a=new ResidueAnnotation((Protein)p);
                            if(0==(iErr=sftrParseGffLine(0,A,0,L,null,a))){
                                addToProt(a,(Protein)p);
                                _siResanLstCreated=new ResidueAnnotation[]{a};
                                EVT_NOW(EVT_RESIDUE_SELECTION_ADDED);
                            }
                        }
                    }
                }else{
                    final BA txt=readBytes(para);
                    if(sze(txt)==0)iErr=SSCRIPT_MSG_DEFAULT;
                    else{
                        if(strchr('\t',txt)<0) txt.replaceChar('|','\t');
                        IF_GUI(threadGuiBG=)gffFromFileOrServer(RETURN_THREAD|SEQFEAT_PUT_LOADED|SEQFEAT_NOT_MAP_SYN,null,txt,omittedPP,null);;
                    }
                }
            }else if(cmd==iSCRIPT_echo){
                for(String s:splitTkns(para)){
                    final Object[]oo=objectsWithRegex(OBJRX_RESSEL,s,ppVis);
                    if(oo.length==0) print.a(s).a1(' ');
                    else{
                        for(Object o:oo) if(o instanceof Protein) print.aa(o," ");
                        resSelPrint(0,oo,print.a1('\n'));
                    }
                }
                print.a('\n');
@*SARRAYeq_INTRFC_FOR_SCRIPTCMD
                 INTRFC_SequenceAligner=iSCRIPT_use_aligner
                 INTRFC_SequenceAligner3D=iSCRIPT_use_aligner3D
                 INTRFC_SequenceAlignerTakesProfile=iSCRIPT_use_aligner_p
#if CPP_WITH_GUI
                 INTRFC_View3d=iSCRIPT_use_3D_viewer
#endif //CPP_WITH_GUI
*@
            }else if(iConst(SARRAYeq_INTRFC_FOR_SCRIPTCMD,cmd)!=null){
                iErr=sclSetDefaultForInterface(xatoi(iConst(SARRAYeq_INTRFC_FOR_SCRIPTCMD,cmd)),para);
#if CPP_WITH_GUI
            }else if(cmd==iSCRIPT_speak){
                speak(RETURN_THREAD,para);
            }else if(cmd==iSCRIPT_wait_for){
                final String[]waitFor=splitTkns(para);
                threadGuiBG=CPP_thrdM1(siWaitJobBG,Strap.this,waitFor);
                if(waitFor.length==0)iErr=SSCRIPT_MSG_DEFAULT;
                else for(String s:waitFor) if(!cntainsEl(s,_siVJobsKeep))siWarning().a(iConst(SARRAYeq_SSCRIPT_MSG,SSCRIPT_MSG_NO_SUCH_BG_PROCESS)).aln(s);
            }else if(cmd==iSCRIPT_iconify){
                wndw(WNDW_DO_ICONIZE|WNDW_NATIVE|WNDW_MAIN_WINDOW,null);
            }else if(cmd==iSCRIPT_deiconify){
                wndw(WNDW_DO_FRAME_NORMAL|WNDW_NATIVE|WNDW_MAIN_WINDOW,null);
            }else if(cmd==iSCRIPT_toFront){
                wndw(WNDW_NATIVE|WNDW_DO_FRONT|WNDW_MAIN_WINDOW,null);
                awtc(AWTC_REQUEST_FOCUS,runCR(RUN_ALIPANEL_GET_PANE,aliPanel()));
            }else if(cmd==iSCRIPT_msec){
                if(isChrClas(DIGT,A,0)&&tok().setText(T,b,e).nextToken()&&tok().nextToken()&&tok().nextToken()){
                    inEDTms(thrdCR1(RUN_STRAP_SCRIPT,this,new BA(T,tok().from(),e)),xatoi(para));
                }else iErr=SSCRIPT_MSG_DEFAULT;
            }else if(T[b]=='*'){
                final Object[]data=new Object[SEVT_DATA_SIZE];
                data[SEVT_DATA_TEXTLINE]=new String[]{script.newString(b,e)};
                strapEvtData(EVT_SCRIPT_LINE,data);
#endif //CPP_WITH_GUI
            }else if(cmd==iSCRIPT_set_characters_per_line||cmd==iSCRIPT_set_export_columns||cmd==iSCRIPT_set_scrollposition||cmd==iSCRIPT_clip_N_term ||cmd==iSCRIPT_clip_C_term ||cmd==iSCRIPT_title){
                SI_VALUES[cmd]=para;
            }else if(cmd==iSCRIPT_set_conservation_threshold){
                SI_VALUES[cmd]=para;
                IF_GUI(runCR1(RUN_ALIPANEL_SET_THRESHOLD,aliPanel(),io(chrAt(0,para)=='i'?atoi(para,2)*100/ppVis.length-1: xatoi(para))));;
            }else if(cmd==iSCRIPT_sleep){
                IF_GUI(threadGuiBG=thrdSleep(xatoi(para)));;
                UNLESS_GUI(sleepMS(xatoi(para)));;
            }else if(cmd==iSCRIPT_set_color_mode){
                SI_VALUES[cmd]=para;
                if(rescolorSet(para)){
                    EVT_NOW(EVT_AA_SHADING_CHANGED);
                }else iErr=SSCRIPT_MSG_EXPECT_COLOR_SCHEME;
            }else if(cmd==iSCRIPT_url_alias||cmd==iSCRIPT_feature_colors){
                for(String s:splitTkns(para)){
                    final int eq=strchr('=',s);
                    if(eq<1)iErr=cmd==iSCRIPT_url_alias?SSCRIPT_MSG_EXEMPLE_URL_ALIAS:SSCRIPT_MSG_EXPECT_FEATURE_COLORS;
                    else{
                        final String key=s.substring(0,eq),val=s.substring(eq+1);
                        if(cmd==iSCRIPT_url_alias) hrefAddAlias(key,val);
                        else if(!ResidueAnnotation.sftrAddColors(key,val)) iErr=SSCRIPT_MSG_EXPECT_FEATURE_COLORS;
                    }
                }

            }else if(cmd==iSCRIPT_load){
#if CPP_PRG_AA
                if(strEnds("/"+DIRNAME_PARA+"/"+PARA_uploadedFiles,baArgs)){
                    final String[]ss=splitTkns(baArgs);
                    siAaReadUploadedSequences(file(ss[ss.length-1]),ss[0]);
                } else
#endif //CPP_PRG_AA
                    {
                        final String[]ss=splitTkns(baArgs);
                        if(ss.length==0)iErr=SSCRIPT_MSG_DEFAULT;
                        else if("--AA_SEQUENCES".equals(iThEl(0,ss))){
                            final String f=iThStrg(1,ss);
                            final BA txt=readBytes(f);
                            if(sze(txt)==0)iErr=SSCRIPT_MSG_NO_SUCH_FILE;
                            else siAaLoadSequences(txt);
                        }else{
                            IF_GUI(threadGuiBG=)
                                downloadProteins(RETURN_THREAD|LOADP_PROCESS_LOADED_P,ss,null IF_GUI(,null,oo(ALIAS_TARGET_ALIPANEL)));
                        }
                    }
            }else if(stxType==PARAMETER_P_OR_NEW){
                final Protein[]pp=omittedPP!=null?omittedPP:spp(_siProtsAndResansWithRegex(cmd,baObj,ppAll));
                final boolean createNew=ARRAY_EMPTY(pp);
                final String gapped=para!=null&&para.indexOf('-')>=0?para:null;
                if(cmd==iSCRIPT_aa_sequence||cmd==iSCRIPT_nt_sequence){
                    int count=0;
                    final byte[]bb=_siBufBB=redim(_siBufBB,fstKomma,99);
                    final boolean[]lettr=chrClas(LETTR);
                    FORi(0,fstKomma)if(iThBool(A[i],lettr)) bb[count++]=A[i];
                    final byte[]seq=cpyArry(bb,0,count);
                    if(seq.length>0 && (sze(baObj)>0||omittedPP!=null)){
                        Protein[]prots=pp;
                        if(createNew){
                            (prots=spp(new Protein()))[0].setProperty(PROTEINO_ALIGNMENT,_main);
                            if(sze(baObj)>0) prots[0].setName(new BA(99).aFilter(FILTER_NO_MATCH_TO_US|FILENM,baObj));
                            // strapSetSequenceIsInAlignment(CTRUE,prots);
                        }
                        final int aliType=strapAlignmentType();
                        for(Protein p:prots){
                            if(cmd==iSCRIPT_nt_sequence) p.setIntProperty(PROTEINI_MOL_TYPE,MOL_TYPE_FLAG_N);
                            if(cmd==iSCRIPT_nt_sequence && (aliType!=iSCRIPT_alignment_type_n&&
                                                            aliType!=iSCRIPT_alignment_type_N&&
                                                            aliType!=iSCRIPT_alignment_type_CN||
                                                            aliType==iSCRIPT_alignment_type_P||
                                                            fstKomma<lstKomma)){
                                {
                                    int cdsStart=fstKomma+1;
                                    {
                                        final int eq=strchr('=',A,fstKomma,lstKomma);
                                        if(eq>0) cdsStart=strchr(' ',A,eq,lstKomma);
                                    }
                                    if(createNew) p.setCharSequence(triplets2aa(true,seq,MAX_INT));
                                    final String cds=s(A,cdsStart,lstKomma);
                                    if(sze(cds)==0) p._flags|=PFLAG_NO_EXONS;
                                    else p._flags&=~PFLAG_NO_EXONS;
                                    p.projectNucleotides(seq,sze(cds)==0?"1..":cds);/*X FIXME see Strap_AlignmentWriter_Inc and rubber band selection*/
                                }
                                if(gapped!=null){
                                    final BA gg=new BA(gapped.length());
                                    for(int i=0,codon=0;i<gapped.length();i++){
                                        final char nt=gapped.charAt(i);
                                        if(nt=='-' && codon%3!=0) baOut(p).aa(RED_WARNING,i," codon=",codon,i).aln();
                                        if(nt=='-' || iThBool(nt,lettr) && codon++%3==2) gg.a(nt);
                                    }
                                    p.inferGapsFromGappedSequence(toByts(gg));
                                }
                            }else{
                                p.setResidueType(seq);
                                p.setExons(null,false);
                                if(gapped!=null) p.inferGapsFromGappedSequence(toByts(gapped));
                            }
                        }
                        strapSetSequenceIsInAlignment(CTRUE,prots);
                        EVT_NOW(EVT_SEQUENCE_ADDED);
                    }else iErr=SSCRIPT_MSG_WRONG_NUM_ARGS;
                }
            }else if(stxType==PARAMETER_PP_AA || stxType==ONLY_PP_AA){
                IF_GUI(final int mc=modic(strapSelectedObjectsV()));;
                if(sze(baObj)==0)iErr=SSCRIPT_MSG_EXPECT_RESANS;
                else if(cmd!=iSCRIPT_select_3D && stxType==PARAMETER_PP_AA && sze(para)==0)iErr=SSCRIPT_MSG_EXPECT_PARAMPETER;
                IF_GUI(else if(sze(baObj)==1 && '*'==chrAt(0,baObj) && cmd==iSCRIPT_unselect) clr(strapSelectedObjectsV());)
                else{
                    final Object[]pp_aa=_siProtsAndResansWithRegex(cmd,baObj,ppVis);
                    //if(iThBool(cmd,boolArry(RSC_SCRIPT_GROUP3D))){
                    if(0!=(stx&SCRIPT_OPT_3D)){
                        final String viewId=strM(STR_INTERN_VIEW3D,para);
                        final ResidueAnnotation[]aa=derefArry(pp_aa,ResidueAnnotation.class);
                        View3d pv=v3dForId(viewId),vv[]=v3dVV(pv);
                        final Protein[]pp;
                        if(sze(baObj)==0) pp=v3dPP(pv);
                        else{
                            final Collection vP=new ArrayList();
                            for(Object o:pp_aa) adUniq(sp(o),vP);
                            pp=spp(vP);
                        }
                        if(cmd==iSCRIPT_open_3D && pp.length>0){
                            final Protein[]pInf=new Protein[pp.length+22];
                            int count=0;
                            for(Protein p:pp) if(p.countRes()>0 && (hasXYZ(p)||p.getPdbID(PDBID_ANY_SIMILAR)!=null) && onlyOnceHC(323,p)) pInf[count++]=p;
                            if(count>0){
                                IF_GUI(threadGuiBG=thrdRRR(projectXYZ(RETURN_THREAD,pInf,ALIAS_PDB_ID_OF_SEQUENCE),thrdCR1(RUN_STRAP_SCRIPT,this,new BA(T,b,e))));;
                                UNLESS_GUI(projectXYZ(0,pInf,new String[]{ALIAS_PDB_ID_OF_SEQUENCE}));;
                            }
                            IF_GUI(if(count==0)){
                                final View3d pvNew=v3dOpen(V3D_OPEN_NOT_GENERATE_ID|V3D_OPEN_SEND_ALL_ANNOTATIONS,
                                                           pp,
                                                           IF_GUI(orO(pv,sclDefaultForInterface(INTRFC_View3d))) UNLESS_GUI(pv),
                                                           null);
                                IF_GUI(if(pvNew==null)iErr=SSCRIPT_MSG_FAILED_INSTANTIATE_V3D;else)
                                    {
                                        if(pv==null) V3D_MAP_ID_TO_VV.put(viewId,v3dSameViewV(pvNew));
                                        vv=v3dVV(pv=pvNew);
                                    }
                            }
                        }else if(cmd==iSCRIPT_select_3D||cmd==iSCRIPT_open_3D||cmd==iSCRIPT_add_to_3D){
                            _siV3dPP=pp;
                            _siV3dID=viewId;
                            if(!ARRAY_EMPTY(aa)) v3dApplyResSel(0,aa,vv,"Unnamed");
                            if(cmd==iSCRIPT_select_3D IF_DEACTIVATED(||cmd==iSCRIPT_open_3D)) v3dRecordGeneric(new BA(99).aa(iSCRIPT_select_3D,baArgs),v3dForId(viewId));
                        }
                        IF_GUI(if(cmd==iSCRIPT_close_3D) for(View3d v:vv) if(cntainsEl(sp(v),pp))dispos(v); else inEDTms(thread_v3dToFront(0,pv),99));;
                    }
                    if(cmd==iSCRIPT_print_mapped_residue_indices){
                        int count=0;
                        for(String s:splitTkns(baObj)){
                            if(s.indexOf('/')<1) continue;
                            final ResidueAnnotation[]ss=derefArry(objectsWithRegex(OBJRX_RESSEL|OBJRX_RESSEL_ANONYM,toBA(s),ppVis),ResidueAnnotation.class);
                            if(ss.length==0) continue;
                            count++;
                            for(Protein p:derefArry(pp_aa,Protein.class)){
                                print.aa(iConst(SARRAY_STRAP_SCRIPT_CMD,cmd),'\t',s,'\t',p,'/').aln(selectedPositionsToText(SELPOS2TXT_COMPACT_NO_SPC,resSelMapPosZ(ss,p),firstResIdx(p),p));
                            }
                        }
                        if(count==0)iErr=SSCRIPT_MSG_DEFAULT;
                    }
                    if(cmd==iSCRIPT_add_annotation||cmd==iSCRIPT_set_annotation){
                        final int eq=para.indexOf('=');
                        if(eq<0)iErr=SSCRIPT_MSG_DEFAULT;
                        else{
                            siAddAnno(cmd,para.substring(0,eq),para.substring(eq+1),pp_aa);
                            EVT_NOW(EVT_RESIDUE_SELECTION);
                        }
                    }
                    if(cmd==iSCRIPT_hide||cmd==iSCRIPT_unhide)  strapSetSequenceIsInAlignment(cmd==iSCRIPT_unhide?CTRUE:CFALSE,derefArry(pp_aa,Protein.class));
                    FORj(0,pp_aa.length){
                        final Object o=pp_aa[j];
                        final ResidueAnnotation a=derefResan(o);
                        final Protein p=derefProt(o);
#if CPP_WITH_GUI
                        if(cmd==iSCRIPT_select) strapSelectedObjectsV().add(o);
                        else if(cmd==iSCRIPT_unselect) strapSelectedObjectsV().remove(o);
                        else if(cmd==iSCRIPT_cursor) {if(a!=null) setCursorResidueIdx(sp(orO(p,a)),fstTrue(a.getSelectedAminoacids())+resSelAminoOffsetZ(a));}
                        else if(cmd==iSCRIPT_scroll_to) runCR1(RUN_ALIPANEL_SCROLL_TO_RECT_AND_FILL,aliPanel(),enclosingRectangle(pp_aa));
                        else if(cmd==iSCRIPT_box||cmd==iSCRIPT_ants) runCR1(RUN_ALIPANEL_SET_RUBBER_BAND,aliPanel(),enclosingRectangle(pp_aa));

#endif //CPP_WITH_GUI
                        else if(cmd==iSCRIPT_hide) runCR(RUN_SET_DISABLED,a);
                        else if(cmd==iSCRIPT_unhide) runCR(RUN_SET_ENABLED,a);
                        else if(cmd==iSCRIPT_bg_color){
                            baArgs.setEnd(lstKomma);
                            final BA txt=p.resnToIdxInTxt(baArgs);
                            final byte[]bb=txt.bytes();
                            tok().setText(txt);
                            final int[]nn=new int[p.countRes()];/*X offset=-firstResIdx(p)-1,*/
                            Arrays.fill(nn,INT_NAN);
                            while(_tok.nextToken()){
                                final int to=_tok.to(),eq=strchr('=',bb,_tok.from(),to);
                                if(eq<0 || to-eq!=8 || bb[eq+1]!='#'){
                                    if(onlyOnce(38)) baOut(RED_ERROR).aa(iSCRIPT_bg_color," ...").aFT(bb,_tok.from(),to).aln(" ...");
                                    continue;
                                }
                                CPP_synchronized(SYNC_PARSE_SET){
                                    parseSet(toknzr(345,SPACE_COMMA).setText(bb,_tok.from(),eq),0,nn.length);
                                    final boolean[]buf=parseSetGet(0,MAX_INT);
                                    final int rgb=hexToInt(bb,eq+2,to);
                                    ROFi0(nn.length) if(buf[i]) nn[i]=rgb;
                                }
                            }
                            p.setProperty(PROTEINO_RES_BG_COLOR,nn);
                            baArgs.setEnd(L);
                            EVT_NOW(EVT_AA_SHADING_CHANGED);
                        }else if(cmd==iSCRIPT_color){
                            final long rgb=chrAt(0,para)!='#'?-1: v3dRgbInScriptAt(1,para);
                            final Object c=IF_GUI("AUTO".equals(para)?v3dChain2color(j):)rgb!=-1?newColrA((int)rgb):null;
                            if(c!=null){
                                setColrO(c,p);
                                if(a!=null) {EVT_NOW(EVT_RESIDUE_SELECTION_COLOR); a.run(RUN_SET_COLOR,c);}
                            }else iErr=SSCRIPT_MSG_DEFAULT;
                        }else if(cmd==iSCRIPT_close||cmd==iSCRIPT_delete){
                            if(p!=null){strapRemoveProteins(IF_GUI(false,)p);EVT_NOW(EVT_SEQUENCE_REMOVED);}
                            if(a!=null){dispos(a);EVT_NOW(EVT_RESIDUE_SELECTION_DELETED);}
                        }else if(cmd==iSCRIPT_balloon_text){
                            if(p!=null) p.setBalloonText(para);
                            if(a!=null) a.annoAdd(RESAN_ENTRY_OVERRIDE|IRESAN_BALLOON,para);
                        }else if(cmd==iSCRIPT_icon){
                            if(para!=null){
                                final String s=IF_AA(orS(mapStrStr(MAPSTR_SCRIPT_INTERPRETER_IMAGES).get(para),para)) UNLESS_AA(para);
                                if(p!=null) {p.setSequenceIcon(s);EVT_NOW(EVT_SEQUENCE_RENAMED);}
                                IF_GUI(if(a!=null) a.annoAdd(IRESAN_BG_IMAGE,s));;
                                EVT_LATER(EVT_RESIDUE_SELECTION_COLOR);
                            }
                        }
                    }
                }
                IF_GUI(if(modic(strapSelectedObjectsV())!=mc) evt=EVT_OBJECTS_SELECTED);;
            }else if(cmd==iSCRIPT_new_aminoacid_selection||cmd==iSCRIPT_new_nucleotide_selection){
                tok().setText(A,lstKomma+1,L);
                final String resi=toStrgTrim(A,0,lstKomma);
                while(_tok.nextToken()){
                    final int slash=strchr('/',A,_tok.from(),_tok.to());
                    if(slash<0) continue;
                    final BA protein=new BA(A,_tok.from(),slash);
                    final String aName=s(A,slash+1,L);
                    for(Protein p:spp(_siProtsAndResansWithRegex(cmd,protein,ppVis))){
                        ResidueAnnotation a=null;
                        for(ResidueAnnotation s:p.residueAnnotations()) if(aName.equals(s.getName()) && resi.equals(s.value(IRESAN_POS))){a=s;break;}
                        if(a==null){a=new ResidueAnnotation(p);EVT_NOW(EVT_RESIDUE_SELECTION_ADDED);}
                        a.annoAdd((cmd==iSCRIPT_new_aminoacid_selection?0: RESAN_ENTRY_NT)|IRESAN_POS,resi)
                            .annoAdd(IRESAN_NAME,aName);
                        IF_GUI(a.setStyle(SSTYLE_LOWER_HALF));;
                        if(omittedPP!=null) a.annoAdd(IRESAN_GROUP,"Script");
                        addToProt(a,p);
                        _siResanLstCreated=new ResidueAnnotation[]{a};
                    }
                }
            }else if(stxType==PARAMETER_PP || stxType==PARAMETER_PARSE || stxType==ONLY_PP){
                final Protein[]pp=stxType==PARAMETER_PARSE||omittedPP!=null?omittedPP:spp(_siProtsAndResansWithRegex(cmd,baObj,ppVis));
                if(cmd==iSCRIPT_print_sequences){
                    if(sze(baObj)==0) print.a(iConst(SARRAYeq_SSCRIPT_MSG,SSCRIPT_MSG_NO_SEQS));
                    print.a(' ').joinSpc(pp.length>0?pp:ppAll);
                }else if(stxType==PARAMETER_PP && sze(para)==0){
                    iErr=SSCRIPT_MSG_EXPECT_PARAMPETER;
                }else if(sze(baObj)==0 && omittedPP==null){
                    iErr=SSCRIPT_MSG_EXPECT_SEQS;
                }else if(pp.length==0 && omittedPP==null){
                    if(ppVis.length==0)iErr=SSCRIPT_MSG_NO_SEQS;
                    else if(!(sze(baObj)==1 && '*'==chrAt(0,baObj)))iErr=SSCRIPT_MSG_NO_SUCH_SEQ;
                }else if(cmd==iSCRIPT_add_het){/* 3 tokens by space:    1.n32      2.num1:A,num2:A,num3:A...     3.Long name */
                    final int q=strchr('"'|STR_E,A,0,L);
                    final String n=q<0?null:toStrgTrim(A,q+1,L-1);
                    final Protein[]hh=new Protein[tokns(' ',A,0,q,SI_TOKEN_FT)];
                    ROFi0(hh.length){
                        final int f=SI_TOKEN_FT[i*2],t=SI_TOKEN_FT[i*2+1],colon=strchr(':',A,f,t),us=nxtBwd(chrClas(-DIGT),A,colon-1,f-1);
                        if(colon>0&&iThByte(us,A)=='_'&&isChrClas(DIGT,A,us+1)){
                            final Protein h=hh[i]=new Protein();
                            h.setIntProperty(PROTEINI_CHAINTYPE,CHAINTYPE_HET);
                            h.setChain(colon==t-1?null:wordAt(A,colon+1));
                            h.setResn(new int[]{atoi(A,us+1)},null);
                            h.setResidueName32(new int[]{charsToBitsSkipSpc(A,f,us)});
                            h.setName(s(A,f,t));
                            h.setProperty(P_TITLE,n);
                        }else{
                            siWarning().aa("Expected format like FAD_33:B or HEM_23:   ",colon,' ',us,isChrClas(DIGT,A,us+1)).an(' ',10).a("Token=").aFT(A,f,t).aln("<<<");
                        }
                    }
                    for(Protein p:pp)addToProt(hh,p);
                }
#if CPP_DEACTIVATED
                else if(cmd==iSCRIPT_set_molecule_type){
                    else for(Protein p:pp) p.setIntProperty(PROTEINI_MOL_TYPE,t);
#endif //CPP_DEACTIVATED
                    else if(cmd==iSCRIPT_change_order){
                        strapInferOrderOfProteins(SORT_ALL,pp);
                        strapInferOrderOfProteins(0,pp);
                    }else if(cmd==iSCRIPT_tax_group){
                        final Collection v=new ArrayList();
                        final String[]tt=splitTkns(para);
                        for(int i=tt.length;--i>=-1;){
                            clr(v);
                            for(Protein p:pp){
                                boolean hasTaxon=false;
                                ROFk0(4){
                                    final Object h=p.getProperty(k==0?P_TAXONOMY: k==1?P_ORGANISM_SC: k==2?P_ORGANISM_MNEMONIC: P_ORGANISM);
                                    if(h!=null){
                                        if(i<0) hasTaxon=true;
                                        else if(k==0?strstr(STR_IC|STR_w_L,tt[i],h)>=0: strEquAt(STR_IC,tt[i],h,0)) {v.add(p);break;}
                                    }
                                }
                                if(i<0 && !hasTaxon) v.add(p);
                            }
                            if(sze(v)>0) setSequenceGroup(false,addPfx("_",i<0?iConst(SARRAYeq_SSCRIPT_MSG,SSCRIPT_MSG_UNKNOWN_TAXONOMY):tt[i]),v);
                        }
                    }else if(cmd==iSCRIPT_sequence_group && sze(para)>0){
                        setSequenceGroup(false,para,pp);
                    }else if(cmd==iSCRIPT_biomt){
                        tok().setText(A,0,L).nextToken();
                        final int num=_tok.asInt();
                        if(num<1)iErr=SSCRIPT_MSG_DEFAULT;
                        _tok.nextToken();
                        final String[]chains=splitTkns('|',A,_tok.from(),_tok.to(),null);
                        if(chains.length==0)iErr=SSCRIPT_MSG_CHAINS;
                        Collection v=null;
                        while(_tok.nextToken()){
                            final Matrix3D m3d=new Matrix3D();
                            if(m3d.parseMatrixPlain(toknzr(346,'|').setText(A,_tok.from(),_tok.to()))) v=adNotNullNew(m3d,v);
                            else iErr=SSCRIPT_MSG_MX3D;
                        }
                        if(v!=null){
                            final Object[]neu=new Object[3];
                            neu[ASSEMBLY_ID]=io(num);
                            neu[ASSEMBLY_CHAINS]=chains;
                            neu[ASSEMBLY_MATRICES]=toArry(v,Matrix3D.NONE);
                            for(Protein p:pp) p.setProperty(PROTEINO_BIOMT,adToArry(0,neu,(Object[][])p.getProperty(PROTEINO_BIOMT),Object[].class));
                        }
                    }else{
                        for(Protein p:pp){
                            final int nR=p.countRes();
                            if(cmd==iSCRIPT_taxonomy) p.setProperty(P_TAXONOMY,para);
                            else if(cmd==iSCRIPT_set_OS) p.setProperty(P_ORGANISM_SC,para);
                            else if(cmd==iSCRIPT_set_DE) p.setProperty(P_COMPOUND,para);
                            else if(cmd==iSCRIPT_set_TI) p.setProperty(P_TITLE,para);
                            else if(cmd==iSCRIPT_set_EC) p.setProperty(PROTEINO_EC,splitTkns(para));
                            else if(cmd==iSCRIPT_taxid) p.setIntProperty(PROTEINI_TAXID,xatoi(para));
                            else if(cmd==iSCRIPT_all_chains) p.setChainsByType(chainsByTypeFromText(baArgs));
                            else if(cmd==iSCRIPT_xyzAlpha) p.setResidueCalphaXYZ(newByts(A,0,L));
                            else if(cmd==iSCRIPT_xyz) p.parseXYZ(A,L);
                            else if(cmd==iSCRIPT_res_name){
                                tok().setText(A,0,fstKomma);
                                int[]n32=p.getResidueName32();
                                while(_tok.nextToken()){
                                    final int f=_tok.from(),t=_tok.to(),i=atoi(A,f),eq=strchr('=',A,f,t);
                                    if(i<0||i>=nR||eq<0)siWarning().aPlrl(nR-1,iConst(SARRAYeq_SSCRIPT_MSG,eq<0?SSCRIPT_MSG_EXPECT_EQ:SSCRIPT_MSG_RES_IDX_OUT_OF_RANGE)).a(" in\"").aFT(T,f,t).aln("\".");
                                    else{
                                        if(n32==null)n32=new int[nR];
                                        n32[i]=charsToBitsSkipSpc(A,eq+1,eq+1-t);
                                    }
                                }
                                p.setResidueName32(n32);
                            }else if(cmd==iSCRIPT_print_fasta||cmd==iSCRIPT_print_pdb && p.isProteinStructure()){
                                print.an('#',3).a(p).an('#',3).aln().join0(strapInstance(cmd==iSCRIPT_print_pdb?SEQWRITER_PDB:SEQWRITER_FA).getProteinText(SEQW_COMPLETE_PDB,p,null,null,null));
                            }else if(cmd==iSCRIPT_set_residue_index_offset){
                                p.setIndexOffsetAA(xatoi(para));
                                EVT_NOW(EVT_RESIDUE_SELECTION);
                            }else if(cmd==iSCRIPT_set_nucleotide_index_offset){
                                p.setIndexOffsetNT(xatoi(para));
                                EVT_NOW(EVT_RESIDUE_SELECTION);
                            }else if(cmd==iSCRIPT_gaps){
                                p.inferGapsFromGappedSequence(toByts(para));
                                EVT_LATER(EVT_ALIGNMENT);
                            }else if(cmd==iSCRIPT_chain){
                                p.setChain(para);
                            }else if(cmd==iSCRIPT_res_secstru_90){
                                final BA sb=baClr(135);
                                for(int i=0,base91[]=charcodeToBase90();i<L-1; i+=2) sb.an((char)A[i+1],iThInt(A[i],base91));
                                p.setResidueSecStrType(sb.newBytes());
                            }else if(cmd==iSCRIPT_res_num||cmd==iSCRIPT_res_chain||cmd==iSCRIPT_res_ins||cmd==iSCRIPT_res_secstru){
                                tok().setText(A,0,fstKomma);
                                if(cmd==iSCRIPT_res_num){
                                    final int[]nn=new int[nR];
                                    parseSeriesN(1,_tok,nn);
                                    p.setResn(nn,NO_byte);
                                }else{
                                    final byte[]cc;
                                    if(strchr('=',A,0,fstKomma)<0) cc=newByts(A,0,fstKomma);
                                    else parseSeriesN(INT_NAN,_tok,cc=new byte[nR]);
                                    if(cmd==iSCRIPT_res_chain && isChrClas(LETTR_DIGT,cc,0)) p.setChain(s((char)cc[0]));/*X obsolete*/
                                    if(cmd==iSCRIPT_res_ins) p.setResn(NO_int,cc);
                                    if(cmd==iSCRIPT_res_secstru) p.setResidueSecStrType(cc);
                                }
                            }else if(cmd==iSCRIPT_cds){
                                if(strstr(0,"..",para)>0 || nxt(0,chrClas(LETTR),para)>=0) p.setCDS(para);
                                // else if(cntainsOnly("0123456789 -,",para,0,MAX_INT)){
                                else if(0>nxt(0,chrClas(-DIGT_DASH_SPC_COMMA),para,0,MAX_INT)){
                                    final String n=p.getName();
                                    final boolean[]bb=parseSetStrg(para,-1,p.countCDS());
                                    FORi(0,mini(bb.length,p.countCDS())){
                                        if(bb[i]){
                                            final Protein p1=new Protein();
                                            p1.setProperty(PROTEINO_ALIGNMENT,_main);
                                            IF_GUI(if(strEquAt(0,"cds ",T,b)) p1.setName(n); else);;
                                            p1.setName(delLstCmpnt('!',n)+'_'+(i+1)+lstCmpnt('!',n));
                                            p1.setCharSequence(p.getCharSequence());
                                            p1.addCDS(p.getCDS(i));
                                            p1.setFile(p.getFile());
                                            p1.addSeqRef(ADD_SEQREF_ACC,p.seqId(GETSEQID_ACCESSION));
                                            p1.setIntProperty(PROTEINI_MOL_TYPE,p.getIntProperty(PROTEINI_MOL_TYPE));
                                            if(p1.applyCDS(0)) strapSetSequenceIsInAlignment(CTRUE,p1);
                                            if(p.isSubset()) p1.setSubset((p.subsetStart()+1)+"-"+p.subsetEnd());
                                        }
                                    }
                                    strapRemoveProteins(IF_GUI(false,)p);
                                    EVT_LATER(EVT_SEQUENCE_REMOVED);
                                }else iErr=SSCRIPT_MSG_DEFAULT;
                                EVT_NOW(EVT_NUCL_TRANSLATION);
                            }else if(cmd==iSCRIPT_rotate_translate||cmd==iSCRIPT_rotate_translate_complex){
                                final Protein[]ppMatrix= spp(objectsWithRegex(0,para,ppAll));
                                final Matrix3D m3d=isNull(para)?null:ppMatrix.length==1?ppMatrix[0].getRotationAndTranslation(): new Matrix3D();
                                if(isNull(para) || ppMatrix.length==1 || m3d.parseMatrixPlain(toByts(para),0,MAX_INT)){
                                    p.setRotationAndTranslation(m3d);
                                    if(cmd==iSCRIPT_rotate_translate_complex) for(Protein p2:p.getProteinsSameComplex()) p2.setRotationAndTranslation(m3d);
                                    EVT_NOW(EVT_PROTEIN_3D_MOVED);
                                }else iErr=SSCRIPT_MSG_DEFAULT;
                            }else if(cmd==iSCRIPT_xref||cmd==iSCRIPT_AC||cmd==iSCRIPT_remove_xref){
                                for(String id:splitTkns(para)){
                                    if(cmd==iSCRIPT_remove_xref) p.removeSequenceRef(id);
                                    else if(cmd==iSCRIPT_AC) p.addSeqRef(ADD_SEQREF_ACC,id);
                                    else if(cmd==iSCRIPT_xref) p.addSeqRef(0,id);
                                    if(id.indexOf(':')<0)iErr=SSCRIPT_MSG_DEFAULT;
                                    EVT_LATER(EVT_SEQUENCE_XREF);
                                }
                            }else if(cmd==iSCRIPT_print_selections){
                                print.aa(p,"\t");
                                for(ResidueSelection s:p.resSel(SOBJECT_RESSEL_AND_RESAN)){
                                    print.a(nam(s)).a('=').boolToText(s.getSelectedAminoacids(),s.getSelectedAminoacidsOffset()+1,",","-").a(' ');
                                }
                                print.a('\n');
                            }else if(cmd==iSCRIPT_print_3D_transformation){
                                print.aa(p,"\t");
                                final Matrix3D m3d=p.getRotationAndTranslation();
                                if(m3d==null) print.aln("NULL");
                                else m3d.toText(MTRX_FORMAT_PLAIN,"",print).a('\n');
                            }else{
#if CPP_WITH_GUI
                                if(cmd==iSCRIPT_to_row||cmd==iSCRIPT_below_row){
                                    final AliPanel v=aliPanel();
                                    if(v!=null){
                                        final int src=idxOf(p,ppVis);
                                        final Object[]ppDest=objectsWithRegex(0,para,ppVis);
                                        int dst=0>nxt(0,chrClas(-DIGT),para)?xatoi(para)-1: idxOf(iThEl(0,ppDest),ppVis);
                                        if(ppDest.length>0 && dst>src) dst--;
                                        if(dst>=0){
                                            if(cmd==iSCRIPT_below_row) dst++;
                                            if(src>=0 && dst>=0 && src!=dst) v.moveLines(src,mini(sze(v.vROWS)-1,dst),1);
                                            EVT_NOW(EVT_SEQUENCE_ORDER);
                                        }else iErr=SSCRIPT_MSG_DEFAULT;
                                    }
                                }else if(cmd==iSCRIPT_set_similar_pdb){
                                    p.setPdbID(PDBID_SUGGESTED,para);
                                }else if(cmd==iSCRIPT_put_property){
                                    final int eq=para.indexOf('=');
                                    final String val=para.substring(eq+1);
                                    pcp((eq>0?para.substring(0,eq):para),isNull(val)?null:val,p);
                                }else if(cmd==iSCRIPT_close_wire){
                                    final View3d[]vv0=p.get3dViews(),vv=new View3d[vv0.length];
                                    ROFi0(vv.length) if(vv0[i] instanceof Simple3D) vv[i]=vv0[i];
                                    dispos(vv);
                                }else if(cmd==iSCRIPT_define_complex){
                                    p.setProteinsSameComplex(pp);
                                }
#endif //CPP_WITH_GUI
                            }
                        }/*X for p*/
                        if(cmd==iSCRIPT_find_uniprot_id){
/*!FIXME was ist mit ExactMatch */
                            IF_GUI(threadGuiBG=blast4id(RETURN_THREAD|(BLAST4ID_DB_UNIPROT<<BLAST4ID_DB_SHIFT)|
                                                        (strstr(STR_w,"--ALL",baObj)>=0?BLAST4ID_EVEN_IF_HAS_ID:0),
                                                        pp,null));;
                            IF_GUI(timeOutMS=findupEstimatedTime(pp));;
                        }else if(cmd==iSCRIPT_project_XYZ){
                            for(Protein p:pp) p.detach3DStructure();
                            if(!isNull(para) && pp.length>0){
#define pdbIds para.replaceAll("( |^)--\\w+","").trim()
                                IF_GUI(threadBG=projectXYZ(RETURN_THREAD|INFER3D_IF_NOT_ALREADY,pp,pdbIds));;
                                UNLESS_GUI(projectXYZ(INFER3D_IF_NOT_ALREADY,pp,new String[]{pdbIds}));;
#undef pdbIds
                            } IF_GUI(else EVT_LATER(EVT_RESIDUE_SELECTION_DELETED));;
                        }else if(cmd==iSCRIPT_set_ruler_secondary_structure){
                            for(Protein p:pp){
                                if(p.getResidueSecStrType()!=null){
                                    IF_GUI(runCR1(RUN_ALIPANEL_SET_SECSTRU_P,aliPanel(),p));
                                    IF_GUI(SI_VALUES[cmd]=wref(p));;
                                    UNLESS_GUI(SI_VALUES[cmd]=p);;
                                    break;
                                }
                            }
#if CPP_WITH_DAS
                        }else if(cmd==iSCRIPT_das){
                            if(pp.length>0){
                                IF_GUI(threadGuiBG=)sftrStartThreads(SEQFEAT_NOT_SEARCH_ID,splitTkns(para),pp);;
                                IF_GUI(timeOutMS=1000*60*10);;
                            }
                        }else if(cmd==iSCRIPT_das_check){
                            for(String t:splitTkns(para)) StrapDAS.loadDas(RETURN_THREAD|SEQFEAT_OPT_CHECK_AVAILABILITY_ONLY,t,pp,null);
#endif //CPP_WITH_DAS
                        }else if(cmd==iSCRIPT_gff_uniprot){
                            IF_GUI(threadGuiBG=)sftrStartThreads(SEQFEAT_NOT_SEARCH_ID|SEQFEAT_SRC_UNIPROT,IF_DAS(null,)pp);;
                            IF_GUI(timeOutMS=1000*60*3);;
                        }else if(cmd==iSCRIPT_CSA){
                            IF_GUI(threadGuiBG=)sftrStartThreads(SEQFEAT_NOT_SEARCH_ID|SEQFEAT_SRC_CSA,IF_DAS(null,)pp);;
                            IF_GUI(timeOutMS=1000*60);;
                        }else if(cmd==iSCRIPT_align){
                            boolean gappedMSF=false,noMsf=false,gap=false;
                            Collection vMsf=null;
                            if(strstr(STR_w,"--IF_UNGAPPED",baArgs)>=0){
                                for(Protein p:pp){
                                    final boolean isMsf=(p._flags&PFLAG_IS_IN_MSF)!=0 IF_AA(&& !strEnds("/"+DIRNAME_PARA+"/"+PARA_sequences,p.getFile()));
                                    if(isMsf) vMsf=adUniqNew(p.getGappedSequence(true),vMsf);
                                    else noMsf=true;
                                    if(p.getResColumnMax()+1!=p.countRes()){
                                        if(isMsf) gappedMSF=true;
                                        gap=true;
                                    }
                                }
                            }
                            if(gappedMSF && noMsf){
                                final SequenceAligner a=(SequenceAligner)mkInstanceBid(BUT_C1(ClustalW));
                                runCR1(RUN_ALIGN_ADD_PROFILE,a,toArry(vMsf,byte[].class));
                                new AcceptAlignment2(pp,0,(byte[][])iThEl(ALIGNRESULT_GAPPED,a.computeAlignment(0,pp)));
                                CPP_GUI_CACHE_SAVE();
                            }else if(!gap){
                                for(Protein p:pp) if(p.getProperty(PROTEINO_PARSER) instanceof Strap) p.xyzByID(false);
                                IF_GUI(threadGuiBG=)alignProteins(RETURN_THREAD|(strstr(STR_w,"--CHANGE_ORDER",baArgs)>=0?ALIGN_CHANGE_ORDER: 0),null,pp IF_GUI(,null));;
                            }
/* http://localhost/aa/aa.php?sid=x2015_02_04_181751Rba8b */
                        }else if(cmd==iSCRIPT_superimpose||cmd==iSCRIPT_superimpose_complex){
                            IF_GUI(threadGuiBG=)superimposeProteins(RETURN_THREAD|SUPERIMP_EVENT|(cmd==iSCRIPT_superimpose_complex?SUPERIMP_COMPLEX_BEST:0),pp IF_GUI(,null));;
                        }else{
#if CPP_WITH_GUI
                            if(cmd==iSCRIPT_wire) webAlignment3D(true,pp,null);
                            else if(cmd==iSCRIPT_jalview) jalviewLaunch(JALVIEW_SECSTRU,pp,null);
                            else if(cmd==iSCRIPT_download_files){
                                threadBG=thrdRRR(sftrStartThreads(SEQFEAT_SRC_UNIPROT,IF_DAS(null,)pp),projectXYZ(RETURN_THREAD|INFER3D_IF_NOT_ALREADY|INFER3D_NO_BLAST,pp,"AUTO"));
                            }else if(cmd==iSCRIPT_tree){
                                if(noDuplicateNames(pp).length<3)iErr=SSCRIPT_MSG_DEFAULT;
                                else{
                                    displayPhylogeneticTree(null,noDuplicateNames(pp),0,MAX_INT,null);
                                    wndw(WNDW_DO_FRONT|(333<<WNDW_SHIFT_MS),title(BUT_C1(DialogDendrogram)));
                                }
                            }
#endif //CPP_WITH_GUI
                        }
                    }
                }else if(SCRIPT_SYNTAX_V3D==(stx&SCRIPT_SYNTAX_MASK)){
                    //iV3DCMD_AAA
                    final View3d[]vv=v3dToArry((Collection)V3D_MAP_ID_TO_VV.get(_siV3dID));
                    final Collection vViews=new ArrayList();
                    for(Object prot:oo(_siV3dPP)){
                        if(prot==null) continue;
                        for(View3d v:((Protein)prot).get3dViews()){
                            if("*"==_siV3dID||IF_GUI(strstr(STR_w,_siV3dID,"$ANY_VIEWER")>=0 || v instanceof Simple3D&&strstr(STR_w,_siV3dID,"$ANY_WIRE")>=0||)
                               cntainsEl(v,vv) && idxOf(prot,_siV3dPP)>=0){
                                vViews.add(v);
                            }
                        }
                    }
                    if(sze(vViews)>0) v3dSendCommand2(new BA(99).aa(iConst(SARRAY_STRAP_SCRIPT_CMD,cmd),' ',baArgs),v3dToArry(vViews));
                    else iErr=SSCRIPT_MSG_NO_SUCH_V3D;
#if CPP_WITH_GUI
                }else if(cmd==iSCRIPT_src){
                    final ChTokenizer tokArgs=new ChTokenizer(',').setText(baArgs);
                    if(tokArgs.nextToken()){
                        final String cn=tokArgs.asString().trim();
                        try{Class.forName(cn);}catch(Exception ex){iErr=SSCRIPT_MSG_FAILED_CLASS_FORNAME; putln(ex);}
                        showJavaSrc(cn);
                    }
#endif //CPP_WITH_GUI
                }else{
                    iErr=SSCRIPT_MSG_CMD_NOT_PROCESSED;
                }
                if(sze(print)>0){
                    baLog(LOG_SCRIPT_INTERPRETER).aa("#"+ANSI_BOLD+"BEGIN ",iConst(SARRAY_STRAP_SCRIPT_CMD,cmd)).trim().aa(ANSI_RESET,'\n',print).a1('\n').aa("#"+ANSI_BOLD+"END ",iConst(SARRAY_STRAP_SCRIPT_CMD,cmd),ANSI_RESET).delBlanksR().a("\n\n");
                    baOut("\n"+ANSI_BOLD+"SCRIPT> ").aln(print);
                }
            } finally{
#if CPP_WITH_GUI
                if(evt>=0) strapEvtDispatch(evt);
                if(evtLater>=0) strapEvtDispatch(evtLater|SEVTMS*111);
#undef EVT_LATER
#undef EVT_NOW
#endif //CPP_WITH_GUI
                if(iErr!=0 || sze(siWarning())>0){
                    Object error=iErr==SSCRIPT_MSG_DEFAULT?iConst(SARRAYeq_StrapScriptInterpreter_Errors,cmd):iConst(SARRAYeq_SSCRIPT_MSG,iErr);
                    if(iErr==SSCRIPT_MSG_EXEMPLE_URL_ALIAS||iErr==SSCRIPT_MSG_EXPECT_FEATURE_COLORS||cmd==iSCRIPT_add_annotation)  error=s(error).replace('~','=').replace('|','/');
                    if(iErr==SSCRIPT_MSG_EXPECT_COLOR_SCHEME) error=new BA(99).a(error).joinSpc(arry(SARRAY_RESCOLOR_TYPES));
                    final BA sb=new BA(222)
                        .aa(error,' ',siWarning()," >")
                        .and(iErr==SSCRIPT_MSG_NO_SUCH_SEQ?baArgs:null," ")
                        .aFT(T,b,e).a('<').aln();
                    IF_GUI(baLog(LOG_SCRIPT_INTERPRETER).aa('\n',iErr!=0?RED_ERROR:RED_WARNING,sb));;
                    baOut(ANSI_MAGENTA).a("SCRIPT>"+ANSI_RESET+" ").aln(sb);
                }
                if(idxOf(ALIAS_SEND_TO_STDOUT,baLog(LOG_SCRIPT_INTERPRETER).getSendTo())>=0 && baLog(LOG_SCRIPT_INTERPRETER).end()!=logEnd) baLog(LOG_SCRIPT_INTERPRETER).send();
                if(threadBG!=null){
                    IF_GUI(threadGuiBG=threadBG);;
                    UNLESS_GUI(threadBG.run());;
                }
#if CPP_WITH_GUI
                if(threadGuiBG!=null){
                    if(timeOutMS>0) threadGuiBG=thrdCountDownWait(999,timeOutMS,(CountDown)threadGuiBG);
                    if(sze(jobId)>0){
                        _siVJobsKeep=adNotNullNew(jobId,_siVJobsKeep);
                        threadGuiBG=thrdRRR(threadGuiBG,thrdRmElmntFromV(jobId,_siVJobs=adNotNullNew(jobId,_siVJobs)));
                    }
                    startThrd(thrdRRR(threadGuiBG,thrdCR1(RUN_STRAP_SCRIPT,this,new BA(T,e+1,script.end()))));
                    break;
                }
#endif //CPP_WITH_GUI
            }
            IF_GUI(if(0==(opt&STRAPSCRIPT_NOT_FRAME_TO_FRONT)) wndw(WNDW_NATIVE|WNDW_DO_FRONT|WNDW_MAIN_WINDOW,null));;
        }
        baLog(LOG_SCRIPT_INTERPRETER).send();
    }
/* <<< Interpret  <<< */
/* ---------------------------------------- */
/* >>> Jobs >>> */
#if CPP_WITH_GUI
    REFLECTION_PUBLIC_VOID siWaitJobBG(String[]jj){/*X Script_interpreter */
        while(sze(_siVJobs)>0){
            sleepMS(111);
            boolean running=false;
            for(Object s:jj) if(cntainsEl(s,_siVJobs)) {running=true;break;}
            if(!running) break;
        }
        REFLECTION_RETURN;
    }
#endif //CPP_WITH_GUI
/* <<< Jobs  <<< */
/* ---------------------------------------- */
/* >>> Script File >>> */
    private static int IF_GUI(_siScriptFilesSkip,)_siScriptFilesN;
#if CPP_WITH_GUI
    REFLECTION_PUBLIC_VOID observeScriptFileBG(){
        if(_siScriptFilesSkip>=0 && _siScriptFilesSkip++%5!=0) REFLECTION_RETURN;
        ROFi0(_siScriptFilesN){
            final File f=_siScriptFilesF[i];
            final int s=sze(f),prev=_siScriptFilesS[i];
            if(s<=prev) continue;
            RandomAccessFile fp=null;
            try{
                fp=new RandomAccessFile(f,"r");
                fp.seek(prev);
                final byte[]bb=new byte[s-prev];
                fp.readFully(bb,0,bb.length);
                final int end=strchrBwd('\n',bb,bb.length,-1);
                if(end>=0){
                    thrdCR1(RUN_STRAP_SCRIPT|THRDCR_EDT_LATER,null,new BA(bb,0,end+1));
                    _siScriptFilesS[i]+=end+1;
                    _siScriptFilesSkip=-1;/*X  from now on observe file more often */
                }
            }catch(IOException iox){
                _siScriptFilesS[i]=s;
                errorEx(iox,iConst(SARRAYeq_SSCRIPT_MSG,SSCRIPT_MSG_observeScriptFileBG),f);
            } finally{
                closeStrm(fp);
            }
        }
        REFLECTION_RETURN;
    }
#endif //CPP_WITH_GUI
    static BA siConcat(IF_GUI(boolean showHtml,boolean debug_Unused,)Object[]scriptOrUrl){
        final int N=sze(scriptOrUrl);
        final BA[]su=new BA[N];
        int len=N;
        FORi(0,N){
            BA s=toBA(scriptOrUrl[i]);
            if(0<sze(s)){
                File f=null;
                String u=null;

                if((looks(LIKE_EXTURL,s.rmFirstLastChar('"','"').trim())) && (u=s(url(s)))!=null){
                    s=readBytes(inStrm(INSTREAM_DECOMPRESS|(99<<INSTREAM_SHIFT_TIMEOUT),u));
                }else if(nxt(0,chrClas(SPC),s)<0 && null!=(f=file(NEWFILE_NO_ERROR,s))){
#if CPP_WITH_GUI
                    if(isNamedPipe(f)){
                        thrdCR1(RUN_STRAP_NAMED_PIPE|THRDCR_START,newScriptInterpreter(),f);
                        return null;
                    }else if(fileExsts(f)){
#endif //CPP_WITH_GUI
                        s=readBytes(f);
                        if(_siScriptFilesN<_siScriptFilesF.length){
                            _siScriptFilesF[_siScriptFilesN]=f;
                            _siScriptFilesS[_siScriptFilesN++]=sze(f);
                        }
                    }else f=null;
                }
                if(u!=null||f!=null) baLog(LOG_SCRIPT_INTERPRETER).a("Read ").or(u,f).a(' ').formatSize(sze(s)).a('\n');
            }
            if((su[i]=s)!=null) len+=s.length();
        }
        IF_GUI(if(_siScriptFilesN>0) callPeriodically(999,CPP_thrdM(observeScriptFileBG,newScriptInterpreter())));;
        ROFi0(N){
            final BA html=su[i];
            final boolean xml=strEquAt(STR_w,"<?xml",html,nxt(0,chrClas(-SPC),html));
            if(xml||looks(LIKE_HTML,html)){
#if CPP_WITH_GUI
                if(showHtml){
                    IF_MEIN_DEBUG(if(debug_Unused) _awtModifiers=CTRL_MASK);;
                    if(xml) thrdCR1(RUN_SHOW_HTML_WITH_SCRIPT_XML|THRDCR_EDT_LATER,_main,html);
                    else thrdCR1(RUN_SHOW_HTML_WITH_SCRIPT|THRDCR_EDT_LATER,_main,html);
                }
#endif //CPP_WITH_GUI
                final int saveB=html.begin(),saveE=html.end();
                (su[i]=new BA(0).aFilter(FILTER_HTML_DECODE,html.insidePreTags("strap_script"))).trimSize();
                html.setBegin(saveB);
                html.setEnd(saveE);
            }
        }
        final BA script=N==1?su[0]: new BA(len);
        for(int i=0; N!=1 && i<N;i++)script.aln(su[i]);
        baLog(LOG_SCRIPT_INTERPRETER).send();
        return script;
    }
/* <<< Script File <<< */
/* ---------------------------------------- */
/* >>> ResidueSelection >>> */
    private static void siAddAnno(int cmd,String k,String value,Object[]aa){
        for(Object o:aa){
            final ResidueAnnotation a=derefResan(o);
            if(a!=null){
                if(KRESAN_COLOR.equalsIgnoreCase(k)) setColrO(str2color(value,0),a);
                else{
                    if(cmd==iSCRIPT_add_annotation) a.addE(0,k,value);
                    else a.addE(RESAN_ENTRY_OVERRIDE,k,isNull(value)?null:value);
                }
            }
        }
    }
    private Object[]_siProtsAndResansWithRegex(int cmd,BA baObj,Protein[]pp){
        if(sze(baObj)==1){
            final char c=baObj.charAt(0);
            if(_siParsePP!=null && c=='P') return _siParsePP;
            if(c=='~') return _siResanLstCreated;
        }
        final int opt=cmd==iSCRIPT_scroll_to||cmd==iSCRIPT_box||cmd==iSCRIPT_ants||cmd==iSCRIPT_cursor?OBJRX_RESSEL_ANONYM:
            cmd==iSCRIPT_open_3D? (OBJRX_EXTRA_PP_CREATE|OBJRX_RESSEL_ANONYM|OBJRX_WARN):
            //iThBool(cmd,boolArry(RSC_SCRIPT_GROUP3D))
            0!=(iThInt(cmd,intArry(SARRAY_STRAP_SCRIPT_OPT))&SCRIPT_OPT_3D)?(OBJRX_RESSEL|OBJRX_EXTRA_PP|OBJRX_RESSEL_ANONYM|OBJRX_WARN):
            OBJRX_RESSEL;
#if CPP_WITH_GUI
        if(cmd==iSCRIPT_das_check IF_DAS(||cmd==iSCRIPT_das)||cmd==iSCRIPT_gff_uniprot||cmd==iSCRIPT_CSA||cmd==iSCRIPT_project_XYZ){
            for(int count=0,i=pp.length;--i>=0;){
                final Protein p=pp[i];
                if(p!=null && (p.onlyActgn() || (p.getIntProperty(PROTEINI_MOL_TYPE)&MOL_TYPE_FLAG_N)!=0)){
                    if(count++==0) pp=pp.clone();
                    pp[i]=null;
                }
            }
            pp=rmNullPP(pp);
        }
#endif //CPP_WITH_GUI
        return objectsWithRegex(opt,baObj,pp);
    }
/* <<< ResidueAnnotation  <<< */
/* ---------------------------------------- */
/* >>>  >>> */
/*  static Protein[]siNewHets(byte[]A,int[]ft,String defaultChain,Protein pOrNull){ */
/*     final int[]n32=new int[]{charsToBitsSkipSpc(A,ft[0],ft[1]-ft[2*0])}; */
/*     final String n=s(A,ft[4],ft[5]); */
/*     final Protein[]hh=new Protein[tokns(' ',A,ft[2],ft[3],ft)]; */
/*     IF_MEIN_DEBUG(int countNew=0);; */
/*     ROFi0(hh.length){ */
/*         final int f=ft[2*i],t=ft[1+2*i],colon=strchr(':',A,f,t),resn=atoi(A,f); */
/*         char ins=chrAt((colon>0?colon:t)-1,A); */
/*         if(!IS_UPPER(ins))ins=0; */
/*         final String chain=colon<0?defaultChain: colon+1==t?"_": pdbChainAt(A,colon+1,t); */
/*         if(pOrNull!=null && null!=(hh[i]=pOrNull.hetWithNumInsName(n32[0],resn,ins,chain))) continue; */
/*         IF_MEIN_DEBUG(countNew++);; */
/*         final Protein h=hh[i]=new Protein(); */
/*         h.setIntProperty(PROTEINI_CHAINTYPE,CHAINTYPE_HET); */
/*         h.setProperty(P_TITLE,n); */
/*         h.setName(s(baClr(VCLR_NUMBERS).aBytes(h.getResidueName32()[0]).a('_').a(h.resnAt(0,0)))); */
/*         h.setResidueName32(n32); */
/*         h.setResn(new int[]{resn},ins!=0?new byte[]{(byte)ins}:null); */
/*         h.setChain(chain); */
/*     } */
/*     IF_MEIN_DEBUG(if(pOrNull!=null&&hh.length>0 && countNew>0) baOut(DEBUG_LONGER).aPlrl(hh.length," siNewHets hh=%n countNew=").a(countNew).aln());; */
/*     return hh; */
/* } */
/* <<< Static utility <<< */
/* ---------------------------------------- */
/* >>> Script_interpreter Alignment Annotatator >>> */
/* If text consists only of references,then load proteins. */
/* Limitations relevant for GUI commands: is Blocking  */
    private static Protein[]siPpFromReferences(BA txt){/*X Also CPP_WITH_GUI*/
        final ChTokenizer tok=new ChTokenizer(SPC);
        Collection v=null;
        final byte[]T=txt.bytes();
        final int ee[]=txt.eol();
        FORiL(0,ee.length){
            final int b=nxt(chrClas(-SPC),T,iL==0?txt.begin():ee[iL-1]+1,ee[iL]);
            if(b<0 || T[b]=='#') continue;
            tok.setText(T,b,ee[iL]);
            while(tok.nextToken()){
                final int f=tok.from(),colon=strchr(':',T,f,tok.to());
                //  && cntainsOnly(LETTR_DIGT_US_COLON,T,f,colon)))
                if(strEquAt(0,"http://",T,f) || colon>f+1 && isChrClas(UPPR,T,f) && 0>nxt(chrClas(-LETTR_DIGT_US_COLON),T,f,colon)) v=adUniqNew(tok.asString(),v);
                else{
                    //  baOut(RED_WARNING).aln("Malformed sequence reference \"").a(T,f,t).aln("\".  Expecting URL or DB-colon-entry.");
                    return Protein.NONE;
                }
            }
        }
        if(v==null) return Protein.NONE;
        Collection<Protein>vP=new ArrayList();
        downloadProteins(LOADP_PROCESS_LOADED_P,toStrgArray(0,v),vP IF_GUI(,null,oo(ALIAS_TARGET_ALIPANEL)));
        return spp(vP);
    }
#define SEP "#AA_NEXT"
    private static Protein[]siAaLoadSequences(BA txt){/*X Also CPP_WITH_GUI*/
        final byte[]T=txt.bytes();
        String name=null;
        Collection v=null;
        for(int ee[]=txt.eol(),B=txt.begin(),start=B,iL=0,L=ee.length;iL<=L;iL++){
            final int b=iL==0?B: iL==L?txt.end(): ee[iL-1]+1;
            final boolean isStart=iL!=L && ee[iL]-b>=CPP_STRLEN(SEP) && T[b]=='#' && strEquAt(STR_w_R,SEP,T,b);
            if((iL==L || isStart) && nxt(chrClas(-SPC),T,start,b)>=0){
                final BA part=B==start && iL==L?txt: new BA(T,start,b).trim();
                if(siPpFromReferences(part).length==0){
                    for(Protein p:readAddToPep(null,readPepOrNuc(0,null,part))){
                        v=adNotNullNew(p,v);
                        if(p.getName()==UNNAMED&&name==null && p.seqId(GETSEQID_ACCESSION)!=null) p.setName(delToLstChr1(':',p.seqId(GETSEQID_ACCESSION)));
                    }
                }
            }
            if(isStart){
                start=ee[iL]+1;
                name=wordAt(T,nxt(0,chrClas(-SPC),T,b+CPP_STRLEN(SEP),ee[iL]));
            }
        }
        final Protein[]pp=spp(v);
        for(Protein p:pp) p.setProperty(PROTEINO_ALIGNMENT,_main);/*X  muss nach leadingAndTrailingLowerCaseLettersInMSA */
        strapAddProteins(IF_GUI(0,)pp);
        return pp;
    }
#undef SEP
#if CPP_PRG_AA
    private static void siAaReadUploadedSequences(File file,String dir){
        final ChInStream cis=new ChInStream(file,555);
        final BA LINE=new BA(555),tmp=new BA(99),err=new BA(99);
        final int[]TABS=new int[UL_NUM_FIELDS+1];
        while(cis.readLine(clr(LINE))){
            final byte[]T=LINE.bytes();
            final int E=LINE.end();
            if(tabulatrs('\t',T,0,E,TABS)<1 || isTrue(LINE.csvGetFieldTrim(UL_FIELD_HIDE,TABS))) continue;
            final String
                nam=LINE.csvGetFieldTrim(UL_FIELD_NAM,TABS),
                ref=LINE.csvGetFieldTrim(UL_FIELD_DBREF,TABS),
                md5=LINE.csvGetFieldTrim(UL_FIELD_HC,TABS);
            Protein[]pp=null;
            final String[]chains=splitTkns(clr(tmp).aa(LINE.csvGetFieldTrim(UL_FIELD_CHAIN,TABS),' ',LINE.csvGetFieldTrim(UL_FIELD_NUC_CHAINS,TABS)).replaceChar(',',' '));
            Collection<Protein>v=null;
            if(sze(md5)>0){
                final File f=file(clr(tmp).aa(dir,'/').aFT(md5,0,1).aa('/',md5));
                if(sze(f)==0){err.aa(LINE,' ').aFile(f).aln();continue;}
                if(imgFileDotExt(md5)==null) pp=readAddToPep(null,readPepOrNuc(0,chains,f));
                else{
                    if(sze(nam)==0)err.a(RED_WARNING).aln(iConst(SARRAYeq_SSCRIPT_MSG,SSCRIPT_MSG_EXPECT_IMG));
                    else{
                        final Object b64=imgBase64(IMAGEBASE64_H,s(f));
                        if(b64!=ALIAS_ERROR) mapStrStr(MAPSTR_SCRIPT_INTERPRETER_IMAGES).put(nam,s(b64));
                    }
                }
            }else if(sze(ref)>0){
                if(chains.length==0) pp=downloadProteinID(LOADP_PROCESS_LOADED_P,ref,null,null);
                else{
                    for(String chain:chains) v=adAllNotNullNew(downloadProteinID(LOADP_PROCESS_LOADED_P,s(clr(tmp).aa(ref,'_',chain)),null,null),v);
                    pp=spp(v);
                }
            }
            if(!ARRAY_EMPTY(pp)){
                if(sze(pp)==1) pp[0].setName(orS(nam,"Unamed"));
                processLoadedProteins(UNLESS_AA(0,)pp UNLESS_AA(,null));
                //strapSetSequenceIsInAlignment(CTRUE,pp); for(Protein p:pp) p.setProperty(PROTEINO_ALIGNMENT,_main);
                String icn=LINE.csvGetFieldTrim(UL_FIELD_ICN,TABS),b64=null;
                if(sze(icn)>0 && (b64=mapStrStr(MAPSTR_SCRIPT_INTERPRETER_IMAGES).get(icn))==null)err.aa(RED_WARNING,iConst(SARRAYeq_SSCRIPT_MSG,SSCRIPT_MSG_UNKNOWN_IMG),icn).aln();
                for(Protein p:pp){
                    p.setSubset(LINE.csvGetFieldTrim(UL_FIELD_RANGE,TABS));
                    p.setSequenceIcon(b64);
                }
                setSequenceGroup(true,LINE.csvGetFieldTrim(UL_FIELD_GRP,TABS),pp);
            }
        }
        if(sze(err)>0){
            err.special(BA_TO_STDERR);
            baOut(RED_WARNING).aRplc('\t','|',err).aln();
        }
        closeStrm(cis);
    }
#endif //CPP_PRG_AA
/* <<< Script_interpreter Alignment Annotatator <<< */
/* ---------------------------------------- */
/* ---------------------------------------- */
/* >>> Scripting >>> */
#if CPP_WITH_GUI
    public static ResidueAnnotation resanBeforeGaps(Protein p){
        final ResidueAnnotation a=findWithName(RESAN_RESIDUES_BEFORE_GAPS,p.residueAnnotations(),ResidueAnnotation.class);
        final BA pos=new BA(99);
        final int cc[]=p.getResColumn(),N=mini(p.countRes(),cc.length)-1;
        for(int i=0;i<N;i++) if(cc[i+1]-cc[i]>1) pos.aa(firstResIdx(p)+i+1,',');
        return a==null?annotateSeqStyleRgbPosNameGrp(p,SSTYLE_UNDERLINE|SFLAG_NO_SAVE,0xFFFF00,pos.del(','),RESAN_RESIDUES_BEFORE_GAPS,"Computed"): a.annoAdd(IRESAN_POS,pos);
    }
#endif //CPP_WITH_GUI

/*a OBJRX_RESSEL A OBJRX_RESSEL_ANONYM */
    public static CPP_sync void objectsWithRegex(int opt,Object list,Protein[]pp,Collection v){
        if(sze(list)==0) return;
        final byte[]T=list instanceof byte[]?((byte[])list).clone(): list instanceof BA?((BA)list).newBytes(): toByts(list);
        final ChTokenizer tok=toknzr(343,SPC);
        {
            final int opt2=opt&~(OBJRX_EXTRA_PP|OBJRX_EXTRA_PP_CREATE);
            _ooWithRx(opt2,tok,T,pp,v);
            if(opt!=opt2) _ooWithRx(opt,tok,T,_vExtProt,v);
        }
        tok.setText(T,0,MAX_INT);
        if(0!=(opt&OBJRX_WARN)){
            BA sb=null;
            while(tok.nextToken()){
                if(sb==null) sb=baOut(RED_WARNING).a("objectsWithRegex: ");
                sb.aa(tok.asString(),' ');
            }
            if(sb!=null) sb.send();
        }
        clr(tok);
    }

    public static CPP_sync Object[]objectsWithRegex(int opt,Object list,Protein[]pp){
        if(sze(list)==0) return 0==(opt&OBJRX_RESSEL)?Protein.NONE:NO_Object;
        final Collection v=new ArrayList();
        objectsWithRegex( opt,list,pp,v);
        return toArryClr(v);
    }
    private static CPP_sync void _ooWithRx(int opt,ChTokenizer TOK,byte[]T,Object proteins,Collection v){
        TOK.setText(T,0,MAX_INT);
        final int nP=sze(proteins);
    nextToken:
        while(TOK.nextToken()){
            final int sze=v.size(),f=TOK.from(),to=TOK.to();
            try{
                if(!looks(LIKE_FILEPATH,T,f,to)){
                    final int slash=strchr('/',T,f,to),t=slash>=0?slash:to,atSign=strchr('@',T,f,to),to2=atSign>slash?atSign:to;
                    if(t<=f) continue nextToken;
                    final int c0=T[f];
                    if(c0=='-' && f+1<t && T[f+1]=='-') continue nextToken;
                    if(c0=='!' || c0=='$'){
                        FORi(VAR_PROTEINS_WITH_AAA,VAR_PROTEINS_WITH_ZZZ){
                            if(strEquAt(STR_EQ_EXACT_L,iConst(SARRAYeq_STRAP_VARS,i),T,c0=='!'?f+1:f,t)){
                                FORiP(0,nP){
                                    final Protein p=iThProt(iP,proteins);
                                    if(p!=null&&(c0!='!')==(i==VAR_PROTEINS_WITH_PDB_ID?p.getPdbID(PDBID_ID)!=null:
                                                            i==VAR_PROTEINS_WITH_UNIPROT_ID?p.seqId(GETSEQID_ALSO_BY_IDENTITY|BLAST4ID_DB_UNIPROT)!=null:
                                                            i==VAR_PROTEINS_FROM_STRUCTURE_FILE?p.isLoadedFromStructureFile():
                                                            false)) v.add(p);
                                }
                                continue nextToken;
                            }
                        }
                    }
                    final boolean allProts=(t-f==1 || t-f==2&&T[f]=='.') && T[t-1]=='*';
                    java.util.regex.Pattern rx=null,rx2=null;
                    final String expr=s(T,f,t);
                    try{
                        if(!allProts && (strchr('*',T,f,t)>=0 || strchr('\\',T,f,t)>=0 || strchr('[',T,f,t)>=0)) rx=java.util.regex.Pattern.compile(expr);
                    }catch(Exception e){stckTrc(147,e);}
                    try{
                        if(to2-slash>2 && (strchr('*',T,slash+1,to2)>=0 || strchr('[',T,slash+1,to2)>=0)) rx2=java.util.regex.Pattern.compile(s(T,slash+1,to2));
                    }catch(Exception e){stckTrc(148,e);}
                    FORiP(0,nP){
                        final Protein p=iThProt(iP,proteins);
                        if(p==null) continue;
                        final String wt=(String)p.getProperty(PROTEINO_WEB_TOK_WITH_SUBSET),wt3=(String)p.getProperty(PROTEINO_WEB_TOK_PDB);
                        boolean hasRef=strEquAt(0,p.getName(),T,f);
                        if(expr.indexOf(':')>0){
                            for(String ref:p.getRefs(0)) if(hasRef=TOK.tokEquals(STR_IC,ref)) break;
                        }
                        if(allProts || hasRef||
                           rx!=null && (rx.matcher(p.getName()).matches() || wt!=null && rx.matcher(wt).matches() || wt3!=null && rx.matcher(wt3).matches())||
                           TOK.tokEquals(0,p.getName()) || TOK.tokEquals(0,wt)||
                           //  || cntainsOnly(DIGT,T,f,t) && atoi(T,f)==iP+1
                           strStarts("PDB:",expr) && (p.hasPdbId(expr) || strStarts(expr,wt)) || 0>nxt(chrClas(-DIGT),T,f,t) && atoi(T,f)==iP+1){
                            if(slash<0) v.add(p);
                            else if(0!=(opt&(OBJRX_RESSEL|OBJRX_RESSEL_ANONYM))){
                                for(ResidueSelection a:p.resSel(SOBJECT_RESSEL_AND_RESAN)){
                                    final String an=nam(a);
                                    if(an==null) continue;
                                    if(to2-slash==2&&T[slash+1]=='*' || rx2!=null && rx2.matcher(an).matches() || strEquAt(STR_EQ_EXACT_L,an,T,slash+1,to2)){
                                        //if (atSign<0 || resSelPosMatches(T,atSign+1,to,a)){
                                        //final String position=s(T,atSign+1,to);if (atSign<0 || resSelPosMatches(position,0,MAX_INT,a)) v.add(a);
                                        if(atSign<0 || resSelPosMatches(T,atSign+1,to,a)) v.add(a);
                                    }
                                }
                                IF_GUI(if(chrAt(slash+1,T)=='$' && strEquAt(0,RESAN_RESIDUES_BEFORE_GAPS,T,slash+1,to)) v.add(resanBeforeGaps(p)));;

                                if(sze(v)==sze && 0!=(opt&OBJRX_RESSEL_ANONYM) && looksLikeSet(p.getChain()!=null?(LIKESET_ALLOW_COLON_CHAIN|LIKESET_ALLOW_DOT_ATOM):LIKESET_ALLOW_DOT_ATOM,T,slash+1,to2)){
                                    final ResidueAnnotation ra=new ResidueAnnotation(p);
                                    {
                                        final int dot=strchr('.',T,slash+1,to2);
                                        ra.annoAdd(IRESAN_NAME,"selection")
                                            .annoAdd(IRESAN_POS,s(T,slash+1,dot>0?dot:to2));
                                        if(dot>0) ra.annoAdd(IRESAN_ATOMS,s(T,dot+1,to2));
                                    }
                                    ra.setStyle(SSTYLE_LOWER_HALF);
                                    v.add(ra);
                                }
                            }
                        }
                    }
                }
            }finally{
                if(sze(v)==sze && 0!=(opt&OBJRX_EXTRA_PP_CREATE)){
                    final Protein p;
                    {
                        final String id=TOK.asString();
                        if(strStarts("PDB:",id)) p=iThProt(0,readAddToPep(null,pdbDownloadPepOrNuc(0,id,null)));
                        else{
                            final String urlOrF=orS(hrefToUrlString(HREF_PROTEIN_FILE,id),id);
                            p=newProteinInstance(0,readBytes(looks(LIKE_EXTURL,urlOrF)?dlUrl(urlOrF): file(NEWFILE_NO_ERROR,urlOrF)));
                        }
                    }
                    if(p!=null){
                        p.setProperty(PROTEINO_ALIGNMENT,_main);
                        v.add(p);
                        _vExtProt.add(p);
                        p._flags=PFLAG_EXTERNAL;
                        p.setProperty(PROTEINO_WEB_TOK_WITH_SUBSET,TOK.asString());
                    }
                }
                if(v.size()>sze) FORi(f,to) T[i]=32;
            }
        }/*X TOK*/
    }
/* <<< Scripting <<< */
/* ---------------------------------------- */
