#define _csaMap mapNoClr(214)
#define _mapGFF mapNoClr(215)
/* >>> SeqFtr Utils >>> */
private static String _gffUpdateStrg(String old,byte[]T,int begin,int end){
    final int b=nxt(chrClas(-SPC),T,begin,end),e=b<0?0: eolTrim(T,begin,end);
    return e==0?null: old==null || !strEquAt(0,old,T,b)|| old.length()!=e-b?s(T,b,e): old;
}
/* <<< SeqFtr Utils <<< */
/* ---------------------------------------- */
/* >>> SeqFtr Name >>> */
static String sftrMapSynonyms(int opt,String fn){
    if(fn==null) return null;
    String ret=null,aa;
    if(0==(opt&SEQFEAT_NOT_MAP_SYN)){
        if(mapStrStr(MAPSTR_SFTR_SYN|MAPSTR_OPTION_NO_INIT)==null){
            final BA ba=rsc(RSC_SEQUENCE_FEATURES_SYN);
            mapCols012345to9(MAP_KEYS_LETTR_DIGT_LC|MAP_VALUES_AS_INTERN,ba,mapStrStr(MAPSTR_SFTR_SYN));
            if(sze(ba)<99) assrt();
            final BA txt=rsc(RSC_SEQUENCE_FEATURES_RELATIONS);
            final ChTokenizer tok=toknzr(347,SPC);
            final byte[]T=txt.bytes();
            final int ee[]=txt.eol();
            FORiL(0,ee.length){
                final int b=BOL0(iL,ee),e=ee[iL];
                if(e-b<2 || T[b]=='#') continue;
                tok.setText(T,b,e);
                while(tok.nextToken()){/*X  Wozu das?*/
                    final String s=tok.asString();
                    if(s.indexOf('*')<0) mapStrStr(MAPSTR_SFTR_SYN).put(lCaseOnlyLettersDigits(s,mapStrStr(MAPSTR_SFTR_LC)),s);
                }
            }
            clr(tok);
        }
        final String lc=lCaseOnlyLettersDigits(fn,mapStrStr(MAPSTR_SFTR_LC));
        if(lc.indexOf("phosphorylated")>=0 && (lc.indexOf(aa="tyrosine")>=0 || lc.indexOf(aa="threonine")>=0 || lc.indexOf(aa="serine")>=0)) ret=addPfx("Phospho",aa);
        if(ret==null && (lc.indexOf("glycosylat")>=0 || lc.indexOf("glycosolat")>=0)) ret="Glycosylation";
        if(ret==null) ret=mapStrStr(MAPSTR_SFTR_SYN).get(lc);
    }
    //        if(ret==null && nxt(0,chrClas(-UPPR_DIGT_US),fn)<0) ret=fn;
    if(ret==null && (ret=mapStrStr(STR_INTERN_RESAN_KEY).get(fn))==null){
        mapStrStr(STR_INTERN_RESAN_KEY).put(fn,ret=toStrgIntrn(new BA(0).aFilter(FILTER_CAPITALIZE,fn).replaceChar(' ','_')));
    }
    return ret;
}
/* <<< SeqFtr Name <<< */
/* ---------------------------------------- */
/* >>> SeqFtr SecStr >>> */
#if CPP_PRG_AA
private static void sftrSecStrToModel(Protein p){
    if(p==null || p.getResidueSecStrType()!=null) return;
    byte[]ss=null;
    for(ResidueAnnotation s:p.residueAnnotations()){
        final int c=sftrSecStrChar(s.featureName());
        if(c!=0){
            if(ss==null) ss=new byte[p.countRes()];
            final boolean[]bb=s.getSelectedAminoacids();
            final int off=resSelAminoOffsetZ(s),n=mini(bb.length,ss.length-off);
            FORi(maxi(0,-off),n) if(bb[i]) ss[off+i]=(byte)c;
            rmFromProt(s,p);
        }
    }
    if(ss!=null) p.setResidueSecStrType(ss);
}
#endif //CPP_PRG_AA
public static int sftrSecStrChar(String s){
    return "Turn"==s?' ': "Helix"==s?'H': "Beta_strand"==s?'E': '\0';
}
/* <<< SeqFtr SecStr <<< */
/* ---------------------------------------- */
/* >>> SeqFtr Score >>> */
private static void sftrKeepFeaturesWithBestScore(Protein p){
    final ResidueAnnotation[]aa=p.residueAnnotations();
    ROFj0(aa.length){
        final ResidueAnnotation a0=aa[j];
        final String pos0=a0==null?null:a0.value(IRESAN_POS);
        if(pos0==null) continue;
        final float score0=a0._simRegionScore;
        final String name0=a0.featureName();
        for(int WHERE=a0.whereFeatureLoadedFrom(),from0=MIN_INT,to0=MIN_INT,i=aa.length;--i>=0;){
            final ResidueAnnotation a=aa[i];
            if(a==null || a==a0 || pos0==null || a.featureName()!=name0) continue;
            final float score=a._simRegionScore;
            if(WHERE==a.whereFeatureLoadedFrom() && score0<=score) continue;
            final String pos=a.value(IRESAN_POS);
            boolean overlaps;
            if(chrAt(0,pos)!='R'?pos0.equals(pos):/*X RESAN_POS_REFERENCE */
               eqBoolArraysOffset(a.getSelectedAminoacids(),a.getSelectedAminoacidsOffset(),a0.getSelectedAminoacids(),a0.getSelectedAminoacidsOffset())) overlaps=true;
            else{
                final int from=a.getSelectedAminoacidsOffset(),to=from+lstTrue(a.getSelectedAminoacids());
                if(from0==MIN_INT) to0=(from0=a0.getSelectedAminoacidsOffset())+lstTrue(a0.getSelectedAminoacids());
                overlaps=
                    from==from0 && to==to0||
                    from0<=from && from<to0 || from0<=to && to<=to0 ||  from<=from0 && from0<=to   || from<=to0 && to0<=to;
            }
            if(overlaps){
                baLog(LOG_SFTR).aa("   DELETE: ",name0," ",score,"  [",pos,"]   BECAUSE  OF ",score0,"  [",pos0,']').aln();
                rmFromProt(a,p);
                final long hc=a._srcTextHC;
                if(hc!=0) p.addInvalidFeatureHC(hc);
                aa[i]=null;
            }
        }
    }
    baLog(LOG_SFTR).send();
}
/* <<< SeqFtr Score <<< */
/* ---------------------------------------- */
/* >>> SeqFtr Merge  >>> */
private static void sftrMergeA(ResidueAnnotation a,Protein p){
#if CPP_WITH_GUI
    {
        File fAnno=a.featureFile(iFile(DIR_WORKING));
        a.parseResan(readBytes(sze(fAnno)>0?fAnno:a.featureFile(null)),0,MAX_INT);
    }
#endif //CPP_WITH_GUI
    final ResidueSelection s=IF_GUI(!isCbSlct(TOG_COMBINE_SEQ_FEATURES)?null:) sftrMergeSimilar(a,p);
    if(s==null||s==a){
        if(countTrue(a.getSelectedAminoacids())>5) a.setVisibleWhere(a.getVisibleWhere()&~VIS123_STRUCTURE);
        addToProt(a,p);
    }
}
private static ResidueAnnotation sftrMergeSimilar(ResidueAnnotation a,Protein p){
    final String fn=a==null||p==null?null:a.featureName();
    if(fn==null) return null;
    final String pos=a.value(IRESAN_POS);
    for(ResidueSelection s:p.resSel(SOBJECT_RESSEL_AND_RESAN)){
        final ResidueAnnotation a2=s instanceof ResidueAnnotation?(ResidueAnnotation)s:null;
        final String fn2=a2==null?null:a2.featureName();
        if(fn2!=null){
#define sameColon (pos.indexOf(':')>0)==(a2.value(IRESAN_POS).indexOf(':')>0)
            if(!(sameColon?pos.equals(a2.value(IRESAN_POS)): resSelEqualAminoPos(a,a2))) continue;
#undef sameColon
            if(null==a2.entryNotContained(a,false)) return a2;
            if(null==a.entryNotContained(a2,false)){
                rmFromProt(a2,p);
                return a;
            }
            if(a.getName().equals(a2.getName())){
                a2.entryNotContained(a,true);
                return a2;
            }
            if(fn2==fn || sftrIsGeneralizationOf(a.featureName(),a2)){
                IF_GUI(a2.includeFeature(a));;
                return a2;
            }
            if(sftrIsGeneralizationOf(fn2,a)){
                IF_GUI(a.includeFeature(a2));;
                rmFromProt(a2,p);
                return a;
            }
            if(a2.run(RUN_IS_ENABLED,null)==TRUEr && a.run(RUN_IS_ENABLED,null)==TRUEr && 0==sftrSecStrChar(fn) && fn!="Active_site" && 0==sftrSecStrChar(fn2) && fn2!="Active_site"){
                adNotNull(fn.compareTo(fn2)<0?new StrgArray(fn,fn2):new StrgArray(fn2,fn),_sftrNoGeneralizationV);
            }
        }
    }
    return null;
}
static boolean sftrIsGeneralizationOf(String fnGeneral,Object oSpecific){
    final ResidueAnnotation aSpecific=oSpecific instanceof ResidueAnnotation?(ResidueAnnotation)oSpecific:null;
    final String fnSpecific=aSpecific!=null?aSpecific.featureName(): (String)oSpecific;
    if(sze(fnSpecific)>sze(fnGeneral) && strstr(STR_IC,fnGeneral,fnSpecific)>=0&&
       !fnSpecific.startsWith("UNIPROT")) return true;/*X "Helix" and "UNIPROTKB_P23639_HELIX_240_247_26"*/
    final Map m=mapNoClr(270);
    if(sze(m)==0) mapKey2Arry(MAP_VALUES_AS_INTERN,rsc(RSC_SEQUENCE_FEATURES_RELATIONS),m);
    final String[]ssSpecific=(String[])m.get(fnGeneral);
    boolean ret=false;
    if(ssSpecific!=null){
        for(String s:ssSpecific){
            if(s!=null){
                final int L=s.length();
                if(L>0){
                    if(s==fnSpecific) {ret=true;break;}
                    final char c0=s.charAt(0),c9=s.charAt(L-1);
                    if(c0=='*' && c9=='*'){
                        if(L==1) {ret=true;break;}
                        if(xstrstr(0,s,1,L-1,fnSpecific,0,MAX_INT)>=0) {ret=true;break;}
                    }else if(c0=='*'){
                        if(xstrEquAt(0,s,1,L,fnSpecific,sze(fnSpecific)-L+1,MAX_INT)) {ret=true;break;}
                    }else if(c9=='*'){
                        if(xstrEquAt(0,s,0,L-1,fnSpecific,0,MAX_INT)) {ret=true;break;}
                    }
                }
            }
        }
    }
    if(!ret && (fnGeneral=="Post_translational_modification" || fnGeneral=="Modified_residue")){
        final int[]aa=aSpecific==null?null: aSpecific.ENDS_AA;
        final boolean isAA;
        if(aa==null || aa[0]==0){
            isAA=textHasAminoAcid(fnSpecific)>0;
            if(aa!=null) aa[0]=isAA?CTRUE:CFALSE;
        }else isAA=aa[0]==CTRUE;
        if(isAA) ret=true;
    }
    if(ret && adNotNull(new StrgArray(fnGeneral,fnSpecific),setNoClr(226))){
        baLog(LOG_SFTR_GENERALIZATION).aa("Drop ",fnGeneral," but keep ").aln(fnSpecific);
    }
    return ret;
}
/* <<< SeqFtr Merge <<< */
/* ---------------------------------------- */
/* >>> SeqFtr Add >>> */
public static void sftrAdd(ResidueAnnotation a,Protein p,String why){
    if(a==null || p==null) return;
    final String fn=a.featureName();
    if(fn=="Sequence_conflict" || fn=="mature_protein_region") why="Unspecific";
    if(p.getResidueSecStrType()!=null && 0!=sftrSecStrChar(fn)) why="Secondary structure already known";
    if(countTrue(a.getSelectedAminoacids())==0) why="No aminos selected";
    if(sze(why)!=0) a.annoAdd(IRESAN_DISABLED,why);
    CPP_synchronized(mkIdObjct(331,p)) {sftrMergeA(a,p);}
}
/* <<< SeqFtr Add <<< */
/* ---------------------------------------- */
/* >>> SeqFtr Load >>> */
public static UNLESS_GUI(void) IF_GUI(Runnable)sftrStartThreads(int opt,IF_DAS(Object[]rows_or_title,) Protein[]pp){/*X opt=SEQFEAT_... | FINDUP_... */
#if CPP_WITH_GUI
    CountDown countDown=new CountDown0("Sequence Features"),countDownID=null;
    if(0==(opt&SEQFEAT_NOT_SEARCH_ID)) countDownIncRunDec("blast4id",blast4id(RETURN_THREAD|(BLAST4ID_DB_UNIPROT<<BLAST4ID_DB_SHIFT),pp,null),countDownID=new CountDown0("BLAST4ID"));
    opt|=RETURN_THREAD;
#endif //CPP_WITH_GUI
    IF_DAS(for(Object t:oo(rows_or_title)) IF_GUI(countDownIncRunDec("DAS",StrapDAS.loadDas(opt,t,pp,countDownID),countDown)));;
    if(0!=(opt&SEQFEAT_SRC_UNIPROT)){
        IF_LocalSequenceDB(if(LocalSequenceDB.instances().length>0) sftrPutLoaded(null,pp); else){
            IF_GUI(countDownIncRunDec("sftrLoad",sftrLoad(opt|RETURN_THREAD,pp,countDownID),countDown));;
        }
    }
    if(0!=(opt&SEQFEAT_SRC_CSA)){/*X Warten auf project coordinates? */
        IF_GUI(countDownIncRunDec("sftrLoadCSA",sftrLoadCSA(IF_GUI(RETURN_THREAD,)pp),countDown));;
    }
#if CPP_WITH_GUI
    startThrd(thrdRRR(thrdCountDownWait(3334,1000*60*10,countDown),
                      thread_setDisabled(_seqfeatPrgBars),
                      thread_setEnabled((new Object[]{buttn(SBUT_SEQFEAT_UniprotFtr),buttn(SBUT_SEQFEAT_ButDefault)})),
                      null));
    return countDown;
#endif //CPP_WITH_GUI

}
private static ResidueAnnotation[]sftrParseGffOrXml(int opt,BA ba,Protein p,String sequenceDB){
    if(0==sze(ba) || p==null) return ResidueAnnotation.NONE;
    final byte[]T=ba.bytes();
    final int E=ba.end(),B=nxt(chrClas(-SPC),T,ba.begin(),E);
    if(B<0) return ResidueAnnotation.NONE;
    IF_DAS(final boolean isXML=chrAt(B,T)=='<' && (strstr(0,"</SEGMENT>",ba)>0 && strstr(0,"<SEGMENT",ba)>=0 || strstr(0,"</FEATURE>",ba)>0 && strstr(0,"<FEATURE",ba)>=0));;
    Collection vRA=null;
    String dataSrc=uCase(sequenceDB);
    final int ee[]=ba.eol();
 nextFeature:
    FORiL(0,ee.length){
        final int b=BOLb(iL,ee),e=ee[iL],from=IF_DAS(isXML?strstr(0,"<FEATURE",T,b,E):)b,to=from<0?-1: IF_DAS(isXML?strstr(0,"</FEATURE>",T,b,E):) eolTrim(T,b,e);
        if(strEquAt(0,SEQFEAT_PFX_DATA_SRC_EQ,T,b)){
            dataSrc=s(T,b+CPP_STRLEN(SEQFEAT_PFX_DATA_SRC_EQ),ee[iL]);
            continue;
        }
        if(to-from<5 || T[b]=='#') continue;
        final long hc=hashCdL(T,from,to);
        if(p.isInvalidFeatureHC(hc)) continue;
        if(hc!=0) for(ResidueAnnotation a2:p.residueAnnotations()) if(a2._srcTextHC==hc) continue nextFeature;
        String disabledWhy=null;
        int iErr=0;
        try{
            final ResidueAnnotation a=new ResidueAnnotation(p);
            IF_DAS(if(isXML) error=StrapDAS.sftrParseXml(T,from,to,dataSrc,a); else)
                iErr=sftrParseGffLine(opt,T,from,to,dataSrc,a);
            if(iErr!=0) continue;
            final String fName=sftrMapSynonyms(opt,nam(a));
            if("Chain"==fName) {iErr=SSCRIPT_MSG_CHAIN; continue;}
            if(0!=sftrSecStrChar(fName) && p.getResidueSecStrType()!=null) {iErr=SSCRIPT_MSG_SECONDARY_STRUCTURE; continue;}
            {
                final int off=a.getSelectedAminoacidsOffset(),fst=fstTrue(a.getSelectedAminoacids()),lst=lstTrue(a.getSelectedAminoacids());
                if(fst<0) disabledWhy="No residues";
                else if(off+fst>p.countRes()) disabledWhy="Right of sequence range";
                else if(off+lst<0) disabledWhy="Left of sequence range";
                else{
                    final String rule=FeatureColor.featureColor(fName).rule();
                    if(rule!=null && rule!="-"){
                        if(fst!=lst) baOut(RED_WARNING).aa("Feature ",fName).and(": Unexpected rule \"",rule).a("\" because it spans >1 residue.").aln(a.value(IRESAN_POS)).aFT(T,b,e).aln();
                        else if(off<p.countRes() && off>=0){
                            final char amino=chrAt(off&~32,p.getResType());
                            if(rule.indexOf(amino)<0){
                                disabledWhy=s(baClr(136).aa(" Actual amino: ",amino," But allowed aminos: ",rule));
                                baOut(RED_WARNING).aa(p,'/',fName,'@',a.value(IRESAN_POS),"  offsets=").aln(p._mapRefSeqOffset);
                            }
                        }
                    }
                }
            }
            a._srcTextHC=hc;
            a.setStyle(SSTYLE_UNDERLINE | (1<<VIS123_BIT_SHIFT_LINE));
            a.annoAdd(IRESAN_NAME,fName).setFeatureSrc(IF_DAS(isXML?SEQFEAT_SRC_DAS:) SEQFEAT_SRC_UNIPROT);
            if(a.value(IRESAN_GROUP)==null) a.annoAdd(IRESAN_GROUP,disabledWhy==null?"Features": IF_DAS(isXML?"Deactivated DAS-features":) "Deactivated GFF-features");
            IF_MEIN_DEBUG(if(disabledWhy!=null) baOut("disabledWhy=").and(disabledWhy," addFeature ").aa(p,'/',nam(a),' ',ANSI_FG_GRAY).aRplc('\t',' ',T,b,e).aln(ANSI_RESET));;
            if(a.value(IRESAN_SRC)==null && a.value(IRESAN_HIDDEN)==null) a.annoAdd(IRESAN_HIDDEN,"f");/*X  Otherwise very long underlinings are deactivated by checkbox in HTML */
            sftrAdd(a,p,disabledWhy);
            vRA=adNotNullNew(a,vRA);
        } finally{
            if(iErr!=0){
                IF_MEIN_DEBUG(if(onlyOnceHC(324,iConst(SARRAYeq_SSCRIPT_MSG,iErr))) baOut(RED_WARNING).aa("sftrParseGffOrXml p=",p," error=").aln(iConst(SARRAYeq_SSCRIPT_MSG,iErr)));;
                if(hc!=0) p.addInvalidFeatureHC(hc);
            }
        }
    }
    if(vRA!=null){
        sftrKeepFeaturesWithBestScore(p);
        vRA.retainAll(p.vChilds(SOBJECT_RESSEL_AND_RESAN));
    }
    return toArry(vRA,ResidueAnnotation.NONE);
}
private final static int[]_gffTT=new int[9];/*X  P25787 UniProtKB Modified residue 24 24 . . . Note=Phosphotyrosine */
public static int sftrParseGffLine(int opt,byte[]T,int b,int e,String dataSrc,ResidueAnnotation a){
    CPP_synchronized(recordSync(_gffTT,"sftrParseGffLine")){
        final boolean[]no_spc=chrClas(-SPC);
        final BA pos=baClr(137);
        int b0=0,e0=0,b1=0,e1=0,b2=0,e2=0,b3=0,e3=0,b4=0,e4=0,nuc=IRESAN_POS;
        {
            final int nTabs=mini(8,tabulatrs('\t',T,b,e,_gffTT));
            if(nTabs<3) return GFF_MSG_AT_LEAST_3_FIELDS;
            ROFi0(nTabs+1){
                final int f=nxt(no_spc,T,i==0?b:maxi(0,_gffTT[i-1]),e),t=eolTrim(T,b,_gffTT[i]);
                if(t-f==1&&T[f]=='.' || f>=t) continue;
                switch(i){
                case 0:b0=f; e0=t;break;
                case 1:b1=f; e1=t;break;
                case 2:b2=f; e2=t;break;
                case 3:b3=f; e3=t;break;
                case 4:b4=f; e4=t;break;
                case 6:
                    if(t-f==1 && T[f]=='+') nuc=IRESAN_POS|RESAN_ENTRY_NT;
                    break;
                case 8:
                    if(nTabs>7) sftrGffAttributes(a,T,f,t);
                    break;
                }
            }
        }
        a.annoAdd(IRESAN_NAME,sftrMapSynonyms(opt,s(T,b2,e2)));
/* TT[2*..] can be -1 */
        final int plus4=b4>0&&T[b4]=='+'?1:0,minus3=b3>0&&T[b3]=='-'?1:0;
        if(e0-b0>1&&e1-b1>1) pos.aa(RESAN_POS_REFERENCE+"=",canonicalSeqDB(SEQID_PUT_COLON,s(T,b1,e1))).aFT(T,b0,e0).a(' ');
        if(e3>b3 && e4<=b4){/*X  Field 3 has Expression */
            if(e1>b1) return GFF_MSG_START_END;
            a.annoAdd(IRESAN_POS,pos.aFT(T,b3,e3))
                .annoAdd(IRESAN_GROUP,addSfx(dataSrc," GFF "));
        }else if(e3-b3>minus3 && 0>nxt(chrClas(-DIGT),T,b3+minus3,e3) && 0>nxt(chrClas(-DIGT),T,b4+plus4,e4)){
/*X Wozu das sternchen*/
            final int asterisk=dataSrc==null?0:dataSrc.indexOf('*');
            if((e1>b1||asterisk>0) && e0>b0){
#define ba baClr(138)
                a.annoAdd(IRESAN_SRC,
                          asterisk>0?ba.aFT(dataSrc,0,asterisk).aFT(T,b0,e0).aFT(dataSrc,asterisk+1,MAX_INT):
                          ba.a(dataSrc!=null?dataSrc:strEquAt(STR_IC,DB_UNIPROT,T,b1)?DB_UNIPROT: uCase(s(T,b1,e1))).a1(':').aFT(T,b0,e0));
#undef ba
            }
            // else a.annoAdd(nuc,pos.aFromDashTo(atoi(T,b3),atoi(T,b4)));
            a.annoAdd(nuc,pos.aFromDashTo(atoi(T,b3),atoi(T,b4)));
        }else{
            return GFF_MSG_START_END;
        }
    }
    return 0;
}
private static void sftrGffAttributes(ResidueAnnotation a,byte[]T,int f,int t){
    String evidence=null;
    FOReq(f+1,t-1){
        switch(T[eq]){
        case'=':
            switch(T[eq-1]){
            case'e':
                if(eq-f>3 && strEquAt(STR_w_L|STR_IC,"Note",T,eq-4)){
                    String n;
                    if(strEquAt(0,n="Modified_residue",T,eq+1) || strEquAt(0,n="Topological_domain",T,eq+1) || strEquAt(0,n="Region",T,eq+1)) a.annoAdd(IRESAN_NAME,n);
                    continue;
                }
                break;
            case's':
                if(eq-f>5 && strEquAt(STR_w_L,"status",T,eq-6)){
                    if(strEquAt(STR_w_R,"By similarity",T,eq+1)) evidence=EVIDENCE_BY_SIMILARITY;
                    if(strEquAt(STR_w_R,"Potential",T,eq+1)) evidence=EVIDENCE_POTENTIAL;
                    continue;
                }
                break;
            }
            final String k=strM(STR_INTERN_GFF_ATTR,toStrgTrim(T,nxtBwd(STR_E,chrClas(-LETTR),T,eq-1,f-1)+1,eq));
            final int begin,end=T[eq+1]=='"'?closingDquote(T,begin=eq+2,t):nxt(STR_E,chrClas(SPC_SEMICOLON),T,begin=eq+1,t);
            if(end>begin && sze(k)>0){
                if(k==KRESAN_COLOR) a.setColor('*',str2color(T,begin));
                else a.addE(0,k,s(T,begin,end));
            }
            break;
        case'$':
            if(strEquAt(STR_w_R,"$SBS",T,eq)) evidence=EVIDENCE_BY_SIMILARITY;
            if(strEquAt(STR_w_R,"$SP",T,eq)) evidence=EVIDENCE_POTENTIAL;
        }
    }
    if(evidence!=null) a.annoAdd(IRESAN_EVIDENCE,evidence);
}
/* <<< SeqFtr Load <<< */
/* ---------------------------------------- */
/* >>> SeqFtr GFF  >>> */
/* This method creates ResidueAnnotation objects for already downloaded GFF or BioDAS texts. */
/* It can be called outside EDT and puts itself into EDT. */
/* @param m Mapping of sequence IDs to GFF or BioDAS texts. */
/* In non-GUI mode,m can be null. In this case the texts are found in p.getProperty(PROTEINO_vGFF). */
REFLECTION_PUBLIC_STATIC_VOID sftrPutLoaded(Map<String,BA>m,Protein[]pp){
    Collection v=null;
#if CPP_WITH_LocalSequenceDB
    if(m==null){
        for(Protein p:pp){
            final String dbId=p.seqId(BLAST4ID_DB_UNIPROT);
            if(dbId!=null && !cntainsEl(dbId,(Collection)p.getProperty(PROTEINO_vIdsOfGffText)))  v=adUniqNew(new LocalSequenceDB.SeqWithID(dbId,p),v);
        }
        final LocalSequenceDB up=sze(v)==0?null: LocalSequenceDB.instanceForDB("UNIPROT:");
        if(up!=null) up.getSeqAndAnnoTextMulti(true,toArry(v,LocalSequenceDB.SeqWithID.class),_main /*RUN_SEQDB_FOUND_SEQ4ID*/);
        for(Protein p:pp) for(Object txt:oo((Collection)p.getProperty(PROTEINO_vGFF))) sftrParseGffOrXml(0,(BA)txt,p,null);
    } else
#endif //CPP_WITH_LocalSequenceDB
        if(m!=null){
            final boolean isEDT=isEDT();
            IF_GUI(boolean added=false);;
            final String[]name_iP=new String[2];
            if(isEDT) v=new HashSet(m.keySet());
            FORiP(0,pp.length){
                final Protein p=pp[iP];
                if(p==null) continue;
                int count=0;
                name_iP[0]=p.getName();
                name_iP[1]=s(iP+1);
                for(int t=REFS_ZZZ;--t>=-1;){
                    if(t!=0&&t!=REFS_BY_IDENT&&t!=-1) continue;
                    for(String id:t==-1?name_iP:p.getRefs(t)){
/* First collect all required sequences not in EDT. They will be used in sftrParseGffOrXml() in Protein.refSeqOffset */
                        IF_GUI(if(!isEDT&&strchr(':',name_iP)>0) p.refSeqOffset(true,id); else){
                            final BA txt=m.get(id);
                            IF_GUI(Collection vHC=(Collection)p.getProperty(PROTEINO_vGFFhc));
                            IF_GUI(if(vHC==null) p.setProperty(PROTEINO_vGFFhc,vHC=new HashSet()));;
                            if(txt!=null IF_GUI(&&vHC.add(txt.hashCodeAsLong()))){
                                rmElmntFromV(id,v);
                                for(ResidueAnnotation a:sftrParseGffOrXml(0,txt,p,"")){
                                    if(t==0 && a.value(IRESAN_EVIDENCE)==null) a.annoAdd(IRESAN_EVIDENCE,EVIDENCE_BY_IDENTITY);
                                    if(a.run(RUN_IS_ENABLED,null)==TRUEr) count++;
                                }
                            }
                        }
                    }
                }
                if(count>0){
                    strapIncMC(MCA_SEQUENCE_FEATURES_V,null);
                    IF_GUI(added=true);;
                }
            }
            if(sze(v)>0) baOut(RED_WARNING).a(" Unused GFF: ").aln(v);
            IF_GUI(if(!isEDT) inEdtLater(CPP_thrdMS(sftrPutLoaded,Strap,m,pp)); else if(added) strapEvtDispatch(EVT_RESIDUE_SELECTION_ADDED|SEVTMS*999));;
        }
    REFLECTION_RETURN;
}
/* The second column contains the DB like "UniProtKB". */
/* Will be mapped to "UNIPROT". */
/* Can be empty. */
/* If not loaded from server,the first column can be the sequence name or the protein number. */
REFLECTION_PUBLIC_STATIC Runnable gffFromFileOrServer(int opt,String src,BA txt,Protein[]pp,Map<String,BA>m1){
#define THREAD CPP_thrdMS(gffFromFileOrServer,Strap,io(opt),src,txt,pp,m1)
    IF_GUI(if(OPT_RETURN_THREAD(opt)) return THREAD);;
    IF_GUI(if(!isEDT()) {inEdtLater(THREAD); return null;});;
#undef THREAD
    final byte[]T=txt.bytes();
    String id=null,db0=null,db_id=null;
    final BA tmp=new BA(22),baPP=new BA(22);
    if(pp==null)pp=strapProteins();
    BA buf=null;
    final ScriptVariables variables=new ScriptVariables();
    final int[]TABS=new int[3],ee=txt.eol();
    final Map m=_mapGFF;
    FORiL(0,ee.length){
        final int b=BOL0(iL,ee),e=ee[iL];
        if(e-b==0 || T[b]=='#'||
           e-b>5 && T[b]=='l' && strEquAt(0,"let ",T,b) && variables.evalVarAssignment(T,b+4,e)||
           tabulatrs('\t',T,b,e,TABS)<2) continue;
        id=_gffUpdateStrg(id,T,b,TABS[0]);
        if(TABS[0]>=0 && nxt(chrClas(LETTR),T,TABS[0],TABS[1])>=0){/*X  With DB reference */
            db0=_gffUpdateStrg(db0,T,TABS[0],TABS[1]);
            final String db=orS(canonicalSeqDB(SEQID_PUT_COLON,db0),db0);
            final int dbL=sze(db);
            if(db_id==null || dbL>0&&!db_id.startsWith(db) || !db_id.endsWith(id) || sze(db_id)!=dbL+sze(id)+(dbL==0?0:1)){
                db_id=s(clr(tmp).aa(db,id));
                buf=null;
            }
            if(null==buf && null==(buf=(BA)m.get(db_id))){
                m.put(db_id,buf=new BA(333).a(SEQFEAT_PFX_DATA_SRC_EQ).aa(src,'\n'));
                IF_GUI(m1.put(db_id,buf));;
            }
            buf.aFT(T,b,e).a('\n');
        }else{/*X  Without DB reference */
            for(Object p:sze(id)==0? pp: objectsWithRegex(0,braceExpansion(variables.set(true,T,b,TABS[0]).mkBA(baPP)),pp)){
                sftrParseGffOrXml(opt,clr(tmp).aFT(T,b,e),(Protein)p,"");
            }
        }
    }
    for(Object k:oo(m.values()))  ((BA)k).trimSize();
    if(0!=(opt&SEQFEAT_PUT_LOADED)) sftrPutLoaded(m1,pp);
    return null;
}
public static ResidueAnnotation[]sftrLoadFromProteinFile(BA text,int maxLen,Protein... pp){
    final Collection<ResidueAnnotation>vAnnotations=new ArrayList();
    BA ba=null;
    boolean found=false;
    for(Protein p:pp){
        if(null==(ba=pp.length==1 && text!=null?text: readBytes(p.getFile(),ba))) continue;
        final byte[]T=ba.bytes();
        final int[]ee=ba.eol();
        Map<String,String>mapRemark=null;
        FORiL(0,ee.length){
            final int b=BOL(iL,ee,ba);
            if(ee[iL]-b>28 && T[b+7]=='8' && T[b+8]=='0' && T[b+9]=='0' && T[b]=='R' && strEquAt(0,"REMARK 800 SITE_IDENTIFIER: ",T,b)){
                final String id=ba.getString(MAP_BA_STRING_TRIM,b+28,ee[iL]);
                FORjL(iL+1,ee.length){
                    final int lineBegin=ee[jL-1]+1;
                    if(isChrClas(LETTR_DIGT,T,lineBegin)){
                        if(strEquAt(0,"REMARK 800 SITE_DESCRIPTION: ",T,lineBegin)){
                            (mapRemark==null?mapRemark=new HashMap():mapRemark).put(id,ba.getString(MAP_BA_STRING_TRIM,lineBegin+29,ee[jL]));
                        }
                        break;
                    }
                }
            }
        }
        boolean thisFound=false;
        {
            final ChTokenizer TOK=new ChTokenizer(SPC);

        nextLine:
            for(int fromTo[]={0,0},b=0,e=0,iL=0;iL<ee.length; iL++,b=e+1){
                e=eolTrim(T,b,ee[iL]);
                if(e-b>5 && T[b]=='F' && T[b+1]=='T'&&T[b+2]==' '){
                    TOK.setText(T,b+3,e);
                    if(!TOK.nextToken()) continue nextLine;
                    {
                        final int f=TOK.from(),c0=T[f];
                        if((c0=='C'&&TOK.eq("CDS")||TOK.eq("CHAIN")) || c0=='e'&&TOK.eq("exon")  || !IS_UPPER_OR_LOWER(c0) || 0<=nxt(chrClas(-LETTR_DIGT_US),T,f,TOK.to())) continue nextLine;
                    }
                    final String featureName=TOK.asString();
                    if(!TOK.nextToken() || 0<=nxt(chrClas(-DIGT),T,TOK.from(),TOK.to())) continue;
                    final int start=TOK.asInt()-1;
                    if(!TOK.nextToken() || 0<=nxt(chrClas(-DIGT),T,TOK.from(),TOK.to())) continue;
                    final int end=TOK.asInt();
                    if(end-start<1 || end-start>maxLen) continue;
                    fromTo[0]=1+start;
                    fromTo[1]=end;
                    ResidueAnnotation a=new ResidueAnnotation(p).
                        annoAdd(IRESAN_REMARK,ba.newString(b,e))
                        .annoAdd(IRESAN_POS,fromTo)
                        .annoAdd(IRESAN_GROUP,"FT_Lines")
                        .annoAdd(IRESAN_NAME,featureName).setFeatureSrc(SEQFEAT_SRC_FILE);
                    a.setStyle(SSTYLE_UNDERLINE | (1<<VIS123_BIT_SHIFT_LINE));
                    thisFound=found=true;
                    if(featureName!=sftrMapSynonyms(0,featureName)) a.annoAdd(IRESAN_REMARK,featureName);
                    sftrAdd(a,p,null);
                    vAnnotations.add(a);
                }
            }
        }
        if(thisFound) sftrKeepFeaturesWithBestScore(p);
    }
    final ResidueAnnotation[]aa=toArry(vAnnotations,ResidueAnnotation.NONE);
    if(found){
        strapIncMC(MCA_SEQUENCE_FEATURES_V,null);
        strapEvtDispatch(EVT_RESIDUE_SELECTION_ADDED|SEVTMS*999);
    }
    return aa;
}
/* <<< SeqFtr GFF <<< */
/* ---------------------------------------- */
/* >>> CSA  >>> */
REFLECTION_PUBLIC_STATIC Runnable sftrLoadCSA(IF_GUI(int opt,) Protein[]pp){
    IF_GUI(if(OPT_RETURN_THREAD(opt)) return CPP_thrdMS(sftrLoadCSA,Strap,io(opt),pp));;
    if(IF_AA(sze(iFile(F_CATALYTIC_SITE_ATLAS))==0||)fstNotNull(pp)!=null) return null;
    final ChTokenizer tok=new ChTokenizer(SPC);
    {
        final BA ids=new BA(99);
        for(Protein p:pp){
            if(p!=null){
                final String id=p.getPdbID(PDBID_ID|PDBID_INFERRED);
                if(sze(id)>0){
                    final String uc=uCase(id);
                    if(_csaMap.get(uc)==null) ids.aWithoutPfx("PDB:",uc).a('\n');
                }
            }
        }
        BA txt=null;
        IF_AA(if(sze(iFile(F_CATALYTIC_SITE_ATLAS))>0)txt=toBA(rtExecOutput(0,new Object[]{"fgrep","-f",wrte(iFile(FSUFFIX_txt),ids),iFile(F_CATALYTIC_SITE_ATLAS)})));;
        if(sze(txt)==0) return null;
        final byte[]T=txt.bytes();
/* To HashMap */
        final int ee[]=txt.eol();
        FORiL(0,ee.length){
            final int b=BOL0(iL,ee),t0=strchr('\t',T,b,ee[iL]);
            if(t0<0){
                baOut(RED_WARNING).a("txt=").aln(txt).aln("\nLine=").aFT(T,b,ee[iL]).aln().aln();
                assrt();
            }else{
                final byte[]data=txt.newBytes(t0+1,ee[iL]);
                tok.setText(T,b,t0);
                while(tok.nextToken()) _csaMap.put(tok.asString(),data);
            }
        }
    }
/* Create ResidueAnnotation */
    int count=0;
    final String CSA_PFX=ANSI_FG_BLUE+"CSA: "+ANSI_RESET;
    baOut(CSA_PFX).a("Key-set: ").aln(_csaMap.keySet());
    for(Protein p:pp){
        String status=null;
        final String id=delPfx("PDB:",uCase(p.getPdbID(PDBID_ID|PDBID_INFERRED)));
        if(id!=null){
            final long match=p._infXYZMatch;
            status=(match>>>NUMERATOR_SHIFT)==(match&DENOMINATOR_MASK)?EVIDENCE_BY_IDENTITY: EVIDENCE_BY_SIMILARITY;
        }
        final byte[]T=id==null?null:(byte[])_csaMap.get(id);
        tok.setText(T,0,MAX_INT);
        baOut(CSA_PFX).aa(p,"\t",id,"\t").formatSize(sze(T)).a('\n');
        final byte[]rt=p.getResTypeUC();
        while(tok.nextToken()){
            final int f=tok.from(),t=tok.to(),
                csaRT=T[f]&~32,
                csaRN=atoi(T,f+1),
                csaIns=isChrClas(LETTR,T,t-1)?T[t-1]: INSCODE_WITHOUT,
                ia=p.resnToIdx(0,csaRN,(char)csaIns);
            if(csaRT!=iThByte(ia,rt)){
                final BA sb=baOut(CSA_PFX).aa(T," ",id,'/',(char)csaRT,csaRN).an((char)csaIns,csaIns==0?0:1).aa(" p=",p,"/");
                if(ia<0||ia>=p.countRes()) sb.aln("Not in sequence ");
                else sb.aa("Wrong residue type ",chrAt(ia,rt),ia).aln();
                continue;
            }
            final String pos=s(1+ia+firstResIdx(p));
            baOut(CSA_PFX).aa(p," Add ",pos,"\t\"",(char)csaRT,"\"\t",T).aln(GREEN_SUCCESS);
#define baTmp() baClr(170)
            annotateSeqStyleRgbPosNameGrp(p,SSTYLE_UNDERLINE,0,pos,"Active_site","CSA")
                .annoAdd(IRESAN_HYPERREFS,baTmp().aa("PDB_CATALYTIC_SITE:",id))
                .annoAdd(IRESAN_BALLOON,baTmp().aa("From PDB:",pdbID(id)," Chain ",pdbChain(id)," Residues ").aFilter(FILTER_TO_UPPER,T))
                .annoAdd(IRESAN_EVIDENCE,csaRT!=T[f] CPP_REM(byHomology)?EVIDENCE_BY_SIMILARITY: orS(status,EVIDENCE_BY_SIMILARITY))
                .setFeatureSrc(SEQFEAT_SRC_CSA);
            count++;
        }
#undef baTmp
    }
    baOut(null).aPlrl(count,CSA_PFX+"Added %N residue selection%S ").a(pp).aln(count>0?GREEN_SUCCESS:null);
    if(count>0) strapEvtDispatch(EVT_RESIDUE_SELECTION_ADDED);
    return null;
}
/* PDB ID,SITE NUMBER,RESIDUE TYPE,CHAIN ID,RESIDUE NUMBER,CHEMICAL FUNCTION,EVIDENCE TYPE,LITERATURE ENTRY */
/* 1 */
/* 1j17,7,Asp,T,102,U,HOM,1rtf */
/* 1j17,7,Gly,T,193,U,HOM,1rtf */
/* 1y7l,1,Lys,A,42,S,HOM,1m54 */
/* <<< CSA <<< */
/* ---------------------------------------- */
