
/*  */
/* ---------------------------------------- */
/* >>> Open >>> */
private static int _v3dOpenCount;
// V3DCMD_set_rotation_translation
#define gui 0==(opt&V3D_OPEN_TO_HTML)
REFLECTION_PUBLIC_STATIC View3d v3dOpen(int opt,Protein[]pp,Object clazzOrViewer,File webDir){
    if(fstNotNull(pp)==null) return null;
    final View3d inSameView=derefZ(clazzOrViewer,View3d.class);
#if CPP_WITH_GUI
    if(gui){
        if(!isEDT()) return(View3d)inEdtNow(thread_v3dOpen(opt,pp,clazzOrViewer,webDir));
        if(clazzOrViewer==null) return null;
        if((opt&V3D_OPEN_ASK)!=0){
            if(!dlgYesNo(nProteins(pp,toBA("Load ")).a("\n into the protein structure viewer?"))) return null;
            if(null==fstComplies(pp,IF_CALPHA)) new BA(99).aPlrl(pp.length,"A 3D structure is not associated to the protein%S").special(BA_ERROR);
        }
    }
#endif //CPP_WITH_GUI
    View3d pv1=null;
    FORiP(0,pp.length){
        final Protein p=pp[iP];
        //if (p==null || (!p.hasXYZorPDBID(true) && p.getMolecules(CHAINTYPE_NUC_OR_HET).length==0)) continue;
        if(p==null || 0==(opt&V3D_OPEN_EVEN_IF_NO_XYZ) && (!(clazzOrViewer==Simple3D.class?hasCalpha(p):hasXYZ(p)) && p.getPdbID(PDBID_ANY_SIMILAR)==null && p.getMolecules(CHAINTYPE_NUC_OR_HET).length==0)||
           v3dForProtein(p,inSameView)!=null) continue;
        final View3d pv;
#if CPP_WITH_GUI
        if(gui){
            if((pv=(View3d)mkInstance(iCLASS_View3d,io(bidForClass(clazzOrViewer))))==null) return null;
        }else
#endif //CPP_WITH_GUI
            //(pv=new AbstractView3d(0 IF_GUI(,io(0)))).setProperty(AVIEW3D_SET_WEB_DIR,webDir);
            (pv=new AbstractView3d(0 IF_GUI(,null))).setProperty(AVIEW3D_SET_WEB_DIR,webDir);
        if(pv.init3d(opt,p,pv1!=null?pv1:inSameView)){
            pv.setProperty(VIEW3D_IS_VERBOSE,(opt&V3D_OPEN_VERBOSE)!=0?TRUEr:null);
            if(v3dFlag(VIEW3D_FLAG_EXECUTABLE,pv)) baLog(LOG_MSG).aln("To see details of the external process,\nhold ctrl when pressing the button to start the 3D viewer.");
            IF_GUI(if(gui) v3dTransform3D(p.getRotationAndTranslation(),pv));;
            IF_AA(if(p.getRotationAndTranslation()!=null)  v3dForHtml(pv).pseudoCommand("AA_ROT_TRANS("));;
            addToProt(pv,p);
            IF_GUI(if(!(pv instanceof Simple3D))){
                IF_GUI(if(0!=(opt&V3D_OPEN_EACH_PROTEIN_OWN_COLOR)) v3dColorAllAminos(v3dChain2color(iP),pv));;
                if(0!=(opt&V3D_OPEN_INIT_SCRIPT)) v3dSendCommand(V3DCMD_render IF_AA(+" --early"),pv);
                if(0!=(opt&V3D_OPEN_SEND_ALL_ANNOTATIONS)) v3dApplyResSel(V3D_RESSEL_COMMANDS|V3D_RESSEL_NOT_HIGHLIGHT|V3D_RESSEL_SKIP_WITHOUT_COMMAND,p.residueAnnotations(),new View3d[]{pv},null);
                IF_GUI(if(gui) strapEvtDispatch(EVT_V3D_LOADED));;
            }
            if(pv1==null) pv1=pv;
            IF_GUI(v3dSendCommand(p.getProperty(PROTEINO_RUN_SCRIPT_AFTER_LOADING),pv));;
        }
        //IF_GUI(runCR1(RUN_V3D_msgRatherDragProt,_main,pv));;
    }
#if CPP_WITH_GUI
    if(gui && pv1!=null){
        v3dSetPV(V3D_FOCUSED,pv1);
        runCR(RUN_V3D_processOneViewer,_main,io(opt),pv1);
        v3dSetTitle(pv1);
        if(0!=(opt&V3D_OPEN_INIT_SCRIPT)) v3dSendCommand(V3DCMD_render+" --late",pv1);
        else v3dSendCommand(V3DCMD_center_amino,pv1);
    }
#endif //CPP_WITH_GUI
    V3D_MAP_ID_TO_VV.put(plrl(++_v3dOpenCount,"V3D %n"),v3dSameViewV(pv1));
    return pv1;
}
#undef gui
/* <<<  open3dViewer <<< */
/* ---------------------------------------- */
/* >>> ID >>> */
public static View3d v3dForId(String id){
    return IF_GUI(sze(id)==0?v3dGetPV(V3D_FOCUSED):) derefZ(iThEl(0,V3D_MAP_ID_TO_VV.get(id)),View3d.class);
}
public static String v3dId(View3d v){
    if(v!=null) for(Map.Entry<String,Collection>e:entryArry(V3D_MAP_ID_TO_VV)) if(cntainsEl(v,e.getValue())) return e.getKey();
    return null;
}
/* <<< ID  <<< */
/* ---------------------------------------- */
/* >>> Atoms for Selection3D >>> */
public static void v3dChangeSelection3D(IF_GUI(boolean isGeneric,) Selection3D ss[],String expr){
    if(ss!=null){
        final String[]aa=IF_GUI(!isGeneric?null:)v3dSplitAtoms(expr);
        ROFi0(ss.length){
            if(ss[i]!=null && !(IF_GUI(isGeneric&&)eqArry(EQARRY_EQUALS,aa,s3dAtoms(ss[i])))){
                ss[i]=new Selection3D(IF_GUI(!isGeneric?S3D_NEW_INSTANCE_CHANGE_NATIVEATOMS:)S3D_NEW_INSTANCE_CHANGE_ATOMS,
                                      ss[i],
                                      IF_GUI(!isGeneric?expr:)aa);

            }
        }
    }
}
#define _v3dCacheSplitAtoms mapSoft(325)
private static String[]v3dSplitAtoms(String s){
    if(sze(s)==0) return NO_String;
    String[]atoms=(String[])_v3dCacheSplitAtoms.get(s);
    if(atoms==null){
        atoms=splitTkns('.',s);
        Collection v=null;
        ROFi0(atoms.length){
            final String a=atoms[i];
            final int L=sze(a);
            final boolean asteriskB=a.charAt(0)=='*',asteriskE=lstChar(a)=='*';
            if(asteriskB || asteriskE){
                for(String aType:arry(SARRAY_atomsOfAminos)){
                    final int longer=sze(aType)-L+1;
                    if(longer<0) continue;
                    if(asteriskB && xstrEquAt(0,a,1,L,aType,longer,MAX_INT)||
                       asteriskE && xstrEquAt(0,a,0,L-1,aType,0,MAX_INT)){
                        v=adUniqNew(aType,v);
                        atoms[i]=null;
                    }
                }
            }
            if(v!=null){
                adAllUniq(atoms,v);
                atoms=toStrgArray(0,v);
            }
        }
        _v3dCacheSplitAtoms.put(s,atoms);
    }
    return atoms;
}
/* <<< Atoms for Selection3D<<< */
/* ---------------------------------------- */
/* >>> Create Selection3D >>> */

public static void v3dSetSelection3D(int selectCmd,Selection3D[]atoms,String id,View3d pv){
    if(atoms!=null){
        v3dSendCommand(new BA(99).or(iConst(SARRAY_STRAP_SCRIPT_CMD,selectCmd),V3DCMD_select).aa(' ',v3dSelection3dToTextSameChain(V3D_GENERIC,atoms)),pv);
        _v3dAfterSel3D(selectCmd,atoms,id,pv);
    }
}
private static void _v3dAfterSel3D(int selectCmd,Selection3D[]atoms,String id,View3d pv){
    if(atoms==null || sp(pv)==null) return;
    IF_GUI(if(pv instanceof Simple3D) {runCR(RUN_V3D_setSelectionSimple3D,_main,atoms,IF_CHECK_CODE((Simple3D))pv); return;})
        if(isChrClas(LETTR,id,0)){
            if(v3dIsSupporting(iV3DCMD_select_save,pv)) v3dSendCommand(new BA(99).a(V3DCMD_select_save+" ").aFilter(FILTER_NO_MATCH_TO_US|LETTR_DIGT_US,id),pv);
            pcp(V3D_KEY_SEL_ID,id,pv);
        }
    pcp(V3D_KEY_SEL_ATOM,selectCmd==iV3DCMD_select_cut||selectCmd==iV3DCMD_select_rm?null: atoms,pv);
    IF_GUI(v3dSetTitleStyleMenu(pv));;
}
public static Selection3D[]textToSelection3D(CPP_AS_OBJECT(CharSequence)text,Protein p){
    if(text==null || sze(text)==5&&V3D_SELECT_NONE.equals(s(text))) return Selection3D.NONE;
    final int[]opts={0};
    final byte[]T=toByts(v3dReplaceVars(V3D_GENERIC,text,p));
    if(nxt(0,chrClas(-SPC),T)<0) return Selection3D.NONE;
    final ChTokenizer TOK=toknzr(348,SPACE_COMMA).setText(T,0,MAX_INT);
    final Collection<Selection3D>v=new ArrayList();
    while(TOK.nextToken()){
        String nativeA,atoms[];
        final int B=TOK.from(),E=TOK.to(),endGrp=nxt(STR_E,chrClas(SPC),T,B,E),colon=strchr(':',T,B,endGrp);
        {
            final int atomsB=strchr('.',T,B,endGrp),atomsE=atomsB<0?-1:nxt(STR_E,chrClas(SPC),T,atomsB,E);
            nativeA=strEquAt(0,".NATIVE",T,atomsB)?s(hex2bin(T,atomsB+7,atomsE)):null;
            atoms=nativeA!=null||atomsB<0?null: v3dSplitAtoms(s(T,atomsB,atomsE));
        }
        if(chrAt(B,T)=='$'){
            final int m=strEquAt(STR_w_R,V3D_SELECT_DNA,T,B)?CHAINTYPE_DNA: strEquAt(STR_w_R,V3D_SELECT_RNA,T,B)?CHAINTYPE_RNA:0;
            if(m!=0){
                for(Protein h:p.getMolecules(m)) v.add(new Selection3D(0,INT_NAN,'\0',INT_NAN,'\0',h.getChain(),atoms));
                continue;
            }
            if(strEquAt(STR_w_R,V3D_SELECT_ALL,T,B)) opts[0]|=SEL3D_ALL;
            if(strEquAt(STR_w_R,V3D_SELECT_AMINOACID,T,B)) opts[0]|=SEL3D_AMINOACIDS;
        }
        final int noWord1=nxt(STR_E,chrClas(-LETTR_DIGT_US),T,B+1,E);
        String chain=null,error=null;
        if(looks(LIKE_INTEGER,T,B,E)){
            char insF=0,insL=0;
            {
                final int noDigt=nxt(STR_E,chrClas(-DIGT),T,B+1,E);
                if(isChrClas(LETTR_DIGT_US,T,noDigt)) insF=insL=(char)T[noDigt];
            }
            final int resF=atoi(T,B,E);
            int resL=resF;
            if(iThByte(noWord1,T)!=0){
                final int dashPos=
                    T[noWord1]==':'&&chrAt(noWord1+1,T)=='-'?noWord1+1:
                    T[noWord1]==':'&&chrAt(noWord1+2,T)=='-'?noWord1+2:
                    T[noWord1]=='-'?noWord1:
                    -1;
                if(dashPos>0){
                    if(!looks(LIKE_INTEGER,T,dashPos+1,E)) error="Number expected after \"-\" ";
                    else{
                        resL=atoi(T,dashPos+1,E);
                        final int posIns=nxt(STR_E,chrClas(-DIGT),T,dashPos+2,E);
                        insL=isChrClas(LETTR_DIGT_US,T,posIns)?(char)T[posIns]:'\0';
                    }
                }
            }
            chain=colon>0?pdbChainAt(T,colon+1,endGrp):null;
            if(resF<=resL||fstNotNull(atoms)!=null||chain!=null) v.add(new Selection3D(S3D_NEW_INSTANCE_CHANGE_NATIVEATOMS,
                                                                                   new Selection3D(opts[0],resF,insF,resL,insL,chain,atoms),
                                                                                   nativeA));  /*X  Example: b1_SaccharomycesCerevisiae.pdb 105 und 187 */
        }else if(T[B]!='.'){
            v.add(new Selection3D(S3D_NEW_INSTANCE_CHANGE_NATIVEATOMS,
                                  new Selection3D(opts[0],rmQuotes('"',s(T,B,noWord1)),chain,atoms),
                                  nativeA));
        }
        if(error!=null) baOut(RED_WARNING).a(" in toSelectionT:").aFT(T,B,E).a1(' ').aln(error);
    }
    clr(TOK);
    return toArry(v,Selection3D.NONE);
}
public static Selection3D[]boolToSelection3D(int opt,boolean[]bb,int offset,Protein p,String atoms){
    final int last=lstTrue(bb);
    if(p==null || last<0) return Selection3D.NONE;
    final Collection<Selection3D>v=new ArrayList();
    final byte[]ri=p.getResidueInsCode();
    final int nR=mini(0!=(opt&RESIDUE_FULL)?p.countResidues(): p.subsetEnd()-p.subsetStart(),last+1+offset);
    for(int i=maxi(0,offset);i<nR;){
        final int rn1=p.resnAt(opt,i);
        if(!bb[i-offset] || INT_NAN==rn1){
            i++;
            continue;
        }
        int i2=i+1;
        while(i2<nR && bb[i2-offset] && p.residueHasXYZ(0!=(opt&RESIDUE_FULL),i2)) i2++;
        if(i2<=nR){
            final int k=0!=(opt&RESIDUE_FULL)?i:i+p.subsetStart();
            v.add(new Selection3D(0,rn1,(char)iThByte(k,ri),p.resnAt(opt,i2-1),(char)iThByte(i2-k,ri),p.getChain(),v3dSplitAtoms(atoms)));
        }
        i=i2;
    }
    return toArryClr(v,Selection3D.NONE);
}

/* ---------------------------------------- */
/* >>> from Selection3D >>> */
/* ( /b1_SaccharomycesCerevisiae and (////10-20    ////99));  */
#define isP (viewerId==V3D_PYMOL)
#define isJ (viewerId==V3D_JMOL)
#define isA (viewerId==V3D_ASTEX)
#define isR (viewerId==V3D_RASMOL)
#define isG (viewerId==V3D_GENERIC)
#define isObj (viewerId==-1)
public static String v3dSelection3dToTextSameChain(int viewerId,Selection3D[]ss){
    if(fstNotNull(ss)==null) return V3D_SELECT_NONE;
    final boolean isJR=isJ||isR;
    final BA sb=new BA(99);
    if(isA||isP||isJR) sb.a('(');
    FORi(0,ss.length){
        final Selection3D s=ss[i];
        if(s==null) continue;
        if(i>0){
            if(isA||isP||isJR) sb.a(" or ");
            else if(isObj) sb.a("or");
            else sb.a1(' ');
        }
        final String name=s3dResidueName(s);
        final int end0=sb.end();
        if(isA) sb.a(" ( ");/*X  Bugfix */
        int pCountSlash=0;
        if(name!=null && isG){
            sb.aa(name," ");
        }else if(V3D_SELECT_ALL.equals(name)){
            sb.a(isA||isJR?" all ": isP?"/": "");
        }else if(V3D_SELECT_NONE.equals(name)){
            sb.a(isA||isJR||isP?" none ": "");
        }else if(name!=null){
            if(isJR)sb.aa(" [",name,"] ");
            if(isA) sb.aa(" name ",name);
            if(isP) sb.aa(" resn ",name);
        }else if(0!=(s3dOptions(s)&SEL3D_AMINOACIDS)){
            if(sb.end()>end0 && isA||isJR||isP) sb.a1(' ').a("and");
            sb.a1(' ').a(isA?"aminoacid ": isJR?"amino ": isG?V3D_SELECT_AMINOACID+" ": isP?"not het ": "");/*X Todo no DNA no RNA */
        }else if(0!=(s3dOptions(s)&SEL3D_ALL)){
            if(nxt(chrClas(LETTR),sb,end0,MAX_INT)>=0 && isA||isJR||isP) sb.a1(' ').a("and");
            if(isA) sb.a1(' ').a("all");
        }else{
            final char insF=s3dFirstInsCode(s),insL=s3dLastInsCode(s);
            final int fst=s3dFirst(s),lst=s3dLast(s),f,l;
            if(isA && insL!=0){/*X Astex insertion code */
                final int insTmp=fst==lst && IS_UPPER_OR_LOWER(insF)?insF: 'A';
                if(insTmp<=insL || insL==0){
                    sb.aa(" (residue ",lst);
                    //if(insL==0) sb.a(" and insertion ' ' ");                    else
                    {
                        sb.a(" and (");
                        for(int ins=insTmp;ins<=insL;ins++) sb.aa("insertion '",(char)ins,"' or ");
                        sb.del(" or ").a(')');
                    }
                    sb.a(")or ");
                }
                l=lst-1;
            }else{
                l=lst;
            }
            if(isA && insF!=0 && fst!=lst){
                sb.aa(" (residue ",fst);
                if(insF==0) sb.a(" and insertion ' ' ");
                else FORc('A',insF) sb.aa(" and not insertion '",(char)c,'\'');
                sb.a(")or ");
                f=fst+1;
            }else{
                f=fst;
            }
            if(f<=l){
                final String chain=s3dChain(s);
                if(isA) sb.a(" residue ");
                if(isP) {sb.an('/',3).aa(chain,'/'); pCountSlash=4;}
                sb.a(f);
                if(insF!=0){
                    if(isG||isObj||isP) sb.a(insF);
                    if(isJR) sb.aa('^',insF);
                }
                if(f<l || insF!=insL){
                    if(isA||isObj) sb.a(" to ");
                    else sb.a('-');
                    sb.a(l);
                    if(insL!=0){
                        if(isG||isObj||isP) sb.a(insL);
                        if(isJR) sb.aa('^',insL);
                    }
                }
                if(chain!=null){
                    if(isJR||isG) {sb.a(':'); if(isG||"_".equals(chain)) sb.a(chain);}
                    if(isObj) sb.aa('c',chain);
                }
            }
            if(isA) sb.del("or ");
        }
        {
            final String nativeA=s3dNativeAtoms(s);
            if(sze(s3dAtoms(s))+sze(nativeA)>0){
                sb.del(' ');
                if(isP) sb.an('/',5-pCountSlash);
                if(isA||isJR) sb.a(" and ");
                if(isJR) sb.a('(');
                if(sze(nativeA)>0){
                    if(isObj) sb.a(nativeA.hashCode());
                    else if(!isG) sb.a(nativeA);
                }else{
                    if(isA) sb.a1(' ').a("atom ");
                    FORat(0,sze(s3dAtoms(s))){
                        final String a=s3dAtoms(s)[at];
                        if(0<at) sb.a(isJR?" or ": isP?",": isA?" ": "");
                        if(isObj) sb.a('a');
                        if(isJR) sb.a("*.");
                        if(isG) sb.a('.');
                        if(isA||isP||isG||isJR||isObj) sb.a(a);
                    }
                }
                if(isJR) sb.a(')');
                if(isG && sze(nativeA)>0) sb.aa(".NATIVE",bin2hex(nativeA.getBytes(),0,MAX_INT));
            }
        }
        if(isA) sb.a1(' ').a(')').replace(0,"( and ","( ");/*X  Bugfix */
    }
    if(isA||isP||isJR) sb.a1(' ').a(')');
    return s(sb.trim());
}
#undef isP
#undef isJ
#undef isA
#undef isR
#undef isG
#undef isObj

public static boolean[]selection3dToBoolZ(Selection3D[]atoms,Protein p,boolean[]bb){
    if(p==null || fstNotNull(atoms)==null) return NO_boolean;
    bb=redim(bb,p.countRes(),99|REDIM_CLEAR_ARRAY);
    for(Selection3D a:atoms){
        if(eqStr(p.getChain(),s3dChain(a))){
            final int fst=p.resnToIdx(0,s3dFirst(a),s3dFirstInsCode(a));
            if(fst>=0){
                final int lst=p.resnToIdx(0,s3dLast(a),s3dLastInsCode(a));
                if(lst>=fst) setTrue(fst,mini(bb.length,lst+1),bb);
            }
        }
    }
    return bb;
}
/* <<< from Selection3D <<< */
/* ---------------------------------------- */
/* <<< ResidueSelection <<< */
public static boolean v3dApplyResSel(final int option,ResidueSelection[]ss,View3d[]vv,String nameIn3D){
    int opt=option|V3D_RESSEL_NO_RECURSION;
    boolean success=false;
    if(opt!=option){
        final int optNoCmd=opt&~(V3D_RESSEL_COMMANDS|V3D_RESSEL_COLOR);
        if(opt!=optNoCmd){
            success=v3dApplyResSel(opt,ss,vv,null);
            if(0!=(opt&V3D_RESSEL_SKIP_WITHOUT_COMMAND)) return success;
            opt=optNoCmd;
        }
    }
    IF_GUI(String error=null);;
    final Set vShared=new HashSet();
    View3d pvSel=null;
    for(ResidueSelection s:ss){
        final Protein prot=sp(s);
        if(prot==null) continue;
        clr(vShared);
        final ResidueAnnotation a=derefResan(s);
        if(0!=(opt&V3D_RESSEL_SKIP_WITHOUT_COMMAND) && (a==null||a.value(IRESAN_VIEW3D)==null)) continue;
        for(View3d v:vv!=null?vv: prot.get3dViews()){
            final Protein p=sp(v);
            if(0!=(V3D_RESSEL_SAME_PROTEIN&opt) && prot!=p) continue;
            final boolean[]bb=resSelMapPosZ(new ResidueSelection[]{s},p);
            if(fstTrue(bb)<0){
                IF_GUI(error="The selected residues do not map to the protein");;
                continue;
            }
            String atomExpr=null;
            if(runCR(RUN_IS_ENABLED,a)==TRUEr){
                Selection3D[]atoms=null;
                final ResidueAnnotation.Entry[]ee=a.entries();
                boolean hasColorCmd=false;
                for(int i=0;i<=ee.length;i++){
                    final String k=ee.length==i?null:ee[i].key();
                    if(k!=null && !ee[i].isEnabled()) continue;
                    final int ki=ee.length==i?-1:ee[i]._ki;
                    final String val=k==null?null:ee[i].value();
                    if(ki==IRESAN_ATOMS) {atomExpr=val; atoms=null;}
                    if(0!=(opt&(V3D_RESSEL_COMMANDS|V3D_RESSEL_COLOR)) IF_GUI(&&!(v instanceof Simple3D))){
                        CharSequence send=null;
                        if(k!=null && sze(val)>0){
                            send=//k.equals(cn)||k.equals(scn)?V3DCMD_native+scn+","+val:
                                ki==IRESAN_VIEW3D?addPfx("3D_",val):null;
                            if(strStarts(V3DCMD_color,send)) hasColorCmd=true;
                        }
                        if(send!=null || k==null&&0!=(V3D_RESSEL_NAMES_FROM_RESSEL&opt) || atomExpr!=null || k==null && !hasColorCmd){
                            if(atoms==null){
                                v3dSetSelection3D(0,
                                                  atoms=boolToSelection3D(0,bb,0,p,atomExpr),
                                                  0==(V3D_RESSEL_NAMES_FROM_RESSEL&opt)?null:
                                                  s(baClr(140).aFilter(FILTER_NO_MATCH_TO_US|LETTR_DIGT,prot).a('_').aFilter(FILTER_NO_MATCH_TO_US|LETTR_DIGT,a.getName())),
                                                  //0==(V3D_RESSEL_NAMES_FROM_RESSEL&opt)?null:s(new BA(99).aFilter(FILTER_NO_MATCH_TO_US,LETTR_DIGT,a!=null?a.getID():s)),
                                                  v);
                            }
                            if(k==null && !hasColorCmd)  send=new BA(99).a(V3DCMD_color+" #").aFT(getColrO(s),0,8);
                            v3dSendCommand(resSelReplaceVariable(send,a),v);
                        }
                    }
                }
            }
            if(0==(opt&(V3D_RESSEL_COMMANDS|V3D_RESSEL_COLOR)))  v3dSetSelection3D(vShared.add(v3dSharedMap(v))?0:iV3DCMD_select_add,boolToSelection3D(0,bb,0,p,atomExpr),nameIn3D,v);
            pvSel=v;
            if(0==(opt&(V3D_RESSEL_COMMANDS|V3D_RESSEL_COLOR|V3D_RESSEL_NOT_HIGHLIGHT)))  v3dSendCommand(V3DCMD_highlight_selected_amino_acids,v);
        }
        IF_GUI(if(pvSel!=null && 0!=(opt&V3D_RESSEL_SET_FOCUSED_PV) && !(pvSel instanceof Simple3D)) v3dSetPV(V3D_FOCUSED,pvSel));;
    }
    IF_GUI(if(error!=null && 0!=(opt&V3D_RESSEL_REPORT_ERROR)) error(error));;
    return success || pvSel!=null;
}
/* ---------------------------------------- */
/* >>> Variables >>> */
public static String v3dProtName(Object p){
    return s(baClr(141).aFilter(FILTER_SINGLE_US|FILTER_NO_MATCH_TO_US|LETTR_DIGT_US,baClr(142).a(p=sp(p)).delIC(arry(SARRAY_COMPRESS_SUFFIX)).delIC(arry(SARRAY_DOT_PDB_ENT_CIF))));
}
// 3036
public static CPP_AS_OBJECT(CharSequence) v3dReplaceVars(int type,CPP_AS_OBJECT(CharSequence)txt,Protein p){
    if(strchr('$',txt)>=0){
        for(String var:arry(SARRAY_SELECTION_ALIASES_3D)){
            if(strstr(STR_w_R,var,txt)<0) continue;
            final BA sb=baClr(143);
            Object rplc=null;
            switch(var.hashCode()){
            case CPP_HASHCD(V3D_SELECT_HETERO):
                //case CPP_HASHCD(V3D_SELECT_DNA):
                //case CPP_HASHCD(V3D_SELECT_RNA):
                //for(Protein h:p.getMolecules(var==V3D_SELECT_RNA?CHAINTYPE_RNA:var==V3D_SELECT_DNA?CHAINTYPE_DNA:CHAINTYPE_DNA)) sb.aa(h.getName(),' ');
                for(Protein h:p.getMolecules(CHAINTYPE_HET)) sb.aa(h.getName(),' ');
                rplc=sb;
                break;
            case CPP_HASHCD(V3DVAR_COLOR):
                rplc=sb.a(type==V3D_ASTEX?"0x":"#").aFT(orO(getColrO(p),"FF00FF"),0,6);
                break;
            case CPP_HASHCD(V3DVAR_PROTEIN):
                rplc=v3dProtName(p);
                break;
            case CPP_HASHCD(V3D_SELECT_NTERM):
            case CPP_HASHCD(V3D_SELECT_FIRST_LAST):
            case CPP_HASHCD(V3D_SELECT_CTERM):{
                final int section=var==V3D_SELECT_NTERM?FSTLST_NTERM: var==V3D_SELECT_CTERM?FSTLST_CTERM:FSTLST_NTERM_CTERM;
                final int idxF=p.firstLastResidueWithXyz()[section*2],idxT=p.firstLastResidueWithXyz()[section*2+1];
                rplc=sb;
                if(type==V3D_ASTEX) sb.a("(residue ");
                if(idxF<0 || idxT<0){
                    rplc=var==V3D_SELECT_FIRST_LAST?"aminoacid": V3D_SELECT_NONE;
                }else{
                    final int opt=type==V3D_ASTEX?RESIDUE_NO_CHAIN|RESIDUE_FULL|RESIDUE_NO_INS: RESIDUE_NO_CHAIN|RESIDUE_FULL;
                    p.resnAsText(opt,idxF,sb);
                    p.resnAsText(opt,idxT,sb.a(type==V3D_ASTEX?" to ":"-"));
                    if(type==V3D_ASTEX) sb.a(')');
                    if(type==V3D_GENERIC) rplc=toBA(rplc).aa(':',p.getChain());
                }
#if CPP_DEACTIVATED
                if(ia>=0 && sb!=null){
                    sb.a(p.resnAt(RESIDUE_FULL,ia));
                    if(vType!=V3D_ASTEX) sb.aCharClas(chrClas(LETTR),chrAt(ia,ii));
                }
                ...
                    if(v3dFirstResn(c1,type,p,sb)<0 || v3dFirstResn(c2,type,p,sb.a(type==V3D_ASTEX?" to ": "-"))<0){
                        rplc=null;
                        rplc=c1=='f'?"aminoacid": V3D_SELECT_NONE;
                    }else{
                        if(type==V3D_GENERIC) rplc=toBA(rplc).aa(':',p.getChain());
                        if(type==V3D_ASTEX) sb.a(')');
                    }
#endif //CPP_DEACTIVATED
            }
            }
            if(rplc!=null) txt=toBA(txt).replace(STR_w_R,var,rplc);
        }
    }
    return txt;
}
/* <<< Variables <<< */
/* ---------------------------------------- */
/* >>> Script >>> */
public static long v3dRgbInScript(Object command){
    for(int cmd:intArry(RSC_INTS_V3D_COMMANDS_WITH_COLOR)){
        if(strstr(STR_w,iConst(SARRAY_STRAP_SCRIPT_CMD,cmd),command)>=0){
            final String[]vv=arry(SARRAYeq_STRAP_VARS);
            if(strstr(STR_w_R,vv[VAR_COLOR_AS_PROTEIN],command)>=0) return RGBA_INHERIT;
            if(strstr(STR_w_R,vv[VAR_COLOR_AS_RESIDUE],command)>=0) return RGBA_NONE;
            final int h=strchr('#',command);
            return h>=0?v3dRgbInScriptAt(h+1,command): -1;
        }
    }
    return RGBA_NONE;
}
public static long v3dRgbInScriptAt(int i,Object s){
    final int e=nxt(STR_E,chrClas(-HEX_DIGT),s,i,MAX_INT);
    return e-i!=6 && e-i!=8?-1:Long.parseLong(s(s,i,e),16) | (e-i==8?0: 255L<<24);
}

/* <<< Script utils <<< */
/* ---------------------------------------- */
/* >>> Script >>> */
public static void v3dSendCommand2(Object command,View3d[]vv){
    Collection v=null;
    final boolean[]todo=setTrue(0,sze(vv),null);
    while(fstTrue(todo)>=0){
        if(clr(v)==null) v=new ArrayList();
        Collection v1=null;
        FORi(0,todo.length){
            if(vv[i]==null) todo[i]=false;
            else if(todo[i]){
                final Collection v2=v3dSameViewV(vv[i]);
                if(v1==null || v1==v2){
                    v1=v2;
                    v.add(vv[i]);
                    todo[i]=false;
                }
            }
        }
        v3dSendCommand(command,v3dToArry(v));
    }
}

/** @param pvv: 3D-views that are displayed in the same canvas */
IF_MEIN_DEBUG(static { assert RSC_MULTI_INIT_LATE==RSC_MULTI_INIT+1;});;
public static void v3dSendCommand(Object script,View3d...pvv){
    final View3d pv1=(View3d)fstNotNull(pvv);
    if(pv1==null) return;
    {
        final int n=szeVA(script);
        if(n>=0){
            FORi(0,n) v3dSendCommand(iThEl(i,script),pvv);
            return;
        }
    }
    if(strchr('\n',script=toStrgTrim(script))>0){
        v3dSendCommand(splitTkns('\n'|SPLIT_TRIM,script),pvv);
    }else if(sze(script)>0){
        v3dLog(0,pv1,script);
        final int cmd=v3dCmdInLine(script);
        int alreadySelect=0;
        for(View3d pv:pvv){
            final Protein p=sp(pv);
            if(p==null) continue;
            final AbstractView3d wpv=v3dForHtml(pv);
            if(cmd==iV3DCMD_hide_everything){
                for(int sc:intArry(RSC_INTS_V3D_STYLE_COMMANDS)) if(v3dIsSupporting(sc,pv)) v3dSendCommand(addPfx(iConst(SARRAY_STRAP_SCRIPT_CMD,sc)," off"),pv);
            }else if(cmd==iV3DCMD_select){
                runCR1(RUN_INTERPRET_COMMAND,pv,alreadySelect++==0?script: addPfx(V3DCMD_select_add,delPfx(V3DCMD_select,script)));
            }else if(cmd==iV3DCMD_render){
#if CPP_WITH_GUI
@*SARRAYeq_RSC_EARLY_LATE
                 --early=RSC_MULTI_INIT --late=RSC_MULTI_INIT_LATE
*@
                if(wpv==null){
                    final BA txt=new BA(333);
                    FORt(RSC_MULTI_INIT,RSC_MULTI_INIT_LATE+1) if(((String)script).indexOf(iConst(SARRAYeq_RSC_EARLY_LATE,t))<0)  txt.joinLns(bidSettings(bidForClass(pv),t));
                    pv.setProperty(VIEW3D_NO_LOG,"");
                    v3dSendCommand(txt.lines(),pv);
                    pv.setProperty(VIEW3D_NO_LOG,null);
                } else
#endif //CPP_WITH_GUI
                    wpv.pseudoCommand("AA_RENDER(");
            }else IF_GUI(if(cmd==0 || v3dIsSupporting(cmd,pv1)||v3dForHtml(pv1)!=null)){
                    String s=(String)script;
                    if(cmd==0) newScriptInterpreter().siInterpretScript(0,s);
                    else{
                        if(s.indexOf(V3DVAR_PROTEIN_COLOR)>0){
                            if(getColrO(p)!=null) s=s(strplc(0,V3DVAR_PROTEIN_COLOR,new BA(7).aa('#',getColrO(p)),s));
                            else if(cmd==iV3DCMD_color) return;
                            else if(cmd==iV3DCMD_cartoon) s=s(strplc(0,V3DVAR_PROTEIN_COLOR,"",s));
                        }
                        runCR1(RUN_INTERPRET_COMMAND,pv,s);
                    }
                    return;/*X  Only for one*/
                }
        }
    }
}
/* <<< Scripting 3D <<< */
/* ---------------------------------------- */
/* >>> Log 3D >>> */
/*      Record commands SCRIPT_select_3D SCRIPT_open_3D and all View3d commands    */
public static Collection v3dRecordGeneric(Object add,View3d pvWeb){/*X  Only those created by script commands */
    final AbstractView3d pv=v3dForHtml(pvWeb);
    if(pv==null) return null;
    final Collection v=(Collection)pv.getProperty(AVIEW3D_GET_RECORD_GENERIC_COMMANDS);
    v.add(add instanceof BA?((BA)add).newBytes(): add);
    return v;
}
public static BA v3dLog(int opt,View3d pv,Object cmd){/*X cmd is CharSequence*/
    boolean ok=strStarts("3D_",cmd)==(0==(opt&V3D_LOG_NATIVE)) && sze(cmd)>0;
    if(ok){
        if(0==(opt&V3D_LOG_NATIVE)){
            if(prgOptOn(iPAR_LOG3D))  baOut(ANSI_FG_GREEN).aa(shrtClasNamOrAlias(pv).toUpperCase(),"> "+ANSI_RESET).aln(cmd);
        }else{
            if(prgOptOn(iPAR_LOG3DG)) baOut(ANSI_FG_MAGENTA).aa(shrtClasNamOrAlias(pv),"> "+ANSI_RESET).aln(cmd);
        }
    }
#if CPP_WITH_GUI
    final Protein p=sp(pv);
    if(p!=null){
        //final Object key=pcpKey(ECHOcond(0==(opt&V3D_LOG_NATIVE)?)ECHOref(V3D_KEY_LOGGER_G):ECHOref(V3D_KEY_LOGGER_N));
        final Object key=0==(opt&V3D_LOG_NATIVE)?pcpKey(ECHOref(V3D_KEY_LOGGER_G)): pcpKey(ECHOref(V3D_KEY_LOGGER_N));
        final Map map=v3dSharedMap(pv);
        BA log=(BA)map.get(key);
        if(log==null) map.put(key,log=(BA)(0==(opt&V3D_LOG_NATIVE)?
                                           runCR1(RUN_V3D_initLogGen,v3dSharedUtils(pv),pv):
                                           runCR1(RUN_V3D_initLog,v3dSharedUtils(pv),pv)));
        if(0!=(opt&V3D_LOG_NATIVE) || pv.getProperty(VIEW3D_NO_LOG)==null){
            if(ok){
                //            if(p!=map.put(pcpKey(ECHOcond(0==(opt&V3D_LOG_NATIVE)?)ECHOref(V3D_KEY_LOGGER_PROTEIN_G):ECHOref(V3D_KEY_LOGGER_PROTEIN_N)),p)){
                if(p!=map.put(0==(opt&V3D_LOG_NATIVE)?pcpKey(ECHOref(V3D_KEY_LOGGER_PROTEIN_G)):pcpKey(ECHOref(V3D_KEY_LOGGER_PROTEIN_N)),p)){
                    log.a('#').an('-',20).aln().a(SCRIPT_select_3D_KOMMA).aln(p);
                }
                log.aln(cmd);
            }
            return log.send();
        }
    }
#endif //CPP_WITH_GUI
    return null;
}
/* <<< Log 3D <<< */
/* ---------------------------------------- */
/* >>> View3d and Proteins >>> */
public static AbstractView3d v3dForHtml(View3d v) {return v==null||v.getClass()!=AbstractView3d.class?null:(AbstractView3d)v;}
public static boolean v3dFlag(int f,View3d v) {return v!=null&&0!=(f&xatoi(v.getProperty(VIEW3D_GET_FLAGS)));}
public static boolean v3dIsSupporting(int cmd,View3d v){
    if(cmd==iV3DCMD_native) return true;
    if(null==v||null==iConst(SARRAY_STRAP_SCRIPT_CMD,cmd)) return false;
    IF_GUI(if(cmd==iV3DCMD_hide_everything) return!(v instanceof Simple3D));;
    return idxOf(cmd,(int[])v.getProperty(VIEW3D_GET_SUPPORTED_COMMANDS))>=0;
}
public static Protein[]v3dPP(View3d pv){
    final Collection v=v3dSameViewV(pv);
    final Protein[]pp=new Protein[sze(v)];
    ROFi0(pp.length) pp[i]=sp(iThEl(i,v));
    return rmNullPP(pp);
}
public static Collection<View3d>v3dSameViewV(View3d pv){
    if(pv==null) return null;
    final Collection v=(Collection)pv.getProperty(VIEW3D_GET_SHARED_VIEWS);
    adUniq(pv,v);
    return v;
}
public static View3d v3dForProtein(Protein p,View3d pv){
    if(p!=null){
        final Collection v=v3dSameViewV(pv);
        ROFi0(sze(v)) if(sp(iThEl(i,v))==p) return(View3d)iThEl(i,v);
    }
    return null;
}
public static Map v3dSharedMap(View3d pv){
    if(pv==null) return null;
    final Map m=pv==null?null:(Map)pv.getProperty(VIEW3D_GET_SHARED_MAP);
    if(m==null) assrt();
    return m;
}
/* <<< View3d and Proteins <<< */
/* ---------------------------------------- */
