#define S3D_CE_MIN_CALPHA 16
/* >>> Base90 >>> */
#define B90_DIGITS (127-33-3)
#define B90_BLOCK '>'
#define B90_NAN '~'

/* (NUM1 1) */
/* --- */
#define BASE_ACTG (1<<8)
#define BASE_ACUG (2<<8)
#if CPP_WITH_SOAP
/* (NUM1 1) */
#define SOAP_EBI 2
#define SOAP_STATUS_RUNNING 1
#define SOAP_STATUS_FINISHED 2
#define SOAP_ASK_FOR_PERMISSION (1<<1)
#endif //CPP_WITH_SOAP
/* (NUM1 1) */
#define DBFETCH_SKIP_EXISTING (1<<1)
/* (NUM1 0) */
#define COMPV_NO_BLOCKING (1<<0)
/* --- */
#define SEVTMS_SHIFT 8
#define SEVTMS (1<<SEVTMS_SHIFT)

/* --- */
#define ALIP_PP_VISIBLE 1
/* (NUM1 16) Strap Context menu */
#define SXM_FLAG_CURSOR (1<<16)
#define SXM_FLAG_IMMUTABLE (1<<17)
#define SXM_FLAG_MB (1<<18)

/* (NUM1 18) warum nicht 0 */
/* ---------------------------------------- */
/* >>> DialogPublishAlignment >>> */
/* (NUM1 1) */
#define SSCRIPT_NO_RESSEL (1<<1)
#define SSCRIPT_SELECTED_RESSEL (1<<2)
#define SSCRIPT_NO_ICONS (1<<3)
#define SSCRIPT_PROJECT_COORDINATES (1<<4)
#define SSCRIPT_HIDDEN_RESSEL (1<<5)
#define SSCRIPT_SEQFEAT (1<<6)
#define SSCRIPT_HIDDEN_SEQ (1<<7)
#define SSCRIPT_3D (1<<8)
/* <<< DialogPublishAlignment <<< */
/* ---------------------------------------- */
/* >>>  >>> */

#define ALITXT_OFFSET_MASK 0xffFFFF
/* (NUM1 27) */
#define ALITXT_FASTA (1<<27)
#define ALITXT_PFX_p (1<<28)
#define ALITXT_FOLD_100 (1<<29)
#define ALITXT_PFX_SEQRES_ATOMS (1<<30)
#define ALITXT_ANSI (1<<31)
/* --- */

#define SCRLLPN_OPTS_PROTEINS (SCRLLPN_INHERIT_SIZE|SCRLLPN_EBORDER)
/*    (NUM1 16) */
#define LSTMDL_FLAG_TWO_JLIST (1<<16)
#define LSTMDL_FLAG_CREATE (1<<17)
#define LSTMDL_FLAG_UPDATE_NOW (1<<18)
/* (NUM1 1) */
#define V3D_SESSION_LOAD_PROTS (1<<1)
#define V3D_SESSION_NO_ASK (1<<2)
/* ---------- */
/* (NUM1 0) */
//CHAINTYPE_INFO_PDBID 0

#define SOBJECT_SET_RESSEL (1<<SOBJECT_RESSEL)|(1<<SOBJECT_RESAN)|(1<<SOBJECT_RESSEL_AND_RESAN)|(1<<SOBJECT_SEQFEAT)
#define SOBJECT_OPT_NOT_OPEN_MENU (1<<8)
#define SOBJECT_MASK (SOBJECT_OPT_NOT_OPEN_MENU-1)
/* (NUM1 1) */
#define CURSOR_COLUMN (1<<1)
/* (NUM1 0) */
#define SEQID_NEEDS_COLON (1<<0)
#define SEQID_PUT_COLON (1<<1)
/* (NUM1 0) */
#define RESIDUE_NO_CHAIN (1<<0)
#define RESIDUE_NO_INS (1<<1)
#define RESIDUE_FULL (1<<2)
#define RESIDUE_LAST (1<<3)
/* (NUM1 2) */
#define ALIGNER_FLAGS_USE_SECONDARY_STRUCTURE (1<<2)
#define ALIGNER_FLAGS_CHECK_PERFECT_MATCH (1<<3)
#define ALIGNER_FLAGS_NOT_TO_SECURITY_LIST (1<<4)
#define ALIGNER_FLAGS_LOCAL (1<<7)
#define ALIGNER_FLAGS_ONLY_TWO_SEQUENCES (1<<8)
#define ALIGNER_FLAGS_HAS_SCORE (1<<9)
#define ALIGNER_FLAGS_NEEDS_PROTEINS (1<<10)
#define ALIGNER_FLAGS_3D (1<<11)
#define ALIGNER_FLAGS_RETURNS_MATRIX (1<<12)
#define ALIGNER_FLAGS_RETURNS_GAPPED (1<<13)
#define ALIGNER_FLAGS_AT_LEAST_3_SEQS (1<<15)
#define ALIGNER_FLAGS_PROFILES_1 (1<<16)
#define ALIGNER_FLAGS_PROFILES_3 (1<<17)
#define ALIGNER_FLAGS_NO_CTRL_PNL (1<<18)
/* (NUM1 0) */
#define OPT_ALIGN_NO_ERROR (1<<0)
/*----------------------------------------*/
/* (NUM1 0) */
#define ALIGNRESULT_INDICES_OF_SEQUENCES 0
#define ALIGNRESULT_SCORE 1
#define ALIGNRESULT_RMSD 2
#define ALIGNRESULT_MATRIX 3
#define ALIGNRESULT_GAPPED 4
#define ALIGNRESULT_PROTEIN_MC 5
#define ALIGNRESULT_ZZZ 6
/* --- */

/* --- */

#define TYPE_ALIGN_RESULT Object[]
#define meinFloatObject(f) new Float(f)
/*----------------------------------------*/
/* >>> Parser >>> */
#define SEL3D_AMINOACIDS (1<<2)
#define SEL3D_ALL (1<<3)
#define S3D_PRINT_HUMAN_READABLE 1
#define S3D_COLUMN_SEQUENCE 10
/* (NUM1 1)  RETURN_THREAD */
#define PROTEIN_INSTANCE_FILE_OR_SEQUENCE (1<<1)
/* <<< Parser <<< */
/* ---------------------------------------- */
/* >>> Sequence Parser >>> */

/* --- */
/* Die loadp- and READP_ options waren vor 8/2018 separat.  Beobachte overlap _optLoad=LOADP_USE_UNIPROT_SOAP; */
/* (NUM1 1)  RETURN_THREAD ) */
#define LOADP_USE_UNIPROT_SOAP (1<<2)
#define LOADP_SCROLL (1<<3)
#define LOADP_PROCESS_LOADED_P (1<<5)
#define LOADP_EV_PP_ADDED (1<<6)
#define LOADP_SHOW_3D_ORPHAN_HETS (1<<7)
#define LOADP_EXTRACT_ENST (1<<8)

#define READP_NOT_ADD_TO_PEP (1<<10)
#define READP_NOT_MK_STRAPFORMAT (1<<11)
#define READP_PDB_NO_HASHMAP (1<<13)
#define READP_ONLY_HET_OR_NUC (1<<14)
#define S3D_PARSE_ALIGNMENT (1<<15)
#define S3D_PARSE_MATRIX (1<<16)
#define S3D_PARSE_SCORE (1<<17)
#define S3D_PARSE_MSA_START_S (1<<18)

#define PROTPARS_NO_SEQRES (1<<19)
#define PROTPARS_NO_HEADER (1<<20)
#define PROTPARS_NO_RESSEL (1<<21)
#define PROTPARS_NO_HETATM (1<<22)
#define PROTPARS_SEQUENCE_FEATURES (1<<23)
#define PROTPARS_NAME_FROM_FA_HEADER (1<<24)
#define PROTPARS_AS_DNA_OR_RNA (1<<25)

#define PROTPARS_AS_PEP (1<<26)
#define PROTPARS_FIRST_PEPTIDE (1<<27)
#define INFER3D_SHOW_BACKBONE (1<<28)
#define INFER3D_IF_NOT_ALREADY (1<<29)
#define INFER3D_NO_BLAST (1<<30)
/* --- */
#define PROTPARS_DEFAULT PROTPARS_SEQUENCE_FEATURES
/* <<< Sequence Parser <<< */
/* ---------------------------------------- */
/* >>> ProteinWriter  >>> */
/*X  PDBParser.writePdbOnlyChain */
/* (NUM1 1) */
#define SEQW_CALPHA_ATOMS (1<<1)
#define SEQW_SIDE_CHAIN_ATOMS (1<<2)
#define SEQW_ONLY_COORDINATES (1<<3)
#define SEQW_SEQRES (1<<4)
#define SEQW_SEQRES_IF_COORDINATES (1<<5)
#define SEQW_HETEROS (1<<6)
#define SEQW_ONLY_NT_STRUCTURE (1<<7)
#define SEQW_NT_STRUCTURE (1<<8)
#define SEQW_NUCLEOTIDES (1<<9)
#define SEQW_HELIX_SHEET (1<<10)
#define SEQW_MET_INSTEAD_OF_MSE (1<<11)
#define SEQW_IDX_FOR_RESNUM (1<<12)
#define SEQW_NO_OCCUPANCY (1<<13)
#define SEQW_PDB_TRAILING_SPC (1<<14)
#define SEQW_CHAINS_ABCD (1<<20)
#define SEQW_CHAIN_A (1<<15)
#define SEQW_CHAIN_B (1<<16)
#define SEQW_SHORT_ATOM_LINES (1<<17)
#define SEQW_GZ (1<<18)
#define SEQW_DIRECTLY_INTO_SB (1<<19)
#define SEQW_NICE_SPACING (1<<20)
#define SEQW_COMPLETE_CALPHA (SEQW_CALPHA_ATOMS|SEQW_SEQRES|SEQW_HELIX_SHEET|SEQW_HETEROS|SEQW_ONLY_NT_STRUCTURE)
#define SEQW_COMPLETE_PDB (SEQW_SEQRES|SEQW_HELIX_SHEET|SEQW_HETEROS|SEQW_ONLY_NT_STRUCTURE|SEQW_SIDE_CHAIN_ATOMS)
/* <<< Sequence Writer <<< */
/* ---------------------------------------- */
/* >>>   >>> */

/* (NUM1 1)  RETURN_THREAD */
#define RECT2VIS_CENTER (1<<1)
#define RECT2VIS_SHIFT_REPEAT 16
/* (NUM1 1)  RETURN_THREAD  FINDUP_* and SEQFEAT_* see sftrStartThreads( ... ) */

/* (NUM1 9) */
#define SEQFEAT_NOT_SEARCH_ID (1<<9)
#define SEQFEAT_SRC_CSA (1<<10)
#define SEQFEAT_SRC_FILE (1<<11)
#define SEQFEAT_SRC_UNIPROT (1<<12)
#define SEQFEAT_SRC_DAS (1<<13)
#define SEQFEAT_SRC_MODRES (1<<14)
#define SEQFEAT_OPT_CHECK_AVAILABILITY_ONLY (1<<16)
#define SEQFEAT_PUT_LOADED (1<<17)
#define SEQFEAT_LOG2SF (1<<18)
#define SEQFEAT_LOG2DAS (1<<19)
#define SEQFEAT_NOT_MAP_SYN (1<<20)
#define SEQFEAT_XML_FORMAT (1<<21)
/*Protein*/

#define XYZ90_PRECISION 1000
#define XYZ90_PRECISION_CALPHA 1000

/* (NUM1 0) */
#define XYZ_DISTANCE_ACCEPT_CALPHA (1<<1)
#define XYZ_DISTANCE_USE_CALPHA (1<<2)
#define XYZ_DISTANCE_YES_OR_NO (1<<3)

/* (NUM1 0 ) */
#define P_DRAG_MSA (1<<0)
#define P_DRAG_ALL_CHAINS (1<<1)
#define P_DRAG_ORIG (1<<2)
/* (NUM1 0 ) */
#define P_ADD (1<<0)
#define P_ADD_HETERO_UNIQUE (1<<1)
#define P_ADD_HETERO_APPLY_INVERSE_MX (1<<2)
/* --- */
#define PROTEINO_FLAG_ADD (1<<30)
#define PROTEINO_FLAG_IF_EMPTY (1<<31)
/* (NUM1 1 ) */
#define IF_NT (1<<1)
#define IF_CALPHA (1<<2)
#define IF_XYZ_MOVED (1<<3)
#define IF_PDB_ID (1<<4)
#define IF_EC (1<<5)
#define IF_IN_ALI (1<<6)
#define IF_NOT_IN_ALI (1<<7)
#define IF_ACTGN (1<<8)
#define IF_NT_or_ACTGN (1<<9)
#define IF_NOT_ACTGN (1<<10)
#define IF_NO_CALPHA (1<<11)
#define IF_IN_3D (1<<12)
#define IF_SECSTRU (1<<13)
#define IF_SOLVENT (1<<14)
#define IF_HETERO3D (1<<15)
#define IF_NUC3D (1<<16)
#define IF_INFERRED_3D (1<<17)
#define IF_NO_3D_FILE (1<<18)
#define IF_NO_PDB_ID (1<<19)
#define IF_MISMATCH3D (1<<20)
#define IF_RES_ANNO (1<<21)
#define IF_RES_SEL (1<<22)
#define IF_SEQ_FEATURE (1<<23)
#define IF_HAS_CDS_DATA (1<<24)
#define NEWPROTEINJLIST_SELECT_ALL (1<<25)
/* (NUM1 0 ) */
#define PFLAG_INTO_SAME_LINE (1<<0)
#define PFLAG_EXTERNAL (1<<1)
#define PFLAG_IS_IN_MSF (1<<2)
#define PFLAG_PROCESSED (1<<3)
#define PFLAG_WEBALI (1<<4)
#define PFLAG_IN_ALI (1<<6)
#define PFLAG_LOADED (1<<7)
#define PFLAG_TEMP (1<<8)
#define PFLAG_NO_EXONS (1<<9)
#define PFLAG_FROM_PDB_ZIP (1<<10)
#define PFLAG_RNUM_ASCENDING (1<<11)
#define PFLAG_JUST_READ (1<<12)
#define PFLAG_HAS_XYZ (1<<14)
#define PFLAG_HAS_CALPHA (1<<15)
#define PFLAG_ORIG_PDB (1<<16)
//PFLAG_BLAST4ID_UNIPROT (1<<17)
//  PFLAG_BLAST4ID_PDB (1<<18)
//PFLAG_ FROM_STRUCTURE_FILE (1<<11)
/* (NUM1 0 ) */

#define TO_RESAN_EDIT (1<<0)
#define TO_RESAN_ALSO_RETURN_UNCHANGED (1<<1)
/* (NUM1 0 ) */
#define RESANFLAG_FROM_FILE (1<<0)
#define RESANFLAG_COLOR_SET (1<<1)
#define RESANFLAG_SAVE (1<<2)
/* (NUM1 0 ) */
#define GPFLAGS_OPT_WEB (1<<0)
#define GPFLAGS_WIDE_GAPS (1<<1)
/* (NUM1 1 ) */
#define PDBID_ID (1<<1)
#define PDBID_INFERRED (1<<2)
#define PDBID_SUGGESTED (1<<3)
#define PDBID_SIMILAR (1<<4)
#define PDBID_NUM (1<<5)
#define PDBID_REQUIRES_CHAIN (1<<6)
#define PDBID_NOT_OVERWRITE (1<<7)
/* --- */
#define PDBID_ANY_STRICT (PDBID_ID|PDBID_INFERRED|PDBID_SUGGESTED|PDBID_SIMILAR)
#define PDBID_ANY_SIMILAR (PDBID_ANY_STRICT|PDBID_SIMILAR)
/* ------------------------------------------*/
/* (NUM1 3 RETURN_THREAD ) */
#define ALIGN_CHANGE_ORDER (1<<1)
/* (NUM1 3 RETURN_THREAD ) */
#define SUPERIMP_EVENT (1<<1)
#define SUPERIMP_COMPLEX_BEST (1<<2)

//(NUM1 1)
//SBUT_NUM 107
/* --- */
/*(NUM1 0)*/
#define SJCOMP_TF_ANIM_SPEED 0
#define SJCOMP_L 1
/* --- */
#if CPP_WITH_GUI
#define PROTEIN_BALLOON_MAXX EM
#endif //CPP_WITH_GUI
/* (NUM1 1) */
#define OBJRX_RESSEL (1<<1)
#define OBJRX_RESSEL_ANONYM (1<<2)
#define OBJRX_EXTRA_PP (1<<3)
#define OBJRX_EXTRA_PP_CREATE (1<<4)
#define OBJRX_WARN (1<<5)
/* (NUM1 4)  1<<4    SSTYLE_MASK+1 */
#define SFLAG_NO_ADD (1<<4)
#define SFLAG_NO_SAVE (1<<5)
/* (NUM1 0)   IMPORTANT: If changed then increment in Strap.pdbFileName(...)  */

/* (NUM1 1) */
#define VIEW3D_FLAG_OPENGL (1<<1)
#define VIEW3D_FLAG_SEQUENCE_CURSOR_DELAYED (1<<2)
#define VIEW3D_FLAG_RIBBON_COLOR_NO_CHANGE (1<<3)
#define VIEW3D_FLAG_HAS_CONTEXTMENU (1<<4)
#define VIEW3D_FLAG_NEEDS_UPDATE_SURFACES_WHEN_ROTATED (1<<5)
#define VIEW3D_FLAG_EXECUTABLE (1<<6)
/*X  E.G. Pymol */

/* (NUM1 0) */
#define V3D_OPEN_VERBOSE (1<<0)
#define V3D_OPEN_ASK (1<<1)
#define V3D_OPEN_SEND_ALL_ANNOTATIONS (1<<2)
#define V3D_OPEN_NOT_ADD_PANEL (1<<3)
#define V3D_OPEN_NARROW_OTHERS (1<<4)
#define V3D_OPEN_ADD_TAB (1<<5)
#define V3D_OPEN_INIT_SCRIPT (1<<6)
#define V3D_OPEN_EACH_PROTEIN_OWN_COLOR (1<<7)
#define V3D_OPEN_TO_HTML (1<<8)
#define V3D_OPEN_LOAD_NT (1<<9)
#define V3D_OPEN_EVEN_IF_NO_XYZ (1<<10)
#define V3D_OPEN_NOT_GENERATE_ID (1<<11)
/* --- */
/* (NUM1 1) */
#define V3D_RESSEL_COMMANDS (1<<1)
#define V3D_RESSEL_COLOR (1<<2)
#define V3D_RESSEL_NAMES_FROM_RESSEL (1<<3)
#define V3D_RESSEL_SAME_PROTEIN (1<<4)
#define V3D_RESSEL_REPORT_ERROR (1<<6)
#define V3D_RESSEL_NO_WIRE (1<<8)
#define V3D_RESSEL_NOT_HIGHLIGHT (1<<10)
#define V3D_RESSEL_SET_FOCUSED_PV (1<<11)
#define V3D_RESSEL_SKIP_WITHOUT_COMMAND (1<<12)
#define V3D_RESSEL_NO_RECURSION (1<<13)
/* (NUM1 12)  Bit 0-7 uniqIdx  Bit 16- row */

/* (NUM1 0) */
#define HL_TA_SEQS (1<<0)
#define HL_TA_RESAN (1<<1)
#define HL_TA_WORKING_DIR (1<<2)
#define HL_TA_REFS (1<<3)
/* ---*/

/* ================================================== */

#define thread_v3dOpen(opt,pp,clazzOrViewer,webDir)  CPP_thrdMS(v3dOpen,Strap,io(opt),pp,clazzOrViewer,webDir)
#define v3dVV(pv) v3dToArry(v3dSameViewV(pv))
#define PDB_APPEND_13_1234(id4,cif) aFilter(FILTER_TO_LOWER|LETTR_DIGT,id4,1,3).a('/').a(cif?null:"pdb").aFilter(FILTER_TO_LOWER,id4).a(cif?".cif.gz":".ent.gz")
/* <<<  <<< */
/* ---------------------------------------- */
/* >>> File >>> */
#define pdbImageUrl(id) s(iPath2(iURL_PDBJ_IMAGE_EQ,lCase(pdbID(id))))
#if CPP_PRG_AA
#define AA_ALIGNMENT2HTML_ZIP "alignment2html.zip"
#define STRAPOUT_FILES_TXT "strapOut/files.txt"
#define STRAPOUT_SEQUENCES_TXT "strapOut/sequences.txt"

#define XMATCH_SFX_DIR ".d/"
#define XMATCH_SFX_GFFFA (XMATCH_SFX_DIR+"gff_fa")
#define XMATCH_SFX_2BIT (XMATCH_SFX_DIR+"db.2bit")
#endif //CPP_PRG_AA
#define DND_FILE_PFX_HET "dnd_het_"
/*    (NUM1 0) */
#define SEQFILE_CHAIN 0
#define SEQFILE_CHAIN_BY_COLON 1
#define SEQFILE_EXT 2
#define SEQFILE_EXT3D 3
#define SEQFILE_BASE 4
#define SEQFILE_COMPRESS_SUFFIX 5
#define SEQFILE_SUBSET 6
#define SEQFILE_PATH 7
#define SEQFILE_NUM 8

/* <<< File <<< */
/* ---------------------------------------- */
/* >>> PDB-Format  >>> */
#define INSCODE_WITHOUT '_'
#define INSCODE_IGNORE (char)0
#define DEFAULT_PEP_CHAIN ""
#define chainToChain1(s) chrAt(0,s)
/* (NUM1 0) */
#define PDBBUF_ATOM 0
#define PDBBUF_ANUM 1
#define PDBBUF_ELEM 2
#define PDBBUF_RNAM 3
#define PDBBUF_RNUM 4
#define PDBBUF_CHAIN 5

#define PDBBUF_ZZZ 6
/* (NUM1 1) */
#define PDB_INFO 1
#define PDB_ERR 2
#define PDB_WRN 3
#define PDB_DONE 4

/* <<< PDB-Format <<< */
/* ---------------------------------------- */
/* >>> PDB-Parser  >>> */
/* (NUM1 31) */
#define PDB_ERR_LINE_FROM_POS (1<<31)
/* <<< PDB-Parser <<< */
/* ---------------------------------------- */
/* >>> Selection3D  >>> */
    //!#define isContainerForHeteros(protein)  (protein.countResidues()==0 && protein.getIntProperty(PROTEINI_CHAINTYPE)==CHAINTYPE_PEP)

#define s3dResidueName(s) s._residueName
#define s3dNativeAtoms(s) s._nativeAtoms
#define s3dChain(s) s._chain
#define s3dAtoms(s) s._atoms

#define s3dOptions(s) s._opt
#define s3dFirst(s) s._f
#define s3dLast(s) s._l
#define s3dFirstInsCode(s) s._fIns
#define s3dLastInsCode(s) s._lIns

/* (NUM1 1) */
#define S3D_NEW_INSTANCE_CHANGE_ATOMS 1
#define S3D_NEW_INSTANCE_CHANGE_NATIVEATOMS 2

/* <<< Selection3D <<< */
/* ---------------------------------------- */
/* >>> Sequence properties  >>> */

/* (NUM1 1) */
#define SEQ_ATTRIBUTE_1STIDX 1
#define SEQ_ATTRIBUTE_TRANS3D 2
#define SEQ_ATTRIBUTE_ANNO_OVERWRITE 3
#define SEQ_ATTRIBUTE_ANNO 4
#define SEQ_ATTRIBUTE_ASSOCIATE3D 5
#define SEQ_ATTRIBUTE_CDS 6
#define SEQ_ATTRIBUTE_GAPS 7
/* --- */

#define SECSTRU_NONE ((byte)' ')
#define SECSTRU_UNKNOWN ((byte)'.')

/* <<< CIF-Format <<< */
/* ---------------------------------------- */
/* >>> ExactMatch >>> */
#define XMATCH_SEP_ID '+'
#define XMATCH_SEP_SYN_ID '+'

/* <<< ExactMatch <<< */
/* ---------------------------------------- */
/* >>> Placeholders >>> */
#define ALIAS_JOIN_ELEMENTIDX "AJ$$EI"
#define ALIAS_PDB_ID_OF_SEQUENCE "PDB_ID"
/* <<< Placeholders <<< */
/* ---------------------------------------- */
/* >>> MISC  >>> */
#define HETERO_MIN_DISTANCE 7f

/* <<<  <<< */
/* ---------------------------------------- */
/* >>> Protein >>> */
/* (NUM1 0) */
#define RESIDUE_ACCESSIBILITY_COMPUTE (1<<0)
#define RESIDUE_ACCESSIBILITY_COMPUTE_AGAIN (1<<1)

/* (NUM1 0) mapResnToI */
#define MAP_RETRIEVE 0
#define MAP_NO_OVERWRITE 1
#define MAP_OVERWRITE 2
/* Keep! not change numbers! */
#define FSTLST_NTERM 0
#define FSTLST_NTERM_CTERM 1
#define FSTLST_CTERM 2

/* <<< Protein <<< */
/* ---------------------------------------- */
/* >>> Annotation >>> */
#define RESAN_ENTRY_EDITED (1<<12)
#define RESAN_ENTRY_NT (1<<13)
#define RESAN_ENTRY_DISABLED RESAN_ENTRY_NT
#define RESAN_ENTRY_ROW (1<<14)
#define RESAN_ENTRY_NO_UPDATE_UI (1<<15)
#define RESAN_ENTRY_NOT_UNIQUE (1<<17)
#define RESAN_ENTRY_OVERRIDE (1<<18)
#define RESAN_ENTRY_ROW_SHIFT 16
/* ----------------- */


/* (NUM1 8) */
#define RESSEL_IMPL_IT_MASK ((1<<8)-1)
#define RESSEL_IMPL_OFFSET_IS_1ST_IDX (1<<9)
#define RESSEL_IMPL_NOT_IN_TREE (1<<10)
/* (NUM1 0) */
#define RESSEL_IMPL_SHARED 0
#define RESSEL_IMPL_PROTEIN 1
#define RESSEL_IMPL_NAME 2
#define RESSEL_IMPL_PLAIN_ZZZ 3
#define RESSEL_IMPL_CTRL RESSEL_IMPL_PLAIN_ZZZ
#define RESSEL_IMPL_SLIDER_UPPER 4
#define RESSEL_IMPL_SLIDER_LOWER 5
#define RESSEL_IMPL_LAB_LOWER 6
#define RESSEL_IMPL_LAB_UPPER 7
#define RESSEL_IMPL_COMPUTED_FROM 8
#define RESSEL_IMPL_TF_HETERO 9
/* (NUM1 3) */
#define HLPAT_patterns 3
#define HLPAT_patternsRC 4
#define HLPAT_text 5
#define HLPAT_butColor 6
#define HLPAT_dialog 7
#define HLPAT_mc 8
#define HLPAT_isNT 9
#define HLPAT_ZZZ 10
#define RESSEL_IMPL_ZZZ 11
/* --- */
/* (NUM1 3) */
#define RESSEL_IMPL_ALIGN_ONE_ALL_slider 3
#define RESSEL_IMPL_ALIGN_ONE_ALL_selBlosums 4

#define RESSEL_IMPL_ALIGN_ONE_ALL_alignment 6


/* (NUM1 1) */
#define RESSEL_PRINT_SLASH_N (1<<1)
#define RESSEL_PRINT_NO_AT (1<<2)
/* (NUM1 1) */
#define SELPOS2TXT_PDB_RESNUM (1<<1)
#define SELPOS2TXT_COMPACT_NO_SPC (1<<2)
/* <<< Annotation <<< */
/* ---------------------------------------- */
/* >>> Properties >>> */
#define RESN_TO_IDX_FAILED -1
#define RESN_TO_IDX_IS_HETERO -2

/* (NUM1 1) */
/* General */
#define P_MC_FILE_CONTENT 1
#define P_MC_CHARSEQ 2
#define P_MC_1ST_RES_IDX 3
#define P_MC_IDS 4
/* Renderer */
#define P_MC_CURSOR_SEQ 5
#define P_MC_SEQ_LABELS 6
/* Residue related */
#define P_MC_RESNUM 7
#define P_MC_RES_TYPE 8
#define P_MC_RES_TYPE_FULL 9
#define P_MC_RES_TYPE_UC 10
#define P_MC_RES_TYPE_STRG_UC 11
#define P_MC_RES_KEY16 12
/*Alignment */
#define P_MC_GAPPED_SEQ 13
/* 3D */
#define P_MC_RES_SECSTRU 14
#define P_MC_CALPHA_ORIG 15
#define P_MC_ATOM_COORD_ORIG 16
#define P_MC_ATOM_COORD_PV 17
#define P_MC_MATRIX3D 18
#define P_MC_CALPHA 19
#define P_MC_ATOM_COORD 20
#define P_MC_ACCESSIBILITY 21
#define P_MC_INFERRED_PDB 22
#define P_MC_BBOX 23
//MC_FST_LST_HAS_XYZ=24,
/* Nucleotide */
#define P_MC_NUC 25
#define P_MC_EXONS 26
#define P_MC_NUC_STRAND 27
#define P_MC_COUNT_NUC 28
#define P_MC_NUC_IDX2TRANSLATED_IDX 29
#define P_MC_REVERSE 30
#define P_MC_TRIPLETS 31
/* ResidueSelection */
#define P_MC_RES_SELECTIONS_V 32
#define P_MC_RES_SELECTIONS 33
#define P_MC_RES_SELECTIONS_NOT_EMPTY 34
#define P_MC_RES_SELECTION_REFERENCE 35
#define P_MC_SELECTED_RES 36
/*X  oder besser MC_DISPLAYED_SELECTIONS */
#define MC_RESIDUE_ANNOTATION_GROUPS 37
#define P_MC_RES_SELECTION_LABELS 38
#define P_MC_RES_SELECTION_STYLE 39
/* Other Objects */
#define P_MC_HETERO_V 40
#define P_MC_PROTEIN_V3D_V 41
#define P_MC_MAX 42
#define MCA_PROTEINS_V 43
#define MCA_ALIGNMENT 44
#define MCA_EMPTY_COLS 45
#define MCA_SEQUENCE_FEATURES_V 46
#define MCA_RES_COUNT_NOSYNC 47
#define MCA_MAX 48
/* --- */
#define P_MC_SHIFT 6
/* --- */
/* --- No change numbers! --- */
#define P_HEADER 1
#define P_ORGANISM 2
#define P_ORGANISM_SC 3
#define P_COMPOUND 4
#define P_TITLE 5
#define P_ORGANISM_MNEMONIC 6
#define P_TAXONOMY 7
#define P_HEADER_NUM 8
/* --- No change numbers! --- */
/* --- INFO --- */
/* (NUM1 9)  Warum 9? */
#define PROTEINO_WEB_TOK 9
#define PROTEINO_WEB_TOKENS 10
#define PROTEINO_WEB_TOK_WITH_SUBSET 11
#define PROTEINO_WEB_TOK_PDB 12
#define PROTEINO_TREE 13
#define PROTEINO_URL_3D 14
#define PROTEINO_ONLY_HETERO_ADD_TO_ANOTHER_PROTEIN 15
#define PROTEINO_ALIGNMENT 16
#define PROTEINO_RUN_SCRIPT_AFTER_LOADING 17
#define PROTEINO_ATOM_B_FACTOR 18
#define PROTEINO_ATOM_OCCUPANCY 19
#define PROTEINO_EC 20
#define PROTEINO_URL 21
#define PROTEINO_FILENAME 22
#define PROTEINO_DATA_PAINT_CHAIN 23
#define PROTEINO_ORIGINAL_NAME 24
#define PROTEINO_INF3D_INFO 25
#define PROTEINO_BIOMT 26
#define PROTEINO_BIOLOGICAL_MX 27
#define PROTEINO_RES_BG_COLOR 28
#define PROTEINO_PDBTEXT_SECSTR 29
#define PROTEINO_vGFF 30
#define PROTEINO_vIdsOfGffText 31
#define PROTEINO_OWNERS_OF_NUC_OR_HET 32
#define PROTEINO_PARSER 33
#define PROTEINO_BLAST4ID_VV 34
#define PROTEINO_PARSE_AGAIN_SRC 35
#if CPP_WITH_GUI
#define PROTEINO_vGFFhc 36
#define PROTEINO_RECURS_PDB_RESULT 37
#define PROTEINO_RECURS_PDB_BLASTS 38
#endif //CPP_WITH_GUI
#define PROTEINO_NUM 39
/* (NUM1 0) */
#define PROTEINI_ROW 0
#define PROTEINI_PREFERRED_ORDER 1
#define PROTEINI_DONE_EXACT_MATCH 2
#define PROTEINI_PARSE_TIME 3
#define PROTEINI_MOL_TYPE 4
#define PROTEINI_NOT_USE_STRUCTURE_FOR_ALIGNMENT 5
#define PROTEINI_ICON_WIDTH 7
#define PROTEINI_TAXID 8
#define PROTEINI_DEPOSITION_YEAR 9
#define PROTEINI_CDS 10
#define PROTEINI_HTML_IDX 11
#define PROTEINI_CHAINTYPE 12
#define PROTEINI_FILENAME_HC 13
#define PROTEINI_AA_IDX_OFFSET 14
#define PROTEINI_NT_IDX_OFFSET 15
#define PROTEINI_ZZZ 18

/* <<< Properties <<< */
/* ---------------------------------------- */
/* >>> Cache >>> */

/* (NUM1 0) */
#define SEQFEAT_MAX_DAYS 33
/* (NUM1 1) */
#define P_CACHE_ATOM_COORD 1
#define P_P_CACHE_ATOM_COORD_PV 2
#define P_CACHE_CALPHA 3
#define P_P_CACHE_CALPHA_PV 4
#define P_CACHE_RESIDUES 5
#define P_CACHE_KEY4RESIDUES 6
#define P_P_CACHE_RESIDUES_HAS_XYZ 7
#define P_P_CACHE_RESIDUES_FULL 8
#define P_CACHE_RES_UC 9
#define P_CACHE_RES_STRG_UC 10
#define P_CACHE_Ti_2_Ni 11
#define P_CACHE_BBOX 13
#define P_CACHE_groupAnno 14
#define P_CACHE_ResCol 15
#define P_CACHE_col2i 16
#define P_CACHE_gapped 17
#define P_CACHE_selAA 18
#define P_P_CACHE_ResColW 19
#define P_CACHE_REND 20
#define P_CACHE_CHILDS 21
#define P_CACHE_childsBuf 22
#define P_CACHE_FST_LST_HAS_XYZ 23
#define P_CACHE_SUPERIMPOSE_3D 24
#define P_NUM_CACHE 25

/* <<< Cache <<< */
/* ---------------------------------------- */
/* >>> Export Alignment >>> */
/* (NUM1 0) */
#define STT_WRITE_LAST (1<<0)
#define STT_WRITE_STEP (1<<1)
/* (NUM1 2) */
#define HTMLUTIL_BOLD (1<<2)
/* AlignmentWriter (NUM1 1) */
#define ALIWR_PARA_KEY_IDENT_THRESHOLD 1
#define ALIWR_PARA_DIRECTORY 2
#define ALIWR_PARA_COL_RANGE 3
#define ALIWR_PARA_RES_PER_LINE 4
#define ALIWR_PARA_NAMES 5
#define ALIWR_PARA_RULER_SECSTR 7
#define ALIWR_PARA_ERROR_MSG 8
#define ALIWR_PARA_FTR_FONT 9
#define ALIWR_PARA_ZZZ 10
/* (NUM1 1) */
#define ALIWR_FILE_SUFFIX (1<<5)
#define ALIWR_UNDERLINE_ANNOTATIONS (1<<10)
#if !CPP_PRG_AA
#define ALIWR_PDB_RESIDUE_NUMBER (1<<9)
#define ALIWR_SECONDARY_STRUCTURE (1<<11)
#define ALIWR_PROTEIN_ICONS (1<<15)
#define ALIWR_WEB_BROWSER (1<<12)
#define ALIWR_NUCLEOTIDE_TRIPLET (1<<7)
#define ALIWR_EXTRA_SPACE (1<<6)
#define ALIWR_SCALE_FTR_LINE (1<<13)
#define ALIWR_JTEXTPANE (1<<14)
#endif //!CPP_PRG_AA
//#define ALIWR_BALLOON_MESSAGE (1<<14)
/* <<< AlignmentWriter <<< */
/* ---------------------------------------- */
/* >>> Import Alignment >>> */
/* (NUM1 1) */
#define MSF_FORMAT_SIMPLE 1
#define MSF_FORMAT_MSF 2
#define MSF_FORMAT_STOCKHOLM 3
#define MSF_FORMAT_PRODOM 4
#define MSF_FORMAT_HSSP 5
#define MSF_FORMAT_FASTA 6
#define MSF_FORMAT_NEXUS 7
#define MSF_FORMAT_CLUSTALW 8
//#define MSF_FORMAT_CLUSTALW 8
#define MSF_FORMAT_PIR 9
/* (NUM1 16) */
#define MSF_START_WITH_S (1<<16)
/* <<< Import Alignment <<< */
/* ---------------------------------------- */
/* >>> Series >>> */
/* (NUM1 1) */
#define SERIES_INS 1
#define SERIES_SECSTRU 2
/* <<< Series <<< */
/* ---------------------------------------- */
/* >>> Matrix3D >>> */
/* (NUM1 1) */
#define MTRX_FORMAT_PLAIN 1
#define MTRX_FORMAT_EXPLAIN 2
#define MTRX_FORMAT_PLAIN_VBAR 3
#define MTRX_FORMAT_XML 4
#if CPP_WITH_GUI
#define MTRX_FORMAT_ROUNDED 5
#endif //CPP_WITH_GUI
#if CPP_DEACTIVATED
#define MTRX_FORMAT_JMOL 6
#define MTRX_FORMAT_PYMOL 7
#endif //CPP_DEACTIVATED
/* (NUM1 0) */
#define ASSEMBLY_ID 0
#define ASSEMBLY_CHAINS 1
#define ASSEMBLY_MATRICES 2
#define ASSEMBLY_ZZZ 3

/* <<< Matrix3D <<< */
/* ---------------------------------------- */
/* >>> View3d >>> */

#define v3dToArry(v)  toArry(v,View3d.NONE)
/* (NUM1 0) */
#define V3D_RIBBON_COMMAND 0
#define V3D_RIBBON_NAME 1
#define V3D_RIBBON_COLOR 2
#define V3D_RIBBON_NUM_FIELDS 4
/* (NUM1 1) */
#define V3D_LOG_NATIVE (1<<1)
/* (NUM1 1) */
#define VIEW3D_GET_FRAME_TITLE 1
/*X  String */
#define VIEW3D_GET_ATOM_SELECTION_EXAMPLE 2
/*X  String */
#define VIEW3D_GET_JMENUBAR 3
/*X  javax-swing-jmenubar */
#define VIEW3D_GET_CANVAS 4
/*X  java-awt-component */
#define VIEW3D_GET_RIBBONS 5
#define VIEW3D_GET_FLAGS 6
/*X  int-bit-mask with properties */
#define VIEW3D_GET_SUPPORTED_COMMANDS 7
/*X  String Array */
#define VIEW3D_GET_SHARED_VIEWS 8
/*X  List<View3d> */
#define VIEW3D_GET_SHARED_MAP 9
/*X  Map */
#define VIEW3D_GET_PNAME 10
#define VIEW3D_IS_VERBOSE 11
/*X  If not null then verbose */
#define VIEW3D_NO_LOG 12
/*X  Not logging when doing 3D_render */
#define VIEW3D_MAP_SAVED_SELECTION 13
#define AVIEW3D_GET_RECORD_GENERIC_COMMANDS 14
#define AVIEW3D_GET_SELECTION3D 15
#define AVIEW3D_CAN_TRACK_SELECTION3D 16
#define AVIEW3D_SET_WEB_DIR 17
#define AVIEW3D_PROPERTIES_L 18

/* <<< View3d <<< */
/* ---------------------------------------- */
/* >>>  resSelSetAminoSelected >>> */
#define ALIAS_POSITION_PLUS_1 (MIN_INT+1)
#define SELECTION_ADD 1
#define SELECTION_RM 2
#define SELECTION_TOGGLE 3
#define SELECTION_ONLY 4
/* <<< ResidueAnnotation <<< */
/* ---------------------------------------- */
/* >>> ResidueAnnotation >>> */
#define resSelMaxUnderline()  _resselMaxUL
#define STYLE_TO_LINE(style) ((style>>VIS123_BIT_SHIFT_LINE)&0xFF)
#define RESANCACHE_IS_SEL_DISPLAYED 0
#define RESANCACHE_rendMC 1
#define RESANCACHE_IS_SEL_NT 2
#define RESANCACHE_IS_SEL 3
#if CPP_WITH_GUI
#define RESANCACHE_REND_TEXT 4
#define RESANCACHE_REND_TEXT_JLIST 5
#endif //CPP_WITH_GUI
/* --- */
#define SSTYLE_MASK 0xF
/* --- */
#define RESSEL_MAX_UNDERLINE 7
/* --- */
/* <<< ResidueAnnotation <<< */
/* ---------------------------------------- */
/* >>> drawResidueSelection  >>> */
#define SEQFEAT_ALI_SCORE " Alignment-Score="
#define SEQFEAT_PFX_DATA_SRC_EQ "DATA_SRC="
/* <<< ResidueAnnotation <<< */
/* ---------------------------------------- */
/* >>> drawResidueSelection  >>> */

#define P_AMINO_ACIDS true
#define P_NUCLEOTIDES false

/* <<< drawResidueSelection <<< */
/* ---------------------------------------- */
/* >>> Evidence  >>> */
#define EVIDENCE_POTENTIAL "Potential"
#define EVIDENCE_BY_SIMILARITY "By similarity"
#define EVIDENCE_BY_IDENTITY "By identity"
#define EVIDENCE_EXPERIMENTAL "Experimental"
#define EVIDENCE_BY_AUTHOR "By author"
#define EVIDENCE_BY_SOFTWARE "By software"
#define EVIDENCE_UNKNOWN "Evidence unknown"
#define EVIDENCE_MANUAL_ASSERTION "Manual assertion"
/* <<< Evidence <<< */
/* ---------------------------------------- */
/* >>> Misc >>> */
#define findupEstimatedTime(ppNotUsed)  1000*60*10
#define rescolorI() _rescolorI
/* <<<  <<< */
/* ---------------------------------------- */
/* >>> Align, Blast  >>> */
/* (NUM1 0) */
#define SIMILARITY_MATRIX_BLOSUM62 0
#define SIMILARITY_MATRIX_BLASTMIDLINE 1
#define SIMILARITY_MATRIX_BL2SEQ_MIDLINE 2
#define SIMILARITY_MATRIX_NUC 3
#define SIMILARITY_MATRIX_COMPL 4
#define SIMILARITY_MATRIX_ZZZ 5
/* --- */

#define BLOSUM62_MAX 9
#define BLOSUM62_MIN -4
#define ALIGN_SCORE_FOR_PERFECT_MATCH 7777
#define BL2SEQ_BLASTX "blastx"
#define DB_EMBL "EMBL"
#define DB_UNIPARC "UNIPARC"
#define DB_UNIPROT "UNIPROT"
#define DB_NCBI_AA "NCBI_AA"
#define DB_NCBI_NT "NCBI_NT"
#define DB_REFSEQ "REFSEQ"
#define DB_NCBI "NCBI"
#define DB_GENBANK "GB"

#define TITLE_PEPTIDE_MATCH "PeptideMatch"
/* --- */

/* (NUM1 8)  0xFF for BLAST4ID_DB_database */

#define GETSEQID_ALSO_BY_IDENTITY (1<<9)
#define GETSEQID_ONLY_BY_IDENTITY (1<<10)

/* BLAST4ID: Bit 0 is RETURN_THREAD  (NUM1 1) */
#define BLAST4ID_CACHE_ONLY (1<<2)
#define BLAST4ID_NOT_FETCH_SEQUENCE (1<<3)
#define BLAST4ID_EVEN_IF_HAS_ID (1<<4)
/* - */
#define BLAST4ID_BLASTER_SHIFT 8
#define BLAST4ID_BLASTER_MASK  (255<<BLAST4ID_BLASTER_SHIFT)
#define BLAST4ID_DB_SHIFT 16
#define BLAST4ID_DB_MASK   (15<<BLAST4ID_DB_SHIFT)
/* --- */

#define BLAST_SHIFT_WORDSIZE 8
#define BLAST_SHIFT_SENSITIVITY 12
#define BLAST_SHIFT_NUMALI 16
/* (NUM1 1)  RETURN_THREAD!*/
#define BLAST_NUCLEOTIDE_DB (1<<1)
#define BLAST_NUCLEOTIDE_QUERY (1<<2)
#define BLAST_DATABASES_FULL_LIST (1<<3)
#define BLAST_NO_GAPS (1<<4)
#define BLAST_CACHE_ONLY (1<<5)
/* --- */

#define _blastV vNoClr(367)
#define _blastJlist _X[111]
/* <<<  <<< */
/* ---------------------------------------- */
/* --- */
/* (NUM1 0) */
#define IDATA_HL_MC 0
#define IDATA_HL_OPT 1
#define IDATA_HL_L 2
/* (NUM1 0) */
#define DATA_HL_BB 0
#define DATA_HL_L 1
/* (NUM1 0) */
#define DATA_LSTMDL_SelectedItem 0
#define DATA_LSTMDL_L 1
/* (NUM1 0) */
#define IDATA_LSTMDL_FILTER 0
#define IDATA_LSTMDL_L 1
/* (NUM1 0) */
#define DATA_DiaAnnoActDeact_ComboKeys 0
#define DATA_DiaAnnoActDeact_TF 1
#define DATA_DiaAnnoActDeact_ButDeact 2
#define DATA_DiaAnnoActDeact_ButActiv 3
#define DATA_DiaAnnoActDeact_ButDel 4
#define DATA_DiaAnnoActDeact_PNL 5
#define DATA_DiaAnnoActDeact_Msg 6
#define DATA_DiaAnnoActDeact_filter 7
#define DATA_SXM_ITEMS3D_MENU_BAR 10
#define DATA_SXM_ITEMS3D_MENU_CTXT 11
#define DATA_SXM_ContextObjects 12
#define DATA_SXM_ITEMS 13
#define DATA_SXM_TITLE2 14
#define DATA_SXM_TITLE1 15
#define DATA_SXM_JPopup 16
#define DATA_SXM_GENERIC_MB 17
#define DATA_SXM_DialogExecuteOnFile 18
#define DATA_SXM_FilePopup 19
//#define DATA_SXM_MapButtons 20
#define DATA_CTXTMENU_L 21
/* (NUM1 0) */
#define IDATA_SXM_OPT 0
#define IDATA_SXM_TYPE 1
#define IDATA_CTXTMENU_L 2
/* (NUM1 0) */
#define DATA_DRAWSEQ_CHARBOUNDS 0
#define DATA_DRAWSEQ_FONT 1
#define DATA_DRAWSEQ_FREQUENCIES 2
#define DATA_DRAWSEQ_L 3
/* (NUM1 0) */
/* #define DATA_DROP_PP_FromStrg 0 */
/* #define DATA_DROP_BA_FromStrg 1 */
/* #define DATA_DROP_Files 2 */
/* #define DATA_DROP_FilesResSel 3 */
/* #define DATA_DROP_FileAnno 4 */
/* #define DATA_DROP_Objects 5 */
/* #define DATA_DROP_LogMsg 6 */
/* #define DATA_DROP_dndTarget 7 */
/* #define DATA_DROP_Transferable 8 */
/* #define DATA_DROP_LINK 9 */
/* #define DATA_DROP_IMG 10 */
/* #define DATA_DROP_MSG 11 */
/* #define DATA_DROP_SCRIPT 12 */
/* #define DATA_DROP_STRG 13 */
/* #define DATA_DROP_TARGET_AAA 14 */
/* #define DATA_DROP_TARGET_JCOMPONENT 15 */
/* #define DATA_DROP_TARGET_RESANS 16 */
/* #define DATA_DROP_TARGET_ALIP 17 */
/* #define DATA_DROP_TARGET_PP 18 */
/* #define DATA_DROP_TARGET_TXTCOMP 19 */
/* #define DATA_DROP_TARGET_COLLECTION 20 */
/* #define DATA_DROP_TARGET_V3D 21 */
/* #define DATA_DROP_L 23 */
/* ---------- */

/* <<< Data of instances of Strap.class <<< */
/* ---------------------------------------- */
/* >>> Entropy >>> */
#define FREQAA_TOTAL ('z'-'a'+1)
#define FREQAA_VALID ('z'-'a'+2)
#define FREQAA_ENTROPY ('z'-'a'+3)
#define FREQAA_ENTROPY_DRAWN ('z'-'a'+4)
/* <<< Entropy  <<< */
/* ---------------------------------------- */
/* >>> Script >>> */
#define newScriptInterpreter()  new Strap(0)
#define SI_VALUES_SIZE SCRIPT_CMD_ZZZ
/* <<< Script  <<< */
/* ---------------------------------------- */
/* >>> StrapFormat >>> */
#define STRAPFORMAT_HASH_CHAIN '~'
#define STRAPFORMAT_HASH_ID '>'
/* (NUM1 1) RETURN_THREAD */
#define STRAPSCRIPT_NOT_FRAME_TO_FRONT (1<<1)
#define STRAPSCRIPT_HASH_CREATE_NEW_PROTEIN (1<<2)

/* <<<  <<< */
/* ---------------------------------------- */
/* >>>  Strap final static Collection >>> */
#if CPP_WITH_GUI
#define _vRepaintCursor vectorNoClr(236)
#define strapSelectedObjectsV() vNoClr(240|VCLR_UNIQLIST_HASHSET)
#define vAliPanelPlotters_ValueOfResidue vNoClr(247)
#define vAliPanelPlotters_ValueOfAlignPosition vNoClr(370)
#define _vAllResidueAnnotation vNoClr(249)
#define _mapDndFile2Ressel weakmapNoClr(218)
#endif //CPP_WITH_GUI
#define V3D_MAP_ID_TO_VV mapNoClr(221)
#define MAP_UniProt2Swiss mapNoClr(222)
#define MAP_UniProt2Name mapNoClr(223)
#define _mapLabelToAsym mapNoClr(272)
/* <<< Strap  final static Collection <<< */
/* ---------------------------------------- */
/* >>> Tree  >>> */
#define _strapTree _X[64]
/* <<< Tree <<< */
/* ---------------------------------------- */
/* >>> Blast  >>> */
