#! /bin/bash -u
set -o pipefail

onlyCompile=0
DO_SINGLE=0
while getopts cs opt; do
	case $opt in
		c ) onlyCompile=1;;
        s ) DO_SINGLE=1;;
	esac
done

echo $ANSI_INVERSE === Running UpdateEnumerations.sh === $ANSI_RESET>/dev/stderr
source $STRAP_SRC/SOURCE_ME_MAKE_STRAP.sh
source $STRAP_ENV ||die source $STRAP_ENV
cd ${BASH_SOURCE[0]%/*}
# ********************
# *** Compile Java ***
# ********************
readonly BASIC_MACROS_JAVA=$CPP_DIR_SRC_GENERATED/headers.h
source $STRAP_SRC/cpp/cppGenerateHeader.sh>/dev/null
$STRAP_SRC/cpp/cppGenerateHeader.sh>$BASIC_MACROS_JAVA || die source cppGenerateHeader.sh
echo JAVA_ROOTS=$ANSI_MAGENTA $JAVA_ROOTS $ANSI_RESET
cat $(find $JAVA_ROOTS -name 'cpp_BASIC_*.h') >>$BASIC_MACROS_JAVA
compileJava(){

    local src=$PWD/UpdateEnumerations.java
    local processed=$STRAP_PREPROCESSED/$(cppAbsToRelPath $src)
    local class=${processed%.java}.class
    mkdir -p ${processed%/*}
    for java in  ${src%/*}/*.java;do
        [[ -f $class ]] || break
        [[ $java -nt $class ]] && rm $class
    done
#    ls $src $processed
    if ! [[ -s $class ]]; then
        cpp  -DWRITE_CONCATENATED_JAVA=1 -nostdinc -P $src --imacros $BASIC_MACROS_JAVA >$processed
#) 2>&1 | fgrep -v 'Extra argument to #endif'
        ls -l $src $processed
        #echo $ANSI_MAGENTA
        set -x
        javac -cp $STRAP_PREPROCESSED $processed
        set +x
        #echo $ANSI_RESET
    fi
    ls -l $class
}
compileJava
(($onlyCompile)) && exit

readonly CPP1_HEADER=$STRAP_PREPROCESSED/tmp/cpp1.h
mkdir -p ${CPP1_HEADER%/*}
grep -h '#define *thread.*CPP_thrd' $(find $STRAP_SRC -name "*.h")>$CPP1_HEADER
for i in CASE_ARGV CASE_ARG ECHOcond ECHOref; do echo '#undef '$i>>$CPP1_HEADER; done
echo -e '#undef ECHOcond\n#define ECHOcond(a)\n#define WRITE_CONCATENATED_JAVA 1' >>$CPP1_HEADER
cpp1() {
    cpp -nostdinc -P -C -I$STRAP_SRC/src/{noGui,gui}/charite/christo/{strap/,}  $* --imacros $CPP1_HEADER
    # Without the -C option lines with double slash will be truncated like http://www....
}
writeConcatenatedJava() {
    echo $ANSI_INVERSE BEGIN writeConcatenatedJava $ANSI_RESET>&2
    # The preprocessor concatenation operator ## does not work. Makros BUT_C1 and BUT_C2 fail.
    local FF=$(find $JAVA_ROOTS -name '[A-Z]*.java'|fgrep -v -e /test/Test -e /test/todo -e /generateCode/ -e Inc.java)
    cat $FF | sed -n  's|^#define \(\w*\)\b.*$|#undef \1|p'>$CPP_DIR_SRC_GENERATED/undef.h
    local FF2=
    for f in $FF;do
        FF2=$FF2' '$f' '$CPP_DIR_SRC_GENERATED/undef.h
    done
    if (( DO_SINGLE )); then
        for j in $FF; do
            echo $j >/dev/stderr
            cat $j|rmComments|cpp1  --imacros $BASIC_MACROS_JAVA
        done
    else
        more $FF2|rmComments|grep -v '#define \(LBUT\|baTmp(\)'| sed 's|^#endif .*|#endif|1'| cpp1 $(cppSearchPaths) --imacros $BASIC_MACROS_JAVA | sed -e 's|^ \+||1'
        local RR=$(find $JAVA_ROOTS -iname 'rsc_*[a-z]')
        more $RR|\
            sed -e 's|^#endif .*|#endif|1; s| _DEL_SPC_ ||g' |\
            #tee $STRAP_PREPROCESSED/tmp/writeConcatenatedJava.beforeGPP|\
            gpp -U '' '' '(' ',' ')' '(' ')' '$' '' -M '\n#\w' '\n' ' ' ' ' '\n' '' '' $HEADER_NO_PARENTHESES|\
            sed "$SED_UNSTRINGIZE"
    fi
    echo $ANSI_INVERSE END $ANSI_RESET writeConcatenatedJava>&2
}
readonly HEADER_NO_PARENTHESES=$CPP_DIR_SRC_GENERATED/noParenthes.h

#makeManPage
fgrep -v '(' $BASIC_MACROS_JAVA |sed -e 's|^#endif .*|#endif|1'>$HEADER_NO_PARENTHESES


readonly CONCATENATED=$CPP_DIR_SRC_GENERATED/concatenated.java
more $HEADER_NO_PARENTHESES $(find $JAVA_ROOTS -iname 'rsc_*[a-z]' -not -name '*SAVE_FILE_HOOK.sh')|\
    sed -e 's|^#endif .*|#endif|1; s| _DEL_SPC_ ||g' -e 's|\bBUT_C1(\(\w\+\))|BUT_C_\1|g'|\
    ##tee $CONCATENATED.beforGPP |\
    gpp -U '' '' '(' ',' ')' '(' ')' '$' '' -M '\n#\w' '\n' ' ' ' ' '\n' '' '' > $CONCATENATED
# Ich kann rmComments hier nicht weglassen. Warum?

writeConcatenatedJava|rmComments>>$CONCATENATED

ls -l $CONCATENATED

methodByReflection(){
    echo ::::::::::::::
    echo $STRAP_SRC/
    echo ::::::::::::::
    echo '@*SARRAY_methodByReflection'
    sed 's|\bCPP_thrd|\n&|p' $CONCATENATED|sed -n 's|^CPP_thrd\w*(\(\w*\),\(\w*\),.*|\2 \1|p'|fgrep -v -w this|sort -u|tr '\n' '|'
    echo
    echo '*@'
    echo '@*SARRAY_REFLECTION_PUBLIC'
    sed -n 's|.*\bREFLECTION_PUBLIC[^(]*\b\(\w\+\)(.*|\1|p' $CONCATENATED |sort -u|tr '\n' '|'
    echo
    echo '*@'
}
(($CPP_WITH_GUI&&$CPP_WITH_MEIN_DEBUG)) && methodByReflection>$CPP_DIR_SRC_GENERATED/tmp.txt && cat $CPP_DIR_SRC_GENERATED/tmp.txt>>$CONCATENATED
#methodByReflection
# ******************
# *** Start Java ***
# ******************
java -cp $STRAP_PREPROCESSED generateCode.UpdateEnumerations $STRAP_SRC $CONCATENATED

#echo -n $ANSI_FG_RED
#fgrep '/*' *.rsc |fgrep -v -e '/*}"' && die ' Use CPP_PRG_STRAP ' $ANSI_RESET
#fgrep '*/' *.rsc | fgrep -v -e '*/}"' && die ' Use CPP_PRG_STRAP ' $ANSI_RESET
#echo -n $ANSI_RESET
