

static void mkPrgPara(String variable,String par){
    _sarrayPrgParameters.addToSarrayI(_count,par);
    counterSet(OPT_RSC,"i"+variable,_count);
    _count+=2; /* skip a number */
    _definesRSC.a("#define ").a(variable).a(" \"").a(par).aln("\"")
        .a("#define ").a(variable).a("_NQ ").aln(par);
}
static void mkPrgParas(){
    mkPrgPara("PAR_AAA",null);
    mkPrgPara("PAR_LOG3DG","-log3dG");
    mkPrgPara("PAR_LOG3D","-log3d");
    mkPrgPara("PAR_VERBOSE","-verbose");
    mkPrgPara("PAR_LOGEXEC","-logExec");
    mkPrgPara("PAR_LOGPCKG","-logPckg");
    mkPrgPara("PAR_LOGNETWORK","-logNetwork");
    mkPrgPara("PAR_VERBOSE_SHORT","-v");
    mkPrgPara("PAR_stdout","-stdout");
    mkPrgPara("PAR_useInstalledSoftware","-useInstalledSoftware");
    mkPrgPara("PAR_allowFileModification","-allowFileModification");
    mkPrgPara("PAR_EXCEPTION_NO_UPLOAD","-noUploadEx");
    mkPrgPara("PAR_EDTFTP","-edtftp");
    mkPrgPara("PAR_KEEP_FILES","-keepFiles");
    mkPrgPara("PAR_MANUAL","-manual");
    mkPrgPara("PAR_noCacheWrite","-noCacheWrite");
    mkPrgPara("PAR_noCache","-noCache");
    mkPrgPara("PAR_cacheUrl","-cacheUrl");
    mkPrgPara("PAR_PDB_DB","-pdbDB");
    mkPrgPara("PAR_LOCAL_DB","-localSequenceDB=");
    mkPrgPara("PAR_SCRIPT_OUTPUT","-scriptOutput=");
    mkPrgPara("PAR_DIRECTORIES","-directories=");
    mkPrgPara("PAR_RELATIVE_URL","-pathsForRelativeURL=");
    mkPrgPara("PAR_JAR_FILE","-jarFile=");
    mkPrgPara("PAR_help","-help");
    mkPrgPara("PAR_NO_FTP","-noFTP");
#if CPP_WITH_SPELLCHECK
    mkPrgPara("PAR_spellcheckWords","-spellcheckWords=");
#endif //CPP_WITH_SPELLCHECK
#if CPP_WITH_GUI
    mkPrgPara("PAR_bash_completion","-completion");
    mkPrgPara("PAR_user_home","-user.home=");
    mkPrgPara("PAR_stackTrace","-stackTrace");
    mkPrgPara("PAR_stackTraceShort","-stackTraceShort");
    mkPrgPara("PAR_testWeb","-testWeb");
#if 0
    mkPrgPara("PAR_DproxyHost","-DproxyHost=");
#endif //0
    mkPrgPara("PAR_ckURLs","-ckURLs");
    mkPrgPara("PAR_ASK_UPLOAD","-askUpload");
    mkPrgPara("PAR_ASK_EXEC","-askExec");
    mkPrgPara("PAR_ASK_EXIT","-askExit");
    mkPrgPara("PAR_LOCK_MENU","-mlock");
    mkPrgPara("PAR_NO_SOUND","-noSound");
    mkPrgPara("PAR_NO_DISCLAIMER","-noDisclaimer");
    mkPrgPara("PAR_PROXY_PAC","-pac=");
    mkPrgPara("PAR_PROXY_CFG","-proxycfgOutput=");
    mkPrgPara("PAR_PROXY_PROBE","-probeWebProxy");
    mkPrgPara("PAR_DEBUG_PROXY","-debugProxy");
    mkPrgPara("PAR_LAF","-laf=");
    mkPrgPara("PAR_GEOMETRY","-geometry=");
    mkPrgPara("PAR_AS_TEXTVIEWER","-viewTextFiles");
    mkPrgPara("PAR_PMID_MANAGER","-pubmed");
    mkPrgPara("PAR_CALLING_BATCH","-callingBatch=");
    mkPrgPara("PAR_noExit","-noExit");
    mkPrgPara("PAR_noRemoteCode","-noRemoteCode");
    mkPrgPara("PAR_notAskQuit","-notAskQuit");
#endif //CPP_WITH_GUI

#if CPP_WITH_WINDOWS
    mkPrgPara("PAR_64","-64");
    mkPrgPara("PAR_win","-win");
#endif //CPP_WITH_WINDOWS

#if CPP_WITH_DAS
    mkPrgPara("PAR_DAS_NO_CACHE","-noCacheDAS");
#endif //CPP_WITH_DAS

#if CPP_PRG_AA
    mkPrgPara("PAR_noInternet","-noInternet");
    mkPrgPara("PAR_OUT_FILE_NAME","-o");
    mkPrgPara("PAR_urlsAsFilename","-urlsAsFilename");
    mkPrgPara("PAR_FORMATDB","-formatdb");
    mkPrgPara("PAR_FORMATDB_SORT","-sort=");
    mkPrgPara("PAR_MK_CSA","-formatCSA=");
    mkPrgPara("PAR_MK_PDB","-mkPdb=");

    mkPrgPara("PAR_MK_PDB_FA","-mkPdbFA=");
    mkPrgPara("PAR_UNIPROT_DB","-uniprotDB=");
    mkPrgPara("PAR_DOWNLOAD_IMAGES","-downloadImages");
    mkPrgPara("PAR_GF_SERVER_UP","-gfServerUniprot=");
    mkPrgPara("PAR_GF_SERVER_UP_PORT","-gfServerUniprotPort=");
    mkPrgPara("PAR_TEST_PDBSEQ","-testPdbseq=");
    mkPrgPara("PAR_TEST_ID4SEQ","-testIdForSeq=");
    mkPrgPara("PAR_TEST_SEQ4ID","-testSeqForId=");
    mkPrgPara("PAR_TEST_RO_ARCHIVE_PDB","-testPdbID=");
    mkPrgPara("PAR_FORMATDB_GFF","-GFF=");
    mkPrgPara("PAR_aa3dViaPHP","-aa3dViaPHP");
#endif //CPP_PRG_AA

#if CPP_PRG_STRAP

    mkPrgPara("PAR_ALIGNER_PROFILE","-alignerP=");
    mkPrgPara("PAR_ALIGNER_PAIR","-aligner2=");
    mkPrgPara("PAR_ALIGNER","-aligner=");
    mkPrgPara("PAR_ALIGNER_3D","-aligner3D=");
    mkPrgPara("PAR_SUPERIMPOSER","-superimposer=");
    mkPrgPara("PAR_VIEW3D","-v3d=");

    mkPrgPara("PAR_TRANSLATION","-useFieldTranslation=");
    mkPrgPara("PAR_NOT_TO_FRONT","-notToFront");
    mkPrgPara("PAR_noIdentical","-noIdentical");

    mkPrgPara("PAR_UPDATE_STRAP_JAR","-updateStrapJar=");

    mkPrgPara("PAR_onlyWobblePos","-onlyWobblePos");
    mkPrgPara("PAR_strapDirectory","-strapDirectory");
    mkPrgPara("PAR_toJalview","-toJalview");

    mkPrgPara("PAR_toTree","-toTree");
    mkPrgPara("PAR_cachePassword","-cachePassword=");
    mkPrgPara("PAR_cacheUser","-cacheUser=");
    mkPrgPara("PAR_dasFeatures","-dasFeatures=");
    mkPrgPara("PAR_dasRegistry","-dasRegistry=");
    mkPrgPara("PAR_exclude","-exclude=");
    mkPrgPara("PAR_dialog","-dialog=");
    mkPrgPara("PAR_publication","-publication=");
    mkPrgPara("PAR_pdb","-pdb=");
    mkPrgPara("PAR_align","-align=");
    mkPrgPara("PAR_alignAndRearange","-alignAndRearange=");
    mkPrgPara("PAR_load","-load=");
    mkPrgPara("PAR_noSequenceFeatures","-noSequenceFeatures");
    mkPrgPara("PAR_hideAll","-hideAll");
    mkPrgPara("PAR_nameFromFasta","-nameFromFasta");
    mkPrgPara("PAR_testCSA","-testCSA");
    mkPrgPara("PAR_EXPORT_TO_AAA",null);
    mkPrgPara("PAR_toClustal","-toClustal");
    mkPrgPara("PAR_toMSF","-toMSF");
    mkPrgPara("PAR_toMultipleFasta","-toMultipleFasta");
    mkPrgPara("PAR_toWord","-toWord");
    mkPrgPara("PAR_toFasta","-toFasta");
    mkPrgPara("PAR_EXPORT_TO_ZZZ",null);
#endif //CPP_PRG_STRAP

#if CPP_PRG_STRAP_OR_AA
        mkPrgPara("PAR_LOCAL_PDB","-localPDB=");
    mkPrgPara("PAR_HTML_STRAP_PHP","-strapPhp=");
    mkPrgPara("PAR_HTML_JS","-javaScript=");
    mkPrgPara("PAR_dataForFigure","-dataForFigure=");
    mkPrgPara("PAR_pdbNoXYZ","-pdbNoXYZ");
    mkPrgPara("PAR_noSeqres","-noSeqres");
    mkPrgPara("PAR_variable","-variable=");
#endif //CPP_PRG_STRAP_OR_AA

#if CPP_WITH_WEBSTART
    mkPrgPara("PAR_rename","-rename");
    mkPrgPara("PAR_separateInstance","-separateInstance");
    mkPrgPara("PAR_silPort","-silPort");
    mkPrgPara("PAR_iconify","-iconify");
    mkPrgPara("PAR_no3D","-no3D=");
    mkPrgPara("PAR_noAlignment","-noA=");
    mkPrgPara("PAR_noSuperimpose","-noSP=");
    mkPrgPara("PAR_port","-port");
#endif //CPP_WITH_WEBSTART

    mkPrgPara("PAR_deadlock","-deadlock");
    mkPrgPara("PAR_logURLs","-logURLs");
    mkPrgPara("PAR_mac","-mac");
    mkPrgPara("PAR_meinPC","-meinPC");
    mkPrgPara("PAR_noClassloading","-noClassloading");
    mkPrgPara("PAR_pckg","-pckg");

#if CPP_WITH_MEIN_DEBUG
    mkPrgPara("PAR_debugHtmlTidy","-htmlTidy");
    mkPrgPara("PAR_debugFinalize","-logFinalize");
    mkPrgPara("PAR_benchmarkViewAlignment","-benchmarkViewAlignment=");
    mkPrgPara("PAR_listFile","-listFile=");
    mkPrgPara("PAR_testCompilation","-testC");
#endif //CPP_WITH_MEIN_DEBUG

    mkPrgPara("PFXPAR_AAA",null);

#if CPP_PRG_AA
    mkPrgPara("PFXPAR_VMPROP","-VMPROP");
    mkPrgPara("PFXPAR_IGNORE","-IGNORE_");
#endif //CPP_PRG_AA

#if CPP_WITH_GUI
    mkPrgPara("PFXPAR_ADD_SETTING","-addPreference");
#endif //CPP_WITH_GUI

#if CPP_PRG_STRAP
#endif //CPP_PRG_STRAP

#if CPP_PRG_STRAP_OR_AA
    mkPrgPara("PFXPAR_script","-script");
#endif //CPP_PRG_STRAP_OR_AA

    mkPrgPara("PFXPAR_ZZZ",null);
    mkPrgPara("PAR_ZZZ",null);
}
