#include <stdlib.h>
#include <stdio.h>
#include <math.h>


double	qnorm(double u)  
{
double	t1,t2;
double	x,erfinv,z;

t1 = 2/(3.14159*0.14);

x = 2*u - 1;
t2 = log(1-(x*x));

erfinv = sqrt(-t1-(t2/2)+sqrt(pow(t1+(t2/2),2.0)-(t2/0.14)));

z = sqrt(2.0)*erfinv;

if (u < 0.5) z = -z;

return(z);
}


void main(int argc,char *argv[])
{
int	n_proc,I,n_sobol;
char	cor_name[256],sobol_name[256];
int	n_sobol_proc;
int	*id;
double	*chol_cor_mat,*u,*s,*z;
char	out_name[256];
int	i,j,k,m;
FILE	*fptr,*fptr_out;
double	d;


if (argc != 6)  {
	printf("<n_proc> <I> <cor_name> <n_sobol> <sobol_name>\n");
	}

/*
d = 0.01;
while (d < 1.0)  {
	printf("%le %le\n",d,qnorm(d));
	d = d + 0.01;
	}
*/

sscanf(argv[1],"%i",&n_proc);
sscanf(argv[2],"%i",&I);
sscanf(argv[3],"%s",cor_name);
sscanf(argv[4],"%i",&n_sobol);
sscanf(argv[5],"%s",sobol_name);

printf("%i %i %s %i %s\n",n_proc,I,cor_name,n_sobol,sobol_name);

n_sobol_proc = (int)(n_sobol / n_proc);

id = (int *)malloc(I*sizeof(int));
chol_cor_mat = (double *)malloc(I*I*sizeof(double));
fptr = fopen(cor_name,"r");
for (i = 0; i < I; i++)  {
	fscanf(fptr,"%i",&(id[i]));
	}
for (i = 0; i < I; i++)  {
	fscanf(fptr,"%*i");
	for (j = 0; j < I; j++)  {
		fscanf(fptr,"%le",&(chol_cor_mat[(i*I)+j]));
		}
	}
fclose(fptr);

for (i = 0; i < I; i++)  {
	printf("%i ",id[i]);
	}
printf("\n");

u = (double *)malloc(I*sizeof(double));
s = (double *)malloc(I*sizeof(double));
z = (double *)malloc(I*sizeof(double));

fptr = fopen(sobol_name,"r");
for (k = 0; k < I; k++)  {
	fscanf(fptr,"%*le");
	}
for (i = 0; i < n_proc; i++)  {
	sprintf(out_name,"u_matrix_%i.dat",i);
	fptr_out = fopen(out_name,"w");
	for (j = 0; j < I; j++)  {
		fprintf(fptr_out,"%i ",id[j]);
		}
	fprintf(fptr_out,"\n");
	for (j = 0; j < n_sobol_proc; j++)  {
		for (k = 0; k < I; k++)  {
			fscanf(fptr,"%le",&(u[k]));
			s[k] = qnorm(u[k]);
			}
		/*
		for (k = 0; k < I; k++)  {
			z[k] = s[k];
			}
		*/
		for (k = 0; k < I; k++)  {
			z[k] = 0;
			for (m = 0; m <= k; m++)  {
				z[k] = z[k] + (chol_cor_mat[(k*I)+m]*s[m]);
				}
			}
		for (k = 0; k < I; k++)  {
			fprintf(fptr_out,"%le ",z[k]);
			}
		fprintf(fptr_out,"\n");
		}
	fclose(fptr_out);
	}
fclose(fptr);
}



