#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <mpi.h>


double	qnorm(double u)  
{
double	t1,t2;
double	x,erfinv,z;

t1 = 2/(3.14159*0.14);

x = 2*u - 1;
t2 = log(1-(x*x));

erfinv = sqrt(-t1-(t2/2)+sqrt(pow(t1+(t2/2),2.0)-(t2/0.14)));

z = sqrt(2.0)*erfinv;

if (u < 0.5) z = -z;

return(z);
}


void main(int argc,char *argv[])
{
int	node,totnodes;
int	n_proc,I,n_sobol;
char	cor_name[256],sobol_name[256];
int	n_sobol_proc;
int	*id;
double	*chol_cor_mat,*u,*s,*z;
char	out_name[256];
int	i,j,k,m;
FILE	*fptr,*fptr_out;
double	d;

MPI_Init(&argc,&argv);
MPI_Comm_size(MPI_COMM_WORLD,&totnodes);
MPI_Comm_rank(MPI_COMM_WORLD,&node);

if (argc != 6)  {
	if (node == 0)  {
		printf("<n_proc> <I> <cor_name> <n_sobol> <sobol_name>\n");
		}
        MPI_Finalize();
        exit(0);
	}

sscanf(argv[1],"%i",&n_proc);
sscanf(argv[2],"%i",&I);
sscanf(argv[3],"%s",cor_name);
sscanf(argv[4],"%i",&n_sobol);
sscanf(argv[5],"%s",sobol_name);

n_sobol_proc = (int)(n_sobol / n_proc);

id = (int *)malloc(I*sizeof(int));
chol_cor_mat = (double *)malloc(I*I*sizeof(double));
fptr = fopen(cor_name,"r");
for (i = 0; i < I; i++)  {
	fscanf(fptr,"%i",&(id[i]));
	}
for (i = 0; i < I; i++)  {
	fscanf(fptr,"%*i");
	for (j = 0; j < I; j++)  {
		fscanf(fptr,"%le",&(chol_cor_mat[(i*I)+j]));
		}
	}
fclose(fptr);

u = (double *)malloc(I*sizeof(double));
s = (double *)malloc(I*sizeof(double));
z = (double *)malloc(I*sizeof(double));

fptr = fopen(sobol_name,"r");
for (i = 0; i < I; i++)  {
	fscanf(fptr,"%*le");
	}
for (i = 0; i < (node*n_sobol_proc); i++)  {
	for (j = 0; j < I; j++)  {
		fscanf(fptr,"%*le");
		}
	}

sprintf(out_name,"u_matrix_%i.dat",node);
fptr_out = fopen(out_name,"w");
for (i = 0; i < I; i++)  {
	fprintf(fptr_out,"%i ",id[i]);
	}
fprintf(fptr_out,"\n");
for (i = 0; i < n_sobol_proc; i++)  {
	for (j = 0; j < I; j++)  {
		fscanf(fptr,"%le",&(u[j]));
		s[j] = qnorm(u[j]);
		}
	for (j = 0; j < I; j++)  {
		z[j] = 0;
		for (k = 0; k <= j; k++)  {
			z[j] = z[j] + (chol_cor_mat[(j*I)+k]*s[k]);
			}
		}
	for (j = 0; j < I; j++)  {
		fprintf(fptr_out,"%le ",z[j]);
		}
	fprintf(fptr_out,"\n");
	}
fclose(fptr_out);

fclose(fptr);
}



