#include <stdlib.h>
#include <stdio.h>
#include <math.h>



int invert_matrix_2x2(double *mat,double *invmat)
{
double	x11,x12,x22;
double	y11,y12,y22;
double	Z;

x11=mat[0]; x12=mat[1]; 
	    x22=mat[3];

Z = x11*x22 - x12*x12;

invmat[0]=x22/Z; invmat[1]=-x12/Z; 
invmat[2]=-x12/Z; invmat[3]=x11/Z; 

if (Z == 0) return(1);
return(0);
}



int invert_matrix_3x3(double *mat,double *invmat)
{
double	a,b,c,d,e,f,g,h,k;
double	A,B,C,D,E,F,G,H,K,Z;

a = mat[0]; b = mat[1]; c = mat[2];
d = mat[3]; e = mat[4]; f = mat[5];
g = mat[6]; h = mat[7]; k = mat[8];

A = e*k - f*h; B = c*h - b*k; C = b*f - c*e;
D = f*g - d*k; E = a*k - c*g; F = c*d - a*f;
G = d*h - e*g; H = b*g - a*h; K = a*e - b*d;

Z = a*(e*k - f*h) + b*(f*g - d*k) + c*(d*h - e*g);

invmat[0] = A/Z; invmat[1] = B/Z; invmat[2] = C/Z;
invmat[3] = D/Z; invmat[4] = E/Z; invmat[5] = F/Z;
invmat[6] = G/Z; invmat[7] = H/Z; invmat[8] = K/Z;

if (Z == 0) return(1);
return(0);
}



int invert_matrix_4x4(double *mat,double *invmat)
{
double	x11,x12,x13,x14,
	    x22,x23,x24,
		x33,x34,
		    x44;
double	y11,y12,y13,y14,
            y22,y23,y24,
                y33,y34,
                    y44;
double	Z;


x11=mat[0]; x12=mat[1]; x13=mat[2];  x14=mat[3];
            x22=mat[5]; x23=mat[6];  x24=mat[7];
                        x33=mat[10]; x34=mat[11];
                                     x44=mat[15];

y11 = 2*x34*x23*x24 + x33*x44*x22 - x24*x24*x33 - x34*x34*x22 - x23*x23*x44;
y12 = -(-x12*x34*x34 - x13*x23*x44 + x13*x24*x34 + x12*x44*x33 + x14*x23*x34 - x14*x24*x33);
y13 = -x44*x13*x22 + x12*x23*x44 - x14*x24*x23 + x13*x24*x24 - x12*x34*x24 + x14*x34*x22;
y14 = -(-x14*x23*x23 + x24*x13*x23 - x24*x12*x33 - x34*x13*x22 + x12*x34*x23 + x14*x33*x22);

y22 = -x13*x13*x44 - x34*x34*x11 + 2*x34*x13*x14 + x33*x11*x44 - x33*x14*x14;
y23 = -(x23*x11*x14 - x23*x14*x14 + x34*x12*x14 - x34*x11*x24 - x13*x44*x12 + x14*x13*x24);
y24 = x12*x14*x33 - x11*x24*x33 - x13*x23*x14 + x11*x23*x34 - x12*x34*x13 + x13*x13*x24;

y33 = 2*x24*x12*x14 - x14*x14*x22 - x24*x24*x11 - x12*x12*x44 + x11*x22*x44;
y34 = -(x13*x24*x12 + x23*x14*x12 - x23*x11*x24 - x14*x13*x22 - x34*x12*x12 + x34*x11*x22);

y44 = -x13*x13*x22 + 2*x23*x12*x13 - x23*x23*x11 - x12*x12*x33 + x11*x22*x33;

Z = -x11*x22*x34*x34 - x11*x23*x23*x44 + 2*x11*x23*x24*x34 + x11*x22*x44*x33 -
    x11*x24*x24*x33 + 2*x44*x12*x13*x23 - x44*x22*x13*x13 - x44*x12*x12*x33 - 
    2*x12*x34*x14*x23 + x23*x23*x14*x14 + 2*x24*x14*x12*x33 + 2*x22*x34*x13*x14 - 
    2*x12*x13*x34*x24 + x12*x12*x34*x34 + x13*x13*x24*x24 - 2*x13*x24*x14*x23 -
    x22*x33*x14*x14;

invmat[0]=y11/Z;  invmat[1]=y12/Z;  invmat[2]=y13/Z;  invmat[3]=y14/Z;
invmat[4]=y12/Z;  invmat[5]=y22/Z;  invmat[6]=y23/Z;  invmat[7]=y24/Z;
invmat[8]=y13/Z;  invmat[9]=y23/Z;  invmat[10]=y33/Z; invmat[11]=y34/Z;
invmat[12]=y14/Z; invmat[13]=y24/Z; invmat[14]=y34/Z; invmat[15]=y44/Z;

if (Z == 0) return(1);
return(0);
}



int invert_matrix_5x5(double *mat,double *invmat)
{
double	x11,x12,x13,x14,x15,
	    x22,x23,x24,x25,
		x33,x34,x35,
		    x44,x45,
		        x55;
double	y11,y12,y13,y14,y15,
            y22,y23,y24,y25,
                y33,y34,y35,
                    y44,y45,
			y55;
double	Z;


x11=mat[0]; x12=mat[1]; x13=mat[2];  x14=mat[3];  x15=mat[4];
            x22=mat[6]; x23=mat[7];  x24=mat[8];  x25=mat[9];
                        x33=mat[12]; x34=mat[13]; x35=mat[14];
                                     x44=mat[18]; x45=mat[19];
						  x55=mat[24];

y11 = (x34*x34*x25*x25 + x23*x23*x45*x45 + x24*x24*x35*x35 - x34*x34*x22*x55 - x33*x45*x45*x22 - 
       x23*x23*x44*x55 - x33*x25*x25*x44 - x35*x35*x44*x22 - x24*x24*x33*x55 - 2*x34*x25*x23*x45 + 
       x33*x55*x22*x44 + 2*x35*x23*x25*x44 + 2*x35*x22*x34*x45 - 2*x24*x35*x23*x45 - 2*x24*x35*x34*x25 + 
       2*x24*x33*x25*x45 + 2*x24*x23*x34*x55); 
y12 = -(x44*x35*x13*x25 - x44*x15*x25*x33 + x44*x35*x15*x23 + x13*x23*x45*x45 + x24*x15*x45*x33 - 
        x35*x14*x45*x23 + x24*x14*x35*x35 - x34*x24*x35*x15 - x24*x13*x35*x45 + x25*x14*x45*x33 - 
        x34*x15*x45*x23 - x34*x13*x25*x45 - x34*x14*x35*x25 + 2*x34*x12*x35*x45 + x34*x34*x15*x25 - 
        x12*x33*x45*x45 - x55*x34*x34*x12 + x55*x34*x24*x13 - x55*x24*x14*x33 + x55*x34*x14*x23 + 
        x44*x55*x12*x33 - x44*x55*x23*x13 - x44*x12*x35*x35);
y13 = (x15*x45*x23*x24 - 2*x24*x13*x25*x45 + x14*x25*x35*x24 - x12*x45*x45*x23 - x24*x24*x15*x35 + 
       x55*x24*x24*x13 - x15*x23*x25*x44 - x35*x12*x44*x25 + x14*x23*x25*x45 + x22*x14*x55*x34 - 
       x22*x45*x15*x34 - x34*x55*x24*x12 + x34*x24*x15*x25 + x34*x25*x12*x45 + x55*x12*x44*x23 - 
       x55*x14*x23*x24 + x13*x25*x25*x44 - x22*x13*x44*x55 - x22*x14*x35*x45 + x22*x15*x44*x35 + 
       x22*x13*x45*x45  - x34*x14*x25*x25  + x24*x12*x35*x45);
y14 = -(x23*x34*x55*x12 - x23*x23*x14*x55 - x24*x33*x55*x12 + x24*x13*x23*x55 + x33*x55*x22*x14 - 
	x13*x22*x34*x55 - x13*x23*x25*x45 + x23*x23*x45*x15 + x35*x13*x22*x45 + 2*x35*x23*x25*x14 + 
	x13*x25*x25*x34 - x24*x35*x13*x25 - x24*x35*x23*x15 + x33*x25*x45*x12 - x35*x35*x22*x14 - 
	x35*x23*x45*x12 - x33*x25*x25*x14 + x24*x33*x15*x25 - x34*x25*x23*x15 - x35*x12*x34*x25 + 
	x35*x22*x34*x15 - x33*x15*x22*x45 + x24*x12*x35*x35);
y15 = (-x35*x22*x14*x34 - x35*x24*x24*x13 + x35*x34*x24*x12 - x35*x12*x44*x23 + x35*x14*x23*x24 + 
       x35*x22*x13*x44 + x45*x23*x34*x12 - x45*x23*x23*x14 - x45*x24*x33*x12 + x45*x24*x13*x23 + 
       x45*x33*x22*x14 - x45*x13*x22*x34 + x15*x24*x24*x33 + x15*x22*x34*x34 - x44*x15*x33*x22 + 
       x44*x15*x23*x23 - 2*x15*x34*x24*x23 - x25*x34*x34*x12 + x25*x34*x24*x13 - x25*x24*x14*x33 + 
       x25*x34*x14*x23 + x25*x44*x12*x33 - x25*x44*x23*x13);

y22 = (-x15*x15*x44*x33 + x34*x34*x15*x15  + x35*x35*x14*x14 + x45*x45*x13*x13  + 2*x34*x45*x35*x11 - 
       x34*x34*x55*x11 - x44*x55*x13*x13 + x44*x55*x11*x33 - x45*x45*x11*x33 - 2*x34*x15*x13*x45 - 
       2*x35*x14*x13*x45 + 2*x14*x15*x45*x33 - x14*x14*x55*x33 + 2*x34*x55*x14*x13 - x35*x35*x44*x11 + 
       2*x35*x44*x15*x13 - 2*x34*x14*x15*x35);
y23 = -(2*x45*x14*x15*x23 - x45*x15*x13*x24 - x14*x45*x13*x25 - x14*x14*x23*x55 - x45*x45*x11*x23 + 
	x12*x45*x45*x13 + x11*x23*x44*x55 - x15*x15*x23*x44 - x12*x13*x44*x55 - x15*x14*x25*x34 - 
	x12*x45*x15*x34 + x11*x45*x25*x34 + x15*x15*x24*x34 + x12*x14*x34*x55 - x11*x24*x34*x55 - 
	x15*x14*x24*x35 + x11*x45*x24*x35 - x12*x14*x45*x35 - x11*x25*x35*x44 + x15*x12*x35*x44 + 
	x15*x13*x25*x44 + x14*x13*x24*x55 + x14*x14*x25*x35); 
y24 = (x55*x14*x12*x33 - x55*x24*x11*x33 - x55*x14*x23*x13 + x55*x24*x13*x13 + x55*x23*x11*x34 - 
       x55*x34*x12*x13 - x35*x25*x11*x34 + x24*x33*x15*x15 + x14*x35*x15*x23 - x23*x34*x15*x15 - 
       x14*x15*x25*x33 - x45*x25*x13*x13 - x23*x35*x45*x11 - x14*x12*x35*x35 + x24*x11*x35*x35 + 
       x45*x25*x11*x33 + x34*x12*x15*x35 - x15*x45*x12*x33 + x35*x45*x12*x13 + x14*x35*x13*x25 - 
       2*x24*x35*x15*x13 + x25*x34*x15*x13 + x23*x15*x45*x13);
y25 = -(x24*x45*x13*x13 + x24*x15*x14*x33 - x24*x45*x11*x33 + x24*x35*x11*x34 - x24*x14*x35*x13 - 
	x24*x34*x15*x13 - x34*x15*x14*x23 - x34*x45*x12*x13 + x34*x45*x23*x11 - x35*x44*x23*x11 - 
        x35*x14*x34*x12 - x34*x34*x25*x11 - x25*x44*x13*x13 + x25*x44*x11*x33 + x34*x34*x15*x12 + 
        x35*x14*x14*x23 + x45*x14*x12*x33 - x15*x44*x12*x33 + x35*x44*x12*x13 - x14*x14*x25*x33 + 
        x23*x15*x13*x44 - x23*x45*x14*x13 + 2*x34*x25*x14*x13); 

y33 = (2*x45*x25*x24*x11 - x22*x45*x45*x11 - x25*x25*x44*x11 + x15*x15*x24*x24 - x14*x14*x22*x55 + 
       x12*x12*x45*x45  + x14*x14*x25*x25  - x55*x24*x24*x11 - x12*x12*x44*x55 + x22*x55*x44*x11 + 
       2*x25*x15*x12*x44 - x15*x15*x22*x44 - 2*x24*x45*x15*x12 - 2*x25*x45*x14*x12 + 2*x45*x14*x15*x22 - 
       2*x25*x15*x14*x24 + 2*x24*x14*x12*x55);

y34 = -(-x22*x55*x14*x13 + x22*x55*x11*x34 + x22*x15*x45*x13 - x22*x35*x45*x11 + x22*x14*x15*x35 - 
        x22*x34*x15*x15 - x55*x23*x24*x11 + x55*x14*x12*x23 - x55*x34*x12*x12 + x55*x24*x12*x13 - 
        x15*x45*x12*x23 - x24*x12*x15*x35 - x24*x15*x25*x13 + x23*x25*x45*x11 + x25*x35*x24*x11 - 
        x34*x11*x25*x25 + x23*x24*x15*x15 - x25*x45*x12*x13 + 2*x34*x15*x12*x25 - x14*x35*x12*x25 + 
        x35*x45*x12*x12 + x14*x13*x25*x25 - x14*x15*x23*x25);
y35 = (-x22*x34*x15*x14 + x22*x34*x11*x45 - x22*x35*x44*x11 + x22*x15*x13*x44 + x22*x35*x14*x14 - 
       x22*x45*x14*x13 - x34*x45*x12*x12 + x34*x12*x25*x14 + x34*x15*x24*x12 - x34*x24*x25*x11 + 
       x35*x44*x12*x12 + x15*x14*x23*x24 + x45*x24*x12*x13 - x15*x12*x44*x23 - x23*x25*x14*x14 - 
       2*x35*x14*x24*x12 - x45*x23*x24*x11 - x12*x25*x13*x44 + x23*x25*x44*x11 + x24*x24*x35*x11 - 
       x15*x24*x24*x13 + x24*x25*x14*x13 + x45*x14*x12*x23);

y44 = (x15*x15*x23*x23 - x15*x15*x33*x22 + x22*x11*x55*x33 - x55*x11*x23*x23 + 2*x55*x13*x23*x12 - 
       x22*x55*x13*x13 - x55*x12*x12*x33 + x25*x25*x13*x13 + 2*x35*x23*x25*x11 - 2*x23*x25*x15*x13 - 
       2*x35*x25*x12*x13 - x25*x25*x11*x33 + 2*x25*x15*x12*x33 + x35*x35*x12*x12 + 2*x15*x35*x13*x22 - 
       2*x15*x35*x23*x12 - x22*x35*x35*x11); 
y45 = -(x15*x23*x23*x14 - x15*x33*x22*x14 - x45*x22*x13*x13 - x45*x12*x12*x33 + x45*x22*x11*x33 - 
        x45*x11*x23*x23 + 2*x45*x13*x23*x12 - x14*x35*x12*x23 + x14*x35*x22*x13 + x34*x15*x22*x13 - 
        x35*x24*x12*x13 - x34*x22*x35*x11 + x14*x25*x12*x33 - x14*x25*x23*x13 + x24*x15*x12*x33 - 
        x25*x24*x11*x33 + x25*x24*x13*x13 - x34*x15*x12*x23 + x35*x23*x24*x11 + x35*x34*x12*x12 + 
        x23*x25*x11*x34 - x12*x34*x25*x13 - x23*x15*x24*x13); 

y55 = (x23*x23*x14*x14 + x34*x34*x12*x12 - x22*x13*x13*x44 - x12*x12*x33*x44 + x22*x11*x33*x44 - 
       x11*x23*x23*x44 + 2*x13*x44*x23*x12 - x33*x22*x14*x14 - 2*x14*x23*x34*x12 + 2*x14*x13*x22*x34 + 
       x24*x24*x13*x13 - x22*x34*x34*x11 - 2*x23*x24*x14*x13 + 2*x34*x23*x24*x11 - 2*x34*x24*x12*x13 - 
       x24*x24*x11*x33 + 2*x24*x14*x12*x33);

Z = x11*x24*x24*x35*x35  + x11*x23*x23*x45*x45  + x22*x35*x35*x14*x14  + x15*x15*x23*x23*x44 + x55*x24*x24*x13*x13 + 
    x13*x13*x25*x25*x44 + x15*x15*x24*x24*x33 + x34*x34*x11*x25*x25  + x14*x14*x25*x25*x33 + x22*x13*x13*x45*x45 + 
    x12*x12*x35*x35*x44 + x55*x14*x14*x23*x23  + x12*x12*x33*x45*x45  - 2*x24*x13*x13*x25*x45 + 2*x11*x35*x23*x25*x44 - 
    2*x34*x35*x12*x12*x45 - x55*x12*x12*x33*x44 - x55*x11*x24*x24*x33 - 2*x55*x14*x24*x13*x23 - x22*x11*x55*x34*x34 - 
    x22*x55*x13*x13*x44 - 2*x22*x13*x14*x45*x35 + 2*x22*x33*x45*x14*x15 + x22*x34*x34*x15*x15 + x22*x11*x55*x33*x44 + 
    2*x22*x35*x15*x13*x44 + 2*x34*x24*x13*x15*x25 - 2*x34*x34*x15*x12*x25 - x22*x33*x15*x15*x44 - x22*x11*x33*x45*x45 - 
    x22*x11*x35*x35*x44 + 2*x22*x55*x13*x14*x34 - 2*x22*x13*x45*x15*x34 + 2*x22*x11*x35*x45*x34 - 2*x22*x14*x35*x15*x34 - 
    x22*x55*x33*x14*x14 + 2*x15*x45*x24*x13*x23 + 2*x11*x24*x33*x25*x45 - 2*x11*x24*x35*x23*x45 + 2*x14*x35*x23*x45*x12 + 
    2*x34*x12*x45*x23*x15 - 2*x34*x11*x23*x25*x45 - 2*x34*x24*x35*x11*x25 + 2*x34*x24*x35*x15*x12 + 2*x34*x13*x25*x45*x12 - 
    2*x34*x24*x15*x15*x23 - 2*x14*x24*x33*x15*x25 - 2*x35*x15*x44*x23*x12 - 2*x13*x44*x35*x12*x25 - 2*x13*x44*x25*x23*x15 - 
    x55*x11*x23*x23*x44 + 2*x55*x24*x12*x33*x14 + 2*x55*x13*x44*x23*x12 - x11*x25*x25*x33*x44 - 2*x34*x12*x14*x23*x55 + 
    2*x34*x15*x23*x25*x14 + 2*x34*x35*x12*x14*x25 + 2*x34*x24*x11*x23*x55 - 2*x15*x45*x23*x23*x14 + 2*x15*x12*x25*x33*x44 - 
    2*x34*x24*x13*x55*x12 - 2*x34*x13*x25*x25*x14 + 2*x24*x12*x35*x13*x45 + 2*x14*x24*x35*x23*x15 + 2*x14*x24*x35*x13*x25 - 
    2*x14*x33*x25*x45*x12 - 2*x24*x12*x33*x15*x45 - 2*x14*x14*x35*x23*x25 - 2*x13*x45*x45*x23*x12 - 2*x24*x24*x15*x35*x13 - 
    2*x24*x12*x35*x35*x14 + 2*x14*x23*x25*x45*x13 + x34*x34*x12*x12*x55;

invmat[0]=y11/Z;  invmat[1]=y12/Z;  invmat[2]=y13/Z;  invmat[3]=y14/Z;  invmat[4]=y15/Z;
invmat[5]=y12/Z;  invmat[6]=y22/Z;  invmat[7]=y23/Z;  invmat[8]=y24/Z;  invmat[9]=y25/Z;
invmat[10]=y13/Z; invmat[11]=y23/Z; invmat[12]=y33/Z; invmat[13]=y34/Z; invmat[14]=y35/Z;
invmat[15]=y14/Z; invmat[16]=y24/Z; invmat[17]=y34/Z; invmat[18]=y44/Z; invmat[19]=y45/Z;
invmat[20]=y15/Z; invmat[21]=y25/Z; invmat[22]=y35/Z; invmat[23]=y45/Z; invmat[24]=y55/Z;

if (Z == 0) return(1);
return(0);
}




int invert_matrix_6x6(double *mat,double *invmat)
{
double	A11[25],A11i[25];
double	a12[5],a22,b;
double	A11i_a12[5];
double	B[25],C[25];
int	i;

A11[0]=mat[0]; A11[1]=mat[1]; A11[2]=mat[2]; A11[3]=mat[3]; A11[4]=mat[4];
A11[5]=mat[6]; A11[6]=mat[7]; A11[7]=mat[8]; A11[8]=mat[9]; A11[9]=mat[10];
A11[10]=mat[12]; A11[11]=mat[13]; A11[12]=mat[14]; A11[13]=mat[15]; A11[14]=mat[16];
A11[15]=mat[18]; A11[16]=mat[19]; A11[17]=mat[20]; A11[18]=mat[21]; A11[19]=mat[22];
A11[20]=mat[24]; A11[21]=mat[25]; A11[22]=mat[26]; A11[23]=mat[27]; A11[24]=mat[28];

invert_matrix_5x5(A11,A11i);

a12[0]=mat[5]; a12[1]=mat[11]; a12[2]=mat[17]; a12[3]=mat[23]; a12[4]=mat[29];

a22=mat[35];

A11i_a12[0] = A11i[0]*a12[0] + A11i[1]*a12[1] + A11i[2]*a12[2] + A11i[3]*a12[3] + A11i[4]*a12[4];
A11i_a12[1] = A11i[5]*a12[0] + A11i[6]*a12[1] + A11i[7]*a12[2] + A11i[8]*a12[3] + A11i[9]*a12[4];
A11i_a12[2] = A11i[10]*a12[0] + A11i[11]*a12[1] + A11i[12]*a12[2] + A11i[13]*a12[3] + A11i[14]*a12[4];
A11i_a12[3] = A11i[15]*a12[0] + A11i[16]*a12[1] + A11i[17]*a12[2] + A11i[18]*a12[3] + A11i[19]*a12[4];
A11i_a12[4] = A11i[20]*a12[0] + A11i[21]*a12[1] + A11i[22]*a12[2] + A11i[23]*a12[3] + A11i[24]*a12[4];

b = a22 - (a12[0]*A11i_a12[0] + a12[1]*A11i_a12[1] + a12[2]*A11i_a12[2] + a12[3]*A11i_a12[3] + a12[4]*A11i_a12[4]);

B[0]=A11i_a12[0]*A11i_a12[0]; B[1]=A11i_a12[0]*A11i_a12[1]; B[2]=A11i_a12[0]*A11i_a12[2]; B[3]=A11i_a12[0]*A11i_a12[3]; B[4]=A11i_a12[0]*A11i_a12[4]; 
B[5]=A11i_a12[1]*A11i_a12[0]; B[6]=A11i_a12[1]*A11i_a12[1]; B[7]=A11i_a12[1]*A11i_a12[2]; B[8]=A11i_a12[1]*A11i_a12[3]; B[9]=A11i_a12[1]*A11i_a12[4]; 
B[10]=A11i_a12[2]*A11i_a12[0]; B[11]=A11i_a12[2]*A11i_a12[1]; B[12]=A11i_a12[2]*A11i_a12[2]; B[13]=A11i_a12[2]*A11i_a12[3]; B[14]=A11i_a12[2]*A11i_a12[4]; 
B[15]=A11i_a12[3]*A11i_a12[0]; B[16]=A11i_a12[3]*A11i_a12[1]; B[17]=A11i_a12[3]*A11i_a12[2]; B[18]=A11i_a12[3]*A11i_a12[3]; B[19]=A11i_a12[3]*A11i_a12[4]; 
B[20]=A11i_a12[4]*A11i_a12[0]; B[21]=A11i_a12[4]*A11i_a12[1]; B[22]=A11i_a12[4]*A11i_a12[2]; B[23]=A11i_a12[4]*A11i_a12[3]; B[24]=A11i_a12[4]*A11i_a12[4]; 

for (i = 0; i < 25; i++)  {
	C[i] = b*A11i[i] + B[i];
	}

invmat[0]=C[0]; invmat[1]=C[1]; invmat[2]=C[2]; invmat[3]=C[3]; invmat[4]=C[4]; invmat[5]=-A11i_a12[0]; 
invmat[6]=C[5]; invmat[7]=C[6]; invmat[8]=C[7]; invmat[9]=C[8]; invmat[10]=C[9]; invmat[11]=-A11i_a12[1]; 
invmat[12]=C[10]; invmat[13]=C[11]; invmat[14]=C[12]; invmat[15]=C[13]; invmat[16]=C[14]; invmat[17]=-A11i_a12[2]; 
invmat[18]=C[15]; invmat[19]=C[16]; invmat[20]=C[17]; invmat[21]=C[18]; invmat[22]=C[19]; invmat[23]=-A11i_a12[3]; 
invmat[24]=C[20]; invmat[25]=C[21]; invmat[26]=C[22]; invmat[27]=C[23]; invmat[28]=C[24]; invmat[29]=-A11i_a12[4]; 
invmat[30]=-A11i_a12[0]; invmat[31]=-A11i_a12[1]; invmat[32]=-A11i_a12[2]; invmat[33]=-A11i_a12[3]; invmat[34]=-A11i_a12[4]; invmat[35]=1; 

for (i = 0; i < 36; i++)  {
	invmat[i] = invmat[i] / b;
	}

if (b == 0) return(1);
return(0);
}

