#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <mpi.h>

#include "external_functions.h"



typedef struct  {
        double  L;
        double  DL_theta,DL_cov1,DL_cov2,DL_cov3,DL_s;
        double  D2L_theta,D2L_cov1,D2L_cov2,D2L_cov3,D2L_s;
        double  D2L_theta_cov1,D2L_theta_cov2,D2L_theta_cov3,D2L_theta_s;
        double  D2L_cov1_cov2,D2L_cov1_cov3,D2L_cov1_s;
        double  D2L_cov2_cov3,D2L_cov2_s;
        double  D2L_cov3_s;
} derivative_return;



derivative_return derivative_binomial_glmm(double theta,double cov1_size,double cov2_size,double cov3_size,double s,
                                 	   int nobs,double *Y,double *cov1,double *cov2,double *cov3,
                                 	   int ncube,double *u_vec,double *pu_vec,int *u_index_vec)  
{
double          	u,pu;
int			u_index;
double          	z,p;
double          	L;
double          	Dlz_theta,Dlz_cov1,Dlz_cov2,Dlz_cov3,Dlz_s;
double          	D2lz_theta,D2lz_cov1,D2lz_cov2,D2lz_cov3,D2lz_s;
double          	D2lz_theta_cov1,D2lz_theta_cov2,D2lz_theta_cov3,D2lz_theta_s;
double          	D2lz_cov1_cov2,D2lz_cov1_cov3,D2lz_cov1_s;
double          	D2lz_cov2_cov3,D2lz_cov2_s;
double          	D2lz_cov3_s;
double          	prod_L;
double          	sum_Dlz_theta,sum_Dlz_cov1,sum_Dlz_cov2,sum_Dlz_cov3,sum_Dlz_s;
double          	sum_D2lz_theta,sum_D2lz_cov1,sum_D2lz_cov2,sum_D2lz_cov3,sum_D2lz_s;
double          	sum_D2lz_theta_cov1,sum_D2lz_theta_cov2,sum_D2lz_theta_cov3,sum_D2lz_theta_s;
double          	sum_D2lz_cov1_cov2,sum_D2lz_cov1_cov3,sum_D2lz_cov1_s;
double          	sum_D2lz_cov2_cov3,sum_D2lz_cov2_s;
double          	sum_D2lz_cov3_s;
double          	L_acc;
double          	DL_theta_acc,DL_cov1_acc,DL_cov2_acc,DL_cov3_acc,DL_s_acc;
double          	D2L_theta_acc,D2L_cov1_acc,D2L_cov2_acc,D2L_cov3_acc,D2L_s_acc;
double          	D2L_theta_cov1_acc,D2L_theta_cov2_acc,D2L_theta_cov3_acc,D2L_theta_s_acc;
double          	D2L_cov1_cov2_acc,D2L_cov1_cov3_acc,D2L_cov1_s_acc;
double          	D2L_cov2_cov3_acc,D2L_cov2_s_acc;
double          	D2L_cov3_s_acc;
double			pL_pu;
derivative_return	ret_struct;
int             	i,c;


L_acc = 0;

DL_theta_acc = 0;
DL_cov1_acc = 0;
DL_cov2_acc = 0;
DL_cov3_acc = 0;
DL_s_acc = 0;

D2L_theta_acc = 0;
D2L_cov1_acc = 0;
D2L_cov2_acc = 0;
D2L_cov3_acc = 0;
D2L_s_acc = 0;

D2L_theta_cov1_acc = 0;
D2L_theta_cov2_acc = 0;
D2L_theta_cov3_acc = 0;
D2L_theta_s_acc = 0;

D2L_cov1_cov2_acc = 0;
D2L_cov1_cov3_acc = 0;
D2L_cov1_s_acc = 0;

D2L_cov2_cov3_acc = 0;
D2L_cov2_s_acc = 0;

D2L_cov3_s_acc = 0;

for (c = 0; c < ncube; c++)  {
        pu = pu_vec[c];

        prod_L = 1;

        sum_Dlz_theta = 0;
        sum_Dlz_cov1 = 0;
        sum_Dlz_cov2 = 0;
        sum_Dlz_cov3 = 0;
        sum_Dlz_s = 0;

        sum_D2lz_theta = 0;
        sum_D2lz_cov1 = 0;
        sum_D2lz_cov2 = 0;
        sum_D2lz_cov3 = 0;
        sum_D2lz_s = 0;

        sum_D2lz_theta_cov1 = 0;
        sum_D2lz_theta_cov2 = 0;
        sum_D2lz_theta_cov3 = 0;
        sum_D2lz_theta_s = 0;

        sum_D2lz_cov1_cov2 = 0;
        sum_D2lz_cov1_cov3 = 0;
        sum_D2lz_cov1_s = 0;

        sum_D2lz_cov2_cov3 = 0;
        sum_D2lz_cov2_s = 0;

        sum_D2lz_cov3_s = 0;

	u_index = u_index_vec[c];

        for (i = 0; i < nobs; i++)  {
		u = u_vec[(u_index*nobs)+i];

                z = theta + cov1_size*cov1[i] + cov2_size*cov2[i] + cov3_size*cov3[i] + s*u;
                p = exp(z) / (1 + exp(z));

                L = pow(p,Y[i]) * pow(1-p,1-Y[i]);

                prod_L = prod_L * L;

                Dlz_theta = Y[i] - p;
                Dlz_cov1 = cov1[i]*Dlz_theta;
                Dlz_cov2 = cov2[i]*Dlz_theta;
                Dlz_cov3 = cov3[i]*Dlz_theta;
                Dlz_s = u*Dlz_theta;

                D2lz_theta = p*p - p;

                D2lz_theta_cov1 = cov1[i]*D2lz_theta;
                D2lz_theta_cov2 = cov2[i]*D2lz_theta;
                D2lz_theta_cov3 = cov3[i]*D2lz_theta;
                D2lz_theta_s = u*D2lz_theta;

                D2lz_cov1 = cov1[i]*D2lz_theta_cov1;
                D2lz_cov2 = cov2[i]*D2lz_theta_cov2;
		D2lz_cov3 = cov3[i]*D2lz_theta_cov3;
                D2lz_s = u*D2lz_theta_s;

                D2lz_cov1_cov2 = cov1[i]*D2lz_theta_cov2;
                D2lz_cov1_cov3 = cov1[i]*D2lz_theta_cov3;
                D2lz_cov1_s = cov1[i]*D2lz_theta_s;

                D2lz_cov2_cov3 = cov2[i]*D2lz_theta_cov3;
                D2lz_cov2_s = cov2[i]*D2lz_theta_s;

                D2lz_cov3_s = cov3[i]*D2lz_theta_s;

                sum_Dlz_theta = sum_Dlz_theta + Dlz_theta;
                sum_Dlz_cov1 = sum_Dlz_cov1 + Dlz_cov1;
                sum_Dlz_cov2 = sum_Dlz_cov2 + Dlz_cov2;
                sum_Dlz_cov3 = sum_Dlz_cov3 + Dlz_cov3;
                sum_Dlz_s = sum_Dlz_s + Dlz_s;

                sum_D2lz_theta = sum_D2lz_theta + D2lz_theta;
                sum_D2lz_cov1 = sum_D2lz_cov1 + D2lz_cov1;
                sum_D2lz_cov2 = sum_D2lz_cov2 + D2lz_cov2;
                sum_D2lz_cov3 = sum_D2lz_cov3 + D2lz_cov3;
                sum_D2lz_s = sum_D2lz_s + D2lz_s;

       	        sum_D2lz_theta_cov1 = sum_D2lz_theta_cov1 + D2lz_theta_cov1;
       	        sum_D2lz_theta_cov2 = sum_D2lz_theta_cov2 + D2lz_theta_cov2;
       	        sum_D2lz_theta_cov3 = sum_D2lz_theta_cov3 + D2lz_theta_cov3;
               	sum_D2lz_theta_s = sum_D2lz_theta_s + D2lz_theta_s;

               	sum_D2lz_cov1_cov2 = sum_D2lz_cov1_cov2 + D2lz_cov1_cov2;
               	sum_D2lz_cov1_cov3 = sum_D2lz_cov1_cov3 + D2lz_cov1_cov3;
               	sum_D2lz_cov1_s = sum_D2lz_cov1_s + D2lz_cov1_s;

               	sum_D2lz_cov2_cov3 = sum_D2lz_cov2_cov3 + D2lz_cov2_cov3;
               	sum_D2lz_cov2_s = sum_D2lz_cov2_s + D2lz_cov2_s;

               	sum_D2lz_cov3_s = sum_D2lz_cov3_s + D2lz_cov3_s;
               	}

	pL_pu = prod_L*pu;

        L_acc = L_acc + pL_pu;

        DL_theta_acc = DL_theta_acc + sum_Dlz_theta*pL_pu;
        DL_cov1_acc = DL_cov1_acc + sum_Dlz_cov1*pL_pu;
        DL_cov2_acc = DL_cov2_acc + sum_Dlz_cov2*pL_pu;
        DL_cov3_acc = DL_cov3_acc + sum_Dlz_cov3*pL_pu;
        DL_s_acc = DL_s_acc + sum_Dlz_s*pL_pu;

        D2L_theta_acc = D2L_theta_acc + (sum_D2lz_theta + sum_Dlz_theta*sum_Dlz_theta)*pL_pu;
        D2L_cov1_acc = D2L_cov1_acc + (sum_D2lz_cov1 + sum_Dlz_cov1*sum_Dlz_cov1)*pL_pu;
        D2L_cov2_acc = D2L_cov2_acc + (sum_D2lz_cov2 + sum_Dlz_cov2*sum_Dlz_cov2)*pL_pu;
        D2L_cov3_acc = D2L_cov3_acc + (sum_D2lz_cov3 + sum_Dlz_cov3*sum_Dlz_cov3)*pL_pu;
        D2L_s_acc = D2L_s_acc + (sum_D2lz_s + sum_Dlz_s*sum_Dlz_s)*pL_pu;

        D2L_theta_cov1_acc = D2L_theta_cov1_acc + (sum_D2lz_theta_cov1 + sum_Dlz_theta*sum_Dlz_cov1)*pL_pu;
        D2L_theta_cov2_acc = D2L_theta_cov2_acc + (sum_D2lz_theta_cov2 + sum_Dlz_theta*sum_Dlz_cov2)*pL_pu;
        D2L_theta_cov3_acc = D2L_theta_cov3_acc + (sum_D2lz_theta_cov3 + sum_Dlz_theta*sum_Dlz_cov3)*pL_pu;
        D2L_theta_s_acc = D2L_theta_s_acc + (sum_D2lz_theta_s + sum_Dlz_theta*sum_Dlz_s)*pL_pu;

        D2L_cov1_cov2_acc = D2L_cov1_cov2_acc + (sum_D2lz_cov1_cov2 + sum_Dlz_cov1*sum_Dlz_cov2)*pL_pu;
        D2L_cov1_cov3_acc = D2L_cov1_cov3_acc + (sum_D2lz_cov1_cov3 + sum_Dlz_cov1*sum_Dlz_cov3)*pL_pu;
        D2L_cov1_s_acc = D2L_cov1_s_acc + (sum_D2lz_cov1_s + sum_Dlz_cov1*sum_Dlz_s)*pL_pu;

        D2L_cov2_cov3_acc = D2L_cov2_cov3_acc + (sum_D2lz_cov2_cov3 + sum_Dlz_cov2*sum_Dlz_cov3)*pL_pu;
        D2L_cov2_s_acc = D2L_cov2_s_acc + (sum_D2lz_cov2_s + sum_Dlz_cov2*sum_Dlz_s)*pL_pu;

        D2L_cov3_s_acc = D2L_cov3_s_acc + (sum_D2lz_cov3_s + sum_Dlz_cov3*sum_Dlz_s)*pL_pu;
	}


ret_struct.L = L_acc;

ret_struct.DL_theta = DL_theta_acc;
ret_struct.DL_cov1 = DL_cov1_acc;
ret_struct.DL_cov2 = DL_cov2_acc;
ret_struct.DL_cov3 = DL_cov3_acc;
ret_struct.DL_s = DL_s_acc;

ret_struct.D2L_theta = D2L_theta_acc;
ret_struct.D2L_cov1 = D2L_cov1_acc;
ret_struct.D2L_cov2 = D2L_cov2_acc;
ret_struct.D2L_cov3 = D2L_cov3_acc;
ret_struct.D2L_s = D2L_s_acc;

ret_struct.D2L_theta_cov1 = D2L_theta_cov1_acc;
ret_struct.D2L_theta_cov2 = D2L_theta_cov2_acc;
ret_struct.D2L_theta_cov3 = D2L_theta_cov3_acc;
ret_struct.D2L_theta_s = D2L_theta_s_acc;

ret_struct.D2L_cov1_cov2 = D2L_cov1_cov2_acc;
ret_struct.D2L_cov1_cov3 = D2L_cov1_cov3_acc;
ret_struct.D2L_cov1_s = D2L_cov1_s_acc;

ret_struct.D2L_cov2_cov3 = D2L_cov2_cov3_acc;
ret_struct.D2L_cov2_s = D2L_cov2_s_acc;

ret_struct.D2L_cov3_s = D2L_cov3_s_acc;

return(ret_struct);
}



derivative_return gather_nodes(derivative_return d_ret,int totnodes)  
{
MPI_Status	stat;
double		dtool;
int		r;

for (r = 1; r < totnodes; r++)  {
       	MPI_Recv(&dtool,1,MPI_DOUBLE,r,r,MPI_COMM_WORLD,&stat);
        d_ret.L = d_ret.L + dtool;

	MPI_Recv(&dtool,1,MPI_DOUBLE,r,r,MPI_COMM_WORLD,&stat);
	d_ret.DL_theta = d_ret.DL_theta + dtool;
	MPI_Recv(&dtool,1,MPI_DOUBLE,r,r,MPI_COMM_WORLD,&stat);
	d_ret.DL_cov1 = d_ret.DL_cov1 + dtool;
	MPI_Recv(&dtool,1,MPI_DOUBLE,r,r,MPI_COMM_WORLD,&stat);
	d_ret.DL_cov2 = d_ret.DL_cov2 + dtool;
	MPI_Recv(&dtool,1,MPI_DOUBLE,r,r,MPI_COMM_WORLD,&stat);
	d_ret.DL_cov3 = d_ret.DL_cov3 + dtool;
	MPI_Recv(&dtool,1,MPI_DOUBLE,r,r,MPI_COMM_WORLD,&stat);
	d_ret.DL_s = d_ret.DL_s + dtool;

	MPI_Recv(&dtool,1,MPI_DOUBLE,r,r,MPI_COMM_WORLD,&stat);
	d_ret.D2L_theta = d_ret.D2L_theta + dtool;
	MPI_Recv(&dtool,1,MPI_DOUBLE,r,r,MPI_COMM_WORLD,&stat);
	d_ret.D2L_cov1 = d_ret.D2L_cov1 + dtool;
	MPI_Recv(&dtool,1,MPI_DOUBLE,r,r,MPI_COMM_WORLD,&stat);
	d_ret.D2L_cov2 = d_ret.D2L_cov2 + dtool;
	MPI_Recv(&dtool,1,MPI_DOUBLE,r,r,MPI_COMM_WORLD,&stat);
	d_ret.D2L_cov3 = d_ret.D2L_cov3 + dtool;
	MPI_Recv(&dtool,1,MPI_DOUBLE,r,r,MPI_COMM_WORLD,&stat);
	d_ret.D2L_s = d_ret.D2L_s + dtool;

	MPI_Recv(&dtool,1,MPI_DOUBLE,r,r,MPI_COMM_WORLD,&stat);
	d_ret.D2L_theta_cov1 = d_ret.D2L_theta_cov1 + dtool;
	MPI_Recv(&dtool,1,MPI_DOUBLE,r,r,MPI_COMM_WORLD,&stat);
	d_ret.D2L_theta_cov2 = d_ret.D2L_theta_cov2 + dtool;
	MPI_Recv(&dtool,1,MPI_DOUBLE,r,r,MPI_COMM_WORLD,&stat);
	d_ret.D2L_theta_cov3 = d_ret.D2L_theta_cov3 + dtool;
	MPI_Recv(&dtool,1,MPI_DOUBLE,r,r,MPI_COMM_WORLD,&stat);
	d_ret.D2L_theta_s = d_ret.D2L_theta_s + dtool;

	MPI_Recv(&dtool,1,MPI_DOUBLE,r,r,MPI_COMM_WORLD,&stat);
	d_ret.D2L_cov1_cov2 = d_ret.D2L_cov1_cov2 + dtool;
	MPI_Recv(&dtool,1,MPI_DOUBLE,r,r,MPI_COMM_WORLD,&stat);
	d_ret.D2L_cov1_cov3 = d_ret.D2L_cov1_cov3 + dtool;
	MPI_Recv(&dtool,1,MPI_DOUBLE,r,r,MPI_COMM_WORLD,&stat);
	d_ret.D2L_cov1_s = d_ret.D2L_cov1_s + dtool;

	MPI_Recv(&dtool,1,MPI_DOUBLE,r,r,MPI_COMM_WORLD,&stat);
	d_ret.D2L_cov2_cov3 = d_ret.D2L_cov2_cov3 + dtool;
	MPI_Recv(&dtool,1,MPI_DOUBLE,r,r,MPI_COMM_WORLD,&stat);
	d_ret.D2L_cov2_s = d_ret.D2L_cov2_s + dtool;

	MPI_Recv(&dtool,1,MPI_DOUBLE,r,r,MPI_COMM_WORLD,&stat);
	d_ret.D2L_cov3_s = d_ret.D2L_cov3_s + dtool;
        }

return(d_ret);
}



void calculate_derivatives(derivative_return d_ret,double *L,double *DlnL,double *D2lnL)
{
double          	DL_theta,DL_cov1,DL_cov2,DL_cov3,DL_s;
double          	D2L_theta,D2L_cov1,D2L_cov2,D2L_cov3,D2L_s;
double          	D2L_theta_cov1,D2L_theta_cov2,D2L_theta_cov3,D2L_theta_s;
double          	D2L_cov1_cov2,D2L_cov1_cov3,D2L_cov1_s;
double          	D2L_cov2_cov3,D2L_cov2_s;
double          	D2L_cov3_s;
double          	DlnL_theta,DlnL_cov1,DlnL_cov2,DlnL_cov3,DlnL_s;
double          	D2lnL_theta,D2lnL_cov1,D2lnL_cov2,D2lnL_cov3,D2lnL_s;
double          	D2lnL_theta_cov1,D2lnL_theta_cov2,D2lnL_theta_cov3,D2lnL_theta_s;
double          	D2lnL_cov1_cov2,D2lnL_cov1_cov3,D2lnL_cov1_s;
double          	D2lnL_cov2_cov3,D2lnL_cov2_s;
double          	D2lnL_cov3_s;

*L = d_ret.L;

DL_theta = d_ret.DL_theta;
DL_cov1 = d_ret.DL_cov1;
DL_cov2 = d_ret.DL_cov2;
DL_cov3 = d_ret.DL_cov3;
DL_s = d_ret.DL_s;

D2L_theta = d_ret.D2L_theta;
D2L_cov1 = d_ret.D2L_cov1;
D2L_cov2 = d_ret.D2L_cov2;
D2L_cov3 = d_ret.D2L_cov3;
D2L_s = d_ret.D2L_s;
D2L_theta_cov1 = d_ret.D2L_theta_cov1;
D2L_theta_cov2 = d_ret.D2L_theta_cov2;
D2L_theta_cov3 = d_ret.D2L_theta_cov3;
D2L_theta_s = d_ret.D2L_theta_s;
D2L_cov1_cov2 = d_ret.D2L_cov1_cov2;
D2L_cov1_cov3 = d_ret.D2L_cov1_cov3;
D2L_cov1_s = d_ret.D2L_cov1_s;
D2L_cov2_cov3 = d_ret.D2L_cov2_cov3;
D2L_cov2_s = d_ret.D2L_cov2_s;
D2L_cov3_s = d_ret.D2L_cov3_s;

DlnL_theta = DL_theta / *L;
DlnL_cov1 = DL_cov1 / *L;
DlnL_cov2 = DL_cov2 / *L;
DlnL_cov3 = DL_cov3 / *L;
DlnL_s = DL_s / *L;

DlnL[0] = DlnL_theta;
DlnL[1] = DlnL_cov1;
DlnL[2] = DlnL_cov2;
DlnL[3] = DlnL_cov3;
DlnL[4] = DlnL_s;

D2lnL_theta = (D2L_theta / *L) - DlnL_theta*DlnL_theta;
D2lnL_cov1 = (D2L_cov1 / *L) - DlnL_cov1*DlnL_cov1;
D2lnL_cov2 = (D2L_cov2 / *L) - DlnL_cov2*DlnL_cov2;
D2lnL_cov3 = (D2L_cov3 / *L) - DlnL_cov3*DlnL_cov3;
D2lnL_s = (D2L_s / *L) - DlnL_s*DlnL_s;
D2lnL_theta_cov1 = (D2L_theta_cov1 / *L) - DlnL_theta*DlnL_cov1;
D2lnL_theta_cov2 = (D2L_theta_cov2 / *L) - DlnL_theta*DlnL_cov2;
D2lnL_theta_cov3 = (D2L_theta_cov3 / *L) - DlnL_theta*DlnL_cov3;
D2lnL_theta_s = (D2L_theta_s / *L) - DlnL_theta*DlnL_s;
D2lnL_cov1_cov2 = (D2L_cov1_cov2 / *L) - DlnL_cov1*DlnL_cov2;
D2lnL_cov1_cov3 = (D2L_cov1_cov3 / *L) - DlnL_cov1*DlnL_cov3;
D2lnL_cov1_s = (D2L_cov1_s / *L) - DlnL_cov1*DlnL_s;
D2lnL_cov2_cov3 = (D2L_cov2_cov3 / *L) - DlnL_cov2*DlnL_cov3;
D2lnL_cov2_s = (D2L_cov2_s / *L) - DlnL_cov2*DlnL_s;
D2lnL_cov3_s = (D2L_cov3_s / *L) - DlnL_cov3*DlnL_s;

D2lnL[0] = -D2lnL_theta;
D2lnL[6] = -D2lnL_cov1;
D2lnL[12] = -D2lnL_cov2;
D2lnL[18] = -D2lnL_cov3;
D2lnL[24] = -D2lnL_s;
D2lnL[1] = D2lnL[5] = -D2lnL_theta_cov1;
D2lnL[2] = D2lnL[10] = -D2lnL_theta_cov2;
D2lnL[3] = D2lnL[15] = -D2lnL_theta_cov3;
D2lnL[4] = D2lnL[20] = -D2lnL_theta_s;
D2lnL[7] = D2lnL[11] = -D2lnL_cov1_cov2;
D2lnL[8] = D2lnL[16] = -D2lnL_cov1_cov3;
D2lnL[9] = D2lnL[21] = -D2lnL_cov1_s;
D2lnL[13] = D2lnL[17] = -D2lnL_cov2_cov3;
D2lnL[14] = D2lnL[22] = -D2lnL_cov2_s;
D2lnL[19] = D2lnL[23] = -D2lnL_cov3_s;
}



void calculate_parameters(double theta,double cov1_size,double cov2_size,double cov3_size,double s,
			  double *DlnL,double *D2lnL,
			  double *theta_star,double *cov1_size_star,double *cov2_size_star,double *cov3_size_star,double *s_star)
{
double	x11,x12,x13,x14,x15,x22,x23,x24,x25,x33,x34,x35,x44,x45,x55;
double	z1,z2,z3,z4,z5;
double	t1,t2,t3,t4,t5;
double	denom;

x11=D2lnL[0]; x12=D2lnL[1]; x13=D2lnL[2];  x14=D2lnL[3];  x15=D2lnL[4];
	      x22=D2lnL[6]; x23=D2lnL[7];  x24=D2lnL[8];  x25=D2lnL[9];
			    x33=D2lnL[12]; x34=D2lnL[13]; x35=D2lnL[14];
				           x44=D2lnL[18]; x45=D2lnL[19];
							  x55=D2lnL[24];
z1 = DlnL[0];
z2 = DlnL[1];
z3 = DlnL[2];
z4 = DlnL[3];
z5 = DlnL[4];

denom = x11*x22*x55*x44*x33 - x22*x55*x14*x14*x33 - 2*x25*x15*x14*x24*x33 + 2*x44*x25*x15*x12*x33 + 
	2*x55*x12*x14*x24*x33 + x14*x14*x25*x25*x33 + x45*x45*x12*x12*x33 + x44*x25*x25*x13*x13 + 
	x44*x15*x15*x23*x23 + x44*x12*x12*x35*x35 + x24*x24*x33*x15*x15 + x55*x34*x34*x12*x12 + 
	x55*x24*x24*x13*x13 + x55*x14*x14*x23*x23 + x22*x45*x45*x13*x13 + x22*x14*x14*x35*x35 + 
	x22*x34*x34*x15*x15 + x11*x24*x24*x35*x35 + x11*x34*x34*x25*x25 + x11*x45*x45*x23*x23 - 
	x55*x44*x12*x12*x33 - 2*x55*x23*x12*x14*x34 - 2*x55*x12*x13*x24*x34 - 2*x55*x23*x24*x13*x14 + 
	2*x12*x13*x24*x35*x45 - x11*x55*x24*x24*x33 + 2*x55*x44*x23*x12*x13 + 2*x23*x12*x14*x35*x45 + 
	2*x23*x12*x45*x15*x34 - 2*x45*x45*x23*x12*x13 - 2*x34*x12*x12*x35*x45 + 2*x12*x13*x25*x45*x34 - 
	2*x34*x34*x25*x15*x12 + 2*x23*x25*x45*x13*x14 + 2*x23*x25*x15*x14*x34 - 2*x34*x25*x25*x13*x14 - 
	2*x44*x12*x35*x25*x13 + 2*x23*x24*x35*x15*x14 + 2*x25*x15*x13*x24*x34 - 2*x12*x45*x15*x24*x33 - 
	2*x23*x15*x15*x24*x34 - 2*x14*x14*x23*x25*x35 - 2*x12*x14*x24*x35*x35 - 2*x45*x15*x14*x23*x23 - 
	2*x24*x24*x35*x15*x13 - 2*x25*x45*x24*x13*x13 - 2*x12*x14*x25*x45*x33 + 2*x25*x35*x24*x13*x14 + 
	2*x12*x35*x15*x24*x34 + 2*x23*x24*x13*x45*x15 + 2*x25*x35*x12*x14*x34 - 2*x44*x25*x15*x13*x23 - 
	2*x44*x12*x35*x15*x23 - x22*x44*x15*x15*x33 - x22*x55*x44*x13*x13 + 2*x11*x55*x23*x24*x34 - 
	x11*x44*x25*x25*x33 - x11*x55*x44*x23*x23 - x11*x22*x55*x34*x34 - x11*x22*x45*x45*x33 + 
	2*x22*x55*x34*x13*x14 + 2*x22*x44*x35*x15*x13 - 2*x22*x13*x14*x35*x45 - 2*x22*x13*x45*x15*x34 + 
	2*x22*x45*x15*x14*x33 - 2*x22*x35*x15*x14*x34 - x11*x22*x44*x35*x35 + 2*x11*x44*x23*x25*x35 - 
	2*x11*x23*x24*x35*x45 - 2*x11*x25*x35*x24*x34 + 2*x11*x25*x45*x24*x33 - 2*x11*x23*x25*x45*x34 + 
	2*x11*x22*x34*x35*x45;

if (denom != 0)  {
	t1 = (x25*x25*x13*z3*x44 - x25*x12*z5*x34*x34 + x35*x23*x24*x14*z5 - x12*x35*x35*x24*z4 - 
	      x35*x23*x12*z5*x44 + x45*x22*x14*z5*x33 + x22*x13*x45*x45*z3 - x22*x45*x45*z1*x33 - 
	      x45*x22*x34*x13*z5 - 2*z5*x23*x15*x24*x34 - z5*x22*x44*x15*x33 - x12*x55*x23*x34*z4 - 
	      x12*x55*z2*x44*x33 + x13*x55*z3*x24*x24 + x14*x55*z4*x23*x23 - x12*x55*x24*z3*x34 + 
	      x13*x55*x23*z2*x44 + x45*x34*x23*x15*z2 - x45*x24*z2*x33*x15 - x45*x22*x34*z3*x15 + 
	      x45*x22*z4*x33*x15 - x13*x22*x55*z3*x44 + x13*x22*x55*x34*z4 - x13*x55*x23*x24*z4 - 
	      x13*x55*x34*x24*z2 + x12*x55*x24*z4*x33 + x12*x55*x23*z3*x44 + x35*x23*x15*x24*z4 + 
	      2*x35*x22*x34*x45*z1 + x22*x35*x35*x14*z4 - x35*x13*z5*x24*x24 - x35*x22*x34*x14*z5 - 
	      x35*x22*x13*x45*z4 - x22*x35*x35*z1*x44 - x35*x22*z3*x45*x14 - x45*x14*z5*x23*x23 - 
	      x45*x24*x12*z5*x33 - x13*x45*x45*x23*z2 + x12*x45*x45*z2*x33 - x23*x12*x45*x45*z3 + 
	      x45*x34*x23*x12*z5 + x45*x23*x24*x13*z5 + x12*x55*z2*x34*x34 - x35*x22*x34*z4*x15 + 
	      x35*x22*z3*x15*x44 + x25*x23*x15*x34*z4 - x25*x24*x15*z4*x33 + x25*x24*x15*z3*x34 - 
	      x35*x23*x15*z2*x44 + x35*x34*x24*z2*x15 - x14*x55*x34*x23*z2 + x14*x55*x24*z2*x33 - 
	      x14*x55*x23*x24*z3 - x14*x22*x55*z4*x33 + x14*x22*x55*z3*x34 + z1*x22*x55*x44*x33 - 
	      z1*x55*x24*x24*x33 + 2*z1*x55*x23*x24*x34 - z1*x55*x44*x23*x23 - z1*x22*x55*x34*x34 + 
	      x45*x23*x15*x24*z3 + x25*z2*x44*x15*x33 - x25*x23*x15*z3*x44 - x25*x25*x13*x34*z4 - 
	      2*x25*x24*x34*x35*z1 + x25*x24*x34*x13*z5 + x25*x25*x14*z4*x33 - x25*x25*x14*z3*x34 + 
	      x25*x12*x35*x34*z4 - x25*x25*z1*x44*x33 - x25*x24*x14*z5*x33 - 2*x25*x24*x13*x45*z3 + 
	      2*x25*x24*x45*z1*x33 - x25*x12*x35*z3*x44 + x12*x35*x35*z2*x44 + x35*x13*x45*x24*z2 + 
	      x35*x23*x12*x45*z4 + x35*x23*z2*x45*x14 - 2*x35*x23*x24*x45*z1 - x35*x35*x14*x24*z2 + 
	      x35*z3*x12*x45*x24 + x35*x34*x24*x12*z5 - 2*x35*x34*x12*x45*z2 + x35*x22*x13*z5*x44 + 
	      x25*x24*z4*x35*x13 - x25*z2*x45*x14*x33 + x25*z2*x35*x14*x34 + x25*x12*z5*x44*x33 - 
	      x25*x23*x13*z5*x44 - 2*x25*x23*x34*x45*z1 - 2*x25*x23*x35*x14*z4 + x25*x23*x34*x14*z5 + 
	      x25*x23*x13*x45*z4 + 2*x25*x23*x35*z1*x44 - x25*x12*x45*z4*x33 + x25*x12*x45*z3*x34 - 
	      x25*z2*x44*x35*x13 + x25*z2*x13*x45*x34 + x25*x24*x35*x14*z3 + x25*x23*z3*x45*x14 + 
	      z5*x44*x15*x23*x23 + z5*x24*x24*x33*x15 + z5*x22*x34*x34*x15 - x25*z2*x34*x34*x15 - 
	      x35*z3*x15*x24*x24 - x45*z4*x23*x23*x15 + x25*x25*z1*x34*x34 + x35*x35*z1*x24*x24 + 
	      x45*x45*z1*x23*x23);

	t2 = -(-z2*x34*x34*x15*x15 - z2*x14*x14*x35*x35 - z2*x45*x45*x13*x13 - x11*x55*x23*x34*z4 - 
	       x11*x55*z2*x44*x33 - x55*x23*x13*z1*x44 + x55*x24*x13*x14*z3 - x55*x24*x14*z1*x33 - 
	       x55*x12*x13*z3*x44 + x55*x12*x14*z3*x34 + x55*x23*x34*x14*z1 + x55*x12*z1*x44*x33 + 
	       x55*x12*x13*x34*z4 - 2*x55*z2*x34*x13*x14 - x11*x55*x24*z3*x34 - x11*x23*x35*z5*x44 + 
	       x11*x25*z5*x44*x33 - x11*x25*x45*z4*x33 + x11*x23*x35*x45*z4 + x11*x25*x35*x34*z4 + 
	       x11*x25*x45*z3*x34 - 2*x11*z2*x34*x35*x45 + x11*x55*x24*z4*x33 + x11*x55*x23*z3*x44 + 
	       x11*x24*x35*x45*z3 - x11*x25*x35*z3*x44 - x11*x24*x45*z5*x33 + x11*x24*x34*x35*z5 + 
	       x11*x23*x34*x45*z5 - x24*x34*x35*x15*z1 - x24*x34*x13*z5*x15 - x24*x35*x45*x13*z1 + 
	       x25*x15*x14*z4*x33 - x25*x15*x14*z3*x34 + x24*x14*z1*x35*x35  - x12*x35*x15*x34*z4 + 
	       2*x12*z1*x34*x35*x45 - x25*x35*x34*x14*z1 - x25*x35*x13*x14*z4 - x25*x15*z1*x44*x33 + 
	       x24*x14*z5*x15*x33 - x24*x13*x45*x15*z3 + x24*x45*x15*z1*x33 + x12*x35*x15*z3*x44 + 
	       2*x25*z5*x34*x13*x14 - x12*x13*x35*x45*z4 - x12*x13*x34*x45*z5 + x12*x14*x45*z5*x33 - 
	       x12*x14*x35*x45*z3 - x24*x13*x14*x35*z5 + 2*x24*z4*x35*x15*x13 - x25*x45*x34*x13*z1 - 
	       2*z2*x45*x15*x14*x33 + 2*z2*x35*x15*x14*x34 - x12*z5*x15*x44*x33 + x24*x45*z5*x13*x13 + 
	       x25*x45*x14*z1*x33 + x23*x13*z5*x15*x44 - x23*x13*x14*x45*z5 - x23*x34*x45*x15*z1 - 
	       x23*x35*x15*x14*z4 - x23*x35*x45*x14*z1 - x23*x34*x14*z5*x15 - x23*x13*x45*x15*z4 + 
	       x23*x35*x15*z1*x44 - x12*x14*x34*x35*z5 + x12*x45*x15*z4*x33 - x12*x45*x15*z3*x34 + 
	       x12*x13*x35*z5*x44 - 2*z2*x44*x35*x15*x13 + 2*z2*x13*x14*x35*x45 + 2*z2*x13*x45*x15*x34 - 
	       x25*x45*x13*x14*z3 - x24*x35*x15*x14*z3 + 2*x23*z3*x45*x15*x14 + x25*x15*x13*z3*x44 - 
	       x25*x15*x13*x34*z4 + x55*x24*x34*x13*z1 + x55*x23*x13*x14*z4 - x55*x12*x14*z4*x33 + 
	       x25*x35*x13*z1*x44 + x25*x35*z3*x14*x14 - x25*z5*x44*x13*x13 + x12*z5*x15*x34*x34 + 
	       x25*x45*z4*x13*x13 + x23*x13*z1*x45*x45 + x23*x35*z5*x14*x14 + x12*x14*z4*x35*x35 + 
	       z2*x44*x15*x15*x33 - x12*z1*x45*x45*x33 + x25*x15*z1*x34*x34 - x12*z1*x44*x35*x35 - 
	       x55*x12*z1*x34*x34 - x55*x23*z3*x14*x14 - x55*x24*z4*x13*x13 + x55*z2*x14*x14*x33 + 
	       x55*z2*x44*x13*x13 + x11*x55*z2*x34*x34 - x11*x25*z5*x34*x34 - x11*x24*z4*x35*x35 + 
	       x11*z2*x44*x35*x35 + x11*z2*x45*x45*x33 - x11*x23*z3*x45*x45 + x12*x13*z3*x45*x45 - 
	       x25*z5*x14*x14*x33 - x23*x15*x15*z3*x44 + x23*x15*x15*x34*z4 - x24*x15*x15*z4*x33 + 
	       x24*x15*x15*z3*x34);

	t3 = (x23*x24*x14*z5*x15 - x55*x34*x12*x14*z2 + x55*x12*x13*z2*x44 + 2*x55*z3*x12*x14*x24 - 
	      x55*x23*x12*x14*z4 + z3*x15*x15*x24*x24 - x23*x25*z5*x14*x14 - x35*x45*x12*x12*z4 + 
	      x12*x35*x15*x24*z4 - x23*x12*z5*x15*x44 + x12*x13*x24*x45*z5 - x23*x15*x15*x24*z4 - 
	      x13*x14*x25*x25*z4 - x25*x35*z2*x14*x14 + x55*x23*x12*z1*x44 + x55*x23*z2*x14*x14 - 
	      x35*x15*z1*x24*x24 + x25*x25*x13*z1*x44 - x11*x22*x35*z5*x44 + x11*x22*x55*z3*x44 - 
	      x11*x22*x55*x34*z4 + x11*x22*x35*x45*z4 + x11*x22*x34*x45*z5 + x11*x55*x23*x24*z4 + 
	      x11*x55*x34*x24*z2 + x13*x14*x24*x25*z5 + x25*x35*x12*x14*z4 - x12*x35*x15*z2*x44 + 
	      x13*x45*x15*x24*z2 - x25*x13*x12*z5*x44 + x13*x14*x25*x45*z2 + x25*x15*x13*x24*z4 - 
	      x23*x25*x15*z1*x44 + x23*x12*x45*x15*z4 - 2*x23*z2*x45*x15*x14 + x12*x13*x25*x45*z4 + 
	      x34*x25*x45*x12*z1 + x34*x12*x14*x25*z5 + x11*x25*x35*z2*x44 + x11*x23*x25*z5*x44 - 
	      x11*x25*x35*x24*z4 + 2*x11*z3*x25*x45*x24 - x11*x35*x45*x24*z2 - x11*x23*x25*x45*z4 - 
	      x11*x23*x24*x45*z5 - x11*x34*x25*x45*z2 - x11*x34*x24*x25*z5 - x12*x13*z2*x45*x45 - 
	      x23*x12*z1*x45*x45 + z3*x12*x12*x45*x45 + x23*x25*x15*x14*z4 + x55*x13*z1*x24*x24 + 
	      z3*x25*x25*x14*x14 - 2*z3*x25*x15*x14*x24 + x23*x12*x14*x45*z5 + x23*x24*x45*x15*z1 - 
	      2*x35*z5*x12*x14*x24 + x35*x45*x12*x14*z2 - x12*x35*x25*z1*x44 + x35*x15*x14*x24*z2 - 
	      2*x13*z1*x25*x45*x24 - 2*z3*x12*x45*x15*x24 - x25*x15*x13*z2*x44 - 2*z3*x12*x14*x25*x45 + 
	      x34*x24*x25*x15*z1 + x34*x24*x12*z5*x15 + x34*x25*x15*x14*z2 + x23*x25*x45*x14*z1 + 
	      x55*x34*z4*x12*x12  + 2*z3*x25*x15*x12*x44 - 2*x34*z4*x25*x15*x12 + x34*x12*x45*x15*z2 + 
	      x25*x35*x24*x14*z1 + x35*x45*x24*x12*z1 + x22*x55*x34*x14*z1 + x22*x55*x13*x14*z4 - 
	      x22*x55*x13*z1*x44 + x22*x13*z5*x15*x44 - x22*x13*x14*x45*z5 - x22*x34*x45*x15*z1 - 
	      x22*x35*x15*x14*z4 - x11*x55*x23*z2*x44 + x23*x15*x15*z2*x44 - x34*x24*z2*x15*x15 + 
	      x12*x12*x35*z5*x44 + x11*x35*z5*x24*x24 + x11*x34*z4*x25*x25 + x11*x23*z2*x45*x45 - 
	      x11*z3*x25*x25*x44 - x11*x55*z3*x24*x24 - x11*x22*z3*x45*x45 + x22*x13*z1*x45*x45 + 
	      x22*x34*z4*x15*x15 + x22*x35*z5*x14*x14 - x22*z3*x15*x15*x44 - x22*x55*z3*x14*x14 - 
	      x13*z5*x15*x24*x24 - x34*x45*z5*x12*x12 - x34*x14*z1*x25*x25 - x55*x12*x13*x24*z4 - 
	      x55*x23*x24*x14*z1 - x55*x13*x14*x24*z2 - x55*x34*x24*x12*z1 - x22*x35*x45*x14*z1 - 
	      x22*x34*x14*z5*x15 - x22*x13*x45*x15*z4 + x22*x35*x15*z1*x44 + 2*x22*z3*x45*x15*x14 - 
	      x55*z3*x12*x12*x44);

	t4 = -(x22*x35*x15*x14*z3 + x55*x12*x13*x24*z3 + x55*x23*x12*x14*z3 + x55*x23*x24*x13*z1 - 
	       2*x55*z4*x23*x12*x13 + x55*x13*x14*x23*z2 + x55*x34*x23*x12*z1 + x55*x34*x12*x13*z2 + 
	       x25*x45*z2*x13*x13 + x24*x12*z1*x35*x35 + x24*x25*z5*x13*x13 - x14*z1*x25*x25*x33 - 
	       x45*z5*x12*x12*x33 + x23*x15*x15*x24*z3 + x34*x12*x12*x35*z5 + x34*x25*x25*x13*z1 + 
	       x34*x23*x15*x15*z2 + x14*z5*x15*x23*x23 + x45*x15*z1*x23*x23 + x12*x14*z2*x35*x35 + 
	       x13*x14*x25*x25*z3 + x35*x45*x12*x12*z3 + x24*x25*x15*z1*x33 + x24*x12*z5*x15*x33 - 
	       x23*x12*x14*x35*z5 + 2*x14*z1*x23*x25*x35 - x35*x15*x14*x23*z2 - x12*x35*x15*x24*z3 - 
	       x13*x45*x15*x23*z2 - x23*x25*x45*x13*z1 - z4*x12*x12*x35*x35 - z4*x25*x25*x13*x13 - 
	       z4*x23*x23*x15*x15 - x34*x25*x13*x12*z5 - x34*x12*x35*x25*z1 + x25*x15*x14*z2*x33 - 
	       x25*x35*x12*x14*z3 + x12*x45*x15*z2*x33 + x25*x45*x12*z1*x33 - x23*x12*x45*x15*z3 + 
	       2*x45*z5*x23*x12*x13 + 2*x34*z3*x25*x15*x12 - x34*x23*x12*z5*x15 - x34*x12*x35*x15*z2 - 
	       x34*x25*x15*x13*z2 - x25*x15*x13*x24*z3 - x35*x45*x23*x12*z1 - x35*x45*x12*x13*z2 - 
	       x23*x25*x15*x14*z3 - x34*x23*x25*x15*z1 + x12*x14*x25*z5*x33 - x12*x13*x25*x45*z3 - 
	       x23*x24*x35*x15*z1 - x23*x24*x13*z5*x15 + 2*x24*z2*x35*x15*x13 - x24*z2*x33*x15*x15 - 
	       x55*x14*z1*x23*x23 - x55*x34*z3*x12*x12 - x55*x24*z2*x13*x13 + x55*z4*x33*x12*x12 + 
	       x22*x55*z4*x13*x13 - x22*x34*z3*x15*x15 - x22*x14*z1*x35*x35 - x22*x45*z5*x13*x13 + 
	       x22*z4*x33*x15*x15 - x11*x34*z3*x25*x25 + x11*z4*x33*x25*x25 - x11*x24*z2*x35*x35 - 
	       x11*x45*z5*x23*x23 + x11*x55*z4*x23*x23 + x11*x22*z4*x35*x35 - x55*x12*x14*z2*x33 - 
	       x13*x14*x23*x25*z5 + 2*z4*x12*x35*x25*x13 + 2*z4*x25*x15*x13*x23 - x13*x14*x25*x35*z2 + 
	       2*z4*x12*x35*x15*x23 - 2*z4*x33*x25*x15*x12 - x12*x13*x24*x35*z5 - x25*x35*x24*x13*z1 - 
	       x55*x24*x12*z1*x33 - x22*x14*z5*x15*x33 + x22*x13*x45*x15*z3 - x22*x45*x15*z1*x33 + 
	       x22*x34*x35*x15*z1 + x22*x34*x13*z5*x15 + x22*x35*x45*x13*z1 + x22*x13*x14*x35*z5 - 
	       2*x22*z4*x35*x15*x13 + x22*x55*x14*z1*x33 - x22*x55*x13*x14*z3 - x22*x55*x34*x13*z1 - 
	       2*x11*z4*x23*x25*x35 - x11*x25*x45*z2*x33 + x11*x34*x25*x35*z2 + x11*x34*x23*x25*z5 + 
	       x11*x35*x45*x23*z2 + x11*x23*x25*x45*z3 + x11*x25*x35*x24*z3 + x11*x23*x24*x35*z5 - 
	       x11*x24*x25*z5*x33 - x11*x55*x34*x23*z2 + x11*x55*x24*z2*x33 - x11*x55*x23*x24*z3 - 
	       x11*x22*x55*z4*x33 + x11*x22*x55*z3*x34 + x11*x22*x45*z5*x33 - x11*x22*x35*x45*z3 - 
	       x11*x22*x34*x35*z5);

	t5 = (z5*x24*x24*x13*x13 + x11*x35*x23*z2*x44 + z5*x34*x34*x12*x12 - z5*x22*x14*x14*x33 - 
	      z5*x44*x12*x12*x33 - z5*x22*x44*x13*x13 - x45*x24*z2*x13*x13 - x13*x15*z3*x24*x24 - 
	      x14*x15*z4*x23*x23 - x35*x23*z2*x14*x14 - x45*x14*z1*x23*x23 - x45*x34*z3*x12*x12 + 
	      x45*z4*x33*x12*x12 + x45*x22*z4*x13*x13 - x12*x15*z2*x34*x34 + x35*x22*z3*x14*x14 + 
	      x35*z3*x12*x12*x44 - x35*x13*z1*x24*x24 - x35*x34*z4*x12*x12 + z1*x15*x24*x24*x33 + 
	      z1*x15*x44*x23*x23 + z1*x15*x22*x34*x34 - x25*x12*z1*x34*x34 - x25*x23*z3*x14*x14 - 
	      x25*x24*z4*x13*x13 + x25*z2*x14*x14*x33 + x25*z2*x44*x13*x13 + x11*x25*z2*x34*x34 + 
	      x11*x35*z3*x24*x24 - x11*z5*x44*x23*x23 - x11*z5*x22*x34*x34 + x11*x45*z4*x23*x23 - 
	      x11*z5*x24*x24*x33 + 2*z5*x12*x14*x24*x33 - 2*z5*x23*x12*x14*x34 - 2*z5*x23*x24*x13*x14 + 
	      2*z5*x44*x23*x12*x13 - 2*z5*x12*x13*x24*x34 + x12*x15*z2*x44*x33 + 2*z5*x22*x34*x13*x14 + 
	      x12*x15*x23*x34*z4 + x25*x24*x13*x14*z3 - x25*x24*x14*z1*x33 - x25*x23*x13*z1*x44 - 
	      x35*x23*x12*z1*x44 + x25*x12*x14*z3*x34 + x25*x23*x34*x14*z1 + x25*x12*z1*x44*x33 - 
	      x25*x12*x13*z3*x44 + x12*x15*x24*z3*x34 - x13*x15*x23*z2*x44 + x35*x23*x12*x14*z4 - 
	      x45*x12*x14*z2*x33 + x13*x15*x22*z3*x44 - x13*x15*x22*x34*z4 + x13*x15*x23*x24*z4 + 
	      x13*x15*x34*x24*z2 + x25*x12*x13*x34*z4 - 2*x25*z2*x34*x13*x14 - x35*x22*x13*x14*z4 + 
	      x35*x22*x13*z1*x44 + x14*x15*x34*x23*z2 - x14*x15*x24*z2*x33 + x14*x15*x23*x24*z3 + 
	      x14*x15*x22*z4*x33 - x14*x15*x22*z3*x34 - z1*x15*x22*x44*x33 - x12*x15*x24*z4*x33 - 
	      x12*x15*x23*z3*x44 - x35*x12*x13*z2*x44 - 2*x35*z3*x12*x14*x24 - x45*x24*x12*z1*x33 + 
	      x45*x22*x14*z1*x33 - x45*x22*x13*x14*z3 - x45*x22*x34*x13*z1 - 2*z1*x15*x23*x24*x34 + 
	      x45*x23*x12*x14*z3 + x45*x23*x24*x13*z1 - 2*x45*z4*x23*x12*x13 + x45*x13*x14*x23*z2 + 
	      x45*x34*x23*x12*z1 + x45*x34*x12*x13*z2 + x25*x24*x34*x13*z1 + x25*x23*x13*x14*z4 - 
	      x25*x12*x14*z4*x33 + x35*x12*x13*x24*z4 + x35*x23*x24*x14*z1 + x35*x13*x14*x24*z2 + 
	      x35*x34*x24*x12*z1 + x45*x12*x13*x24*z3 + x35*x34*x12*x14*z2 - x35*x22*x34*x14*z1 + 
	      z5*x14*x14*x23*x23 + 2*x11*z5*x23*x24*x34 - x11*x25*z2*x44*x33 + x11*x45*x22*z3*x34 - 
	      x11*x45*x23*x24*z3 + x11*x45*x24*z2*x33 + x11*x35*x22*x34*z4 - x11*x25*x24*z3*x34 - 
	      x11*x45*x22*z4*x33 + x11*x25*x23*z3*x44 - x11*x45*x34*x23*z2 + x11*z5*x22*x44*x33 - 
	      x11*x35*x22*z3*x44 - x11*x35*x23*x24*z4 - x11*x35*x34*x24*z2 + x11*x25*x24*z4*x33 - 
	      x11*x25*x23*x34*z4);

	*theta_star = theta + (t1/denom);
	*cov1_size_star = cov1_size + (t2/denom);
	*cov2_size_star = cov2_size + (t3/denom);
	*cov3_size_star = cov3_size + (t4/denom);
	*s_star = s + (t5/denom);
	}
else	{
	*theta_star = theta;
	*cov1_size_star = cov1_size;
	*cov2_size_star = cov2_size;
	*cov3_size_star = cov3_size;
	*s_star = s;
	}
}



double update_pu(double theta,double cov1_size,double cov2_size,double cov3_size,double s,
                 int nobs,double *Y,double *cov1,double *cov2,double *cov3,
                 int ncube,double *u_vec,double *pu_vec,int *u_index_vec,
                 double L,
		 int node,int totnodes,double thresh)  
{
double          u,pu;
int		u_index;
double          z,p;
double          L_u,L_prod,pu_0;
int             nonzero_cube;
double          pu_acc;
int             i,c,r,inttool;
double		dtool;
int		zero_index,nonzero_index;
MPI_Status	stat;


nonzero_cube = 0;
for (c = 0; c < ncube; c++)  {
        pu = pu_vec[c];

	u_index = u_index_vec[c];

        L_prod = 1;

        for (i = 0; i < nobs; i++)  {
                u = u_vec[(u_index*nobs)+i];

                z = theta + cov1_size*cov1[i] + cov2_size*cov2[i] + cov3_size*cov3[i] + s*u;
                p = exp(z) / (1 + exp(z));

                L_u = pow(p,Y[i]) * pow(1-p,1-Y[i]);

                L_prod = L_prod * L_u;
                }

        pu_0 = (L_prod*pu) / L;                         

	if ((pu_0 < 0) || (pu_0 > 1))  {
		printf("Warning: pu_0= %le\n",pu_0);
		printf("Diagnostic: L_prod= %le pu= %le L_prod*pu= %le L= %le\n",L_prod,pu,L_prod*pu,L);
		}

	pu_vec[c] = pu_0;
        if (pu_0 > 0)  {
		nonzero_cube++;
                }
        }

if (node == 0)  {
        for (r = 1; r < totnodes; r++)  {
                MPI_Recv(&inttool,1,MPI_INT,r,r,MPI_COMM_WORLD,&stat);
                nonzero_cube = nonzero_cube + inttool;
                }
        thresh = thresh / (double)(nonzero_cube);
        for (r = 1; r < totnodes; r++)  {
                MPI_Send(&thresh,1,MPI_DOUBLE,r,0,MPI_COMM_WORLD);
                }
        }
else    {
        MPI_Send(&nonzero_cube,1,MPI_INT,0,node,MPI_COMM_WORLD);
        MPI_Recv(&thresh,1,MPI_DOUBLE,0,0,MPI_COMM_WORLD,&stat);
        }

pu_acc = 0;
nonzero_cube = 0;
for (c = 0; c < ncube; c++)  {
        if (pu_vec[c] < thresh)  {
                pu_vec[c] = 0;
                }
        else    {
                pu_acc = pu_acc + pu_vec[c];
		nonzero_cube++;
                }
        }

zero_index = 0;
nonzero_index = 0;
do      {
        while ((zero_index < ncube) && (pu_vec[zero_index] != 0))  {
                zero_index++;
                }
        if (zero_index < ncube)  {
                if (nonzero_index < zero_index)  nonzero_index = zero_index;
                while ((nonzero_index < ncube) && (pu_vec[nonzero_index] == 0))  {
                        nonzero_index++;
                        }
                if (nonzero_index < ncube)  {
                        pu_vec[zero_index] = pu_vec[nonzero_index];
                        pu_vec[nonzero_index] = 0;

                        inttool = u_index_vec[zero_index];
                        u_index_vec[zero_index] = u_index_vec[nonzero_index];
                        u_index_vec[nonzero_index] = inttool;
                        }
                else    {
                        zero_index = nonzero_index;
                        }
                }
        } while (zero_index < ncube);   

if (node == 0)  {
        for (r = 1; r < totnodes; r++)  {
                MPI_Recv(&dtool,1,MPI_DOUBLE,r,r,MPI_COMM_WORLD,&stat);
                pu_acc = pu_acc + dtool;
                }
        for (r = 1; r < totnodes; r++)  {
                MPI_Send(&pu_acc,1,MPI_DOUBLE,r,0,MPI_COMM_WORLD);
                }
        }
else    {
        MPI_Send(&pu_acc,1,MPI_DOUBLE,0,node,MPI_COMM_WORLD);
        MPI_Recv(&pu_acc,1,MPI_DOUBLE,0,0,MPI_COMM_WORLD,&stat);
        }

for (c = 0; c < nonzero_cube; c++)  {
        pu_vec[c] = pu_vec[c] / pu_acc;
        }

return(nonzero_cube);
}



void write_pu(int ncube,int nobs,
              double *pu_vec,double *u_vec,int *u_index_vec,
              char *u_outputfile,char *pu_outputfile,char *write_append)
{
int     c,r,u_index;
FILE    *fptr_u,*fptr_pu;

fptr_u = fopen(u_outputfile,write_append);
fptr_pu = fopen(pu_outputfile,write_append);

for (c = 0; c < ncube; c++)  {
	u_index = u_index_vec[c];

        fprintf(fptr_pu,"%le\n",pu_vec[c]);

        for (r = 0; r < nobs; r++)  {
	        fprintf(fptr_u,"%le ",u_vec[(u_index*nobs)+r]);
                }
        fprintf(fptr_u,"\n");
        }

fclose(fptr_u);
fclose(fptr_pu);
}



void main(int argc,char *argv[])
{
int			node,totnodes;
int			nobs,ngene,ncube_node_base;
double			*phenotypes,*cov1,*cov2,*cov3;
double			*u,pu_base,*pu;
int			*u_index_vec;
double			theta_base,cov1_size_base,cov2_size_base,cov3_size_base,s_lo,s_hi,s_step,s_curr;
double			cull_thresh;
double			difference_limit;
int			*id,*u_id,haltcrit;
int			ncube_node;
double			theta,cov1_size,cov2_size,cov3_size,s;
derivative_return	d_ret;
double			L,DlnL_distance,DlnL[5],D2lnL[25];
double			theta_0,cov1_size_0,cov2_size_0,cov3_size_0,s_0;
derivative_return	d_ret_0;
double			L_0,DlnL_distance_0,DlnL_0[5],D2lnL_0[25];
double			difference;
double			theta_store,cov1_size_store,cov2_size_store,cov3_size_store,s_store;
double			L_store,DlnL_store[5],D2lnL_store[25];
int			ncube_node_store;
double			*pu_store;
int			*u_index_vec_store;
double			s_eval_code,stop_code,update_pu_code,pu_store_code,pu_write_code;
int			retcode;
double			D2lnLinv[25];
int			i,j,r;
char			c,fname[256],fname2[256];
FILE			*fptr;
double			dtool;
MPI_Status		stat;



MPI_Init(&argc,&argv);
MPI_Comm_size(MPI_COMM_WORLD,&totnodes);
MPI_Comm_rank(MPI_COMM_WORLD,&node);

if (argc != 13)  {
        if (node == 0)  {
                printf("Required arguments: <pheno/cov file> <nobs> <ncube_node> <theta effect> <cov1 effect> <cov2 effect> <cov3 effect> <s effect lo> <s effect hi> <s effect step> <stopping crit> <point culling threshhold>\n");
                }
        MPI_Finalize();
        exit(0);
        }

sscanf(argv[2],"%i",&nobs);
id = (int *)malloc(nobs*sizeof(int));
phenotypes = (double *)malloc(nobs*sizeof(double));
cov1 = (double *)malloc(nobs*sizeof(double));
cov2 = (double *)malloc(nobs*sizeof(double));
cov3 = (double *)malloc(nobs*sizeof(double));
fptr = fopen(argv[1],"r");
for (i = 0; i < nobs; i++)  {
        fscanf(fptr,"%i %lf %lf %lf %lf",&(id[i]),&(phenotypes[i]),&(cov1[i]),&(cov2[i]),&(cov3[i]));
        }
fclose(fptr);

sscanf(argv[3],"%i",&ncube_node_base);
u_id = (int *)malloc(nobs*sizeof(double));
u = (double *)malloc(ncube_node_base*nobs*sizeof(double));
sprintf(fname,"u_matrix_%i.dat",node);
fptr = fopen(fname,"r");
for (i = 0; i < nobs; i++)  {
        if (fscanf(fptr,"%i",&(u_id[i])) == EOF)  {
                if (node == 0)  {
                        printf("Too small cubature file. Quitting.\n");
                        }
                MPI_Finalize();
                exit(0);
                }
        }
for (i = 0; i < ncube_node_base*nobs; i++)  {
        if (fscanf(fptr,"%lf",&(u[i])) == EOF)  {
                if (node == 0)  {
                        printf("Too small cubature file. Quitting.\n");
                        }
                MPI_Finalize();
                exit(0);
                }
        }
fclose(fptr);

u_index_vec = (int *)malloc(ncube_node_base*sizeof(int));
for (i = 0; i < ncube_node_base; i++)  {
        u_index_vec[i] = i;
        }
u_index_vec_store = (int *)malloc(ncube_node_base*sizeof(int));
pu = (double *)malloc(ncube_node_base*sizeof(double));
pu_store = (double *)malloc(ncube_node_base*sizeof(double));
pu_base = 1.0 / (double)(ncube_node_base*totnodes);

haltcrit = 0;
for (i = 0; i < nobs; i++)  {
        if (id[i] != u_id[i])  haltcrit = 1;
        }
if (haltcrit == 1)  {
        if (node == 0)  {
                printf("Nonmatching phenotype/covariate and cubature person IDs. Quitting.\n");
                }
        MPI_Finalize();
        exit(0);
        }

sscanf(argv[4],"%le",&theta_base);
sscanf(argv[5],"%le",&cov1_size_base);
sscanf(argv[6],"%le",&cov2_size_base);
sscanf(argv[7],"%le",&cov3_size_base);

sscanf(argv[8],"%le",&s_lo);
sscanf(argv[9],"%le",&s_hi);
sscanf(argv[10],"%le",&s_step);

sscanf(argv[11],"%le",&difference_limit);

sscanf(argv[12],"%le",&cull_thresh);

if (node == 0)  {
        s_eval_code = 1;
        s_curr = s_lo;
        while (s_eval_code == 1)  {
                for (r = 1; r < totnodes; r++)  {
                        MPI_Send(&s_eval_code,1,MPI_DOUBLE,r,0,MPI_COMM_WORLD);
                        }

                printf("s= %le evaluation.\n",s_curr);

		theta = theta_base;
		cov1_size = cov1_size_base;
		cov2_size = cov2_size_base;
		cov3_size = cov3_size_base;
		s = s_curr;
                for (i = 0; i < ncube_node_base; i++)  {
                        pu[i] = pu_base;
                        }
		ncube_node = ncube_node_base;

		stop_code = 0;
		do	{
			for (r = 1; r < totnodes; r++)  {
				MPI_Send(&stop_code,1,MPI_DOUBLE,r,0,MPI_COMM_WORLD);
				}

			for (r = 1; r < totnodes; r++)  {
				MPI_Send(&theta,1,MPI_DOUBLE,r,0,MPI_COMM_WORLD);
			        MPI_Send(&cov1_size,1,MPI_DOUBLE,r,0,MPI_COMM_WORLD);
			        MPI_Send(&cov2_size,1,MPI_DOUBLE,r,0,MPI_COMM_WORLD);
			        MPI_Send(&cov3_size,1,MPI_DOUBLE,r,0,MPI_COMM_WORLD);
		        MPI_Send(&s,1,MPI_DOUBLE,r,0,MPI_COMM_WORLD);
			        }
			d_ret = derivative_binomial_glmm(theta,cov1_size,cov2_size,cov3_size,s,
							 nobs,phenotypes,cov1,cov2,cov3,ncube_node,u,pu,u_index_vec);
			d_ret = gather_nodes(d_ret,totnodes);
			calculate_derivatives(d_ret,&L,DlnL,D2lnL);
			DlnL_distance = sqrt(pow(DlnL[0],2) + pow(DlnL[1],2) + pow(DlnL[2],2) + pow(DlnL[3],2) + pow(DlnL[4],2));

			printf("\t%le %le %le %le %le : %le %le\n",theta,cov1_size,cov2_size,cov3_size,s,log(L),DlnL_distance);
			/*
			printf("\tDlnL\n");
			printf("\t%le %le %le %le\n",DlnL[0],DlnL[1],DlnL[2],DlnL[3],DlnL[4]);
			printf("\tD2lnL\n");
			printf("\t%le %le %le %le %le\n",D2lnL[0],D2lnL[1],D2lnL[2],D2lnL[3],D2lnL[4]);
			printf("\t%le %le %le %le %le\n",D2lnL[5],D2lnL[6],D2lnL[7],D2lnL[8],D2lnL[9]);
			printf("\t%le %le %le %le %le\n",D2lnL[10],D2lnL[11],D2lnL[12],D2lnL[13],D2lnL[14]);
			printf("\t%le %le %le %le %le\n",D2lnL[15],D2lnL[16],D2lnL[17],D2lnL[18],D2lnL[19]);
			printf("\t%le %le %le %le %le\n",D2lnL[20],D2lnL[21],D2lnL[22],D2lnL[23],D2lnL[24]);
			*/

			calculate_parameters(theta,cov1_size,cov2_size,cov3_size,s,DlnL,D2lnL,
					     &theta_0,&cov1_size_0,&cov2_size_0,&cov3_size_0,&s_0);
			for (r = 1; r < totnodes; r++)  {
				MPI_Send(&theta_0,1,MPI_DOUBLE,r,0,MPI_COMM_WORLD);
			        MPI_Send(&cov1_size_0,1,MPI_DOUBLE,r,0,MPI_COMM_WORLD);
			        MPI_Send(&cov2_size_0,1,MPI_DOUBLE,r,0,MPI_COMM_WORLD);
			        MPI_Send(&cov3_size_0,1,MPI_DOUBLE,r,0,MPI_COMM_WORLD);
			        MPI_Send(&s_0,1,MPI_DOUBLE,r,0,MPI_COMM_WORLD);
				}
			d_ret_0 = derivative_binomial_glmm(theta_0,cov1_size_0,cov2_size_0,cov3_size_0,s_0,
							   nobs,phenotypes,cov1,cov2,cov3,ncube_node,u,pu,u_index_vec);
			d_ret_0 = gather_nodes(d_ret_0,totnodes);
			calculate_derivatives(d_ret_0,&L_0,DlnL_0,D2lnL_0);
			DlnL_distance_0 = sqrt(pow(DlnL_0[0],2) + pow(DlnL_0[1],2) + pow(DlnL_0[2],2) + pow(DlnL_0[3],2) + pow(DlnL_0[4],2));
			difference = DlnL_distance - DlnL_distance_0;
                        printf("\t%le %le %le %le %le : %le %le %le\n",theta_0,cov1_size_0,cov2_size_0,cov3_size_0,s_0,log(L_0),DlnL_distance_0,difference);

			if (difference > difference_limit)  {
				theta = theta_0;
				cov1_size = cov1_size_0;
				cov2_size = cov2_size_0;
				cov3_size = cov3_size_0;
				s = s_0;

				L = L_0;

				DlnL_distance = DlnL_distance_0;

                                DlnL[0]=DlnL_0[0]; DlnL[1]=DlnL_0[1]; DlnL[2]=DlnL_0[2]; DlnL[3]=DlnL_0[3]; DlnL[4]=DlnL_0[4];

                                D2lnL[0]=D2lnL_0[0]; D2lnL[1]=D2lnL_0[1]; D2lnL[2]=D2lnL_0[2]; D2lnL[3]=D2lnL_0[3]; D2lnL[4]=D2lnL_0[4];
                                D2lnL[5]=D2lnL_0[5]; D2lnL[6]=D2lnL_0[6]; D2lnL[7]=D2lnL_0[7]; D2lnL[8]=D2lnL_0[8]; D2lnL[9]=D2lnL_0[9];
                                D2lnL[10]=D2lnL_0[10]; D2lnL[11]=D2lnL_0[11]; D2lnL[12]=D2lnL_0[12]; D2lnL[13]=D2lnL_0[13]; D2lnL[14]=D2lnL_0[14];
                                D2lnL[15]=D2lnL_0[15]; D2lnL[16]=D2lnL_0[16]; D2lnL[17]=D2lnL_0[17]; D2lnL[18]=D2lnL_0[18]; D2lnL[19]=D2lnL_0[19];
                                D2lnL[20]=D2lnL_0[20]; D2lnL[21]=D2lnL_0[21]; D2lnL[22]=D2lnL_0[22]; D2lnL[23]=D2lnL_0[23]; D2lnL[24]=D2lnL_0[24];

				update_pu_code = 1;
				for (r = 1; r < totnodes; r++)  {
				        MPI_Send(&update_pu_code,1,MPI_DOUBLE,r,0,MPI_COMM_WORLD);
				
				        MPI_Send(&theta_0,1,MPI_DOUBLE,r,0,MPI_COMM_WORLD);
				        MPI_Send(&cov1_size_0,1,MPI_DOUBLE,r,0,MPI_COMM_WORLD);
				        MPI_Send(&cov2_size_0,1,MPI_DOUBLE,r,0,MPI_COMM_WORLD);
				        MPI_Send(&cov3_size_0,1,MPI_DOUBLE,r,0,MPI_COMM_WORLD);
				        MPI_Send(&s_0,1,MPI_DOUBLE,r,0,MPI_COMM_WORLD);
				        MPI_Send(&L_0,1,MPI_DOUBLE,r,0,MPI_COMM_WORLD);
					}
				ncube_node = update_pu(theta_0,cov1_size_0,cov2_size_0,cov3_size_0,s_0,
				          	       nobs,phenotypes,cov1,cov2,cov3,
				          	       ncube_node,u,pu,u_index_vec,L_0,
					  	       node,totnodes,cull_thresh);

				stop_code = 0;
				}
			else	{
				update_pu_code = 0;
				for (r = 1; r < totnodes; r++)  {
				        MPI_Send(&update_pu_code,1,MPI_DOUBLE,r,0,MPI_COMM_WORLD);
					}

				stop_code = 1;
				}
			} while (stop_code == 0);
		for (r = 1; r < totnodes; r++)  {
			MPI_Send(&stop_code,1,MPI_DOUBLE,r,0,MPI_COMM_WORLD);
			}

                if ((s_curr == s_lo) || (L > L_store))  {
                        pu_store_code = 1;
                        for (r = 1; r < totnodes; r++)  {
                                MPI_Send(&pu_store_code,1,MPI_DOUBLE,r,0,MPI_COMM_WORLD);
                                }

                        theta_store=theta; cov1_size_store=cov1_size; cov2_size_store=cov2_size; cov3_size_store=cov3_size; s_store=s;                  

                        L_store = L;

                        DlnL_store[0]=DlnL[0]; DlnL_store[1]=DlnL[1]; DlnL_store[2]=DlnL[2]; DlnL_store[3]=DlnL[3]; DlnL_store[4]=DlnL[4];

                        D2lnL_store[0]=D2lnL[0]; D2lnL_store[1]=D2lnL[1]; D2lnL_store[2]=D2lnL[2]; D2lnL_store[3]=D2lnL[3]; D2lnL_store[4]=D2lnL[4];
                        D2lnL_store[5]=D2lnL[5]; D2lnL_store[6]=D2lnL[6]; D2lnL_store[7]=D2lnL[7]; D2lnL_store[8]=D2lnL[8]; D2lnL_store[9]=D2lnL[9];
                        D2lnL_store[10]=D2lnL[10]; D2lnL_store[11]=D2lnL[11]; D2lnL_store[12]=D2lnL[12]; D2lnL_store[13]=D2lnL[13]; D2lnL_store[14]=D2lnL[14];
                        D2lnL_store[15]=D2lnL[15]; D2lnL_store[16]=D2lnL[16]; D2lnL_store[17]=D2lnL[17]; D2lnL_store[18]=D2lnL[18]; D2lnL_store[19]=D2lnL[19];
                        D2lnL_store[20]=D2lnL[20]; D2lnL_store[21]=D2lnL[21]; D2lnL_store[22]=D2lnL[22]; D2lnL_store[23]=D2lnL[23]; D2lnL_store[24]=D2lnL[24];

			ncube_node_store = ncube_node;
                        for (i = 0; i < ncube_node; i++)  {
                                pu_store[i] = pu[i];
				u_index_vec_store[i] = u_index_vec[i];
                                }
                        }
                else    {
                        pu_store_code = 0;
                        for (r = 1; r < totnodes; r++)  {
                                MPI_Send(&pu_store_code,1,MPI_DOUBLE,r,0,MPI_COMM_WORLD);
                                }
                        }

                printf("Curr Parameters: ");
                printf("theta= %le cov1_size= %le cov2_size= %le cov3_size= %le s= %le ",theta,cov1_size,cov2_size,cov3_size,s);
                printf("lnL= %le\n",log(L));
                printf("Best Parameters: ");
                printf("theta= %le cov1_size= %le cov2_size= %le cov3_size= %le s= %le ",theta_store,cov1_size_store,cov2_size_store,cov3_size_store,s_store);
                printf("lnL= %le\n",log(L_store));

                s_curr = s_curr + s_step;
		if (s_curr > s_hi) s_eval_code = 0;
                }
        for (r = 1; r < totnodes; r++)  {
                MPI_Send(&s_eval_code,1,MPI_DOUBLE,r,0,MPI_COMM_WORLD);
                }
		
	printf("Final Parameters: ");
	printf("theta= %le cov1_size= %le cov2_size= %le cov3_size= %le s= %le\n",theta_store,cov1_size_store,cov2_size_store,cov3_size_store,s_store);
        printf("lnL= %le\n",log(L_store));
	printf("DlnL: %le %le %le %le %le\n",DlnL_store[0],DlnL_store[1],DlnL_store[2],DlnL_store[3],DlnL_store[4]);
        printf("D2lnL=\n");     
        printf("%le %le %le %le %le\n",D2lnL_store[0],D2lnL_store[1],D2lnL_store[2],D2lnL_store[3],D2lnL_store[4]);
        printf("%le %le %le %le %le\n",D2lnL_store[5],D2lnL_store[6],D2lnL_store[7],D2lnL_store[8],D2lnL_store[9]);
        printf("%le %le %le %le %le\n",D2lnL_store[10],D2lnL_store[11],D2lnL_store[12],D2lnL_store[13],D2lnL_store[14]);
        printf("%le %le %le %le %le\n",D2lnL_store[15],D2lnL_store[16],D2lnL_store[17],D2lnL_store[18],D2lnL_store[19]);
        printf("%le %le %le %le %le\n",D2lnL_store[20],D2lnL_store[21],D2lnL_store[22],D2lnL_store[23],D2lnL_store[24]);
        retcode = invert_matrix_5x5(D2lnL_store,D2lnLinv);
        printf("D2lnLinv=\n");     
        printf("%le %le %le %le %le\n",D2lnLinv[0],D2lnLinv[1],D2lnLinv[2],D2lnLinv[3],D2lnLinv[4]);
        printf("%le %le %le %le %le\n",D2lnLinv[5],D2lnLinv[6],D2lnLinv[7],D2lnLinv[8],D2lnLinv[9]);
        printf("%le %le %le %le %le\n",D2lnLinv[10],D2lnLinv[11],D2lnLinv[12],D2lnLinv[13],D2lnLinv[14]);
        printf("%le %le %le %le %le\n",D2lnLinv[15],D2lnLinv[16],D2lnLinv[17],D2lnLinv[18],D2lnLinv[19]);
        printf("%le %le %le %le %le\n",D2lnLinv[20],D2lnLinv[21],D2lnLinv[22],D2lnLinv[23],D2lnLinv[24]);

        write_pu(ncube_node_store,nobs,pu_store,u,u_index_vec_store,"u_matrix_star.dat","pu_matrix_star.dat","w");
        for (r = 1; r < totnodes; r++)  {
                MPI_Send(&pu_write_code,1,MPI_DOUBLE,r,0,MPI_COMM_WORLD);
                MPI_Recv(&pu_write_code,1,MPI_DOUBLE,r,r,MPI_COMM_WORLD,&stat);
                }
	}
else	{
        MPI_Recv(&s_eval_code,1,MPI_DOUBLE,0,0,MPI_COMM_WORLD,&stat);

        while (s_eval_code == 1)  {
                for (i = 0; i < ncube_node_base; i++)  {
                        pu[i] = pu_base;
                        }
		ncube_node = ncube_node_base;

	        MPI_Recv(&stop_code,1,MPI_DOUBLE,0,0,MPI_COMM_WORLD,&stat);
		while (stop_code == 0)  {
		        MPI_Recv(&theta,1,MPI_DOUBLE,0,0,MPI_COMM_WORLD,&stat);
		        MPI_Recv(&cov1_size,1,MPI_DOUBLE,0,0,MPI_COMM_WORLD,&stat);
		        MPI_Recv(&cov2_size,1,MPI_DOUBLE,0,0,MPI_COMM_WORLD,&stat);
		        MPI_Recv(&cov3_size,1,MPI_DOUBLE,0,0,MPI_COMM_WORLD,&stat);
		        MPI_Recv(&s,1,MPI_DOUBLE,0,0,MPI_COMM_WORLD,&stat);
			d_ret = derivative_binomial_glmm(theta,cov1_size,cov2_size,cov3_size,s,
			 			         nobs,phenotypes,cov1,cov2,cov3,ncube_node,u,pu,u_index_vec);
			MPI_Send(&(d_ret.L),1,MPI_DOUBLE,0,node,MPI_COMM_WORLD);
		        MPI_Send(&(d_ret.DL_theta),1,MPI_DOUBLE,0,node,MPI_COMM_WORLD);
		        MPI_Send(&(d_ret.DL_cov1),1,MPI_DOUBLE,0,node,MPI_COMM_WORLD);
		        MPI_Send(&(d_ret.DL_cov2),1,MPI_DOUBLE,0,node,MPI_COMM_WORLD);
		        MPI_Send(&(d_ret.DL_cov3),1,MPI_DOUBLE,0,node,MPI_COMM_WORLD);
		        MPI_Send(&(d_ret.DL_s),1,MPI_DOUBLE,0,node,MPI_COMM_WORLD);
		        MPI_Send(&(d_ret.D2L_theta),1,MPI_DOUBLE,0,node,MPI_COMM_WORLD);
		        MPI_Send(&(d_ret.D2L_cov1),1,MPI_DOUBLE,0,node,MPI_COMM_WORLD);
		        MPI_Send(&(d_ret.D2L_cov2),1,MPI_DOUBLE,0,node,MPI_COMM_WORLD);
		        MPI_Send(&(d_ret.D2L_cov3),1,MPI_DOUBLE,0,node,MPI_COMM_WORLD);
		        MPI_Send(&(d_ret.D2L_s),1,MPI_DOUBLE,0,node,MPI_COMM_WORLD);
		        MPI_Send(&(d_ret.D2L_theta_cov1),1,MPI_DOUBLE,0,node,MPI_COMM_WORLD);
		        MPI_Send(&(d_ret.D2L_theta_cov2),1,MPI_DOUBLE,0,node,MPI_COMM_WORLD);
		        MPI_Send(&(d_ret.D2L_theta_cov3),1,MPI_DOUBLE,0,node,MPI_COMM_WORLD);
		        MPI_Send(&(d_ret.D2L_theta_s),1,MPI_DOUBLE,0,node,MPI_COMM_WORLD);
		        MPI_Send(&(d_ret.D2L_cov1_cov2),1,MPI_DOUBLE,0,node,MPI_COMM_WORLD);
		        MPI_Send(&(d_ret.D2L_cov1_cov3),1,MPI_DOUBLE,0,node,MPI_COMM_WORLD);
		        MPI_Send(&(d_ret.D2L_cov1_s),1,MPI_DOUBLE,0,node,MPI_COMM_WORLD);
		        MPI_Send(&(d_ret.D2L_cov2_cov3),1,MPI_DOUBLE,0,node,MPI_COMM_WORLD);
		        MPI_Send(&(d_ret.D2L_cov2_s),1,MPI_DOUBLE,0,node,MPI_COMM_WORLD);
		        MPI_Send(&(d_ret.D2L_cov3_s),1,MPI_DOUBLE,0,node,MPI_COMM_WORLD);

		        MPI_Recv(&theta,1,MPI_DOUBLE,0,0,MPI_COMM_WORLD,&stat);
		        MPI_Recv(&cov1_size,1,MPI_DOUBLE,0,0,MPI_COMM_WORLD,&stat);
		        MPI_Recv(&cov2_size,1,MPI_DOUBLE,0,0,MPI_COMM_WORLD,&stat);
		        MPI_Recv(&cov3_size,1,MPI_DOUBLE,0,0,MPI_COMM_WORLD,&stat);
		        MPI_Recv(&s,1,MPI_DOUBLE,0,0,MPI_COMM_WORLD,&stat);
			d_ret = derivative_binomial_glmm(theta,cov1_size,cov2_size,cov3_size,s,
						         nobs,phenotypes,cov1,cov2,cov3,ncube_node,u,pu,u_index_vec);
			MPI_Send(&(d_ret.L),1,MPI_DOUBLE,0,node,MPI_COMM_WORLD);
		        MPI_Send(&(d_ret.DL_theta),1,MPI_DOUBLE,0,node,MPI_COMM_WORLD);
		        MPI_Send(&(d_ret.DL_cov1),1,MPI_DOUBLE,0,node,MPI_COMM_WORLD);
		        MPI_Send(&(d_ret.DL_cov2),1,MPI_DOUBLE,0,node,MPI_COMM_WORLD);
		        MPI_Send(&(d_ret.DL_cov3),1,MPI_DOUBLE,0,node,MPI_COMM_WORLD);
		        MPI_Send(&(d_ret.DL_s),1,MPI_DOUBLE,0,node,MPI_COMM_WORLD);
		        MPI_Send(&(d_ret.D2L_theta),1,MPI_DOUBLE,0,node,MPI_COMM_WORLD);
		        MPI_Send(&(d_ret.D2L_cov1),1,MPI_DOUBLE,0,node,MPI_COMM_WORLD);
		        MPI_Send(&(d_ret.D2L_cov2),1,MPI_DOUBLE,0,node,MPI_COMM_WORLD);
		        MPI_Send(&(d_ret.D2L_cov3),1,MPI_DOUBLE,0,node,MPI_COMM_WORLD);
		        MPI_Send(&(d_ret.D2L_s),1,MPI_DOUBLE,0,node,MPI_COMM_WORLD);
		        MPI_Send(&(d_ret.D2L_theta_cov1),1,MPI_DOUBLE,0,node,MPI_COMM_WORLD);
		        MPI_Send(&(d_ret.D2L_theta_cov2),1,MPI_DOUBLE,0,node,MPI_COMM_WORLD);
		        MPI_Send(&(d_ret.D2L_theta_cov3),1,MPI_DOUBLE,0,node,MPI_COMM_WORLD);
		        MPI_Send(&(d_ret.D2L_theta_s),1,MPI_DOUBLE,0,node,MPI_COMM_WORLD);
		        MPI_Send(&(d_ret.D2L_cov1_cov2),1,MPI_DOUBLE,0,node,MPI_COMM_WORLD);
		        MPI_Send(&(d_ret.D2L_cov1_cov3),1,MPI_DOUBLE,0,node,MPI_COMM_WORLD);
		        MPI_Send(&(d_ret.D2L_cov1_s),1,MPI_DOUBLE,0,node,MPI_COMM_WORLD);
		        MPI_Send(&(d_ret.D2L_cov2_cov3),1,MPI_DOUBLE,0,node,MPI_COMM_WORLD);
		        MPI_Send(&(d_ret.D2L_cov2_s),1,MPI_DOUBLE,0,node,MPI_COMM_WORLD);
		        MPI_Send(&(d_ret.D2L_cov3_s),1,MPI_DOUBLE,0,node,MPI_COMM_WORLD);

		        MPI_Recv(&update_pu_code,1,MPI_DOUBLE,0,0,MPI_COMM_WORLD,&stat);
			if (update_pu_code == 1)  {
			        MPI_Recv(&theta,1,MPI_DOUBLE,0,0,MPI_COMM_WORLD,&stat);
			        MPI_Recv(&cov1_size,1,MPI_DOUBLE,0,0,MPI_COMM_WORLD,&stat);
			        MPI_Recv(&cov2_size,1,MPI_DOUBLE,0,0,MPI_COMM_WORLD,&stat);
			        MPI_Recv(&cov3_size,1,MPI_DOUBLE,0,0,MPI_COMM_WORLD,&stat);
			        MPI_Recv(&s,1,MPI_DOUBLE,0,0,MPI_COMM_WORLD,&stat);
			        MPI_Recv(&L,1,MPI_DOUBLE,0,0,MPI_COMM_WORLD,&stat);

				ncube_node = update_pu(theta,cov1_size,cov2_size,cov3_size,s,
				          	       nobs,phenotypes,cov1,cov2,cov3,
				          	       ncube_node,u,pu,u_index_vec,L,
					  	       node,totnodes,cull_thresh);
				}

		        MPI_Recv(&stop_code,1,MPI_DOUBLE,0,0,MPI_COMM_WORLD,&stat);
			}

                MPI_Recv(&pu_store_code,1,MPI_DOUBLE,0,0,MPI_COMM_WORLD,&stat);
                if (pu_store_code == 1)  {
			ncube_node_store = ncube_node;
                        for (i = 0; i < ncube_node; i++)  {
                                pu_store[i] = pu[i];
				u_index_vec_store[i] = u_index_vec[i];
                                }
                        }

                MPI_Recv(&s_eval_code,1,MPI_DOUBLE,0,0,MPI_COMM_WORLD,&stat);
                }


        MPI_Recv(&pu_write_code,1,MPI_DOUBLE,0,0,MPI_COMM_WORLD,&stat);
        write_pu(ncube_node_store,nobs,pu_store,u,u_index_vec_store,"u_matrix_star.dat","pu_matrix_star.dat","a");
        MPI_Send(&pu_write_code,1,MPI_DOUBLE,0,node,MPI_COMM_WORLD);
	}

MPI_Finalize();
}
