#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <mpi.h>

#include "external_functions.h"



typedef struct  {
        double  L;
        double  DL_theta,DL_s;
        double  D2L_theta,D2L_s;
        double  D2L_theta_s;
} derivative_return;



derivative_return derivative_binomial_glmm(double theta,double s,
                                 	   int nobs,double *Y,
                                 	   int ncube,double *u_vec,double *pu_vec,int *u_index_vec)  
{
double          	u,pu;
int			u_index;
double          	z,p;
double          	L;
double          	Dlz_theta,Dlz_s;
double          	D2lz_theta,D2lz_s;
double          	D2lz_theta_s;
double          	prod_L;
double          	sum_Dlz_theta,sum_Dlz_s;
double          	sum_D2lz_theta,sum_D2lz_s;
double          	sum_D2lz_theta_s;
double          	L_acc;
double          	DL_theta_acc,DL_s_acc;
double          	D2L_theta_acc,D2L_s_acc;
double          	D2L_theta_s_acc;
double			pL_pu;
derivative_return	ret_struct;
int             	i,c;


L_acc = 0;

DL_theta_acc = 0;
DL_s_acc = 0;

D2L_theta_acc = 0;
D2L_s_acc = 0;

D2L_theta_s_acc = 0;

for (c = 0; c < ncube; c++)  {
        pu = pu_vec[c];

        prod_L = 1;

        sum_Dlz_theta = 0;
        sum_Dlz_s = 0;

        sum_D2lz_theta = 0;
        sum_D2lz_s = 0;

        sum_D2lz_theta_s = 0;

	u_index = u_index_vec[c];

        for (i = 0; i < nobs; i++)  {
		u = u_vec[(u_index*nobs)+i];

                z = theta + s*u;
                p = exp(z) / (1 + exp(z));

                L = pow(p,Y[i]) * pow(1-p,1-Y[i]);

                prod_L = prod_L * L;

                Dlz_theta = Y[i] - p;
                Dlz_s = u*Dlz_theta;

                D2lz_theta = p*p - p;

                D2lz_theta_s = u*D2lz_theta;

                D2lz_s = u*D2lz_theta_s;

                sum_Dlz_theta = sum_Dlz_theta + Dlz_theta;
                sum_Dlz_s = sum_Dlz_s + Dlz_s;

                sum_D2lz_theta = sum_D2lz_theta + D2lz_theta;
                sum_D2lz_s = sum_D2lz_s + D2lz_s;

                sum_D2lz_theta_s = sum_D2lz_theta_s + D2lz_theta_s;
                }

	pL_pu = prod_L*pu;

        L_acc = L_acc + pL_pu;                              

        DL_theta_acc = DL_theta_acc + sum_Dlz_theta*pL_pu;
        DL_s_acc = DL_s_acc + sum_Dlz_s*pL_pu;

        D2L_theta_acc = D2L_theta_acc + (sum_D2lz_theta + sum_Dlz_theta*sum_Dlz_theta)*pL_pu;
        D2L_s_acc = D2L_s_acc + (sum_D2lz_s + sum_Dlz_s*sum_Dlz_s)*pL_pu;

        D2L_theta_s_acc = D2L_theta_s_acc + (sum_D2lz_theta_s + sum_Dlz_theta*sum_Dlz_s)*pL_pu;
        }


ret_struct.L = L_acc;

ret_struct.DL_theta = DL_theta_acc;
ret_struct.DL_s = DL_s_acc;

ret_struct.D2L_theta = D2L_theta_acc;
ret_struct.D2L_s = D2L_s_acc;

ret_struct.D2L_theta_s = D2L_theta_s_acc;

return(ret_struct);
}



derivative_return gather_nodes(derivative_return d_ret,int totnodes)  
{
MPI_Status	stat;
double		dtool;
int		r;

for (r = 1; r < totnodes; r++)  {
       	MPI_Recv(&dtool,1,MPI_DOUBLE,r,r,MPI_COMM_WORLD,&stat);
        d_ret.L = d_ret.L + dtool;

	MPI_Recv(&dtool,1,MPI_DOUBLE,r,r,MPI_COMM_WORLD,&stat);
	d_ret.DL_theta = d_ret.DL_theta + dtool;
	MPI_Recv(&dtool,1,MPI_DOUBLE,r,r,MPI_COMM_WORLD,&stat);
	d_ret.DL_s = d_ret.DL_s + dtool;

	MPI_Recv(&dtool,1,MPI_DOUBLE,r,r,MPI_COMM_WORLD,&stat);
	d_ret.D2L_theta = d_ret.D2L_theta + dtool;
	MPI_Recv(&dtool,1,MPI_DOUBLE,r,r,MPI_COMM_WORLD,&stat);
	d_ret.D2L_s = d_ret.D2L_s + dtool;

	MPI_Recv(&dtool,1,MPI_DOUBLE,r,r,MPI_COMM_WORLD,&stat);
	d_ret.D2L_theta_s = d_ret.D2L_theta_s + dtool;
        }

return(d_ret);
}



void calculate_derivatives(derivative_return d_ret,double *L,double *DlnL,double *D2lnL)
{
double          	DL_theta,DL_s;
double          	D2L_theta,D2L_s;
double          	D2L_theta_s;
double          	DlnL_theta,DlnL_s;
double          	D2lnL_theta,D2lnL_s;
double          	D2lnL_theta_s;

*L = d_ret.L;

DL_theta = d_ret.DL_theta;
DL_s = d_ret.DL_s;

D2L_theta = d_ret.D2L_theta;
D2L_s = d_ret.D2L_s;
D2L_theta_s = d_ret.D2L_theta_s;

DlnL_theta = DL_theta / *L;
DlnL_s = DL_s / *L;

DlnL[0] = DlnL_theta;
DlnL[1] = DlnL_s;

D2lnL_theta = (D2L_theta / *L) - DlnL_theta*DlnL_theta;
D2lnL_s = (D2L_s / *L) - DlnL_s*DlnL_s;
D2lnL_theta_s = (D2L_theta_s / *L) - DlnL_theta*DlnL_s;

D2lnL[0] = -D2lnL_theta;
D2lnL[3] = -D2lnL_s;
D2lnL[1] = D2lnL[2] = -D2lnL_theta_s;
}


void calculate_parameters(double theta,double s,
			  double *DlnL,double *D2lnL,
			  double *theta_star,double *s_star)
{
double	x11,x12,x22;
double	z1,z2;
double	y1,y2;
double	denom;

x11=D2lnL[0]; x12=D2lnL[1]; 
	      x22=D2lnL[3];

z1 = DlnL[0];
z2 = DlnL[1];

denom = x11*x22 - x12*x12;

if (denom != 0)  {
	y1 = (x22*z1 - z2*x12) / denom;
	y2 = (-x12*z1 + x11*z2) / denom;

	*theta_star = theta + y1;
	*s_star = s + y2;
	}
else	{
	*theta_star = theta;
	*s_star = s;
	}
}



int update_pu(double theta,double s,
              int nobs,double *Y,
              int ncube,double *u_vec,double *pu_vec,int *u_index_vec,
              double L,
	      int node,int totnodes,double thresh)  
{
double          u,pu;
int		u_index;
double          z,p;
double          L_u,L_prod,pu_0;
int		nonzero_cube;
double		pu_acc;
int             i,c,r,inttool;
double		dtool;
int		zero_index,nonzero_index;
MPI_Status	stat;


nonzero_cube = 0;
for (c = 0; c < ncube; c++)  {
        pu = pu_vec[c];

	u_index = u_index_vec[c];

        L_prod = 1;

        for (i = 0; i < nobs; i++)  {
                u = u_vec[(u_index*nobs)+i];

                z = theta + s*u;
                p = exp(z) / (1 + exp(z));

                L_u = pow(p,Y[i]) * pow(1-p,1-Y[i]);

                L_prod = L_prod * L_u;
                }

        pu_0 = (L_prod*pu) / L;                         

	if ((pu_0 < 0) || (pu_0 > 1))  {
		printf("Warning: pu_0= %le\n",pu_0);
		printf("Diagnostic: L_prod= %le pu= %le L_prod*pu= %le L= %le\n",L_prod,pu,L_prod*pu,L);
		}
		
	pu_vec[c] = pu_0;
	if (pu_0 > 0)  {
		nonzero_cube++;
		}
        }

if (node == 0)  {
	for (r = 1; r < totnodes; r++)  {
	      	MPI_Recv(&inttool,1,MPI_INT,r,r,MPI_COMM_WORLD,&stat);
		nonzero_cube = nonzero_cube + inttool;
		}
	thresh = thresh / (double)(nonzero_cube);
	for (r = 1; r < totnodes; r++)  {
		MPI_Send(&thresh,1,MPI_DOUBLE,r,0,MPI_COMM_WORLD);
		}
	}
else	{
	MPI_Send(&nonzero_cube,1,MPI_INT,0,node,MPI_COMM_WORLD);
        MPI_Recv(&thresh,1,MPI_DOUBLE,0,0,MPI_COMM_WORLD,&stat);
	}

pu_acc = 0;
nonzero_cube = 0;
for (c = 0; c < ncube; c++)  {
	if (pu_vec[c] < thresh)  {
		pu_vec[c] = 0;
		}
	else	{
		pu_acc = pu_acc + pu_vec[c];
		nonzero_cube++;
		}
	}

zero_index = 0;
nonzero_index = 0;
do	{
	while ((zero_index < ncube) && (pu_vec[zero_index] != 0))  {
		zero_index++;
		}
	if (zero_index < ncube)  {
		if (nonzero_index < zero_index)  nonzero_index = zero_index;
		while ((nonzero_index < ncube) && (pu_vec[nonzero_index] == 0))  {
			nonzero_index++;
			}
		if (nonzero_index < ncube)  {
			pu_vec[zero_index] = pu_vec[nonzero_index];
			pu_vec[nonzero_index] = 0;

			inttool = u_index_vec[zero_index];
			u_index_vec[zero_index] = u_index_vec[nonzero_index];
			u_index_vec[nonzero_index] = inttool;
			}
		else	{
			zero_index = nonzero_index;
			}
		}
	} while (zero_index < ncube);	

if (node == 0)  {
	for (r = 1; r < totnodes; r++)  {
		MPI_Recv(&dtool,1,MPI_DOUBLE,r,r,MPI_COMM_WORLD,&stat);
		pu_acc = pu_acc + dtool;
		}
	for (r = 1; r < totnodes; r++)  {
		MPI_Send(&pu_acc,1,MPI_DOUBLE,r,0,MPI_COMM_WORLD);
		}
	}
else	{
	MPI_Send(&pu_acc,1,MPI_DOUBLE,0,node,MPI_COMM_WORLD);
	MPI_Recv(&pu_acc,1,MPI_DOUBLE,0,0,MPI_COMM_WORLD,&stat);
	}

for (c = 0; c < nonzero_cube; c++)  {
	pu_vec[c] = pu_vec[c] / pu_acc;
	}

return(nonzero_cube);
}


void write_pu(int ncube,int nobs,
	      double *pu_vec,double *u_vec,int *u_index_vec,
	      char *u_outputfile,char *pu_outputfile,char *write_append)
{
int	c,r,u_index;
FILE    *fptr_u,*fptr_pu;

fptr_u = fopen(u_outputfile,write_append);
fptr_pu = fopen(pu_outputfile,write_append);

for (c = 0; c < ncube; c++)  {
	u_index = u_index_vec[c];

	fprintf(fptr_pu,"%le\n",pu_vec[c]);

	for (r = 0; r < nobs; r++)  {
		fprintf(fptr_u,"%le ",u_vec[(u_index*nobs)+r]);
		}
	fprintf(fptr_u,"\n");
	}

fclose(fptr_u);
fclose(fptr_pu);
}



void main(int argc,char *argv[])
{
int			node,totnodes;
int			nobs,ngene,ncube_node_base;
double			*phenotypes;
double			*u,pu_base,*pu;
int			*u_index_vec;
double			theta_base,s_lo,s_hi,s_step,s_curr;
double			cull_thresh;
double			difference_limit;
int                     *id,*u_id,haltcrit;
int			ncube_node;
double			theta,s;
derivative_return	d_ret;
double			L,DlnL_distance,DlnL[2],D2lnL[4];
double			theta_0,s_0;
derivative_return	d_ret_0;
double			L_0,DlnL_distance_0,DlnL_0[2],D2lnL_0[4];
double			difference;
double			theta_store,s_store;
double			L_store,DlnL_store[2],D2lnL_store[4];
int			ncube_node_store;
double			*pu_store;
int			*u_index_vec_store;
double			s_eval_code,stop_code,update_pu_code,pu_store_code,pu_write_code;
int			retcode;
double			D2lnLinv[4];
int			i,j,r;
char			c,fname[256],fname2[256];
FILE			*fptr;
double			dtool;
MPI_Status		stat;



MPI_Init(&argc,&argv);
MPI_Comm_size(MPI_COMM_WORLD,&totnodes);
MPI_Comm_rank(MPI_COMM_WORLD,&node);

if (argc != 10)  {
        if (node == 0)  {
                printf("Required arguments: <pheno/cov file> <nobs> <ncube_node> <theta effect> <s effect lo> <s effect hi> <s effect step> <stopping crit> <point culling threshhold>\n");
                }
        MPI_Finalize();
        exit(0);
        }

sscanf(argv[2],"%i",&nobs);
id = (int *)malloc(nobs*sizeof(int));
phenotypes = (double *)malloc(nobs*sizeof(double));
fptr = fopen(argv[1],"r");
for (i = 0; i < nobs; i++)  {
        fscanf(fptr,"%i %lf",&(id[i]),&(phenotypes[i]));
        }
fclose(fptr);

sscanf(argv[3],"%i",&ncube_node_base);
u_id = (int *)malloc(nobs*sizeof(int));
u = (double *)malloc(ncube_node_base*nobs*sizeof(double));
sprintf(fname,"u_matrix_%i.dat",node);
fptr = fopen(fname,"r");
for (i = 0; i < nobs; i++)  {
        if (fscanf(fptr,"%i",&(u_id[i])) == EOF)  {
                if (node == 0)  {
                        printf("Too small cubature file. Quitting.\n");
                        }
                MPI_Finalize();
                exit(0);
                }
        }
for (i = 0; i < ncube_node_base*nobs; i++)  {
        if (fscanf(fptr,"%lf",&(u[i])) == EOF)  {
                if (node == 0)  {
                        printf("Too small cubature file. Quitting.\n");
                        }
                MPI_Finalize();
                exit(0);
                }
        }
fclose(fptr);

u_index_vec = (int *)malloc(ncube_node_base*sizeof(int));
for (i = 0; i < ncube_node_base; i++)  {
	u_index_vec[i] = i;
	}
u_index_vec_store = (int *)malloc(ncube_node_base*sizeof(int));
pu = (double *)malloc(ncube_node_base*sizeof(double));
pu_store = (double *)malloc(ncube_node_base*sizeof(double));
pu_base = 1.0 / (double)(ncube_node_base*totnodes);

haltcrit = 0;
for (i = 0; i < nobs; i++)  {
        if (id[i] != u_id[i])  haltcrit = 1;
        }
if (haltcrit == 1)  {
        if (node == 0)  {
                printf("Nonmatching phenotype/covariate and cubature person IDs. Quitting.\n");
                }
        MPI_Finalize();
        exit(0);
        }

sscanf(argv[4],"%le",&theta_base);
	
sscanf(argv[5],"%le",&s_lo);
sscanf(argv[6],"%le",&s_hi);
sscanf(argv[7],"%le",&s_step);

sscanf(argv[8],"%le",&difference_limit);

sscanf(argv[9],"%le",&cull_thresh);


if (node == 0)  {
	s_eval_code = 1;
	s_curr = s_lo;
	while (s_eval_code == 1)  {
		for (r = 1; r < totnodes; r++)  {
			MPI_Send(&s_eval_code,1,MPI_DOUBLE,r,0,MPI_COMM_WORLD);
			}

		printf("s= %le evaluation.\n",s_curr);

		theta = theta_base;
		s = s_curr;
		for (i = 0; i < ncube_node_base; i++)  {
			pu[i] = pu_base;
			}
		ncube_node = ncube_node_base;

		stop_code = 0;
		do	{
			for (r = 1; r < totnodes; r++)  {
				MPI_Send(&stop_code,1,MPI_DOUBLE,r,0,MPI_COMM_WORLD);
				}

			for (r = 1; r < totnodes; r++)  {
				MPI_Send(&theta,1,MPI_DOUBLE,r,0,MPI_COMM_WORLD);
			        MPI_Send(&s,1,MPI_DOUBLE,r,0,MPI_COMM_WORLD);
			        }
			d_ret = derivative_binomial_glmm(theta,s,
							 nobs,phenotypes,ncube_node,u,pu,u_index_vec);
			d_ret = gather_nodes(d_ret,totnodes);
			calculate_derivatives(d_ret,&L,DlnL,D2lnL);
			DlnL_distance = sqrt(pow(DlnL[0],2) + pow(DlnL[1],2));
			printf("\t%le %le : %le %le\n",theta,s,log(L),DlnL_distance);

			calculate_parameters(theta,s,DlnL,D2lnL,&theta_0,&s_0);
			for (r = 1; r < totnodes; r++)  {
				MPI_Send(&theta_0,1,MPI_DOUBLE,r,0,MPI_COMM_WORLD);
			        MPI_Send(&s_0,1,MPI_DOUBLE,r,0,MPI_COMM_WORLD);
			        }
			d_ret_0 = derivative_binomial_glmm(theta_0,s_0,
							   nobs,phenotypes,ncube_node,u,pu,u_index_vec);
			d_ret_0 = gather_nodes(d_ret_0,totnodes);
			calculate_derivatives(d_ret_0,&L_0,DlnL_0,D2lnL_0);
			DlnL_distance_0 = sqrt(pow(DlnL_0[0],2) + pow(DlnL_0[1],2));
			difference = DlnL_distance - DlnL_distance_0;
			printf("\t%le %le : %le %le %le\n",theta_0,s_0,log(L_0),DlnL_distance_0,difference);
	
			if (difference > difference_limit)  {
				theta = theta_0;
				s = s_0;

				L = L_0;

				DlnL_distance = DlnL_distance_0;

				DlnL[0]=DlnL_0[0]; DlnL[1]=DlnL_0[1];

				D2lnL[0]=D2lnL_0[0]; D2lnL[1]=D2lnL_0[1]; 
				D2lnL[2]=D2lnL_0[2]; D2lnL[3]=D2lnL_0[3];

				update_pu_code = 1;
				for (r = 1; r < totnodes; r++)  {
				        MPI_Send(&update_pu_code,1,MPI_DOUBLE,r,0,MPI_COMM_WORLD);

				        MPI_Send(&theta_0,1,MPI_DOUBLE,r,0,MPI_COMM_WORLD);
				        MPI_Send(&s_0,1,MPI_DOUBLE,r,0,MPI_COMM_WORLD);
				        MPI_Send(&L_0,1,MPI_DOUBLE,r,0,MPI_COMM_WORLD);
					}
				ncube_node = update_pu(theta_0,s_0,
				          	       nobs,phenotypes,
				          	       ncube_node,u,pu,u_index_vec,L_0,
		 			  	       node,totnodes,cull_thresh);

				stop_code = 0;
				}
			else	{
				update_pu_code = 0;
				for (r = 1; r < totnodes; r++)  {
				        MPI_Send(&update_pu_code,1,MPI_DOUBLE,r,0,MPI_COMM_WORLD);
					}

				stop_code = 1;
				}			
			} while (stop_code == 0);
		for (r = 1; r < totnodes; r++)  {
			MPI_Send(&stop_code,1,MPI_DOUBLE,r,0,MPI_COMM_WORLD);
			}

		if ((s_curr == s_lo) || (L > L_store))  {
			pu_store_code = 1;
			for (r = 1; r < totnodes; r++)  {
				MPI_Send(&pu_store_code,1,MPI_DOUBLE,r,0,MPI_COMM_WORLD);
				}

			theta_store = theta; s_store = s;			

			L_store = L;

			DlnL_store[0] = DlnL[0]; DlnL_store[1] = DlnL[1];

			D2lnL_store[0] = D2lnL[0]; D2lnL_store[1] = D2lnL[1]; 
			D2lnL_store[2] = D2lnL[2]; D2lnL_store[3] = D2lnL[3];

			ncube_node_store = ncube_node;
			for (i = 0; i < ncube_node; i++)  {
				pu_store[i] = pu[i];
				u_index_vec_store[i] = u_index_vec[i];
				}
			}
		else	{
			pu_store_code = 0;
			for (r = 1; r < totnodes; r++)  {
				MPI_Send(&pu_store_code,1,MPI_DOUBLE,r,0,MPI_COMM_WORLD);
				}
			}

		printf("Curr Parameters: ");
		printf("theta= %le s= %le ",theta,s);
		printf("lnL= %le\n",log(L));
		printf("Best Parameters: ");
		printf("theta= %le s= %le ",theta_store,s_store);
		printf("lnL= %le\n",log(L_store));

		s_curr = s_curr + s_step;
		if (s_curr > s_hi) s_eval_code = 0;
		}
	for (r = 1; r < totnodes; r++)  {
		MPI_Send(&s_eval_code,1,MPI_DOUBLE,r,0,MPI_COMM_WORLD);
		}

	printf("Final Parameters: ");
	printf("theta= %le s= %le\n",theta_store,s_store);
	printf("lnL= %le\n",log(L_store));
	printf("DlnL= %le %le\n",DlnL_store[0],DlnL_store[1]);
	printf("D2lnL=\n");
	printf("%le %le\n",D2lnL_store[0],D2lnL_store[1]);
	printf("%le %le\n",D2lnL_store[2],D2lnL_store[3]);
        retcode = invert_matrix_2x2(D2lnL_store,D2lnLinv);
	printf("D2lnLinv=\n");
	printf("%le %le\n",D2lnLinv[0],D2lnLinv[1]);
	printf("%le %le\n",D2lnLinv[2],D2lnLinv[3]);

	write_pu(ncube_node_store,nobs,pu_store,u,u_index_vec_store,"u_matrix_star.dat","pu_matrix_star.dat","w");
	for (r = 1; r < totnodes; r++)  {
		MPI_Send(&pu_write_code,1,MPI_DOUBLE,r,0,MPI_COMM_WORLD);
		MPI_Recv(&pu_write_code,1,MPI_DOUBLE,r,r,MPI_COMM_WORLD,&stat);
		}
	}
else	{
	MPI_Recv(&s_eval_code,1,MPI_DOUBLE,0,0,MPI_COMM_WORLD,&stat);

	while (s_eval_code == 1)  {
		for (i = 0; i < ncube_node_base; i++)  {
			pu[i] = pu_base;
			}
		ncube_node = ncube_node_base;

	        MPI_Recv(&stop_code,1,MPI_DOUBLE,0,0,MPI_COMM_WORLD,&stat);
		while (stop_code == 0)  {
		        MPI_Recv(&theta,1,MPI_DOUBLE,0,0,MPI_COMM_WORLD,&stat);
		        MPI_Recv(&s,1,MPI_DOUBLE,0,0,MPI_COMM_WORLD,&stat);
			d_ret = derivative_binomial_glmm(theta,s,
			 			         nobs,phenotypes,ncube_node,u,pu,u_index_vec);
			MPI_Send(&(d_ret.L),1,MPI_DOUBLE,0,node,MPI_COMM_WORLD);
		        MPI_Send(&(d_ret.DL_theta),1,MPI_DOUBLE,0,node,MPI_COMM_WORLD);
		        MPI_Send(&(d_ret.DL_s),1,MPI_DOUBLE,0,node,MPI_COMM_WORLD);
		        MPI_Send(&(d_ret.D2L_theta),1,MPI_DOUBLE,0,node,MPI_COMM_WORLD);
		        MPI_Send(&(d_ret.D2L_s),1,MPI_DOUBLE,0,node,MPI_COMM_WORLD);
		        MPI_Send(&(d_ret.D2L_theta_s),1,MPI_DOUBLE,0,node,MPI_COMM_WORLD);

		        MPI_Recv(&theta,1,MPI_DOUBLE,0,0,MPI_COMM_WORLD,&stat);
		        MPI_Recv(&s,1,MPI_DOUBLE,0,0,MPI_COMM_WORLD,&stat);
			d_ret = derivative_binomial_glmm(theta,s,
			 			         nobs,phenotypes,ncube_node,u,pu,u_index_vec);
			MPI_Send(&(d_ret.L),1,MPI_DOUBLE,0,node,MPI_COMM_WORLD);
		        MPI_Send(&(d_ret.DL_theta),1,MPI_DOUBLE,0,node,MPI_COMM_WORLD);
		        MPI_Send(&(d_ret.DL_s),1,MPI_DOUBLE,0,node,MPI_COMM_WORLD);
		        MPI_Send(&(d_ret.D2L_theta),1,MPI_DOUBLE,0,node,MPI_COMM_WORLD);
		        MPI_Send(&(d_ret.D2L_s),1,MPI_DOUBLE,0,node,MPI_COMM_WORLD);
		        MPI_Send(&(d_ret.D2L_theta_s),1,MPI_DOUBLE,0,node,MPI_COMM_WORLD);

		        MPI_Recv(&update_pu_code,1,MPI_DOUBLE,0,0,MPI_COMM_WORLD,&stat);
			if (update_pu_code == 1)  {
			        MPI_Recv(&theta,1,MPI_DOUBLE,0,0,MPI_COMM_WORLD,&stat);
			        MPI_Recv(&s,1,MPI_DOUBLE,0,0,MPI_COMM_WORLD,&stat);
			        MPI_Recv(&L,1,MPI_DOUBLE,0,0,MPI_COMM_WORLD,&stat);

				ncube_node = update_pu(theta,s,
				          	       nobs,phenotypes,
				          	       ncube_node,u,pu,u_index_vec,L,
		 			               node,totnodes,cull_thresh);
				}

		        MPI_Recv(&stop_code,1,MPI_DOUBLE,0,0,MPI_COMM_WORLD,&stat);
			}

	        MPI_Recv(&pu_store_code,1,MPI_DOUBLE,0,0,MPI_COMM_WORLD,&stat);
		if (pu_store_code == 1)  {
			ncube_node_store = ncube_node;
			for (i = 0; i < ncube_node; i++)  {
				pu_store[i] = pu[i];
				u_index_vec_store[i] = u_index_vec[i];
				}
			}

		MPI_Recv(&s_eval_code,1,MPI_DOUBLE,0,0,MPI_COMM_WORLD,&stat);
		}

	MPI_Recv(&pu_write_code,1,MPI_DOUBLE,0,0,MPI_COMM_WORLD,&stat);
	write_pu(ncube_node_store,nobs,pu_store,u,u_index_vec_store,"u_matrix_star.dat","pu_matrix_star.dat","a");
	MPI_Send(&pu_write_code,1,MPI_DOUBLE,0,node,MPI_COMM_WORLD);
	}

MPI_Finalize();
}
