#include <stdlib.h>
#include <stdio.h>
#include <math.h>


#include "external_functions.h"


typedef struct  {
	double	L;
	double	DL_theta,DL_cov1,DL_cov2,DL_gamma,DL_s;
	double	D2L_theta,D2L_cov1,D2L_cov2,D2L_gamma,D2L_s;
	double 	D2L_theta_cov1,D2L_theta_cov2,D2L_theta_gamma,D2L_theta_s;
	double	D2L_cov1_cov2,D2L_cov1_gamma,D2L_cov1_s;
	double	D2L_cov2_gamma,D2L_cov2_s;
	double	D2L_gamma_s;
} score_return;



score_return score_binomial_glmm(double theta,double cov1_size,double cov2_size,double gamma,double s,
				 int nobs,double *g,double *Y,double *cov1,double *cov2,
				 int ncube,double *u_vec,double *pu_vec)  {
double 		u,pu;
double		z,p;
double		L;
double		Dlz_theta,Dlz_cov1,Dlz_cov2,Dlz_gamma,Dlz_s;
double		D2lz_theta,D2lz_cov1,D2lz_cov2,D2lz_gamma,D2lz_s;
double		D2lz_theta_cov1,D2lz_theta_cov2,D2lz_theta_gamma,D2lz_theta_s;
double		D2lz_cov1_cov2,D2lz_cov1_gamma,D2lz_cov1_s;
double		D2lz_cov2_gamma,D2lz_cov2_s;
double		D2lz_gamma_s;
double		prod_L;
double		sum_Dlz_theta,sum_Dlz_cov1,sum_Dlz_cov2,sum_Dlz_gamma,sum_Dlz_s;
double		sum_D2lz_theta,sum_D2lz_cov1,sum_D2lz_cov2,sum_D2lz_gamma,sum_D2lz_s;
double		sum_D2lz_theta_cov1,sum_D2lz_theta_cov2,sum_D2lz_theta_gamma,sum_D2lz_theta_s;
double		sum_D2lz_cov1_cov2,sum_D2lz_cov1_gamma,sum_D2lz_cov1_s;
double		sum_D2lz_cov2_gamma,sum_D2lz_cov2_s;
double		sum_D2lz_gamma_s;
double		L_acc;
double		DL_theta_acc,DL_cov1_acc,DL_cov2_acc,DL_gamma_acc,DL_s_acc;
double		D2L_theta_acc,D2L_cov1_acc,D2L_cov2_acc,D2L_gamma_acc,D2L_s_acc;
double		D2L_theta_cov1_acc,D2L_theta_cov2_acc,D2L_theta_gamma_acc,D2L_theta_s_acc;
double		D2L_cov1_cov2_acc,D2L_cov1_gamma_acc,D2L_cov1_s_acc;
double		D2L_cov2_gamma_acc,D2L_cov2_s_acc;
double		D2L_gamma_s_acc;
double		pLpu;
score_return	ret_struct;
int		i,c;


L_acc = 0;

DL_theta_acc = 0;
DL_cov1_acc = 0;
DL_cov2_acc = 0;
DL_gamma_acc = 0;
DL_s_acc = 0;

D2L_theta_acc = 0;
D2L_cov1_acc = 0;
D2L_cov2_acc = 0;
D2L_gamma_acc = 0;
D2L_s_acc = 0;

D2L_theta_cov1_acc = 0;
D2L_theta_cov2_acc = 0;
D2L_theta_gamma_acc = 0;
D2L_theta_s_acc = 0;

D2L_cov1_cov2_acc = 0;
D2L_cov1_gamma_acc = 0;
D2L_cov1_s_acc = 0;

D2L_cov2_gamma_acc = 0;
D2L_cov2_s_acc = 0;

D2L_gamma_s_acc = 0;

for (c = 0; c < ncube; c++)  {
	pu = pu_vec[c];

	prod_L = 1;

	sum_Dlz_theta = 0;
	sum_Dlz_cov1 = 0;
	sum_Dlz_cov2 = 0;
	sum_Dlz_gamma = 0;
	sum_Dlz_s = 0;

	sum_D2lz_theta = 0;
	sum_D2lz_cov1 = 0;
	sum_D2lz_cov2 = 0;
	sum_D2lz_gamma = 0;
	sum_D2lz_s = 0;

	sum_D2lz_theta_cov1 = 0;
	sum_D2lz_theta_cov2 = 0;
	sum_D2lz_theta_gamma = 0;
	sum_D2lz_theta_s = 0;

	sum_D2lz_cov1_cov2 = 0;
	sum_D2lz_cov1_gamma = 0;
	sum_D2lz_cov1_s = 0;

	sum_D2lz_cov2_gamma = 0;
	sum_D2lz_cov2_s = 0;

	sum_D2lz_gamma_s = 0;

	for (i = 0; i < nobs; i++)  {
		/*if (g[i] >= 0)  {*/
		if (g[i] != -666.13)  {
			u = u_vec[(c*nobs)+i];

			z = theta + cov1_size*cov1[i] + cov2_size*cov2[i] + gamma*g[i] + s*u;
			p = exp(z) / (1 + exp(z));

			L = pow(p,Y[i]) * pow(1-p,1-Y[i]);

			prod_L = prod_L * L;

			Dlz_theta = Y[i] - p;
			Dlz_cov1 = cov1[i]*Dlz_theta;
			Dlz_cov2 = cov2[i]*Dlz_theta;
			Dlz_gamma = g[i]*Dlz_theta;
			Dlz_s = u*Dlz_theta;

			D2lz_theta = p*p - p;

			D2lz_theta_cov1 = cov1[i]*D2lz_theta;
			D2lz_theta_cov2 = cov2[i]*D2lz_theta;
			D2lz_theta_gamma = g[i]*D2lz_theta;
			D2lz_theta_s = u*D2lz_theta;

			D2lz_cov1 = cov1[i]*D2lz_theta_cov1;
			D2lz_cov2 = cov2[i]*D2lz_theta_cov2;
			D2lz_gamma = g[i]*D2lz_theta_gamma;
			D2lz_s = u*D2lz_theta_s;

			D2lz_cov1_cov2 = cov1[i]*D2lz_theta_cov2;
			D2lz_cov1_gamma = cov1[i]*D2lz_theta_gamma;
			D2lz_cov1_s = cov1[i]*D2lz_theta_s;

			D2lz_cov2_gamma = cov2[i]*D2lz_theta_gamma;
			D2lz_cov2_s = cov2[i]*D2lz_theta_s;

			D2lz_gamma_s = g[i]*D2lz_theta_s;

			sum_Dlz_theta = sum_Dlz_theta + Dlz_theta;
			sum_Dlz_cov1 = sum_Dlz_cov1 + Dlz_cov1;
			sum_Dlz_cov2 = sum_Dlz_cov2 + Dlz_cov2;
			sum_Dlz_gamma = sum_Dlz_gamma + Dlz_gamma;
			sum_Dlz_s = sum_Dlz_s + Dlz_s;

			sum_D2lz_theta = sum_D2lz_theta + D2lz_theta;
			sum_D2lz_cov1 = sum_D2lz_cov1 + D2lz_cov1;
			sum_D2lz_cov2 = sum_D2lz_cov2 + D2lz_cov2;
			sum_D2lz_gamma = sum_D2lz_gamma + D2lz_gamma;
			sum_D2lz_s = sum_D2lz_s + D2lz_s;

			sum_D2lz_theta_cov1 = sum_D2lz_theta_cov1 + D2lz_theta_cov1;
			sum_D2lz_theta_cov2 = sum_D2lz_theta_cov2 + D2lz_theta_cov2;
			sum_D2lz_theta_gamma = sum_D2lz_theta_gamma + D2lz_theta_gamma;
			sum_D2lz_theta_s = sum_D2lz_theta_s + D2lz_theta_s;

			sum_D2lz_cov1_cov2 = sum_D2lz_cov1_cov2 + D2lz_cov1_cov2;
			sum_D2lz_cov1_gamma = sum_D2lz_cov1_gamma + D2lz_cov1_gamma;
			sum_D2lz_cov1_s = sum_D2lz_cov1_s + D2lz_cov1_s;

			sum_D2lz_cov2_gamma = sum_D2lz_cov2_gamma + D2lz_cov2_gamma;
			sum_D2lz_cov2_s = sum_D2lz_cov2_s + D2lz_cov2_s;

			sum_D2lz_gamma_s = sum_D2lz_gamma_s + D2lz_gamma_s;
			}
		}

	pLpu = prod_L*pu;

	L_acc = L_acc + pLpu;				

	DL_theta_acc = DL_theta_acc + sum_Dlz_theta*pLpu;
	DL_cov1_acc = DL_cov1_acc + sum_Dlz_cov1*pLpu;
	DL_cov2_acc = DL_cov2_acc + sum_Dlz_cov2*pLpu;
	DL_gamma_acc = DL_gamma_acc + sum_Dlz_gamma*pLpu;
	DL_s_acc = DL_s_acc + sum_Dlz_s*pLpu;

	D2L_theta_acc = D2L_theta_acc + (sum_D2lz_theta + sum_Dlz_theta*sum_Dlz_theta)*pLpu;
	D2L_cov1_acc = D2L_cov1_acc + (sum_D2lz_cov1 + sum_Dlz_cov1*sum_Dlz_cov1)*pLpu;
	D2L_cov2_acc = D2L_cov2_acc + (sum_D2lz_cov2 + sum_Dlz_cov2*sum_Dlz_cov2)*pLpu;
	D2L_gamma_acc = D2L_gamma_acc + (sum_D2lz_gamma + sum_Dlz_gamma*sum_Dlz_gamma)*pLpu;
	D2L_s_acc = D2L_s_acc + (sum_D2lz_s + sum_Dlz_s*sum_Dlz_s)*pLpu;

	D2L_theta_cov1_acc = D2L_theta_cov1_acc + (sum_D2lz_theta_cov1 + sum_Dlz_theta*sum_Dlz_cov1)*pLpu;
	D2L_theta_cov2_acc = D2L_theta_cov2_acc + (sum_D2lz_theta_cov2 + sum_Dlz_theta*sum_Dlz_cov2)*pLpu;
	D2L_theta_gamma_acc = D2L_theta_gamma_acc + (sum_D2lz_theta_gamma + sum_Dlz_theta*sum_Dlz_gamma)*pLpu;
	D2L_theta_s_acc = D2L_theta_s_acc + (sum_D2lz_theta_s + sum_Dlz_theta*sum_Dlz_s)*pLpu;

	D2L_cov1_cov2_acc = D2L_cov1_cov2_acc + (sum_D2lz_cov1_cov2 + sum_Dlz_cov1*sum_Dlz_cov2)*pLpu;
	D2L_cov1_gamma_acc = D2L_cov1_gamma_acc + (sum_D2lz_cov1_gamma + sum_Dlz_cov1*sum_Dlz_gamma)*pLpu;
	D2L_cov1_s_acc = D2L_cov1_s_acc + (sum_D2lz_cov1_s + sum_Dlz_cov1*sum_Dlz_s)*pLpu;

	D2L_cov2_gamma_acc = D2L_cov2_gamma_acc + (sum_D2lz_cov2_gamma + sum_Dlz_cov2*sum_Dlz_gamma)*pLpu;
	D2L_cov2_s_acc = D2L_cov2_s_acc + (sum_D2lz_cov2_s + sum_Dlz_cov2*sum_Dlz_s)*pLpu;

	D2L_gamma_s_acc = D2L_gamma_s_acc + (sum_D2lz_gamma_s + sum_Dlz_gamma*sum_Dlz_s)*pLpu;
	}


ret_struct.L = L_acc;

ret_struct.DL_theta = DL_theta_acc;
ret_struct.DL_cov1 = DL_cov1_acc;
ret_struct.DL_cov2 = DL_cov2_acc;
ret_struct.DL_gamma = DL_gamma_acc;
ret_struct.DL_s = DL_s_acc;

ret_struct.D2L_theta = D2L_theta_acc;
ret_struct.D2L_cov1 = D2L_cov1_acc;
ret_struct.D2L_cov2 = D2L_cov2_acc;
ret_struct.D2L_gamma = D2L_gamma_acc;
ret_struct.D2L_s = D2L_s_acc;

ret_struct.D2L_theta_cov1 = D2L_theta_cov1_acc;
ret_struct.D2L_theta_cov2 = D2L_theta_cov2_acc;
ret_struct.D2L_theta_gamma = D2L_theta_gamma_acc;
ret_struct.D2L_theta_s = D2L_theta_s_acc;

ret_struct.D2L_cov1_cov2 = D2L_cov1_cov2_acc;
ret_struct.D2L_cov1_gamma = D2L_cov1_gamma_acc;
ret_struct.D2L_cov1_s = D2L_cov1_s_acc;

ret_struct.D2L_cov2_gamma = D2L_cov2_gamma_acc;
ret_struct.D2L_cov2_s = D2L_cov2_s_acc;

ret_struct.D2L_gamma_s = D2L_gamma_s_acc;

return(ret_struct);
}


void main(int argc,char *argv[])
{
int		nobs,ngene,ncube_node;
double		*phenotypes,*cov1,*cov2,*genotypes;
char		snp[256],gtool[256];
double		*u,*pu;
double		theta_star,cov1_size_star,cov2_size_star,s_star;
score_return	score_components;
double		L;
double		DL_theta,DL_cov1,DL_cov2,DL_gamma,DL_s;
double		D2L_theta,D2L_cov1,D2L_cov2,D2L_gamma,D2L_s;
double		D2L_theta_cov1,D2L_theta_cov2,D2L_theta_gamma,D2L_theta_s;
double		D2L_cov1_cov2,D2L_cov1_gamma,D2L_cov1_s;
double		D2L_cov2_gamma,D2L_cov2_s;
double		D2L_gamma_s;
double		lnL;
double		DlnL_theta,DlnL_cov1,DlnL_cov2,DlnL_gamma,DlnL_s;
double		D2lnL_theta,D2lnL_cov1,D2lnL_cov2,D2lnL_gamma,D2lnL_s;
double		D2lnL_theta_cov1,D2lnL_theta_cov2,D2lnL_theta_gamma,D2lnL_theta_s;
double		D2lnL_cov1_cov2,D2lnL_cov1_gamma,D2lnL_cov1_s;
double		D2lnL_cov2_gamma,D2lnL_cov2_s;
double		D2lnL_gamma_s;
double		D2lnL[25],D2lnLinv[25];
double		score_statistic,s_c_proc;
int             *id,*u_id,*g_id,haltcrit;
int		i,j,g,r,retcode;
char		c,fname[256];
FILE		*fptr;
double		dtool;


if (argc != 9)  {
        printf("Required arguments: <pheno/cov file> <nobs> <geno file> <ngene> <theta effect> <cov1 effect> <cov2 effect> <s effect>\n");
        exit(0);
        }

sscanf(argv[5],"%le",&theta_star);
sscanf(argv[6],"%le",&cov1_size_star);
sscanf(argv[7],"%le",&cov2_size_star);
sscanf(argv[8],"%le",&s_star);

sscanf(argv[2],"%i",&nobs);
id = (int *)malloc(nobs*sizeof(int));
phenotypes = (double *)malloc(nobs*sizeof(double));
cov1 = (double *)malloc(nobs*sizeof(double));
cov2 = (double *)malloc(nobs*sizeof(double));
fptr = fopen(argv[1],"r");
for (i = 0; i < nobs; i++)  {
	fscanf(fptr,"%i %lf %lf %lf",&(id[i]),&(phenotypes[i]),&(cov1[i]),&(cov2[i]));
	}
fclose(fptr);

ncube_node = 0;
sprintf(fname,"pu_matrix.dat");
fptr = fopen(fname,"r");
while (fscanf(fptr,"%*s") != EOF)  {
        ncube_node++;
        }
fclose(fptr);
printf("Total cubature size = %i\n",ncube_node);
/*
u_id = (int *)malloc(nobs*sizeof(int));
*/
u = (double *)malloc(ncube_node*nobs*sizeof(double));
sprintf(fname,"u_matrix.dat");
fptr = fopen(fname,"r");
/*
for (i = 0; i < nobs; i++)  {
        if (fscanf(fptr,"%i",&(u_id[i])) == EOF)  {
                printf("Too small cubature file. Quitting.\n");
                exit(0);
                }
        }
*/
for (i = 0; i < ncube_node*nobs; i++)  {
        if (fscanf(fptr,"%lf",&(u[i])) == EOF)  {
                printf("Too small cubature file. Quitting.\n");
                exit(0);
                }
        }
fclose(fptr);
pu = (double *)malloc(ncube_node*sizeof(double));
sprintf(fname,"pu_matrix.dat");
fptr = fopen(fname,"r");
for (i = 0; i < ncube_node; i++)  {
	fscanf(fptr,"%lf",&(pu[i]));
	}
fclose(fptr);

/*
haltcrit = 0;
for (i = 0; i < nobs; i++)  {
        if (id[i] != u_id[i])  haltcrit = 1;
        }
if (haltcrit == 1)  {
        printf("Nonmatching cubature and phenotype/covariate person IDs. Quitting.\n");
        exit(0);
        }
*/

sscanf(argv[4],"%i",&ngene);
fptr = fopen(argv[3],"r");
genotypes = (double *)malloc(nobs*sizeof(double));
g_id = (int *)malloc(nobs*sizeof(int));
fscanf(fptr,"%*s");
for (i = 0; i < nobs; i++)  {
        fscanf(fptr,"%i",&(g_id[i]));
        }

haltcrit = 0;
for (i = 0; i < nobs; i++)  {
        if (id[i] != g_id[i])  haltcrit = 1;
        }
if (haltcrit == 1)  {
        printf("Nonmatching phenotype/covariate and genotype person IDs. Quitting.\n");
        exit(0);
        }

for (i = 0; i < ngene; i++)  {
	fscanf(fptr,"%s",snp);

	for (j = 0; j < nobs; j++)  {
                fscanf(fptr,"%s",gtool);
                if (strcmp(gtool,"NA") == 0)  genotypes[j] = -666.13;
                else  sscanf(gtool,"%le",&(genotypes[j]));
		}

	score_components = score_binomial_glmm(theta_star,cov1_size_star,cov2_size_star,0,s_star,nobs,genotypes,phenotypes,cov1,cov2,ncube_node,u,pu);

	L = score_components.L;

	DL_theta = score_components.DL_theta;
	DL_cov1 = score_components.DL_cov1;
	DL_cov2 = score_components.DL_cov2;
	DL_gamma = score_components.DL_gamma;
	DL_s = score_components.DL_s;

	D2L_theta = score_components.D2L_theta;
	D2L_cov1 = score_components.D2L_cov1;
	D2L_cov2 = score_components.D2L_cov2;
	D2L_gamma = score_components.D2L_gamma;
	D2L_s = score_components.D2L_s;

	D2L_theta_cov1 = score_components.D2L_theta_cov1;
	D2L_theta_cov2 = score_components.D2L_theta_cov2;
	D2L_theta_gamma = score_components.D2L_theta_gamma;
	D2L_theta_s = score_components.D2L_theta_s;

	D2L_cov1_cov2 = score_components.D2L_cov1_cov2;
	D2L_cov1_gamma = score_components.D2L_cov1_gamma;
	D2L_cov1_s = score_components.D2L_cov1_s;

	D2L_cov2_gamma = score_components.D2L_cov2_gamma;
	D2L_cov2_s = score_components.D2L_cov2_s;

	D2L_gamma_s = score_components.D2L_gamma_s;

	lnL = log(L);

	DlnL_theta = DL_theta / L;
	DlnL_cov1 = DL_cov1 / L;
	DlnL_cov2 = DL_cov2 / L;
	DlnL_gamma = DL_gamma / L;
	DlnL_s = DL_s / L;

	D2lnL_theta = (D2L_theta / L) - DlnL_theta*DlnL_theta;
	D2lnL_cov1 = (D2L_cov1 / L) - DlnL_cov1*DlnL_cov1;
	D2lnL_cov2 = (D2L_cov2 / L) - DlnL_cov2*DlnL_cov2;
	D2lnL_gamma = (D2L_gamma / L) - DlnL_gamma*DlnL_gamma;
	D2lnL_s = (D2L_s / L) - DlnL_s*DlnL_s;

	D2lnL_theta_cov1 = (D2L_theta_cov1 / L) - DlnL_theta*DlnL_cov1;
	D2lnL_theta_cov2 = (D2L_theta_cov2 / L) - DlnL_theta*DlnL_cov2;
	D2lnL_theta_gamma = (D2L_theta_gamma / L) - DlnL_theta*DlnL_gamma;
	D2lnL_theta_s = (D2L_theta_s / L) - DlnL_theta*DlnL_s;

	D2lnL_cov1_cov2 = (D2L_cov1_cov2 / L) - DlnL_cov1*DlnL_cov2;
	D2lnL_cov1_gamma = (D2L_cov1_gamma / L) - DlnL_cov1*DlnL_gamma;
	D2lnL_cov1_s = (D2L_cov1_s / L) - DlnL_cov1*DlnL_s;

	D2lnL_cov2_gamma = (D2L_cov2_gamma / L) - DlnL_cov2*DlnL_gamma;
	D2lnL_cov2_s = (D2L_cov2_s / L) - DlnL_cov2*DlnL_s;

	D2lnL_gamma_s = (D2L_gamma_s / L) - DlnL_gamma*DlnL_s;


	D2lnL[0] = -D2lnL_theta;
	D2lnL[6] = -D2lnL_cov1;
	D2lnL[12] = -D2lnL_cov2;
	D2lnL[18] = -D2lnL_gamma;
	D2lnL[24] = -D2lnL_s;

	D2lnL[1] = D2lnL[5] = -D2lnL_theta_cov1;
	D2lnL[2] = D2lnL[10] = -D2lnL_theta_cov2;
	D2lnL[3] = D2lnL[15] = -D2lnL_theta_gamma;
	D2lnL[4] = D2lnL[20] = -D2lnL_theta_s;

	D2lnL[7] = D2lnL[11] = -D2lnL_cov1_cov2;
	D2lnL[8] = D2lnL[16] = -D2lnL_cov1_gamma;
	D2lnL[9] = D2lnL[21] = -D2lnL_cov1_s;

	D2lnL[13] = D2lnL[17] = -D2lnL_cov2_gamma;
	D2lnL[14] = D2lnL[22] = -D2lnL_cov2_s;

	D2lnL[19] = D2lnL[23] = -D2lnL_gamma_s;

	retcode = invert_matrix_5x5(D2lnL,D2lnLinv);

	if (retcode == 0)  {
		score_statistic = DlnL_gamma*DlnL_gamma*D2lnLinv[18];
		printf("%s %le\n",snp,score_statistic);
		}
	else	{
		printf("%s NA\n",snp);
		}
	/*
	printf("lnL= %le\n",lnL);
	printf("DlnL= %le %le %le %le %le\n",DlnL_theta,DlnL_cov1,DlnL_cov2,DlnL_gamma,DlnL_s);
	printf("D2lnL=\n");
	printf("%le %le %le %le %le\n",D2lnL[0],D2lnL[1],D2lnL[2],D2lnL[3],D2lnL[4]);
	printf("%le %le %le %le %le\n",D2lnL[5],D2lnL[6],D2lnL[7],D2lnL[8],D2lnL[9]);
	printf("%le %le %le %le %le\n",D2lnL[10],D2lnL[11],D2lnL[12],D2lnL[13],D2lnL[14]);
	printf("%le %le %le %le %le\n",D2lnL[15],D2lnL[16],D2lnL[17],D2lnL[18],D2lnL[19]);
	printf("%le %le %le %le %le\n",D2lnL[20],D2lnL[21],D2lnL[22],D2lnL[23],D2lnL[24]);
	printf("D2lnLinv=\n");
	printf("%le %le %le %le %le\n",D2lnLinv[0],D2lnLinv[1],D2lnLinv[2],D2lnLinv[3],D2lnLinv[4]);
	printf("%le %le %le %le %le\n",D2lnLinv[5],D2lnLinv[6],D2lnLinv[7],D2lnLinv[8],D2lnLinv[9]);
	printf("%le %le %le %le %le\n",D2lnLinv[10],D2lnLinv[11],D2lnLinv[12],D2lnLinv[13],D2lnLinv[14]);
	printf("%le %le %le %le %le\n",D2lnLinv[15],D2lnLinv[16],D2lnLinv[17],D2lnLinv[18],D2lnLinv[19]);
	printf("%le %le %le %le %le\n",D2lnLinv[20],D2lnLinv[21],D2lnLinv[22],D2lnLinv[23],D2lnLinv[24]);

	exit(0);
	*/
	}

fclose(fptr);
free(phenotypes);
free(genotypes);
free(u);
free(pu);
}
