/*
 * Decompiled with CFR 0.152.
 */
package edu.hust.go.gui;

import edu.hust.go.gui.GoCell;
import java.awt.Component;
import java.util.Enumeration;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class GoTreeView
extends JTree {
    public GoTreeView(TreeModel model) {
        super(model);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setCellRenderer(new TipTreeCellRenderer());
        TreeNode root = (TreeNode)model.getRoot();
        this.expandAll(this, new TreePath(root), true);
    }

    private void expandAll(JTree tree, TreePath parent, boolean expand) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                this.expandAll(tree, path, expand);
            }
        }
        if (expand) {
            tree.expandPath(parent);
        } else {
            tree.collapsePath(parent);
        }
    }

    class TipTreeCellRenderer
    extends DefaultTreeCellRenderer {
        TipTreeCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            String toolTip = "";
            if (value instanceof GoCell) {
                toolTip = ((GoCell)value).getToolTipString();
            }
            this.setToolTipText(toolTip);
            return this;
        }
    }
}

