/*
 * Decompiled with CFR 0.152.
 */
package edu.hust.go.model;

import edu.hust.go.model.GoGraphModel;
import edu.hust.go.model.GraphPath;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;
import org._3pq.jgrapht.graph.SimpleDirectedGraph;

public class Similarity {
    public static final byte CAO = 0;
    public static final byte LIN = 1;
    public static final byte RESNIK = 2;
    public static final byte ZZL = 3;
    public static final byte oldZZL = 4;

    public static float evaluate(GoGraphModel graphModel, Object obj1, Object obj2, byte type) {
        Object[][] bPath;
        float rootChild = 0.0f;
        SimpleDirectedGraph graph = graphModel.getGraph();
        Object[][] aPath = GraphPath.getPath2Root(graph, obj1);
        if (!Similarity.sameRoot(aPath, bPath = GraphPath.getPath2Root(graph, obj2))) {
            return 0.0f;
        }
        rootChild = ((Integer)graphModel.getRootVertexesMap().get(aPath[0][aPath[0].length - 1])).floatValue() + 1.0f;
        int[] lcaIndexes = Similarity.findLatestCommonAncestor(aPath, bPath, graph);
        switch (type) {
            case 0: {
                return Similarity.cao(aPath, bPath, graph, obj1, obj2, rootChild);
            }
            case 1: {
                return Similarity.lin(graph, bPath[lcaIndexes[0]][lcaIndexes[1]], obj1, obj2, rootChild);
            }
            case 2: {
                return (float)(-Math.log((float)(GraphPath.getNodeAllChildren(graph, bPath[lcaIndexes[0]][lcaIndexes[1]]).size() + 1) / rootChild));
            }
            case 3: {
                return Similarity.zzl(aPath, bPath, lcaIndexes[0], lcaIndexes[1]);
            }
            case 4: {
                return Similarity.oldZZL(aPath, bPath);
            }
        }
        return 0.0f;
    }

    private static float oldZZL(Object[][] aPath, Object[][] bPath) {
        Vector<Integer> aVector = new Vector<Integer>();
        int max = 0;
        int i = 0;
        while (i < aPath.length) {
            if (max < aPath[i].length) {
                aVector.clear();
                aVector.add(new Integer(i));
                max = aPath[i].length;
            } else if (max == aPath[i].length) {
                aVector.add(new Integer(i));
            }
            ++i;
        }
        Vector<Integer> bVector = new Vector<Integer>();
        max = 0;
        int i2 = 0;
        while (i2 < bPath.length) {
            if (max < bPath[i2].length) {
                bVector.clear();
                bVector.add(new Integer(i2));
                max = bPath[i2].length;
            } else if (max == bPath[i2].length) {
                bVector.add(new Integer(i2));
            }
            ++i2;
        }
        max = 0;
        int i3 = 0;
        while (i3 < aVector.size()) {
            int M = (Integer)aVector.get(i3);
            int j = 0;
            while (j < bVector.size()) {
                int N = (Integer)bVector.get(j);
                int commonNum = 0;
                int m = aPath[M].length - 1;
                int n = bPath[N].length - 1;
                while (m > -1 && n > -1) {
                    if (!aPath[M][m].equals(bPath[N][n])) break;
                    ++commonNum;
                    --m;
                    --n;
                }
                max = max < commonNum ? commonNum : max;
                ++j;
            }
            ++i3;
        }
        float d1 = (float)(0.5 / Math.pow(2.0, aPath[(Integer)aVector.get(0)].length - 1));
        float d2 = (float)(0.5 / Math.pow(2.0, bPath[(Integer)bVector.get(0)].length - 1));
        float d0 = (float)(0.5 / Math.pow(2.0, max - 1));
        return 2.0f * d0 - d1 - d2;
    }

    private static float zzl(Object[][] aPath, Object[][] bPath, int dim1, int dim2) {
        int size = bPath[dim1].length - dim2;
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        int i = 0;
        while (i < aPath.length) {
            int swap = aPath[i].length - size;
            if (swap > -1 && aPath[i][swap].equals(bPath[dim1][dim2])) {
                map.put(new Integer(i), new Integer(swap));
            }
            ++i;
        }
        Object[] keys = map.keySet().toArray();
        int[] indexes = new int[keys.length];
        int i2 = 0;
        while (i2 < keys.length) {
            indexes[i2] = (Integer)keys[i2];
            boolean hit = true;
            int m = (Integer)map.get(keys[i2]);
            int n = dim2;
            while (m < aPath[indexes[i2]].length && n < bPath[dim1].length) {
                if (!aPath[indexes[i2]][m].equals(bPath[dim1][n])) {
                    hit = false;
                    break;
                }
                ++m;
                ++n;
            }
            if (!hit) {
                indexes[i2] = -1;
            }
            ++i2;
        }
        int index = -1;
        int maxPathNumber = 0;
        int i3 = 0;
        while (i3 < indexes.length) {
            if (indexes[i3] > -1 && maxPathNumber < aPath[indexes[i3]].length) {
                maxPathNumber = aPath[indexes[i3]].length;
                index = indexes[i3];
            }
            ++i3;
        }
        if (index < 0) {
            System.out.println("Error!");
            return 0.0f;
        }
        float d1 = (float)(0.5 / Math.pow(2.0, aPath[index].length - 1));
        float d2 = (float)(0.5 / Math.pow(2.0, bPath[dim1].length - 1));
        float d0 = (float)(0.5 / Math.pow(2.0, size - 1));
        return 2.0f * d0 - d1 - d2;
    }

    private static float lin(SimpleDirectedGraph graph, Object latestCommonAncestor, Object obj1, Object obj2, float rootChildrenNum) {
        float d0 = (float)Math.log((float)(GraphPath.getNodeAllChildren(graph, latestCommonAncestor).size() + 1) / rootChildrenNum);
        float d1 = (float)Math.log((float)(GraphPath.getNodeAllChildren(graph, obj1).size() + 1) / rootChildrenNum);
        float d2 = (float)Math.log((float)(GraphPath.getNodeAllChildren(graph, obj2).size() + 1) / rootChildrenNum);
        return 2.0f * d0 / (d1 + d2);
    }

    private static float cao(Object[][] aPath, Object[][] bPath, SimpleDirectedGraph graph, Object obj1, Object obj2, float rootChildrenNum) {
        HashSet[] sets = new HashSet[]{new HashSet(), new HashSet()};
        HashSet<Object> swapSet = new HashSet<Object>();
        int i = 0;
        while (i < aPath.length) {
            int j = 0;
            while (j < aPath[i].length) {
                sets[0].add(aPath[i][j]);
                ++j;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < bPath.length) {
            int j = 0;
            while (j < bPath[i2].length) {
                sets[1].add(bPath[i2][j]);
                ++j;
            }
            ++i2;
        }
        Object[] values = sets[0].toArray();
        int i3 = 0;
        while (i3 < values.length) {
            if (sets[1].contains(values[i3])) {
                swapSet.add(values[i3]);
            }
            ++i3;
        }
        sets[0].addAll(sets[1]);
        sets[0].removeAll(swapSet);
        sets[1] = swapSet;
        float[] informs = new float[]{0.0f, 0.0f};
        int i4 = 0;
        while (i4 < sets.length) {
            values = sets[i4].toArray();
            int j = 0;
            while (j < values.length) {
                float swap = (float)(GraphPath.getNodeAllChildren(graph, values[j]).size() + 1) / rootChildrenNum;
                int n = i4;
                informs[n] = (float)((double)informs[n] + -Math.log(swap));
                ++j;
            }
            ++i4;
        }
        return informs[1] / (informs[0] + informs[1]);
    }

    private static boolean sameRoot(Object[][] aPath, Object[][] bPath) {
        return aPath[0][aPath[0].length - 1].equals(bPath[0][bPath[0].length - 1]);
    }

    private static int[] findLatestCommonAncestor(Object[][] aPath, Object[][] bPath, SimpleDirectedGraph graph) {
        if (!Similarity.sameRoot(aPath, bPath)) {
            return null;
        }
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        HashSet<Object> set = new HashSet<Object>();
        int i = 0;
        while (i < aPath.length) {
            int j = 0;
            while (j < aPath[i].length) {
                set.add(aPath[i][j]);
                ++j;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < bPath.length) {
            int j = bPath[i2].length - 1;
            while (j > -1) {
                if (set.contains(bPath[i2][j])) {
                    map.put(new Integer(i2), new Integer(j));
                }
                --j;
            }
            ++i2;
        }
        Object[] values = map.keySet().toArray();
        int max = 0;
        Vector<Object> vector = new Vector<Object>();
        int i3 = 0;
        while (i3 < values.length) {
            int swap = bPath[(Integer)values[i3]].length - (Integer)map.get(values[i3]);
            if (max < swap) {
                vector.clear();
                vector.add(values[i3]);
                max = swap;
            } else if (max == swap) {
                vector.add(values[i3]);
            }
            ++i3;
        }
        int[] array = new int[vector.size() * 2];
        values = vector.toArray();
        int i4 = 0;
        while (i4 < array.length) {
            array[i4] = (Integer)values[i4 / 2];
            array[i4 + 1] = (Integer)map.get(values[i4 / 2]);
            i4 += 2;
        }
        return Similarity.getMaxInformationIndexes(bPath, array, graph);
    }

    private static int[] getMaxInformationIndexes(Object[][] path, int[] indexes, SimpleDirectedGraph graph) {
        float max = 0.0f;
        int[] dim = new int[]{-1, -1};
        int i = 0;
        while (i < indexes.length) {
            int swap = GraphPath.getNodeAllChildren(graph, path[indexes[i]][indexes[i + 1]]).size() + 1;
            if (max < (float)swap) {
                dim[0] = indexes[i];
                dim[1] = indexes[i + 1];
                max = swap;
            } else if (max == (float)swap && path[dim[0]].length < path[indexes[i]].length) {
                dim[0] = indexes[i];
                dim[1] = indexes[i + 1];
            }
            i += 2;
        }
        return dim;
    }
}

