/*
 * Decompiled with CFR 0.152.
 */
package edu.hust.go.model;

import edu.hust.go.model.GoParser;
import java.io.IOException;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

public abstract class XmlGoParser
extends GoParser
implements ContentHandler,
DTDHandler,
ErrorHandler,
DeclHandler,
LexicalHandler {
    XMLReader parser;
    Document curDocument;
    Element curElement;
    String targetElementName;

    public String getTargetElementName() {
        return this.targetElementName;
    }

    public void setTargetElementName(String _targetElementName) {
        this.targetElementName = _targetElementName;
    }

    public XmlGoParser(String _target) {
        super(_target, 4, 10000);
    }

    public XmlGoParser(String _target, int _maxThreadNumber) {
        super(_target, _maxThreadNumber, 10000);
    }

    public XmlGoParser(String _target, int _maxThreadNumber, int _maxPoolSize) {
        super(_target, _maxThreadNumber, _maxPoolSize);
    }

    void init() {
        try {
            this.parser.setFeature("http://xml.org/sax/features/namespaces", true);
            this.parser.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
            this.parser.setFeature("http://xml.org/sax/features/validation", false);
            this.parser.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            this.parser.setFeature("http://apache.org/xml/features/validation/schema", false);
            this.parser.setFeature("http://apache.org/xml/features/validation/schema-full-checking", false);
            this.parser.setFeature("http://apache.org/xml/features/validation/dynamic", false);
        }
        catch (SAXException e) {
            // empty catch block
        }
        this.parser.setDTDHandler(this);
        this.parser.setErrorHandler(this);
        this.parser.setContentHandler(this);
        try {
            this.parser.setProperty("http://xml.org/sax/properties/declaration-handler", this);
        }
        catch (SAXException e) {
            e.printStackTrace(System.err);
        }
        try {
            this.parser.setProperty("http://xml.org/sax/properties/lexical-handler", this);
        }
        catch (SAXException e) {
            e.printStackTrace(System.err);
        }
    }

    protected void parseTarget() {
        try {
            this.parser.parse(this.target);
        }
        catch (IOException e) {
            System.err.println("error: Parse error occurred - " + e.getMessage());
        }
        catch (SAXException e) {}
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void ignorableWhitespace(char[] ch, int offset, int length) throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void characters(char[] ch, int offset, int length) throws SAXException {
        if (this.getCurElement() != null) {
            StringWriter sw = new StringWriter();
            sw.write(ch, offset, length);
            String value = sw.toString();
            Text textNode = this.getCurElement().getOwnerDocument().createTextNode(value);
            this.getCurElement().appendChild(textNode);
        }
    }

    public void startElement(String uri, String localName, String qname, Attributes attributes) throws SAXException {
        if (qname.equals(this.targetElementName)) {
            this.createNewDocument(localName, qname, attributes);
        } else if (this.getCurElement() != null) {
            this.addElement(this.getCurElement(), localName, qname, attributes);
        }
    }

    public void endElement(String uri, String localName, String qname) throws SAXException {
        if (qname.equals(this.getTargetElementName())) {
            Document doc = this.getCurElement().getOwnerDocument();
            this.addDataToPool(doc);
            this.setCurElement(null);
        } else if (this.getCurElement() != null) {
            this.setCurElement((Element)this.getCurElement().getParentNode());
        }
    }

    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
    }

    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    public void startEntity(String name) throws SAXException {
    }

    public void startCDATA() throws SAXException {
    }

    public void endCDATA() throws SAXException {
    }

    public void comment(char[] ch, int offset, int length) throws SAXException {
    }

    public void endEntity(String name) throws SAXException {
    }

    public void endDTD() throws SAXException {
    }

    public void elementDecl(String name, String contentModel) throws SAXException {
    }

    public void attributeDecl(String elementName, String attributeName, String type, String valueDefault, String value) throws SAXException {
    }

    public void internalEntityDecl(String name, String text) throws SAXException {
    }

    public void externalEntityDecl(String name, String publicId, String systemId) throws SAXException {
    }

    public void warning(SAXParseException ex) throws SAXException {
        this.printError("Warning", ex);
    }

    public void error(SAXParseException ex) throws SAXException {
        this.printError("Error", ex);
    }

    public void fatalError(SAXParseException ex) throws SAXException {
        this.printError("Fatal Error", ex);
        throw ex;
    }

    protected void printError(String type, SAXParseException ex) {
        System.err.print("[");
        System.err.print(type);
        System.err.print("] ");
        String systemId = ex.getSystemId();
        if (systemId != null) {
            int index = systemId.lastIndexOf(47);
            if (index != -1) {
                systemId = systemId.substring(index + 1);
            }
            System.err.print(systemId);
        }
        System.err.print(':');
        System.err.print(ex.getLineNumber());
        System.err.print(':');
        System.err.print(ex.getColumnNumber());
        System.err.print(": ");
        System.err.print(ex.getMessage());
        System.err.println();
        System.err.flush();
    }

    private Element getCurElement() {
        return this.curElement;
    }

    private void setCurElement(Element curElement) {
        this.curElement = curElement;
    }

    private Element createNewDocument(String localName, String qname, Attributes attrs) {
        try {
            this.curDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (Exception e) {
            System.out.println(e);
        }
        Element root = this.curDocument.createElement(qname);
        int length = attrs.getLength();
        int i = 0;
        while (i < length) {
            root.setAttribute(attrs.getQName(i), attrs.getValue(i));
            ++i;
        }
        this.curDocument.appendChild(root);
        this.setCurElement(root);
        return root;
    }

    private void addElement(Element parent, String localName, String qname, Attributes attrs) {
        Element child = parent.getOwnerDocument().createElement(qname);
        int length = attrs.getLength();
        int i = 0;
        while (i < length) {
            String Qname = attrs.getQName(i);
            String value = attrs.getValue(i);
            child.setAttribute(Qname, value);
            ++i;
        }
        parent.appendChild(child);
        this.setCurElement(child);
    }
}

