/*
 * Decompiled with CFR 0.152.
 */
package example;

import edu.hust.go.model.GoException;
import edu.hust.go.model.GoGraphModel;
import edu.hust.go.term.GO_term;
import java.util.HashMap;

public class ParserExample {
    public static void main(String[] args) {
        if (args.length != 2) {
            ParserExample.printUsage();
        }
        String target = args[0];
        byte goDefType = ParserExample.getGoDefType(args[1].toUpperCase());
        long start = System.currentTimeMillis();
        HashMap termMap = null;
        try {
            termMap = GoGraphModel.loadGoDefinition(target, goDefType);
        }
        catch (GoException e) {
            System.out.println(e);
            ParserExample.printUsage();
        }
        long end = System.currentTimeMillis();
        Object[] keys = termMap.keySet().toArray();
        System.out.println(keys.length);
        GO_term term = (GO_term)termMap.get(keys[0]);
        System.out.println(keys[0]);
        System.out.println();
        System.out.println("It take " + (end - start) + " millseconds to parse the file");
        System.out.println("There are " + termMap.size() + " GO terms");
    }

    static void printUsage() {
        System.out.println("Usage: java filaName fileType");
        System.out.println("fileName: the location of the GO description file");
        System.out.println("fileType, should be OBO, OBO-XML, RDF-XML or OWL");
        System.exit(-1);
    }

    private static byte getGoDefType(String goDefType) {
        int defType = -1;
        if (goDefType.equals("OBO")) {
            defType = 0;
        } else if (goDefType.equals("OBO-XML")) {
            defType = 1;
        } else if (goDefType.equals("RDF-XML")) {
            defType = 2;
        } else if (goDefType.equals("OWL")) {
            defType = 3;
        }
        return (byte)defType;
    }
}

