/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.layout;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Point;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jgraph.layout.JGraphLayoutSettings;
import org.jgraph.layout.SugiyamaLayoutAlgorithm;

public class SugiyamaLayoutSettings
extends JPanel
implements JGraphLayoutSettings {
    protected SugiyamaLayoutAlgorithm layout;
    private JTextField verticalSpacingTextField = new JTextField();
    private JTextField horizontalSpacingTextField = new JTextField();
    private JCheckBox verticalDirectionCheckBox = new JCheckBox();
    private JCheckBox flushToOriginCheckBox = new JCheckBox();

    public SugiyamaLayoutSettings(SugiyamaLayoutAlgorithm sugiyamaLayoutAlgorithm) {
        this.layout = sugiyamaLayoutAlgorithm;
        JPanel jPanel = new JPanel(new GridLayout(4, 2, 5, 0));
        JLabel jLabel = new JLabel("Horizontal Spacing");
        jLabel.setToolTipText("Sets horizontal spacing of the layout grid");
        jLabel.setLabelFor(this.horizontalSpacingTextField);
        jLabel.setDisplayedMnemonic('h');
        jPanel.add(jLabel);
        jPanel.add(this.horizontalSpacingTextField);
        jLabel = new JLabel("Vertical Spacing");
        jLabel.setToolTipText("Sets vertical spacing of the layout grid");
        jLabel.setLabelFor(this.verticalSpacingTextField);
        jLabel.setDisplayedMnemonic('v');
        jPanel.add(jLabel);
        jPanel.add(this.verticalSpacingTextField);
        jLabel = new JLabel("Vertical Orientation");
        jLabel.setToolTipText("Check to set vertical (top-down) orientation of the layout. Uncheck for horizontal (left-right)");
        jLabel.setLabelFor(this.verticalDirectionCheckBox);
        jLabel.setDisplayedMnemonic('o');
        jPanel.add(jLabel);
        jPanel.add(this.verticalDirectionCheckBox);
        jLabel = new JLabel("Flush to Origin");
        jLabel.setToolTipText("Check to flush the graph to the canvas origin");
        jLabel.setLabelFor(this.flushToOriginCheckBox);
        jLabel.setDisplayedMnemonic('f');
        jPanel.add(jLabel);
        jPanel.add(this.flushToOriginCheckBox);
        this.add((Component)jPanel, "Center");
        this.revert();
    }

    public void revert() {
        this.horizontalSpacingTextField.setText(String.valueOf(this.layout.getSpacing().x));
        this.verticalSpacingTextField.setText(String.valueOf(this.layout.getSpacing().y));
        this.verticalDirectionCheckBox.setSelected(this.layout.isVertical());
        this.flushToOriginCheckBox.setSelected(this.layout.getFlushToOrigin());
    }

    public void apply() {
        this.check();
        this.layout.setSpacing(new Point(Integer.parseInt(this.getIndention()), Integer.parseInt(this.getVerticalSpacing())));
        this.layout.setVertical(this.getVerticalDirection());
        this.layout.setFlushToOrigin(this.getFlushToOrigin());
    }

    private void check() {
        try {
            Integer.parseInt(this.horizontalSpacingTextField.getText());
            Integer.parseInt(this.verticalSpacingTextField.getText());
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception.getMessage());
        }
    }

    public String getIndention() {
        return this.horizontalSpacingTextField.getText().trim();
    }

    public void setIndention(String string) {
        this.horizontalSpacingTextField.setText(string);
    }

    public String getVerticalSpacing() {
        return this.verticalSpacingTextField.getText().trim();
    }

    public void setVerticalSpacing(String string) {
        this.verticalSpacingTextField.setText(string);
    }

    public boolean getVerticalDirection() {
        return this.verticalDirectionCheckBox.isSelected();
    }

    public void setVerticalDirection(boolean bl) {
        this.verticalDirectionCheckBox.setSelected(bl);
    }

    public boolean getFlushToOrigin() {
        return this.flushToOriginCheckBox.isSelected();
    }

    public void setFlushToOrigin(boolean bl) {
        this.flushToOriginCheckBox.setSelected(bl);
    }
}

