/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.util;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import javax.swing.JTextArea;

public class JGraphConsole
extends JTextArea {
    public static int STREAM_OUT = 0;
    public static int STREAM_ERR = 1;
    protected PrintStream stream;

    private JGraphConsole(PrintStream printStream) {
        this.stream = printStream;
        JTextAreaOutputStream jTextAreaOutputStream = new JTextAreaOutputStream(this, printStream, true);
        if (printStream == System.out) {
            System.setOut(jTextAreaOutputStream);
        } else if (printStream == System.err) {
            System.setErr(jTextAreaOutputStream);
        }
    }

    public boolean isErrorConsole() {
        return this.stream == System.err;
    }

    public static JGraphConsole createOutConsole() {
        return new JGraphConsole(System.out);
    }

    public static JGraphConsole createErrConsole() {
        return new JGraphConsole(System.err);
    }

    class JTextAreaOutputStream
    extends PrintStream {
        private JTextArea target = null;
        private PrintStream orig = null;
        private boolean showOrig = false;

        public JTextAreaOutputStream(JTextArea jTextArea, PrintStream printStream, boolean bl) {
            super(new ByteArrayOutputStream());
            this.target = jTextArea;
            this.showOrig = bl;
            this.orig = printStream;
        }

        public void print(boolean bl) {
            if (this.showOrig) {
                this.orig.print(bl);
            }
            if (bl) {
                this.target.append("true");
            } else {
                this.target.append("false");
            }
            this.target.setCaretPosition(this.target.getText().length());
        }

        public void println(boolean bl) {
            if (this.showOrig) {
                this.orig.println(bl);
            }
            if (bl) {
                this.target.append("true\n");
            } else {
                this.target.append("false\n");
            }
            this.target.setCaretPosition(this.target.getText().length());
        }

        public void print(char c) {
            if (this.showOrig) {
                this.orig.print(c);
            }
            char[] cArray = new char[]{c};
            this.target.append(new String(cArray));
            this.target.setCaretPosition(this.target.getText().length());
        }

        public void println(char c) {
            if (this.showOrig) {
                this.orig.println(c);
            }
            char[] cArray = new char[]{c, '\n'};
            this.target.append(new String(cArray));
            this.target.setCaretPosition(this.target.getText().length());
        }

        public void print(char[] cArray) {
            if (this.showOrig) {
                this.orig.print(cArray);
            }
            this.target.append(new String(cArray));
            this.target.setCaretPosition(this.target.getText().length());
        }

        public void println(char[] cArray) {
            if (this.showOrig) {
                this.orig.println(cArray);
            }
            this.target.append(new String(cArray) + "\n");
            this.target.setCaretPosition(this.target.getText().length());
        }

        public void print(double d) {
            if (this.showOrig) {
                this.orig.print(d);
            }
            this.target.append(Double.toString(d));
            this.target.setCaretPosition(this.target.getText().length());
        }

        public void println(double d) {
            if (this.showOrig) {
                this.orig.println(d);
            }
            this.target.append(Double.toString(d) + "\n");
            this.target.setCaretPosition(this.target.getText().length());
        }

        public void print(float f) {
            if (this.showOrig) {
                this.orig.print(f);
            }
            this.target.append(Float.toString(f));
            this.target.setCaretPosition(this.target.getText().length());
        }

        public void println(float f) {
            if (this.showOrig) {
                this.orig.println(f);
            }
            this.target.append(Float.toString(f) + "\n");
            this.target.setCaretPosition(this.target.getText().length());
        }

        public void print(int n) {
            if (this.showOrig) {
                this.orig.print(n);
            }
            this.target.append(Integer.toString(n));
            this.target.setCaretPosition(this.target.getText().length());
        }

        public void println(int n) {
            if (this.showOrig) {
                this.orig.println(n);
            }
            this.target.append(Integer.toString(n) + "\n");
            this.target.setCaretPosition(this.target.getText().length());
        }

        public void print(long l) {
            if (this.showOrig) {
                this.orig.print(l);
            }
            this.target.append(Long.toString(l));
            this.target.setCaretPosition(this.target.getText().length());
        }

        public void println(long l) {
            if (this.showOrig) {
                this.orig.println(l);
            }
            this.target.append(Long.toString(l) + "\n");
            this.target.setCaretPosition(this.target.getText().length());
        }

        public void print(Object object) {
            if (this.showOrig) {
                this.orig.print(object);
            }
            this.target.append(object.toString());
            this.target.setCaretPosition(this.target.getText().length());
        }

        public void println(Object object) {
            if (this.showOrig) {
                this.orig.println(object);
            }
            this.target.append(object.toString() + "\n");
            this.target.setCaretPosition(this.target.getText().length());
        }

        public void print(String string) {
            if (this.showOrig) {
                this.orig.print(string);
            }
            this.target.append(string);
            this.target.setCaretPosition(this.target.getText().length());
        }

        public void println(String string) {
            if (this.showOrig) {
                this.orig.println(string);
            }
            this.target.append(string + "\n");
            this.target.setCaretPosition(this.target.getText().length());
        }

        public void println() {
            if (this.showOrig) {
                this.orig.println();
            }
            this.target.append(new String("\n"));
            this.target.setCaretPosition(this.target.getText().length());
        }
    }
}

