/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.util;

import java.text.DateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import org.jgraph.JGraph;
import org.jgraph.graph.GraphModel;
import org.jgraph.util.JGraphUtilities;

public class JGraphGraphvizEncoder {
    static transient Hashtable hash;

    public static String encode(JGraph jGraph, Object[] objectArray) {
        hash = new Hashtable();
        DateFormat dateFormat = DateFormat.getDateTimeInstance(1, 1);
        String string = dateFormat.format(new Date());
        StringBuffer stringBuffer = new StringBuffer("/* Graphviz file generated by JGraph - " + string + " */" + "\n\ndigraph G {");
        for (int i = 0; i < objectArray.length; ++i) {
            if (!JGraphUtilities.isVertex(jGraph, objectArray[i])) continue;
            hash.put(objectArray[i], new Integer(hash.size()));
        }
        Iterator iterator = hash.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            stringBuffer.append(JGraphGraphvizEncoder.encodeVertex(jGraph, hash.get(k), k));
        }
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            if (!jGraph.getModel().isEdge(objectArray[i])) continue;
            stringBuffer.append(JGraphGraphvizEncoder.encodeEdge(jGraph, new Integer(n++), objectArray[i]));
        }
        stringBuffer.append("\n}");
        return stringBuffer.toString();
    }

    private static String encodeVertex(JGraph jGraph, Object object, Object object2) {
        if (object == null) {
            return "";
        }
        String string = jGraph.convertValueToString(object2);
        if (string == null) {
            string = "";
        }
        return "\n\t" + object.toString() + " [label=\"" + string + "\", " + "shape=\"box\"];";
    }

    private static String encodeEdge(JGraph jGraph, Object object, Object object2) {
        GraphModel graphModel = jGraph.getModel();
        String string = null;
        Object object3 = graphModel.getSource(object2);
        if (object3 != null) {
            Object v;
            Object v2 = hash.get(graphModel.getParent(object3));
            if (v2 != null) {
                string = v2.toString();
            }
            String string2 = null;
            Object object4 = graphModel.getTarget(object2);
            if (object4 != null && (v = hash.get(graphModel.getParent(object4))) != null) {
                string2 = v.toString();
            }
            if (string != null && string2 != null) {
                return "\n\t" + string + " -> " + string2 + ";";
            }
        }
        return "";
    }
}

