/*
 * Decompiled with CFR 0.152.
 */
package example;

import edu.hust.go.gui.GraphCreator;
import edu.hust.go.gui.OpenPageDialog;
import edu.hust.go.model.GoException;
import edu.hust.go.model.GoGraphModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.UIManager;

public class GUIExample
extends JFrame
implements ActionListener {
    JPanel panel;
    JLabel statusBar = new JLabel();
    JButton oboButton = new JButton("Load GO Database");
    JButton queryButton = new JButton("Query");
    JTextField mIdTextField = new JTextField("15422 15423");
    private JFileChooser jfc;
    private OpenPageDialog pageDialog;
    HashMap goMap;
    JScrollPane viewPanel = new JScrollPane();
    JTextPane textPanel = new JTextPane();
    final String treeGraphView = "Tree Graph";
    final String treeView = "Tree";
    final String graphView = "Graph";
    String[] viewType = new String[]{"Tree Graph", "Tree", "Graph"};
    JComboBox viewTypeComboBox = new JComboBox<String>(this.viewType);
    final String[] chindLevel = new String[]{"-1", "0", "1", "2", "3", "4"};
    final String[] goDefinitionType = new String[]{"OBO", "OBO-XML", "RDF-XML", "OWL"};
    JComboBox childLevleComboBox = new JComboBox<String>(this.chindLevel);
    JComboBox goDefTypeComboBox = new JComboBox<String>(this.goDefinitionType);

    public GUIExample() {
        this.enableEvents(64L);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setVisible(true);
        this.setDefaultCloseOperation(3);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        new GUIExample();
    }

    private void jbInit() throws Exception {
        this.panel = (JPanel)this.getContentPane();
        this.panel.setLayout(new BorderLayout());
        this.setSize(new Dimension(600, 800));
        this.setTitle("Gene Ontology in Java");
        this.statusBar.setText("No GO definition file");
        this.panel.setMinimumSize(new Dimension(400, 300));
        JPanel loadDbPanel = new JPanel();
        loadDbPanel.setLayout(new FlowLayout(0));
        this.oboButton.addActionListener(this);
        this.oboButton.setActionCommand("OBO parser");
        loadDbPanel.add(this.oboButton);
        loadDbPanel.add(this.goDefTypeComboBox);
        JPanel radioPanel = new JPanel();
        radioPanel.setLayout(new FlowLayout(0));
        radioPanel.add(new JLabel("View Type"));
        radioPanel.add(this.viewTypeComboBox);
        radioPanel.add(new JLabel("Child Depth"));
        radioPanel.add(this.childLevleComboBox);
        JPanel mQueryPanel = new JPanel(new FlowLayout(0));
        this.mIdTextField.setPreferredSize(new Dimension(250, 22));
        JLabel mQueryLabel = new JLabel("Query GO id");
        this.queryButton.addActionListener(this);
        mQueryPanel.add(mQueryLabel);
        mQueryPanel.add(this.mIdTextField);
        mQueryPanel.add(this.queryButton);
        JPanel contextPanel = new JPanel(new GridLayout(0, 1));
        contextPanel.add(loadDbPanel);
        contextPanel.add(radioPanel);
        contextPanel.add(mQueryPanel);
        JScrollPane messagePanel = new JScrollPane(this.textPanel);
        JSplitPane jSplitPane1 = new JSplitPane(0, this.viewPanel, messagePanel);
        jSplitPane1.setDividerLocation(500);
        this.panel.add((Component)contextPanel, "North");
        this.panel.add((Component)jSplitPane1, "Center");
        this.panel.add((Component)this.statusBar, "South");
        this.jfc = new JFileChooser();
        this.pageDialog = new OpenPageDialog(new Frame(), true);
        this.pageDialog.setFileChooser(this.jfc);
    }

    void query(byte viewType) {
        if (this.goMap == null) {
            JOptionPane.showMessageDialog(this, "Please load GO definitione file first\n :)");
            return;
        }
        String[] ids = this.parpareMultipleGoId(this.mIdTextField.getText());
        if (ids == null) {
            String msg = "Invalid Query Items\nPlaese separate items by space or comma\n :)";
            JOptionPane.showMessageDialog(this, msg);
            return;
        }
        int childLevel = Integer.parseInt((String)this.childLevleComboBox.getSelectedItem());
        Object[] objs = GraphCreator.query(ids, this.goMap, viewType, childLevel);
        JComponent component = (JComponent)objs[0];
        String log = (String)objs[1];
        this.viewPanel.setViewportView(component);
        this.textPanel.setText(log);
    }

    String[] parpareMultipleGoId(String ids) {
        ArrayList<String> list = new ArrayList<String>();
        String[] idArray = ids.trim().split("[, ]");
        int i = 0;
        while (i < idArray.length) {
            if (idArray[i].indexOf(":") >= 0) {
                idArray[i] = idArray[i].substring(idArray[i].indexOf(":") + 1);
            } else if (idArray[i].indexOf("_") >= 0) {
                idArray[i] = idArray[i].substring(idArray[i].indexOf("_") + 1);
            }
            try {
                DecimalFormat df = new DecimalFormat("GO:0000000");
                idArray[i] = df.format(Integer.parseInt(idArray[i].trim()));
                if (!list.contains(idArray[i])) {
                    list.add(idArray[i]);
                }
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
            ++i;
        }
        if (list.size() == 0) {
            return null;
        }
        idArray = new String[list.size()];
        list.toArray(idArray);
        return idArray;
    }

    public void actionPerformed(ActionEvent e) {
        byte viewType = 0;
        String str = (String)this.viewTypeComboBox.getSelectedItem();
        if (str.equals("Tree Graph")) {
            viewType = 0;
        } else if (str.equals("Tree")) {
            viewType = 1;
        } else if (str.equals("Graph")) {
            viewType = 2;
        }
        if (e.getSource() == this.oboButton) {
            this.jfc.setDialogTitle("Load Go definition file with " + e.getActionCommand());
            int status = this.jfc.showOpenDialog(this);
            byte goDefType = this.getGoDefType();
            if (status == 0) {
                String filePath = this.jfc.getSelectedFile().getPath();
                if (goDefType == 0 || goDefType == 1 || goDefType == 2 || goDefType == 3) {
                    try {
                        this.goMap = GoGraphModel.loadGoDefinition(filePath, goDefType);
                        this.statusBar.setText("Current GO definition file: " + filePath);
                    }
                    catch (GoException excep) {
                        this.goMap = null;
                        System.out.println(excep);
                    }
                }
            }
        } else if (e.getSource() == this.queryButton) {
            this.query(viewType);
        }
    }

    private byte getGoDefType() {
        int defType = -1;
        String goDefType = (String)this.goDefTypeComboBox.getSelectedItem();
        if (goDefType.equals("OBO")) {
            defType = 0;
        } else if (goDefType.equals("OBO-XML")) {
            defType = 1;
        } else if (goDefType.equals("RDF-XML")) {
            defType = 2;
        } else if (goDefType.equals("OWL")) {
            defType = 3;
        }
        return (byte)defType;
    }
}

