/*
 * Decompiled with CFR 0.152.
 */
package org._3pq.jgrapht.edge;

import java.io.Serializable;
import org._3pq.jgrapht.Edge;
import org._3pq.jgrapht.EdgeFactory;
import org._3pq.jgrapht.edge.DirectedEdge;
import org._3pq.jgrapht.edge.DirectedWeightedEdge;
import org._3pq.jgrapht.edge.UndirectedEdge;
import org._3pq.jgrapht.edge.UndirectedWeightedEdge;

public final class EdgeFactories {
    private EdgeFactories() {
    }

    static abstract class AbstractEdgeFactory
    implements EdgeFactory,
    Serializable {
        AbstractEdgeFactory() {
        }

        public abstract Edge createEdge(Object var1, Object var2);
    }

    public static class UndirectedWeightedEdgeFactory
    extends AbstractEdgeFactory {
        public Edge createEdge(Object object, Object object2) {
            return new UndirectedWeightedEdge(object, object2);
        }
    }

    public static class UndirectedEdgeFactory
    extends AbstractEdgeFactory {
        public Edge createEdge(Object object, Object object2) {
            return new UndirectedEdge(object, object2);
        }
    }

    public static class DirectedWeightedEdgeFactory
    extends AbstractEdgeFactory {
        public Edge createEdge(Object object, Object object2) {
            return new DirectedWeightedEdge(object, object2);
        }
    }

    public static class DirectedEdgeFactory
    extends AbstractEdgeFactory {
        public Edge createEdge(Object object, Object object2) {
            return new DirectedEdge(object, object2);
        }
    }
}

