/*
 * Decompiled with CFR 0.152.
 */
package org._3pq.jgrapht.ext;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import org._3pq.jgrapht.Edge;
import org._3pq.jgrapht.Graph;

public class VisioExporter {
    private static final VertexNameProvider DEFAULT_VERTEX_NAME_PROVIDER = new VertexNameProvider(){

        public String getVertexName(Object object) {
            return object.toString();
        }
    };
    private VertexNameProvider m_vertexNameProvider;

    public VisioExporter(VertexNameProvider vertexNameProvider) {
        this.m_vertexNameProvider = vertexNameProvider;
    }

    public VisioExporter() {
        this(DEFAULT_VERTEX_NAME_PROVIDER);
    }

    public void export(OutputStream outputStream, Graph graph) {
        PrintStream printStream = new PrintStream(outputStream);
        Iterator iterator = graph.vertexSet().iterator();
        while (iterator.hasNext()) {
            this.exportVertex(printStream, iterator.next());
        }
        Iterator iterator2 = graph.edgeSet().iterator();
        while (iterator2.hasNext()) {
            this.exportEdge(printStream, (Edge)iterator2.next());
        }
        printStream.flush();
    }

    private void exportEdge(PrintStream printStream, Edge edge) {
        String string = this.m_vertexNameProvider.getVertexName(edge.getSource());
        String string2 = this.m_vertexNameProvider.getVertexName(edge.getTarget());
        printStream.print("Link,");
        printStream.print(string);
        printStream.print("-->");
        printStream.print(string2);
        printStream.print(",,,");
        printStream.print(string);
        printStream.print(",");
        printStream.print(string2);
        printStream.print("\n");
    }

    private void exportVertex(PrintStream printStream, Object object) {
        String string = this.m_vertexNameProvider.getVertexName(object);
        printStream.print("Shape,");
        printStream.print(string);
        printStream.print(",,");
        printStream.print(string);
        printStream.print("\n");
    }

    public static interface VertexNameProvider {
        public String getVertexName(Object var1);
    }
}

