/*
 * Decompiled with CFR 0.152.
 */
package org._3pq.jgrapht.traverse;

import java.util.ArrayList;
import java.util.List;
import org._3pq.jgrapht.event.ConnectedComponentTraversalEvent;
import org._3pq.jgrapht.event.EdgeTraversalEvent;
import org._3pq.jgrapht.event.TraversalListener;
import org._3pq.jgrapht.event.VertexTraversalEvent;
import org._3pq.jgrapht.traverse.GraphIterator;

public abstract class AbstractGraphIterator
implements GraphIterator {
    private List m_traversalListeners = new ArrayList();
    private boolean m_crossComponentTraversal = true;
    private boolean m_reuseEvents = false;

    public void setCrossComponentTraversal(boolean bl) {
        this.m_crossComponentTraversal = bl;
    }

    public boolean isCrossComponentTraversal() {
        return this.m_crossComponentTraversal;
    }

    public void setReuseEvents(boolean bl) {
        this.m_reuseEvents = bl;
    }

    public boolean isReuseEvents() {
        return this.m_reuseEvents;
    }

    public void addTraversalListener(TraversalListener traversalListener) {
        if (!this.m_traversalListeners.contains(traversalListener)) {
            this.m_traversalListeners.add(traversalListener);
        }
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void removeTraversalListener(TraversalListener traversalListener) {
        this.m_traversalListeners.remove(traversalListener);
    }

    protected void fireConnectedComponentFinished(ConnectedComponentTraversalEvent connectedComponentTraversalEvent) {
        int n = this.m_traversalListeners.size();
        int n2 = 0;
        while (n2 < n) {
            TraversalListener traversalListener = (TraversalListener)this.m_traversalListeners.get(n2);
            traversalListener.connectedComponentFinished(connectedComponentTraversalEvent);
            ++n2;
        }
    }

    protected void fireConnectedComponentStarted(ConnectedComponentTraversalEvent connectedComponentTraversalEvent) {
        int n = this.m_traversalListeners.size();
        int n2 = 0;
        while (n2 < n) {
            TraversalListener traversalListener = (TraversalListener)this.m_traversalListeners.get(n2);
            traversalListener.connectedComponentStarted(connectedComponentTraversalEvent);
            ++n2;
        }
    }

    protected void fireEdgeTraversed(EdgeTraversalEvent edgeTraversalEvent) {
        int n = this.m_traversalListeners.size();
        int n2 = 0;
        while (n2 < n) {
            TraversalListener traversalListener = (TraversalListener)this.m_traversalListeners.get(n2);
            traversalListener.edgeTraversed(edgeTraversalEvent);
            ++n2;
        }
    }

    protected void fireVertexTraversed(VertexTraversalEvent vertexTraversalEvent) {
        int n = this.m_traversalListeners.size();
        int n2 = 0;
        while (n2 < n) {
            TraversalListener traversalListener = (TraversalListener)this.m_traversalListeners.get(n2);
            traversalListener.vertexTraversed(vertexTraversalEvent);
            ++n2;
        }
    }

    public abstract Object next();

    public abstract boolean hasNext();
}

