/*
 * Decompiled with CFR 0.152.
 */
package org._3pq.jgrapht.traverse;

import org._3pq.jgrapht.Edge;
import org._3pq.jgrapht.Graph;
import org._3pq.jgrapht.traverse.CrossComponentIterator;
import org._3pq.jgrapht.util.FibonacciHeap;

public class ClosestFirstIterator
extends CrossComponentIterator {
    private FibonacciHeap m_heap = new FibonacciHeap();

    public ClosestFirstIterator(Graph graph) {
        this(graph, null);
    }

    public ClosestFirstIterator(Graph graph, Object object) {
        super(graph, object);
    }

    public Edge getSpanningTreeEdge(Object object) {
        QueueEntry queueEntry = (QueueEntry)this.getSeenData(object);
        if (queueEntry == null) {
            return null;
        }
        return queueEntry.m_spanningTreeEdge;
    }

    protected boolean isConnectedComponentExhausted() {
        return this.m_heap.size() == 0;
    }

    protected void encounterVertex(Object object, Edge edge) {
        QueueEntry queueEntry = this.createSeenData(object, edge);
        this.putSeenData(object, queueEntry);
        this.m_heap.insert(queueEntry, queueEntry.getShortestPathLength());
    }

    protected void encounterVertexAgain(Object object, Edge edge) {
        QueueEntry queueEntry = (QueueEntry)this.getSeenData(object);
        if (queueEntry.m_frozen) {
            return;
        }
        double d = this.calculatePathLength(object, edge);
        if (d < queueEntry.getShortestPathLength()) {
            queueEntry.m_spanningTreeEdge = edge;
            this.m_heap.decreaseKey(queueEntry, d);
        }
    }

    protected Object provideNextVertex() {
        QueueEntry queueEntry = (QueueEntry)this.m_heap.removeMin();
        queueEntry.m_frozen = true;
        return queueEntry.m_vertex;
    }

    private void assertNonNegativeEdge(Edge edge) {
        if (edge.getWeight() < 0.0) {
            throw new IllegalArgumentException("negative edge weights not allowed");
        }
    }

    private double calculatePathLength(Object object, Edge edge) {
        this.assertNonNegativeEdge(edge);
        Object object2 = edge.oppositeVertex(object);
        QueueEntry queueEntry = (QueueEntry)this.getSeenData(object2);
        return queueEntry.getShortestPathLength() + edge.getWeight();
    }

    private QueueEntry createSeenData(Object object, Edge edge) {
        double d = edge == null ? 0.0 : this.calculatePathLength(object, edge);
        QueueEntry queueEntry = new QueueEntry(d);
        queueEntry.m_vertex = object;
        queueEntry.m_spanningTreeEdge = edge;
        return queueEntry;
    }

    private static class QueueEntry
    extends FibonacciHeap.Node {
        Edge m_spanningTreeEdge;
        Object m_vertex;
        boolean m_frozen;

        QueueEntry(double d) {
            super(d);
        }

        double getShortestPathLength() {
            return this.getKey();
        }
    }
}

