package edu.hust.go.model;

/**
 * <p>Title: GO4J</p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2005</p>
 * <p>Company: </p>
 * @author GQ Zhang
 * @version 1.0
 */

import java.util.HashMap;
import java.util.Vector;
import org.w3c.dom.Document;

import edu.hust.go.term.*;


public abstract class GoParser {
    public static final byte OBO = 0;
    public static final byte OBOXML = 1;
    public static final byte RDFXML = 2;
    public static final byte OWL = 3;

    static final int defaultThreadNumber = 4;
    static final int defaultPoolSize = 10000;

    String target;
    int threadNumber;
    int poolSize;

    HashMap termMap = new HashMap();
    Vector dataPool = new Vector();
    HashMap threadPool = new HashMap();
    boolean m_ParserActive = true;

    public GoParser(String _target) {
        this(_target, GoParser.defaultThreadNumber, GoParser.defaultPoolSize);
    }

    public GoParser(String _target, int _maxThreadNumber) {
        this(_target, _maxThreadNumber, GoParser.defaultPoolSize);
    }

    /**
     * @param _target GO definition file
     * @param _termType SIMPLE_TERM or COMPLETE_TERM
     * @param _maxThreadNumber thread number
     * @param _maxPoolSize GO term parse speed may slower than read thread, if
     *  the number of unparsed terms greater than maxPoolSize, new term has to
     *  wait until old terms have been parsed.
     */
    public GoParser(String _target, int _maxThreadNumber, int _maxPoolSize) {
        target = _target;
        threadNumber = _maxThreadNumber;
        poolSize = _maxPoolSize;
    }

    /** get the whole GO id-terms in GO definition.
     * @return the key is GO ids, and the value is GO terms.
     * <br/>If the termType is SIMPLE_TERM, the value is DefaultGO_term.
     * <br/>If the termType is COMPLETE_TERM and the parse is OBOGoParser, the value is OBOGO_term.
     * <br/>If the termType is COMPLETE_TERM and the parse is SaxGoParser, the value is XMLGO_term.
     */
    public HashMap getTermMap() {
        return termMap;
    }

    public abstract GO_term getGoTermById(String id);

    protected void parse(byte goDefType) {
        setParserActive();
        for (int i = 0; i < threadNumber; i++) {
            GoAdaptor adaptor = new GoAdaptor(this, String.valueOf(i), goDefType);
            adaptor.start();
            threadPool.put(String.valueOf(i), adaptor);
        }
        parseTarget();
        setParsingComplete();
        while (threadActive()) {
            try {
                wait();
            }
            catch (Exception e) {}
        }
    }

    protected abstract void parseTarget();

    protected synchronized boolean queueProcessed() {
        return (!parsingInProgress()) && (dataPool.size() == 0);
    }

    protected synchronized boolean parsingInProgress() {
        return m_ParserActive;
    }

    protected synchronized void setParserActive() {
        m_ParserActive = true;
    }

    protected synchronized void setParsingComplete() {
        m_ParserActive = false;
    }

    protected synchronized void addDataToPool(Object data) {
        dataPool.add(data);
        if (dataPool.size() == poolSize) {
            try {
                wait();
            }
            catch (InterruptedException e) {
                System.out.println(e);
            }
        }
    }

    protected synchronized Object getDataFromPool() {
        Object data = null;
        while (parsingInProgress() && (dataPool.size() == 0)) {
            try {
                wait(100);
            }
            catch (InterruptedException ie) {
            }
        }
        if (!parsingInProgress() && (dataPool.size() == 0)) {
            return null;
        }
        data = dataPool.remove(0);
        notify();
        return data;
    }

    protected synchronized void addTermToMap(Object data, byte defType) {
        GO_term term = null;
        try {
            switch (defType) {
                case GoParser.OBO:
                    term = new OBOGO_term( (HashMap) data);
                    break;
                case GoParser.OBOXML:
                    term = new OboXmlGo_term( (Document) data);
                    break;
                case GoParser.RDFXML:
                    term = new RdfXmlGo_term( (Document) data);
                    break;
                case GoParser.OWL:
                    term = new OwlGo_term( (Document) data);
                    break;
                default:
                    term=null;
            }
        }
        catch (Exception e) {}
        if (term != null) {
            termMap.put(term.getId(), term);
        }
    }

    protected synchronized void removeThread(String threadName) {
        threadPool.remove(threadName);
    }

    protected synchronized boolean threadActive() {
        return threadPool.size() > 0;
    }
}

class GoAdaptor
    extends Thread {
    GoParser parser;
    HashMap map = new HashMap();
    String threadName;
    byte goDefType;

    public GoAdaptor(GoParser _parser, String _threadName, byte _goDefType) {
        parser = _parser;
        threadName = _threadName;
        goDefType = _goDefType;
    }

    public void run() {
        while (!parser.queueProcessed()) {
            Object data = parser.getDataFromPool();
            if (data != null) {
                parser.addTermToMap(data, goDefType);
            }
        }
        parser.removeThread(threadName);
    }
}
