package edu.hust.go.model;

/**
 * <p>Title: GO4J</p>
 * <p>Description: Go api in Java</p>
 * <p>Copyright: Copyright (c) 2005</p>
 * <p>Company: Life Science and Technology, HUST, China</p>
 * @author GQ Zhang
 * @version 1.0
 */
import org.xml.sax.helpers.XMLReaderFactory;
import edu.hust.go.term.GO_term;
import edu.hust.go.term.RdfXmlGo_term;

public class RdfXmlGoParser
    extends XmlGoParser {
    public RdfXmlGoParser(String _target) {
        this(_target, GoParser.defaultThreadNumber, GoParser.defaultPoolSize);
    }

    public RdfXmlGoParser(String _target, int _maxThreadNumber) {
        this(_target, _maxThreadNumber, GoParser.defaultPoolSize);
    }

    public RdfXmlGoParser(String _target, int _maxThreadNumber, int _maxPoolSize) {
        super(_target, _maxThreadNumber, _maxPoolSize);
        setTargetElementName("go:term");
        try {
            parser = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            init();
        }
        catch (Exception e) {
            System.err.println("error: Unable to instantiate parser (org.apache.xerces.parsers.SAXParser)");
        }
        parse(GoParser.RDFXML);
    }

    public GO_term getGoTermById(String id){
        return (RdfXmlGo_term)termMap.get(id);
    }

}