package edu.hust.go.term;

/**
 * <p>Title: GO4J</p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2005</p>
 * <p>Company: </p>
 * @author GQ Zhang
 * @version 1.0
 */

import java.util.Vector;
import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Element;
import javax.xml.transform.TransformerException;
import org.apache.xpath.CachedXPathAPI;

import edu.hust.go.model.GoParser;

public abstract class DefaultGO_term
    implements GO_term {
    String id;
    String name;
    String def;
    Vector is_a=new Vector();
    Vector part_of=new Vector();

    /*protected Vector synonym;
    protected boolean obsolete = false;
    protected byte namespace = -1;

    public static final byte biological_process = 1;
    public static final byte molecular_function = 2;
    public static final byte cellular_component = 3;*/



    /*public DefaultGO_term(Object obj, byte defType) {
        switch (defType) {
            case (GoParser.OBO):
                initOBO( (HashMap) obj);
                break;
            case GoParser.OBOXML:
                initOboXml( (Document) obj);
                break;
            case (GoParser.RDFXML):
                initRdfXml( (Document) obj);
                break;
            case (GoParser.OWL):
                initOwl( (Document) obj);
                break;
            default:
        }
    }

    private void initOboXml(Document doc) {
        CachedXPathAPI xpath = new CachedXPathAPI();
        try {
            id = xpath.eval(doc, "/term/id/text()").str();
            name = xpath.eval(doc, "/term/name/text()").str();
            String nameSpace = xpath.eval(doc, "/term/namespace/text()").str();

            synonym = setSynonym(doc, xpath);
            def = xpath.eval(doc, "/term/definition/text()").str();
            part_of = setPart_of(doc, xpath);
            is_a = setIs_a(doc, xpath);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    private void initRdfXml(Document doc) {
        CachedXPathAPI xpath = new CachedXPathAPI();
        try {
            id = xpath.eval(doc, "/term/accession/text()").str();
            name = xpath.eval(doc, "/term/name/text()").str();
            synonym = setSynonym(doc, xpath);
            def = xpath.eval(doc, "/term/definition/text()").str();
            part_of = setPart_of(doc, xpath);
            is_a = setIs_a(doc, xpath);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    private void initOwl(Document doc) {

    }

    private void initOBO(HashMap map) {
        id = (String) map.get("id");
        name = (String) map.get("name");
        def = (map.get("def") == null) ? null : ( (String) map.get("def"));
        synonym = (map.get("synonym") == null) ? null : ( (Vector) map.get("synonym"));
        obsolete = (map.get("is_obsolete") != null) && ( ( (String) map.get("is_obsolete")).equals("true"));
        is_a = (map.get("is_a") == null) ? null : ( (Vector) map.get("is_a"));
        part_of = (map.get("part_of") == null) ? null : ( (Vector) map.get("part_of"));
        String tempStr = (String) map.get("namespace");
        if (tempStr.equals("biological_process")) {
            namespace = biological_process;
        }
        else if (tempStr.equals("molecular_function")) {
            namespace = molecular_function;
        }
        else if (tempStr.equals("cellular_component")) {
            namespace = cellular_component;
        }
        refine();
    }

    private void refine() {
        for (int i = 0; is_a != null && i < is_a.size(); i++) {
            String str = (String) is_a.get(i);
            int flag = str.indexOf("!");
            if (flag > 0) {
                str = str.substring(0, flag).trim();
                is_a.set(i, str);
            }
        }
        for (int i = 0; part_of != null && i < part_of.size(); i++) {
            String str = (String) part_of.get(i);
            int flag = str.indexOf("!");
            if (flag > 0) {
                str = str.substring(0, flag).trim();
                part_of.set(i, str);
            }
        }
    }

    public Vector setSynonym(Node doc, CachedXPathAPI xpath) throws TransformerException {
        NodeList synonymList = xpath.selectNodeList(doc, "/term/synonym");
        Vector _synonym = new Vector();
        for (int i = 0; i < synonymList.getLength(); i++) {
            _synonym.add(xpath.eval(synonymList.item(i), "./text()").str());
        }
        return _synonym;
    }

    public Vector setIs_a(Node doc, CachedXPathAPI xpath) throws TransformerException {
        NodeList is_aList = xpath.selectNodeList(doc, "/term/is_a");
        Vector _is_a = new Vector();
        for (int i = 0; i < is_aList.getLength(); i++) {
            String resource = ( (Element) is_aList.item(i)).getAttribute("rdf:resource").trim();
            resource = resource.substring(resource.indexOf("#") + 1);
            if (resource.startsWith("GO:")) {
                _is_a.add(resource);
            }
            else if (resource.startsWith("obsolete")) {
                obsolete = true;
            }
        }
        return _is_a;
    }

    public Vector setPart_of(Node doc, CachedXPathAPI xpath) throws TransformerException {
        NodeList part_ofList = xpath.selectNodeList(doc, "/term/part_of");
        Vector _part_of = new Vector();
        for (int i = 0; i < part_ofList.getLength(); i++) {
            String resource = ( (Element) part_ofList.item(i)).getAttribute("rdf:resource");
            resource = resource.substring(resource.indexOf("#") + 1);
            _part_of.add(resource.substring(resource.indexOf("#") + 1));
            if (!resource.startsWith("GO:")) {
                System.out.println(resource);
                _part_of.add(resource);
            }

        }
        return _part_of;
    }

    public Vector setDbxref(Node doc, CachedXPathAPI xpath) throws TransformerException {
        NodeList dbxrefList = xpath.selectNodeList(doc, "/term/dbxref");
        Vector _dbxref = new Vector();
        for (int i = 0; i < dbxrefList.getLength(); i++) {
            String database_symbol = xpath.eval(dbxrefList.item(i), "./database_symbol/text()").str();
            String reference = xpath.eval(dbxrefList.item(i), "./reference/text()").str();
            String type = ( (Element) dbxrefList.item(i)).getAttribute("type");
            _dbxref.add(new GO_dbxref(database_symbol, new GO_reference(reference, type)));
        }
        return _dbxref;
    }

    public Vector getSynonym() {
        return synonym;
    }

    public boolean isObsolete() {
        return obsolete;
    }*/

    public String getDef() {
        return def;
    }

    public String getId() {
        return id;
    }

    public Vector getIs_a() {
        return is_a;
    }

    public String getName() {
        return name;
    }

    public Vector getPart_of() {
        return part_of;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(getId()).append(", ").append(getName());
        return buf.toString();
    }
}
