package edu.hust.go.term;

/**
 * <p>Title: GO4J</p>
 * <p>Description: Go api in Java</p>
 * <p>Copyright: Copyright (c) 2005</p>
 * <p>Company: Life Science and Technology, HUST, China</p>
 * @author GQ Zhang
 * @version 1.0
 */
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import javax.xml.transform.TransformerException;
import org.apache.xpath.CachedXPathAPI;

public class OwlGo_term
    extends DefaultGO_term {
    public OwlGo_term(Document doc) throws TransformerException {
        CachedXPathAPI xpath = new CachedXPathAPI();
        id = transform(xpath.eval(doc, "/Class/@ID").str());
        name = xpath.eval(doc, "/Class/label").str();
        def = xpath.eval(doc, "/Class/comment").str();
        is_a=setIs_a(doc, xpath);
        part_of = setPartOf(doc, xpath);
    }

    String transform(String owlGoid){
        return owlGoid.replaceFirst("_",":");
    }

    Vector setIs_a(Document doc, CachedXPathAPI xpath) throws TransformerException {
        Vector vector = new Vector();
        NodeList nodeList = xpath.selectNodeList(doc, "/Class/subClassOf");
        for (int i = 0; i < nodeList.getLength(); i++) {
            String str = xpath.eval(nodeList.item(i), "./@resource").str();
            if (str.startsWith("#GO_")) {
                vector.add(transform(str.substring(1)));
            }
        }
        return vector;
    }

    Vector setPartOf(Document doc, CachedXPathAPI xpath) throws TransformerException {
        Vector vector = new Vector();
        NodeList nodeList = xpath.selectNodeList(doc, "/Class/subClassOf/Restriction");
        for (int i = 0; i < nodeList.getLength(); i++) {
            String str = xpath.eval(nodeList.item(i), "onProperty/ObjectProperty/@about").str();
            if (str.equals("#part_of")) {
                str = xpath.eval(nodeList.item(i), "someValuesFrom/@resource").str();
                vector.add(transform(str.substring(1)));
            }
        }
        return vector;
    }
}