package example;
import java.awt.*;
import java.awt.geom.*;
import java.awt.event.*;
import javax.swing.*;
import java.text.DecimalFormat;
import java.util.*;
import edu.hust.go.gui.GraphCreator;

import edu.hust.go.gui.OpenPageDialog;
import edu.hust.go.model.*;

/**
 * <p>Title: GO4J</p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2005</p>
 * <p>Company: </p>
 * @author GQ Zhang
 * @version 1.0
 */

public class GUIExample
    extends JFrame
    implements ActionListener {
    JPanel panel;
    JLabel statusBar = new JLabel();
    JButton oboButton = new JButton("Load GO Database");
    JButton queryButton = new JButton("Query");
    JTextField mIdTextField = new JTextField("15422 15423");
    private JFileChooser jfc;
    private OpenPageDialog pageDialog;

    HashMap goMap;
    JScrollPane viewPanel = new JScrollPane();
    JTextPane textPanel = new JTextPane();

    final String treeGraphView = "Tree Graph";
    final String treeView = "Tree";
    final String graphView = "Graph";
    String[] viewType = {
        treeGraphView, treeView, graphView};
    JComboBox viewTypeComboBox = new JComboBox(viewType);
    final String[] chindLevel = {
        "-1", "0", "1", "2", "3", "4"};
    final String[] goDefinitionType = {
        "OBO", "OBO-XML", "RDF-XML", "OWL"};
    JComboBox childLevleComboBox = new JComboBox(chindLevel);
    JComboBox goDefTypeComboBox = new JComboBox(goDefinitionType);

    //Construct the application
    public GUIExample() {
        enableEvents(AWTEvent.WINDOW_EVENT_MASK);
        try {
            jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }

        setVisible(true);
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

    }

    //Main method
    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        new GUIExample();
    }

    private void jbInit() throws Exception {
        panel = (JPanel)this.getContentPane();
        panel.setLayout(new BorderLayout());
        this.setSize(new Dimension(600, 800));
        this.setTitle("Gene Ontology in Java");
        statusBar.setText("No GO definition file");
        panel.setMinimumSize(new Dimension(400, 300));

        JPanel loadDbPanel = new JPanel();
        loadDbPanel.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.LEFT));
        oboButton.addActionListener(this);
        oboButton.setActionCommand("OBO parser");
        loadDbPanel.add(oboButton);
        loadDbPanel.add(goDefTypeComboBox);

        JPanel radioPanel = new JPanel();
        radioPanel.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.LEFT));
        radioPanel.add(new JLabel("View Type"));
        radioPanel.add(viewTypeComboBox);
        radioPanel.add(new JLabel("Child Depth"));
        radioPanel.add(childLevleComboBox);

        JPanel mQueryPanel = new JPanel(new java.awt.FlowLayout(java.awt.FlowLayout.LEFT));
        mIdTextField.setPreferredSize(new Dimension(250, 22));
        JLabel mQueryLabel = new JLabel("Query GO id");
        queryButton.addActionListener(this);
        mQueryPanel.add(mQueryLabel);
        mQueryPanel.add(mIdTextField);
        mQueryPanel.add(queryButton);

        JPanel contextPanel = new JPanel(new GridLayout(0, 1));
        contextPanel.add(loadDbPanel);
        contextPanel.add(radioPanel);
        contextPanel.add(mQueryPanel);

        JScrollPane messagePanel = new JScrollPane(textPanel);
        JSplitPane jSplitPane1 = new JSplitPane(JSplitPane.VERTICAL_SPLIT, viewPanel, messagePanel);
        jSplitPane1.setDividerLocation(500);
        panel.add(contextPanel, BorderLayout.NORTH);
        panel.add(jSplitPane1, BorderLayout.CENTER);
        panel.add(statusBar, BorderLayout.SOUTH);

        jfc = new JFileChooser();
        pageDialog = new OpenPageDialog(new Frame(), true);
        pageDialog.setFileChooser(jfc);
    }

    void query(byte viewType) {
        if (goMap == null) {
            JOptionPane.showMessageDialog(this, "Please load GO definitione file first\n :)");
            return;
        }
        String[] ids = parpareMultipleGoId(mIdTextField.getText());
        if (ids == null) {
            String msg = "Invalid Query Items\nPlaese separate items by space or comma\n :)";
            JOptionPane.showMessageDialog(this, msg);
            return;
        }
        int childLevel = Integer.parseInt( (String) childLevleComboBox.getSelectedItem());
        Object[] objs = GraphCreator.query(ids, goMap, viewType, childLevel);
        JComponent component = (JComponent) objs[0];
        String log = (String) objs[1];
        viewPanel.setViewportView(component);
        textPanel.setText(log);
    }

    String[] parpareMultipleGoId(String ids) {
        ArrayList list = new ArrayList();
        String[] idArray = ids.trim().split("[, ]");
        for (int i = 0; i < idArray.length; i++) {
            if (idArray[i].indexOf(":") >= 0) {
                idArray[i] = idArray[i].substring(idArray[i].indexOf(":") + 1);
            }else if(idArray[i].indexOf("_")>=0){
                idArray[i] = idArray[i].substring(idArray[i].indexOf("_") + 1);
            }
            try {
                DecimalFormat df = new DecimalFormat("GO:0000000");
                idArray[i] = df.format(Integer.parseInt(idArray[i].trim()));
                if (!list.contains(idArray[i])) {
                    list.add(idArray[i]);
                }
            }
            catch (NumberFormatException ex) {}
        }
        if (list.size() == 0) {
            return null;
        }
        idArray = new String[list.size()];
        list.toArray(idArray);
        return idArray;
    }

    public void actionPerformed(ActionEvent e) {
        byte viewType = GraphCreator.JTREEGRAPHVIEW;
        String str = (String) viewTypeComboBox.getSelectedItem();
        if (str.equals(treeGraphView)) {
            viewType = GraphCreator.JTREEGRAPHVIEW;
        }
        else if (str.equals(treeView)) {
            viewType = GraphCreator.JTREEVIEW;
        }
        else if (str.equals(graphView)) {
            viewType = GraphCreator.JGRAPHVIEW;
        }

        if (e.getSource() == oboButton) {
            jfc.setDialogTitle("Load Go definition file with " + e.getActionCommand());
            int status = jfc.showOpenDialog(this);
            byte goDefType=getGoDefType();
            if (status == JFileChooser.APPROVE_OPTION) {
                String filePath = jfc.getSelectedFile().getPath();
                if(goDefType==GoParser.OBO || goDefType==GoParser.OBOXML || goDefType==GoParser.RDFXML || goDefType==GoParser.OWL){
                    try{
                        goMap = GoGraphModel.loadGoDefinition(filePath, goDefType);
                        statusBar.setText("Current GO definition file: " + filePath);
                    }catch(GoException excep){
                        goMap=null;
                        System.out.println(excep);
                    }
                }
            }
        }
        else if (e.getSource() == queryButton) {
            query(viewType);
        }
    }

    private byte getGoDefType() {
        byte defType = -1;
        String goDefType = (String) goDefTypeComboBox.getSelectedItem();
        if (goDefType.equals("OBO")) {
            defType = GoParser.OBO;
        }
        else if (goDefType.equals("OBO-XML")) {
            defType = GoParser.OBOXML;
        }
        else if (goDefType.equals("RDF-XML")) {
            defType = GoParser.RDFXML;
        }
        else if (goDefType.equals("OWL")) {
            defType = GoParser.OWL;
        }
        return defType;
    }
}