package example;
/**
 * <p>Title: GO4J</p>
 * <p>Description: Go api in Java</p>
 * <p>Copyright: Copyright (c) 2005</p>
 * <p>Company: Life Science and Technology, HUST, China</p>
 * @author GQ Zhang
 * @version 1.0
 */
import java.util.*;
import java.text.*;
import edu.hust.go.model.*;
import edu.hust.go.term.*;

public class GraphModelExample {
    public static void main(String[] args) {
        HashMap goMap = null;
        GO_term[] term = new GO_term[2];
        int type = -1;
        if (args.length < 3) {
            printUsage();
        }
        try {
            goMap = GoGraphModel.loadGoDefinition(args[0], GoParser.OBO);
            if (goMap == null) {
                printUsage();
            }
            for(int i=2;i<args.length && i<4;i++){
                term[i-2] = transForm(args[i], goMap);
            }
            GoGraphModel graphModel = new GoGraphModel(goMap);
            for (int i = 0; i < term.length; i++) {
                if (term[i] != null && graphModel.getObsoleteSet().contains(term[i])) {
                    System.out.println(term[i].getId() + " is obsolete");
                    System.exit( -1);
                }
            }
            if (args[1].equals("-s")) {
                getSimilarity(graphModel, term[0], term[1], Similarity.CAO);
            }
            else if (args[1].equals("-r")) {
                getPathway(graphModel, term[0]);
            }
            else if (args[1].equals("-p")) {
                getPathway(graphModel, term[0], term[1]);
            }
            else {
                printUsage();
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }

    }

    static void getPathway(GoGraphModel graphModel, GO_term term) {
        if (graphModel == null || term == null) {
            return;
        }
        Object[][] objs = graphModel.getPathsOfNode2Root(term);
        System.out.print("The pathways between " + term.getId() + " and the root is:");
        for (int i = 0; i < objs.length; i++) {
            System.out.print("\nPath "+(i+1)+":\t");
            for (int j = 0; j < objs[i].length; j++) {
                System.out.print( ( (GO_term) objs[i][j]).getId() + " ");
            }
        }
    }

    static void getPathway(GoGraphModel graphModel, GO_term term1, GO_term term2) {
        if (graphModel == null || term1 == null || term2 == null) {
            return;
        }
        HashMap map = graphModel.getPathsBetweenNodes(term1, term2);
        HashSet commonSet = (HashSet) map.keySet().toArray()[0];
        Object[] commomTerms = commonSet.toArray();
        System.out.println("The common ancestors between " + term1.getId() + " and " +
                           term2.getId() + " are:\n\t");
        for (int i = 0; i < commomTerms.length; i++) {
            System.out.print( ( ( (GO_term) commomTerms[i])).getId() + " ");
        }
        System.out.println("\nthe commonPathways are:");
        Object[][] values = (Object[][]) map.get(commonSet);
        for (int i = 0; i < values.length; i++) {
            System.out.print("\nPath "+(i+1)+":\t");
            for (int j = 0; j < values[i].length; j++) {
                System.out.print( ( (GO_term) values[i][j]).getId() + " ");
            }
        }
    }

    static void getSimilarity(GoGraphModel graphModel, GO_term term1, GO_term term2,byte methodType) {
        if (graphModel == null || term1 == null || term2 == null) {
            return;
        }
        float value = graphModel.evalSimilarity(term1, term2,methodType);
        System.out.println("The semantic similarity between ");
        System.out.print(term1.getId() + " " + term2.getId() + " is: "+value);
    }

    static void printUsage() {
        System.out.println("Usage: java filaName [-s id1 id2] [-r id1] [-p id1 id2]");
        System.out.println("\tfileName the location of GO definition in OBO.");
        System.out.println("\tid1 the first GO id.");
        System.out.println("\tid2 the second GO id, if -s or -p is chosen, id2 is necessary.");
        System.out.println("\t-s evaluate the similarity between id1 and id2");
        System.out.println("\t-r find the pathways between id1 and its root");
        System.out.println("\t-p find the pathways between id1 and id2");
        System.exit( -1);
    }

    /*static void evalSim(HashMap goMap) {
        String[] goids = {
            "GO:0015422", "GO:0015423", "83",
            "GO:0015279", "GO:0005245", "80",
            "GO:0016871", "GO:0009982", "34.5",
            "GO:0015576", "GO:0015170", "34.5",
            "GO:0004620", "GO:0004630", "84.5",
            "GO:0045517", "GO:0045518", "70",
            "GO:0004004", "GO:0015611", "29",
            "GO:0003693", "GO:0004525", "20",
            //"GO:0000034", "GO:0016816","39",
            "GO:0016618", "GO:0004450", "43.5",
            "GO:0045509", "GO:0001613", "30",
            "GO:0005117", "GO:0005037", "35",
            "GO:0004765", "GO:0008965", "40",
            "GO:0015595", "GO:0005046", "9",
            "GO:0004438", "GO:0019791", "34.5",
            "GO:0004631", "GO:0000033", "29",
            "GO:0015648", "GO:0015233", "33.5",
            "GO:0004791", "GO:0016452", "13.5",
            "GO:0008296", "GO:0004173", "13.5",
            "GO:0003763", "GO:0008830", "18",
            "GO:0018475", "GO:0046408", "23.5",
            "GO:0046565", "GO:0015075", "14.5",
            "GO:0008031", "GO:0046905", "0",
            "GO:0008142", "GO:0003909", "14.5",
            "GO:0019193", "GO:0017150", "9"
        };
        byte[] types = {
            Similarity.ZZL, Similarity.oldZZL, Similarity.RESNIK, Similarity.LIN, Similarity.CAO};
        GoGraphModel graph = null;
        try {
            graph = new GoGraphModel(goMap);

        }
        catch (InvalidGoDefinitionException e) {
            System.out.println(e);
            return;
        }

        for (int i = 0; i < goids.length; i += 3) {
            GO_term term1 = (GO_term) goMap.get(goids[i]);
            GO_term term2 = (GO_term) goMap.get(goids[i + 1]);
            for (int m = 0; m < types.length; m++) {
                float f = Similarity.evaluate(graph, term1, term2, types[m]);
                System.out.print(f + " ");
            }
            System.out.println(goids[i + 2] + "\n");
        }
    }*/

    static GO_term transForm(String rawId, HashMap goMap) {
        String id = rawId;
        GO_term term = null;
        if (id.indexOf(":") >= 0) {
            id = id.substring(id.indexOf(":") + 1);
        }
        try {
            DecimalFormat df = new DecimalFormat("GO:0000000");
            id = df.format(Integer.parseInt(id.trim()));
            term = (GO_term) goMap.get(id);
        }
        catch (Exception ex) {
            System.out.println("No such go id: " + rawId + "\nPlease input a new go id");
            System.exit( -1);
        }
        return term;
    }
}