package example;

/**
 * <p>Title: GO4J</p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2005</p>
 * <p>Company: </p>
 * @author GQ Zhang
 * @version 1.0
 */
import java.util.*;
import edu.hust.go.model.*;
import edu.hust.go.term.*;

public class ParserExample {
    public static void main(String[] args) {
        if (args.length != 2) {
            printUsage();
        }
        String target = args[0];
        byte goDefType = getGoDefType(args[1].toUpperCase());

        long start = System.currentTimeMillis();

        HashMap termMap = null;
        try {
            termMap = GoGraphModel.loadGoDefinition(target, goDefType);
        }
        catch (GoException e) {
            System.out.println(e);
            printUsage();
        }
        long end = System.currentTimeMillis();
        //GO_term term=(GO_term)termMap.get("GO-0015423");
        Object[] keys = termMap.keySet().toArray();
        System.out.println(keys.length);
        GO_term term = (GO_term) termMap.get(keys[0]);
        System.out.println(keys[0]);
        //System.out.println(term.getIs_a().get(0));
        System.out.println();
        System.out.println("It take " + (end - start) + " millseconds to parse the file");
        System.out.println("There are " + termMap.size() + " GO terms");
    }

    static void printUsage() {
        System.out.println("Usage: java filaName fileType");
        System.out.println("fileName: the location of the GO description file");
        System.out.println("fileType, should be OBO, OBO-XML, RDF-XML or OWL");
        System.exit( -1);
    }

    private static byte getGoDefType(String goDefType) {
        byte defType = -1;
        if (goDefType.equals("OBO")) {
            defType = GoParser.OBO;
        }
        else if (goDefType.equals("OBO-XML")) {
            defType = GoParser.OBOXML;
        }
        else if (goDefType.equals("RDF-XML")) {
            defType = GoParser.RDFXML;
        }
        else if (goDefType.equals("OWL")) {
            defType = GoParser.OWL;
        }
        return defType;
    }

}