#!/usr/bin/perl

use strict;
use Carp;
my $dbg = 0;
use Tk;

sub _log {
	return unless $dbg;
	open CHECK, ">>/tmp/simpleoutputtt.txt" or die "can't open output file";
	print CHECK @_;
	close CHECK;
}


begin();
MainLoop;

sub begin {
	my $mw = MainWindow->new;
	my $text1 = $mw->Scrolled("Text", -width => 50, -height => 20, -wrap => 'word', -background => 'white')->pack(-side => 'left');
	my $text2 = $mw->Scrolled("Text", -width => 50, -height => 20, -wrap => 'word', -background => 'pink')->pack(-side => 'right');
	$text1->bind("<Key-Return>" => sub {
		my $string = $text1->get('1.0', 'end');
		$string =~ s/^\s//;
		$string =~ s/^\n//;
		$string =~ s/\n\n//g;
		$string =~ s/\n$//g;
		my ($req, $dat) = (($string =~ /(\w+)\(((\<\w+\>)?([\w+|\d+]+)?(\<\/\w+\>)?)\)/) && ($1, $2));
		my $result = _askGenquire($req, $dat);
		$text2->delete('1.0', 'end');
		$text2->insert('end', "result\n\n$result");
				}
			);
}
	



sub _askGenquire {
	my ($request, $data) = @_;
	$| = 1;
	_log("$request $data\n");
	sendToGenquire("<REQUEST><$request>$data</$request></REQUEST>\n\n");
	my $response;
	my $partial;
	#sleep 1;
	for (;;){
		my $buf;
		my $len = sysread(STDIN, $buf, 1024);
		substr($buf,0,0)=$partial;  ## prepend from last sysread
		my @buf=split(/\r?\n/,$buf);   ## break into lines
		if ($buf=~/\n$/) { $partial=''; } else { $partial= pop(@buf); }
		_log("partial *". (length($partial)) . "*\n");
		foreach(@buf) { $response .= $_ }
		last if ($response =~ /<\/GQ_RESPONSE>/);
		last if ($len) < 1024;
		next;
	}
	#_log("RESPONSE WAS: $response\n");
	my $sendback = (($response =~ /<$request>(.*)<\/$request>/) && $1);
	_log("SENDBACK WAS: $sendback\n");
	return $sendback;

}

sub sendToGenquire {
	my ($return) = @_;
	my $len = length($return);
	my $offset = 0; my $tries = 0;
	while ($len){
		my $written = syswrite STDOUT, $return, $len, $offset; # may only write partial data...
		unless (defined $written){next}
		$offset += $written;
		$len -= $written;
	}
	return $return;
}	
